#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <dir.h>
#include <allegro.h>
/* help system by Doug Eleveld */

char *object_last_help = NULL;
char *object_help_text = NULL;
char *object_help_text_section[24];


int set_object_help_general()
{
   object_help_text = object_help_text_section[0];
   return D_O_K;
}


int set_object_help_using_mdk()
{
   object_help_text = object_help_text_section[1];
   return D_O_K;
}


int set_object_help_dialog()
{
   object_help_text = object_help_text_section[2];
   return D_O_K;
}


int set_object_help_clear()
{
   object_help_text = object_help_text_section[3];
   return D_O_K;
}


int set_object_help_box()
{
   object_help_text = object_help_text_section[4];
   return D_O_K;
}


int set_object_help_shadow()
{
   object_help_text = object_help_text_section[5];
   return D_O_K;
}


int set_object_help_bitmap()
{
   object_help_text = object_help_text_section[6];
   return D_O_K;
}


int set_object_help_text()
{
   object_help_text = object_help_text_section[7];
   return D_O_K;
}
int set_object_help_ctext()
{
   object_help_text = object_help_text_section[8];
   return D_O_K;
}
int set_object_help_button()
{
   object_help_text = object_help_text_section[9];
   return D_O_K;
}
int set_object_help_check()
{
   object_help_text = object_help_text_section[10];
   return D_O_K;
}
int set_object_help_radio()
{
   object_help_text = object_help_text_section[11];
   return D_O_K;
}
int set_object_help_icon()
{
   object_help_text = object_help_text_section[12];
   return D_O_K;
}

int set_object_help_keyboard()
{
   object_help_text = object_help_text_section[13];
   return D_O_K;
}
int set_object_help_edit()
{
   object_help_text = object_help_text_section[14];
   return D_O_K;
}
int set_object_help_list()
{
   object_help_text = object_help_text_section[15];
   return D_O_K;
}

int set_object_help_textbox()
{
   object_help_text = object_help_text_section[16];
   return D_O_K;
}
int set_object_help_slider()
{
   object_help_text = object_help_text_section[17];
   return D_O_K;
}

int set_object_help_menu()
{
   object_help_text = object_help_text_section[18];
   return D_O_K;
}
int set_object_help_dialog_manager()
{
   object_help_text = object_help_text_section[19];
   return D_O_K;
}

int set_object_help_mdks_color_dialog()
{
   object_help_text = object_help_text_section[20];
   return D_O_K;
}

int set_object_help_c_output_colors()
{
   object_help_text = object_help_text_section[21];
   return D_O_K;
}
int set_object_help_c_output_comments()
{
   object_help_text = object_help_text_section[22];
   return D_O_K;
}
int set_object_help_c_output_globals()
{
   object_help_text = object_help_text_section[23];
   return D_O_K;
}
int set_object_help_new_features()
{
   object_help_text = object_help_text_section[24];
   return D_O_K;
}

int do_object_help_exit(void)
{
   return D_CLOSE;
}


MENU mdk_help[] =
{
   { "&Using MDk - Basics",set_object_help_using_mdk    ,    NULL},
   { "MDK New Features",    set_object_help_new_features    ,    NULL},
   { "",              NULL,                                  NULL },
   { "MDK's &Color - Dialog",    set_object_help_mdks_color_dialog     ,    NULL},
   { "C Output: C&olors",    set_object_help_c_output_colors     ,    NULL},
   { "C Output: Co&mments",    set_object_help_c_output_comments    ,    NULL},
   { "C Output: &Globals",    set_object_help_c_output_globals    ,    NULL},
   { NULL,              NULL,                                NULL}
};



MENU object_help_choose_topic[] =
{
   { "&General: Allegro's Gui",       set_object_help_general,                 NULL },
   { "&Using MDK 3.0",          NULL,                 mdk_help },
   { "&Dialog proc",       set_object_help_dialog,                 NULL },
   { "&Clear procs",       set_object_help_clear,                 NULL },
   { "&Box procs",         set_object_help_box,                   NULL },
   { "&Shadows procs",     set_object_help_shadow,                NULL },
   { "&Text procs",        set_object_help_text  ,                NULL },
   { "CTe&xt procs",       set_object_help_ctext,                 NULL },
   { "B&utton procs",      set_object_help_button,                NULL },
   { "C&heck procs",       set_object_help_check,                 NULL },
   { "&Radio procs",       set_object_help_radio,                 NULL },
   { "&Icon procs",        set_object_help_icon,                  NULL },
   { "&Keyboard procs",    set_object_help_keyboard,              NULL },
   { "&Edit procs",        set_object_help_edit,                  NULL },
   { "&List procs",        set_object_help_list,                  NULL },
   { "TextB&ox procs",     set_object_help_textbox,               NULL },
   { "&Slider procs",      set_object_help_slider,                NULL },
   { "&Menu procs",        set_object_help_menu,                  NULL },
   { "Dialo&g Manger",     set_object_help_dialog_manager,                  NULL },
   { NULL,              NULL,                                  NULL }
};


MENU object_help_topic[] =
{
   { "&Topic",          NULL,                                  object_help_choose_topic },
   { "E&xit",           do_object_help_exit,                  NULL },
   { NULL,              NULL,                                  NULL }
};



int d_object_helptext_proc(int msg, DIALOG *d, int c)
{
   if (d->dp == NULL)
      d->dp = object_help_text;

   /* if the text needs changing changed, redraw */
   if ((msg == MSG_IDLE) && (object_help_text != object_last_help)) {
      d->dp = object_help_text;
      object_last_help = object_help_text;

      d->d2 = 0;

      show_mouse(NULL);
      d_textbox_proc(MSG_DRAW, d, c);
      show_mouse(screen);

      return D_O_K;
   }
   else 
      return d_textbox_proc(msg, d, c);
};



DIALOG object_help[] =
{
/* (dialog proc)      (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)  (d1)  (d2)  (dp) */
   { d_clear_proc,       0,    0,    1024,    800,    8,    8,    0,    0,       0,    0,    NULL },
   { d_text_proc,        0,    4,    0,    0,    255,  8,    0,    0,       0,    0,    "Help viewer by Doug Eleveld / Shawn Hargreaves" },
   { d_menu_proc,        0,    0,    0,    0,    255,  0,    0,    0,       0,    0,    object_help_topic },
   { d_object_helptext_proc,    0,    20,   0,    0,    255,  0,    0,    0,       0,    0,    NULL },
   { NULL,               0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
};



/* handle the help command */
int setup_helper()
{
   char buf[256];
   PACKFILE *f;
   char *last, *s; 
   int size, i, j;

   strcpy(buf, "argv_0");
   strcpy(get_filename(buf), "object.txt");

   size = file_size(buf);
   if (size <= 0) {
      alert("Error reading object.txt", NULL, NULL, "Oh dear", NULL, 13, 0);
      return D_REDRAW;
   }

   object_help_text = malloc(size+1); 

   f = pack_fopen(buf, F_READ);
   if (!f) {
      alert("Error reading object.txt", NULL, NULL, "Oh dear", NULL, 13, 0);
      return D_REDRAW;
   }

   pack_fread(object_help_text, size, f);
   pack_fclose(f);

   object_help_text[size] = 0;
   object_help_text_section[0] = object_help_text;

   last = object_help_text;

   while ((s = strstr(last, " \r\n")) != NULL) {
      last = s+3;
      if ((SCREEN_W >= 640) && (isspace(*last)))
	 continue;
      j = 0;
      while (isspace(last[j]))
	 j++;
      s++;
      memmove(s, s+2+j, size - ((long)s-(long)object_help_text) - 1 - j);
      size -= 2+j;
      last = s;
   }

   last = object_help_text;

   for (i=1; i<25; i++) {
      s = strstr(last , "\r\n\r\n====");

      if (s) {
	 object_help_text_section[i] = last = s+4;
	 s[3] = 0;
      }
      else
	 object_help_text_section[i] = NULL;
   }

   object_last_help = NULL;

   set_dialog_color(object_help, 100, 12);
   object_help[0].fg = palette_color[100];
   object_help[0].bg = palette_color[133];
   object_help[1].bg = palette_color[133];
   object_help[3].bg = palette_color[133];
   object_help[3].fg = palette_color[0];
   object_help[3].d1 = 0;
   object_help[3].d2 = 0;
   object_help[3].dp = object_help_text;

   if (SCREEN_W > 512)
      object_help[1].x = SCREEN_W - 420;
   else
      object_help[1].x = SCREEN_W;

   object_help[3].w = SCREEN_W;
   object_help[3].h = SCREEN_H - 20;
}
int do_help()
{
   popup_dialog(object_help,1);
}

