//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------
//
// Some of this code was lifted from Allegros' gui.c, actually a lot of it...
//
//----------------------------------------------------------------------------
#include "degui.h"

//----------------------------------------------------------------------------
// Scrollable object
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// A helper function for dealing with clicks on the scrollbar
void scrollable_object::handle_click (void)
   {
   int xx, yy;
   int height = (h()-4) / text_height(font);
   int hh = h()-4;

   while(mouse_b)
      {
      int i = (hh * height + listsize/2) / listsize;
      int len = (hh * offset + listsize/2) / listsize + 2;
      if ((mouse_y >= y()+len) && (mouse_y <= y()+len+i))
         {
         xx = mouse_y - len + 2;
         while (mouse_b)
            {
            yy = (listsize * (mouse_y - xx) + hh/2) / hh;
            if(yy > listsize-height) yy = listsize-height;

            if(yy < 0) yy = 0;

            if(yy != offset)
               {
               offset = yy;
               show_mouse(NULL);
               send_message(MSG_DRAW);
               show_mouse(screen);
               }
            }
         }
      else
         {
         if(mouse_y<=y()+len) yy = offset-height;
         else yy = offset+height;

         if(yy > listsize-height) yy = listsize-height;

         if(yy < 0) yy = 0;

         if(yy != offset)
            {
            offset= yy;
            show_mouse(NULL);
            send_message(MSG_DRAW);
            show_mouse(screen);
            }
         }
      }
   }
//----------------------------------------------------------------------------
// Helper function to help scroll a listbox
void scrollable_object::scroll (int &index)
   {
   int height = (h()-4) / text_height(font);

   if(listsize<=0)
      {
      index = offset = 0;
      return;
      }

   // Check selected item
   if(index < 0) index = 0;
   else if(index >= listsize) index = listsize -1;

   // Check scroll position
   while((offset>0)&&(offset+height>listsize)) offset--;

   if(offset>=index)
      {
      if (index <= 0) offset = 0;
      else offset = index - 1;
      }
   else
      {
      while ((offset + height - ((index == listsize-1) ? 1 : 2)) < index) offset++;
      }
   }
//----------------------------------------------------------------------------

