//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// Some C Objects for Allegro's gui
//----------------------------------------------------------------------------
#include "degui.h"
#include "internal.h"

//----------------------------------------------------------------------------
// Global helper functions for the listbox
//----------------------------------------------------------------------------
// Tell the object to draw itself
void _draw_list_object (char*(*list_grabber_proc)(int,int*),
                       int *listsize,
                       const int offset,
                       const int x, const int y, const int w, const int h,
                       const int index,
                       const int disabled, const int has_focus,
                       const int fore,
                       const int select, const int deselect,
                       const int disable,
                       const int light_shad, const int dark_shad)
   {
   int height, xx;
   int fg;
   int y1, i;
   char s[2] = ".";
   char *text;
   int ii, x1;
   int len;
   int ww = w-1;

   // Draw the background
   draw_3d_frame(screen,x,y,x+ww,y+h,-1,dark_shad,light_shad);

   // Find out if we need a scrollbar or not
   list_grabber_proc(-1, listsize);
   height = (h-4) / text_height(font);

   xx = x+ww-2;

   // Choose the text color
   fg = fore;
   if(disabled) fg = disable;

   text_mode(-1);
   y1 = y+2;

   // Draw the contents
   for(i=offset;i<(*listsize);i++)
      {
      // Get the line to display
      text = list_grabber_proc(i,listsize);

      ii = 0;
      x1 = x+4;

      // Set the colors for the selected line
      if(i==index)
         {
         rectfill(screen,x1-2,y1,xx,y1+text_height(font)-1,select);
         rectfill(screen,xx,y1,xx+1,y1+text_height(font)-1,deselect);
         rectfill(screen,x+1,y1,x1-2,y1+text_height(font)-1,deselect);

         if(has_focus) draw_dotted_rect(screen,x1-1,y1,xx-1,y1+text_height(font)-1,fore);
         }
      else
         {
         rectfill(screen,x+1,y1,xx+1,y1+text_height(font)-1,deselect);
         }

      while((text!=NULL)&&(text[ii]!=0))
         {
         // Find the length of the character
         s[0] = text[ii];
         len = text_length(font,(unsigned char*)s);

         // Stop drawing if we are out of bounds
         if(x1+len>xx) break;

         // Draw the character, possible with cursor
         textout(screen,font,(unsigned char*)s,x1,y1,fg);

         x1 += len;
         ii++;
         }
      y1 += text_height(font);

      // Quit when we have printed enough
      if(y1+text_height(font)>(y+h)) i = *listsize;
      }
   // Draw the rest of the blank stuff
   rectfill(screen,x+1,y+1,x+ww-1,y+1,deselect);
   if(y1<(y+h-1)) rectfill(screen,x+1,y1,x+ww-1,y+h-1,deselect);
   }
//----------------------------------------------------------------------------

