indexing
    description    : "Allegro con Eiffel: 16.16 fixed point objects"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    allegro_author : "Shawn Hargreaves (shawn@talula.demon.co.uk)"
    names          : fixed
    date_started   : "17th December, 1996"
    version        : "0.1 beta"
    platforms      : "MS-DOS"
    dependencies   : "Allegro v2.2, DJGPP v2.01"


expanded class FIXED


inherit
    FIXED_REF
    redefine
        infix "+", infix "-", infix "*", infix "/", infix "^",
        prefix "+", prefix "-", valid_divisor, infix "<",
        infix "<=", infix ">", infix ">=", compare, one,
        zero, fill_tagged_out_memory
    end  -- inherit FIXED_REF


------------------------------------------------------ Internal features
feature { FIXED, BITMAP }

    -- Actual internal representation
    data : INTEGER


------------------------------------------------------ Fixed features
feature { ANY }

    from_integer(i : INTEGER) is
    -- Set Current to the fixed version of i
--    require
--        i_is_valid : i >= fixed_min.to_integer and i <= fixed_max.to_integer
    do
        c_inline_c("C->_data=itofix(a1);")
    end  -- feature from_integer


    from_double(d : DOUBLE) is
    -- Set Current to the fixed version of d
--    require
--        d_is_valid : d >= fixed_min.to_double and d <= fixed_max.to_double
    do
        c_inline_c("C->_data=ftofix(a1);")
    end  -- feature from_double


    to_integer : INTEGER is
    -- Return the integer equivalent of Current (truncation)
    do
        c_inline_c("R=fixtoi(C->_data);")
    end  -- feature to_integer


    to_real : REAL is
    -- Return the real equivalent of Current
    do
        Result := to_double
    end  -- feature to_real


    to_double : DOUBLE is
    -- Return the double equivalent of Current
    do
        c_inline_c("R=fixtof(C->_data);")
    end  -- feature to_double


    fixed_min : FIXED is
    -- The minimum possible value of a fixed
    once
        Result.from_integer(-32768)
    end  -- feature fixed_min


    fixed_max : FIXED is
    -- The maximum possible value of a fixed
    once
        Result.from_integer(+32767)
    end  -- feature fixed_max


    infix "+" (other : FIXED) : FIXED is
    -- Add `other' to Current.
    do
        c_inline_c("R._data=C->_data+a1->_data;")
    end  -- feature infix "+"


    infix "-" (other : FIXED) : FIXED is
    -- Subtract `other' from Current.
    do
        c_inline_c("R._data=C->_data-a1->_data;")
    end  -- feature infix "-"


    infix "*" (other: FIXED): FIXED is
    -- Multiply `other' by Current.
    do
        c_inline_c("R._data=fmul(C->_data,a1->_data);")
    end  -- feature infix "*"


    infix "/" (other : FIXED) : FIXED is
    -- Divide Current by `other'.
    do
        c_inline_c("R._data=fdiv(C->_data,a1->_data);")
    end  -- feature infix "/"


    infix "^" (e : INTEGER) : FIXED is
    -- Raise Current to `e'-th power.
    do
        check
            to_double = 0.0 implies e > 0
        end

        Result.from_double(to_double ^ e)
    end  -- feature infix "^"


    prefix "+" : FIXED is
    do
        c_inline_c("R._data=C->_data;")
    end  -- feature prefix "+"


    prefix "-" : FIXED is
    do
        c_inline_c("R._data=-1*C->_data;")
    end  -- feature prefix "-"


    abs : FIXED is
    do
        if Current.to_double < 0.0 then
            Result := -Current
        else
            Result := +Current
        end
    end  -- feature abs


    infix "<" (other : FIXED) : BOOLEAN is
    -- Is Current less than `other'?
    do
        Result := data < other.data
    end  -- feature infix "<"


    infix "<=" (other : FIXED) : BOOLEAN is
    -- Is Current smaller or equal to `other'?
    do
        Result := data <= other.data
    end  -- feature infix "<="


    infix ">" (other : FIXED) : BOOLEAN is
    -- Is Current greater than `other'?
    do
        Result := data > other.data
    end  -- feature infix ">"


    infix ">=" (other : FIXED) : BOOLEAN is
    -- Is Current greater or equal to `other'?
    do
        Result := data >= other.data
    end  -- feature infix ">="


    compare(other : FIXED) : INTEGER is
    -- Compare Current with `other'.
    -- '<' <==> Result < 0
    -- '>' <==> Result > 0
    -- Otherwise Result = 0
    do
        if Current < other then
            Result := -1
        else
            if Current > other then
                Result := 1
            end  -- if
        end  -- if
    end  -- feature compare


    valid_divisor(other : FIXED) : BOOLEAN is
    do
        Result := (other.data /= 0)
    end  -- feature valid_divisor


    one : FIXED is
    once
        Result.from_integer(1)
    end  -- feature one


    zero : FIXED is
    once
        Result.from_integer(0)
    end  -- feature zero


    floor : INTEGER is
    -- Greatest integral value no greater than Current.
    do
        c_inline_c("R=fixtoi((C)->_data);")
    ensure
        result_no_greater : Current.to_double >= Result
        close_enough      : Current.to_double - Result < one
    end  -- feature floor


    ceiling : INTEGER is
    -- Smallest integral value no smaller than Current.
    do
        Result := floor + 1
    ensure
        result_no_smaller : Current.to_double <= Result
        close_enough      : Result.to_real - Current.to_double < one
    end  -- feature ceiling


    truncated_to_integer : INTEGER is
    -- Integer part (same sign, largest absolute value
    -- no greater than Current).
    do
        Result := floor

        if 0.5 + Result < to_double(Current) then
            Result := ceiling
        end  -- if
    end  -- feature truncated_to_integer


    to_string : STRING is
    -- Convert the FIXED into a new allocated STRING.
    -- Note: see `append_in' to save memory.
    do
        Result := to_double.to_string
    end  -- feature to_string


    append_in(str : STRING) is
    -- Append the equivalent of `to_string' at the end of
    -- `str'. Thus you can save memory because no other
    -- STRING is allocate for the job.
    require
        str /= Void
    do
        to_double.append_in(str)
    end  -- feature append_in


    to_string_format(d : INTEGER) : STRING is
    -- Convert the FIXED into a new allocated STRING including
    -- only `d' digits in fractional part.
    -- Note: see `append_in_format' to save memory.
    do
        Result := to_double.to_string_format(d)
    end  -- feature to_string_format


    append_in_format(str : STRING; f : INTEGER) is
    -- Same as `append_in' but produce only `f' digit of
    -- the fractional part.
    require
        str /= Void
        f >= 0;
    do
        to_double.append_in_format(str,f)
    end  -- feature append_in_format


------------------------------------------------------ Maths functions
feature { ANY }

    sqrt : FIXED is
    -- Compute the square routine.
    require
        current_is_valid : to_integer >= 0
    do
        c_inline_c("R._data=fsqrt((C)->_data);")
    end  -- feature sqrt


    sin : FIXED is
    -- Compute the sine routine (in 256 degree units)
    do
        c_inline_c("R=fsin((C)->_data);")
    end  -- feature sin


    cos : FIXED is
    -- Compute the cosine routine (in 256 degree units)
    do
        c_inline_c("R=fcos((C)->_data);")
    end  -- feature cos


    tan : FIXED is
    -- Compute the tangent routine (in 256 degree units)
    do
        c_inline_c("R=ftan((C)->_data);")
    end  -- feature tan


    asin : FIXED is
    -- Compute the arc sine routine (in 256 degree units)
    do
        c_inline_c("R=fasin((C)->_data);")
    end  -- feature asin


    acos : FIXED is
    -- Compute the arc cosine routine (in 256 degree units)
    do
        c_inline_c("R=facos((C)->_data);")
    end  -- feature acos


    atan : FIXED is
    -- Compute the arc tangent routine (in 256 degree units)
    do
        c_inline_c("R=fatan((C)->_data);")
    end  -- feature atan


    atan2(f : FIXED) : FIXED is
    -- Compute the arc tangent of Current/f (in 256 degree units)
    -- See the C function atan2 for details
    do
        c_inline_c("R=atan2((C)->_data,a1->_data);")
    end  -- feature atan2


------------------------------------------------------ Object Printing
feature { ANY }

    fill_tagged_out_memory is
    do
        Current.append_in(tagged_out_memory)
    end  -- feature fill_tagged_out_memory


end  -- class FIXED

