indexing
    description    : "Allegro con Eiffel: write only packed file objects"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    allegro_author : "Shawn Hargreaves (shawn@talula.demon.co.uk)"
    names          : pack_file_write
    date_started   : "8th February, 1997"
    version        : "0.1 beta"
    platforms      : "MS-DOS"
    dependencies   : "Allegro v2.2, DJGPP v2.01"


class PACK_FILE_WRITE


inherit
    PACK_FILE
    end  -- inherit PACK_FILE


creation { ANY }
    connect_to


------------------------------------------------------ Creation features
feature { ANY }

    connect_to(new_path : STRING) is
    -- Connect this object to the given file
    do
        mode := "wp"
        output_stream := fopen(new_path,mode)

        if output_stream.is_not_void then
            path := new_path
        end  -- if
    end  -- feature connect_to


    disconnect is
    -- Disconnect this object from the current file
    local
        err : INTEGER
    do
        err := fclose(output_stream)
        path := Void
    end  -- feature disconnect


------------------------------------------------------ PACK_FILE_WRITE features
feature { ANY }

    put_character(c : CHARACTER) is
    -- Put a character into the file
    local
        err : CHARACTER
    do
        err := fputc(c,output_stream)

        debug
            if err /= c then
                std_error.put_string("Error in PACK_FILE_WRITE.put_character.%N")
                crash
            end  -- if
        end  -- debug
    end  -- feature put_character


    put_string(s : STRING) is
    -- Output `s' to current output device.
    require
        s /= Void
    local
        i : INTEGER
    do
        from
            i := 1
        until
            i > s.count
        loop
            put_character(s.item(i))
            i := i + 1
        end  -- from/loop
    end  -- feature put_string


    put_integer (i : INTEGER) is
    -- Output `i' to current output device.
    do
        tmp_string.clear
        i.append_in(tmp_string)
        put_string(tmp_string)
    end  -- feature put_integer


    put_integer_format(i, s : INTEGER) is
    -- Output `i' to current output device using at most
    -- `s' character.
    do
        tmp_string.clear
        i.append_in_format(tmp_string,s)
        put_string(tmp_string)
    end  -- feature put_integer_format


    put_real(r : REAL) is
    -- Output `r' to current output device.
    do
        tmp_string.clear
        r.append_in(tmp_string)
        put_string(tmp_string)
    end  -- feature put_real


    put_real_format(r : REAL; f : INTEGER) is
    -- Output `r' with only `f' digit for the fractionnal part.
    -- Examples:
    --    put_real(3.519,2) print "3.51".
    require
        f >= 0
    do
        tmp_string.clear
        r.append_in_format(tmp_string,f)
        put_string(tmp_string)
    end  -- feature put_real_format


    put_double(d : DOUBLE) is
    -- Output `d' to current output device.
    do
        tmp_string.clear
        d.append_in(tmp_string)
        put_string(tmp_string)
    end  -- feature put_double


    put_double_format(d : DOUBLE; f : INTEGER) is
    -- Output `d' with only `f' digit for the fractionnal part.
    -- Examples:
    --    put_double(3.519,2) print "3.51".
    require
        f >= 0
    do
        tmp_string.clear
        d.append_in_format(tmp_string,f)
        put_string(tmp_string)
    end  -- feature put_double_format


    put_boolean(b : BOOLEAN) is
    -- Output `b' to current output device according
    -- to the Eiffel format.
    do
        if b then
            put_string("true")
        else
            put_string("false")
        end  -- if
    end  -- feature put_boolean


    put_new_line is
    -- Output a newline character.
    do
        put_character('%N')
    end  -- feature put_new_line


    put_spaces(nb : INTEGER) is
    -- Output `nb' spaces character.
    require
        nb >= 0
    local
        count : INTEGER
    do
        from
        until
            count >= nb
        loop
            put_character(' ')
            count := count + 1
        end  -- from/loop
    end  -- feature put_spaces


    append_file(file_name : STRING) is
    require
        file_exists(file_name)
    local
        c : CHARACTER
    do
        tmp_file_read.connect_to(file_name)

        from
            tmp_file_read.read_character
        until
            tmp_file_read.end_of_input
        loop
            c := tmp_file_read.last_character
            put_character(c)
           tmp_file_read.read_character
        end  -- from/loop

        tmp_file_read.disconnect
    end  -- feature append_file


    flush is
    local
        err : INTEGER
    do
        err := fflush(output_stream)
    end  -- feature flush


------------------------------------------------------ Internal features
feature { NONE }

    tmp_file_read : PACK_FILE_READ is
    once
        !!Result.make
    end  -- feature tmp_file_read


    output_stream : POINTER


    tmp_string : STRING is
    once
        !!Result.make(512)
    end  -- feature tmp_string

end  -- class PACK_FILE_WRITE
