; * IDEHDDA.CPP - Contains IDE Hard Disk Low level functions.
; * Copyright (C) 1998, 1999 Prashant TR
; *
; * This program is free software; you can redistribute it and/or modify
; * it under the terms of the GNU General Public License as published by
; * the Free Software Foundation; either version 2 of the License, or
; * (at your option) any later version.
; *
; * See the file COPYING.TR for more details.

; Assembly functions to get IDE HDD information.

; Define global variables.
PUBLIC _idehdd_info_block

; Define global function(s).
PUBLIC _get_ide_hdd_info


_TEXT	SEGMENT BYTE PUBLIC 'CODE'
ASSUME CS:_TEXT, DS:_DATA
.386P

delay	PROC	NEAR
	PUSH	CX
	PUSH	DX
	MOV 	DX, AX
	SHR	EAX, 16
	MOV	CX, AX
	MOV	AH, 86H
	INT	15H
	POP	DX
	POP	CX
	RET
delay	ENDP

; To get IDE HDD info.
_get_ide_hdd_info	PROC	FAR
	PUSH	BP
	MOV	BP, SP
	PUSH	CX
	PUSH	DX
	PUSH	DI

	; Write to HDD control register.
	MOV	DX, [BP + 6]
	MOV	AL, [BP + 8]
	ADD	DX, 6
	OUT	DX, AL

	; Identify drive.
	MOV	AL, 0ECH
	INC	DX
	OUT	DX, AL

	; Check if command ended in error.
	MOV	EAX, 493E0H
	CALL	delay

	IN	AL, DX
	TEST	AL, 1
	JZ      _ide_hdd_info_cmd_passed
	JMP	_ide_hdd_info_not_found

_ide_hdd_info_cmd_passed:
	; See if sector buffer is ready.
	MOV	EAX, 493E0H
	CALL	delay

	IN	AL, DX
	TEST	AL, 8
	JNZ     _ide_hdd_info_getinfo

	JMP     _ide_hdd_info_not_found

_ide_hdd_info_getinfo:
	MOV	CX, 100H
	MOV	DI, OFFSET _idehdd_info_block
	MOV	AX, DS
	MOV	ES, AX
	SUB	DX, 7
	CLD
_ide_hdd_info_getstring:
	REP	INSW
	POP	DI
	POP	DX
	POP	CX
	POP	BP
	XOR	AX, AX
	MOV	DX, AX
	INC	AX
	RET
_ide_hdd_info_not_found:
	POP	SI
	POP	BX
	POP	CX
	POP	BP
	XOR	AX, AX
	MOV	DX, AX
	RET

_get_ide_hdd_info	ENDP

_TEXT	ENDS

; Data segment.
_DATA	SEGMENT	BYTE PUBLIC 'DATA'
ASSUME	DS:_DATA

_idehdd_info_block	DB	512 DUP(0)

_DATA	ENDS
	END