/*
 * EXTERNAL.H - Contains external functions.
 * Copyright (C) 1998, 1999 Prashant TR
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING.TR for more details.
*/

// ID for this file.
#define _EXTERNAL_H_

// External variables.
#ifndef _CPU_CC_

extern int errflag;

#endif

#ifdef stderr

#undef stderr

#ifdef _CPU_CC_

FILE *stderr;

#else

extern FILE *stderr;

#endif

#endif

// External functions.
extern "C" {
       unsigned long get_cpu_family();
       unsigned long get_cpu_model();
       unsigned long get_cpu_stepping_id();
       unsigned long get_cpu_feature_flags();
       int has_idflag();
       int is_386dx();
       int is_486dx();
       int is_cyrix486();
       char *get_cpu_vendor_name();
       unsigned long get_cpu_divword();
       unsigned long get_cpu_divbyte();
       unsigned long get_cpu_value();
       int get_xeon_celeron_p2d();
}

// Function definitions.
void newhandler();
void checkerrors();
int pinrun(const char *, const char *);
