/*
        SMARTEDIT - A general purpose editor for text files.

        Copyright (C) 1999 Prashant TR
                          B-42, Kudremukh Colony,
                          II Block, Koramangala,
                          Bangalore - 560034.

This program is freeware. You are free to modify and/or redistribute them
under the terms of the GNU General Public License version 2.0 or later.
Read the file COPYING for the license.

The file COPYING.TR contains details about the distribution of this software.

*/

/* ID for this file. */
#define _WINDOW_C_

#include "editor.h"

extern PREFERENCES pref;
extern unsigned video_base;
unsigned _stklen = 0x4000;
extern int blocking;

#pragma warn -rvl
#pragma argsused

extern WINDOW *win;

void drawwindow()
{
	unsigned short offset;
	sngbox_direct(win -> x1, win -> y1,
		win -> x2, win -> y2,
		pref.wincolor, pref.winbkcolor);

	/* Draw maximize button. */
	offset = (win -> y1 - 1) * 160 + ((win -> x2 - 6) * 2);
	_farpokeb(_dos_ds, video_base + offset, '[');
	_farpokeb(_dos_ds, video_base + offset + 2, '^');
	_farpokeb(_dos_ds, video_base + offset + 4, ']');

	/* Draw close button. */
	offset = (win -> y1 - 1) * 160 + ((win -> x1 + 2) * 2);
	_farpokeb(_dos_ds, video_base + offset, '[');
	_farpokeb(_dos_ds, video_base + offset + 2, '');
	_farpokeb(_dos_ds, video_base + offset + 4, ']');

	/* Print the filename. */
	if ((!strcmp(win -> filename, "")) &&
		(!strcmp(pref.deffilename, ""))) return;
	if (!strcmp(win -> filename, ""))
		strcpy(win -> filename, pref.deffilename);
	gotoxy(win -> x1 + ((win -> x2 - win -> x1 + 1) -
		strlen(win -> filename) - 2) / 2 - 1,
		win -> y1);
	textcolor(pref.wincolor); textbackground(pref.winbkcolor);
	cprintf(" %s ", win -> filename);
}

void destroyblock()
{
	win -> highlighted = 0;

	/* This takes care if already highlighted. */
	if (win -> bl1 == NULL) return;

	/* De-initialize all variables. */
	win -> bl1 = win -> bl2 = NULL;
	win -> bx1 = win -> by1 = win -> bx2 = win -> by2 = 0xffff;
}

void removehighlight(char *buffer)
{
	char *ptr = buffer;
	int f, g, offset, attrib = (pref.winbkcolor << 4) | pref.wincolor;

	/* Remove highlight. */
	for(f = win -> y1 + 1; f <= win -> y2 - 1; f++)
	{
		offset = (f - 1) * 160 + (win -> x1 * 2) + 1;
		for(g = win -> x1 + 1; g <= win -> x2 - 1; g++)
		{
			ptr[offset++] = attrib;
			offset++;
		}
	}
}

void highlight(char *buffer)
{
	unsigned short startrow = win -> logicalrow - win -> physicalrow +
					win -> y1 + 1;
	unsigned short offset, f, g, range,
			attrib = (pref.winbkcolor << 4) | pref.wincolor;
	unsigned short phyr1 = win -> by1 - startrow + 1 + win -> y1,
			phyc1 = win -> bx1 - win -> logicalcolstart + 1 +
				win -> x1,
			phyr2 = win -> by2 - startrow + 1 + win -> y1,
			phyc2 = win -> bx2 - win -> logicalcolstart + 1 +
				win -> x1;
	char *ptr = buffer;

	/* Check if blocking is in progress. */
	if (blocking) return;

	/* Check if we need to highlight. */
	if ((phyr1 > 0x7fff) && (phyr2 > 0x7fff)) return;
	if (phyr1 > 0x7fff) phyr1 = 0;
	if (phyr2 < win -> y1 + 1) return;
	if (phyr1 > win -> y2 - 1) return;
	if ((phyr2 == win -> y1 + 1) && (phyc2 == win -> x1 + 1)) return;
	if (phyr2 < phyr1) return;

	/* If out of bounds, set them to the min./max. possible. */
	/* Order is important. */
	if (phyc1 < win -> x1 + 1) phyc1 = win -> x1 + 1;
	if (phyc2 > win -> x2 - 1) phyc2 = win -> x2 - 1;
	if (phyr1 < win -> y1 + 1) {
		phyr1 = win -> y1 + 1;
		phyc1 = win -> x1 + 1;
	}
	if (phyr2 > win -> y2 - 1) {
		phyr2 = win -> y2 - 1;
		phyc2 = win -> x2;
	}

	/* First change the background of the window. */
	/* Clear window contents. */
	for(f = win -> y1 + 1; f <= win -> y2 - 1; f++)
	{
		offset = (f - 1) * 160 + (win -> x1 * 2) + 1;
		for(g = win -> x1 + 1; g <= win -> x2 - 1; g++)
		{
			ptr[offset++] = attrib;
			offset++;
		}
	}

	/* Highlight first line only. */
	offset = (phyr1 - 1) * 160 + (phyc1 - 1) * 2 + 1;

	if (win -> by1 == win -> by2) range = phyc2;
	else range = win -> x2;

	/* Highlight only if within range. */
	while (phyc1++ != range)
	{
		ptr[offset++] = 0x70;
		offset++;
	}

	if (win -> by1 == win -> by2) return;

	/* Highlight middle lines if any. */
	for(f = phyr1 + 1; f < phyr2; f++)
	{
		offset = (f - 1) * 160 + (win -> x1 * 2) + 1;
		for(g = win -> x1 + 1; g <= win -> x2 - 1; g++)
		{
			ptr[offset++] = 0x70;
			offset++;
		}
	}

	/* Highlight last line only. */
	offset = (phyr2 - 1) * 160 + (win -> x1 * 2) + 1;

	phyc1 = win -> x1 + 1;
	range = phyc2;

	/* Highlight only if within range. */
	while (phyc1++ != range)
	{
		ptr[offset++] = 0x70;
		offset++;
	}
}

void scrollbars()
{
	unsigned short offset, f, ch;

	/* Draw vertical scroll bar. */
	offset = (win -> y1 * 160) + ((win -> x2 - 1) * 2);
	_farpokeb(_dos_ds, video_base + offset, (pref.scrltype) ? 24 : '^');
	if (pref.scrltype) _farpokeb(_dos_ds, video_base + offset + 1, 0xf0);
	offset += 160;
	if (pref.scrltype) ch = ''; else ch = '';
	for(f = win -> y1 + 2; f <= win -> y2 - 2; f++, offset += 160)
	_farpokeb(_dos_ds, video_base + offset, ch);
	_farpokeb(_dos_ds, video_base + offset, (pref.scrltype) ? 25 : 'v');
	if (pref.scrltype) _farpokeb(_dos_ds, video_base + offset + 1, 0xf0);

	/* Draw horizontal scroll bar. */
	offset = ((win -> y2 - 1) * 160) + (win -> x1 * 2);
	_farpokeb(_dos_ds, video_base + offset++, (pref.scrltype) ? 27 : '<');
	offset++;
	if (pref.scrltype) _farpokeb(_dos_ds, video_base + offset - 1, 0xf0);
	if (pref.scrltype) ch = ''; else ch = '';
	for(f = win -> x1 + 2; f <= win -> x2 - 2; f++, offset += 2)
	_farpokeb(_dos_ds, video_base + offset, ch);
	_farpokeb(_dos_ds, video_base + offset, (pref.scrltype) ? 26 : '>');
	if (pref.scrltype) _farpokeb(_dos_ds, video_base + offset + 1, 0xf0);

	if (!pref.scrltype) {
		win -> xbar = win -> x1 + 2 +
			(win -> x2 - win -> x1 - 13) * win -> logicalcol / 255;
		win -> ybar = win -> y1 + 2 +
			(win -> y2 - win -> y1 - 9) *
				win -> logicalrow / win -> total_lines;
		if (win -> total_lines == 1) win -> ybar = win -> y1 + 2;
	}
	else {
		win -> xbar = win -> x1 + 2 +
			(win -> x2 - win -> x1 - 4) * win -> logicalcol / 255;
		win -> ybar = win -> y1 + 2 +
			(win -> y2 - win -> y1 - 4) *
			win -> logicalrow / win -> total_lines;
		if (win -> total_lines == 1) win -> ybar = win -> y1 + 2;
	}
}

void redrawwindow()
{
	char buffer[4000];
	TEXT *cline = win -> currline;
	unsigned short f, g,offset, phyrow = win -> physicalrow;

	if (blocking) return;

	/* Get window contents. */
	movedata(_dos_ds, video_base, FP_SEG(buffer), FP_OFF(buffer), 4000);

	removehighlight(buffer);

	/* Clear window contents. */
	for(f = win -> y1 + 1; f <= win -> y2 - 1; f++)
	{
		offset = (f - 1) * 160 + (win -> x1 * 2);
		for(g = win -> x1 + 1; g <= win -> x2 - 1; g++)
		{
			buffer[offset++] = 32;
			offset++;
		}
	}

	win -> currline = win -> scrline;
	win -> physicalrow = win -> y1 + 1;
	while ((win -> currline != NULL) && (win -> physicalrow < win -> y2))
	{
		offset = (win -> physicalrow - 1) * 160 + (win -> x1 * 2);

		for(f = win -> x1 + 1; f <= (win -> x2 - 1); f++, offset++)
		buffer[offset++] = win -> currline -> text[
					win -> logicalcolstart +
					f - win -> x1 - 2];
		win -> currline = win -> currline -> next;
		win -> physicalrow++;
	}
	win -> currline = cline;
	win -> physicalrow = phyrow;

	/* See if highlighting is needed. */
	if (win -> highlighted) highlight(buffer);

	/* Write to display memory. */
	movedata(FP_SEG(buffer), FP_OFF(buffer), _dos_ds, video_base, 4000);
}

void redrawline()
{
	unsigned short offset = (win -> physicalrow - 1) * 160 +
				(win -> x1 * 2), f;
	for(f = win -> x1 + 1; f <= (win -> x2 - 1); f++, offset++)
	_farpokeb(_dos_ds, video_base + offset++,
				win -> currline -> text[
					win -> logicalcolstart +
					f - win -> x1 - 2]);
}

/* Draw a dialog box with title. */
void drawdialog(char *title,
		int x1, int y1, int x2, int y2, int color,int bkcolor)
{
	int f, len = strlen(title);
	int offset = x1 + (x2 - x1 - strlen(title)) / 2;
	sngbox_direct(x1, y1, x2, y2, color, bkcolor);

	/* Draw shadows. */
	for(f = y1 + 1; f <= y2; f++)
	{
		_farpokeb(_dos_ds, video_base +
				x2 * 2 + 160 * (f - 1) + 1, LIGHTGRAY);
		_farpokeb(_dos_ds, video_base +
				x2 * 2 + 160 * (f - 1) + 3, LIGHTGRAY);
	}
	for(f = x1 + 2; f <= x2 + 2; f++)
	_farpokeb(_dos_ds, video_base + (f - 1) * 2 + 160 * y2 + 1, LIGHTGRAY);

	/* Print the title. */
	for(f = x1; f <= x2; f++)
	{
		_farpokeb(_dos_ds, video_base +
			(f - 1) * 2 + 160 * (y1 - 1), ' ');
		_farpokeb(_dos_ds, video_base +
			(f - 1) * 2 + 160 * (y1 - 1) + 1,
					(WHITE << 4) + BLACK);
	}
	for(f = 1; f <= len; f++)
	{
		_farpokeb(_dos_ds, video_base +
			(offset++ * 2) + 160 * (y1 - 1), *title++);
	}
}

/* Edit box. Returns 0 if cancelled or 1 if accepted. */
int editbox(char *buffer, int x, int y, int physical_length,
			int logical_length, char blankpad)
{
	int key, f, g;
	gotoxy(x, y);
	do {
		key = getch();
		if (!key) key = 256 + getch();
		f = strlen(buffer);
		if (isprint(key)) {
			if (f < logical_length) {
				buffer[f++] = key;
				buffer[f] = 0;
			}
		}
		else if ((key == 8) && (f)) buffer[--f] = 0;

		/* Print it. */
		if (f > physical_length) {
			gotoxy(x, y);
			cprintf("%s", &buffer[f - physical_length]);
			gotoxy(x + physical_length, y);
		}
		else {
			for(g = 1; g <= physical_length; g++)
			{
				_farpokeb(_dos_ds, video_base +
					(x + g - 2) * 2 +
					(y - 1) * 160, blankpad);
			}
			gotoxy(x, y);
			cprintf("%s", buffer);
			gotoxy(x + f, y);
		}
	} while ((key != 27) && (key != 13));

	if (key == 27) return 0;
	return 1;
}

void open_save_dialog(char *fname)
{
	char buffer[4000];
	char filename[256] = "";
	int key;

	/* Save video contents. */
	movedata(_dos_ds, video_base, FP_SEG(buffer), FP_OFF(buffer), 4000);

	/* Draw dialog box. */
	drawdialog("Load / Save File", 10, 5, 70, 15, WHITE, LIGHTGRAY);
	textcolor(WHITE); textbackground(LIGHTGRAY);
	gotoxy(14, 8); cprintf("Enter Filename");
	gotoxy(20, 12); cprintf("Press ESC to cancel or ENTER to accept");
	textcolor(WHITE); textbackground(BLUE);
	gotoxy(14, 10); cprintf("[......................................."
				"...........]");

	/* Get the filename. */
	key = editbox(filename, 15, 10, 50, 255, '.');
	/* Restore screen. */
	movedata(FP_SEG(buffer), FP_OFF(buffer), _dos_ds, video_base, 4000);
	if (!key) strcpy(fname, "+None+");
	else strcpy(fname, filename);
}

void doscmd_dialog(char *doscmd)
{
	char buffer[4000];
	char filename[256] = "";
	int key;

	/* Save video contents. */
	movedata(_dos_ds, video_base, FP_SEG(buffer), FP_OFF(buffer), 4000);

	/* Draw dialog box. */
	drawdialog("Execute DOS Command", 10, 5, 70, 15, WHITE, LIGHTGRAY);
	textcolor(WHITE); textbackground(LIGHTGRAY);
	gotoxy(14, 8); cprintf("Enter DOS Command to execute (type COMMAND to shell)");
	gotoxy(20, 12); cprintf("Press ESC to cancel or ENTER to accept");
	textcolor(WHITE); textbackground(BLUE);
	gotoxy(14, 10); cprintf("[......................................."
				"...........]");

	/* Get the filename. */
	key = editbox(filename, 15, 10, 50, 255, '.');

	/* Restore screen. */
	movedata(FP_SEG(buffer), FP_OFF(buffer), _dos_ds, video_base, 4000);
	if (!key) strcpy(doscmd, "");
	else strcpy(doscmd, filename);
}

void find_dialog(char *text)
{
	char buffer[4000];
	char textbuf[256] = "";
	int key;

	/* Save video contents. */
	movedata(_dos_ds, video_base, FP_SEG(buffer), FP_OFF(buffer), 4000);

	/* Draw dialog box. */
	drawdialog("Search for a string", 10, 5, 70, 15, WHITE, LIGHTGRAY);
	textcolor(WHITE); textbackground(LIGHTGRAY);
	gotoxy(14, 8); cprintf("Find what :");
	gotoxy(20, 12); cprintf("Press ESC to cancel or ENTER to accept");
	textcolor(WHITE); textbackground(BLUE);
	gotoxy(14, 10); cprintf("[......................................."
				"...........]");

	/* Get the string. */
	key = editbox(textbuf, 15, 10, 50, 255, '.');

	/* Restore screen. */
	movedata(FP_SEG(buffer), FP_OFF(buffer), _dos_ds, video_base, 4000);
	if (!key) strcpy(text, "");
	else strcpy(text, textbuf);
	setcursor;
}

void replace_dialog(char *text, char *newtext)
{
	char buffer[4000];
	char textbuf[256] = "";
	int key;

	/* Save video contents. */
	movedata(_dos_ds, video_base, FP_SEG(buffer), FP_OFF(buffer), 4000);

	/* Draw dialog box. */
	drawdialog("Search for a string", 10, 5, 70, 19, WHITE, LIGHTGRAY);
	textcolor(WHITE); textbackground(LIGHTGRAY);
	gotoxy(14, 8); cprintf("Find what :");
	gotoxy(20, 12); cprintf("Press ESC to cancel or ENTER to accept");
	textcolor(WHITE); textbackground(BLUE);
	gotoxy(14, 10); cprintf("[......................................."
				"...........]");

	/* Get the string. */
	key = editbox(textbuf, 15, 10, 50, 255, '.');

	if (!key) {
		strcpy(text, "");
		movedata(FP_SEG(buffer), FP_OFF(buffer), _dos_ds, video_base, 4000);
		setcursor;
		return;
	}

	strcpy(text, textbuf);
	textcolor(WHITE); textbackground(LIGHTGRAY);
	gotoxy(14, 12); cprintf("Replace with :                        "
				"      ");
	gotoxy(20, 16); cprintf("Press ESC to cancel or ENTER to accept");
	textcolor(WHITE); textbackground(BLUE);
	gotoxy(14, 14); cprintf("[......................................."
				"...........]");
	strcpy(textbuf, "");
	/* Get the string. */
	key = editbox(textbuf, 15, 14, 50, 255, '.');

	/* Restore screen. */
	if (!key) strcpy(newtext, "");
	else strcpy(newtext, textbuf);
	movedata(FP_SEG(buffer), FP_OFF(buffer), _dos_ds, video_base, 4000);
	setcursor;
}

/* Check/Uncheck an option. */
int check(int x, int y, int checked)
{
	gotoxy(x, y);
	cprintf("%c", (checked) ? 'X' : ' ');
	gotoxy(x, y);
        return 0;
}

/* To check for space, enter or ESC. */
int wait_checkbox(int *checked)
{
	int result;

	do {
		result = wait();
		if (!result) result = 256 + getch();
		if (result == ' ') {
			*checked = !*checked;
			check(wherex(), wherey(), *checked);
		}
	} while ((result != 27) && (result != 13) && (result != 328) &&
		(result != 336) && (result != 9) && (result != 271));

	/* Return the key pressed. */
	return (result);
}

/* Edit box that recognizes special characters.
	Returns 0 if cancelled or 1 if accepted. */
int editbox_special(char *buffer, int x, int y, int physical_length,
			int logical_length, char blankpad)
{
	int key, f, g;
	gotoxy(x, y);
	do {
		key = getch();
		if (!key) key = 256 + getch();
		f = strlen(buffer);
		if (isprint(key)) {
			if (f < logical_length) {
				buffer[f++] = key;
				buffer[f] = 0;
			}
		}
		else if ((key == 8) && (f)) buffer[--f] = 0;

		/* Print it. */
		if (f > physical_length) {
			gotoxy(x, y);
			cprintf("%s", &buffer[f - physical_length]);
			gotoxy(x + physical_length, y);
		}
		else {
			for(g = 1; g <= physical_length; g++)
			{
				_farpokeb(_dos_ds, video_base +
					(x + g - 2) * 2 +
					(y - 1) * 160, blankpad);
			}
			gotoxy(x, y);
			cprintf("%s", buffer);
			gotoxy(x + f, y);
		}
	} while ((key != 27) && (key != 13) && (key != 9) && (key != 271) &&
			(key != 328) && (key != 336));

	return (key);
}