/*
        SMARTEDIT - A general purpose editor for text files.

        Copyright (C) 1999 Prashant TR
                          B-42, Kudremukh Colony,
                          II Block, Koramangala,
                          Bangalore - 560034.

This program is freeware. You are free to modify and/or redistribute them
under the terms of the GNU General Public License version 2.0 or later.
Read the file COPYING for the license.

The file COPYING.TR contains details about the distribution of this software.

*/

/* ID for this file. */
#define _FORMAT_C_

#include "editor.h"

extern WINDOW *win;
extern char searchtxt[256], replacetxt[256], filename[256];
extern PREFERENCES pref;

/* Process the key pressed. */
void send_message(int key)
{
	TEXT *ptr;
	unsigned short f;
	if ((isprint(key)) && (key < 256)) {
		if (win -> logicalcol < 255) {
			win -> dirty = 1;
			insert_char(key);
			setcursor;
		}
	}
	/* Ctrl-K. */
	else if (key == 11) Edit_Copy();
	/* Ctrl-L. */
	else if (key == 12) {
		if (strcmp(searchtxt, "")) Search_Find(searchtxt);
	}
	/* Ctrl-N. */
	else if (key == 14) Edit_Clear();
	/* Ctrl-J. */
	else if (key == 10) {
		if (strcmp(searchtxt, ""))
			Search_Replace(searchtxt, replacetxt);

	}
	/* ENTER. */
	else if (key == 13) {
		win -> dirty = 1;
		insert_line();
		setcursor;
	}
	/* Backspace. */
	else if (key == 8) {
		destroyblock();
		win -> dirty = 1;
		if (win -> logicalcol == 1) {
			if (win -> logicalrow != 1) {
				append_line();
				setcursor;
			}
		}
		else {
			backspace_char();
			setcursor;
		}
	}
	/* Left. */
	else if ((key == 331) || (key == 19)) {
		if (win -> logicalcol == 1) return;
		blockbegin();
		win -> logicalcol--;
		win -> physicalcol--;
		if (win -> physicalcol < win -> x1 + 1) {
			/* Retain physical column. */
			win -> physicalcol++;
			win -> logicalcolstart--;
			redrawwindow();
		}
		else redrawline();
		blockend();
		setcursor;
	}
	/* Right. */
	else if ((key == 333) || (key == 4)) {
		if (win -> logicalcol == 255) return;
		blockbegin();
		win -> logicalcol++;
		win -> physicalcol++;
		if (win -> physicalcol > win -> x2 - 1) {
			/* Retain physical column. */
			win -> physicalcol--;
			win -> logicalcolstart++;
			redrawwindow();
		}
		else redrawline();
		blockend();
		setcursor;
	}
	/* Up. */
	else if ((key == 328) || (key == 5)) {
		if (win -> logicalrow == 1) return;
		blockbegin();
		win -> currline = win -> currline -> prev;
		win -> logicalrow--;
		win -> physicalrow--;
		if (win -> physicalrow < win -> y1 + 1) {
			/* Retain physical row. */
			win -> physicalrow++;
			win -> scrline = win -> scrline -> prev;
			redrawwindow();
		}
		else redrawline();
		blockend();
		setcursor;
	}
	/* Down. */
	else if ((key == 336) || (key == 24))  {
		if (win -> currline -> next == NULL) return;
		blockbegin();
		win -> currline = win -> currline -> next;
		win -> logicalrow++;
		win -> physicalrow++;
		if (win -> physicalrow > win -> y2 - 1) {
			/* Retain physical row. */
			win -> physicalrow--;
			win -> scrline = win -> scrline -> next;
			redrawwindow();
		}
		else redrawline();
		blockend();
		setcursor;
	}
	/* Home. */
	else if (key == 327) {
		blockbegin();
		win -> logicalcol = 1;
		win -> physicalcol = win -> x1 + 1;
		if (win -> logicalcolstart != 1) {
			win -> logicalcolstart = 1;
			redrawwindow();
		}
		blockend();
		setcursor;
	}
	/* End. */
	else if (key == 335) {
		blockbegin();
		f = 254;
		ptr = win -> currline;
		while ((f != 0xffff) && (ptr -> text[f] == 32)) f--;
		f++;
		win -> logicalcol = f + 1;
		f = win -> logicalcolstart;
		win -> physicalcol = (win -> logicalcol - 1) %
				(win -> x2 - win -> x1 - 1) +
				win -> x1 + 1;
		win -> logicalcolstart = (win -> logicalcol - 1) /
				(win -> x2 - win -> x1 - 1) *
				(win -> x2 - win -> x1 - 1) + 1;
		if (f != win -> logicalcolstart) redrawwindow();
		blockend();
		setcursor;
	}
	/* Del key. */
	else if ((key == 339) || (key == 7)) {
		if (shiftstatus & 3) {
			Edit_Cut();
			return;
		}
		destroyblock();
		win -> dirty = 1;
		delete_char();
		setcursor;
	}
	/* PgUp key. */
	else if ((key == 329) || (key == 18)) {
		if (win -> logicalrow == 1) return;
		blockbegin();
		f = (win -> y2 - win -> y1 - 1);
		while ((f) && (win -> scrline -> prev != NULL))
		{
			win -> logicalrow--;
			win -> currline = win -> currline -> prev;
			win -> scrline = win -> scrline -> prev;
			f--;
		}
		if (f) {
			win -> currline = win -> scrline;
			win -> physicalrow = win -> y1 + 1;
			win -> logicalrow = 1;
		}
		redrawwindow();
		blockend();
		setcursor;
	}
	/* PgDn key. */
	else if ((key == 337) || (key == 3)) {
		if (win -> currline -> next == NULL) return;
		blockbegin();
		f = (win -> y2 - win -> y1 - 1);
		while ((f) && (win -> currline -> next != NULL))
		{
			win -> logicalrow++;
			win -> currline = win -> currline -> next;
			win -> scrline = win -> scrline -> next;
			f--;
		}
		if (f) {
			win -> scrline = win -> currline;
			win -> physicalrow = win -> y1 + 1;
		}
		redrawwindow();
		blockend();
		setcursor;
	}
	/* Ctrl-PgUp key. */
	else if (key == 388) {
		blockbegin();
		win -> currline = win -> topline;
		win -> scrline = win -> topline;
		win -> logicalrow = 1;
		win -> physicalrow = win -> y1 + 1;
		redrawwindow();
		blockend();
		setcursor;
	}
	/* Ctrl-PgDn key. */
	else if (key == 374) {
		if (win -> currline -> next == NULL) return;
		blockbegin();
		while (win -> currline -> next != NULL)
		{
			win -> logicalrow++;
			win -> currline = win -> currline -> next;
			win -> scrline = win -> scrline -> next;
		}
		win -> scrline = win -> currline;
		win -> physicalrow = win -> y1 + 1;
		redrawwindow();
		blockend();
		setcursor;
	}
	/* Ctrl-HOME key. */
	else if (key == 375) {
		if (win -> currline == win -> scrline) return;
		blockbegin();
		while (win -> currline != win -> scrline)
		{
			win -> logicalrow--;
			win -> currline = win -> currline -> prev;
		}
		win -> physicalrow = win -> y1 + 1;
		blockend();
		setcursor;
	}
	/* Ctrl-END key. */
	else if (key == 373) {
		if (win -> currline -> next == NULL) return;
		blockbegin();
		ptr = win -> scrline;
		win -> physicalrow = win -> y1 + 1;
		f = (win -> y2 - win -> y1 - 1);

		while (win -> currline != win -> scrline)
		{
			win -> logicalrow--;
			win -> currline = win -> currline -> prev;
		}

		while ((--f) && (ptr -> next != NULL))
		{
			win -> physicalrow++;
			win -> logicalrow++;
			ptr = ptr -> next;
		}
		win -> currline = ptr;
		blockend();
		setcursor;
	}
	/* Ctrl-Y (Delete a line). */
	else if (key == 25) {
		destroyblock();
		win -> dirty = 1;
		delete_line();
		setcursor;
	}
	/* F2: Save. */
	else if (key == 316) {
		_setcursortype(1);
		if (!strcmp(win -> filename, "") &&
			(!strcmp(pref.deffilename, "")))
			open_save_dialog(filename);
		else strcpy(filename, win -> filename);
		if (!strcmp(win -> filename, ""))
			strcpy(filename, pref.deffilename);

		if (strcmp(filename, "+None+"))	File_Save(filename);
		_setcursortype((!win -> insert) + 1);
		setcursor;
	}
	/* F3: Load. */
	else if (key == 317) {
		_setcursortype(1);
		open_save_dialog(filename);
		if (strcmp(filename, "+None+")) File_Load(filename);
		_setcursortype((!win -> insert) + 1);
		setcursor;
	}
	else if (key == 354) Window_Size(); /* Ctrl-F5. */
	else if (key == 319) Window_FullScreen(); /* F5. */
	else if (key == 355) Window_NewWindow(); /* Ctrl-F6. */
	else if (key == 320) Window_NextWindow(); /* F6. */
	else if (key == 362) Window_CloseWindow(); /* Alt-F3. */
}