/*
   $Source: F:/DJGPP/EXAMPLES/C/VM/RCS/vm.c $
   $Revision: 1.2 $
   $Date: 1997/05/14 06:34:00 $
   $Author: PHIL $
   $Locker:  $

   example program demonstrating DJGPP's flat memory model and virtual memory
   allocates as much memory as possible in 5 meg increments
   writes all the memory with the value 0xA5
   rewrites it with the value 0x5A
*/

#include <stdio.h>
#include <stdlib.h>

#define ONE_MEG  1048576

int
main ()
{
   char *mem[512];
   int   n;
   int   i;
   int   j;

   /* malloc a pile of memory */
   n = 0;
   while ((mem[n] = malloc (ONE_MEG))) {
      n++;
      printf ("%d megabytes allocated\n", n);
   }
   printf ("\n");

   /* fill it all with 0xA5 */
   for (i=0; i<n; i++) {
      for (j=0; j<ONE_MEG; j++) {
         mem[i][j] = 0xa5;
      }
      printf ("%d megabytes written\n", i+1);
   }
   printf ("\n");
   
   /* refill it all with 0x5A */
   for (i=0; i<n; i++) {
      for (j=0; j<ONE_MEG; j++) {
         mem[i][j] = 0x5A;
      }
      printf ("%d megabytes rewritten\n", i+1);
   }
   printf ("\n");

   return (0);
}



