# Sed script to add DJGPP specific issues to config.h.

$ a\
\
\
/* DGJPP-specific definitions */\
\
#ifdef __DJGPP__\
\
int chdir_safer(char const *);\
# define chdir  chdir_safer\
\
# define HAVE_DOS_FILE_NAMES 1\
\
# include <ctype.h>\
# define filename_char_eq(c1,c2) \\\
   ({int _c1 = (c1), _c2 = (c2); \\\
     (_c1 >= 'A' &&  _c1 <= 'Z' ? tolower(_c1) : _c1) == \\\
     (_c2 >= 'A' &&  _c2 <= 'Z' ? tolower(_c2) : _c2); \\\
   })\
\
# define DEFAULT_OS_QUOTING_STYLE      dos_nt_quoting()\
# define DEFAULT_OS_QUOTING_STYLE_DCL  extern enum quoting_style dos_nt_quoting (void);\
\
/*\
 *  Provide version.h.\
 */\
# include <sys/version.h>  /*  gcc no longer includes this by default.  */\
\
# include <stdio.h>\
# include <sys/stat.h>\
\
int djgpp_wrapper_open(const char *file_name, int mode, ...);\
# undef  open\
# define open(file_name, mode, permisions...)  djgpp_wrapper_open(file_name, mode, ## permisions)\
\
int djgpp_wrapper_close(int fd);\
# undef  close\
# define close(fd)  djgpp_wrapper_close(fd)\
\
FILE *djgpp_wrapper_fopen(const char *file_name, const char *mode);\
# undef  fopen\
# define fopen(file_name, mode)  djgpp_wrapper_fopen(file_name, mode)\
\
int djgpp_wrapper_fclose(FILE *fp);\
# undef  fclose\
# define fclose(fp)  djgpp_wrapper_fclose(fp)\
\
int djgpp_wrapper_rename(const char *old_name, const char *new_name);\
# undef  rename\
# define rename(old_name, new_name)  djgpp_wrapper_rename(old_name, new_name)\
\
int djgpp_wrapper_unlink(const char *file_name);\
# undef  unlink\
# define unlink(file_name)  djgpp_wrapper_unlink(file_name)\
\
int djgpp_wrapper_lstat(const char *file_name, struct stat *stat_buf);\
# undef  lstat\
# define lstat(file_name, stat_buf)  djgpp_wrapper_lstat(file_name, stat_buf)\
\
int djgpp_wrapper_fstat(int fd, struct stat *stat_buf);\
# undef  fstat\
# define fstat(fd, stat_buf)  djgpp_wrapper_fstat(fd, stat_buf)\
\
int djgpp_wrapper_stat(const char *file_name, struct stat *stat_buf);\
# undef  stat\
# define stat(file_name, stat_buf)  djgpp_wrapper_stat(file_name, stat_buf)\
\
/*  To avoid redefinition warnings.  */\
# ifdef _GL_ARG_NONNULL\
#  undef _GL_ARG_NONNULL\
# endif\
\
\
/*\
 * Map linux file mode to DJGPP file mode.\
 * This is necessary to correctly map file\
 * modes encoded in git style patches.\
 */\
/* Encoding of the file mode.  */\
\
# define __S_IFMT        0170000        /* These bits determine file type.  */\
\
/* File types.  */\
# define __S_IFDIR       0040000        /* Directory.  */\
# define __S_IFCHR       0020000        /* Character device.  */\
# define __S_IFBLK       0060000        /* Block device.  */\
# define __S_IFREG       0100000        /* Regular file.  */\
# define __S_IFIFO       0010000        /* FIFO.  */\
# define __S_IFLNK       0120000        /* Symbolic link.  */\
\
# define __S_ISDIR(m)    (((m) & __S_IFMT) == __S_IFDIR)\
# define __S_ISCHR(m)    (((m) & __S_IFMT) == __S_IFCHR)\
# define __S_ISBLK(m)    (((m) & __S_IFMT) == __S_IFBLK)\
# define __S_ISREG(m)    (((m) & __S_IFMT) == __S_IFREG)\
# define __S_ISIFO(m)    (((m) & __S_IFMT) == __S_IFIFO)\
# define __S_ISLNK(m)    (((m) & __S_IFMT) == __S_IFLNK)\
\
\
/* Protection bits.  */\
\
# define __ALL_ID        06000          /* These bits determine user/group ID.  */\
\
# define __S_ISUID       04000          /* Set user ID on execution.  */\
# define __S_ISGID       02000          /* Set group ID on execution.  */\
\
# define ___S_ISUID(m)   (((m) & __ALL_ID) == __S_ISUID)\
# define ___S_ISGID(m)   (((m) & __ALL_ID) == __S_ISGID)\
\
\
\
/*\
 *  Change DJGPP specific encoding for S_IFREG.\
 */\
\
# undef  S_IFREG\
# define S_IFREG         0x6000\
# undef  S_ISREG\
# define S_ISREG(m)      (((m) & 0xF000) == 0x6000)\
\
\
# define HAVE_LFN_SUPPORT(name)  (pathconf((name), _PC_NAME_MAX) > 12)\
\
\
/* DJGPP's highst errno is 41 (EILSEQ) so taking the same\
   value than for native windows systems seems to be save.  */\
# ifndef EOPNOTSUPP\
#  define EOPNOTSUPP     10045          /* Operation not supported on transport endpoint */\
# endif\
#endif
