#-----------------------------------------------------------------------------
#
#  perl script for fixing filenames to conform to DOS 8+3 conventions
#  Kein-Hong Man <mkh.pl.jaring.my>
#  this script is hereby placed into PUBLIC DOMAIN
#  2003-05-20
#
#-----------------------------------------------------------------------------
# 
# Notes on conversion to 8+3 safe:
# 
# (1) source code does not appear to have any non-LFN mode problems
#     problematic files were all referenced in textual setup files
# 
# (2) one case of >8 in "include" directory: save_bookf
#     this file appear to be unused, the file used is "bookf", no conflicts
# 
# (3) the "hyph" directory has one >8 case: hyph/uppersorbian.lh
#     hyph files are referenced in "include/langdefs", format being:
#     Format: langdef UpperSorbian <words> { uppersorbian  <punctuations> }
# 
# (4) russian font definitions at "include/russian.fd", font files are not
#     included in the lout distribution as standard, no 8+3 problems
# 
# (5) "blurb.short" is harmless
# 
# (6) "locale" has >1 dot problems, but we are not using it, so drop
# 
# (5) "software" has >3 problems, but it is only informational files,
#     dropped in the binaries, people should see the official site...
# 
# (6) "font" directory has numerous >8 cases, and also usages of '+'
#     styles are encoded for human reading, like these examples:
#	Cr		Cr+		Cr-O		Cr-O+
#	AG-Bd		AG-Bd+		AG-BdO		AG-BdO+
#	AG-CnBd		AG-CnBd+	AG-ExLtO	AG-ExLtO+
#	He-ExtC		He-ExtC+	NCS-Bd		NCS-Bd+
#	NCS-BdIt	NCS-BdIt+	Pa-BdF		Pa-BdF+
#	Pa-BdIt		Pa-BdIt+	Pa-BdItF	Pa-BdItF+
#	Symbol
# 
# (7) font metric files are referenced in "data/fontdefs.ld"
#     Format: @Metrics { AG-Md }
# 
# (8) font metric files are referenced in "data/latin2.ld"
#     Format: @Metrics { AG-Md }
#     Format: @ExtraMetrics { AG-Md+ }
# 
# So, we need to fix the following:
# (3) rename the hyphenation file with >8
# (6) shorten names (longest has 9 chars) and remove '+' characters
# (7) fixup filename references according to (6)
# (8) fixup filename references according to (6)
# (9) we might need to fix the build scripts too...
#
# WARNING
# a filename with all capitals seem to turn into all lower case in Win9x
# MS-DOS prompt window -- causes a problem with the file font/ZD
# 
#-----------------------------------------------------------------------------

$TEST = 0;				# set to non-0 to test parts (BROKEN)
chdir "..";				# start in base directory

%buildsub = ();				# to change in build scripts

#-----------------------------------------------------------------------------
# convert font metrics filenames and verify integrity (automatic) (6)
#-----------------------------------------------------------------------------

$fontdir = "font";			# directory to fix
%fontsub = ();				# what has been substituted

chdir "$fontdir";
@fontlist = glob("*");			# get WHOLE list to work with

foreach $ffile (@fontlist)
{
    $fnew = $ffile;			# HERE ARE THE FIX RULES:
    $fnew =~ s/-//;			# (1) remove '-' to save one space
    $fnew =~ s/\+/X/;			# (2) avoid '+' characters

    ($fname, $fext) = /([^\.]+)\.?([^\.]*)/;

    if (length($fname) > 8 ||		# VERIFY must be valid
	length($fext) > 3)
    {
	die "Cannot trim to MS-DOS safe with these rules ($ffile)";
    }
    foreach $fcheck (keys %fontsub)	# VERIFY cannot duplicate
    {
	if (uc($fnew) eq uc($fcheck))
	{
	    die "Trimming rules creates duplicate filename ($ffile)";
	}
    }
    $fontsub{$ffile} = $fnew;		# make a copy of substitution
    $buildsub{"$fontdir/$ffile"} = "$fontdir/$fnew";

    if (!$TEST) {
	rename $ffile, $fnew;
    }
}
print "Renamed $fontdir files to conform to 8+3 standard\n";
chdir "..";

#-----------------------------------------------------------------------------
# substitute into the font definition files (with checking) (7) (8)
#-----------------------------------------------------------------------------
if ($TEST) {
    @fixuplist = ( "djgpp/fontdefs.ld", "djgpp/latin2.ld", );	# !!! TEST ONLY
}
else {
    @fixuplist = ( "data/fontdefs.ld", "data/latin2.ld", );
}

foreach $fixupfile (@fixuplist)
{
    open IFILE, "<$fixupfile" or die "Cannot read $fixupfile";	# grab everything
    @filebits = <IFILE>;
    close IFILE;

    $outfile = $fixupfile;
    if ($TEST) { $outfile .= ".tst"; }

    open OFILE, ">$outfile" or die "Cannot write $outfile";	# write output
    while ($l = shift @filebits)
    {
	if ($l =~ /^\s*@(Extra)?Metrics\s+\{\s*(\S+)\s*\}/)	# find refs
	{
	    $fixname = $2;
	    $fixnew = $fontsub{$fixname};	# lookup new name

	    if (length($fixnew) == 0)		# might be MS-DOS quirk
	    {
		$fixnew = $fontsub{lc($fixname)}; # lookup again, lower case
	    }
	    if (length($fixnew) == 0)		# if font name cannot be found,
	    {					# something may be wrong
		print "WARNING lookup failed for '$fixname' in $fixupfile\n";
		print OFILE $l;
		next;
	    }
	    $fixname = quotemeta $fixname;			# change filename
	    $l =~ s/(Metrics\s+\{\s*)$fixname(\s*\})/\1$fixnew\2/;
	}
	print OFILE $l;
    }
    close OFILE;
    print "Fixup $fixupfile references to font metric files\n";
}

#-----------------------------------------------------------------------------
# shorten hyphenation filename (manual data specification) (3)
#-----------------------------------------------------------------------------

if ($TEST) 
{
    $langfile = "djgpp/langdefs";				# !!! TEST ONLY
    @sublist = ( "djgpp:lh:uppersorbian:usorbian", );
}
else
{   #---------------------------------------------------------------
    $langfile = "include/langdefs";				# manual spec'ed
    @sublist = ( "hyph:lh:uppersorbian:usorbian", );
}   #---------------------------------------------------------------

foreach $subfile (@sublist)
{
    ($subdir, $subext, $subfrom, $subto) = 			# grab item
	$subfile =~ /([^:]+):([^:]+):([^:]+):([^:]+)/;

    if ($TEST) {
	print "'$subdir/$subfrom.$subext' -> '$subdir/$subto.$subext'\n";
    }
    else {
	rename "$subdir/$subfrom.$subext", "$subdir/$subto.$subext";
    }

    open IFILE, "<$langfile" or die "Cannot read $langfile";	# grab everything
    @filebits = <IFILE>;
    close IFILE;

    $outfile = $langfile;
    if ($TEST) { $outfile .= ".tst"; }

    open OFILE, ">$outfile" or die "Cannot write $outfile";	# write output
    while ($l = shift @filebits)
    {
	$l =~ s/^(langdef\s.+\s\{\s+)$subfrom/$1$subto/;	# make sure
	print OFILE $l;						# correct format
    }
    close OFILE;

    $buildsub{"$subdir/$subfrom.$subext"} = "$subdir/$subto.$subext";

    print "Fixed '$subdir/$subfrom.$subext' -> '$subdir/$subto.$subext'\n";
}

#-----------------------------------------------------------------------------
# fixup build scripts with all filenames changed (9)
#-----------------------------------------------------------------------------
chdir "djgpp";						# now in /djgpp

$origsuffix = ".org";
%buildlist = ( 'build_s' => '$C', 'build_b' => '$L/$LOUT', );

foreach $buildfile (keys %buildlist)
{
    $prefx = quotemeta $buildlist{$buildfile};

    open IFILE, "<$buildfile$origsuffix"
	or die "Cannot read $buildfile$origsuffix";		# grab everything
    @filebits = <IFILE>;
    close IFILE;

    open OFILE, ">$buildfile" or die "Cannot write $buildfile";	# write output
    while ($l = shift @filebits)
    {
	if ($l =~ m!^$prefx/(\S+)$!)
	{
	    $fixname = $1;
	    $fixnew = $buildsub{$fixname};	# lookup new name

	    if (length($fixnew) > 0)
	    {
		$fixname = quotemeta $fixname;			# change filename
		$l =~ s/$fixname/$fixnew/;
	    }
	}
	print OFILE $l;
    }
    close OFILE;
    print "Fixed distribution build file $buildfile\n";
}

#-----------------------------------------------------------------------------
# end of script
#-----------------------------------------------------------------------------
__END__