/* see.c v0.80 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "all.h"
#include "dep.h"
/*---------------------------------------------------------------------------*/
/* global variables : use */
extern int lastkey;
extern struct teffect effect;
extern struct tkeyparse **ptkeyparsetbl;
/*---------------------------------------------------------------------------*/
/* global variables : declare */
BITMAP *pbmp, *pbmpo;
PALETTE pal, palo;
int npixels, scr_h, scr_w;
uchr confname[256], intrname[256], loginname[256], retvalsee[256];
/*---------------------------------------------------------------------------*/
/* variables */
BITMAP *bmp; /* used in load_gif and in gif_output_string */
PACKFILE *ppackfile;
uchr string[4096], **table_see;
int bit_overflow, bit_pos, bit_size, cc, code, count_see, curr_bit_size;
int data_len, data_pos, effect_mode, empty_string, entire, gif_i, image_h;
int image_w, image_x, image_y, interlace, string_length, table_see_index, x, y;
struct lzw_string str[4096];
/*---------------------------------------------------------------------------*/
static tkeyparse
  see_end = {K_END, keysee_end},
  see_f1 = {K_F1, keysee_f1},
  see_f2 = {K_F2, keysee_f2},
  see_f3 = {K_F3, keysee_f3},
  see_f4 = {K_F4, keysee_f4},
  see_f5 = {K_F5, keysee_f5},
  see_f6 = {K_F6, keysee_f6},
  see_f7 = {K_F7, keysee_f7},
  see_f8 = {K_F8, keysee_f8},
  see_f9 = {K_F9, keysee_f9},
  see_f10 = {K_F10, keysee_f10},
  see_f11 = {K_F11, keysee_f11},
  see_f12 = {K_F12, keysee_f12},
  see_home = {K_HOME, keysee_home},
  see_i = {K_i, keysee_i},
  see_insert = {K_INSERT, keysee_insert},
  see_left = {K_LEFT, keysee_left},
  see_pagedown = {K_PAGEDOWN, keysee_pagedown},
  see_pageup = {K_PAGEUP, keysee_pageup},
  see_right = {K_RIGHT, keysee_right}
;

tkeyparse* tkeyparsetbl_see[] =
{
  &see_end,
  &see_f1,
  &see_f2,
  &see_f3,
  &see_f4,
  &see_f5,
  &see_f6,
  &see_f7,
  &see_f8,
  &see_f9,
  &see_f10,
  &see_f11,
  &see_f12,
  &see_home,
  &see_i,
  &see_insert,
  &see_left,
  &see_pagedown,
  &see_pageup,
  &see_right,
  NULL
};
/*---------------------------------------------------------------------------*/
int main(int argc, char *argv[])
{
  char *s;

  if (argc != 2)
    {
      printf("\nSEE v0.80 (copywrong) 1997-1998 by Edward Boone\n");
      printf("usage : see filename.[BMP|FLC|FLI|GIF|JPG|LBM|PCX|TGA]\n");
      getch();
      return 1;
    }
  if (!exists(argv[1]))
    {
      printf("error:\n");
      printf("(main) !exists(argv[1]\n");
      printf("argv[1] : %s\n", argv[1]);
      getch();
      return 1;
    }

  allegro_init();
  install_timer();

  s = getenv("MI_LOGIN");
  /* MI_LOGIN is not known if you run this program as a standalone program */
  /* e.g. not called from within michelle */
  /* and if the environment variable is not set in autoexec.bat */
  if (!s)
    {
      strcpy(confname, DEFNAME);
      strcpy(intrname, INTRNAME);
    }
  else
    {
      strcpy(loginname, s);
      sprintf(confname, "%smich%s.txt", EXEPATH, loginname);
      sprintf(intrname, "%sintr%s.txt", UTILPATH, loginname);
    }
  set_config_file(confname);

  pbmpo = create_bitmapm(320, 200);
  see_picture(argv[1]);

  init_count_see();
  init_table_see();
  effect_mode = 0;

  main_loops();

  destroy_bitmapm(pbmp);
  destroy_bitmapm(pbmpo);
  free_table_see();
  return 0;
}
/*---------------------------------------------------------------------------*/
void clear_table()
{
  empty_string = cc + 2;
  curr_bit_size = bit_size + 1;
  bit_overflow = 0;
}
/*---------------------------------------------------------------------------*/
void free_table_see()
{
  int i;

  for (i = 0; i <= count_see; i++)
    {
      free(table_see[i]);
    }
  free(table_see);
}
/*---------------------------------------------------------------------------*/
void gif_get_code()
{
  if (bit_pos + curr_bit_size > 8)
    {
      if (data_pos >= data_len)
	{
	  data_len = pack_getc(ppackfile);
	  data_pos = 0;
	}
      entire = (pack_getc(ppackfile) << 8) + entire;
      data_pos++;
    }
  if (bit_pos + curr_bit_size > 16)
    {
      if (data_pos >= data_len)
	{
	  data_len = pack_getc(ppackfile);
	  data_pos = 0;
	}
      entire = (pack_getc(ppackfile) << 16) + entire;
      data_pos++;
    }
  code = (entire >> bit_pos) & ((1 << curr_bit_size) - 1);
  if (bit_pos + curr_bit_size > 8)
    {
      entire >>= 8;
    }
  if (bit_pos + curr_bit_size > 16)
    {
      entire >>= 8;
    }
  bit_pos = (bit_pos + curr_bit_size) % 8;
  if (bit_pos == 0)
    {
      if (data_pos >= data_len)
	{
	  data_len = pack_getc(ppackfile);
	  data_pos = 0;
	}
      entire = pack_getc(ppackfile);
      data_pos++;
    }
}
/*---------------------------------------------------------------------------*/
void gif_get_string(int num)
{
  if (num < cc)
    {
      string_length = 1;
      string[0] = str[num].new;
    }
  else
    {
      gif_i = str[num].length;
      string_length = gif_i;
      while (gif_i > 0)
	{
	  gif_i--;
	  string[gif_i] = str[num].new;
	  num = str[num].base;
	}
    }
}
/*---------------------------------------------------------------------------*/
void gif_output_string()
{
  for (gif_i = 0; gif_i < string_length; gif_i++)
    {
      putpixel(bmp, x, y, string[gif_i]);
      x++;
      if (x >= image_x + image_w)
	{
	  x = image_x;
	  y += interlace;
	  if (interlace)
	    {
	      if (y >= image_y + image_h)
		{
		  if (interlace == 8 && (y - image_y) % 8 == 0)
		    {
		      interlace = 8;
		      y = image_y + 4;
		    }
		  else
		    if (interlace == 8 && (y - image_y) % 8 == 4)
		      {
			interlace = 4;
			y = image_y + 2;
		      }
		    else
		      if (interlace == 4)
			{
			  interlace = 2;
			  y = image_y + 1;
			}
		}
	    }
	}
    }
}
/*---------------------------------------------------------------------------*/
void init_count_see()
{
  DIR *pdir = opendir(".");
  struct dirent *pdirent;
  uchr d[MAXDRIVE], e[MAXEXT], f[MAXFILE], p[MAXDIR], s[256];

  count_see = 0;

  pdirent = readdir(pdir);
  while (pdirent)
    {
      strcpy(s, pdirent->d_name);
      fnsplit(s, d, p, f, e);
      /* it's a directory, do nothing */
      if (!access(s, D_OK) ||
	  !strcmp(s, "..") ||
	  !strcmp(s, "."))
	{
	}
      /* it's a file, test extension */
      else if ((!strcmp(".bmp", e)) ||
	       (!strcmp(".gif", e)) ||
	       (!strcmp(".jpg", e)) ||
	       (!strcmp(".lbm", e)) ||
	       (!strcmp(".pcx", e)) ||
	       (!strcmp(".tga", e)))
	{
	  count_see++;
	}
      pdirent = readdir(pdir);
    }
  count_see--;
  closedir(pdir);
}
/*---------------------------------------------------------------------------*/
void init_effect()
{
  BITMAP *temp;

  if ((scr_w != 320) && (scr_h != 200))
    {
      set_color_depth(8);

      temp = create_bitmapm(320, 200);
      stretch_blit(pbmp, temp, 0, 0, pbmp->w, pbmp->h, 0, 0, 320, 200);

      destroy_bitmapm(pbmp);
      pbmp = create_bitmapm(320, 200);
      destroy_bitmapm(pbmpo);
      pbmpo = create_bitmapm(320, 200);

      blit(temp, pbmp, 0, 0, 0, 0, 320, 200);
      set_gfx_modem(GFX_VGA, 320, 200, 0, 0);
      scr_w = SCREEN_W;
      scr_h = SCREEN_H;
      npixels = scr_w * scr_h;
      set_palette(pal);
      get_palette(palo);
      blit(pbmp, screen, 0, 0, 0, 0, 320, 200);
      blit(pbmp, pbmpo, 0, 0, 0, 0, 320, 200);
      destroy_bitmapm(temp);
    }
}
/*---------------------------------------------------------------------------*/
/* don't forget to call free afterwards !!! */
void init_table_see()
{
  DIR *pdir = opendir(".");
  struct dirent *pdirent;
  uchr d[MAXDRIVE], e[MAXEXT], f[MAXFILE], p[MAXDIR], s[256];
  int i = 0;

  table_see = (uchr **) mallocm(count_see * sizeof(uchr *));
  pdirent = readdir(pdir);
  while (pdirent)
    {
      strcpy(s, pdirent->d_name);
      fnsplit(s, d, p, f, e);
      /* it's a directory, do nothing */
      if (!access(s, D_OK) ||
	  !strcmp(s, "..") ||
	  !strcmp(s, "."))
	{
	}
      /* it's a file, test extension */
      else if ((!strcmp(".bmp", e)) ||
	       (!strcmp(".gif", e)) ||
	       (!strcmp(".jpg", e)) ||
	       (!strcmp(".lbm", e)) ||
	       (!strcmp(".pcx", e)) ||
	       (!strcmp(".tga", e)))
	{
	  table_see[i] = (uchr*) mallocm((strlen(s) + 1) * sizeof(uchr *));
	  strcpy(table_see[i], s);
	  i++;
	}
      pdirent = readdir(pdir);
    }
  closedir(pdir);
  init_table_see_index();
}
/*---------------------------------------------------------------------------*/
void init_table_see_index()
{
  int found = 0, i = 0;

  for (i = 0; (i <= count_see) && !found; i++)
    {
      if (!strcmp(retvalsee, table_see[i]))
	{
	  found = 1;
	  table_see_index = i;
	}
    }
}
/*---------------------------------------------------------------------------*/
int key_checker()
{
  int step = FALSE;

  lastkey = 0;
  ptkeyparsetbl = tkeyparsetbl_see;
  if (step)
    {
      key_scan();
      if (lastkey == K_ESC)
	{
	  return 1;
	}
      else
	{
	  return 0;
	}
    }
  else
    {
      if (kbhit())
	{
	  return 1;
	}
      else
	{
	  return 0;
	}
    }
}
/*---------------------------------------------------------------------------*/
/* write pal to .map in DATAPATH */
/* in format 0..255 */
void keysee_end()
{
  uchr d[MAXDRIVE], p[MAXDIR], f[MAXFILE], e[MAXEXT], s[256];

  fnsplit(retvalsee, d, p, f, e);
  sprintf(s, "%s%s%s", DATAPATH, f, ".map");
  writemap(s, pal);
}
/*---------------------------------------------------------------------------*/
void keysee_f1()
{
  effect_mode = 1;
  init_effect();
  keysee_f1_0();
}
/*---------------------------------------------------------------------------*/
void keysee_f2()
{
  effect_mode = 1;
  init_effect();
  keysee_f2_0();
}
/*---------------------------------------------------------------------------*/
void keysee_f3()
{
  effect_mode = 1;
  init_effect();
  keysee_f3_0();
}
/*---------------------------------------------------------------------------*/
void keysee_f4()
{
  effect_mode = 1;
  init_effect();
  keysee_f4_0();
}
/*---------------------------------------------------------------------------*/
void keysee_f5()
{
  effect_mode = 1;
  init_effect();
  keysee_f5_0();
}
/*---------------------------------------------------------------------------*/
void keysee_f6()
{
  effect_mode = 1;
  init_effect();
  keysee_f6_0();
}
/*---------------------------------------------------------------------------*/
void keysee_f7()
{
  effect_mode = 1;
  init_effect();
  keysee_f7_0();
}
/*---------------------------------------------------------------------------*/
void keysee_f8()
{
  effect_mode = 1;
  init_effect();
  keysee_f8_0();
}
/*---------------------------------------------------------------------------*/
void keysee_f9()
{
  effect_mode = 1;
  init_effect();
  keysee_f9_0();
}
/*---------------------------------------------------------------------------*/
void keysee_f10()
{
  effect_mode = 1;
  init_effect();
  keysee_f10_0();
}
/*---------------------------------------------------------------------------*/
void keysee_f11()
{
  effect_mode = 1;
  init_effect();
  keysee_f11_0();
}
/*---------------------------------------------------------------------------*/
void keysee_f12()
{
  effect_mode = 1;
  init_effect();
  keysee_f12_0();
}
/*---------------------------------------------------------------------------*/
void keysee_home()
{
  set_palette(palo);
  get_palette(pal);
}
/*---------------------------------------------------------------------------*/
void keysee_i()
{
  char *s = "", s0[256] = "";
  char *p;
  FILE *t;

  t = NULL;
  s = searchpath(retvalsee);
  p = s;
  if (*p == '.')
    {
      p++;
      getcwd(s0, 100);
      strcat(s0, p);
    }
  cs2doss(s0);
  if (!access(intrname, F_OK))
    {
      t = fopenm(intrname, "at");
      fprintf(t, "%s\n", s0);
    }
  else
    {
      t = fopenm(intrname, "wt");
      fprintf(t, "%s\n", s0);
    }
  fclose(t);
}
/*---------------------------------------------------------------------------*/
void keysee_insert()
{
  blit(pbmpo, pbmp, 0, 0, 0, 0, scr_w, scr_h); /* save pbmpo to pbmp */
  blit(pbmp, screen, 0, 0, 0, 0, scr_w, scr_h);
}
/*---------------------------------------------------------------------------*/
void keysee_left()
{
  if (table_see_index > 0)
    {
      table_see_index--;
    }
  else
    {
      table_see_index = count_see;
    }
  see_picture(table_see[table_see_index]);
  if (effect_mode == 1)
    {
      init_effect();
      if (effect.done)
	{
	  effect.done();
	}
      if (effect.init)
	{
	  effect.init();
	}
    }
}
/*---------------------------------------------------------------------------*/
/* save current screen to .pcx-file in c:\djgpp\contrib\mich\data */
void keysee_pagedown()
{
  uchr d[MAXDRIVE], p[MAXDIR], f[MAXFILE], e[MAXEXT], s[256];
  BITMAP *apbmp;
  PALETTE apal;

  get_palette(apal);
  apbmp = create_sub_bitmap(screen, 0, 0, scr_w, scr_h);
  fnsplit(retvalsee, d, p, f, e);
  sprintf(s, "%s%s.pcx", DATAPATH, f);
  save_bitmap(s, apbmp, apal);
  destroy_bitmapm(apbmp);
}
/*---------------------------------------------------------------------------*/
void keysee_pageup()
{
  blit(pbmpo, pbmp, 0, 0, 0, 0, scr_w, scr_h); /* save pbmpo to pbmp */
  blit(pbmp, screen, 0, 0, 0, 0, scr_w, scr_h);

  set_palette(palo);
  get_palette(pal);
}
/*---------------------------------------------------------------------------*/
void keysee_right()
{
  if (table_see_index < count_see)
    {
      table_see_index++;
    }
  else
    {
      table_see_index = 0;
    }
  see_picture(table_see[table_see_index]);
  if (effect_mode == 1)
    {
      init_effect();
      if (effect.done)
	{
	  effect.done();
	}
      if (effect.init)
	{
	  effect.init();
	}
    }
}
/*---------------------------------------------------------------------------*/
/* load_gif : loads a 2-256 colour GIF file onto a bitmap, returning the */
/* bitmap structure and storing the palette data in the specified palette */
/* (this should be an array of at least 256 RGB structures) */
BITMAP* load_gif(char *filename, RGB *pal)
{
  int width, height, depth;
  int old;
  BITMAP *bmp2;
  int dest_depth;

  ppackfile = pack_fopen(filename, F_READ);
  if (!ppackfile)
    {
      return NULL;
    }

  gif_i = pack_mgetw(ppackfile) << 8;
  gif_i += pack_getc(ppackfile);
  if (gif_i != 0x474946) /* it's not in the GIF-format */
    {
      pack_fclose(ppackfile);
      return NULL;
    }
  pack_fseek(ppackfile, 3); /* skip version */

  width = pack_igetw(ppackfile);
  height = pack_igetw(ppackfile);

  bmp = create_bitmap_ex(8, width, height);
  if (bmp == NULL) /* couldn't create bitmap */
    {
      pack_fclose(ppackfile);
      return NULL;
    }
  clear(bmp);

  gif_i = pack_getc(ppackfile);
  if (gif_i & 128)
    {
      depth = (gif_i & 7) + 1;
    }
  else
    {
      depth = 0; /* no global colour table */
    }

  pack_fseek(ppackfile, 2); /* skip background colour and aspect ratio */

  if (pal && depth) /* only read palette if pal and depth are not 0 */
    {
      for (gif_i = 0; gif_i < (1 << depth); gif_i++)
	{
	  pal[gif_i].r = pack_getc(ppackfile) / 4;
	  pal[gif_i].g = pack_getc(ppackfile) / 4;
	  pal[gif_i].b = pack_getc(ppackfile) / 4;
	}
    }
  else
    if (depth)
      {
	pack_fseek(ppackfile, (1 << depth) * 3);
      }

  do
    {
      gif_i = pack_getc(ppackfile);
      switch (gif_i)
	{
	case 0x2C: /* image descriptor */
	  image_x = pack_igetw(ppackfile); /* individual image dimensions */
	  image_y = pack_igetw(ppackfile);
	  image_w = pack_igetw(ppackfile);
	  image_h = pack_igetw(ppackfile);

	  gif_i = pack_getc(ppackfile);
	  if (gif_i & 64)
	    {
	      interlace = 8;
	    }
	  else
	    {
	      interlace = 1;
	    }

	  if (gif_i & 128)
	    {
	      depth = (gif_i & 7) + 1;
	      if (pal)
		{
		  for (gif_i = 0; gif_i < (1 << depth); gif_i++)
		    {
		      pal[gif_i].r = pack_getc(ppackfile) / 4;
		      pal[gif_i].g = pack_getc(ppackfile) / 4;
		      pal[gif_i].b = pack_getc(ppackfile) / 4;
		    }
		}
	      else
		{
		  pack_fseek(ppackfile, (1 << depth) * 3);
		}
	    }
	  /* lzw stream starts now */
	  bit_size = pack_getc(ppackfile);
	  cc = 1 << bit_size;
	  
	  /* initialise string table */
	  for (gif_i = 0; gif_i < cc; gif_i++)
	    {
	      str[gif_i].base = -1;
	      str[gif_i].new = gif_i;
	      str[gif_i].length = 1;
	    }

	  /* initialise the variables */
	  bit_pos = 0;
	  data_len = pack_getc(ppackfile);
	  data_pos = 0;
	  entire = pack_getc(ppackfile);
	  data_pos++;
	  string_length = 0;
	  x = image_x;
	  y = image_y;

	  /* starting code */
	  clear_table();
	  gif_get_code();
	  if (code == cc)
	    {
	      gif_get_code();
	    }
	  gif_get_string(code);
	  gif_output_string();
	  old = code;
	  
	  while (TRUE)
	    {
	      gif_get_code();
	      
	      if (code == cc)
		{
		  /* starting code */
		  clear_table();
		  gif_get_code();
		  gif_get_string(code);
		  gif_output_string();
		  old = code;
		}
	      else if (code == cc + 1)
		  {
		    break;
		  }
		else if (code < empty_string)
		    {
		      gif_get_string(code);
		      gif_output_string();
		      
		      if (bit_overflow == 0)
			{
			  str[empty_string].base = old;
			  str[empty_string].new = string[0];
			  str[empty_string].length = str[old].length + 1;
			  empty_string++;
			  if (empty_string == (1 << curr_bit_size))
			    {
			      curr_bit_size++;
			    }
			  if (curr_bit_size == 13)
			    {
			      curr_bit_size = 12;
			      bit_overflow = 1;
			    }
			}
		      old = code;
		    }
		  else
		    {
		      gif_get_string(old);
		      string[str[old].length] = string[0];
		      string_length++;
		      
		      if (bit_overflow == 0)
			{
			  str[empty_string].base = old;
			  str[empty_string].new = string[0];
			  str[empty_string].length = str[old].length + 1;
			  empty_string++;
			  if (empty_string == (1 << curr_bit_size))
			    {
			      curr_bit_size++;
			    }
			  if (curr_bit_size == 13)
			    {
			      curr_bit_size = 12;
			      bit_overflow = 1;
			    }
			}
		      gif_output_string();
		      old = code;
		    }
	    }
	  break;
	case 0x21: /* extension introducer */
	  gif_i = pack_getc(ppackfile);
	  if (gif_i == 0xF9) /* graphic control extension */
	    {
	      pack_fseek(ppackfile, 1); /* skip size (it's 4) */
	      gif_i = pack_getc(ppackfile);
	      if (gif_i & 1) /* is transparency enabled ? */
		{
		  pack_fseek(ppackfile, 2);
		  pack_getc(ppackfile); /* transparent colour */
		}
	      else
		pack_fseek(ppackfile, 3);
	    }
	  gif_i = pack_getc(ppackfile);
	  while (gif_i) /* skip data sub-blocks */
	    {
	      pack_fseek(ppackfile, gif_i);
	      gif_i = pack_getc(ppackfile);
	    }
	  break;
	case 0x3B: /* trailer - end of data */
	  pack_fclose(ppackfile);
	  /* convert to correct colour depth */
	  dest_depth = _color_load_depth(8);
	  if (dest_depth != 8)
	    {
	      bmp2 = create_bitmap_ex(dest_depth, bmp->w, bmp->h);
	      if (!bmp2)
		{
		  destroy_bitmapm(bmp);
		  return NULL;
		}
	      select_palette(pal);
	      blit(bmp, bmp2, 0, 0, 0, 0, bmp->w, bmp->h);
	      unselect_palette();
	      destroy_bitmapm(bmp);
	      bmp = bmp2;
	    }
	  return bmp;
	}
    }
  while (TRUE);
  /* this is never executed but DJGPP complains if you leave it out */
  return NULL;
}
/*---------------------------------------------------------------------------*/
/* same as load_gif, but displays an appropriate message when it failed */
BITMAP* load_gifm(char *filename, RGB *pal)
{
  BITMAP *apbmp;

  if (!(apbmp = load_gif(filename, pal))) /* test if NULL */
    {
      printf("error:\n");
      printf("(load_gifm) !(apbmp = load_gif(filename, pal))\n");
      printf("filename : %s\n", filename);
      getch();
      exit(1);
    }
  return apbmp;
}
/*---------------------------------------------------------------------------*/
/* same as load_jpeg, but displays an appropriate message when it failed */
BITMAP* load_jpegm(char *filename, RGB *pal)
{
  BITMAP *apbmp;

  if (!(apbmp = load_jpeg(filename, pal))) /* test if NULL */
    {
      printf("error:\n");
      printf("(load_jpegm) !(apbmp = load_jpeg(filename, pal))\n");
      printf("filename : %s\n", filename);
      getch();
      exit(1);
    }
  return apbmp;
}
/*---------------------------------------------------------------------------*/
void main_loops()
{
  do
    {
      ptkeyparsetbl = tkeyparsetbl_see;
      key_scan();
    }
  while (lastkey != K_ESC);
}
/*---------------------------------------------------------------------------*/
void scan_vga()
{
  int h, finish = FALSE, vga, w;

  vga = get_config_int("[graphics]", "gfx_card", 3);
  if (pbmp->w <= 320 && pbmp->h <= 200)
    {
      vga = GFX_VGA;
      w = 320;
      h = 200;
    }
  else if (pbmp->w <= 640 && pbmp->h <= 480)
    {
      w = 640;
      h = 480;
    }
  else if (pbmp->w <= 800 && pbmp->h <= 600)
    {
      w = 800;
      h = 600;
    }
  else
    {
      w = 1024;
      h = 768;
    }
  do
    {
      if (set_gfx_mode(vga, w, h, 0, 0))
	{
	  if (w == 1024)
	    {
	      w = 800;
	      h = 600;
	    }
	  else if (w == 800)
	    {
	      w = 640;
	      h = 480;
	    }
	  else if (w == 640)
	    {
	      vga = GFX_VGA;
	      w = 320;
	      h = 200;
	    }
	  else
	    {
	      printf("error:\n");
	      printf("(scan_vga) set_gfx_mode(vga, w, h, 0, 0)\n");
	      printf("vga = %i\n", vga);
	      printf("w = %i\n", w);
	      printf("h = %i\n", h);
	      getch();
	      exit(1);
	    }
	}
      else
	{
	  finish = TRUE;
	}
    }
  while (!finish);
  scr_w = SCREEN_W;
  scr_h = SCREEN_H;
  npixels = scr_w * scr_h;
}
/*---------------------------------------------------------------------------*/
void see_fli()
{
  int loop = TRUE;
  int ret;

  set_gfx_modem(GFX_VGA, 320, 200, 0, 0);
  scr_w = SCREEN_W;
  scr_h = SCREEN_H;
  npixels = scr_w * scr_h;
  ret = play_fli(retvalsee, screen, loop, key_checker);
  if (ret < 0)
    {
      printf("error:\n");
      printf("(see_fli) ret < 0\n");
      printf("filename : %s\n", retvalsee);
      printf("loop : %i\n", loop);
      getch();
      exit(1);
    }
}
/*---------------------------------------------------------------------------*/
void see_gif()
{
  destroy_bitmapm(pbmp);
  pbmp = load_gifm(retvalsee, pal);
  destroy_bitmapm(pbmpo);
  pbmpo = load_gifm(retvalsee, pal);
  scan_vga();
  set_palette(pal);
  get_palette(palo);
  blit(pbmp, screen, 0, 0, (scr_w - pbmp->w) / 2, (scr_h - pbmp->h) / 2, pbmp->w, pbmp->h);
}
/*---------------------------------------------------------------------------*/
void see_jpg()
{
  destroy_bitmapm(pbmp);
  pbmp = load_jpegm(retvalsee, pal);
  destroy_bitmapm(pbmpo);
  pbmpo = load_jpegm(retvalsee, pal);
  scan_vga();
  set_palette(pal);
  get_palette(palo);
  blit(pbmp, screen, 0, 0, (scr_w - pbmp->w) / 2, (scr_h - pbmp->h) / 2, pbmp->w, pbmp->h);
}
/*---------------------------------------------------------------------------*/
void see_picture(char *filename)
{
  char d[MAXDRIVE], p[MAXDIR], f[MAXFILE], e[MAXEXT];
  int choice = 0; /* choice default to BMP|LBM|PCX|TGA */

  strcpy(retvalsee, filename);
  fnsplit(filename, d, p, f, e);
  strlwr(e);
  if (!strcmp(e, ".bmp")) choice = 0;
  else if (!strcmp(e, ".flc")) choice = 1;
  else if (!strcmp(e, ".fli")) choice = 1;
  else if (!strcmp(e, ".gif")) choice = 2;
  else if (!strcmp(e, ".jpg")) choice = 3;
  else if (!strcmp(e, ".lbm")) choice = 0;
  else if (!strcmp(e, ".pcx")) choice = 0;
  else if (!strcmp(e, ".tga")) choice = 0;
  switch(choice)
    {
    case 0:
      {
	see_xxx();
	break;
      }
    case 1:
      {
	see_fli();
	break;
      }
    case 2:
      {
	see_gif();
	break;
      }
    case 3:
      {
	see_jpg();
	break;
      }
    }
}
/*---------------------------------------------------------------------------*/
void see_xxx()
{
  destroy_bitmapm(pbmp);
  pbmp = load_bitmapm(retvalsee, pal);
  destroy_bitmapm(pbmpo);
  pbmpo = load_bitmapm(retvalsee, pal);
  scan_vga();
  set_palette(pal);
  get_palette(palo);
  blit(pbmp, screen, 0, 0, (scr_w - pbmp->w) / 2, (scr_h - pbmp->h) / 2,
       pbmp->w, pbmp->h);
}
/*---------------------------------------------------------------------------*/
/* writes apal in a .map-file in 0..255 format */
void writemap(char s[256], PALETTE apal)
{
  int i = 0;
  FILE *fp;

  fp = fopenm(s, "wt");
  for (i = 0; i < 256; i++)
    {
      fprintf(fp, "%i ", apal[i].r * 4);
      fprintf(fp, "%i ", apal[i].g * 4);
      fprintf(fp, "%i\n", apal[i].b * 4);
    }
  fclose(fp);
}
