// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "DFE32.h"
#include "normal.h"
#include "MainFrm.h"
#include "ideoptionsdialog.h"
#include "dfe32doc.h"
#include "dfe32view.h"
#include "childfrm.h"
#include "messageframe.h"
#include "messageview.h"
#include "postmessage.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_COMMAND(ID_VIEW_OPTIONS, OnViewOptions)
	ON_WM_CONTEXTMENU()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	char buffer[500];
	if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	if (!m_wndToolBar.Create(this) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;
	}
	m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);

	// TODO: Delete these three lines if you don't want the toolbar to
	//  be dockable

	// OK!

//	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
//	EnableDocking(CBRS_ALIGN_ANY);
//	DockControlBar(&m_wndToolBar);

	currfont = new CFont;
	GetPrivateProfileString("Options","GCC Path","gcc.exe",buffer,sizeof(buffer),
		"Dfe32.ini"); 
	gccpath = buffer;
	if (gccpath == "gcc.exe")
		AfxMessageBox("It appears that you have not yet set your gcc path in the View->Options menu.  DFE95 may not work correctly until you do!");
	GetPrivateProfileString("Options","GDB Path","gdb.exe",buffer,sizeof(buffer),
		"Dfe32.ini"); 
	gdbpath = buffer;
	GetPrivateProfileString("Options","Make Path","make.exe",buffer,sizeof(buffer),
		"Dfe32.ini"); 
	makepath = buffer;
	debugdefault = (BOOL)GetPrivateProfileInt("Options","Debug Default",TRUE,
		"Dfe32.ini");
	indent = (BOOL)GetPrivateProfileInt("Options","Auto Indent",TRUE,
		"Dfe32.ini");
	LOGFONT lf;
	if (GetPrivateProfileStruct("Options","Font", &lf,sizeof(LOGFONT),
		"Dfe32.ini") == TRUE)
	currfont->CreateFontIndirect(&lf);
	clear = (BOOL)GetPrivateProfileInt("Options","Clear",TRUE,
		"Dfe32.ini");
	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	cs.style = WS_OVERLAPPED | WS_CAPTION | FWS_ADDTOTITLE
		| WS_THICKFRAME | WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX | WS_MAXIMIZE;

	return CMDIFrameWnd::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CMDIFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

void CMainFrame::OnViewOptions() 
{
	CIDEOptionsDialog dlg;
	CChildFrame *cframe;
	if (dlg.DoModal() == IDOK)
	{
		// update all the windows for the new font
		// this may not be very good-looking or slick, but it works
		MDIActivate(GlobalMessageView->GetParentFrame());
		do
		{
			MDINext();
			if (cframe = dynamic_cast<CChildFrame*>(MDIGetActive()))
			{
				cframe->GetActiveView()->SetFont(currfont);
			}
		} while ((CMessageFrame *)MDIGetActive() != 
			GlobalMessageView->GetParentFrame());
	}
}

void CMainFrame::OnContextMenu(CWnd* pWnd, CPoint point) 
{
	CMenu menu;
	if (menu.LoadMenu(IDR_MAINPOP_MENU))
	{
		CMenu* pPopup = menu.GetSubMenu(0);
		ASSERT(pPopup != NULL);
		pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON,point.x, point.y,
			AfxGetMainWnd());
	}	
}
