/* poppler-glib.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Poppler", gir_namespace = "Poppler", gir_version = "0.18", lower_case_cprefix = "poppler_")]
namespace Poppler {
	namespace AnnotTextIcon {
		[CCode (cheader_filename = "poppler.h", cname = "POPPLER_ANNOT_TEXT_ICON_CIRCLE")]
		public const string CIRCLE;
		[CCode (cheader_filename = "poppler.h", cname = "POPPLER_ANNOT_TEXT_ICON_COMMENT")]
		public const string COMMENT;
		[CCode (cheader_filename = "poppler.h", cname = "POPPLER_ANNOT_TEXT_ICON_CROSS")]
		public const string CROSS;
		[CCode (cheader_filename = "poppler.h", cname = "POPPLER_ANNOT_TEXT_ICON_HELP")]
		public const string HELP;
		[CCode (cheader_filename = "poppler.h", cname = "POPPLER_ANNOT_TEXT_ICON_INSERT")]
		public const string INSERT;
		[CCode (cheader_filename = "poppler.h", cname = "POPPLER_ANNOT_TEXT_ICON_KEY")]
		public const string KEY;
		[CCode (cheader_filename = "poppler.h", cname = "POPPLER_ANNOT_TEXT_ICON_NEW_PARAGRAPH")]
		public const string NEW_PARAGRAPH;
		[CCode (cheader_filename = "poppler.h", cname = "POPPLER_ANNOT_TEXT_ICON_NOTE")]
		public const string NOTE;
		[CCode (cheader_filename = "poppler.h", cname = "POPPLER_ANNOT_TEXT_ICON_PARAGRAPH")]
		public const string PARAGRAPH;
	}
	[CCode (cheader_filename = "poppler.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "poppler_action_get_type ()")]
	[Compact]
	public class Action {
		public Poppler.ActionAny any;
		public Poppler.ActionGotoDest goto_dest;
		public Poppler.ActionGotoRemote goto_remote;
		public Poppler.ActionJavascript javascript;
		public Poppler.ActionLaunch launch;
		public Poppler.ActionMovie movie;
		public Poppler.ActionNamed named;
		public Poppler.ActionOCGState ocg_state;
		public Poppler.ActionRendition rendition;
		public Poppler.ActionType type;
		public Poppler.ActionUri uri;
		public Poppler.Action copy ();
		public void free ();
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_annot_get_type ()")]
	public class Annot : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Annot ();
		public Poppler.AnnotType get_annot_type ();
		public Poppler.Color get_color ();
		public string get_contents ();
		public Poppler.AnnotFlag get_flags ();
		public string get_modified ();
		public string get_name ();
		[Version (since = "0.14")]
		public int get_page_index ();
		[Version (since = "0.26")]
		public Poppler.Rectangle get_rectangle ();
		[Version (since = "0.16")]
		public void set_color (Poppler.Color? poppler_color);
		[Version (since = "0.12")]
		public void set_contents (string contents);
		[Version (since = "0.22")]
		public void set_flags (Poppler.AnnotFlag flags);
		[Version (since = "0.26")]
		public void set_rectangle (Poppler.Rectangle poppler_rect);
	}
	[CCode (cheader_filename = "poppler.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "poppler_annot_callout_line_get_type ()")]
	[Compact]
	public class AnnotCalloutLine {
		public bool multiline;
		public double x1;
		public double x2;
		public double x3;
		public double y1;
		public double y2;
		public double y3;
		[CCode (has_construct_function = false)]
		public AnnotCalloutLine ();
		public Poppler.AnnotCalloutLine copy ();
		public void free ();
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_annot_circle_get_type ()")]
	public class AnnotCircle : Poppler.AnnotMarkup {
		[CCode (has_construct_function = false, type = "PopplerAnnot*")]
		[Version (since = "0.26")]
		public AnnotCircle (Poppler.Document doc, Poppler.Rectangle rect);
		[Version (since = "0.26")]
		public Poppler.Color get_interior_color ();
		[Version (since = "0.26")]
		public void set_interior_color (Poppler.Color? poppler_color);
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_annot_file_attachment_get_type ()")]
	public class AnnotFileAttachment : Poppler.AnnotMarkup {
		[CCode (has_construct_function = false)]
		protected AnnotFileAttachment ();
		[Version (since = "0.14")]
		public Poppler.Attachment get_attachment ();
		[Version (since = "0.14")]
		public string get_name ();
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_annot_free_text_get_type ()")]
	public class AnnotFreeText : Poppler.AnnotMarkup {
		[CCode (has_construct_function = false)]
		protected AnnotFreeText ();
		public Poppler.AnnotCalloutLine get_callout_line ();
		public Poppler.AnnotFreeTextQuadding get_quadding ();
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_annot_line_get_type ()")]
	public class AnnotLine : Poppler.AnnotMarkup {
		[CCode (has_construct_function = false, type = "PopplerAnnot*")]
		[Version (since = "0.26")]
		public AnnotLine (Poppler.Document doc, Poppler.Rectangle rect, Poppler.Point start, Poppler.Point end);
		[Version (since = "0.26")]
		public void set_vertices (Poppler.Point start, Poppler.Point end);
	}
	[CCode (cheader_filename = "poppler.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "poppler_annot_mapping_get_type ()")]
	[Compact]
	public class AnnotMapping {
		public Poppler.Annot annot;
		public Poppler.Rectangle area;
		[CCode (has_construct_function = false)]
		public AnnotMapping ();
		public Poppler.AnnotMapping copy ();
		public void free ();
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_annot_markup_get_type ()")]
	public class AnnotMarkup : Poppler.Annot {
		[CCode (has_construct_function = false)]
		protected AnnotMarkup ();
		public GLib.Date? get_date ();
		public Poppler.AnnotExternalDataType get_external_data ();
		public string get_label ();
		public double get_opacity ();
		public bool get_popup_is_open ();
		[Version (since = "0.12")]
		public bool get_popup_rectangle (out Poppler.Rectangle poppler_rect);
		public Poppler.AnnotMarkupReplyType get_reply_to ();
		public string get_subject ();
		[Version (since = "0.12")]
		public bool has_popup ();
		[Version (since = "0.16")]
		public void set_label (string? label);
		[Version (since = "0.16")]
		public void set_opacity (double opacity);
		[Version (since = "0.16")]
		public void set_popup (Poppler.Rectangle popup_rect);
		[Version (since = "0.16")]
		public void set_popup_is_open (bool is_open);
		[Version (since = "0.33")]
		public void set_popup_rectangle (Poppler.Rectangle poppler_rect);
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_annot_movie_get_type ()")]
	public class AnnotMovie : Poppler.Annot {
		[CCode (has_construct_function = false)]
		protected AnnotMovie ();
		[Version (since = "0.14")]
		public unowned Poppler.Movie get_movie ();
		[Version (since = "0.14")]
		public string get_title ();
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_annot_screen_get_type ()")]
	public class AnnotScreen : Poppler.Annot {
		[CCode (has_construct_function = false)]
		protected AnnotScreen ();
		[Version (since = "0.14")]
		public unowned Poppler.Action get_action ();
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_annot_square_get_type ()")]
	public class AnnotSquare : Poppler.AnnotMarkup {
		[CCode (has_construct_function = false, type = "PopplerAnnot*")]
		[Version (since = "0.26")]
		public AnnotSquare (Poppler.Document doc, Poppler.Rectangle rect);
		[Version (since = "0.26")]
		public Poppler.Color get_interior_color ();
		[Version (since = "0.26")]
		public void set_interior_color (Poppler.Color? poppler_color);
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_annot_text_get_type ()")]
	public class AnnotText : Poppler.AnnotMarkup {
		[CCode (has_construct_function = false, type = "PopplerAnnot*")]
		[Version (since = "0.16")]
		public AnnotText (Poppler.Document doc, Poppler.Rectangle rect);
		public string get_icon ();
		public bool get_is_open ();
		public Poppler.AnnotTextState get_state ();
		[Version (since = "0.16")]
		public void set_icon (string icon);
		[Version (since = "0.16")]
		public void set_is_open (bool is_open);
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_annot_text_markup_get_type ()")]
	public class AnnotTextMarkup : Poppler.AnnotMarkup {
		[CCode (has_construct_function = false)]
		protected AnnotTextMarkup ();
		[Version (since = "0.26")]
		public GLib.Array<Poppler.Quadrilateral> get_quadrilaterals ();
		[CCode (has_construct_function = false, type = "PopplerAnnot*")]
		[Version (since = "0.26")]
		public AnnotTextMarkup.highlight (Poppler.Document doc, Poppler.Rectangle rect, GLib.Array<Poppler.Quadrilateral> quadrilaterals);
		[Version (since = "0.26")]
		public void set_quadrilaterals (GLib.Array<Poppler.Quadrilateral> quadrilaterals);
		[CCode (has_construct_function = false, type = "PopplerAnnot*")]
		[Version (since = "0.26")]
		public AnnotTextMarkup.squiggly (Poppler.Document doc, Poppler.Rectangle rect, GLib.Array<Poppler.Quadrilateral> quadrilaterals);
		[CCode (has_construct_function = false, type = "PopplerAnnot*")]
		[Version (since = "0.26")]
		public AnnotTextMarkup.strikeout (Poppler.Document doc, Poppler.Rectangle rect, GLib.Array<Poppler.Quadrilateral> quadrilaterals);
		[CCode (has_construct_function = false, type = "PopplerAnnot*")]
		[Version (since = "0.26")]
		public AnnotTextMarkup.underline (Poppler.Document doc, Poppler.Rectangle rect, GLib.Array<Poppler.Quadrilateral> quadrilaterals);
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_attachment_get_type ()")]
	public class Attachment : GLib.Object {
		public GLib.StringBuilder checksum;
		public GLib.Time ctime;
		public string description;
		public GLib.Time mtime;
		public string name;
		public size_t size;
		[CCode (has_construct_function = false)]
		protected Attachment ();
		public bool save (string filename) throws GLib.Error;
		public bool save_to_callback (Poppler.AttachmentSaveFunc save_func) throws GLib.Error;
	}
	[CCode (cheader_filename = "poppler.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "poppler_color_get_type ()")]
	[Compact]
	public class Color {
		public uint16 blue;
		public uint16 green;
		public uint16 red;
		[CCode (has_construct_function = false)]
		public Color ();
		public Poppler.Color copy ();
		public void free ();
	}
	[CCode (cheader_filename = "poppler.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "poppler_dest_get_type ()")]
	[Compact]
	public class Dest {
		public double bottom;
		public uint change_left;
		public uint change_top;
		public uint change_zoom;
		public double left;
		public string named_dest;
		public int page_num;
		public double right;
		public double top;
		public Poppler.DestType type;
		public double zoom;
		public Poppler.Dest copy ();
		public void free ();
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_document_get_type ()")]
	public class Document : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Document ();
		public Poppler.Dest find_dest (string link_name);
		[CCode (has_construct_function = false)]
		public Document.from_data (string data, int length, string? password) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public Document.from_file (string uri, string? password) throws GLib.Error;
		[CCode (has_construct_function = false)]
		[Version (since = "0.22")]
		public Document.from_gfile (GLib.File file, string? password, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[CCode (has_construct_function = false)]
		[Version (since = "0.22")]
		public Document.from_stream (GLib.InputStream stream, int64 length, string? password, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public GLib.List<Poppler.Attachment> get_attachments ();
		[Version (since = "0.16")]
		public string get_author ();
		[Version (since = "0.16")]
		public long get_creation_date ();
		[Version (since = "0.16")]
		public string get_creator ();
		public Poppler.FormField get_form_field (int id);
		[Version (since = "0.16")]
		public bool get_id (out string permanent_id, out string update_id);
		[Version (since = "0.16")]
		public string get_keywords ();
		[Version (since = "0.16")]
		public string get_metadata ();
		[Version (since = "0.16")]
		public long get_modification_date ();
		[Version (since = "0.18")]
		public uint get_n_attachments ();
		public int get_n_pages ();
		public Poppler.Page get_page (int index);
		public Poppler.Page get_page_by_label (string label);
		[Version (since = "0.16")]
		public Poppler.PageLayout get_page_layout ();
		[Version (since = "0.16")]
		public Poppler.PageMode get_page_mode ();
		[Version (since = "0.16")]
		public void get_pdf_version (out uint major_version, out uint minor_version);
		[Version (since = "0.16")]
		public string get_pdf_version_string ();
		[Version (since = "0.16")]
		public Poppler.Permissions get_permissions ();
		[Version (since = "0.16")]
		public string get_producer ();
		[Version (since = "0.16")]
		public string get_subject ();
		[Version (since = "0.16")]
		public string get_title ();
		public bool has_attachments ();
		[Version (since = "0.16")]
		public bool is_linearized ();
		public bool save (string uri) throws GLib.Error;
		public bool save_a_copy (string uri) throws GLib.Error;
		[Version (since = "0.46")]
		public void set_author (string author);
		[Version (since = "0.46")]
		public void set_creation_date (long creation_date);
		[Version (since = "0.46")]
		public void set_creator (string creator);
		[Version (since = "0.46")]
		public void set_keywords (string keywords);
		[Version (since = "0.46")]
		public void set_modification_date (long modification_date);
		[Version (since = "0.46")]
		public void set_producer (string producer);
		[Version (since = "0.46")]
		public void set_subject (string subject);
		[Version (since = "0.46")]
		public void set_title (string title);
		public string author { owned get; set; }
		public int creation_date { get; set; }
		public string creator { owned get; set; }
		[NoAccessorMethod]
		public string format { owned get; }
		[NoAccessorMethod]
		public uint format_major { get; }
		[NoAccessorMethod]
		public uint format_minor { get; }
		public string keywords { owned get; set; }
		[NoAccessorMethod]
		public bool linearized { get; }
		public string metadata { owned get; }
		[NoAccessorMethod]
		public int mod_date { get; set; }
		public Poppler.PageLayout page_layout { get; }
		public Poppler.PageMode page_mode { get; }
		public Poppler.Permissions permissions { get; }
		public string producer { owned get; set; }
		public string subject { owned get; set; }
		public string title { owned get; set; }
		[NoAccessorMethod]
		public Poppler.ViewerPreferences viewer_preferences { get; }
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_font_info_get_type ()")]
	public class FontInfo : GLib.Object {
		[CCode (has_construct_function = false)]
		public FontInfo (Poppler.Document document);
		public void free ();
		public bool scan (int n_pages, out Poppler.FontsIter iter);
	}
	[CCode (cheader_filename = "poppler.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "poppler_fonts_iter_get_type ()")]
	[Compact]
	public class FontsIter {
		public Poppler.FontsIter copy ();
		public void free ();
		[Version (since = "0.20")]
		public unowned string get_encoding ();
		public unowned string get_file_name ();
		public Poppler.FontType get_font_type ();
		public unowned string get_full_name ();
		public unowned string get_name ();
		[Version (since = "0.20")]
		public unowned string get_substitute_name ();
		public bool is_embedded ();
		public bool is_subset ();
		public bool next ();
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_form_field_get_type ()")]
	public class FormField : GLib.Object {
		[CCode (has_construct_function = false)]
		protected FormField ();
		public Poppler.FormButtonType button_get_button_type ();
		public bool button_get_state ();
		public void button_set_state (bool state);
		public bool choice_can_select_multiple ();
		public bool choice_commit_on_change ();
		public bool choice_do_spell_check ();
		public Poppler.FormChoiceType choice_get_choice_type ();
		public string choice_get_item (int index);
		public int choice_get_n_items ();
		public string choice_get_text ();
		public bool choice_is_editable ();
		public bool choice_is_item_selected (int index);
		public void choice_select_item (int index);
		public void choice_set_text (string text);
		public void choice_toggle_item (int index);
		public void choice_unselect_all ();
		[Version (since = "0.18")]
		public unowned Poppler.Action get_action ();
		public Poppler.FormFieldType get_field_type ();
		public double get_font_size ();
		public int get_id ();
		[Version (since = "0.16")]
		public string get_mapping_name ();
		[Version (since = "0.16")]
		public string get_name ();
		[Version (since = "0.16")]
		public string get_partial_name ();
		public bool is_read_only ();
		public bool text_do_scroll ();
		public bool text_do_spell_check ();
		public int text_get_max_len ();
		public string text_get_text ();
		public Poppler.FormTextType text_get_text_type ();
		public bool text_is_password ();
		public bool text_is_rich_text ();
		public void text_set_text (string text);
	}
	[CCode (cheader_filename = "poppler.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "poppler_form_field_mapping_get_type ()")]
	[Compact]
	public class FormFieldMapping {
		public Poppler.Rectangle area;
		public Poppler.FormField field;
		[CCode (has_construct_function = false)]
		public FormFieldMapping ();
		public Poppler.FormFieldMapping copy ();
		public void free ();
	}
	[CCode (cheader_filename = "poppler.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "poppler_image_mapping_get_type ()")]
	[Compact]
	public class ImageMapping {
		public Poppler.Rectangle area;
		public int image_id;
		[CCode (has_construct_function = false)]
		public ImageMapping ();
		public Poppler.ImageMapping copy ();
		public void free ();
	}
	[CCode (cheader_filename = "poppler.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "poppler_index_iter_get_type ()")]
	[Compact]
	public class IndexIter {
		[CCode (has_construct_function = false)]
		public IndexIter (Poppler.Document document);
		public Poppler.IndexIter copy ();
		public void free ();
		public Poppler.Action get_action ();
		public Poppler.IndexIter get_child ();
		public bool is_open ();
		public bool next ();
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_layer_get_type ()")]
	public class Layer : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Layer ();
		[Version (since = "0.12")]
		public int get_radio_button_group_id ();
		[Version (since = "0.12")]
		public unowned string get_title ();
		[Version (since = "0.12")]
		public void hide ();
		[Version (since = "0.12")]
		public bool is_parent ();
		[Version (since = "0.12")]
		public bool is_visible ();
		[Version (since = "0.12")]
		public void show ();
	}
	[CCode (cheader_filename = "poppler.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "poppler_layers_iter_get_type ()")]
	[Compact]
	public class LayersIter {
		[CCode (has_construct_function = false)]
		[Version (since = "0.12")]
		public LayersIter (Poppler.Document document);
		public Poppler.LayersIter copy ();
		[Version (since = "0.12")]
		public void free ();
		[Version (since = "0.12")]
		public Poppler.LayersIter get_child ();
		[Version (since = "0.12")]
		public Poppler.Layer get_layer ();
		[Version (since = "0.12")]
		public string get_title ();
		[Version (since = "0.12")]
		public bool next ();
	}
	[CCode (cheader_filename = "poppler.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "poppler_link_mapping_get_type ()")]
	[Compact]
	public class LinkMapping {
		public Poppler.Action action;
		public Poppler.Rectangle area;
		[CCode (has_construct_function = false)]
		public LinkMapping ();
		public Poppler.LinkMapping copy ();
		public void free ();
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_media_get_type ()")]
	public class Media : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Media ();
		[Version (since = "0.14")]
		public unowned string get_filename ();
		[Version (since = "0.14")]
		public unowned string get_mime_type ();
		[Version (since = "0.14")]
		public bool is_embedded ();
		[Version (since = "0.14")]
		public bool save (string filename) throws GLib.Error;
		[Version (since = "0.14")]
		public bool save_to_callback (Poppler.MediaSaveFunc save_func) throws GLib.Error;
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_movie_get_type ()")]
	public class Movie : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Movie ();
		[Version (since = "0.14")]
		public unowned string get_filename ();
		[Version (since = "0.14")]
		public bool need_poster ();
		[Version (since = "0.14")]
		public bool show_controls ();
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_ps_file_get_type ()")]
	public class PSFile : GLib.Object {
		[CCode (has_construct_function = false)]
		public PSFile (Poppler.Document document, string filename, int first_page, int n_pages);
		public void free ();
		public void set_duplex (bool duplex);
		public void set_paper_size (double width, double height);
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_page_get_type ()")]
	public class Page : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Page ();
		[Version (since = "0.16")]
		public void add_annot (Poppler.Annot annot);
		public GLib.List<Poppler.Rectangle> find_text (string text);
		[Version (since = "0.22")]
		public GLib.List<Poppler.Rectangle> find_text_with_options (string text, Poppler.FindFlags options);
		public static void free_annot_mapping (GLib.List<Poppler.AnnotMapping> list);
		public static void free_form_field_mapping (GLib.List<Poppler.FormFieldMapping> list);
		public static void free_image_mapping (GLib.List<Poppler.ImageMapping> list);
		public static void free_link_mapping (GLib.List<Poppler.LinkMapping> list);
		[Version (since = "0.18")]
		public static void free_text_attributes (GLib.List<Poppler.TextAttributes> list);
		public GLib.List<Poppler.AnnotMapping> get_annot_mapping ();
		public Poppler.Rectangle get_crop_box ();
		public double get_duration ();
		public GLib.List<Poppler.FormFieldMapping> get_form_field_mapping ();
		public Cairo.Surface get_image (int image_id);
		public GLib.List<Poppler.ImageMapping> get_image_mapping ();
		public int get_index ();
		[Version (since = "0.16")]
		public string get_label ();
		public GLib.List<Poppler.LinkMapping> get_link_mapping ();
		[Version (since = "0.16")]
		public Cairo.Region get_selected_region (double scale, Poppler.SelectionStyle style, Poppler.Rectangle selection);
		[Version (since = "0.16")]
		public string get_selected_text (Poppler.SelectionStyle style, Poppler.Rectangle selection);
		[Version (deprecated = true, deprecated_since = "0.16")]
		public GLib.List<Poppler.Rectangle> get_selection_region (double scale, Poppler.SelectionStyle style, Poppler.Rectangle selection);
		public void get_size (out double width, out double height);
		[Version (since = "0.16")]
		public string get_text ();
		[Version (since = "0.18")]
		public GLib.List<Poppler.TextAttributes> get_text_attributes ();
		[Version (since = "0.26")]
		public GLib.List<Poppler.TextAttributes> get_text_attributes_for_area (Poppler.Rectangle area);
		[Version (since = "0.26")]
		public string get_text_for_area (Poppler.Rectangle area);
		[Version (since = "0.16")]
		public bool get_text_layout ([CCode (array_length_cname = "n_rectangles", array_length_pos = 1.1, array_length_type = "guint")] out Poppler.Rectangle[] rectangles);
		[Version (since = "0.26")]
		public bool get_text_layout_for_area (Poppler.Rectangle area, [CCode (array_length_cname = "n_rectangles", array_length_pos = 2.1, array_length_type = "guint")] out Poppler.Rectangle[] rectangles);
		public Cairo.Surface get_thumbnail ();
		public bool get_thumbnail_size (out int width, out int height);
		public Poppler.PageTransition get_transition ();
		[Version (since = "0.22")]
		public void remove_annot (Poppler.Annot annot);
		public void render ([CCode (type = "cairo_t*")] Cairo.Context cairo);
		public void render_for_printing ([CCode (type = "cairo_t*")] Cairo.Context cairo);
		[Version (since = "0.16")]
		public void render_for_printing_with_options ([CCode (type = "cairo_t*")] Cairo.Context cairo, Poppler.PrintFlags options);
		public void render_selection ([CCode (type = "cairo_t*")] Cairo.Context cairo, Poppler.Rectangle selection, Poppler.Rectangle old_selection, Poppler.SelectionStyle style, Poppler.Color glyph_color, Poppler.Color background_color);
		public void render_to_ps (Poppler.PSFile ps_file);
		[Version (deprecated = true, deprecated_since = "0.16")]
		public static void selection_region_free (GLib.List<Poppler.Rectangle> region);
		public string label { owned get; }
	}
	[CCode (cheader_filename = "poppler.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "poppler_page_transition_get_type ()")]
	[Compact]
	public class PageTransition {
		public Poppler.PageTransitionAlignment alignment;
		public int angle;
		public Poppler.PageTransitionDirection direction;
		public int duration;
		public double duration_real;
		public bool rectangular;
		public double scale;
		public Poppler.PageTransitionType type;
		[CCode (has_construct_function = false)]
		public PageTransition ();
		public Poppler.PageTransition copy ();
		public void free ();
	}
	[CCode (cheader_filename = "poppler.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "poppler_point_get_type ()")]
	[Compact]
	public class Point {
		public double x;
		public double y;
		[CCode (has_construct_function = false)]
		[Version (since = "0.26")]
		public Point ();
		[Version (since = "0.26")]
		public Poppler.Point copy ();
		[Version (since = "0.26")]
		public void free ();
	}
	[CCode (cheader_filename = "poppler.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "poppler_quadrilateral_get_type ()")]
	[Compact]
	public class Quadrilateral {
		public Poppler.Point p1;
		public Poppler.Point p2;
		public Poppler.Point p3;
		public Poppler.Point p4;
		[CCode (has_construct_function = false)]
		[Version (since = "0.26")]
		public Quadrilateral ();
		[Version (since = "0.26")]
		public Poppler.Quadrilateral copy ();
		[Version (since = "0.26")]
		public void free ();
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_structure_element_get_type ()")]
	public class StructureElement : GLib.Object {
		[CCode (has_construct_function = false)]
		protected StructureElement ();
		public string get_abbreviation ();
		[Version (since = "0.26")]
		public string get_actual_text ();
		[Version (since = "0.26")]
		public string get_alt_text ();
		[Version (since = "0.26")]
		public bool get_background_color (out unowned Poppler.Color color);
		[Version (since = "0.26")]
		public double get_baseline_shift ();
		[Version (since = "0.26")]
		public Poppler.StructureBlockAlign get_block_align ();
		[Version (since = "0.26")]
		public bool get_border_color ([CCode (array_length = false)] out unowned Poppler.Color colors[4]);
		[Version (since = "0.26")]
		public void get_border_style ([CCode (array_length = false)] out Poppler.StructureBorderStyle border_styles[4]);
		[Version (since = "0.26")]
		public bool get_border_thickness ([CCode (array_length = false)] out double border_thicknesses[4]);
		[Version (since = "0.26")]
		public bool get_bounding_box (out Poppler.Rectangle bounding_box);
		[Version (since = "0.26")]
		public bool get_color (out unowned Poppler.Color color);
		[Version (since = "0.26")]
		public uint get_column_count ();
		[CCode (array_length_pos = 0.1, array_length_type = "guint")]
		[Version (since = "0.26")]
		public double[] get_column_gaps ();
		[CCode (array_length_pos = 0.1, array_length_type = "guint")]
		[Version (since = "0.26")]
		public double[] get_column_widths ();
		[Version (since = "0.26")]
		public double get_end_indent ();
		[Version (since = "0.26")]
		public string get_form_description ();
		[Version (since = "0.26")]
		public Poppler.StructureFormRole get_form_role ();
		[Version (since = "0.26")]
		public Poppler.StructureFormState get_form_state ();
		[Version (since = "0.26")]
		public Poppler.StructureGlyphOrientation get_glyph_orientation ();
		[Version (since = "0.26")]
		public double get_height ();
		[Version (since = "0.26")]
		public string get_id ();
		[Version (since = "0.26")]
		public Poppler.StructureInlineAlign get_inline_align ();
		[Version (since = "0.26")]
		public Poppler.StructureElementKind get_kind ();
		[Version (since = "0.26")]
		public string get_language ();
		[Version (since = "0.26")]
		public double get_line_height ();
		[Version (since = "0.26")]
		public Poppler.StructureListNumbering get_list_numbering ();
		[Version (since = "0.26")]
		public void get_padding ([CCode (array_length = false)] out double paddings[4]);
		[Version (since = "0.26")]
		public int get_page ();
		[Version (since = "0.26")]
		public Poppler.StructurePlacement get_placement ();
		[Version (since = "0.26")]
		public Poppler.StructureRubyAlign get_ruby_align ();
		[Version (since = "0.26")]
		public Poppler.StructureRubyPosition get_ruby_position ();
		[Version (since = "0.26")]
		public double get_space_after ();
		[Version (since = "0.26")]
		public double get_space_before ();
		[Version (since = "0.26")]
		public double get_start_indent ();
		[Version (since = "0.26")]
		public void get_table_border_style ([CCode (array_length = false)] out Poppler.StructureBorderStyle border_styles[4]);
		[Version (since = "0.26")]
		public uint get_table_column_span ();
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "0.26")]
		public string[] get_table_headers ();
		[Version (since = "0.26")]
		public void get_table_padding ([CCode (array_length = false)] out double paddings[4]);
		[Version (since = "0.26")]
		public uint get_table_row_span ();
		[Version (since = "0.26")]
		public Poppler.StructureTableScope get_table_scope ();
		[Version (since = "0.26")]
		public string get_table_summary ();
		[Version (since = "0.26")]
		public string get_text (Poppler.StructureGetTextFlags flags);
		[Version (since = "0.26")]
		public Poppler.StructureTextAlign get_text_align ();
		[Version (since = "0.26")]
		public bool get_text_decoration_color (out unowned Poppler.Color color);
		[Version (since = "0.26")]
		public double get_text_decoration_thickness ();
		[Version (since = "0.26")]
		public Poppler.StructureTextDecoration get_text_decoration_type ();
		[Version (since = "0.26")]
		public double get_text_indent ();
		[CCode (array_length_pos = 0.1, array_length_type = "guint")]
		[Version (since = "0.26")]
		public Poppler.TextSpan[] get_text_spans ();
		[Version (since = "0.26")]
		public string get_title ();
		[Version (since = "0.26")]
		public double get_width ();
		[Version (since = "0.26")]
		public Poppler.StructureWritingMode get_writing_mode ();
		[Version (since = "0.26")]
		public bool is_block ();
		[Version (since = "0.26")]
		public bool is_content ();
		[Version (since = "0.26")]
		public bool is_grouping ();
		[Version (since = "0.26")]
		public bool is_inline ();
	}
	[CCode (cheader_filename = "poppler.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "poppler_structure_element_iter_get_type ()")]
	[Compact]
	public class StructureElementIter {
		[CCode (has_construct_function = false)]
		[Version (since = "0.26")]
		public StructureElementIter (Poppler.Document poppler_document);
		[Version (since = "0.26")]
		public Poppler.StructureElementIter copy ();
		[Version (since = "0.26")]
		public void free ();
		[Version (since = "0.26")]
		public Poppler.StructureElementIter get_child ();
		[Version (since = "0.26")]
		public Poppler.StructureElement get_element ();
		[Version (since = "0.26")]
		public bool next ();
	}
	[CCode (cheader_filename = "poppler.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "poppler_text_attributes_get_type ()")]
	[Compact]
	[Version (since = "0.18")]
	public class TextAttributes {
		public Poppler.Color color;
		public int end_index;
		public string font_name;
		public double font_size;
		public bool is_underlined;
		public int start_index;
		[CCode (has_construct_function = false)]
		public TextAttributes ();
		public Poppler.TextAttributes copy ();
		public void free ();
	}
	[CCode (cheader_filename = "poppler.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "poppler_text_span_get_type ()")]
	[Compact]
	public class TextSpan {
		[Version (since = "0.26")]
		public Poppler.TextSpan copy ();
		[Version (since = "0.26")]
		public void free ();
		[Version (since = "0.26")]
		public void get_color (out unowned Poppler.Color color);
		[Version (since = "0.26")]
		public unowned string get_font_name ();
		[Version (since = "0.26")]
		public unowned string get_text ();
		[Version (since = "0.26")]
		public bool is_bold_font ();
		[Version (since = "0.26")]
		public bool is_fixed_width_font ();
		[Version (since = "0.26")]
		public bool is_serif_font ();
	}
	[CCode (cheader_filename = "poppler.h", has_type_id = false)]
	public struct ActionAny {
		public Poppler.ActionType type;
		public string title;
	}
	[CCode (cheader_filename = "poppler.h", has_type_id = false)]
	public struct ActionGotoDest {
		public Poppler.ActionType type;
		public string title;
		public Poppler.Dest dest;
	}
	[CCode (cheader_filename = "poppler.h", has_type_id = false)]
	public struct ActionGotoRemote {
		public Poppler.ActionType type;
		public string title;
		public string file_name;
		public Poppler.Dest dest;
	}
	[CCode (cheader_filename = "poppler.h", has_type_id = false)]
	public struct ActionJavascript {
		public Poppler.ActionType type;
		public string title;
		public string script;
	}
	[CCode (cheader_filename = "poppler.h", has_type_id = false)]
	public struct ActionLaunch {
		public Poppler.ActionType type;
		public string title;
		public string file_name;
		public string @params;
	}
	[CCode (cheader_filename = "poppler.h", has_type_id = false)]
	public struct ActionLayer {
		public Poppler.ActionLayerAction action;
		public weak GLib.List<Poppler.ActionLayer> layers;
	}
	[CCode (cheader_filename = "poppler.h", has_type_id = false)]
	public struct ActionMovie {
		public Poppler.ActionType type;
		public string title;
		public Poppler.ActionMovieOperation operation;
		public Poppler.Movie movie;
	}
	[CCode (cheader_filename = "poppler.h", has_type_id = false)]
	public struct ActionNamed {
		public Poppler.ActionType type;
		public string title;
		public string named_dest;
	}
	[CCode (cheader_filename = "poppler.h", has_type_id = false)]
	public struct ActionOCGState {
		public Poppler.ActionType type;
		public string title;
		public GLib.List<Poppler.ActionLayer> state_list;
	}
	[CCode (cheader_filename = "poppler.h", has_type_id = false)]
	public struct ActionRendition {
		public Poppler.ActionType type;
		public string title;
		public int op;
		public Poppler.Media media;
	}
	[CCode (cheader_filename = "poppler.h", has_type_id = false)]
	public struct ActionUri {
		public Poppler.ActionType type;
		public string title;
		public string uri;
	}
	[CCode (cheader_filename = "poppler.h", type_id = "poppler_rectangle_get_type ()")]
	public struct Rectangle {
		public double x1;
		public double y1;
		public double x2;
		public double y2;
		[CCode (has_construct_function = false, type = "PopplerRectangle*")]
		public Rectangle ();
		public Poppler.Rectangle? copy ();
		public void free ();
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_ACTION_LAYER_", type_id = "poppler_action_layer_action_get_type ()")]
	[Version (since = "0.14")]
	public enum ActionLayerAction {
		ON,
		OFF,
		TOGGLE
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_ACTION_MOVIE_", type_id = "poppler_action_movie_operation_get_type ()")]
	[Version (since = "0.14")]
	public enum ActionMovieOperation {
		PLAY,
		PAUSE,
		RESUME,
		STOP
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_ACTION_", type_id = "poppler_action_type_get_type ()")]
	public enum ActionType {
		UNKNOWN,
		NONE,
		GOTO_DEST,
		GOTO_REMOTE,
		LAUNCH,
		URI,
		NAMED,
		MOVIE,
		RENDITION,
		OCG_STATE,
		JAVASCRIPT
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_ANNOT_EXTERNAL_DATA_MARKUP_", type_id = "poppler_annot_external_data_type_get_type ()")]
	public enum AnnotExternalDataType {
		@3D,
		UNKNOWN
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_ANNOT_FLAG_", type_id = "poppler_annot_flag_get_type ()")]
	[Flags]
	public enum AnnotFlag {
		UNKNOWN,
		INVISIBLE,
		HIDDEN,
		PRINT,
		NO_ZOOM,
		NO_ROTATE,
		NO_VIEW,
		READ_ONLY,
		LOCKED,
		TOGGLE_NO_VIEW,
		LOCKED_CONTENTS
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_ANNOT_FREE_TEXT_QUADDING_", type_id = "poppler_annot_free_text_quadding_get_type ()")]
	public enum AnnotFreeTextQuadding {
		LEFT_JUSTIFIED,
		CENTERED,
		RIGHT_JUSTIFIED
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_ANNOT_MARKUP_REPLY_TYPE_", type_id = "poppler_annot_markup_reply_type_get_type ()")]
	public enum AnnotMarkupReplyType {
		R,
		GROUP
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_ANNOT_TEXT_STATE_", type_id = "poppler_annot_text_state_get_type ()")]
	public enum AnnotTextState {
		MARKED,
		UNMARKED,
		ACCEPTED,
		REJECTED,
		CANCELLED,
		COMPLETED,
		NONE,
		UNKNOWN
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_ANNOT_", type_id = "poppler_annot_type_get_type ()")]
	public enum AnnotType {
		UNKNOWN,
		TEXT,
		LINK,
		FREE_TEXT,
		LINE,
		SQUARE,
		CIRCLE,
		POLYGON,
		POLY_LINE,
		HIGHLIGHT,
		UNDERLINE,
		SQUIGGLY,
		STRIKE_OUT,
		STAMP,
		CARET,
		INK,
		POPUP,
		FILE_ATTACHMENT,
		SOUND,
		MOVIE,
		WIDGET,
		SCREEN,
		PRINTER_MARK,
		TRAP_NET,
		WATERMARK,
		@3D
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_BACKEND_", type_id = "poppler_backend_get_type ()")]
	public enum Backend {
		UNKNOWN,
		SPLASH,
		CAIRO
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_DEST_", type_id = "poppler_dest_type_get_type ()")]
	public enum DestType {
		UNKNOWN,
		XYZ,
		FIT,
		FITH,
		FITV,
		FITR,
		FITB,
		FITBH,
		FITBV,
		NAMED
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_FIND_", type_id = "poppler_find_flags_get_type ()")]
	[Flags]
	[Version (since = "0.22")]
	public enum FindFlags {
		DEFAULT,
		CASE_SENSITIVE,
		BACKWARDS,
		WHOLE_WORDS_ONLY
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_FONT_TYPE_", type_id = "poppler_font_type_get_type ()")]
	public enum FontType {
		UNKNOWN,
		TYPE1,
		TYPE1C,
		TYPE1COT,
		TYPE3,
		TRUETYPE,
		TRUETYPEOT,
		CID_TYPE0,
		CID_TYPE0C,
		CID_TYPE0COT,
		CID_TYPE2,
		CID_TYPE2OT
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_FORM_BUTTON_", type_id = "poppler_form_button_type_get_type ()")]
	public enum FormButtonType {
		PUSH,
		CHECK,
		RADIO
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_FORM_CHOICE_", type_id = "poppler_form_choice_type_get_type ()")]
	public enum FormChoiceType {
		COMBO,
		LIST
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_FORM_FIELD_", type_id = "poppler_form_field_type_get_type ()")]
	public enum FormFieldType {
		UNKNOWN,
		BUTTON,
		TEXT,
		CHOICE,
		SIGNATURE
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_FORM_TEXT_", type_id = "poppler_form_text_type_get_type ()")]
	public enum FormTextType {
		NORMAL,
		MULTILINE,
		FILE_SELECT
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_PAGE_LAYOUT_", type_id = "poppler_page_layout_get_type ()")]
	public enum PageLayout {
		UNSET,
		SINGLE_PAGE,
		ONE_COLUMN,
		TWO_COLUMN_LEFT,
		TWO_COLUMN_RIGHT,
		TWO_PAGE_LEFT,
		TWO_PAGE_RIGHT
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_PAGE_MODE_", type_id = "poppler_page_mode_get_type ()")]
	public enum PageMode {
		UNSET,
		NONE,
		USE_OUTLINES,
		USE_THUMBS,
		FULL_SCREEN,
		USE_OC,
		USE_ATTACHMENTS
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_PAGE_TRANSITION_", type_id = "poppler_page_transition_alignment_get_type ()")]
	public enum PageTransitionAlignment {
		HORIZONTAL,
		VERTICAL
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_PAGE_TRANSITION_", type_id = "poppler_page_transition_direction_get_type ()")]
	public enum PageTransitionDirection {
		INWARD,
		OUTWARD
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_PAGE_TRANSITION_", type_id = "poppler_page_transition_type_get_type ()")]
	public enum PageTransitionType {
		REPLACE,
		SPLIT,
		BLINDS,
		BOX,
		WIPE,
		DISSOLVE,
		GLITTER,
		FLY,
		PUSH,
		COVER,
		UNCOVER,
		FADE
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_PERMISSIONS_", type_id = "poppler_permissions_get_type ()")]
	[Flags]
	public enum Permissions {
		OK_TO_PRINT,
		OK_TO_MODIFY,
		OK_TO_COPY,
		OK_TO_ADD_NOTES,
		OK_TO_FILL_FORM,
		OK_TO_EXTRACT_CONTENTS,
		OK_TO_ASSEMBLE,
		OK_TO_PRINT_HIGH_RESOLUTION,
		FULL
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_PRINT_", type_id = "poppler_print_flags_get_type ()")]
	[Flags]
	[Version (since = "0.16")]
	public enum PrintFlags {
		DOCUMENT,
		MARKUP_ANNOTS,
		STAMP_ANNOTS_ONLY,
		ALL
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_SELECTION_", type_id = "poppler_selection_style_get_type ()")]
	public enum SelectionStyle {
		GLYPH,
		WORD,
		LINE
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_STRUCTURE_BLOCK_ALIGN_", type_id = "poppler_structure_block_align_get_type ()")]
	public enum StructureBlockAlign {
		BEFORE,
		MIDDLE,
		AFTER,
		JUSTIFY
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_STRUCTURE_BORDER_STYLE_", type_id = "poppler_structure_border_style_get_type ()")]
	public enum StructureBorderStyle {
		NONE,
		HIDDEN,
		DOTTED,
		DASHED,
		SOLID,
		DOUBLE,
		GROOVE,
		INSET,
		OUTSET
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_STRUCTURE_ELEMENT_", type_id = "poppler_structure_element_kind_get_type ()")]
	public enum StructureElementKind {
		CONTENT,
		OBJECT_REFERENCE,
		DOCUMENT,
		PART,
		ARTICLE,
		SECTION,
		DIV,
		SPAN,
		QUOTE,
		NOTE,
		REFERENCE,
		BIBENTRY,
		CODE,
		LINK,
		ANNOT,
		BLOCKQUOTE,
		CAPTION,
		NONSTRUCT,
		TOC,
		TOC_ITEM,
		INDEX,
		PRIVATE,
		PARAGRAPH,
		HEADING,
		HEADING_1,
		HEADING_2,
		HEADING_3,
		HEADING_4,
		HEADING_5,
		HEADING_6,
		LIST,
		LIST_ITEM,
		LIST_LABEL,
		LIST_BODY,
		TABLE,
		TABLE_ROW,
		TABLE_HEADING,
		TABLE_DATA,
		TABLE_HEADER,
		TABLE_FOOTER,
		TABLE_BODY,
		RUBY,
		RUBY_BASE_TEXT,
		RUBY_ANNOT_TEXT,
		RUBY_PUNCTUATION,
		WARICHU,
		WARICHU_TEXT,
		WARICHU_PUNCTUATION,
		FIGURE,
		FORMULA,
		FORM
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_STRUCTURE_FORM_ROLE_", type_id = "poppler_structure_form_role_get_type ()")]
	public enum StructureFormRole {
		UNDEFINED,
		RADIO_BUTTON,
		PUSH_BUTTON,
		TEXT_VALUE,
		CHECKBOX
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_STRUCTURE_FORM_STATE_", type_id = "poppler_structure_form_state_get_type ()")]
	public enum StructureFormState {
		ON,
		OFF,
		NEUTRAL
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_STRUCTURE_GET_TEXT_", type_id = "poppler_structure_get_text_flags_get_type ()")]
	[Flags]
	public enum StructureGetTextFlags {
		NONE,
		RECURSIVE
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_STRUCTURE_GLYPH_", type_id = "poppler_structure_glyph_orientation_get_type ()")]
	public enum StructureGlyphOrientation {
		[CCode (cname = "POPPLER_STRUCTURE_GLYPH_ORIENTATION_AUTO")]
		AUTO,
		[CCode (cname = "POPPLER_STRUCTURE_GLYPH_ORIENTATION_0")]
		@0,
		[CCode (cname = "POPPLER_STRUCTURE_GLYPH_ORIENTATION_90")]
		@90,
		[CCode (cname = "POPPLER_STRUCTURE_GLYPH_ORIENTATION_180")]
		@180,
		[CCode (cname = "POPPLER_STRUCTURE_GLYPH_ORIENTATION_270")]
		@270
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_STRUCTURE_INLINE_ALIGN_", type_id = "poppler_structure_inline_align_get_type ()")]
	public enum StructureInlineAlign {
		START,
		CENTER,
		END
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_STRUCTURE_LIST_NUMBERING_", type_id = "poppler_structure_list_numbering_get_type ()")]
	public enum StructureListNumbering {
		NONE,
		DISC,
		CIRCLE,
		SQUARE,
		DECIMAL,
		UPPER_ROMAN,
		LOWER_ROMAN,
		UPPER_ALPHA,
		LOWER_ALPHA
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_STRUCTURE_PLACEMENT_", type_id = "poppler_structure_placement_get_type ()")]
	public enum StructurePlacement {
		BLOCK,
		INLINE,
		BEFORE,
		START,
		END
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_STRUCTURE_RUBY_ALIGN_", type_id = "poppler_structure_ruby_align_get_type ()")]
	public enum StructureRubyAlign {
		START,
		CENTER,
		END,
		JUSTIFY,
		DISTRIBUTE
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_STRUCTURE_RUBY_POSITION_", type_id = "poppler_structure_ruby_position_get_type ()")]
	public enum StructureRubyPosition {
		BEFORE,
		AFTER,
		WARICHU,
		INLINE
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_STRUCTURE_TABLE_SCOPE_", type_id = "poppler_structure_table_scope_get_type ()")]
	public enum StructureTableScope {
		ROW,
		COLUMN,
		BOTH
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_STRUCTURE_TEXT_ALIGN_", type_id = "poppler_structure_text_align_get_type ()")]
	public enum StructureTextAlign {
		START,
		CENTER,
		END,
		JUSTIFY
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_STRUCTURE_TEXT_DECORATION_", type_id = "poppler_structure_text_decoration_get_type ()")]
	public enum StructureTextDecoration {
		NONE,
		UNDERLINE,
		OVERLINE,
		LINETHROUGH
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_STRUCTURE_WRITING_MODE_", type_id = "poppler_structure_writing_mode_get_type ()")]
	public enum StructureWritingMode {
		LR_TB,
		RL_TB,
		TB_RL
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_VIEWER_PREFERENCES_", type_id = "poppler_viewer_preferences_get_type ()")]
	[Flags]
	public enum ViewerPreferences {
		UNSET,
		HIDE_TOOLBAR,
		HIDE_MENUBAR,
		HIDE_WINDOWUI,
		FIT_WINDOW,
		CENTER_WINDOW,
		DISPLAY_DOC_TITLE,
		DIRECTION_RTL
	}
	[CCode (cheader_filename = "poppler.h", cprefix = "POPPLER_ERROR_")]
	public errordomain Error {
		INVALID,
		ENCRYPTED,
		OPEN_FILE,
		BAD_CATALOG,
		DAMAGED;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "poppler.h", instance_pos = 1.9)]
	public delegate bool AttachmentSaveFunc ([CCode (array_length_cname = "count", array_length_pos = 1.1, array_length_type = "gsize")] uint8[] buf) throws GLib.Error;
	[CCode (cheader_filename = "poppler.h", instance_pos = 1.9)]
	[Version (since = "0.14")]
	public delegate bool MediaSaveFunc ([CCode (array_length_cname = "count", array_length_pos = 1.1, array_length_type = "gsize")] uint8[] buf) throws GLib.Error;
	[CCode (cheader_filename = "poppler.h", cname = "POPPLER_HAS_CAIRO")]
	public const int HAS_CAIRO;
	[CCode (cheader_filename = "poppler.h", cname = "POPPLER_MAJOR_VERSION")]
	[Version (since = "0.12")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "poppler.h", cname = "POPPLER_MICRO_VERSION")]
	[Version (since = "0.12")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "poppler.h", cname = "POPPLER_MINOR_VERSION")]
	[Version (since = "0.12")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "poppler.h")]
	[Version (since = "0.12")]
	public static bool date_parse (string date, long timet);
	[CCode (cheader_filename = "poppler.h")]
	public static Poppler.Backend get_backend ();
	[CCode (cheader_filename = "poppler.h")]
	public static unowned string get_version ();
}
