/* exporter.c generated by valac 0.28.0, the Vala compiler
 * generated from exporter.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2012 Stefan Walter
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Stef Walter <stefw@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include "seahorse-common.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SeahorseExporterExportToFileData SeahorseExporterExportToFileData;

struct _SeahorseExporterExportToFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SeahorseExporter* self;
	GFile* file;
	gboolean overwrite;
	GCancellable* cancellable;
	gboolean result;
	guint8* bytes;
	gint bytes_length1;
	gint _bytes_size_;
	GFile* outfile;
	GFile* _tmp0_;
	GFile* _tmp1_;
	guint8* _tmp2_;
	GCancellable* _tmp3_;
	size_t _tmp4_;
	guint8* _tmp5_;
	gint _tmp2__length1;
	gint __tmp2__size_;
	guint8* _tmp6_;
	gint _tmp6__length1;
	guint unique;
	const gchar* _tmp7_;
	gboolean _tmp8_;
	GFile* _tmp9_;
	guint8* _tmp10_;
	gint _tmp10__length1;
	GCancellable* _tmp11_;
	GError* err;
	GError* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GError* _tmp15_;
	GError* _tmp16_;
	GError * _inner_error_;
};



static GFile* seahorse_exporter_file_increment_unique (GFile* file, guint* state);
static void seahorse_exporter_export_to_file_data_free (gpointer _data);
static gboolean seahorse_exporter_export_to_file_co (SeahorseExporterExportToFileData* _data_);
static void seahorse_exporter_export_to_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);


GType seahorse_exporter_type_get_type (void) {
	static volatile gsize seahorse_exporter_type_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_exporter_type_type_id__volatile)) {
		static const GEnumValue values[] = {{SEAHORSE_EXPORTER_TYPE_ANY, "SEAHORSE_EXPORTER_TYPE_ANY", "any"}, {SEAHORSE_EXPORTER_TYPE_TEXTUAL, "SEAHORSE_EXPORTER_TYPE_TEXTUAL", "textual"}, {0, NULL, NULL}};
		GType seahorse_exporter_type_type_id;
		seahorse_exporter_type_type_id = g_enum_register_static ("SeahorseExporterType", values);
		g_once_init_leave (&seahorse_exporter_type_type_id__volatile, seahorse_exporter_type_type_id);
	}
	return seahorse_exporter_type_type_id__volatile;
}


GList* seahorse_exporter_get_objects (SeahorseExporter* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return SEAHORSE_EXPORTER_GET_INTERFACE (self)->get_objects (self);
}


gboolean seahorse_exporter_add_object (SeahorseExporter* self, GObject* obj) {
	g_return_val_if_fail (self != NULL, FALSE);
	return SEAHORSE_EXPORTER_GET_INTERFACE (self)->add_object (self, obj);
}


void seahorse_exporter_export (SeahorseExporter* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SEAHORSE_EXPORTER_GET_INTERFACE (self)->export (self, cancellable, _callback_, _user_data_);
}


guint8* seahorse_exporter_export_finish (SeahorseExporter* self, GAsyncResult* _res_, size_t* result_length1, GError** error) {
	return SEAHORSE_EXPORTER_GET_INTERFACE (self)->export_finish (self, _res_, result_length1, error);
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static GFile* seahorse_exporter_file_increment_unique (GFile* file, guint* state) {
	GFile* result = NULL;
	gchar* uri = NULL;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint last = 0;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gchar* prefix = NULL;
	gchar* suffix = NULL;
	gint index = 0;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	guint _tmp18_ = 0U;
	const gchar* _tmp19_ = NULL;
	guint _tmp20_ = 0U;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	GFile* _tmp24_ = NULL;
	GFile* _tmp25_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = file;
	_tmp1_ = g_file_get_uri (_tmp0_);
	uri = _tmp1_;
	_tmp2_ = uri;
	_tmp3_ = string_last_index_of_char (_tmp2_, (gunichar) '/', 0);
	last = _tmp3_;
	_tmp4_ = last;
	if (_tmp4_ == (-1)) {
		last = 0;
	}
	_tmp5_ = uri;
	_tmp6_ = last;
	_tmp7_ = string_last_index_of_char (_tmp5_, (gunichar) '.', _tmp6_);
	index = _tmp7_;
	_tmp8_ = index;
	if (_tmp8_ == (-1)) {
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp9_ = uri;
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (prefix);
		prefix = _tmp10_;
		_tmp11_ = g_strdup ("");
		_g_free0 (suffix);
		suffix = _tmp11_;
	} else {
		const gchar* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gchar* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gchar* _tmp17_ = NULL;
		_tmp12_ = uri;
		_tmp13_ = index;
		_tmp14_ = string_substring (_tmp12_, (glong) 0, (glong) _tmp13_);
		_g_free0 (prefix);
		prefix = _tmp14_;
		_tmp15_ = uri;
		_tmp16_ = index;
		_tmp17_ = string_substring (_tmp15_, (glong) _tmp16_, (glong) (-1));
		_g_free0 (suffix);
		suffix = _tmp17_;
	}
	_tmp18_ = *state;
	*state = _tmp18_ + 1;
	_tmp19_ = prefix;
	_tmp20_ = *state;
	_tmp21_ = suffix;
	_tmp22_ = g_strdup_printf ("%s-%u%s", _tmp19_, _tmp20_, _tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_file_new_for_uri (_tmp23_);
	_tmp25_ = _tmp24_;
	_g_free0 (_tmp23_);
	result = _tmp25_;
	_g_free0 (suffix);
	_g_free0 (prefix);
	_g_free0 (uri);
	return result;
}


static void seahorse_exporter_export_to_file_data_free (gpointer _data) {
	SeahorseExporterExportToFileData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseExporterExportToFileData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void seahorse_exporter_export_to_file (SeahorseExporter* self, GFile* file, gboolean overwrite, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SeahorseExporterExportToFileData* _data_;
	SeahorseExporter* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GCancellable* _tmp4_ = NULL;
	GCancellable* _tmp5_ = NULL;
	_data_ = g_slice_new0 (SeahorseExporterExportToFileData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, seahorse_exporter_export_to_file);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, seahorse_exporter_export_to_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = file;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp2_;
	_tmp3_ = overwrite;
	_data_->overwrite = _tmp3_;
	_tmp4_ = cancellable;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp5_;
	seahorse_exporter_export_to_file_co (_data_);
}


gboolean seahorse_exporter_export_to_file_finish (SeahorseExporter* self, GAsyncResult* _res_, GError** error) {
	gboolean result;
	SeahorseExporterExportToFileData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void seahorse_exporter_export_to_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SeahorseExporterExportToFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	seahorse_exporter_export_to_file_co (_data_);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static gboolean seahorse_exporter_export_to_file_co (SeahorseExporterExportToFileData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->bytes_length1 = 0;
	_data_->_bytes_size_ = 0;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->file;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
	_data_->outfile = _data_->_tmp1_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->cancellable;
	memset (&_data_->_tmp4_, 0, sizeof (size_t));
	_data_->_state_ = 1;
	seahorse_exporter_export (_data_->self, _data_->_tmp3_, seahorse_exporter_export_to_file_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = seahorse_exporter_export_finish (_data_->self, _data_->_res_, &_data_->_tmp4_, &_data_->_inner_error_);
	_data_->_tmp2__length1 = 0;
	_data_->__tmp2__size_ = 0;
	_data_->_tmp2_ = _data_->_tmp5_;
	_data_->_tmp2__length1 = _data_->_tmp4_;
	_data_->__tmp2__size_ = _data_->_tmp2__length1;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->outfile);
		_data_->bytes = (g_free (_data_->bytes), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = NULL;
	_data_->_tmp6__length1 = 0;
	_data_->_tmp6_ = _data_->_tmp2_;
	_data_->_tmp6__length1 = _data_->_tmp2__length1;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2__length1 = 0;
	_data_->bytes = (g_free (_data_->bytes), NULL);
	_data_->bytes = _data_->_tmp6_;
	_data_->bytes_length1 = _data_->_tmp6__length1;
	_data_->_bytes_size_ = _data_->bytes_length1;
	while (TRUE) {
		_data_->unique = (guint) 0;
		{
			_data_->_tmp8_ = FALSE;
			_data_->_tmp8_ = _data_->overwrite;
			if (_data_->_tmp8_) {
				_data_->_tmp7_ = NULL;
			} else {
				_data_->_tmp7_ = "invalid etag";
			}
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = _data_->outfile;
			_data_->_tmp10_ = NULL;
			_data_->_tmp10__length1 = 0;
			_data_->_tmp10_ = _data_->bytes;
			_data_->_tmp10__length1 = _data_->bytes_length1;
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = _data_->cancellable;
			_data_->_state_ = 2;
			g_file_replace_contents_async (_data_->_tmp9_, _data_->_tmp10_, (gsize) _data_->_tmp10__length1, _data_->_tmp7_, FALSE, G_FILE_CREATE_PRIVATE, _data_->_tmp11_, seahorse_exporter_export_to_file_ready, _data_);
			return FALSE;
			_state_2:
			g_file_replace_contents_finish (_data_->_tmp9_, _data_->_res_, NULL, &_data_->_inner_error_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				if (_data_->_inner_error_->domain == G_IO_ERROR) {
					goto __catch6_g_io_error;
				}
				goto __finally6;
			}
			_data_->result = TRUE;
			_data_->_tmp2_ = (g_free (_data_->_tmp2_), NULL);
			_g_object_unref0 (_data_->outfile);
			_data_->bytes = (g_free (_data_->bytes), NULL);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		goto __finally6;
		__catch6_g_io_error:
		{
			_data_->err = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = _data_->err;
			if (g_error_matches (_data_->_tmp12_, G_IO_ERROR, G_IO_ERROR_WRONG_ETAG)) {
				_data_->_tmp13_ = NULL;
				_data_->_tmp13_ = _data_->file;
				_data_->_tmp14_ = NULL;
				_data_->_tmp14_ = seahorse_exporter_file_increment_unique (_data_->_tmp13_, &_data_->unique);
				_g_object_unref0 (_data_->outfile);
				_data_->outfile = _data_->_tmp14_;
				_g_error_free0 (_data_->err);
				continue;
			}
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = _data_->err;
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = _g_error_copy0 (_data_->_tmp15_);
			_data_->_inner_error_ = _data_->_tmp16_;
			_g_error_free0 (_data_->err);
			goto __finally6;
		}
		__finally6:
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_data_->_tmp2_ = (g_free (_data_->_tmp2_), NULL);
		_g_object_unref0 (_data_->outfile);
		_data_->bytes = (g_free (_data_->bytes), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = (g_free (_data_->_tmp2_), NULL);
	_g_object_unref0 (_data_->outfile);
	_data_->bytes = (g_free (_data_->bytes), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


gchar* seahorse_exporter_get_filename (SeahorseExporter* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return SEAHORSE_EXPORTER_GET_INTERFACE (self)->get_filename (self);
}


const gchar* seahorse_exporter_get_content_type (SeahorseExporter* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return SEAHORSE_EXPORTER_GET_INTERFACE (self)->get_content_type (self);
}


GtkFileFilter* seahorse_exporter_get_file_filter (SeahorseExporter* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return SEAHORSE_EXPORTER_GET_INTERFACE (self)->get_file_filter (self);
}


static void seahorse_exporter_base_init (SeahorseExporterIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("content-type", "content-type", "content-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_object ("file-filter", "file-filter", "file-filter", gtk_file_filter_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	}
}


GType seahorse_exporter_get_type (void) {
	static volatile gsize seahorse_exporter_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_exporter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SeahorseExporterIface), (GBaseInitFunc) seahorse_exporter_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType seahorse_exporter_type_id;
		seahorse_exporter_type_id = g_type_register_static (G_TYPE_INTERFACE, "SeahorseExporter", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (seahorse_exporter_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&seahorse_exporter_type_id__volatile, seahorse_exporter_type_id);
	}
	return seahorse_exporter_type_id__volatile;
}



