/* external-download-manager.c generated by valac 0.30.0, the Vala compiler
 * generated from external-download-manager.vala, do not modify */

/*
   Copyright (C) 2012 André Stösel <andre@stoesel.de>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   See the file COPYING for the full license text.
*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>
#include "midori/midori-view.h"
#include "webkit/webkit.h"
#include "midori/midori-extension.h"
#include "midori/midori-browser.h"
#include "midori/midori-app.h"
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include "external-download-manager.h"
#include "katze/katze.h"


#define EDM_TYPE_STEADYFLOW_INTERFACE (edm_steadyflow_interface_get_type ())
#define EDM_STEADYFLOW_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDM_TYPE_STEADYFLOW_INTERFACE, EDMSteadyflowInterface))
#define EDM_IS_STEADYFLOW_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDM_TYPE_STEADYFLOW_INTERFACE))
#define EDM_STEADYFLOW_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), EDM_TYPE_STEADYFLOW_INTERFACE, EDMSteadyflowInterfaceIface))

typedef struct _EDMSteadyflowInterface EDMSteadyflowInterface;
typedef struct _EDMSteadyflowInterfaceIface EDMSteadyflowInterfaceIface;

#define EDM_TYPE_STEADYFLOW_INTERFACE_PROXY (edm_steadyflow_interface_proxy_get_type ())
typedef GDBusProxy EDMSteadyflowInterfaceProxy;
typedef GDBusProxyClass EDMSteadyflowInterfaceProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define EDM_TYPE_DOWNLOAD_REQUEST (edm_download_request_get_type ())
#define EDM_DOWNLOAD_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDM_TYPE_DOWNLOAD_REQUEST, EDMDownloadRequest))
#define EDM_DOWNLOAD_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDM_TYPE_DOWNLOAD_REQUEST, EDMDownloadRequestClass))
#define EDM_IS_DOWNLOAD_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDM_TYPE_DOWNLOAD_REQUEST))
#define EDM_IS_DOWNLOAD_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDM_TYPE_DOWNLOAD_REQUEST))
#define EDM_DOWNLOAD_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDM_TYPE_DOWNLOAD_REQUEST, EDMDownloadRequestClass))

typedef struct _EDMDownloadRequest EDMDownloadRequest;
typedef struct _EDMDownloadRequestClass EDMDownloadRequestClass;
typedef struct _EDMDownloadRequestPrivate EDMDownloadRequestPrivate;

#define EDM_TYPE_MANAGER (edm_manager_get_type ())
#define EDM_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDM_TYPE_MANAGER, EDMManager))
#define EDM_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDM_TYPE_MANAGER, EDMManagerClass))
#define EDM_IS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDM_TYPE_MANAGER))
#define EDM_IS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDM_TYPE_MANAGER))
#define EDM_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDM_TYPE_MANAGER, EDMManagerClass))

typedef struct _EDMManager EDMManager;
typedef struct _EDMManagerClass EDMManagerClass;
typedef struct _EDMManagerPrivate EDMManagerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define __vala_SoupURI_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupURI_free (var), NULL)))

#define EDM_TYPE_EXTERNAL_DOWNLOAD_MANAGER (edm_external_download_manager_get_type ())
#define EDM_EXTERNAL_DOWNLOAD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDM_TYPE_EXTERNAL_DOWNLOAD_MANAGER, EDMExternalDownloadManager))
#define EDM_EXTERNAL_DOWNLOAD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDM_TYPE_EXTERNAL_DOWNLOAD_MANAGER, EDMExternalDownloadManagerClass))
#define EDM_IS_EXTERNAL_DOWNLOAD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDM_TYPE_EXTERNAL_DOWNLOAD_MANAGER))
#define EDM_IS_EXTERNAL_DOWNLOAD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDM_TYPE_EXTERNAL_DOWNLOAD_MANAGER))
#define EDM_EXTERNAL_DOWNLOAD_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDM_TYPE_EXTERNAL_DOWNLOAD_MANAGER, EDMExternalDownloadManagerClass))

typedef struct _EDMExternalDownloadManager EDMExternalDownloadManager;
typedef struct _EDMExternalDownloadManagerClass EDMExternalDownloadManagerClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _EDMExternalDownloadManagerPrivate EDMExternalDownloadManagerPrivate;
typedef struct _Block1Data Block1Data;

#define EDM_TYPE_ARIA2 (edm_aria2_get_type ())
#define EDM_ARIA2(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDM_TYPE_ARIA2, EDMAria2))
#define EDM_ARIA2_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDM_TYPE_ARIA2, EDMAria2Class))
#define EDM_IS_ARIA2(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDM_TYPE_ARIA2))
#define EDM_IS_ARIA2_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDM_TYPE_ARIA2))
#define EDM_ARIA2_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDM_TYPE_ARIA2, EDMAria2Class))

typedef struct _EDMAria2 EDMAria2;
typedef struct _EDMAria2Class EDMAria2Class;
typedef struct _EDMAria2Private EDMAria2Private;
typedef struct _Block2Data Block2Data;
#define __vala_SoupBuffer_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupBuffer_free (var), NULL)))
#define _g_value_array_free0(var) ((var == NULL) ? NULL : (var = (g_value_array_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define EDM_TYPE_STEADY_FLOW (edm_steady_flow_get_type ())
#define EDM_STEADY_FLOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDM_TYPE_STEADY_FLOW, EDMSteadyFlow))
#define EDM_STEADY_FLOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDM_TYPE_STEADY_FLOW, EDMSteadyFlowClass))
#define EDM_IS_STEADY_FLOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDM_TYPE_STEADY_FLOW))
#define EDM_IS_STEADY_FLOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDM_TYPE_STEADY_FLOW))
#define EDM_STEADY_FLOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDM_TYPE_STEADY_FLOW, EDMSteadyFlowClass))

typedef struct _EDMSteadyFlow EDMSteadyFlow;
typedef struct _EDMSteadyFlowClass EDMSteadyFlowClass;
typedef struct _EDMSteadyFlowPrivate EDMSteadyFlowPrivate;

#define EDM_TYPE_COMMAND_LINE_PREFERENCES (edm_command_line_preferences_get_type ())
#define EDM_COMMAND_LINE_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDM_TYPE_COMMAND_LINE_PREFERENCES, EDMCommandLinePreferences))
#define EDM_COMMAND_LINE_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDM_TYPE_COMMAND_LINE_PREFERENCES, EDMCommandLinePreferencesClass))
#define EDM_IS_COMMAND_LINE_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDM_TYPE_COMMAND_LINE_PREFERENCES))
#define EDM_IS_COMMAND_LINE_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDM_TYPE_COMMAND_LINE_PREFERENCES))
#define EDM_COMMAND_LINE_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDM_TYPE_COMMAND_LINE_PREFERENCES, EDMCommandLinePreferencesClass))

typedef struct _EDMCommandLinePreferences EDMCommandLinePreferences;
typedef struct _EDMCommandLinePreferencesClass EDMCommandLinePreferencesClass;
typedef struct _EDMCommandLinePreferencesPrivate EDMCommandLinePreferencesPrivate;

#define EDM_TYPE_COMMAND_LINE (edm_command_line_get_type ())
#define EDM_COMMAND_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDM_TYPE_COMMAND_LINE, EDMCommandLine))
#define EDM_COMMAND_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDM_TYPE_COMMAND_LINE, EDMCommandLineClass))
#define EDM_IS_COMMAND_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDM_TYPE_COMMAND_LINE))
#define EDM_IS_COMMAND_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDM_TYPE_COMMAND_LINE))
#define EDM_COMMAND_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDM_TYPE_COMMAND_LINE, EDMCommandLineClass))

typedef struct _EDMCommandLine EDMCommandLine;
typedef struct _EDMCommandLineClass EDMCommandLineClass;
typedef struct _EDMCommandLinePrivate EDMCommandLinePrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _EDMSteadyflowInterfaceIface {
	GTypeInterface parent_iface;
	void (*AddFile) (EDMSteadyflowInterface* self, const gchar* url, GError** error);
};

struct _EDMDownloadRequest {
	GObject parent_instance;
	EDMDownloadRequestPrivate * priv;
	gchar* uri;
	gchar* auth;
	gchar* referer;
	gchar* cookie_header;
};

struct _EDMDownloadRequestClass {
	GObjectClass parent_class;
};

struct _EDMManager {
	GObject parent_instance;
	EDMManagerPrivate * priv;
};

struct _EDMManagerClass {
	GObjectClass parent_class;
};

struct _EDMManagerPrivate {
	SoupCookieJar* cookie_jar;
	GPtrArray* download_managers;
};

struct _EDMExternalDownloadManager {
	MidoriExtension parent_instance;
	EDMExternalDownloadManagerPrivate * priv;
};

struct _EDMExternalDownloadManagerClass {
	MidoriExtensionClass parent_class;
	gboolean (*download) (EDMExternalDownloadManager* self, EDMDownloadRequest* dlReq);
};

struct _Block1Data {
	int _ref_count_;
	EDMExternalDownloadManager* self;
	GtkMessageDialog* dialog;
};

struct _EDMAria2 {
	EDMExternalDownloadManager parent_instance;
	EDMAria2Private * priv;
};

struct _EDMAria2Class {
	EDMExternalDownloadManagerClass parent_class;
};

struct _Block2Data {
	int _ref_count_;
	EDMAria2* self;
	GtkMessageDialog* dialog;
};

struct _EDMSteadyFlow {
	EDMExternalDownloadManager parent_instance;
	EDMSteadyFlowPrivate * priv;
};

struct _EDMSteadyFlowClass {
	EDMExternalDownloadManagerClass parent_class;
};

struct _EDMCommandLinePreferences {
	GtkDialog parent_instance;
	EDMCommandLinePreferencesPrivate * priv;
	GtkEntry* input;
	EDMCommandLine* commandline;
};

struct _EDMCommandLinePreferencesClass {
	GtkDialogClass parent_class;
};

struct _EDMCommandLine {
	EDMExternalDownloadManager parent_instance;
	EDMCommandLinePrivate * priv;
};

struct _EDMCommandLineClass {
	EDMExternalDownloadManagerClass parent_class;
};


static gpointer edm_download_request_parent_class = NULL;
extern EDMManager* edm_manager;
EDMManager* edm_manager = NULL;
static gpointer edm_manager_parent_class = NULL;
static gpointer edm_external_download_manager_parent_class = NULL;
static gpointer edm_aria2_parent_class = NULL;
static gpointer edm_steady_flow_parent_class = NULL;
static gpointer edm_command_line_preferences_parent_class = NULL;
static gpointer edm_command_line_parent_class = NULL;

GType edm_steadyflow_interface_proxy_get_type (void) G_GNUC_CONST;
guint edm_steadyflow_interface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType edm_steadyflow_interface_get_type (void) G_GNUC_CONST;
void edm_steadyflow_interface_AddFile (EDMSteadyflowInterface* self, const gchar* url, GError** error);
static void edm_steadyflow_interface_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void edm_steadyflow_interface_proxy_AddFile (EDMSteadyflowInterface* self, const gchar* url, GError** error);
static void edm_steadyflow_interface_proxy_edm_steadyflow_interface_interface_init (EDMSteadyflowInterfaceIface* iface);
static void _dbus_edm_steadyflow_interface_AddFile (EDMSteadyflowInterface* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void edm_steadyflow_interface_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* edm_steadyflow_interface_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean edm_steadyflow_interface_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _edm_steadyflow_interface_unregister_object (gpointer user_data);
GType edm_download_request_get_type (void) G_GNUC_CONST;
enum  {
	EDM_DOWNLOAD_REQUEST_DUMMY_PROPERTY
};
EDMDownloadRequest* edm_download_request_new (void);
EDMDownloadRequest* edm_download_request_construct (GType object_type);
static void edm_download_request_finalize (GObject* obj);
GType edm_manager_get_type (void) G_GNUC_CONST;
#define EDM_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EDM_TYPE_MANAGER, EDMManagerPrivate))
enum  {
	EDM_MANAGER_DUMMY_PROPERTY
};
gboolean edm_manager_download_requested (EDMManager* self, MidoriView* view, WebKitDownload* download);
static void _vala_SoupURI_free (SoupURI* self);
GType edm_external_download_manager_get_type (void) G_GNUC_CONST;
gboolean edm_external_download_manager_download (EDMExternalDownloadManager* self, EDMDownloadRequest* dlReq);
void edm_manager_tab_added (EDMManager* self, MidoriBrowser* browser, MidoriView* view);
static gboolean _edm_manager_download_requested_midori_view_download_requested (MidoriView* _sender, WebKitDownload* download, gpointer self);
void edm_manager_tab_removed (EDMManager* self, MidoriBrowser* browser, MidoriView* view);
void edm_manager_browser_added (EDMManager* self, MidoriBrowser* browser);
static void _edm_manager_tab_added_midori_browser_add_tab (MidoriBrowser* _sender, MidoriView* tab, gpointer self);
static void _edm_manager_tab_removed_midori_browser_remove_tab (MidoriBrowser* _sender, MidoriView* tab, gpointer self);
void edm_manager_browser_removed (EDMManager* self, MidoriBrowser* browser);
void edm_manager_activated (EDMManager* self, MidoriExtension* extension, MidoriApp* app);
static void _edm_manager_browser_added_midori_app_add_browser (MidoriApp* _sender, MidoriBrowser* browser, gpointer self);
void edm_manager_deactivated (EDMManager* self, MidoriExtension* extension);
EDMManager* edm_manager_new (void);
EDMManager* edm_manager_construct (GType object_type);
static GObject * edm_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void edm_manager_finalize (GObject* obj);
enum  {
	EDM_EXTERNAL_DOWNLOAD_MANAGER_DUMMY_PROPERTY
};
void edm_external_download_manager_activated (EDMExternalDownloadManager* self, MidoriApp* app);
void edm_external_download_manager_deactivated (EDMExternalDownloadManager* self);
void edm_external_download_manager_handle_exception (EDMExternalDownloadManager* self, GError* _error_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda4_ (Block1Data* _data1_, gint a);
static void ___lambda4__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static gboolean edm_external_download_manager_real_download (EDMExternalDownloadManager* self, EDMDownloadRequest* dlReq);
EDMExternalDownloadManager* edm_external_download_manager_construct (GType object_type);
GType edm_aria2_get_type (void) G_GNUC_CONST;
enum  {
	EDM_ARIA2_DUMMY_PROPERTY
};
static gboolean edm_aria2_real_download (EDMExternalDownloadManager* base, EDMDownloadRequest* dlReq);
static GValue* _g_value_dup (GValue* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void ___lambda5_ (Block2Data* _data2_, gint a);
static void ____lambda5__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void _vala_SoupBuffer_free (SoupBuffer* self);
EDMAria2* edm_aria2_new (void);
EDMAria2* edm_aria2_construct (GType object_type);
static void _edm_external_download_manager_activated_midori_extension_activate (MidoriExtension* _sender, MidoriApp* app, gpointer self);
static void _edm_external_download_manager_deactivated_midori_extension_deactivate (MidoriExtension* _sender, gpointer self);
GType edm_steady_flow_get_type (void) G_GNUC_CONST;
enum  {
	EDM_STEADY_FLOW_DUMMY_PROPERTY
};
static gboolean edm_steady_flow_real_download (EDMExternalDownloadManager* base, EDMDownloadRequest* dlReq);
EDMSteadyFlow* edm_steady_flow_new (void);
EDMSteadyFlow* edm_steady_flow_construct (GType object_type);
GType edm_command_line_preferences_get_type (void) G_GNUC_CONST;
GType edm_command_line_get_type (void) G_GNUC_CONST;
enum  {
	EDM_COMMAND_LINE_PREFERENCES_DUMMY_PROPERTY
};
EDMCommandLinePreferences* edm_command_line_preferences_new (EDMCommandLine* cl);
EDMCommandLinePreferences* edm_command_line_preferences_construct (GType object_type, EDMCommandLine* cl);
static void edm_command_line_preferences_create_widgets (EDMCommandLinePreferences* self);
static void edm_command_line_preferences_response_cb (EDMCommandLinePreferences* self, GtkDialog* source, gint response_id);
static void _edm_command_line_preferences_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
void edm_command_line_update_description (EDMCommandLine* self, MidoriApp* app);
static void edm_command_line_preferences_finalize (GObject* obj);
enum  {
	EDM_COMMAND_LINE_DUMMY_PROPERTY
};
static void edm_command_line_show_preferences (EDMCommandLine* self);
static gchar* edm_command_line_replace_quoted (EDMCommandLine* self, const gchar* context, const gchar* replace, const gchar* with);
static gboolean edm_command_line_real_download (EDMExternalDownloadManager* base, EDMDownloadRequest* dlReq);
static gchar* edm_command_line_description_with_command (const gchar* commandline);
EDMCommandLine* edm_command_line_new (void);
EDMCommandLine* edm_command_line_construct (GType object_type);
static void _edm_command_line_update_description_midori_extension_activate (MidoriExtension* _sender, MidoriApp* app, gpointer self);
static void _edm_command_line_show_preferences_midori_extension_open_preferences (MidoriExtension* _sender, gpointer self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GDBusArgInfo _edm_steadyflow_interface_dbus_arg_info_AddFile_url = {-1, "url", "s"};
static const GDBusArgInfo * const _edm_steadyflow_interface_dbus_arg_info_AddFile_in[] = {&_edm_steadyflow_interface_dbus_arg_info_AddFile_url, NULL};
static const GDBusArgInfo * const _edm_steadyflow_interface_dbus_arg_info_AddFile_out[] = {NULL};
static const GDBusMethodInfo _edm_steadyflow_interface_dbus_method_info_AddFile = {-1, "AddFile", (GDBusArgInfo **) (&_edm_steadyflow_interface_dbus_arg_info_AddFile_in), (GDBusArgInfo **) (&_edm_steadyflow_interface_dbus_arg_info_AddFile_out)};
static const GDBusMethodInfo * const _edm_steadyflow_interface_dbus_method_info[] = {&_edm_steadyflow_interface_dbus_method_info_AddFile, NULL};
static const GDBusSignalInfo * const _edm_steadyflow_interface_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _edm_steadyflow_interface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _edm_steadyflow_interface_dbus_interface_info = {-1, "net.launchpad.steadyflow.App", (GDBusMethodInfo **) (&_edm_steadyflow_interface_dbus_method_info), (GDBusSignalInfo **) (&_edm_steadyflow_interface_dbus_signal_info), (GDBusPropertyInfo **) (&_edm_steadyflow_interface_dbus_property_info)};
static const GDBusInterfaceVTable _edm_steadyflow_interface_dbus_interface_vtable = {edm_steadyflow_interface_dbus_interface_method_call, edm_steadyflow_interface_dbus_interface_get_property, edm_steadyflow_interface_dbus_interface_set_property};

void edm_steadyflow_interface_AddFile (EDMSteadyflowInterface* self, const gchar* url, GError** error) {
#line 16 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_if_fail (self != NULL);
#line 16 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	EDM_STEADYFLOW_INTERFACE_GET_INTERFACE (self)->AddFile (self, url, error);
#line 355 "external-download-manager.c"
}


static void edm_steadyflow_interface_base_init (EDMSteadyflowInterfaceIface * iface) {
#line 15 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	static gboolean initialized = FALSE;
#line 15 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	if (!initialized) {
#line 15 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		initialized = TRUE;
#line 366 "external-download-manager.c"
	}
}


GType edm_steadyflow_interface_get_type (void) {
	static volatile gsize edm_steadyflow_interface_type_id__volatile = 0;
	if (g_once_init_enter (&edm_steadyflow_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EDMSteadyflowInterfaceIface), (GBaseInitFunc) edm_steadyflow_interface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType edm_steadyflow_interface_type_id;
		edm_steadyflow_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "EDMSteadyflowInterface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (edm_steadyflow_interface_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (edm_steadyflow_interface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) edm_steadyflow_interface_proxy_get_type);
		g_type_set_qdata (edm_steadyflow_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "net.launchpad.steadyflow.App");
		g_type_set_qdata (edm_steadyflow_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_edm_steadyflow_interface_dbus_interface_info));
		g_type_set_qdata (edm_steadyflow_interface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) edm_steadyflow_interface_register_object);
		g_once_init_leave (&edm_steadyflow_interface_type_id__volatile, edm_steadyflow_interface_type_id);
	}
	return edm_steadyflow_interface_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (EDMSteadyflowInterfaceProxy, edm_steadyflow_interface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (EDM_TYPE_STEADYFLOW_INTERFACE, edm_steadyflow_interface_proxy_edm_steadyflow_interface_interface_init) )
static void edm_steadyflow_interface_proxy_class_init (EDMSteadyflowInterfaceProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = edm_steadyflow_interface_proxy_g_signal;
}


static void edm_steadyflow_interface_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void edm_steadyflow_interface_proxy_init (EDMSteadyflowInterfaceProxy* self) {
}


static void edm_steadyflow_interface_proxy_AddFile (EDMSteadyflowInterface* self, const gchar* url, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "net.launchpad.steadyflow.App", "AddFile");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (url));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void edm_steadyflow_interface_proxy_edm_steadyflow_interface_interface_init (EDMSteadyflowInterfaceIface* iface) {
	iface->AddFile = edm_steadyflow_interface_proxy_AddFile;
}


static void _dbus_edm_steadyflow_interface_AddFile (EDMSteadyflowInterface* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* url = NULL;
	GVariant* _tmp0_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	url = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	edm_steadyflow_interface_AddFile (self, url, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (url);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void edm_steadyflow_interface_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "AddFile") == 0) {
		_dbus_edm_steadyflow_interface_AddFile (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* edm_steadyflow_interface_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean edm_steadyflow_interface_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint edm_steadyflow_interface_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_edm_steadyflow_interface_dbus_interface_info), &_edm_steadyflow_interface_dbus_interface_vtable, data, _edm_steadyflow_interface_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _edm_steadyflow_interface_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


EDMDownloadRequest* edm_download_request_construct (GType object_type) {
	EDMDownloadRequest * self = NULL;
#line 20 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	self = (EDMDownloadRequest*) g_object_new (object_type, NULL);
#line 20 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	return self;
#line 521 "external-download-manager.c"
}


EDMDownloadRequest* edm_download_request_new (void) {
#line 20 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	return edm_download_request_construct (EDM_TYPE_DOWNLOAD_REQUEST);
#line 528 "external-download-manager.c"
}


static void edm_download_request_class_init (EDMDownloadRequestClass * klass) {
#line 20 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	edm_download_request_parent_class = g_type_class_peek_parent (klass);
#line 20 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	G_OBJECT_CLASS (klass)->finalize = edm_download_request_finalize;
#line 537 "external-download-manager.c"
}


static void edm_download_request_instance_init (EDMDownloadRequest * self) {
}


static void edm_download_request_finalize (GObject* obj) {
	EDMDownloadRequest * self;
#line 20 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EDM_TYPE_DOWNLOAD_REQUEST, EDMDownloadRequest);
#line 21 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_g_free0 (self->uri);
#line 22 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_g_free0 (self->auth);
#line 23 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_g_free0 (self->referer);
#line 24 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_g_free0 (self->cookie_header);
#line 20 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	G_OBJECT_CLASS (edm_download_request_parent_class)->finalize (obj);
#line 559 "external-download-manager.c"
}


GType edm_download_request_get_type (void) {
	static volatile gsize edm_download_request_type_id__volatile = 0;
	if (g_once_init_enter (&edm_download_request_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EDMDownloadRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) edm_download_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EDMDownloadRequest), 0, (GInstanceInitFunc) edm_download_request_instance_init, NULL };
		GType edm_download_request_type_id;
		edm_download_request_type_id = g_type_register_static (G_TYPE_OBJECT, "EDMDownloadRequest", &g_define_type_info, 0);
		g_once_init_leave (&edm_download_request_type_id__volatile, edm_download_request_type_id);
	}
	return edm_download_request_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 44 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	return self ? g_object_ref (self) : NULL;
#line 578 "external-download-manager.c"
}


static void _vala_SoupURI_free (SoupURI* self) {
#line 51 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_boxed_free (soup_uri_get_type (), self);
#line 585 "external-download-manager.c"
}


gboolean edm_manager_download_requested (EDMManager* self, MidoriView* view, WebKitDownload* download) {
	gboolean result = FALSE;
	MidoriDownloadType download_type = 0;
	WebKitDownload* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	MidoriDownloadType _tmp2_ = 0;
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_val_if_fail (view != NULL, FALSE);
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_val_if_fail (download != NULL, FALSE);
#line 34 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp0_ = download;
#line 34 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "midori-download-type");
#line 34 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	download_type = (MidoriDownloadType) ((gintptr) _tmp1_);
#line 36 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp2_ = download_type;
#line 36 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	if (_tmp2_ == MIDORI_DOWNLOAD_SAVE) {
#line 611 "external-download-manager.c"
		EDMDownloadRequest* dlReq = NULL;
		EDMDownloadRequest* _tmp3_ = NULL;
		EDMDownloadRequest* _tmp4_ = NULL;
		WebKitDownload* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		WebKitNetworkRequest* request = NULL;
		WebKitDownload* _tmp8_ = NULL;
		WebKitNetworkRequest* _tmp9_ = NULL;
		WebKitNetworkRequest* _tmp10_ = NULL;
		SoupMessage* message = NULL;
		WebKitNetworkRequest* _tmp11_ = NULL;
		SoupMessage* _tmp12_ = NULL;
		SoupMessage* _tmp13_ = NULL;
		SoupMessageHeaders* headers = NULL;
		SoupMessage* _tmp14_ = NULL;
		SoupMessageHeaders* _tmp15_ = NULL;
		EDMDownloadRequest* _tmp16_ = NULL;
		SoupMessageHeaders* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		EDMDownloadRequest* _tmp20_ = NULL;
		SoupMessageHeaders* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		EDMDownloadRequest* _tmp24_ = NULL;
		SoupCookieJar* _tmp25_ = NULL;
		EDMDownloadRequest* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		SoupURI* _tmp28_ = NULL;
		SoupURI* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
#line 37 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp3_ = edm_download_request_new ();
#line 37 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		dlReq = _tmp3_;
#line 43 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp4_ = dlReq;
#line 43 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp5_ = download;
#line 43 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp6_ = webkit_download_get_uri (_tmp5_);
#line 43 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp7_ = g_strdup (_tmp6_);
#line 43 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_free0 (_tmp4_->uri);
#line 43 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp4_->uri = _tmp7_;
#line 44 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp8_ = download;
#line 44 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp9_ = webkit_download_get_network_request (_tmp8_);
#line 44 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp10_ = _g_object_ref0 (_tmp9_);
#line 44 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		request = _tmp10_;
#line 45 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp11_ = request;
#line 45 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp12_ = webkit_network_request_get_message (_tmp11_);
#line 45 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp13_ = _g_object_ref0 (_tmp12_);
#line 45 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		message = _tmp13_;
#line 46 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp14_ = message;
#line 46 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp15_ = _tmp14_->request_headers;
#line 46 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		headers = _tmp15_;
#line 49 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp16_ = dlReq;
#line 49 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp17_ = headers;
#line 49 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp18_ = soup_message_headers_get (_tmp17_, "Authorization");
#line 49 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp19_ = g_strdup (_tmp18_);
#line 49 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_free0 (_tmp16_->auth);
#line 49 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp16_->auth = _tmp19_;
#line 50 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp20_ = dlReq;
#line 50 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp21_ = headers;
#line 50 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp22_ = soup_message_headers_get (_tmp21_, "Referer");
#line 50 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp23_ = g_strdup (_tmp22_);
#line 50 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_free0 (_tmp20_->referer);
#line 50 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp20_->referer = _tmp23_;
#line 51 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp24_ = dlReq;
#line 51 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp25_ = self->priv->cookie_jar;
#line 51 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp26_ = dlReq;
#line 51 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp27_ = _tmp26_->uri;
#line 51 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp28_ = soup_uri_new (_tmp27_);
#line 51 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp29_ = _tmp28_;
#line 51 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp30_ = soup_cookie_jar_get_cookies (_tmp25_, _tmp29_, TRUE);
#line 51 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_free0 (_tmp24_->cookie_header);
#line 51 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp24_->cookie_header = _tmp30_;
#line 51 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		__vala_SoupURI_free0 (_tmp29_);
#line 726 "external-download-manager.c"
		{
			gint i = 0;
#line 53 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			i = 0;
#line 731 "external-download-manager.c"
			{
				gboolean _tmp31_ = FALSE;
#line 53 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
				_tmp31_ = TRUE;
#line 53 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
				while (TRUE) {
#line 738 "external-download-manager.c"
					gint _tmp33_ = 0;
					GPtrArray* _tmp34_ = NULL;
					guint _tmp35_ = 0U;
					EDMExternalDownloadManager* dm = NULL;
					GPtrArray* _tmp36_ = NULL;
					gint _tmp37_ = 0;
					void* _tmp38_ = NULL;
					EDMExternalDownloadManager* _tmp39_ = NULL;
					EDMExternalDownloadManager* _tmp40_ = NULL;
					EDMDownloadRequest* _tmp41_ = NULL;
					gboolean _tmp42_ = FALSE;
#line 53 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
					if (!_tmp31_) {
#line 752 "external-download-manager.c"
						gint _tmp32_ = 0;
#line 53 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
						_tmp32_ = i;
#line 53 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
						i = _tmp32_ + 1;
#line 758 "external-download-manager.c"
					}
#line 53 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
					_tmp31_ = FALSE;
#line 53 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
					_tmp33_ = i;
#line 53 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
					_tmp34_ = self->priv->download_managers;
#line 53 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
					_tmp35_ = _tmp34_->len;
#line 53 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
					if (!(((guint) _tmp33_) < _tmp35_)) {
#line 53 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
						break;
#line 772 "external-download-manager.c"
					}
#line 54 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
					_tmp36_ = self->priv->download_managers;
#line 54 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
					_tmp37_ = i;
#line 54 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
					_tmp38_ = g_ptr_array_index (_tmp36_, (guint) _tmp37_);
#line 54 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
					_tmp39_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp38_, EDM_TYPE_EXTERNAL_DOWNLOAD_MANAGER) ? ((EDMExternalDownloadManager*) _tmp38_) : NULL);
#line 54 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
					dm = _tmp39_;
#line 55 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
					_tmp40_ = dm;
#line 55 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
					_tmp41_ = dlReq;
#line 55 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
					_tmp42_ = edm_external_download_manager_download (_tmp40_, _tmp41_);
#line 55 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
					if (_tmp42_) {
#line 56 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
						result = TRUE;
#line 56 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
						_g_object_unref0 (dm);
#line 56 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
						_g_object_unref0 (message);
#line 56 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
						_g_object_unref0 (request);
#line 56 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
						_g_object_unref0 (dlReq);
#line 56 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
						return result;
#line 804 "external-download-manager.c"
					}
#line 53 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
					_g_object_unref0 (dm);
#line 808 "external-download-manager.c"
				}
			}
		}
#line 36 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_object_unref0 (message);
#line 36 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_object_unref0 (request);
#line 36 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_object_unref0 (dlReq);
#line 818 "external-download-manager.c"
	}
#line 59 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	result = FALSE;
#line 59 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	return result;
#line 824 "external-download-manager.c"
}


static gboolean _edm_manager_download_requested_midori_view_download_requested (MidoriView* _sender, WebKitDownload* download, gpointer self) {
	gboolean result;
	result = edm_manager_download_requested ((EDMManager*) self, _sender, download);
#line 63 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	return result;
#line 833 "external-download-manager.c"
}


void edm_manager_tab_added (EDMManager* self, MidoriBrowser* browser, MidoriView* view) {
	MidoriView* _tmp0_ = NULL;
#line 62 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_if_fail (self != NULL);
#line 62 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_if_fail (browser != NULL);
#line 62 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_if_fail (view != NULL);
#line 63 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp0_ = view;
#line 63 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_signal_connect_object (_tmp0_, "download-requested", (GCallback) _edm_manager_download_requested_midori_view_download_requested, self, 0);
#line 849 "external-download-manager.c"
}


void edm_manager_tab_removed (EDMManager* self, MidoriBrowser* browser, MidoriView* view) {
	MidoriView* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
#line 66 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_if_fail (self != NULL);
#line 66 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_if_fail (browser != NULL);
#line 66 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_if_fail (view != NULL);
#line 67 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp0_ = view;
#line 67 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_signal_parse_name ("download-requested", MIDORI_TYPE_VIEW, &_tmp1_, NULL, FALSE);
#line 67 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _edm_manager_download_requested_midori_view_download_requested, self);
#line 868 "external-download-manager.c"
}


static void _edm_manager_tab_added_midori_browser_add_tab (MidoriBrowser* _sender, MidoriView* tab, gpointer self) {
#line 73 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	edm_manager_tab_added ((EDMManager*) self, _sender, tab);
#line 875 "external-download-manager.c"
}


static void _edm_manager_tab_removed_midori_browser_remove_tab (MidoriBrowser* _sender, MidoriView* tab, gpointer self) {
#line 74 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	edm_manager_tab_removed ((EDMManager*) self, _sender, tab);
#line 882 "external-download-manager.c"
}


void edm_manager_browser_added (EDMManager* self, MidoriBrowser* browser) {
	MidoriBrowser* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	MidoriBrowser* _tmp4_ = NULL;
	MidoriBrowser* _tmp5_ = NULL;
#line 70 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_if_fail (self != NULL);
#line 70 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_if_fail (browser != NULL);
#line 71 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp0_ = browser;
#line 71 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp1_ = midori_browser_get_tabs (_tmp0_);
#line 899 "external-download-manager.c"
	{
		GList* tab_collection = NULL;
		GList* tab_it = NULL;
#line 71 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		tab_collection = _tmp1_;
#line 71 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		for (tab_it = tab_collection; tab_it != NULL; tab_it = tab_it->next) {
#line 907 "external-download-manager.c"
			MidoriView* tab = NULL;
#line 71 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			tab = (MidoriView*) tab_it->data;
#line 911 "external-download-manager.c"
			{
				MidoriBrowser* _tmp2_ = NULL;
				MidoriView* _tmp3_ = NULL;
#line 72 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
				_tmp2_ = browser;
#line 72 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
				_tmp3_ = tab;
#line 72 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
				edm_manager_tab_added (self, _tmp2_, _tmp3_);
#line 921 "external-download-manager.c"
			}
		}
#line 71 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_list_free0 (tab_collection);
#line 926 "external-download-manager.c"
	}
#line 73 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp4_ = browser;
#line 73 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_signal_connect_object (_tmp4_, "add-tab", (GCallback) _edm_manager_tab_added_midori_browser_add_tab, self, 0);
#line 74 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp5_ = browser;
#line 74 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_signal_connect_object (_tmp5_, "remove-tab", (GCallback) _edm_manager_tab_removed_midori_browser_remove_tab, self, 0);
#line 936 "external-download-manager.c"
}


void edm_manager_browser_removed (EDMManager* self, MidoriBrowser* browser) {
	MidoriBrowser* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	MidoriBrowser* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	MidoriBrowser* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
#line 77 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_if_fail (self != NULL);
#line 77 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_if_fail (browser != NULL);
#line 78 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp0_ = browser;
#line 78 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp1_ = midori_browser_get_tabs (_tmp0_);
#line 955 "external-download-manager.c"
	{
		GList* tab_collection = NULL;
		GList* tab_it = NULL;
#line 78 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		tab_collection = _tmp1_;
#line 78 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		for (tab_it = tab_collection; tab_it != NULL; tab_it = tab_it->next) {
#line 963 "external-download-manager.c"
			MidoriView* tab = NULL;
#line 78 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			tab = (MidoriView*) tab_it->data;
#line 967 "external-download-manager.c"
			{
				MidoriBrowser* _tmp2_ = NULL;
				MidoriView* _tmp3_ = NULL;
#line 79 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
				_tmp2_ = browser;
#line 79 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
				_tmp3_ = tab;
#line 79 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
				edm_manager_tab_removed (self, _tmp2_, _tmp3_);
#line 977 "external-download-manager.c"
			}
		}
#line 78 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_list_free0 (tab_collection);
#line 982 "external-download-manager.c"
	}
#line 80 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp4_ = browser;
#line 80 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_signal_parse_name ("add-tab", MIDORI_TYPE_BROWSER, &_tmp5_, NULL, FALSE);
#line 80 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _edm_manager_tab_added_midori_browser_add_tab, self);
#line 81 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp6_ = browser;
#line 81 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_signal_parse_name ("remove-tab", MIDORI_TYPE_BROWSER, &_tmp7_, NULL, FALSE);
#line 81 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _edm_manager_tab_removed_midori_browser_remove_tab, self);
#line 996 "external-download-manager.c"
}


static void _edm_manager_browser_added_midori_app_add_browser (MidoriApp* _sender, MidoriBrowser* browser, gpointer self) {
#line 89 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	edm_manager_browser_added ((EDMManager*) self, browser);
#line 1003 "external-download-manager.c"
}


void edm_manager_activated (EDMManager* self, MidoriExtension* extension, MidoriApp* app) {
	GPtrArray* _tmp0_ = NULL;
	MidoriExtension* _tmp1_ = NULL;
	GPtrArray* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
#line 84 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_if_fail (self != NULL);
#line 84 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_if_fail (extension != NULL);
#line 84 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_if_fail (app != NULL);
#line 85 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp0_ = self->priv->download_managers;
#line 85 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp1_ = extension;
#line 85 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_ptr_array_add (_tmp0_, _tmp1_);
#line 86 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp2_ = self->priv->download_managers;
#line 86 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp3_ = _tmp2_->len;
#line 86 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	if (_tmp3_ == ((guint) 1)) {
#line 1030 "external-download-manager.c"
		MidoriApp* _tmp4_ = NULL;
		GList* _tmp5_ = NULL;
		MidoriApp* _tmp7_ = NULL;
#line 87 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp4_ = app;
#line 87 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp5_ = midori_app_get_browsers (_tmp4_);
#line 1038 "external-download-manager.c"
		{
			GList* browser_collection = NULL;
			GList* browser_it = NULL;
#line 87 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			browser_collection = _tmp5_;
#line 87 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			for (browser_it = browser_collection; browser_it != NULL; browser_it = browser_it->next) {
#line 1046 "external-download-manager.c"
				MidoriBrowser* browser = NULL;
#line 87 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
				browser = (MidoriBrowser*) browser_it->data;
#line 1050 "external-download-manager.c"
				{
					MidoriBrowser* _tmp6_ = NULL;
#line 88 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
					_tmp6_ = browser;
#line 88 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
					edm_manager_browser_added (self, _tmp6_);
#line 1057 "external-download-manager.c"
				}
			}
#line 87 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			_g_list_free0 (browser_collection);
#line 1062 "external-download-manager.c"
		}
#line 89 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp7_ = app;
#line 89 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		g_signal_connect_object (_tmp7_, "add-browser", (GCallback) _edm_manager_browser_added_midori_app_add_browser, self, 0);
#line 1068 "external-download-manager.c"
	}
}


void edm_manager_deactivated (EDMManager* self, MidoriExtension* extension) {
	GPtrArray* _tmp0_ = NULL;
	MidoriExtension* _tmp1_ = NULL;
	GPtrArray* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
#line 93 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_if_fail (self != NULL);
#line 93 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_if_fail (extension != NULL);
#line 94 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp0_ = self->priv->download_managers;
#line 94 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp1_ = extension;
#line 94 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_ptr_array_remove (_tmp0_, _tmp1_);
#line 95 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp2_ = self->priv->download_managers;
#line 95 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp3_ = _tmp2_->len;
#line 95 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	if (_tmp3_ == ((guint) 0)) {
#line 1094 "external-download-manager.c"
		MidoriApp* app = NULL;
		MidoriExtension* _tmp4_ = NULL;
		MidoriApp* _tmp5_ = NULL;
		MidoriApp* _tmp6_ = NULL;
		MidoriApp* _tmp7_ = NULL;
		GList* _tmp8_ = NULL;
		MidoriApp* _tmp10_ = NULL;
		guint _tmp11_ = 0U;
#line 96 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp4_ = extension;
#line 96 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp5_ = midori_extension_get_app (_tmp4_);
#line 96 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp6_ = _g_object_ref0 (_tmp5_);
#line 96 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		app = _tmp6_;
#line 97 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp7_ = app;
#line 97 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp8_ = midori_app_get_browsers (_tmp7_);
#line 1115 "external-download-manager.c"
		{
			GList* browser_collection = NULL;
			GList* browser_it = NULL;
#line 97 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			browser_collection = _tmp8_;
#line 97 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			for (browser_it = browser_collection; browser_it != NULL; browser_it = browser_it->next) {
#line 1123 "external-download-manager.c"
				MidoriBrowser* browser = NULL;
#line 97 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
				browser = (MidoriBrowser*) browser_it->data;
#line 1127 "external-download-manager.c"
				{
					MidoriBrowser* _tmp9_ = NULL;
#line 98 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
					_tmp9_ = browser;
#line 98 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
					edm_manager_browser_removed (self, _tmp9_);
#line 1134 "external-download-manager.c"
				}
			}
#line 97 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			_g_list_free0 (browser_collection);
#line 1139 "external-download-manager.c"
		}
#line 99 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp10_ = app;
#line 99 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		g_signal_parse_name ("add-browser", MIDORI_TYPE_APP, &_tmp11_, NULL, FALSE);
#line 99 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		g_signal_handlers_disconnect_matched (_tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _edm_manager_browser_added_midori_app_add_browser, self);
#line 95 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_object_unref0 (app);
#line 1149 "external-download-manager.c"
	}
}


EDMManager* edm_manager_construct (GType object_type) {
	EDMManager * self = NULL;
#line 29 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	self = (EDMManager*) g_object_new (object_type, NULL);
#line 29 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	return self;
#line 1160 "external-download-manager.c"
}


EDMManager* edm_manager_new (void) {
#line 29 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	return edm_manager_construct (EDM_TYPE_MANAGER);
#line 1167 "external-download-manager.c"
}


static GObject * edm_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	EDMManager * self;
	SoupSession* session = NULL;
	SoupSession* _tmp0_ = NULL;
	SoupSession* _tmp1_ = NULL;
	SoupSession* _tmp2_ = NULL;
	SoupSessionFeature* _tmp3_ = NULL;
	SoupCookieJar* _tmp4_ = NULL;
#line 103 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	parent_class = G_OBJECT_CLASS (edm_manager_parent_class);
#line 103 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 103 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EDM_TYPE_MANAGER, EDMManager);
#line 107 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp0_ = webkit_get_default_session ();
#line 107 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 107 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	session = _tmp1_;
#line 109 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp2_ = session;
#line 109 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp3_ = soup_session_get_feature (_tmp2_, soup_cookie_jar_get_type ());
#line 109 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, soup_cookie_jar_get_type ()) ? ((SoupCookieJar*) _tmp3_) : NULL);
#line 109 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_g_object_unref0 (self->priv->cookie_jar);
#line 109 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	self->priv->cookie_jar = _tmp4_;
#line 103 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_g_object_unref0 (session);
#line 103 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	return obj;
#line 1207 "external-download-manager.c"
}


static void edm_manager_class_init (EDMManagerClass * klass) {
#line 29 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	edm_manager_parent_class = g_type_class_peek_parent (klass);
#line 29 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_type_class_add_private (klass, sizeof (EDMManagerPrivate));
#line 29 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	G_OBJECT_CLASS (klass)->constructor = edm_manager_constructor;
#line 29 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	G_OBJECT_CLASS (klass)->finalize = edm_manager_finalize;
#line 1220 "external-download-manager.c"
}


static void edm_manager_instance_init (EDMManager * self) {
	GPtrArray* _tmp0_ = NULL;
#line 29 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	self->priv = EDM_MANAGER_GET_PRIVATE (self);
#line 31 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp0_ = g_ptr_array_new ();
#line 31 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	self->priv->download_managers = _tmp0_;
#line 1232 "external-download-manager.c"
}


static void edm_manager_finalize (GObject* obj) {
	EDMManager * self;
#line 29 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EDM_TYPE_MANAGER, EDMManager);
#line 30 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_g_object_unref0 (self->priv->cookie_jar);
#line 31 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_g_ptr_array_unref0 (self->priv->download_managers);
#line 29 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	G_OBJECT_CLASS (edm_manager_parent_class)->finalize (obj);
#line 1246 "external-download-manager.c"
}


GType edm_manager_get_type (void) {
	static volatile gsize edm_manager_type_id__volatile = 0;
	if (g_once_init_enter (&edm_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EDMManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) edm_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EDMManager), 0, (GInstanceInitFunc) edm_manager_instance_init, NULL };
		GType edm_manager_type_id;
		edm_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "EDMManager", &g_define_type_info, 0);
		g_once_init_leave (&edm_manager_type_id__volatile, edm_manager_type_id);
	}
	return edm_manager_type_id__volatile;
}


void edm_external_download_manager_activated (EDMExternalDownloadManager* self, MidoriApp* app) {
	EDMManager* _tmp0_ = NULL;
	MidoriApp* _tmp1_ = NULL;
#line 114 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_if_fail (self != NULL);
#line 114 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_if_fail (app != NULL);
#line 115 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp0_ = edm_manager;
#line 115 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp1_ = app;
#line 115 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	edm_manager_activated (_tmp0_, (MidoriExtension*) self, _tmp1_);
#line 1275 "external-download-manager.c"
}


void edm_external_download_manager_deactivated (EDMExternalDownloadManager* self) {
	EDMManager* _tmp0_ = NULL;
#line 118 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_if_fail (self != NULL);
#line 119 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp0_ = edm_manager;
#line 119 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	edm_manager_deactivated (_tmp0_, (MidoriExtension*) self);
#line 1287 "external-download-manager.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 122 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 122 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	return _data1_;
#line 1296 "external-download-manager.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 122 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 1305 "external-download-manager.c"
		EDMExternalDownloadManager* self;
#line 122 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		self = _data1_->self;
#line 122 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_object_unref0 (_data1_->dialog);
#line 122 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_object_unref0 (self);
#line 122 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		g_slice_free (Block1Data, _data1_);
#line 1315 "external-download-manager.c"
	}
}


static void __lambda4_ (Block1Data* _data1_, gint a) {
	EDMExternalDownloadManager* self;
#line 133 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	self = _data1_->self;
#line 133 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	gtk_object_destroy ((GtkObject*) _data1_->dialog);
#line 1326 "external-download-manager.c"
}


static void ___lambda4__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 133 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	__lambda4_ (self, response_id);
#line 1333 "external-download-manager.c"
}


void edm_external_download_manager_handle_exception (EDMExternalDownloadManager* self, GError* _error_) {
	Block1Data* _data1_;
	gchar* ext_name = NULL;
	const gchar* _tmp0_ = NULL;
	GError* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkMessageDialog* _tmp3_ = NULL;
#line 122 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_if_fail (self != NULL);
#line 122 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 122 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_data1_->_ref_count_ = 1;
#line 122 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_data1_->self = g_object_ref (self);
#line 124 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_object_get ((GObject*) self, "name", &ext_name, NULL);
#line 125 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp0_ = _ ("An error occurred when attempting to download a file with the followin" \
"g plugin:\n" "%s\n\n" "Error:\n%s\n\n" "Carry on without this plugin.");
#line 125 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp1_ = _error_;
#line 125 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp2_ = _tmp1_->message;
#line 125 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp3_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _tmp0_, ext_name, _tmp2_);
#line 125 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_object_ref_sink (_tmp3_);
#line 125 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_data1_->dialog = _tmp3_;
#line 133 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_signal_connect_data ((GtkDialog*) _data1_->dialog, "response", (GCallback) ___lambda4__gtk_dialog_response, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 134 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	gtk_dialog_run ((GtkDialog*) _data1_->dialog);
#line 122 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_g_free0 (ext_name);
#line 122 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	block1_data_unref (_data1_);
#line 122 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_data1_ = NULL;
#line 1376 "external-download-manager.c"
}


static gboolean edm_external_download_manager_real_download (EDMExternalDownloadManager* self, EDMDownloadRequest* dlReq) {
#line 137 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_critical ("Type `%s' does not implement abstract method `edm_external_download_manager_download'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 137 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	return FALSE;
#line 1385 "external-download-manager.c"
}


gboolean edm_external_download_manager_download (EDMExternalDownloadManager* self, EDMDownloadRequest* dlReq) {
#line 137 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 137 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	return EDM_EXTERNAL_DOWNLOAD_MANAGER_GET_CLASS (self)->download (self, dlReq);
#line 1394 "external-download-manager.c"
}


EDMExternalDownloadManager* edm_external_download_manager_construct (GType object_type) {
	EDMExternalDownloadManager * self = NULL;
#line 113 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	self = (EDMExternalDownloadManager*) g_object_new (object_type, NULL);
#line 113 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	return self;
#line 1404 "external-download-manager.c"
}


static void edm_external_download_manager_class_init (EDMExternalDownloadManagerClass * klass) {
#line 113 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	edm_external_download_manager_parent_class = g_type_class_peek_parent (klass);
#line 113 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	((EDMExternalDownloadManagerClass *) klass)->download = edm_external_download_manager_real_download;
#line 1413 "external-download-manager.c"
}


static void edm_external_download_manager_instance_init (EDMExternalDownloadManager * self) {
}


GType edm_external_download_manager_get_type (void) {
	static volatile gsize edm_external_download_manager_type_id__volatile = 0;
	if (g_once_init_enter (&edm_external_download_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EDMExternalDownloadManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) edm_external_download_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EDMExternalDownloadManager), 0, (GInstanceInitFunc) edm_external_download_manager_instance_init, NULL };
		GType edm_external_download_manager_type_id;
		edm_external_download_manager_type_id = g_type_register_static (MIDORI_TYPE_EXTENSION, "EDMExternalDownloadManager", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&edm_external_download_manager_type_id__volatile, edm_external_download_manager_type_id);
	}
	return edm_external_download_manager_type_id__volatile;
}


static GValue* _g_value_dup (GValue* self) {
#line 149 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	return g_boxed_copy (G_TYPE_VALUE, self);
#line 1436 "external-download-manager.c"
}


static gpointer __g_value_dup0 (gpointer self) {
#line 149 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	return self ? _g_value_dup (self) : NULL;
#line 1443 "external-download-manager.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 169 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 169 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	return _data2_;
#line 1452 "external-download-manager.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 169 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 1461 "external-download-manager.c"
		EDMAria2* self;
#line 169 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		self = _data2_->self;
#line 169 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_object_unref0 (_data2_->dialog);
#line 169 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_object_unref0 (self);
#line 169 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		g_slice_free (Block2Data, _data2_);
#line 1471 "external-download-manager.c"
	}
}


static void ___lambda5_ (Block2Data* _data2_, gint a) {
	EDMAria2* self;
	GtkMessageDialog* _tmp0_ = NULL;
#line 179 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	self = _data2_->self;
#line 179 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp0_ = _data2_->dialog;
#line 179 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	gtk_object_destroy ((GtkObject*) _tmp0_);
#line 1485 "external-download-manager.c"
}


static void ____lambda5__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 179 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	___lambda5_ (self, response_id);
#line 1492 "external-download-manager.c"
}


static void _vala_SoupBuffer_free (SoupBuffer* self) {
#line 185 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_boxed_free (soup_buffer_get_type (), self);
#line 1499 "external-download-manager.c"
}


static gboolean edm_aria2_real_download (EDMExternalDownloadManager* base, EDMDownloadRequest* dlReq) {
	EDMAria2 * self;
	gboolean result = FALSE;
	GValueArray* url = NULL;
	GValueArray* _tmp0_ = NULL;
	GValueArray* _tmp1_ = NULL;
	EDMDownloadRequest* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GHashTable* options = NULL;
	GHashTable* _tmp4_ = NULL;
	GValue referer = {0};
	GValue _tmp5_ = {0};
	EDMDownloadRequest* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GHashTable* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	GValue _tmp10_ = {0};
	GValue _tmp11_ = {0};
	GValue* _tmp12_ = NULL;
	GValueArray* headers = NULL;
	GValueArray* _tmp13_ = NULL;
	EDMDownloadRequest* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	GValueArray* _tmp21_ = NULL;
	guint _tmp22_ = 0U;
	SoupMessage* message = NULL;
	GValueArray* _tmp27_ = NULL;
	GHashTable* _tmp28_ = NULL;
	SoupMessage* _tmp29_ = NULL;
	SoupSessionSync* session = NULL;
	SoupSessionSync* _tmp30_ = NULL;
	SoupSessionSync* _tmp31_ = NULL;
	SoupMessage* _tmp32_ = NULL;
	SoupMessage* _tmp33_ = NULL;
	guint _tmp34_ = 0U;
	guint _tmp35_ = 0U;
	GError * _inner_error_ = NULL;
#line 142 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	self = (EDMAria2*) base;
#line 142 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_val_if_fail (dlReq != NULL, FALSE);
#line 143 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp0_ = soup_value_array_new ();
#line 143 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	url = _tmp0_;
#line 144 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp1_ = url;
#line 144 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp2_ = dlReq;
#line 144 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp3_ = _tmp2_->uri;
#line 144 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	soup_value_array_insert (_tmp1_, (guint) 0, G_TYPE_STRING, _tmp3_, NULL);
#line 146 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp4_ = soup_value_hash_new ();
#line 146 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	options = _tmp4_;
#line 147 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_value_init (&_tmp5_, G_TYPE_STRING);
#line 147 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	referer = _tmp5_;
#line 148 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp6_ = dlReq;
#line 148 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp7_ = _tmp6_->referer;
#line 148 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_value_set_string (&referer, _tmp7_);
#line 149 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp8_ = options;
#line 149 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp9_ = g_strdup ("referer");
#line 149 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp10_ = referer;
#line 149 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp11_ = _tmp10_;
#line 149 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp12_ = __g_value_dup0 (&_tmp11_);
#line 149 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_hash_table_insert (_tmp8_, _tmp9_, _tmp12_);
#line 151 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp13_ = soup_value_array_new ();
#line 151 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	headers = _tmp13_;
#line 152 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp14_ = dlReq;
#line 152 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp15_ = _tmp14_->cookie_header;
#line 152 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	if (_tmp15_ != NULL) {
#line 1592 "external-download-manager.c"
		GValueArray* _tmp16_ = NULL;
		EDMDownloadRequest* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
#line 153 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp16_ = headers;
#line 153 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp17_ = dlReq;
#line 153 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp18_ = _tmp17_->cookie_header;
#line 153 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp19_ = g_strconcat ("Cookie: ", _tmp18_, NULL);
#line 153 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp20_ = _tmp19_;
#line 153 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		soup_value_array_insert (_tmp16_, (guint) 0, G_TYPE_STRING, _tmp20_, NULL);
#line 153 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_free0 (_tmp20_);
#line 1612 "external-download-manager.c"
	}
#line 156 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp21_ = headers;
#line 156 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp22_ = _tmp21_->n_values;
#line 156 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	if (_tmp22_ > ((guint) 0)) {
#line 1620 "external-download-manager.c"
		GHashTable* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		GValueArray* _tmp25_ = NULL;
		GValue* _tmp26_ = NULL;
#line 157 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp23_ = options;
#line 157 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp24_ = g_strdup ("header");
#line 157 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp25_ = headers;
#line 157 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp26_ = g_new0 (GValue, 1);
#line 157 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		g_value_init (_tmp26_, G_TYPE_VALUE_ARRAY);
#line 157 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		g_value_set_boxed (_tmp26_, _tmp25_);
#line 157 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		g_hash_table_insert (_tmp23_, _tmp24_, _tmp26_);
#line 1639 "external-download-manager.c"
	}
#line 159 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp27_ = url;
#line 159 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp28_ = options;
#line 159 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp29_ = soup_xmlrpc_request_new ("http://127.0.0.1:6800/rpc", "aria2.addUri", G_TYPE_VALUE_ARRAY, _tmp27_, G_TYPE_HASH_TABLE, _tmp28_, G_TYPE_INVALID);
#line 159 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	message = _tmp29_;
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp30_ = (SoupSessionSync*) soup_session_sync_new ();
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	session = _tmp30_;
#line 164 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp31_ = session;
#line 164 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp32_ = message;
#line 164 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	soup_session_send_message ((SoupSession*) _tmp31_, _tmp32_);
#line 169 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp33_ = message;
#line 169 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_object_get (_tmp33_, "status-code", &_tmp34_, NULL);
#line 169 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp35_ = _tmp34_;
#line 169 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	if (_tmp35_ != ((guint) 200)) {
#line 1667 "external-download-manager.c"
		Block2Data* _data2_;
		const gchar* _tmp36_ = NULL;
		GtkMessageDialog* _tmp37_ = NULL;
		GtkMessageDialog* _tmp38_ = NULL;
		GtkMessageDialog* _tmp39_ = NULL;
#line 169 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_data2_ = g_slice_new0 (Block2Data);
#line 169 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_data2_->_ref_count_ = 1;
#line 169 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_data2_->self = g_object_ref (self);
#line 170 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp36_ = _ ("The plug-in was unable to connect with aria2:\n" "Please make sure that aria2 is running with rpc enabled ie: aria2c --e" \
"nable-rpc\n" "If it's so, check it also is using the port 6800.\n" "Lastly Check the configuration of your firewall.\n" "Whitelist aria2 and the port 6800 if they aren't.");
#line 170 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp37_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", _tmp36_);
#line 170 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		g_object_ref_sink (_tmp37_);
#line 170 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_data2_->dialog = _tmp37_;
#line 179 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp38_ = _data2_->dialog;
#line 179 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		g_signal_connect_data ((GtkDialog*) _tmp38_, "response", (GCallback) ____lambda5__gtk_dialog_response, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 180 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp39_ = _data2_->dialog;
#line 180 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		gtk_dialog_run ((GtkDialog*) _tmp39_);
#line 169 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		block2_data_unref (_data2_);
#line 169 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_data2_ = NULL;
#line 1699 "external-download-manager.c"
	}
	{
		GValue v = {0};
		SoupMessage* _tmp40_ = NULL;
		SoupMessageBody* _tmp41_ = NULL;
		SoupBuffer* _tmp42_ = NULL;
		SoupBuffer* _tmp43_ = NULL;
		guint8* _tmp44_ = NULL;
		gint _tmp44__length1 = 0;
		GValue _tmp45_ = {0};
#line 185 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp40_ = message;
#line 185 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp41_ = _tmp40_->response_body;
#line 185 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp42_ = soup_message_body_flatten (_tmp41_);
#line 185 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp43_ = _tmp42_;
#line 185 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp44_ = _tmp43_->data;
#line 185 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp44__length1 = (gint) _tmp43_->length;
#line 185 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		soup_xmlrpc_parse_method_response ((const gchar*) _tmp44_, -1, &_tmp45_, &_inner_error_);
#line 185 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 185 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		v = _tmp45_;
#line 185 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		__vala_SoupBuffer_free0 (_tmp43_);
#line 185 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 185 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 1734 "external-download-manager.c"
			goto __catch0_g_error;
		}
#line 186 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		result = TRUE;
#line 186 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 186 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_object_unref0 (session);
#line 186 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_object_unref0 (message);
#line 186 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_value_array_free0 (headers);
#line 186 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		G_IS_VALUE (&referer) ? (g_value_unset (&referer), NULL) : NULL;
#line 186 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_hash_table_unref0 (options);
#line 186 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_value_array_free0 (url);
#line 186 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		return result;
#line 1755 "external-download-manager.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp46_ = NULL;
#line 183 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		e = _inner_error_;
#line 183 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_inner_error_ = NULL;
#line 188 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp46_ = e;
#line 188 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		edm_external_download_manager_handle_exception ((EDMExternalDownloadManager*) self, _tmp46_);
#line 183 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_error_free0 (e);
#line 1772 "external-download-manager.c"
	}
	__finally0:
#line 183 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 183 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_object_unref0 (session);
#line 183 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_object_unref0 (message);
#line 183 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_value_array_free0 (headers);
#line 183 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		G_IS_VALUE (&referer) ? (g_value_unset (&referer), NULL) : NULL;
#line 183 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_hash_table_unref0 (options);
#line 183 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_value_array_free0 (url);
#line 183 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 183 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		g_clear_error (&_inner_error_);
#line 183 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		return FALSE;
#line 1795 "external-download-manager.c"
	}
#line 191 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	result = FALSE;
#line 191 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_g_object_unref0 (session);
#line 191 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_g_object_unref0 (message);
#line 191 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_g_value_array_free0 (headers);
#line 191 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	G_IS_VALUE (&referer) ? (g_value_unset (&referer), NULL) : NULL;
#line 191 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_g_hash_table_unref0 (options);
#line 191 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_g_value_array_free0 (url);
#line 191 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	return result;
#line 1813 "external-download-manager.c"
}


static void _edm_external_download_manager_activated_midori_extension_activate (MidoriExtension* _sender, MidoriApp* app, gpointer self) {
#line 201 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	edm_external_download_manager_activated ((EDMExternalDownloadManager*) self, app);
#line 1820 "external-download-manager.c"
}


static void _edm_external_download_manager_deactivated_midori_extension_deactivate (MidoriExtension* _sender, gpointer self) {
#line 202 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	edm_external_download_manager_deactivated ((EDMExternalDownloadManager*) self);
#line 1827 "external-download-manager.c"
}


EDMAria2* edm_aria2_construct (GType object_type) {
	EDMAria2 * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 195 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp0_ = _ ("External Download Manager - Aria2");
#line 195 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp1_ = _ ("Download files with Aria2");
#line 195 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	self = (EDMAria2*) g_object_new (object_type, "name", _tmp0_, "description", _tmp1_, "version", "0.1" MIDORI_VERSION_SUFFIX, "authors", "André Stösel <andre@stoesel.de>", "key", "aria2", NULL);
#line 201 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_signal_connect_object ((MidoriExtension*) self, "activate", (GCallback) _edm_external_download_manager_activated_midori_extension_activate, (EDMExternalDownloadManager*) self, 0);
#line 202 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_signal_connect_object ((MidoriExtension*) self, "deactivate", (GCallback) _edm_external_download_manager_deactivated_midori_extension_deactivate, (EDMExternalDownloadManager*) self, 0);
#line 194 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	return self;
#line 1847 "external-download-manager.c"
}


EDMAria2* edm_aria2_new (void) {
#line 194 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	return edm_aria2_construct (EDM_TYPE_ARIA2);
#line 1854 "external-download-manager.c"
}


static void edm_aria2_class_init (EDMAria2Class * klass) {
#line 141 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	edm_aria2_parent_class = g_type_class_peek_parent (klass);
#line 141 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	((EDMExternalDownloadManagerClass *) klass)->download = edm_aria2_real_download;
#line 1863 "external-download-manager.c"
}


static void edm_aria2_instance_init (EDMAria2 * self) {
}


GType edm_aria2_get_type (void) {
	static volatile gsize edm_aria2_type_id__volatile = 0;
	if (g_once_init_enter (&edm_aria2_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EDMAria2Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) edm_aria2_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EDMAria2), 0, (GInstanceInitFunc) edm_aria2_instance_init, NULL };
		GType edm_aria2_type_id;
		edm_aria2_type_id = g_type_register_static (EDM_TYPE_EXTERNAL_DOWNLOAD_MANAGER, "EDMAria2", &g_define_type_info, 0);
		g_once_init_leave (&edm_aria2_type_id__volatile, edm_aria2_type_id);
	}
	return edm_aria2_type_id__volatile;
}


static gboolean edm_steady_flow_real_download (EDMExternalDownloadManager* base, EDMDownloadRequest* dlReq) {
	EDMSteadyFlow * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 207 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	self = (EDMSteadyFlow*) base;
#line 207 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_val_if_fail (dlReq != NULL, FALSE);
#line 1891 "external-download-manager.c"
	{
		EDMSteadyflowInterface* dm = NULL;
		EDMSteadyflowInterface* _tmp0_ = NULL;
		EDMSteadyflowInterface* _tmp1_ = NULL;
		EDMDownloadRequest* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 209 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp0_ = g_initable_new (EDM_TYPE_STEADYFLOW_INTERFACE_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", "net.launchpad.steadyflow.App", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/net/launchpad/steadyflow/app", "g-interface-name", "net.launchpad.steadyflow.App", "g-interface-info", g_type_get_qdata (EDM_TYPE_STEADYFLOW_INTERFACE, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
#line 209 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		dm = (EDMSteadyflowInterface*) _tmp0_;
#line 209 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1904 "external-download-manager.c"
			goto __catch1_g_error;
		}
#line 213 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp1_ = dm;
#line 213 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp2_ = dlReq;
#line 213 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp3_ = _tmp2_->uri;
#line 213 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		edm_steadyflow_interface_AddFile (_tmp1_, _tmp3_, &_inner_error_);
#line 213 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 213 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			_g_object_unref0 (dm);
#line 1919 "external-download-manager.c"
			goto __catch1_g_error;
		}
#line 214 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		result = TRUE;
#line 214 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_object_unref0 (dm);
#line 214 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		return result;
#line 1928 "external-download-manager.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
#line 208 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		e = _inner_error_;
#line 208 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_inner_error_ = NULL;
#line 216 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp4_ = e;
#line 216 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		edm_external_download_manager_handle_exception ((EDMExternalDownloadManager*) self, _tmp4_);
#line 208 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_error_free0 (e);
#line 1945 "external-download-manager.c"
	}
	__finally1:
#line 208 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 208 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 208 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		g_clear_error (&_inner_error_);
#line 208 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		return FALSE;
#line 1956 "external-download-manager.c"
	}
#line 218 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	result = FALSE;
#line 218 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	return result;
#line 1962 "external-download-manager.c"
}


EDMSteadyFlow* edm_steady_flow_construct (GType object_type) {
	EDMSteadyFlow * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 222 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp0_ = _ ("External Download Manager - SteadyFlow");
#line 222 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp1_ = _ ("Download files with SteadyFlow");
#line 222 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	self = (EDMSteadyFlow*) g_object_new (object_type, "name", _tmp0_, "description", _tmp1_, "version", "0.1" MIDORI_VERSION_SUFFIX, "authors", "André Stösel <andre@stoesel.de>", "key", "steadyflow", NULL);
#line 228 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_signal_connect_object ((MidoriExtension*) self, "activate", (GCallback) _edm_external_download_manager_activated_midori_extension_activate, (EDMExternalDownloadManager*) self, 0);
#line 229 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_signal_connect_object ((MidoriExtension*) self, "deactivate", (GCallback) _edm_external_download_manager_deactivated_midori_extension_deactivate, (EDMExternalDownloadManager*) self, 0);
#line 221 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	return self;
#line 1982 "external-download-manager.c"
}


EDMSteadyFlow* edm_steady_flow_new (void) {
#line 221 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	return edm_steady_flow_construct (EDM_TYPE_STEADY_FLOW);
#line 1989 "external-download-manager.c"
}


static void edm_steady_flow_class_init (EDMSteadyFlowClass * klass) {
#line 206 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	edm_steady_flow_parent_class = g_type_class_peek_parent (klass);
#line 206 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	((EDMExternalDownloadManagerClass *) klass)->download = edm_steady_flow_real_download;
#line 1998 "external-download-manager.c"
}


static void edm_steady_flow_instance_init (EDMSteadyFlow * self) {
}


GType edm_steady_flow_get_type (void) {
	static volatile gsize edm_steady_flow_type_id__volatile = 0;
	if (g_once_init_enter (&edm_steady_flow_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EDMSteadyFlowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) edm_steady_flow_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EDMSteadyFlow), 0, (GInstanceInitFunc) edm_steady_flow_instance_init, NULL };
		GType edm_steady_flow_type_id;
		edm_steady_flow_type_id = g_type_register_static (EDM_TYPE_EXTERNAL_DOWNLOAD_MANAGER, "EDMSteadyFlow", &g_define_type_info, 0);
		g_once_init_leave (&edm_steady_flow_type_id__volatile, edm_steady_flow_type_id);
	}
	return edm_steady_flow_type_id__volatile;
}


static void _edm_command_line_preferences_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 252 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	edm_command_line_preferences_response_cb ((EDMCommandLinePreferences*) self, _sender, response_id);
#line 2021 "external-download-manager.c"
}


EDMCommandLinePreferences* edm_command_line_preferences_construct (GType object_type, EDMCommandLine* cl) {
	EDMCommandLinePreferences * self = NULL;
	EDMCommandLine* _tmp0_ = NULL;
	EDMCommandLine* _tmp1_ = NULL;
	gchar* ext_name = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GObjectClass* _tmp6_ = NULL;
	GParamSpec* _tmp7_ = NULL;
#line 238 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_val_if_fail (cl != NULL, NULL);
#line 238 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	self = (EDMCommandLinePreferences*) g_object_new (object_type, NULL);
#line 239 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp0_ = cl;
#line 239 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 239 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_g_object_unref0 (self->commandline);
#line 239 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	self->commandline = _tmp1_;
#line 242 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_object_get ((GObject*) self, "name", &ext_name, NULL);
#line 244 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp2_ = _ ("Preferences for %s");
#line 244 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp3_ = ext_name;
#line 244 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp4_ = g_strdup_printf (_tmp2_, _tmp3_);
#line 244 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp5_ = _tmp4_;
#line 244 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	gtk_window_set_title ((GtkWindow*) self, _tmp5_);
#line 244 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_g_free0 (_tmp5_);
#line 245 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp6_ = G_OBJECT_GET_CLASS ((GObject*) self);
#line 245 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp7_ = g_object_class_find_property (_tmp6_, "has-separator");
#line 245 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	if (_tmp7_ != NULL) {
#line 246 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		g_object_set ((GObject*) self, "has-separator", FALSE, NULL);
#line 2070 "external-download-manager.c"
	}
#line 247 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 5);
#line 248 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	gtk_window_set_modal ((GtkWindow*) self, TRUE);
#line 249 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	gtk_window_set_default_size ((GtkWindow*) self, 400, 100);
#line 250 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	edm_command_line_preferences_create_widgets (self);
#line 252 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) _edm_command_line_preferences_response_cb_gtk_dialog_response, self, 0);
#line 238 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_g_free0 (ext_name);
#line 238 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	return self;
#line 2086 "external-download-manager.c"
}


EDMCommandLinePreferences* edm_command_line_preferences_new (EDMCommandLine* cl) {
#line 238 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	return edm_command_line_preferences_construct (EDM_TYPE_COMMAND_LINE_PREFERENCES, cl);
#line 2093 "external-download-manager.c"
}


static void edm_command_line_preferences_response_cb (EDMCommandLinePreferences* self, GtkDialog* source, gint response_id) {
	gint _tmp0_ = 0;
#line 255 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_if_fail (self != NULL);
#line 255 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_if_fail (source != NULL);
#line 256 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp0_ = response_id;
#line 256 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	switch (_tmp0_) {
#line 256 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		case GTK_RESPONSE_APPLY:
#line 2109 "external-download-manager.c"
		{
			EDMCommandLine* _tmp1_ = NULL;
			GtkEntry* _tmp2_ = NULL;
			const gchar* _tmp3_ = NULL;
			EDMCommandLine* _tmp4_ = NULL;
			EDMCommandLine* _tmp5_ = NULL;
			MidoriApp* _tmp6_ = NULL;
#line 258 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			_tmp1_ = self->commandline;
#line 258 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			_tmp2_ = self->input;
#line 258 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			_tmp3_ = gtk_entry_get_text (_tmp2_);
#line 258 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			midori_extension_set_string ((MidoriExtension*) _tmp1_, "commandline", _tmp3_);
#line 259 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			_tmp4_ = self->commandline;
#line 259 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			_tmp5_ = self->commandline;
#line 259 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			_tmp6_ = midori_extension_get_app ((MidoriExtension*) _tmp5_);
#line 259 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			edm_command_line_update_description (_tmp4_, _tmp6_);
#line 260 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			gtk_object_destroy ((GtkObject*) self);
#line 261 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			break;
#line 2137 "external-download-manager.c"
		}
#line 256 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		case GTK_RESPONSE_CANCEL:
#line 2141 "external-download-manager.c"
		{
#line 263 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			gtk_object_destroy ((GtkObject*) self);
#line 264 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			break;
#line 2147 "external-download-manager.c"
		}
		default:
#line 256 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		break;
#line 2152 "external-download-manager.c"
	}
}


static void edm_command_line_preferences_create_widgets (EDMCommandLinePreferences* self) {
	GtkLabel* text = NULL;
	const gchar* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkEntry* _tmp2_ = NULL;
	GtkEntry* _tmp3_ = NULL;
	EDMCommandLine* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkVBox* _tmp6_ = NULL;
	GtkVBox* _tmp7_ = NULL;
	GtkEntry* _tmp8_ = NULL;
#line 268 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_if_fail (self != NULL);
#line 269 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp0_ = _ ("Command:");
#line 269 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp1_ = (GtkLabel*) gtk_label_new (_tmp0_);
#line 269 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_object_ref_sink (_tmp1_);
#line 269 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	text = _tmp1_;
#line 270 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp2_ = (GtkEntry*) gtk_entry_new ();
#line 270 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_object_ref_sink (_tmp2_);
#line 270 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_g_object_unref0 (self->input);
#line 270 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	self->input = _tmp2_;
#line 271 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp3_ = self->input;
#line 271 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp4_ = self->commandline;
#line 271 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp5_ = midori_extension_get_string ((MidoriExtension*) _tmp4_, "commandline");
#line 271 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	gtk_entry_set_text (_tmp3_, _tmp5_);
#line 279 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp6_ = ((GtkDialog*) self)->vbox;
#line 279 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	gtk_box_pack_start ((GtkBox*) _tmp6_, (GtkWidget*) text, FALSE, FALSE, (guint) 0);
#line 280 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp7_ = ((GtkDialog*) self)->vbox;
#line 280 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp8_ = self->input;
#line 280 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	gtk_box_pack_start ((GtkBox*) _tmp7_, (GtkWidget*) _tmp8_, FALSE, TRUE, (guint) 0);
#line 283 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	gtk_dialog_add_button ((GtkDialog*) self, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	gtk_dialog_add_button ((GtkDialog*) self, GTK_STOCK_APPLY, (gint) GTK_RESPONSE_APPLY);
#line 286 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	gtk_widget_show_all ((GtkWidget*) self);
#line 268 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_g_object_unref0 (text);
#line 2212 "external-download-manager.c"
}


static void edm_command_line_preferences_class_init (EDMCommandLinePreferencesClass * klass) {
#line 234 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	edm_command_line_preferences_parent_class = g_type_class_peek_parent (klass);
#line 234 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	G_OBJECT_CLASS (klass)->finalize = edm_command_line_preferences_finalize;
#line 2221 "external-download-manager.c"
}


static void edm_command_line_preferences_instance_init (EDMCommandLinePreferences * self) {
}


static void edm_command_line_preferences_finalize (GObject* obj) {
	EDMCommandLinePreferences * self;
#line 234 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EDM_TYPE_COMMAND_LINE_PREFERENCES, EDMCommandLinePreferences);
#line 235 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_g_object_unref0 (self->input);
#line 236 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_g_object_unref0 (self->commandline);
#line 234 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	G_OBJECT_CLASS (edm_command_line_preferences_parent_class)->finalize (obj);
#line 2239 "external-download-manager.c"
}


GType edm_command_line_preferences_get_type (void) {
	static volatile gsize edm_command_line_preferences_type_id__volatile = 0;
	if (g_once_init_enter (&edm_command_line_preferences_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EDMCommandLinePreferencesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) edm_command_line_preferences_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EDMCommandLinePreferences), 0, (GInstanceInitFunc) edm_command_line_preferences_instance_init, NULL };
		GType edm_command_line_preferences_type_id;
		edm_command_line_preferences_type_id = g_type_register_static (GTK_TYPE_DIALOG, "EDMCommandLinePreferences", &g_define_type_info, 0);
		g_once_init_leave (&edm_command_line_preferences_type_id__volatile, edm_command_line_preferences_type_id);
	}
	return edm_command_line_preferences_type_id__volatile;
}


static void edm_command_line_show_preferences (EDMCommandLine* self) {
	EDMCommandLinePreferences* dialog = NULL;
	EDMCommandLinePreferences* _tmp0_ = NULL;
#line 291 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_if_fail (self != NULL);
#line 292 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp0_ = edm_command_line_preferences_new (self);
#line 292 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_object_ref_sink (_tmp0_);
#line 292 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	dialog = _tmp0_;
#line 293 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	gtk_widget_show ((GtkWidget*) dialog);
#line 291 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_g_object_unref0 (dialog);
#line 2270 "external-download-manager.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1282 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1282 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1282 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 2283 "external-download-manager.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1284 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1284 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1284 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1284 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1284 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1284 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1284 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1284 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1284 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 2314 "external-download-manager.c"
				goto __catch2_g_regex_error;
			}
#line 1284 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1284 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1284 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			return NULL;
#line 2323 "external-download-manager.c"
		}
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 2339 "external-download-manager.c"
				goto __catch2_g_regex_error;
			}
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			return NULL;
#line 2350 "external-download-manager.c"
		}
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 2364 "external-download-manager.c"
	}
	goto __finally2;
	__catch2_g_regex_error:
	{
		GError* e = NULL;
#line 1283 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1283 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1287 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1283 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 2378 "external-download-manager.c"
	}
	__finally2:
#line 1283 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1283 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1283 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1283 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		return NULL;
#line 2389 "external-download-manager.c"
	}
}


static gchar* edm_command_line_replace_quoted (EDMCommandLine* self, const gchar* context, const gchar* replace, const gchar* with) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
#line 296 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 296 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 296 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_val_if_fail (replace != NULL, NULL);
#line 297 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp1_ = with;
#line 297 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	if (_tmp1_ != NULL) {
#line 2411 "external-download-manager.c"
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 297 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp2_ = with;
#line 297 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp3_ = g_shell_quote (_tmp2_);
#line 297 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_free0 (_tmp0_);
#line 297 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp0_ = _tmp3_;
#line 2422 "external-download-manager.c"
	} else {
		gchar* _tmp4_ = NULL;
#line 297 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp4_ = g_strdup ("\'\'");
#line 297 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_free0 (_tmp0_);
#line 297 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp0_ = _tmp4_;
#line 2431 "external-download-manager.c"
	}
#line 297 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp5_ = context;
#line 297 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp6_ = replace;
#line 297 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp7_ = string_replace (_tmp5_, _tmp6_, _tmp0_);
#line 297 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	result = _tmp7_;
#line 297 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_g_free0 (_tmp0_);
#line 297 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	return result;
#line 2445 "external-download-manager.c"
}


static gboolean edm_command_line_real_download (EDMExternalDownloadManager* base, EDMDownloadRequest* dlReq) {
	EDMCommandLine * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 300 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	self = (EDMCommandLine*) base;
#line 300 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_val_if_fail (dlReq != NULL, FALSE);
#line 2457 "external-download-manager.c"
	{
		gchar* cmd = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		EDMDownloadRequest* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		EDMDownloadRequest* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		EDMDownloadRequest* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
#line 302 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp0_ = midori_extension_get_string ((MidoriExtension*) self, "commandline");
#line 302 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 302 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		cmd = _tmp1_;
#line 303 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp2_ = cmd;
#line 303 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp3_ = dlReq;
#line 303 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp4_ = _tmp3_->referer;
#line 303 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp5_ = edm_command_line_replace_quoted (self, _tmp2_, "{REFERER}", _tmp4_);
#line 303 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_free0 (cmd);
#line 303 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		cmd = _tmp5_;
#line 304 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp7_ = dlReq;
#line 304 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp8_ = _tmp7_->cookie_header;
#line 304 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		if (_tmp8_ != NULL) {
#line 2502 "external-download-manager.c"
			EDMDownloadRequest* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
#line 304 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			_tmp9_ = dlReq;
#line 304 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			_tmp10_ = _tmp9_->cookie_header;
#line 304 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			_tmp11_ = g_strconcat ("Cookie: ", _tmp10_, NULL);
#line 304 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			_g_free0 (_tmp6_);
#line 304 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			_tmp6_ = _tmp11_;
#line 2516 "external-download-manager.c"
		} else {
#line 304 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			_g_free0 (_tmp6_);
#line 304 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			_tmp6_ = NULL;
#line 2522 "external-download-manager.c"
		}
#line 304 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp12_ = cmd;
#line 304 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp13_ = edm_command_line_replace_quoted (self, _tmp12_, "{COOKIES}", _tmp6_);
#line 304 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_free0 (cmd);
#line 304 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		cmd = _tmp13_;
#line 305 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp14_ = cmd;
#line 305 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp15_ = dlReq;
#line 305 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp16_ = _tmp15_->uri;
#line 305 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp17_ = g_shell_quote (_tmp16_);
#line 305 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp18_ = _tmp17_;
#line 305 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp19_ = string_replace (_tmp14_, "{URL}", _tmp18_);
#line 305 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_free0 (cmd);
#line 305 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		cmd = _tmp19_;
#line 305 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_free0 (_tmp18_);
#line 306 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp20_ = cmd;
#line 306 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		g_spawn_command_line_async (_tmp20_, &_inner_error_);
#line 306 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 306 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			_g_free0 (_tmp6_);
#line 306 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			_g_free0 (cmd);
#line 2560 "external-download-manager.c"
			goto __catch3_g_error;
		}
#line 307 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		result = TRUE;
#line 307 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_free0 (_tmp6_);
#line 307 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_free0 (cmd);
#line 307 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		return result;
#line 2571 "external-download-manager.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp21_ = NULL;
#line 301 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		e = _inner_error_;
#line 301 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_inner_error_ = NULL;
#line 309 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp21_ = e;
#line 309 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		edm_external_download_manager_handle_exception ((EDMExternalDownloadManager*) self, _tmp21_);
#line 301 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_error_free0 (e);
#line 2588 "external-download-manager.c"
	}
	__finally3:
#line 301 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 301 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 301 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		g_clear_error (&_inner_error_);
#line 301 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		return FALSE;
#line 2599 "external-download-manager.c"
	}
#line 311 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	result = FALSE;
#line 311 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	return result;
#line 2605 "external-download-manager.c"
}


static gchar* edm_command_line_description_with_command (const gchar* commandline) {
	gchar* result = NULL;
	gchar* command = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
#line 314 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_val_if_fail (commandline != NULL, NULL);
#line 2618 "external-download-manager.c"
	{
		gchar** argvp = NULL;
		gint argvp_length1 = 0;
		gint _argvp_size_ = 0;
		const gchar* _tmp0_ = NULL;
		gchar** _tmp1_ = NULL;
		gint _tmp2_ = 0;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
#line 318 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp0_ = commandline;
#line 318 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		g_shell_parse_argv (_tmp0_, &_tmp2_, &_tmp1_, &_inner_error_);
#line 318 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		argvp = (_vala_array_free (argvp, argvp_length1, (GDestroyNotify) g_free), NULL);
#line 318 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		argvp = _tmp1_;
#line 318 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		argvp_length1 = _tmp2_;
#line 318 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_argvp_size_ = argvp_length1;
#line 318 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 318 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
			argvp = (_vala_array_free (argvp, argvp_length1, (GDestroyNotify) g_free), NULL);
#line 2644 "external-download-manager.c"
			goto __catch4_g_error;
		}
#line 319 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp3_ = argvp[0];
#line 319 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp4_ = g_strdup (_tmp3_);
#line 319 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_free0 (command);
#line 319 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		command = _tmp4_;
#line 316 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		argvp = (_vala_array_free (argvp, argvp_length1, (GDestroyNotify) g_free), NULL);
#line 2657 "external-download-manager.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar** _tmp6_ = NULL;
		gchar** _tmp7_ = NULL;
		gchar** _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
#line 316 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_error_ = _inner_error_;
#line 316 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_inner_error_ = NULL;
#line 322 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp5_ = commandline;
#line 322 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, " ", 0);
#line 322 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp8_ = _tmp7_;
#line 322 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp8__length1 = _vala_array_length (_tmp6_);
#line 322 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp9_ = _tmp8_[0];
#line 322 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp10_ = g_strdup (_tmp9_);
#line 322 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_free0 (command);
#line 322 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		command = _tmp10_;
#line 322 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
#line 316 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_error_free0 (_error_);
#line 2694 "external-download-manager.c"
	}
	__finally4:
#line 316 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 316 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		_g_free0 (command);
#line 316 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 316 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		g_clear_error (&_inner_error_);
#line 316 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
		return NULL;
#line 2707 "external-download-manager.c"
	}
#line 324 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp11_ = _ ("Download files with \"%s\" or a custom command");
#line 324 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp12_ = command;
#line 324 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp13_ = g_strdup_printf (_tmp11_, _tmp12_);
#line 324 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	result = _tmp13_;
#line 324 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_g_free0 (command);
#line 324 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	return result;
#line 2721 "external-download-manager.c"
}


void edm_command_line_update_description (EDMCommandLine* self, MidoriApp* app) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 327 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_if_fail (self != NULL);
#line 327 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_return_if_fail (app != NULL);
#line 328 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp0_ = midori_extension_get_string ((MidoriExtension*) self, "commandline");
#line 328 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp1_ = edm_command_line_description_with_command (_tmp0_);
#line 328 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp2_ = _tmp1_;
#line 328 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_object_set ((MidoriExtension*) self, "description", _tmp2_, NULL);
#line 328 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_g_free0 (_tmp2_);
#line 2743 "external-download-manager.c"
}


static void _edm_command_line_update_description_midori_extension_activate (MidoriExtension* _sender, MidoriApp* app, gpointer self) {
#line 349 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	edm_command_line_update_description ((EDMCommandLine*) self, app);
#line 2750 "external-download-manager.c"
}


static void _edm_command_line_show_preferences_midori_extension_open_preferences (MidoriExtension* _sender, gpointer self) {
#line 351 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	edm_command_line_show_preferences ((EDMCommandLine*) self);
#line 2757 "external-download-manager.c"
}


EDMCommandLine* edm_command_line_construct (GType object_type) {
	EDMCommandLine * self = NULL;
	gchar* default_commandline = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 337 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp0_ = g_strdup ("wget --no-check-certificate --referer={REFERER} --header={COOKIES} {UR" \
"L}");
#line 337 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	default_commandline = _tmp0_;
#line 340 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp1_ = _ ("External Download Manager - CommandLine");
#line 340 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp2_ = edm_command_line_description_with_command (default_commandline);
#line 340 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp3_ = _tmp2_;
#line 340 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	self = (EDMCommandLine*) g_object_new (object_type, "name", _tmp1_, "description", _tmp3_, "version", "0.1" MIDORI_VERSION_SUFFIX, "authors", "André Stösel <andre@stoesel.de>", "key", "commandline", NULL);
#line 340 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_g_free0 (_tmp3_);
#line 346 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	midori_extension_install_string ((MidoriExtension*) self, "commandline", default_commandline);
#line 348 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_signal_connect_object ((MidoriExtension*) self, "activate", (GCallback) _edm_external_download_manager_activated_midori_extension_activate, (EDMExternalDownloadManager*) self, 0);
#line 349 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_signal_connect_object ((MidoriExtension*) self, "activate", (GCallback) _edm_command_line_update_description_midori_extension_activate, self, 0);
#line 350 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_signal_connect_object ((MidoriExtension*) self, "deactivate", (GCallback) _edm_external_download_manager_deactivated_midori_extension_deactivate, (EDMExternalDownloadManager*) self, 0);
#line 351 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_signal_connect_object ((MidoriExtension*) self, "open-preferences", (GCallback) _edm_command_line_show_preferences_midori_extension_open_preferences, self, 0);
#line 331 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_g_free0 (default_commandline);
#line 331 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	return self;
#line 2796 "external-download-manager.c"
}


EDMCommandLine* edm_command_line_new (void) {
#line 331 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	return edm_command_line_construct (EDM_TYPE_COMMAND_LINE);
#line 2803 "external-download-manager.c"
}


static void edm_command_line_class_init (EDMCommandLineClass * klass) {
#line 290 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	edm_command_line_parent_class = g_type_class_peek_parent (klass);
#line 290 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	((EDMExternalDownloadManagerClass *) klass)->download = edm_command_line_real_download;
#line 2812 "external-download-manager.c"
}


static void edm_command_line_instance_init (EDMCommandLine * self) {
}


GType edm_command_line_get_type (void) {
	static volatile gsize edm_command_line_type_id__volatile = 0;
	if (g_once_init_enter (&edm_command_line_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EDMCommandLineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) edm_command_line_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EDMCommandLine), 0, (GInstanceInitFunc) edm_command_line_instance_init, NULL };
		GType edm_command_line_type_id;
		edm_command_line_type_id = g_type_register_static (EDM_TYPE_EXTERNAL_DOWNLOAD_MANAGER, "EDMCommandLine", &g_define_type_info, 0);
		g_once_init_leave (&edm_command_line_type_id__volatile, edm_command_line_type_id);
	}
	return edm_command_line_type_id__volatile;
}


KatzeArray* extension_init (void) {
	KatzeArray* result = NULL;
	EDMManager* _tmp0_ = NULL;
	KatzeArray* extensions = NULL;
	KatzeArray* _tmp1_ = NULL;
	EDMAria2* _tmp2_ = NULL;
	EDMAria2* _tmp3_ = NULL;
	EDMSteadyFlow* _tmp4_ = NULL;
	EDMSteadyFlow* _tmp5_ = NULL;
	EDMCommandLine* _tmp6_ = NULL;
	EDMCommandLine* _tmp7_ = NULL;
#line 357 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp0_ = edm_manager_new ();
#line 357 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_g_object_unref0 (edm_manager);
#line 357 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	edm_manager = _tmp0_;
#line 359 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp1_ = katze_array_new (MIDORI_TYPE_EXTENSION);
#line 359 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	extensions = _tmp1_;
#line 361 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp2_ = edm_aria2_new ();
#line 361 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp3_ = _tmp2_;
#line 361 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_signal_emit_by_name (extensions, "add-item", (GObject*) _tmp3_);
#line 361 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_g_object_unref0 (_tmp3_);
#line 362 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp4_ = edm_steady_flow_new ();
#line 362 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp5_ = _tmp4_;
#line 362 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_signal_emit_by_name (extensions, "add-item", (GObject*) _tmp5_);
#line 362 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_g_object_unref0 (_tmp5_);
#line 364 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp6_ = edm_command_line_new ();
#line 364 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_tmp7_ = _tmp6_;
#line 364 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	g_signal_emit_by_name (extensions, "add-item", (GObject*) _tmp7_);
#line 364 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	_g_object_unref0 (_tmp7_);
#line 365 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	result = extensions;
#line 365 "/usr/src/ports/midori/midori-0.5.11-1.x86_64/src/midori-0.5.11/extensions/external-download-manager.vala"
	return result;
#line 2881 "external-download-manager.c"
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



