/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the Mips target                            *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 41;
using PredicateBitset = llvm::PredicateBitsetImpl<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(MipsInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(MipsInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr&) const;
  const ISelInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ISelInfo;
  static MipsInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static MipsInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const int64_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(0),
ISelInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_HasMips2Bit = 7,
  Feature_HasMips3Bit = 16,
  Feature_HasMips4_32Bit = 26,
  Feature_NotMips4_32Bit = 27,
  Feature_HasMips4_32r2Bit = 17,
  Feature_HasMips32Bit = 3,
  Feature_HasMips32r2Bit = 6,
  Feature_HasMips32r6Bit = 28,
  Feature_NotMips32r6Bit = 4,
  Feature_IsGP64bitBit = 21,
  Feature_IsPTR64bitBit = 23,
  Feature_HasMips64Bit = 24,
  Feature_HasMips64r2Bit = 22,
  Feature_HasMips64r6Bit = 29,
  Feature_NotMips64r6Bit = 5,
  Feature_InMips16ModeBit = 30,
  Feature_NotInMips16ModeBit = 0,
  Feature_HasCnMipsBit = 25,
  Feature_NotCnMipsBit = 8,
  Feature_IsN64Bit = 37,
  Feature_RelocNotPICBit = 9,
  Feature_RelocPICBit = 36,
  Feature_NoNaNsFPMathBit = 20,
  Feature_HasStdEncBit = 1,
  Feature_NotDSPBit = 11,
  Feature_InMicroMipsBit = 34,
  Feature_NotInMicroMipsBit = 2,
  Feature_IsLEBit = 39,
  Feature_IsBEBit = 40,
  Feature_IsNotNaClBit = 18,
  Feature_HasEVABit = 35,
  Feature_HasMSABit = 33,
  Feature_HasMadd4Bit = 19,
  Feature_UseIndirectJumpsHazardBit = 12,
  Feature_NoIndirectJumpGuardsBit = 10,
  Feature_AllowFPOpFusionBit = 38,
  Feature_IsFP64bitBit = 15,
  Feature_NotFP64bitBit = 14,
  Feature_IsNotSoftFloatBit = 13,
  Feature_HasDSPBit = 31,
  Feature_HasDSPR2Bit = 32,
};

PredicateBitset MipsInstructionSelector::
computeAvailableModuleFeatures(const MipsSubtarget *Subtarget) const {
  PredicateBitset Features;
  if (Subtarget->hasMips2())
    Features[Feature_HasMips2Bit] = 1;
  if (Subtarget->hasMips3())
    Features[Feature_HasMips3Bit] = 1;
  if (Subtarget->hasMips4_32())
    Features[Feature_HasMips4_32Bit] = 1;
  if (!Subtarget->hasMips4_32())
    Features[Feature_NotMips4_32Bit] = 1;
  if (Subtarget->hasMips4_32r2())
    Features[Feature_HasMips4_32r2Bit] = 1;
  if (Subtarget->hasMips32())
    Features[Feature_HasMips32Bit] = 1;
  if (Subtarget->hasMips32r2())
    Features[Feature_HasMips32r2Bit] = 1;
  if (Subtarget->hasMips32r6())
    Features[Feature_HasMips32r6Bit] = 1;
  if (!Subtarget->hasMips32r6())
    Features[Feature_NotMips32r6Bit] = 1;
  if (Subtarget->isGP64bit())
    Features[Feature_IsGP64bitBit] = 1;
  if (Subtarget->isABI_N64())
    Features[Feature_IsPTR64bitBit] = 1;
  if (Subtarget->hasMips64())
    Features[Feature_HasMips64Bit] = 1;
  if (Subtarget->hasMips64r2())
    Features[Feature_HasMips64r2Bit] = 1;
  if (Subtarget->hasMips64r6())
    Features[Feature_HasMips64r6Bit] = 1;
  if (!Subtarget->hasMips64r6())
    Features[Feature_NotMips64r6Bit] = 1;
  if (Subtarget->inMips16Mode())
    Features[Feature_InMips16ModeBit] = 1;
  if (!Subtarget->inMips16Mode())
    Features[Feature_NotInMips16ModeBit] = 1;
  if (Subtarget->hasCnMips())
    Features[Feature_HasCnMipsBit] = 1;
  if (!Subtarget->hasCnMips())
    Features[Feature_NotCnMipsBit] = 1;
  if (Subtarget->isABI_N64())
    Features[Feature_IsN64Bit] = 1;
  if (!TM.isPositionIndependent())
    Features[Feature_RelocNotPICBit] = 1;
  if (TM.isPositionIndependent())
    Features[Feature_RelocPICBit] = 1;
  if (TM.Options.NoNaNsFPMath)
    Features[Feature_NoNaNsFPMathBit] = 1;
  if (Subtarget->hasStandardEncoding())
    Features[Feature_HasStdEncBit] = 1;
  if (!Subtarget->hasDSP())
    Features[Feature_NotDSPBit] = 1;
  if (Subtarget->inMicroMipsMode())
    Features[Feature_InMicroMipsBit] = 1;
  if (!Subtarget->inMicroMipsMode())
    Features[Feature_NotInMicroMipsBit] = 1;
  if (Subtarget->isLittle())
    Features[Feature_IsLEBit] = 1;
  if (!Subtarget->isLittle())
    Features[Feature_IsBEBit] = 1;
  if (!Subtarget->isTargetNaCl())
    Features[Feature_IsNotNaClBit] = 1;
  if (Subtarget->hasEVA())
    Features[Feature_HasEVABit] = 1;
  if (Subtarget->hasMSA())
    Features[Feature_HasMSABit] = 1;
  if (!Subtarget->disableMadd4())
    Features[Feature_HasMadd4Bit] = 1;
  if (Subtarget->useIndirectJumpsHazard())
    Features[Feature_UseIndirectJumpsHazardBit] = 1;
  if (!Subtarget->useIndirectJumpsHazard())
    Features[Feature_NoIndirectJumpGuardsBit] = 1;
  if (TM.Options.AllowFPOpFusion == FPOpFusion::Fast)
    Features[Feature_AllowFPOpFusionBit] = 1;
  if (Subtarget->isFP64bit())
    Features[Feature_IsFP64bitBit] = 1;
  if (!Subtarget->isFP64bit())
    Features[Feature_NotFP64bitBit] = 1;
  if (!Subtarget->useSoftFloat())
    Features[Feature_IsNotSoftFloatBit] = 1;
  if (Subtarget->hasDSP())
    Features[Feature_HasDSPBit] = 1;
  if (Subtarget->hasDSPR2())
    Features[Feature_HasDSPR2Bit] = 1;
  return Features;
}

PredicateBitset MipsInstructionSelector::
computeAvailableFunctionFeatures(const MipsSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features;
  return Features;
}

// LLT Objects.
enum {
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_v2s16,
  GILLT_v2s64,
  GILLT_v4s8,
  GILLT_v4s32,
  GILLT_v8s16,
  GILLT_v16s8,
};
const static size_t NumTypeObjects = 9;
const static LLT TypeObjects[] = {
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::vector(2, 16),
  LLT::vector(2, 64),
  LLT::vector(4, 8),
  LLT::vector(4, 32),
  LLT::vector(8, 16),
  LLT::vector(16, 8),
};

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HasCnMips,
  GIFBS_HasDSP,
  GIFBS_HasDSPR2,
  GIFBS_HasMSA,
  GIFBS_InMicroMips,
  GIFBS_InMips16Mode,
  GIFBS_IsFP64bit,
  GIFBS_NotFP64bit,
  GIFBS_HasDSP_InMicroMips,
  GIFBS_HasDSP_NotInMicroMips,
  GIFBS_HasDSPR2_InMicroMips,
  GIFBS_HasMSA_HasStdEnc,
  GIFBS_HasMSA_IsBE,
  GIFBS_HasMSA_IsLE,
  GIFBS_HasMips32r6_HasStdEnc,
  GIFBS_HasMips32r6_InMicroMips,
  GIFBS_HasMips64r2_HasStdEnc,
  GIFBS_HasMips64r6_HasStdEnc,
  GIFBS_HasStdEnc_IsNotSoftFloat,
  GIFBS_HasStdEnc_NotInMicroMips,
  GIFBS_HasStdEnc_NotMips4_32,
  GIFBS_InMicroMips_IsFP64bit,
  GIFBS_InMicroMips_IsNotSoftFloat,
  GIFBS_InMicroMips_NotFP64bit,
  GIFBS_InMicroMips_NotMips32r6,
  GIFBS_IsGP64bit_NotInMips16Mode,
  GIFBS_AllowFPOpFusion_HasMSA_HasStdEnc,
  GIFBS_HasMSA_HasMips64_HasStdEnc,
  GIFBS_HasMips3_HasStdEnc_IsGP64bit,
  GIFBS_HasMips3_HasStdEnc_NotInMicroMips,
  GIFBS_HasMips32r2_HasStdEnc_NotInMicroMips,
  GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips,
  GIFBS_HasMips32r6_InMicroMips_IsNotSoftFloat,
  GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips,
  GIFBS_HasStdEnc_IsFP64bit_NotInMicroMips,
  GIFBS_HasStdEnc_IsFP64bit_NotMips4_32,
  GIFBS_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasStdEnc_NotFP64bit_NotInMicroMips,
  GIFBS_HasStdEnc_NotFP64bit_NotMips4_32,
  GIFBS_HasStdEnc_NotInMicroMips_RelocNotPIC,
  GIFBS_InMicroMips_IsFP64bit_IsNotSoftFloat,
  GIFBS_InMicroMips_IsNotSoftFloat_NotFP64bit,
  GIFBS_InMicroMips_NotFP64bit_NotMips32r6,
  GIFBS_InMicroMips_NotMips32r6_RelocNotPIC,
  GIFBS_InMicroMips_NotMips32r6_RelocPIC,
  GIFBS_HasMips3_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasMips32r6_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasMips4_32_HasStdEnc_NotMips32r6_NotMips64r6,
  GIFBS_HasMips64_HasStdEnc_NotInMicroMips_NotMips64r6,
  GIFBS_HasMips64r2_HasStdEnc_IsGP64bit_NotInMicroMips,
  GIFBS_HasStdEnc_IsFP64bit_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasStdEnc_IsNotSoftFloat_NotFP64bit_NotInMicroMips,
  GIFBS_HasMips32_HasStdEnc_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMips4_32_HasStdEnc_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_InMicroMips_InMicroMips_NoNaNsFPMath_NotMips32r6_NotMips32r6,
  GIFBS_HasMips4_32_HasStdEnc_IsFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMips4_32_HasStdEnc_IsGP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMips4_32_HasStdEnc_NotFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsNotSoftFloat_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_NoNaNsFPMath_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_InMicroMips_InMicroMips_NoNaNsFPMath_NotFP64bit_NotMips32r6_NotMips32r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsFP64bit_IsNotSoftFloat_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsFP64bit_NoNaNsFPMath_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsNotSoftFloat_NotFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_NoNaNsFPMath_NotFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
};
const static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HasCnMipsBit, },
  {Feature_HasDSPBit, },
  {Feature_HasDSPR2Bit, },
  {Feature_HasMSABit, },
  {Feature_InMicroMipsBit, },
  {Feature_InMips16ModeBit, },
  {Feature_IsFP64bitBit, },
  {Feature_NotFP64bitBit, },
  {Feature_HasDSPBit, Feature_InMicroMipsBit, },
  {Feature_HasDSPBit, Feature_NotInMicroMipsBit, },
  {Feature_HasDSPR2Bit, Feature_InMicroMipsBit, },
  {Feature_HasMSABit, Feature_HasStdEncBit, },
  {Feature_HasMSABit, Feature_IsBEBit, },
  {Feature_HasMSABit, Feature_IsLEBit, },
  {Feature_HasMips32r6Bit, Feature_HasStdEncBit, },
  {Feature_HasMips32r6Bit, Feature_InMicroMipsBit, },
  {Feature_HasMips64r2Bit, Feature_HasStdEncBit, },
  {Feature_HasMips64r6Bit, Feature_HasStdEncBit, },
  {Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, },
  {Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_NotMips4_32Bit, },
  {Feature_InMicroMipsBit, Feature_IsFP64bitBit, },
  {Feature_InMicroMipsBit, Feature_IsNotSoftFloatBit, },
  {Feature_InMicroMipsBit, Feature_NotFP64bitBit, },
  {Feature_InMicroMipsBit, Feature_NotMips32r6Bit, },
  {Feature_IsGP64bitBit, Feature_NotInMips16ModeBit, },
  {Feature_AllowFPOpFusionBit, Feature_HasMSABit, Feature_HasStdEncBit, },
  {Feature_HasMSABit, Feature_HasMips64Bit, Feature_HasStdEncBit, },
  {Feature_HasMips3Bit, Feature_HasStdEncBit, Feature_IsGP64bitBit, },
  {Feature_HasMips3Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips32r2Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips32r6Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips32r6Bit, Feature_InMicroMipsBit, Feature_IsNotSoftFloatBit, },
  {Feature_HasMips64r6Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_NotMips4_32Bit, },
  {Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_NotFP64bitBit, Feature_NotMips4_32Bit, },
  {Feature_HasStdEncBit, Feature_NotInMicroMipsBit, Feature_RelocNotPICBit, },
  {Feature_InMicroMipsBit, Feature_IsFP64bitBit, Feature_IsNotSoftFloatBit, },
  {Feature_InMicroMipsBit, Feature_IsNotSoftFloatBit, Feature_NotFP64bitBit, },
  {Feature_InMicroMipsBit, Feature_NotFP64bitBit, Feature_NotMips32r6Bit, },
  {Feature_InMicroMipsBit, Feature_NotMips32r6Bit, Feature_RelocNotPICBit, },
  {Feature_InMicroMipsBit, Feature_NotMips32r6Bit, Feature_RelocPICBit, },
  {Feature_HasMips3Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips32r6Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips4_32Bit, Feature_HasStdEncBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMips64Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, Feature_NotMips64r6Bit, },
  {Feature_HasMips64r2Bit, Feature_HasStdEncBit, Feature_IsGP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips32Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMips4_32Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_InMicroMipsBit, Feature_InMicroMipsBit, Feature_NoNaNsFPMathBit, Feature_NotMips32r6Bit, Feature_NotMips32r6Bit, },
  {Feature_HasMips4_32Bit, Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMips4_32Bit, Feature_HasStdEncBit, Feature_IsGP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMips4_32Bit, Feature_HasStdEncBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_NoNaNsFPMathBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_InMicroMipsBit, Feature_InMicroMipsBit, Feature_NoNaNsFPMathBit, Feature_NotFP64bitBit, Feature_NotMips32r6Bit, Feature_NotMips32r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_NoNaNsFPMathBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_NoNaNsFPMathBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

// PatFrag predicates.
enum {
  GIPFP_I64_Predicate_immLi16 = GIPFP_I64_Invalid + 1,
  GIPFP_I64_Predicate_immSExt10,
  GIPFP_I64_Predicate_immSExt6,
  GIPFP_I64_Predicate_immSExtAddiur2,
  GIPFP_I64_Predicate_immSExtAddius5,
  GIPFP_I64_Predicate_immZExt1,
  GIPFP_I64_Predicate_immZExt10,
  GIPFP_I64_Predicate_immZExt1Ptr,
  GIPFP_I64_Predicate_immZExt2,
  GIPFP_I64_Predicate_immZExt2Lsa,
  GIPFP_I64_Predicate_immZExt2Ptr,
  GIPFP_I64_Predicate_immZExt2Shift,
  GIPFP_I64_Predicate_immZExt3,
  GIPFP_I64_Predicate_immZExt3Ptr,
  GIPFP_I64_Predicate_immZExt4,
  GIPFP_I64_Predicate_immZExt4Ptr,
  GIPFP_I64_Predicate_immZExt5,
  GIPFP_I64_Predicate_immZExt5_64,
  GIPFP_I64_Predicate_immZExt6,
  GIPFP_I64_Predicate_immZExt8,
  GIPFP_I64_Predicate_immZExtAndi16,
  GIPFP_I64_Predicate_immi32Cst15,
  GIPFP_I64_Predicate_immi32Cst31,
  GIPFP_I64_Predicate_immi32Cst7,
};
bool MipsInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GIPFP_I64_Predicate_immLi16: {
    return Imm >= -1 && Imm <= 126;
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immSExt10: {
    return isInt<10>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immSExt6: {
    return isInt<6>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immSExtAddiur2: {
    return Imm == 1 || Imm == -1 ||
                                           ((Imm % 4 == 0) &&
                                            Imm < 28 && Imm > 0);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immSExtAddius5: {
    return Imm >= -8 && Imm <= 7;
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immZExt1: {
    return isUInt<1>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immZExt10: {
    return isUInt<10>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immZExt1Ptr: {
    return isUInt<1>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immZExt2: {
    return isUInt<2>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immZExt2Lsa: {
    return isUInt<2>(Imm - 1);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immZExt2Ptr: {
    return isUInt<2>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immZExt2Shift: {
    return Imm >= 1 && Imm <= 8;
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immZExt3: {
    return isUInt<3>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immZExt3Ptr: {
    return isUInt<3>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immZExt4: {
    return isUInt<4>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immZExt4Ptr: {
    return isUInt<4>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immZExt5: {
    return Imm == (Imm & 0x1f);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immZExt5_64: {
     return Imm == (Imm & 0x1f); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immZExt6: {
    return Imm == (Imm & 0x3f);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immZExt8: {
    return isUInt<8>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immZExtAndi16: {
    return (Imm == 128 || (Imm >= 1 && Imm <= 4) || Imm == 7 || Imm == 8 ||
            Imm == 15 || Imm == 16 || Imm == 31 || Imm == 32 || Imm == 63 ||
            Imm == 64 || Imm == 255 || Imm == 32768 || Imm == 65535 );
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immi32Cst15: {
    return isUInt<32>(Imm) && Imm == 15;
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immi32Cst31: {
    return isUInt<32>(Imm) && Imm == 31;
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immi32Cst7: {
    return isUInt<32>(Imm) && Imm == 7;
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool MipsInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool MipsInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool MipsInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  (void)MRI;
  llvm_unreachable("Unknown predicate");
  return false;
}

MipsInstructionSelector::ComplexMatcherMemFn
MipsInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

// Custom renderers.
enum {
  GICR_Invalid,
};
MipsInstructionSelector::CustomRendererFn
MipsInstructionSelector::CustomRenderers[] = {
  nullptr, // GICP_Invalid
};

bool MipsInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  MachineFunction &MF = *I.getParent()->getParent();
  MachineRegisterInfo &MRI = MF.getRegInfo();
  // FIXME: This should be computed on a per-function basis rather than per-insn.
  AvailableFunctionFeatures = computeAvailableFunctionFeatures(&STI, &MF);
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  NewMIVector OutMIs;
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, OutMIs, State, ISelInfo, getMatchTable(), TII, MRI, TRI, RBI, AvailableFeatures, CoverageInfo)) {
    return true;
  }

  return false;
}

const int64_t *MipsInstructionSelector::getMatchTable() const {
  constexpr static int64_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/34, 139, /*)*//*default:*//*Label 42*/ 38278,
    /*TargetOpcode::G_ADD*//*Label 0*/ 110,
    /*TargetOpcode::G_SUB*//*Label 1*/ 1287,
    /*TargetOpcode::G_MUL*//*Label 2*/ 1899,
    /*TargetOpcode::G_SDIV*//*Label 3*/ 2275,
    /*TargetOpcode::G_UDIV*//*Label 4*/ 2496,
    /*TargetOpcode::G_SREM*//*Label 5*/ 2717,
    /*TargetOpcode::G_UREM*//*Label 6*/ 2938,
    /*TargetOpcode::G_AND*//*Label 7*/ 3159,
    /*TargetOpcode::G_OR*//*Label 8*/ 3603,
    /*TargetOpcode::G_XOR*//*Label 9*/ 3905, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_BITCAST*//*Label 10*/ 4699, 0, 0,
    /*TargetOpcode::G_LOAD*//*Label 11*/ 8352,
    /*TargetOpcode::G_SEXTLOAD*//*Label 12*/ 8418,
    /*TargetOpcode::G_ZEXTLOAD*//*Label 13*/ 8484, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_INTRINSIC*//*Label 14*/ 8550,
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 15*/ 25061, 0,
    /*TargetOpcode::G_TRUNC*//*Label 16*/ 29985,
    /*TargetOpcode::G_CONSTANT*//*Label 17*/ 30042, 0, 0, 0,
    /*TargetOpcode::G_SEXT*//*Label 18*/ 30102,
    /*TargetOpcode::G_ZEXT*//*Label 19*/ 30130,
    /*TargetOpcode::G_SHL*//*Label 20*/ 30215,
    /*TargetOpcode::G_LSHR*//*Label 21*/ 30739,
    /*TargetOpcode::G_ASHR*//*Label 22*/ 31263, 0, 0,
    /*TargetOpcode::G_SELECT*//*Label 23*/ 31744, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FADD*//*Label 24*/ 33198,
    /*TargetOpcode::G_FSUB*//*Label 25*/ 34077,
    /*TargetOpcode::G_FMUL*//*Label 26*/ 34653,
    /*TargetOpcode::G_FMA*//*Label 27*/ 35090,
    /*TargetOpcode::G_FDIV*//*Label 28*/ 35180, 0, 0, 0,
    /*TargetOpcode::G_FEXP2*//*Label 29*/ 35431, 0,
    /*TargetOpcode::G_FLOG2*//*Label 30*/ 35489, 0,
    /*TargetOpcode::G_FNEG*//*Label 31*/ 35547,
    /*TargetOpcode::G_FPEXT*//*Label 32*/ 36843,
    /*TargetOpcode::G_FPTRUNC*//*Label 33*/ 36992,
    /*TargetOpcode::G_FPTOSI*//*Label 34*/ 37120,
    /*TargetOpcode::G_FPTOUI*//*Label 35*/ 37178,
    /*TargetOpcode::G_SITOFP*//*Label 36*/ 37236,
    /*TargetOpcode::G_UITOFP*//*Label 37*/ 37389, 0, 0, 0,
    /*TargetOpcode::G_BR*//*Label 38*/ 37447, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_CTLZ*//*Label 39*/ 37532, 0,
    /*TargetOpcode::G_CTPOP*//*Label 40*/ 37967,
    /*TargetOpcode::G_BSWAP*//*Label 41*/ 38126,
    // Label 0: @110
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 9, /*)*//*default:*//*Label 51*/ 1286,
    /*GILLT_s32*//*Label 43*/ 124,
    /*GILLT_s64*//*Label 44*/ 473,
    /*GILLT_v2s16*//*Label 45*/ 636,
    /*GILLT_v2s64*//*Label 46*/ 663,
    /*GILLT_v4s8*//*Label 47*/ 812,
    /*GILLT_v4s32*//*Label 48*/ 839,
    /*GILLT_v8s16*//*Label 49*/ 988,
    /*GILLT_v16s8*//*Label 50*/ 1137,
    // Label 43: @124
    GIM_Try, /*On fail goto*//*Label 52*/ 472,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 53*/ 202, // Rule ID 2313 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_immZExt2Lsa,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt2Lsa>>:$sa), GPR32Opnd:{ *:[i32] }:$rt)  =>  (LSA:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] }):$sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::LSA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2313,
        GIR_Done,
      // Label 53: @202
      GIM_Try, /*On fail goto*//*Label 54*/ 270, // Rule ID 802 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_immZExt2Lsa,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (shl:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt2Lsa>>:$sa))  =>  (LSA:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] }):$sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::LSA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 802,
        GIR_Done,
      // Label 54: @270
      GIM_Try, /*On fail goto*//*Label 55*/ 313, // Rule ID 2084 //
        GIM_CheckFeatures, GIFBS_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPRMM16RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immSExtAddiur2,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immSExtAddiur2>>:$imm)  =>  (ADDIUR2_MM:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immSExtAddiur2>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDIUR2_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2084,
        GIR_Done,
      // Label 55: @313
      GIM_Try, /*On fail goto*//*Label 56*/ 356, // Rule ID 2085 //
        GIM_CheckFeatures, GIFBS_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immSExtAddius5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immSExtAddius5>>:$imm)  =>  (ADDIUS5_MM:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immSExtAddius5>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDIUS5_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2085,
        GIR_Done,
      // Label 56: @356
      GIM_Try, /*On fail goto*//*Label 57*/ 379, // Rule ID 1174 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPRMM16RegClassID,
        // (add:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (ADDU16_MMR6:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::ADDU16_MMR6,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1174,
        GIR_Done,
      // Label 57: @379
      GIM_Try, /*On fail goto*//*Label 58*/ 402, // Rule ID 34 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (add:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDu:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::ADDu,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 34,
        GIR_Done,
      // Label 58: @402
      GIM_Try, /*On fail goto*//*Label 59*/ 425, // Rule ID 1028 //
        GIM_CheckFeatures, GIFBS_InMicroMips_NotMips32r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPRMM16RegClassID,
        // (add:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (ADDU16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::ADDU16_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1028,
        GIR_Done,
      // Label 59: @425
      GIM_Try, /*On fail goto*//*Label 60*/ 448, // Rule ID 1040 //
        GIM_CheckFeatures, GIFBS_InMicroMips_NotMips32r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (add:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDu_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::ADDu_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1040,
        GIR_Done,
      // Label 60: @448
      GIM_Try, /*On fail goto*//*Label 61*/ 471, // Rule ID 1745 //
        GIM_CheckFeatures, GIFBS_InMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::CPU16RegsRegClassID,
        // (add:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (AdduRxRyRz16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::AdduRxRyRz16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1745,
        GIR_Done,
      // Label 61: @471
      GIM_Reject,
    // Label 52: @472
    GIM_Reject,
    // Label 44: @473
    GIM_Try, /*On fail goto*//*Label 62*/ 635,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 63*/ 551, // Rule ID 2314 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasMips64_HasStdEnc,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_immZExt2Lsa,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } (shl:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt2Lsa>>:$sa), GPR64Opnd:{ *:[i64] }:$rt)  =>  (DLSA:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt, (imm:{ *:[i32] }):$sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DLSA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2314,
        GIR_Done,
      // Label 63: @551
      GIM_Try, /*On fail goto*//*Label 64*/ 615, // Rule ID 803 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasMips64_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_immZExt2Lsa,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, (shl:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt2Lsa>>:$sa))  =>  (DLSA:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt, (imm:{ *:[i32] }):$sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DLSA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 803,
        GIR_Done,
      // Label 64: @615
      GIM_Try, /*On fail goto*//*Label 65*/ 634, // Rule ID 180 //
        GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
        // (add:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DADDu:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DADDu,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 180,
        GIR_Done,
      // Label 65: @634
      GIM_Reject,
    // Label 62: @635
    GIM_Reject,
    // Label 45: @636
    GIM_Try, /*On fail goto*//*Label 66*/ 662, // Rule ID 1844 //
      GIM_CheckFeatures, GIFBS_HasDSP,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
      // (add:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (ADDQ_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::ADDQ_PH,
      GIR_AddImplicitDef, /*InsnID*/0, Mips::DSPOutFlag20,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1844,
      GIR_Done,
    // Label 66: @662
    GIM_Reject,
    // Label 46: @663
    GIM_Try, /*On fail goto*//*Label 67*/ 811,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_Try, /*On fail goto*//*Label 68*/ 734, // Rule ID 2318 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (mul:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt), MSA128DOpnd:{ *:[v2i64] }:$wd_in)  =>  (MADDV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MADDV_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2318,
        GIR_Done,
      // Label 68: @734
      GIM_Try, /*On fail goto*//*Label 69*/ 791, // Rule ID 811 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, (mul:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt))  =>  (MADDV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MADDV_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 811,
        GIR_Done,
      // Label 69: @791
      GIM_Try, /*On fail goto*//*Label 70*/ 810, // Rule ID 478 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        // (add:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ADDV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::ADDV_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 478,
        GIR_Done,
      // Label 70: @810
      GIM_Reject,
    // Label 67: @811
    GIM_Reject,
    // Label 47: @812
    GIM_Try, /*On fail goto*//*Label 71*/ 838, // Rule ID 1850 //
      GIM_CheckFeatures, GIFBS_HasDSP,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
      // (add:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)  =>  (ADDU_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::ADDU_QB,
      GIR_AddImplicitDef, /*InsnID*/0, Mips::DSPOutFlag20,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1850,
      GIR_Done,
    // Label 71: @838
    GIM_Reject,
    // Label 48: @839
    GIM_Try, /*On fail goto*//*Label 72*/ 987,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_Try, /*On fail goto*//*Label 73*/ 910, // Rule ID 2317 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (mul:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt), MSA128WOpnd:{ *:[v4i32] }:$wd_in)  =>  (MADDV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MADDV_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2317,
        GIR_Done,
      // Label 73: @910
      GIM_Try, /*On fail goto*//*Label 74*/ 967, // Rule ID 810 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, (mul:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt))  =>  (MADDV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MADDV_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 810,
        GIR_Done,
      // Label 74: @967
      GIM_Try, /*On fail goto*//*Label 75*/ 986, // Rule ID 477 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // (add:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ADDV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::ADDV_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 477,
        GIR_Done,
      // Label 75: @986
      GIM_Reject,
    // Label 72: @987
    GIM_Reject,
    // Label 49: @988
    GIM_Try, /*On fail goto*//*Label 76*/ 1136,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      GIM_Try, /*On fail goto*//*Label 77*/ 1059, // Rule ID 2316 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (mul:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt), MSA128HOpnd:{ *:[v8i16] }:$wd_in)  =>  (MADDV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MADDV_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2316,
        GIR_Done,
      // Label 77: @1059
      GIM_Try, /*On fail goto*//*Label 78*/ 1116, // Rule ID 809 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, (mul:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt))  =>  (MADDV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MADDV_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 809,
        GIR_Done,
      // Label 78: @1116
      GIM_Try, /*On fail goto*//*Label 79*/ 1135, // Rule ID 476 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        // (add:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ADDV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::ADDV_H,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 476,
        GIR_Done,
      // Label 79: @1135
      GIM_Reject,
    // Label 76: @1136
    GIM_Reject,
    // Label 50: @1137
    GIM_Try, /*On fail goto*//*Label 80*/ 1285,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      GIM_Try, /*On fail goto*//*Label 81*/ 1208, // Rule ID 2315 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } (mul:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt), MSA128BOpnd:{ *:[v16i8] }:$wd_in)  =>  (MADDV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MADDV_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2315,
        GIR_Done,
      // Label 81: @1208
      GIM_Try, /*On fail goto*//*Label 82*/ 1265, // Rule ID 808 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, (mul:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt))  =>  (MADDV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MADDV_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 808,
        GIR_Done,
      // Label 82: @1265
      GIM_Try, /*On fail goto*//*Label 83*/ 1284, // Rule ID 475 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        // (add:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ADDV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::ADDV_B,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 475,
        GIR_Done,
      // Label 83: @1284
      GIM_Reject,
    // Label 80: @1285
    GIM_Reject,
    // Label 51: @1286
    GIM_Reject,
    // Label 1: @1287
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 9, /*)*//*default:*//*Label 92*/ 1898,
    /*GILLT_s32*//*Label 84*/ 1301,
    /*GILLT_s64*//*Label 85*/ 1460,
    /*GILLT_v2s16*//*Label 86*/ 1492,
    /*GILLT_v2s64*//*Label 87*/ 1519,
    /*GILLT_v4s8*//*Label 88*/ 1607,
    /*GILLT_v4s32*//*Label 89*/ 1634,
    /*GILLT_v8s16*//*Label 90*/ 1722,
    /*GILLT_v16s8*//*Label 91*/ 1810,
    // Label 84: @1301
    GIM_Try, /*On fail goto*//*Label 93*/ 1459,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 94*/ 1343, // Rule ID 1744 //
        GIM_CheckFeatures, GIFBS_InMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::CPU16RegsRegClassID,
        // (sub:{ *:[i32] } 0:{ *:[i32] }, CPU16Regs:{ *:[i32] }:$r)  =>  (NegRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NegRxRy16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rx
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // r
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1744,
        GIR_Done,
      // Label 94: @1343
      GIM_Try, /*On fail goto*//*Label 95*/ 1366, // Rule ID 1176 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPRMM16RegClassID,
        // (sub:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (SUBU16_MMR6:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SUBU16_MMR6,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1176,
        GIR_Done,
      // Label 95: @1366
      GIM_Try, /*On fail goto*//*Label 96*/ 1389, // Rule ID 35 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (sub:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBu:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SUBu,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 35,
        GIR_Done,
      // Label 96: @1389
      GIM_Try, /*On fail goto*//*Label 97*/ 1412, // Rule ID 1032 //
        GIM_CheckFeatures, GIFBS_InMicroMips_NotMips32r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPRMM16RegClassID,
        // (sub:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (SUBU16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SUBU16_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1032,
        GIR_Done,
      // Label 97: @1412
      GIM_Try, /*On fail goto*//*Label 98*/ 1435, // Rule ID 1041 //
        GIM_CheckFeatures, GIFBS_InMicroMips_NotMips32r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (sub:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBu_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SUBu_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1041,
        GIR_Done,
      // Label 98: @1435
      GIM_Try, /*On fail goto*//*Label 99*/ 1458, // Rule ID 1749 //
        GIM_CheckFeatures, GIFBS_InMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::CPU16RegsRegClassID,
        // (sub:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (SubuRxRyRz16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SubuRxRyRz16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1749,
        GIR_Done,
      // Label 99: @1458
      GIM_Reject,
    // Label 93: @1459
    GIM_Reject,
    // Label 85: @1460
    GIM_Try, /*On fail goto*//*Label 100*/ 1491, // Rule ID 181 //
      GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_NotInMicroMips,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
      // (sub:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DSUBu:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DSUBu,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 181,
      GIR_Done,
    // Label 100: @1491
    GIM_Reject,
    // Label 86: @1492
    GIM_Try, /*On fail goto*//*Label 101*/ 1518, // Rule ID 1846 //
      GIM_CheckFeatures, GIFBS_HasDSP,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
      // (sub:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (SUBQ_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SUBQ_PH,
      GIR_AddImplicitDef, /*InsnID*/0, Mips::DSPOutFlag20,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1846,
      GIR_Done,
    // Label 101: @1518
    GIM_Reject,
    // Label 87: @1519
    GIM_Try, /*On fail goto*//*Label 102*/ 1606,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      GIM_Try, /*On fail goto*//*Label 103*/ 1590, // Rule ID 867 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, (mul:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt))  =>  (MSUBV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MSUBV_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 867,
        GIR_Done,
      // Label 103: @1590
      GIM_Try, /*On fail goto*//*Label 104*/ 1605, // Rule ID 996 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        // (sub:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SUBV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SUBV_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 996,
        GIR_Done,
      // Label 104: @1605
      GIM_Reject,
    // Label 102: @1606
    GIM_Reject,
    // Label 88: @1607
    GIM_Try, /*On fail goto*//*Label 105*/ 1633, // Rule ID 1852 //
      GIM_CheckFeatures, GIFBS_HasDSP,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
      // (sub:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)  =>  (SUBU_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SUBU_QB,
      GIR_AddImplicitDef, /*InsnID*/0, Mips::DSPOutFlag20,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1852,
      GIR_Done,
    // Label 105: @1633
    GIM_Reject,
    // Label 89: @1634
    GIM_Try, /*On fail goto*//*Label 106*/ 1721,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
      GIM_Try, /*On fail goto*//*Label 107*/ 1705, // Rule ID 866 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, (mul:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt))  =>  (MSUBV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MSUBV_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 866,
        GIR_Done,
      // Label 107: @1705
      GIM_Try, /*On fail goto*//*Label 108*/ 1720, // Rule ID 995 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // (sub:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SUBV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SUBV_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 995,
        GIR_Done,
      // Label 108: @1720
      GIM_Reject,
    // Label 106: @1721
    GIM_Reject,
    // Label 90: @1722
    GIM_Try, /*On fail goto*//*Label 109*/ 1809,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
      GIM_Try, /*On fail goto*//*Label 110*/ 1793, // Rule ID 865 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, (mul:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt))  =>  (MSUBV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MSUBV_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 865,
        GIR_Done,
      // Label 110: @1793
      GIM_Try, /*On fail goto*//*Label 111*/ 1808, // Rule ID 994 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        // (sub:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SUBV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SUBV_H,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 994,
        GIR_Done,
      // Label 111: @1808
      GIM_Reject,
    // Label 109: @1809
    GIM_Reject,
    // Label 91: @1810
    GIM_Try, /*On fail goto*//*Label 112*/ 1897,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
      GIM_Try, /*On fail goto*//*Label 113*/ 1881, // Rule ID 864 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, (mul:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt))  =>  (MSUBV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MSUBV_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 864,
        GIR_Done,
      // Label 113: @1881
      GIM_Try, /*On fail goto*//*Label 114*/ 1896, // Rule ID 993 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        // (sub:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SUBV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SUBV_B,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 993,
        GIR_Done,
      // Label 114: @1896
      GIM_Reject,
    // Label 112: @1897
    GIM_Reject,
    // Label 92: @1898
    GIM_Reject,
    // Label 2: @1899
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 9, /*)*//*default:*//*Label 122*/ 2274,
    /*GILLT_s32*//*Label 115*/ 1913,
    /*GILLT_s64*//*Label 116*/ 2058,
    /*GILLT_v2s16*//*Label 117*/ 2119,
    /*GILLT_v2s64*//*Label 118*/ 2146, 0,
    /*GILLT_v4s32*//*Label 119*/ 2178,
    /*GILLT_v8s16*//*Label 120*/ 2210,
    /*GILLT_v16s8*//*Label 121*/ 2242,
    // Label 115: @1913
    GIM_Try, /*On fail goto*//*Label 123*/ 2057,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 124*/ 1952, // Rule ID 36 //
        GIM_CheckFeatures, GIFBS_HasMips32_HasStdEnc_NotInMicroMips_NotMips32r6_NotMips64r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (mul:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MUL:{ *:[i32] }:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MUL,
        GIR_AddImplicitDef, /*InsnID*/0, Mips::HI0,
        GIR_AddImplicitDef, /*InsnID*/0, Mips::LO0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 36,
        GIR_Done,
      // Label 124: @1952
      GIM_Try, /*On fail goto*//*Label 125*/ 1975, // Rule ID 304 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (mul:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MUL_R6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MUL_R6,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 304,
        GIR_Done,
      // Label 125: @1975
      GIM_Try, /*On fail goto*//*Label 126*/ 2004, // Rule ID 1042 //
        GIM_CheckFeatures, GIFBS_InMicroMips_NotMips32r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (mul:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MUL_MM:{ *:[i32] }:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MUL_MM,
        GIR_AddImplicitDef, /*InsnID*/0, Mips::HI0,
        GIR_AddImplicitDef, /*InsnID*/0, Mips::LO0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1042,
        GIR_Done,
      // Label 126: @2004
      GIM_Try, /*On fail goto*//*Label 127*/ 2027, // Rule ID 1145 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (mul:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MUL_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MUL_MMR6,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1145,
        GIR_Done,
      // Label 127: @2027
      GIM_Try, /*On fail goto*//*Label 128*/ 2056, // Rule ID 1747 //
        GIM_CheckFeatures, GIFBS_InMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::CPU16RegsRegClassID,
        // (mul:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (MultRxRyRz16:{ *:[i32] }:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MultRxRyRz16,
        GIR_AddImplicitDef, /*InsnID*/0, Mips::HI0,
        GIR_AddImplicitDef, /*InsnID*/0, Mips::LO0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1747,
        GIR_Done,
      // Label 128: @2056
      GIM_Reject,
    // Label 123: @2057
    GIM_Reject,
    // Label 116: @2058
    GIM_Try, /*On fail goto*//*Label 129*/ 2118,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 130*/ 2106, // Rule ID 246 //
        GIM_CheckFeatures, GIFBS_HasCnMips,
        // (mul:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DMUL:{ *:[i64] }:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DMUL,
        GIR_AddImplicitDef, /*InsnID*/0, Mips::HI0,
        GIR_AddImplicitDef, /*InsnID*/0, Mips::LO0,
        GIR_AddImplicitDef, /*InsnID*/0, Mips::P0,
        GIR_AddImplicitDef, /*InsnID*/0, Mips::P1,
        GIR_AddImplicitDef, /*InsnID*/0, Mips::P2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 246,
        GIR_Done,
      // Label 130: @2106
      GIM_Try, /*On fail goto*//*Label 131*/ 2117, // Rule ID 319 //
        GIM_CheckFeatures, GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips,
        // (mul:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DMUL_R6:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DMUL_R6,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 319,
        GIR_Done,
      // Label 131: @2117
      GIM_Reject,
    // Label 129: @2118
    GIM_Reject,
    // Label 117: @2119
    GIM_Try, /*On fail goto*//*Label 132*/ 2145, // Rule ID 1848 //
      GIM_CheckFeatures, GIFBS_HasDSPR2,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
      // (mul:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (MUL_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MUL_PH,
      GIR_AddImplicitDef, /*InsnID*/0, Mips::DSPOutFlag21,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1848,
      GIR_Done,
    // Label 132: @2145
    GIM_Reject,
    // Label 118: @2146
    GIM_Try, /*On fail goto*//*Label 133*/ 2177, // Rule ID 875 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
      // (mul:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (MULV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MULV_D,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 875,
      GIR_Done,
    // Label 133: @2177
    GIM_Reject,
    // Label 119: @2178
    GIM_Try, /*On fail goto*//*Label 134*/ 2209, // Rule ID 874 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
      // (mul:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MULV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MULV_W,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 874,
      GIR_Done,
    // Label 134: @2209
    GIM_Reject,
    // Label 120: @2210
    GIM_Try, /*On fail goto*//*Label 135*/ 2241, // Rule ID 873 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
      // (mul:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MULV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MULV_H,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 873,
      GIR_Done,
    // Label 135: @2241
    GIM_Reject,
    // Label 121: @2242
    GIM_Try, /*On fail goto*//*Label 136*/ 2273, // Rule ID 872 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
      // (mul:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (MULV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MULV_B,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 872,
      GIR_Done,
    // Label 136: @2273
    GIM_Reject,
    // Label 122: @2274
    GIM_Reject,
    // Label 3: @2275
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 9, /*)*//*default:*//*Label 143*/ 2495,
    /*GILLT_s32*//*Label 137*/ 2289,
    /*GILLT_s64*//*Label 138*/ 2335, 0,
    /*GILLT_v2s64*//*Label 139*/ 2367, 0,
    /*GILLT_v4s32*//*Label 140*/ 2399,
    /*GILLT_v8s16*//*Label 141*/ 2431,
    /*GILLT_v16s8*//*Label 142*/ 2463,
    // Label 137: @2289
    GIM_Try, /*On fail goto*//*Label 144*/ 2334,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
      GIM_Try, /*On fail goto*//*Label 145*/ 2322, // Rule ID 298 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips,
        // (sdiv:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (DIV:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DIV,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 298,
        GIR_Done,
      // Label 145: @2322
      GIM_Try, /*On fail goto*//*Label 146*/ 2333, // Rule ID 1138 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
        // (sdiv:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (DIV_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DIV_MMR6,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1138,
        GIR_Done,
      // Label 146: @2333
      GIM_Reject,
    // Label 144: @2334
    GIM_Reject,
    // Label 138: @2335
    GIM_Try, /*On fail goto*//*Label 147*/ 2366, // Rule ID 313 //
      GIM_CheckFeatures, GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
      // (sdiv:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DDIV:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DDIV,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 313,
      GIR_Done,
    // Label 147: @2366
    GIM_Reject,
    // Label 139: @2367
    GIM_Try, /*On fail goto*//*Label 148*/ 2398, // Rule ID 615 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
      // (sdiv:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (DIV_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DIV_S_D,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 615,
      GIR_Done,
    // Label 148: @2398
    GIM_Reject,
    // Label 140: @2399
    GIM_Try, /*On fail goto*//*Label 149*/ 2430, // Rule ID 614 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
      // (sdiv:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DIV_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DIV_S_W,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 614,
      GIR_Done,
    // Label 149: @2430
    GIM_Reject,
    // Label 141: @2431
    GIM_Try, /*On fail goto*//*Label 150*/ 2462, // Rule ID 613 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
      // (sdiv:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DIV_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DIV_S_H,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 613,
      GIR_Done,
    // Label 150: @2462
    GIM_Reject,
    // Label 142: @2463
    GIM_Try, /*On fail goto*//*Label 151*/ 2494, // Rule ID 612 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
      // (sdiv:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DIV_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DIV_S_B,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 612,
      GIR_Done,
    // Label 151: @2494
    GIM_Reject,
    // Label 143: @2495
    GIM_Reject,
    // Label 4: @2496
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 9, /*)*//*default:*//*Label 158*/ 2716,
    /*GILLT_s32*//*Label 152*/ 2510,
    /*GILLT_s64*//*Label 153*/ 2556, 0,
    /*GILLT_v2s64*//*Label 154*/ 2588, 0,
    /*GILLT_v4s32*//*Label 155*/ 2620,
    /*GILLT_v8s16*//*Label 156*/ 2652,
    /*GILLT_v16s8*//*Label 157*/ 2684,
    // Label 152: @2510
    GIM_Try, /*On fail goto*//*Label 159*/ 2555,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
      GIM_Try, /*On fail goto*//*Label 160*/ 2543, // Rule ID 299 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips,
        // (udiv:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (DIVU:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DIVU,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 299,
        GIR_Done,
      // Label 160: @2543
      GIM_Try, /*On fail goto*//*Label 161*/ 2554, // Rule ID 1139 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
        // (udiv:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (DIVU_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DIVU_MMR6,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1139,
        GIR_Done,
      // Label 161: @2554
      GIM_Reject,
    // Label 159: @2555
    GIM_Reject,
    // Label 153: @2556
    GIM_Try, /*On fail goto*//*Label 162*/ 2587, // Rule ID 314 //
      GIM_CheckFeatures, GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
      // (udiv:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DDIVU:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DDIVU,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 314,
      GIR_Done,
    // Label 162: @2587
    GIM_Reject,
    // Label 154: @2588
    GIM_Try, /*On fail goto*//*Label 163*/ 2619, // Rule ID 619 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
      // (udiv:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (DIV_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DIV_U_D,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 619,
      GIR_Done,
    // Label 163: @2619
    GIM_Reject,
    // Label 155: @2620
    GIM_Try, /*On fail goto*//*Label 164*/ 2651, // Rule ID 618 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
      // (udiv:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DIV_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DIV_U_W,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 618,
      GIR_Done,
    // Label 164: @2651
    GIM_Reject,
    // Label 156: @2652
    GIM_Try, /*On fail goto*//*Label 165*/ 2683, // Rule ID 617 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
      // (udiv:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DIV_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DIV_U_H,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 617,
      GIR_Done,
    // Label 165: @2683
    GIM_Reject,
    // Label 157: @2684
    GIM_Try, /*On fail goto*//*Label 166*/ 2715, // Rule ID 616 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
      // (udiv:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DIV_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DIV_U_B,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 616,
      GIR_Done,
    // Label 166: @2715
    GIM_Reject,
    // Label 158: @2716
    GIM_Reject,
    // Label 5: @2717
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 9, /*)*//*default:*//*Label 173*/ 2937,
    /*GILLT_s32*//*Label 167*/ 2731,
    /*GILLT_s64*//*Label 168*/ 2777, 0,
    /*GILLT_v2s64*//*Label 169*/ 2809, 0,
    /*GILLT_v4s32*//*Label 170*/ 2841,
    /*GILLT_v8s16*//*Label 171*/ 2873,
    /*GILLT_v16s8*//*Label 172*/ 2905,
    // Label 167: @2731
    GIM_Try, /*On fail goto*//*Label 174*/ 2776,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
      GIM_Try, /*On fail goto*//*Label 175*/ 2764, // Rule ID 300 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips,
        // (srem:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MOD:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MOD,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 300,
        GIR_Done,
      // Label 175: @2764
      GIM_Try, /*On fail goto*//*Label 176*/ 2775, // Rule ID 1143 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
        // (srem:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MOD_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MOD_MMR6,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1143,
        GIR_Done,
      // Label 176: @2775
      GIM_Reject,
    // Label 174: @2776
    GIM_Reject,
    // Label 168: @2777
    GIM_Try, /*On fail goto*//*Label 177*/ 2808, // Rule ID 315 //
      GIM_CheckFeatures, GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
      // (srem:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DMOD:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DMOD,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 315,
      GIR_Done,
    // Label 177: @2808
    GIM_Reject,
    // Label 169: @2809
    GIM_Try, /*On fail goto*//*Label 178*/ 2840, // Rule ID 855 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
      // (srem:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (MOD_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MOD_S_D,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 855,
      GIR_Done,
    // Label 178: @2840
    GIM_Reject,
    // Label 170: @2841
    GIM_Try, /*On fail goto*//*Label 179*/ 2872, // Rule ID 854 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
      // (srem:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MOD_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MOD_S_W,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 854,
      GIR_Done,
    // Label 179: @2872
    GIM_Reject,
    // Label 171: @2873
    GIM_Try, /*On fail goto*//*Label 180*/ 2904, // Rule ID 853 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
      // (srem:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MOD_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MOD_S_H,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 853,
      GIR_Done,
    // Label 180: @2904
    GIM_Reject,
    // Label 172: @2905
    GIM_Try, /*On fail goto*//*Label 181*/ 2936, // Rule ID 852 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
      // (srem:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (MOD_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MOD_S_B,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 852,
      GIR_Done,
    // Label 181: @2936
    GIM_Reject,
    // Label 173: @2937
    GIM_Reject,
    // Label 6: @2938
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 9, /*)*//*default:*//*Label 188*/ 3158,
    /*GILLT_s32*//*Label 182*/ 2952,
    /*GILLT_s64*//*Label 183*/ 2998, 0,
    /*GILLT_v2s64*//*Label 184*/ 3030, 0,
    /*GILLT_v4s32*//*Label 185*/ 3062,
    /*GILLT_v8s16*//*Label 186*/ 3094,
    /*GILLT_v16s8*//*Label 187*/ 3126,
    // Label 182: @2952
    GIM_Try, /*On fail goto*//*Label 189*/ 2997,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
      GIM_Try, /*On fail goto*//*Label 190*/ 2985, // Rule ID 301 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips,
        // (urem:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MODU:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MODU,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 301,
        GIR_Done,
      // Label 190: @2985
      GIM_Try, /*On fail goto*//*Label 191*/ 2996, // Rule ID 1144 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
        // (urem:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MODU_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MODU_MMR6,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1144,
        GIR_Done,
      // Label 191: @2996
      GIM_Reject,
    // Label 189: @2997
    GIM_Reject,
    // Label 183: @2998
    GIM_Try, /*On fail goto*//*Label 192*/ 3029, // Rule ID 316 //
      GIM_CheckFeatures, GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
      // (urem:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DMODU:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DMODU,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 316,
      GIR_Done,
    // Label 192: @3029
    GIM_Reject,
    // Label 184: @3030
    GIM_Try, /*On fail goto*//*Label 193*/ 3061, // Rule ID 859 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
      // (urem:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (MOD_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MOD_U_D,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 859,
      GIR_Done,
    // Label 193: @3061
    GIM_Reject,
    // Label 185: @3062
    GIM_Try, /*On fail goto*//*Label 194*/ 3093, // Rule ID 858 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
      // (urem:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MOD_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MOD_U_W,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 858,
      GIR_Done,
    // Label 194: @3093
    GIM_Reject,
    // Label 186: @3094
    GIM_Try, /*On fail goto*//*Label 195*/ 3125, // Rule ID 857 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
      // (urem:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MOD_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MOD_U_H,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 857,
      GIR_Done,
    // Label 195: @3125
    GIM_Reject,
    // Label 187: @3126
    GIM_Try, /*On fail goto*//*Label 196*/ 3157, // Rule ID 856 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
      // (urem:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (MOD_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MOD_U_B,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 856,
      GIR_Done,
    // Label 196: @3157
    GIM_Reject,
    // Label 188: @3158
    GIM_Reject,
    // Label 7: @3159
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 9, /*)*//*default:*//*Label 203*/ 3602,
    /*GILLT_s32*//*Label 197*/ 3173,
    /*GILLT_s64*//*Label 198*/ 3386, 0,
    /*GILLT_v2s64*//*Label 199*/ 3474, 0,
    /*GILLT_v4s32*//*Label 200*/ 3506,
    /*GILLT_v8s16*//*Label 201*/ 3538,
    /*GILLT_v16s8*//*Label 202*/ 3570,
    // Label 197: @3173
    GIM_Try, /*On fail goto*//*Label 204*/ 3385,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 205*/ 3226, // Rule ID 2087 //
        GIM_CheckFeatures, GIFBS_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPRMM16RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExtAndi16,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExtAndi16>>:$imm)  =>  (ANDI16_MM:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExtAndi16>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ANDI16_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2087,
        GIR_Done,
      // Label 205: @3226
      GIM_Try, /*On fail goto*//*Label 206*/ 3269, // Rule ID 2244 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPRMM16RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExtAndi16,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExtAndi16>>:$imm)  =>  (ANDI16_MMR6:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExtAndi16>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ANDI16_MMR6,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2244,
        GIR_Done,
      // Label 206: @3269
      GIM_Try, /*On fail goto*//*Label 207*/ 3292, // Rule ID 39 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (and:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (AND:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::AND,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 39,
        GIR_Done,
      // Label 207: @3292
      GIM_Try, /*On fail goto*//*Label 208*/ 3315, // Rule ID 1029 //
        GIM_CheckFeatures, GIFBS_InMicroMips_NotMips32r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPRMM16RegClassID,
        // (and:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (AND16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::AND16_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1029,
        GIR_Done,
      // Label 208: @3315
      GIM_Try, /*On fail goto*//*Label 209*/ 3338, // Rule ID 1045 //
        GIM_CheckFeatures, GIFBS_InMicroMips_NotMips32r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (and:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (AND_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::AND_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1045,
        GIR_Done,
      // Label 209: @3338
      GIM_Try, /*On fail goto*//*Label 210*/ 3361, // Rule ID 1136 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (and:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (AND_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::AND_MMR6,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1136,
        GIR_Done,
      // Label 210: @3361
      GIM_Try, /*On fail goto*//*Label 211*/ 3384, // Rule ID 1746 //
        GIM_CheckFeatures, GIFBS_InMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::CPU16RegsRegClassID,
        // (and:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (AndRxRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::AndRxRxRy16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1746,
        GIR_Done,
      // Label 211: @3384
      GIM_Reject,
    // Label 204: @3385
    GIM_Reject,
    // Label 198: @3386
    GIM_Try, /*On fail goto*//*Label 212*/ 3473,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 213*/ 3453, // Rule ID 241 //
        GIM_CheckFeatures, GIFBS_HasCnMips,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ADD,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (add:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt), 255:{ *:[i64] })  =>  (BADDu:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::BADDu,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 241,
        GIR_Done,
      // Label 213: @3453
      GIM_Try, /*On fail goto*//*Label 214*/ 3472, // Rule ID 184 //
        GIM_CheckFeatures, GIFBS_IsGP64bit_NotInMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
        // (and:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (AND64:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::AND64,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 184,
        GIR_Done,
      // Label 214: @3472
      GIM_Reject,
    // Label 212: @3473
    GIM_Reject,
    // Label 199: @3474
    GIM_Try, /*On fail goto*//*Label 215*/ 3505, // Rule ID 486 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
      // (and:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (AND_V_D_PSEUDO:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::AND_V_D_PSEUDO,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 486,
      GIR_Done,
    // Label 215: @3505
    GIM_Reject,
    // Label 200: @3506
    GIM_Try, /*On fail goto*//*Label 216*/ 3537, // Rule ID 485 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
      // (and:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (AND_V_W_PSEUDO:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::AND_V_W_PSEUDO,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 485,
      GIR_Done,
    // Label 216: @3537
    GIM_Reject,
    // Label 201: @3538
    GIM_Try, /*On fail goto*//*Label 217*/ 3569, // Rule ID 484 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
      // (and:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (AND_V_H_PSEUDO:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::AND_V_H_PSEUDO,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 484,
      GIR_Done,
    // Label 217: @3569
    GIM_Reject,
    // Label 202: @3570
    GIM_Try, /*On fail goto*//*Label 218*/ 3601, // Rule ID 483 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
      // (and:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (AND_V:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::AND_V,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 483,
      GIR_Done,
    // Label 218: @3601
    GIM_Reject,
    // Label 203: @3602
    GIM_Reject,
    // Label 8: @3603
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 9, /*)*//*default:*//*Label 225*/ 3904,
    /*GILLT_s32*//*Label 219*/ 3617,
    /*GILLT_s64*//*Label 220*/ 3744, 0,
    /*GILLT_v2s64*//*Label 221*/ 3776, 0,
    /*GILLT_v4s32*//*Label 222*/ 3808,
    /*GILLT_v8s16*//*Label 223*/ 3840,
    /*GILLT_v16s8*//*Label 224*/ 3872,
    // Label 219: @3617
    GIM_Try, /*On fail goto*//*Label 226*/ 3743,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 227*/ 3650, // Rule ID 40 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (OR:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::OR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 40,
        GIR_Done,
      // Label 227: @3650
      GIM_Try, /*On fail goto*//*Label 228*/ 3673, // Rule ID 1031 //
        GIM_CheckFeatures, GIFBS_InMicroMips_NotMips32r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPRMM16RegClassID,
        // (or:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (OR16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::OR16_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1031,
        GIR_Done,
      // Label 228: @3673
      GIM_Try, /*On fail goto*//*Label 229*/ 3696, // Rule ID 1046 //
        GIM_CheckFeatures, GIFBS_InMicroMips_NotMips32r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (OR_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::OR_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1046,
        GIR_Done,
      // Label 229: @3696
      GIM_Try, /*On fail goto*//*Label 230*/ 3719, // Rule ID 1149 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (OR_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::OR_MMR6,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1149,
        GIR_Done,
      // Label 230: @3719
      GIM_Try, /*On fail goto*//*Label 231*/ 3742, // Rule ID 1748 //
        GIM_CheckFeatures, GIFBS_InMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::CPU16RegsRegClassID,
        // (or:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (OrRxRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::OrRxRxRy16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1748,
        GIR_Done,
      // Label 231: @3742
      GIM_Reject,
    // Label 226: @3743
    GIM_Reject,
    // Label 220: @3744
    GIM_Try, /*On fail goto*//*Label 232*/ 3775, // Rule ID 185 //
      GIM_CheckFeatures, GIFBS_IsGP64bit_NotInMips16Mode,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
      // (or:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (OR64:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::OR64,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 185,
      GIR_Done,
    // Label 232: @3775
    GIM_Reject,
    // Label 221: @3776
    GIM_Try, /*On fail goto*//*Label 233*/ 3807, // Rule ID 892 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
      // (or:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (OR_V_D_PSEUDO:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::OR_V_D_PSEUDO,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 892,
      GIR_Done,
    // Label 233: @3807
    GIM_Reject,
    // Label 222: @3808
    GIM_Try, /*On fail goto*//*Label 234*/ 3839, // Rule ID 891 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
      // (or:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (OR_V_W_PSEUDO:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::OR_V_W_PSEUDO,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 891,
      GIR_Done,
    // Label 234: @3839
    GIM_Reject,
    // Label 223: @3840
    GIM_Try, /*On fail goto*//*Label 235*/ 3871, // Rule ID 890 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
      // (or:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (OR_V_H_PSEUDO:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::OR_V_H_PSEUDO,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 890,
      GIR_Done,
    // Label 235: @3871
    GIM_Reject,
    // Label 224: @3872
    GIM_Try, /*On fail goto*//*Label 236*/ 3903, // Rule ID 889 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
      // (or:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (OR_V:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::OR_V,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 889,
      GIR_Done,
    // Label 236: @3903
    GIM_Reject,
    // Label 225: @3904
    GIM_Reject,
    // Label 9: @3905
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 9, /*)*//*default:*//*Label 243*/ 4698,
    /*GILLT_s32*//*Label 237*/ 3919,
    /*GILLT_s64*//*Label 238*/ 4482, 0,
    /*GILLT_v2s64*//*Label 239*/ 4570, 0,
    /*GILLT_v4s32*//*Label 240*/ 4602,
    /*GILLT_v8s16*//*Label 241*/ 4634,
    /*GILLT_v16s8*//*Label 242*/ 4666,
    // Label 237: @3919
    GIM_Try, /*On fail goto*//*Label 244*/ 4481,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 245*/ 3986, // Rule ID 42 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt), -1:{ *:[i32] })  =>  (NOR:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 42,
        GIR_Done,
      // Label 245: @3986
      GIM_Try, /*On fail goto*//*Label 246*/ 4043, // Rule ID 1048 //
        GIM_CheckFeatures, GIFBS_InMicroMips_NotMips32r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt), -1:{ *:[i32] })  =>  (NOR_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NOR_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1048,
        GIR_Done,
      // Label 246: @4043
      GIM_Try, /*On fail goto*//*Label 247*/ 4100, // Rule ID 1148 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt), -1:{ *:[i32] })  =>  (NOR_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NOR_MMR6,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1148,
        GIR_Done,
      // Label 247: @4100
      GIM_Try, /*On fail goto*//*Label 248*/ 4132, // Rule ID 1175 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, -1:{ *:[i32] })  =>  (NOT16_MMR6:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NOT16_MMR6,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1175,
        GIR_Done,
      // Label 248: @4132
      GIM_Try, /*On fail goto*//*Label 249*/ 4164, // Rule ID 1030 //
        GIM_CheckFeatures, GIFBS_InMicroMips_NotMips32r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, -1:{ *:[i32] })  =>  (NOT16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NOT16_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1030,
        GIR_Done,
      // Label 249: @4164
      GIM_Try, /*On fail goto*//*Label 250*/ 4199, // Rule ID 1362 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOR:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$in, ZERO:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_AddRegister, /*InsnID*/0, Mips::ZERO,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1362,
        GIR_Done,
      // Label 250: @4199
      GIM_Try, /*On fail goto*//*Label 251*/ 4231, // Rule ID 1743 //
        GIM_CheckFeatures, GIFBS_InMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r, -1:{ *:[i32] })  =>  (NotRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NotRxRy16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rx
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // r
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1743,
        GIR_Done,
      // Label 251: @4231
      GIM_Try, /*On fail goto*//*Label 252*/ 4263, // Rule ID 2082 //
        GIM_CheckFeatures, GIFBS_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i32] } GPRMM16:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOT16_MM:{ *:[i32] } GPRMM16:{ *:[i32] }:$in)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NOT16_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2082,
        GIR_Done,
      // Label 252: @4263
      GIM_Try, /*On fail goto*//*Label 253*/ 4298, // Rule ID 2083 //
        GIM_CheckFeatures, GIFBS_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOR_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$in, ZERO:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NOR_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_AddRegister, /*InsnID*/0, Mips::ZERO,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2083,
        GIR_Done,
      // Label 253: @4298
      GIM_Try, /*On fail goto*//*Label 254*/ 4330, // Rule ID 2247 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i32] } GPRMM16:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOT16_MMR6:{ *:[i32] } GPRMM16:{ *:[i32] }:$in)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NOT16_MMR6,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2247,
        GIR_Done,
      // Label 254: @4330
      GIM_Try, /*On fail goto*//*Label 255*/ 4365, // Rule ID 2248 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOR_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$in, ZERO:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NOR_MMR6,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_AddRegister, /*InsnID*/0, Mips::ZERO,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2248,
        GIR_Done,
      // Label 255: @4365
      GIM_Try, /*On fail goto*//*Label 256*/ 4388, // Rule ID 41 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (xor:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (XOR:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::XOR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 41,
        GIR_Done,
      // Label 256: @4388
      GIM_Try, /*On fail goto*//*Label 257*/ 4411, // Rule ID 1033 //
        GIM_CheckFeatures, GIFBS_InMicroMips_NotMips32r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPRMM16RegClassID,
        // (xor:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (XOR16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::XOR16_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1033,
        GIR_Done,
      // Label 257: @4411
      GIM_Try, /*On fail goto*//*Label 258*/ 4434, // Rule ID 1047 //
        GIM_CheckFeatures, GIFBS_InMicroMips_NotMips32r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (xor:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (XOR_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::XOR_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1047,
        GIR_Done,
      // Label 258: @4434
      GIM_Try, /*On fail goto*//*Label 259*/ 4457, // Rule ID 1152 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (xor:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (XOR_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::XOR_MMR6,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1152,
        GIR_Done,
      // Label 259: @4457
      GIM_Try, /*On fail goto*//*Label 260*/ 4480, // Rule ID 1750 //
        GIM_CheckFeatures, GIFBS_InMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::CPU16RegsRegClassID,
        // (xor:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (XorRxRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::XorRxRxRy16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1750,
        GIR_Done,
      // Label 260: @4480
      GIM_Reject,
    // Label 244: @4481
    GIM_Reject,
    // Label 238: @4482
    GIM_Try, /*On fail goto*//*Label 261*/ 4569,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 262*/ 4549, // Rule ID 187 //
        GIM_CheckFeatures, GIFBS_IsGP64bit_NotInMips16Mode,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (or:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt), -1:{ *:[i64] })  =>  (NOR64:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NOR64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 187,
        GIR_Done,
      // Label 262: @4549
      GIM_Try, /*On fail goto*//*Label 263*/ 4568, // Rule ID 186 //
        GIM_CheckFeatures, GIFBS_IsGP64bit_NotInMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
        // (xor:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (XOR64:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::XOR64,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 186,
        GIR_Done,
      // Label 263: @4568
      GIM_Reject,
    // Label 261: @4569
    GIM_Reject,
    // Label 239: @4570
    GIM_Try, /*On fail goto*//*Label 264*/ 4601, // Rule ID 1008 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
      // (xor:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (XOR_V_D_PSEUDO:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::XOR_V_D_PSEUDO,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1008,
      GIR_Done,
    // Label 264: @4601
    GIM_Reject,
    // Label 240: @4602
    GIM_Try, /*On fail goto*//*Label 265*/ 4633, // Rule ID 1007 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
      // (xor:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (XOR_V_W_PSEUDO:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::XOR_V_W_PSEUDO,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1007,
      GIR_Done,
    // Label 265: @4633
    GIM_Reject,
    // Label 241: @4634
    GIM_Try, /*On fail goto*//*Label 266*/ 4665, // Rule ID 1006 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
      // (xor:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (XOR_V_H_PSEUDO:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::XOR_V_H_PSEUDO,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1006,
      GIR_Done,
    // Label 266: @4665
    GIM_Reject,
    // Label 242: @4666
    GIM_Try, /*On fail goto*//*Label 267*/ 4697, // Rule ID 1005 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
      // (xor:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (XOR_V:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::XOR_V,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1005,
      GIR_Done,
    // Label 267: @4697
    GIM_Reject,
    // Label 243: @4698
    GIM_Reject,
    // Label 10: @4699
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 9, /*)*//*default:*//*Label 276*/ 8351,
    /*GILLT_s32*//*Label 268*/ 4713,
    /*GILLT_s64*//*Label 269*/ 4952,
    /*GILLT_v2s16*//*Label 270*/ 4998,
    /*GILLT_v2s64*//*Label 271*/ 5044,
    /*GILLT_v4s8*//*Label 272*/ 6017,
    /*GILLT_v4s32*//*Label 273*/ 6063,
    /*GILLT_v8s16*//*Label 274*/ 6966,
    /*GILLT_v16s8*//*Label 275*/ 7764,
    // Label 268: @4713
    GIM_Try, /*On fail goto*//*Label 277*/ 4736, // Rule ID 117 //
      GIM_CheckFeatures, GIFBS_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
      // (bitconvert:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)  =>  (MFC1:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MFC1,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 117,
      GIR_Done,
    // Label 277: @4736
    GIM_Try, /*On fail goto*//*Label 278*/ 4759, // Rule ID 118 //
      GIM_CheckFeatures, GIFBS_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      // (bitconvert:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)  =>  (MTC1:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MTC1,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 118,
      GIR_Done,
    // Label 278: @4759
    GIM_Try, /*On fail goto*//*Label 279*/ 4782, // Rule ID 1128 //
      GIM_CheckFeatures, GIFBS_InMicroMips_IsNotSoftFloat,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
      // (bitconvert:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)  =>  (MFC1_MM:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MFC1_MM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1128,
      GIR_Done,
    // Label 279: @4782
    GIM_Try, /*On fail goto*//*Label 280*/ 4805, // Rule ID 1129 //
      GIM_CheckFeatures, GIFBS_InMicroMips_IsNotSoftFloat,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      // (bitconvert:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)  =>  (MTC1_MM:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MTC1_MM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1129,
      GIR_Done,
    // Label 280: @4805
    GIM_Try, /*On fail goto*//*Label 281*/ 4828, // Rule ID 1141 //
      GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips_IsNotSoftFloat,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      // (bitconvert:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)  =>  (MTC1_MMR6:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MTC1_MMR6,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1141,
      GIR_Done,
    // Label 281: @4828
    GIM_Try, /*On fail goto*//*Label 282*/ 4851, // Rule ID 1142 //
      GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips_IsNotSoftFloat,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
      // (bitconvert:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)  =>  (MFC1_MMR6:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MFC1_MMR6,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1142,
      GIR_Done,
    // Label 282: @4851
    GIM_Try, /*On fail goto*//*Label 283*/ 4876, // Rule ID 1831 //
      GIM_CheckFeatures, GIFBS_HasDSP,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::DSPRRegClassID,
      // (bitconvert:{ *:[i32] } DSPR:{ *:[v2i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[i32] } DSPR:{ *:[v2i16] }:$src, GPR32:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR32*/11,
      // GIR_Coverage, 1831,
      GIR_Done,
    // Label 283: @4876
    GIM_Try, /*On fail goto*//*Label 284*/ 4901, // Rule ID 1832 //
      GIM_CheckFeatures, GIFBS_HasDSP,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::DSPRRegClassID,
      // (bitconvert:{ *:[i32] } DSPR:{ *:[v4i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[i32] } DSPR:{ *:[v4i8] }:$src, GPR32:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR32*/11,
      // GIR_Coverage, 1832,
      GIR_Done,
    // Label 284: @4901
    GIM_Try, /*On fail goto*//*Label 285*/ 4926, // Rule ID 1835 //
      GIM_CheckFeatures, GIFBS_HasDSP,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::DSPRRegClassID,
      // (bitconvert:{ *:[f32] } DSPR:{ *:[v2i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[f32] } DSPR:{ *:[v2i16] }:$src, FGR32:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FGR32*/8,
      // GIR_Coverage, 1835,
      GIR_Done,
    // Label 285: @4926
    GIM_Try, /*On fail goto*//*Label 286*/ 4951, // Rule ID 1836 //
      GIM_CheckFeatures, GIFBS_HasDSP,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::DSPRRegClassID,
      // (bitconvert:{ *:[f32] } DSPR:{ *:[v4i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[f32] } DSPR:{ *:[v4i8] }:$src, FGR32:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FGR32*/8,
      // GIR_Coverage, 1836,
      GIR_Done,
    // Label 286: @4951
    GIM_Reject,
    // Label 269: @4952
    GIM_Try, /*On fail goto*//*Label 287*/ 4997,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 288*/ 4977, // Rule ID 119 //
        GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
        // (bitconvert:{ *:[f64] } GPR64Opnd:{ *:[i64] }:$rt)  =>  (DMTC1:{ *:[f64] } GPR64Opnd:{ *:[i64] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DMTC1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 119,
        GIR_Done,
      // Label 288: @4977
      GIM_Try, /*On fail goto*//*Label 289*/ 4996, // Rule ID 120 //
        GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR64RegClassID,
        // (bitconvert:{ *:[i64] } FGR64Opnd:{ *:[f64] }:$fs)  =>  (DMFC1:{ *:[i64] } FGR64Opnd:{ *:[f64] }:$fs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DMFC1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 120,
        GIR_Done,
      // Label 289: @4996
      GIM_Reject,
    // Label 287: @4997
    GIM_Reject,
    // Label 270: @4998
    GIM_Try, /*On fail goto*//*Label 290*/ 5043,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 291*/ 5025, // Rule ID 1833 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        // (bitconvert:{ *:[v2i16] } GPR32:{ *:[i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i16] } GPR32:{ *:[i32] }:$src, DSPR:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DSPR*/7,
        // GIR_Coverage, 1833,
        GIR_Done,
      // Label 291: @5025
      GIM_Try, /*On fail goto*//*Label 292*/ 5042, // Rule ID 1837 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
        // (bitconvert:{ *:[v2i16] } FGR32:{ *:[f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i16] } FGR32:{ *:[f32] }:$src, DSPR:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DSPR*/7,
        // GIR_Coverage, 1837,
        GIR_Done,
      // Label 292: @5042
      GIM_Reject,
    // Label 290: @5043
    GIM_Reject,
    // Label 271: @5044
    GIM_Try, /*On fail goto*//*Label 293*/ 5065, // Rule ID 1918 //
      GIM_CheckFeatures, GIFBS_HasMSA,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/75,
      // GIR_Coverage, 1918,
      GIR_Done,
    // Label 293: @5065
    GIM_Try, /*On fail goto*//*Label 294*/ 5086, // Rule ID 1921 //
      GIM_CheckFeatures, GIFBS_HasMSA,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2f64] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v2i64:{ *:[v2i64] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/75,
      // GIR_Coverage, 1921,
      GIR_Done,
    // Label 294: @5086
    GIM_Try, /*On fail goto*//*Label 295*/ 5107, // Rule ID 1938 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/75,
      // GIR_Coverage, 1938,
      GIR_Done,
    // Label 295: @5107
    GIM_Try, /*On fail goto*//*Label 296*/ 5128, // Rule ID 1939 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/75,
      // GIR_Coverage, 1939,
      GIR_Done,
    // Label 296: @5128
    GIM_Try, /*On fail goto*//*Label 297*/ 5149, // Rule ID 1940 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/75,
      // GIR_Coverage, 1940,
      GIR_Done,
    // Label 297: @5149
    GIM_Try, /*On fail goto*//*Label 298*/ 5170, // Rule ID 1941 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2i64] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v8f16:{ *:[v8f16] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/75,
      // GIR_Coverage, 1941,
      GIR_Done,
    // Label 298: @5170
    GIM_Try, /*On fail goto*//*Label 299*/ 5191, // Rule ID 1942 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2i64] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v4f32:{ *:[v4f32] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/75,
      // GIR_Coverage, 1942,
      GIR_Done,
    // Label 299: @5191
    GIM_Try, /*On fail goto*//*Label 300*/ 5212, // Rule ID 1948 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2f64] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v16i8:{ *:[v16i8] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/75,
      // GIR_Coverage, 1948,
      GIR_Done,
    // Label 300: @5212
    GIM_Try, /*On fail goto*//*Label 301*/ 5233, // Rule ID 1949 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2f64] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v8i16:{ *:[v8i16] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/75,
      // GIR_Coverage, 1949,
      GIR_Done,
    // Label 301: @5233
    GIM_Try, /*On fail goto*//*Label 302*/ 5254, // Rule ID 1950 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2f64] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v4i32:{ *:[v4i32] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/75,
      // GIR_Coverage, 1950,
      GIR_Done,
    // Label 302: @5254
    GIM_Try, /*On fail goto*//*Label 303*/ 5275, // Rule ID 1951 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2f64] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v8f16:{ *:[v8f16] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/75,
      // GIR_Coverage, 1951,
      GIR_Done,
    // Label 303: @5275
    GIM_Try, /*On fail goto*//*Label 304*/ 5296, // Rule ID 1952 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2f64] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v4f32:{ *:[v4f32] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/75,
      // GIR_Coverage, 1952,
      GIR_Done,
    // Label 304: @5296
    GIM_Try, /*On fail goto*//*Label 305*/ 5396, // Rule ID 1957 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/Mips::SHF_B,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/3, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_W,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/75,
      // GIR_Coverage, 1957,
      GIR_Done,
    // Label 305: @5396
    GIM_Try, /*On fail goto*//*Label 306*/ 5496, // Rule ID 1958 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2f64] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/Mips::SHF_B,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/3, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_W,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/75,
      // GIR_Coverage, 1958,
      GIR_Done,
    // Label 306: @5496
    GIM_Try, /*On fail goto*//*Label 307*/ 5561, // Rule ID 1962 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/75,
      // GIR_Coverage, 1962,
      GIR_Done,
    // Label 307: @5561
    GIM_Try, /*On fail goto*//*Label 308*/ 5626, // Rule ID 1963 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2f64] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/75,
      // GIR_Coverage, 1963,
      GIR_Done,
    // Label 308: @5626
    GIM_Try, /*On fail goto*//*Label 309*/ 5691, // Rule ID 1967 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2i64] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/75,
      // GIR_Coverage, 1967,
      GIR_Done,
    // Label 309: @5691
    GIM_Try, /*On fail goto*//*Label 310*/ 5756, // Rule ID 1968 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2f64] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/75,
      // GIR_Coverage, 1968,
      GIR_Done,
    // Label 310: @5756
    GIM_Try, /*On fail goto*//*Label 311*/ 5821, // Rule ID 1972 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_W,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/75,
      // GIR_Coverage, 1972,
      GIR_Done,
    // Label 311: @5821
    GIM_Try, /*On fail goto*//*Label 312*/ 5886, // Rule ID 1973 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2f64] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_W,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/75,
      // GIR_Coverage, 1973,
      GIR_Done,
    // Label 312: @5886
    GIM_Try, /*On fail goto*//*Label 313*/ 5951, // Rule ID 1977 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2i64] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_W,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/75,
      // GIR_Coverage, 1977,
      GIR_Done,
    // Label 313: @5951
    GIM_Try, /*On fail goto*//*Label 314*/ 6016, // Rule ID 1978 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2f64] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_W,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/75,
      // GIR_Coverage, 1978,
      GIR_Done,
    // Label 314: @6016
    GIM_Reject,
    // Label 272: @6017
    GIM_Try, /*On fail goto*//*Label 315*/ 6062,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 316*/ 6044, // Rule ID 1834 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        // (bitconvert:{ *:[v4i8] } GPR32:{ *:[i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i8] } GPR32:{ *:[i32] }:$src, DSPR:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DSPR*/7,
        // GIR_Coverage, 1834,
        GIR_Done,
      // Label 316: @6044
      GIM_Try, /*On fail goto*//*Label 317*/ 6061, // Rule ID 1838 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
        // (bitconvert:{ *:[v4i8] } FGR32:{ *:[f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i8] } FGR32:{ *:[f32] }:$src, DSPR:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DSPR*/7,
        // GIR_Coverage, 1838,
        GIR_Done,
      // Label 317: @6061
      GIM_Reject,
    // Label 315: @6062
    GIM_Reject,
    // Label 273: @6063
    GIM_Try, /*On fail goto*//*Label 318*/ 6084, // Rule ID 1917 //
      GIM_CheckFeatures, GIFBS_HasMSA,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/77,
      // GIR_Coverage, 1917,
      GIR_Done,
    // Label 318: @6084
    GIM_Try, /*On fail goto*//*Label 319*/ 6105, // Rule ID 1920 //
      GIM_CheckFeatures, GIFBS_HasMSA,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4f32] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v4i32:{ *:[v4i32] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/77,
      // GIR_Coverage, 1920,
      GIR_Done,
    // Label 319: @6105
    GIM_Try, /*On fail goto*//*Label 320*/ 6126, // Rule ID 1933 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/77,
      // GIR_Coverage, 1933,
      GIR_Done,
    // Label 320: @6126
    GIM_Try, /*On fail goto*//*Label 321*/ 6147, // Rule ID 1934 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/77,
      // GIR_Coverage, 1934,
      GIR_Done,
    // Label 321: @6147
    GIM_Try, /*On fail goto*//*Label 322*/ 6168, // Rule ID 1935 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/77,
      // GIR_Coverage, 1935,
      GIR_Done,
    // Label 322: @6168
    GIM_Try, /*On fail goto*//*Label 323*/ 6189, // Rule ID 1936 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4i32] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v8f16:{ *:[v8f16] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/77,
      // GIR_Coverage, 1936,
      GIR_Done,
    // Label 323: @6189
    GIM_Try, /*On fail goto*//*Label 324*/ 6210, // Rule ID 1937 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/77,
      // GIR_Coverage, 1937,
      GIR_Done,
    // Label 324: @6210
    GIM_Try, /*On fail goto*//*Label 325*/ 6231, // Rule ID 1943 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4f32] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v16i8:{ *:[v16i8] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/77,
      // GIR_Coverage, 1943,
      GIR_Done,
    // Label 325: @6231
    GIM_Try, /*On fail goto*//*Label 326*/ 6252, // Rule ID 1944 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4f32] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v8i16:{ *:[v8i16] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/77,
      // GIR_Coverage, 1944,
      GIR_Done,
    // Label 326: @6252
    GIM_Try, /*On fail goto*//*Label 327*/ 6273, // Rule ID 1945 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4f32] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v2i64:{ *:[v2i64] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/77,
      // GIR_Coverage, 1945,
      GIR_Done,
    // Label 327: @6273
    GIM_Try, /*On fail goto*//*Label 328*/ 6294, // Rule ID 1946 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4f32] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v8f16:{ *:[v8f16] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/77,
      // GIR_Coverage, 1946,
      GIR_Done,
    // Label 328: @6294
    GIM_Try, /*On fail goto*//*Label 329*/ 6315, // Rule ID 1947 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4f32] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v2f64:{ *:[v2f64] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/77,
      // GIR_Coverage, 1947,
      GIR_Done,
    // Label 329: @6315
    GIM_Try, /*On fail goto*//*Label 330*/ 6380, // Rule ID 1955 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_B,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/77,
      // GIR_Coverage, 1955,
      GIR_Done,
    // Label 330: @6380
    GIM_Try, /*On fail goto*//*Label 331*/ 6445, // Rule ID 1956 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4f32] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_B,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/77,
      // GIR_Coverage, 1956,
      GIR_Done,
    // Label 331: @6445
    GIM_Try, /*On fail goto*//*Label 332*/ 6510, // Rule ID 1960 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/77,
      // GIR_Coverage, 1960,
      GIR_Done,
    // Label 332: @6510
    GIM_Try, /*On fail goto*//*Label 333*/ 6575, // Rule ID 1961 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4f32] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/77,
      // GIR_Coverage, 1961,
      GIR_Done,
    // Label 333: @6575
    GIM_Try, /*On fail goto*//*Label 334*/ 6640, // Rule ID 1965 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4i32] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/77,
      // GIR_Coverage, 1965,
      GIR_Done,
    // Label 334: @6640
    GIM_Try, /*On fail goto*//*Label 335*/ 6705, // Rule ID 1966 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4f32] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/77,
      // GIR_Coverage, 1966,
      GIR_Done,
    // Label 335: @6705
    GIM_Try, /*On fail goto*//*Label 336*/ 6770, // Rule ID 1982 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_W,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/77,
      // GIR_Coverage, 1982,
      GIR_Done,
    // Label 336: @6770
    GIM_Try, /*On fail goto*//*Label 337*/ 6835, // Rule ID 1983 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4f32] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_W,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/77,
      // GIR_Coverage, 1983,
      GIR_Done,
    // Label 337: @6835
    GIM_Try, /*On fail goto*//*Label 338*/ 6900, // Rule ID 1987 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_W,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/77,
      // GIR_Coverage, 1987,
      GIR_Done,
    // Label 338: @6900
    GIM_Try, /*On fail goto*//*Label 339*/ 6965, // Rule ID 1988 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4f32] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_W,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/77,
      // GIR_Coverage, 1988,
      GIR_Done,
    // Label 339: @6965
    GIM_Reject,
    // Label 274: @6966
    GIM_Try, /*On fail goto*//*Label 340*/ 6987, // Rule ID 1916 //
      GIM_CheckFeatures, GIFBS_HasMSA,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/76,
      // GIR_Coverage, 1916,
      GIR_Done,
    // Label 340: @6987
    GIM_Try, /*On fail goto*//*Label 341*/ 7008, // Rule ID 1919 //
      GIM_CheckFeatures, GIFBS_HasMSA,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8f16] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } v8i16:{ *:[v8i16] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/76,
      // GIR_Coverage, 1919,
      GIR_Done,
    // Label 341: @7008
    GIM_Try, /*On fail goto*//*Label 342*/ 7029, // Rule ID 1928 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/76,
      // GIR_Coverage, 1928,
      GIR_Done,
    // Label 342: @7029
    GIM_Try, /*On fail goto*//*Label 343*/ 7050, // Rule ID 1929 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/76,
      // GIR_Coverage, 1929,
      GIR_Done,
    // Label 343: @7050
    GIM_Try, /*On fail goto*//*Label 344*/ 7071, // Rule ID 1930 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/76,
      // GIR_Coverage, 1930,
      GIR_Done,
    // Label 344: @7071
    GIM_Try, /*On fail goto*//*Label 345*/ 7092, // Rule ID 1931 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8i16] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v4f32:{ *:[v4f32] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/76,
      // GIR_Coverage, 1931,
      GIR_Done,
    // Label 345: @7092
    GIM_Try, /*On fail goto*//*Label 346*/ 7113, // Rule ID 1932 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/76,
      // GIR_Coverage, 1932,
      GIR_Done,
    // Label 346: @7113
    GIM_Try, /*On fail goto*//*Label 347*/ 7178, // Rule ID 1953 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_B,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/76,
      // GIR_Coverage, 1953,
      GIR_Done,
    // Label 347: @7178
    GIM_Try, /*On fail goto*//*Label 348*/ 7243, // Rule ID 1954 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8f16] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_B,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/76,
      // GIR_Coverage, 1954,
      GIR_Done,
    // Label 348: @7243
    GIM_Try, /*On fail goto*//*Label 349*/ 7308, // Rule ID 1970 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/76,
      // GIR_Coverage, 1970,
      GIR_Done,
    // Label 349: @7308
    GIM_Try, /*On fail goto*//*Label 350*/ 7373, // Rule ID 1971 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8f16] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/76,
      // GIR_Coverage, 1971,
      GIR_Done,
    // Label 350: @7373
    GIM_Try, /*On fail goto*//*Label 351*/ 7438, // Rule ID 1975 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8i16] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v4f32:{ *:[v4f32] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/76,
      // GIR_Coverage, 1975,
      GIR_Done,
    // Label 351: @7438
    GIM_Try, /*On fail goto*//*Label 352*/ 7503, // Rule ID 1976 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8f16] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v4f32:{ *:[v4f32] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/76,
      // GIR_Coverage, 1976,
      GIR_Done,
    // Label 352: @7503
    GIM_Try, /*On fail goto*//*Label 353*/ 7568, // Rule ID 1980 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/76,
      // GIR_Coverage, 1980,
      GIR_Done,
    // Label 353: @7568
    GIM_Try, /*On fail goto*//*Label 354*/ 7633, // Rule ID 1981 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8f16] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/76,
      // GIR_Coverage, 1981,
      GIR_Done,
    // Label 354: @7633
    GIM_Try, /*On fail goto*//*Label 355*/ 7698, // Rule ID 1985 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/76,
      // GIR_Coverage, 1985,
      GIR_Done,
    // Label 355: @7698
    GIM_Try, /*On fail goto*//*Label 356*/ 7763, // Rule ID 1986 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8f16] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/76,
      // GIR_Coverage, 1986,
      GIR_Done,
    // Label 356: @7763
    GIM_Reject,
    // Label 275: @7764
    GIM_Try, /*On fail goto*//*Label 357*/ 7785, // Rule ID 1922 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      // (bitconvert:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$src, MSA128B:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128B*/74,
      // GIR_Coverage, 1922,
      GIR_Done,
    // Label 357: @7785
    GIM_Try, /*On fail goto*//*Label 358*/ 7806, // Rule ID 1923 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      // (bitconvert:{ *:[v16i8] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v4i32:{ *:[v4i32] }:$src, MSA128B:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128B*/74,
      // GIR_Coverage, 1923,
      GIR_Done,
    // Label 358: @7806
    GIM_Try, /*On fail goto*//*Label 359*/ 7827, // Rule ID 1924 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      // (bitconvert:{ *:[v16i8] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v2i64:{ *:[v2i64] }:$src, MSA128B:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128B*/74,
      // GIR_Coverage, 1924,
      GIR_Done,
    // Label 359: @7827
    GIM_Try, /*On fail goto*//*Label 360*/ 7848, // Rule ID 1925 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      // (bitconvert:{ *:[v16i8] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v8f16:{ *:[v8f16] }:$src, MSA128B:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128B*/74,
      // GIR_Coverage, 1925,
      GIR_Done,
    // Label 360: @7848
    GIM_Try, /*On fail goto*//*Label 361*/ 7869, // Rule ID 1926 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      // (bitconvert:{ *:[v16i8] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v4f32:{ *:[v4f32] }:$src, MSA128B:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128B*/74,
      // GIR_Coverage, 1926,
      GIR_Done,
    // Label 361: @7869
    GIM_Try, /*On fail goto*//*Label 362*/ 7890, // Rule ID 1927 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      // (bitconvert:{ *:[v16i8] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v2f64:{ *:[v2f64] }:$src, MSA128B:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128B*/74,
      // GIR_Coverage, 1927,
      GIR_Done,
    // Label 362: @7890
    GIM_Try, /*On fail goto*//*Label 363*/ 7955, // Rule ID 1959 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      // (bitconvert:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$src, MSA128B:{ *:[i32] }), 177:{ *:[i32] }), MSA128B:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_B,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128B*/74,
      // GIR_Coverage, 1959,
      GIR_Done,
    // Label 363: @7955
    GIM_Try, /*On fail goto*//*Label 364*/ 8020, // Rule ID 1964 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      // (bitconvert:{ *:[v16i8] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v8f16:{ *:[v8f16] }:$src, MSA128B:{ *:[i32] }), 177:{ *:[i32] }), MSA128B:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_B,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128B*/74,
      // GIR_Coverage, 1964,
      GIR_Done,
    // Label 364: @8020
    GIM_Try, /*On fail goto*//*Label 365*/ 8085, // Rule ID 1969 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      // (bitconvert:{ *:[v16i8] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v4i32:{ *:[v4i32] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128B:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_B,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128B*/74,
      // GIR_Coverage, 1969,
      GIR_Done,
    // Label 365: @8085
    GIM_Try, /*On fail goto*//*Label 366*/ 8150, // Rule ID 1974 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      // (bitconvert:{ *:[v16i8] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v4f32:{ *:[v4f32] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128B:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_B,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128B*/74,
      // GIR_Coverage, 1974,
      GIR_Done,
    // Label 366: @8150
    GIM_Try, /*On fail goto*//*Label 367*/ 8250, // Rule ID 1979 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      // (bitconvert:{ *:[v16i8] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v2i64:{ *:[v2i64] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128B:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/Mips::SHF_B,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/3, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_W,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128B*/74,
      // GIR_Coverage, 1979,
      GIR_Done,
    // Label 367: @8250
    GIM_Try, /*On fail goto*//*Label 368*/ 8350, // Rule ID 1984 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      // (bitconvert:{ *:[v16i8] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v2f64:{ *:[v2f64] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128B:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/Mips::SHF_B,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/3, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_W,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128B*/74,
      // GIR_Coverage, 1984,
      GIR_Done,
    // Label 368: @8350
    GIM_Reject,
    // Label 276: @8351
    GIM_Reject,
    // Label 11: @8352
    GIM_Try, /*On fail goto*//*Label 369*/ 8417, // Rule ID 1907 //
      GIM_CheckFeatures, GIFBS_HasDSP,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      // MIs[0] Operand 1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ADD,
      GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (ld:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LWX:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::LWX,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // base
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // index
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1907,
      GIR_Done,
    // Label 369: @8417
    GIM_Reject,
    // Label 12: @8418
    GIM_Try, /*On fail goto*//*Label 370*/ 8483, // Rule ID 1906 //
      GIM_CheckFeatures, GIFBS_HasDSP,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      // MIs[0] Operand 1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ADD,
      GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (ld:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi16>>  =>  (LHX:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::LHX,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // base
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // index
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1906,
      GIR_Done,
    // Label 370: @8483
    GIM_Reject,
    // Label 13: @8484
    GIM_Try, /*On fail goto*//*Label 371*/ 8549, // Rule ID 1905 //
      GIM_CheckFeatures, GIFBS_HasDSP,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      // MIs[0] Operand 1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ADD,
      GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (ld:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index))<<P:Predicate_unindexedload>><<P:Predicate_zextload>><<P:Predicate_zextloadi8>>  =>  (LBUX:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::LBUX,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // base
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // index
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1905,
      GIR_Done,
    // Label 371: @8549
    GIM_Reject,
    // Label 14: @8550
    GIM_Try, /*On fail goto*//*Label 372*/ 10744,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_Try, /*On fail goto*//*Label 373*/ 8602, // Rule ID 400 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_repl_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt8,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3616:{ *:[iPTR] }, (imm:{ *:[i32] })<<P:Predicate_immZExt8>>:$imm)  =>  (REPL_QB:{ *:[v4i8] } (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::REPL_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 400,
        GIR_Done,
      // Label 373: @8602
      GIM_Try, /*On fail goto*//*Label 374*/ 8649, // Rule ID 401 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_repl_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immSExt10,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3615:{ *:[iPTR] }, (imm:{ *:[i32] })<<P:Predicate_immSExt10>>:$imm)  =>  (REPL_PH:{ *:[v2i16] } (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::REPL_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 401,
        GIR_Done,
      // Label 374: @8649
      GIM_Try, /*On fail goto*//*Label 375*/ 8696, // Rule ID 1254 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_repl_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immSExt10,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3615:{ *:[iPTR] }, (imm:{ *:[i32] })<<P:Predicate_immSExt10>>:$imm)  =>  (REPL_PH_MM:{ *:[v2i16] } (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::REPL_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1254,
        GIR_Done,
      // Label 375: @8696
      GIM_Try, /*On fail goto*//*Label 376*/ 8743, // Rule ID 1255 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_repl_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt8,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3616:{ *:[iPTR] }, (imm:{ *:[i32] })<<P:Predicate_immZExt8>>:$imm)  =>  (REPL_QB_MM:{ *:[v4i8] } (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::REPL_QB_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1255,
        GIR_Done,
      // Label 376: @8743
      GIM_Try, /*On fail goto*//*Label 377*/ 8783, // Rule ID 334 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_raddu_w_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 3613:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (RADDU_W_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::RADDU_W_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 334,
        GIR_Done,
      // Label 377: @8783
      GIM_Try, /*On fail goto*//*Label 378*/ 8823, // Rule ID 341 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_preceq_w_phl,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 3595:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECEQ_W_PHL:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEQ_W_PHL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 341,
        GIR_Done,
      // Label 378: @8823
      GIM_Try, /*On fail goto*//*Label 379*/ 8863, // Rule ID 342 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_preceq_w_phr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 3596:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECEQ_W_PHR:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEQ_W_PHR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 342,
        GIR_Done,
      // Label 379: @8863
      GIM_Try, /*On fail goto*//*Label 380*/ 8903, // Rule ID 343 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precequ_ph_qbl,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3597:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEQU_PH_QBL:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEQU_PH_QBL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 343,
        GIR_Done,
      // Label 380: @8903
      GIM_Try, /*On fail goto*//*Label 381*/ 8943, // Rule ID 344 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precequ_ph_qbr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3599:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEQU_PH_QBR:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEQU_PH_QBR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 344,
        GIR_Done,
      // Label 381: @8943
      GIM_Try, /*On fail goto*//*Label 382*/ 8983, // Rule ID 345 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precequ_ph_qbla,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3598:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEQU_PH_QBLA:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEQU_PH_QBLA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 345,
        GIR_Done,
      // Label 382: @8983
      GIM_Try, /*On fail goto*//*Label 383*/ 9023, // Rule ID 346 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precequ_ph_qbra,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3600:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEQU_PH_QBRA:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEQU_PH_QBRA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 346,
        GIR_Done,
      // Label 383: @9023
      GIM_Try, /*On fail goto*//*Label 384*/ 9063, // Rule ID 347 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_preceu_ph_qbl,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3601:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEU_PH_QBL:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEU_PH_QBL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 347,
        GIR_Done,
      // Label 384: @9063
      GIM_Try, /*On fail goto*//*Label 385*/ 9103, // Rule ID 348 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_preceu_ph_qbr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3603:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEU_PH_QBR:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEU_PH_QBR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 348,
        GIR_Done,
      // Label 385: @9103
      GIM_Try, /*On fail goto*//*Label 386*/ 9143, // Rule ID 349 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_preceu_ph_qbla,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3602:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEU_PH_QBLA:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEU_PH_QBLA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 349,
        GIR_Done,
      // Label 386: @9143
      GIM_Try, /*On fail goto*//*Label 387*/ 9183, // Rule ID 350 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_preceu_ph_qbra,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3604:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEU_PH_QBRA:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEU_PH_QBRA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 350,
        GIR_Done,
      // Label 387: @9183
      GIM_Try, /*On fail goto*//*Label 388*/ 9223, // Rule ID 398 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_bitrev,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 3171:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt)  =>  (BITREV:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::BITREV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 398,
        GIR_Done,
      // Label 388: @9223
      GIM_Try, /*On fail goto*//*Label 389*/ 9263, // Rule ID 402 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_repl_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3616:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt)  =>  (REPLV_QB:{ *:[v4i8] } GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::REPLV_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 402,
        GIR_Done,
      // Label 389: @9263
      GIM_Try, /*On fail goto*//*Label 390*/ 9303, // Rule ID 403 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_repl_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3615:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt)  =>  (REPLV_PH:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::REPLV_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 403,
        GIR_Done,
      // Label 390: @9303
      GIM_Try, /*On fail goto*//*Label 391*/ 9343, // Rule ID 648 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fclass_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3323:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FCLASS_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FCLASS_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 648,
        GIR_Done,
      // Label 391: @9343
      GIM_Try, /*On fail goto*//*Label 392*/ 9383, // Rule ID 649 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fclass_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3322:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FCLASS_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FCLASS_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 649,
        GIR_Done,
      // Label 392: @9383
      GIM_Try, /*On fail goto*//*Label 393*/ 9423, // Rule ID 672 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fexupl_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 3349:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8f16] }:$ws)  =>  (FEXUPL_W:{ *:[v4f32] } MSA128HOpnd:{ *:[v8f16] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FEXUPL_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 672,
        GIR_Done,
      // Label 393: @9423
      GIM_Try, /*On fail goto*//*Label 394*/ 9463, // Rule ID 673 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fexupl_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 3348:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FEXUPL_D:{ *:[v2f64] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FEXUPL_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 673,
        GIR_Done,
      // Label 394: @9463
      GIM_Try, /*On fail goto*//*Label 395*/ 9503, // Rule ID 674 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fexupr_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 3351:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8f16] }:$ws)  =>  (FEXUPR_W:{ *:[v4f32] } MSA128HOpnd:{ *:[v8f16] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FEXUPR_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 674,
        GIR_Done,
      // Label 395: @9503
      GIM_Try, /*On fail goto*//*Label 396*/ 9543, // Rule ID 675 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fexupr_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 3350:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FEXUPR_D:{ *:[v2f64] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FEXUPR_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 675,
        GIR_Done,
      // Label 396: @9543
      GIM_Try, /*On fail goto*//*Label 397*/ 9583, // Rule ID 680 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ffql_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 3357:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws)  =>  (FFQL_W:{ *:[v4f32] } MSA128HOpnd:{ *:[v8i16] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FFQL_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 680,
        GIR_Done,
      // Label 397: @9583
      GIM_Try, /*On fail goto*//*Label 398*/ 9623, // Rule ID 681 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ffql_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 3356:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws)  =>  (FFQL_D:{ *:[v2f64] } MSA128WOpnd:{ *:[v4i32] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FFQL_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 681,
        GIR_Done,
      // Label 398: @9623
      GIM_Try, /*On fail goto*//*Label 399*/ 9663, // Rule ID 682 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ffqr_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 3359:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws)  =>  (FFQR_W:{ *:[v4f32] } MSA128HOpnd:{ *:[v8i16] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FFQR_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 682,
        GIR_Done,
      // Label 399: @9663
      GIM_Try, /*On fail goto*//*Label 400*/ 9703, // Rule ID 683 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ffqr_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 3358:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws)  =>  (FFQR_D:{ *:[v2f64] } MSA128WOpnd:{ *:[v4i32] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FFQR_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 683,
        GIR_Done,
      // Label 400: @9703
      GIM_Try, /*On fail goto*//*Label 401*/ 9743, // Rule ID 708 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_frcp_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 3381:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FRCP_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FRCP_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 708,
        GIR_Done,
      // Label 401: @9743
      GIM_Try, /*On fail goto*//*Label 402*/ 9783, // Rule ID 709 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_frcp_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 3380:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FRCP_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FRCP_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 709,
        GIR_Done,
      // Label 402: @9783
      GIM_Try, /*On fail goto*//*Label 403*/ 9823, // Rule ID 710 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_frsqrt_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 3385:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FRSQRT_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FRSQRT_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 710,
        GIR_Done,
      // Label 403: @9823
      GIM_Try, /*On fail goto*//*Label 404*/ 9863, // Rule ID 711 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_frsqrt_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 3384:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FRSQRT_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FRSQRT_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 711,
        GIR_Done,
      // Label 404: @9863
      GIM_Try, /*On fail goto*//*Label 405*/ 9903, // Rule ID 738 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ftint_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3413:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FTINT_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FTINT_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 738,
        GIR_Done,
      // Label 405: @9903
      GIM_Try, /*On fail goto*//*Label 406*/ 9943, // Rule ID 739 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ftint_s_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3412:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FTINT_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FTINT_S_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 739,
        GIR_Done,
      // Label 406: @9943
      GIM_Try, /*On fail goto*//*Label 407*/ 9983, // Rule ID 740 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ftint_u_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3415:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FTINT_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FTINT_U_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 740,
        GIR_Done,
      // Label 407: @9983
      GIM_Try, /*On fail goto*//*Label 408*/ 10023, // Rule ID 741 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ftint_u_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3414:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FTINT_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FTINT_U_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 741,
        GIR_Done,
      // Label 408: @10023
      GIM_Try, /*On fail goto*//*Label 409*/ 10063, // Rule ID 876 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_nloc_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3568:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws)  =>  (NLOC_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NLOC_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 876,
        GIR_Done,
      // Label 409: @10063
      GIM_Try, /*On fail goto*//*Label 410*/ 10103, // Rule ID 877 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_nloc_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3570:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws)  =>  (NLOC_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NLOC_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 877,
        GIR_Done,
      // Label 410: @10103
      GIM_Try, /*On fail goto*//*Label 411*/ 10143, // Rule ID 878 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_nloc_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3571:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws)  =>  (NLOC_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NLOC_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 878,
        GIR_Done,
      // Label 411: @10143
      GIM_Try, /*On fail goto*//*Label 412*/ 10183, // Rule ID 879 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_nloc_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3569:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws)  =>  (NLOC_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NLOC_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 879,
        GIR_Done,
      // Label 412: @10183
      GIM_Try, /*On fail goto*//*Label 413*/ 10223, // Rule ID 1217 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_preceq_w_phl,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 3595:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs)  =>  (PRECEQ_W_PHL_MM:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEQ_W_PHL_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1217,
        GIR_Done,
      // Label 413: @10223
      GIM_Try, /*On fail goto*//*Label 414*/ 10263, // Rule ID 1218 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_preceq_w_phr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 3596:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs)  =>  (PRECEQ_W_PHR_MM:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEQ_W_PHR_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1218,
        GIR_Done,
      // Label 414: @10263
      GIM_Try, /*On fail goto*//*Label 415*/ 10303, // Rule ID 1219 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precequ_ph_qbl,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3597:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEQU_PH_QBL_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEQU_PH_QBL_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1219,
        GIR_Done,
      // Label 415: @10303
      GIM_Try, /*On fail goto*//*Label 416*/ 10343, // Rule ID 1220 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precequ_ph_qbla,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3598:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEQU_PH_QBLA_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEQU_PH_QBLA_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1220,
        GIR_Done,
      // Label 416: @10343
      GIM_Try, /*On fail goto*//*Label 417*/ 10383, // Rule ID 1221 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precequ_ph_qbr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3599:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEQU_PH_QBR_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEQU_PH_QBR_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1221,
        GIR_Done,
      // Label 417: @10383
      GIM_Try, /*On fail goto*//*Label 418*/ 10423, // Rule ID 1222 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precequ_ph_qbra,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3600:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEQU_PH_QBRA_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEQU_PH_QBRA_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1222,
        GIR_Done,
      // Label 418: @10423
      GIM_Try, /*On fail goto*//*Label 419*/ 10463, // Rule ID 1223 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_preceu_ph_qbl,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3601:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEU_PH_QBL_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEU_PH_QBL_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1223,
        GIR_Done,
      // Label 419: @10463
      GIM_Try, /*On fail goto*//*Label 420*/ 10503, // Rule ID 1224 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_preceu_ph_qbla,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3602:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEU_PH_QBLA_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEU_PH_QBLA_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1224,
        GIR_Done,
      // Label 420: @10503
      GIM_Try, /*On fail goto*//*Label 421*/ 10543, // Rule ID 1225 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_preceu_ph_qbr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3603:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEU_PH_QBR_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEU_PH_QBR_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1225,
        GIR_Done,
      // Label 421: @10543
      GIM_Try, /*On fail goto*//*Label 422*/ 10583, // Rule ID 1226 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_preceu_ph_qbra,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3604:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEU_PH_QBRA_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEU_PH_QBRA_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1226,
        GIR_Done,
      // Label 422: @10583
      GIM_Try, /*On fail goto*//*Label 423*/ 10623, // Rule ID 1252 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_raddu_w_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 3613:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (RADDU_W_QB_MM:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::RADDU_W_QB_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1252,
        GIR_Done,
      // Label 423: @10623
      GIM_Try, /*On fail goto*//*Label 424*/ 10663, // Rule ID 1256 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_repl_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3615:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs)  =>  (REPLV_PH_MM:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::REPLV_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1256,
        GIR_Done,
      // Label 424: @10663
      GIM_Try, /*On fail goto*//*Label 425*/ 10703, // Rule ID 1257 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_repl_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3616:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs)  =>  (REPLV_QB_MM:{ *:[v4i8] } GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::REPLV_QB_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1257,
        GIR_Done,
      // Label 425: @10703
      GIM_Try, /*On fail goto*//*Label 426*/ 10743, // Rule ID 1267 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_bitrev,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 3171:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs)  =>  (BITREV_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::BITREV_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1267,
        GIR_Done,
      // Label 426: @10743
      GIM_Reject,
    // Label 372: @10744
    GIM_Try, /*On fail goto*//*Label 427*/ 22012,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
      GIM_Try, /*On fail goto*//*Label 428*/ 10808, // Rule ID 357 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_r_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt4,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3635:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$rs_sa)  =>  (SHRA_R_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, (imm:{ *:[i32] }):$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRA_R_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // rs_sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 357,
        GIR_Done,
      // Label 428: @10808
      GIM_Try, /*On fail goto*//*Label 429*/ 10867, // Rule ID 361 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_r_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 3637:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$rs_sa)  =>  (SHRA_R_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] }):$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRA_R_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // rs_sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 361,
        GIR_Done,
      // Label 429: @10867
      GIM_Try, /*On fail goto*//*Label 430*/ 10926, // Rule ID 452 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_r_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt3,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3636:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$rs_sa)  =>  (SHRA_R_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, (imm:{ *:[i32] }):$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRA_R_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // rs_sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 452,
        GIR_Done,
      // Label 430: @10926
      GIM_Try, /*On fail goto*//*Label 431*/ 10985, // Rule ID 906 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_sat_s_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt3,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3617:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$m)  =>  (SAT_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, (imm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SAT_S_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // m
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 906,
        GIR_Done,
      // Label 431: @10985
      GIM_Try, /*On fail goto*//*Label 432*/ 11044, // Rule ID 907 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_sat_s_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt4,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3619:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$m)  =>  (SAT_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, (imm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SAT_S_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // m
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 907,
        GIR_Done,
      // Label 432: @11044
      GIM_Try, /*On fail goto*//*Label 433*/ 11103, // Rule ID 908 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_sat_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3620:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$m)  =>  (SAT_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, (imm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SAT_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // m
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 908,
        GIR_Done,
      // Label 433: @11103
      GIM_Try, /*On fail goto*//*Label 434*/ 11162, // Rule ID 909 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_sat_s_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt6,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3618:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, (imm:{ *:[i32] })<<P:Predicate_immZExt6>>:$m)  =>  (SAT_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, (imm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SAT_S_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // m
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 909,
        GIR_Done,
      // Label 434: @11162
      GIM_Try, /*On fail goto*//*Label 435*/ 11221, // Rule ID 910 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_sat_u_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt3,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3621:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$m)  =>  (SAT_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, (imm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SAT_U_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // m
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 910,
        GIR_Done,
      // Label 435: @11221
      GIM_Try, /*On fail goto*//*Label 436*/ 11280, // Rule ID 911 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_sat_u_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt4,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3623:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$m)  =>  (SAT_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, (imm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SAT_U_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // m
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 911,
        GIR_Done,
      // Label 436: @11280
      GIM_Try, /*On fail goto*//*Label 437*/ 11339, // Rule ID 912 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_sat_u_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3624:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$m)  =>  (SAT_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, (imm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SAT_U_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // m
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 912,
        GIR_Done,
      // Label 437: @11339
      GIM_Try, /*On fail goto*//*Label 438*/ 11398, // Rule ID 913 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_sat_u_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt6,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3622:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, (imm:{ *:[i32] })<<P:Predicate_immZExt6>>:$m)  =>  (SAT_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, (imm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SAT_U_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // m
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 913,
        GIR_Done,
      // Label 438: @11398
      GIM_Try, /*On fail goto*//*Label 439*/ 11457, // Rule ID 953 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_srari_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt3,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3676:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$m)  =>  (SRARI_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, (imm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRARI_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // m
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 953,
        GIR_Done,
      // Label 439: @11457
      GIM_Try, /*On fail goto*//*Label 440*/ 11516, // Rule ID 954 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_srari_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt4,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3678:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$m)  =>  (SRARI_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, (imm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRARI_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // m
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 954,
        GIR_Done,
      // Label 440: @11516
      GIM_Try, /*On fail goto*//*Label 441*/ 11575, // Rule ID 955 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_srari_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3679:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$m)  =>  (SRARI_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, (imm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRARI_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // m
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 955,
        GIR_Done,
      // Label 441: @11575
      GIM_Try, /*On fail goto*//*Label 442*/ 11634, // Rule ID 956 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_srari_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt6,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3677:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, (imm:{ *:[i32] })<<P:Predicate_immZExt6>>:$m)  =>  (SRARI_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, (imm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRARI_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // m
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 956,
        GIR_Done,
      // Label 442: @11634
      GIM_Try, /*On fail goto*//*Label 443*/ 11693, // Rule ID 969 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_srlri_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt3,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3692:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$m)  =>  (SRLRI_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, (imm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRLRI_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // m
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 969,
        GIR_Done,
      // Label 443: @11693
      GIM_Try, /*On fail goto*//*Label 444*/ 11752, // Rule ID 970 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_srlri_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt4,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3694:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$m)  =>  (SRLRI_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, (imm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRLRI_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // m
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 970,
        GIR_Done,
      // Label 444: @11752
      GIM_Try, /*On fail goto*//*Label 445*/ 11811, // Rule ID 971 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_srlri_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3695:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$m)  =>  (SRLRI_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, (imm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRLRI_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // m
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 971,
        GIR_Done,
      // Label 445: @11811
      GIM_Try, /*On fail goto*//*Label 446*/ 11870, // Rule ID 972 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_srlri_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt6,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3693:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, (imm:{ *:[i32] })<<P:Predicate_immZExt6>>:$m)  =>  (SRLRI_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, (imm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRLRI_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // m
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 972,
        GIR_Done,
      // Label 446: @11870
      GIM_Try, /*On fail goto*//*Label 447*/ 11929, // Rule ID 1211 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_r_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt4,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3635:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$sa)  =>  (SHRA_R_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, (imm:{ *:[i32] }):$sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRA_R_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1211,
        GIR_Done,
      // Label 447: @11929
      GIM_Try, /*On fail goto*//*Label 448*/ 11988, // Rule ID 1215 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_r_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 3637:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$sa)  =>  (SHRA_R_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRA_R_W_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1215,
        GIR_Done,
      // Label 448: @11988
      GIM_Try, /*On fail goto*//*Label 449*/ 12047, // Rule ID 1290 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_r_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt3,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3636:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$sa)  =>  (SHRA_R_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, (imm:{ *:[i32] }):$sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRA_R_QB_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1290,
        GIR_Done,
      // Label 449: @12047
      GIM_Try, /*On fail goto*//*Label 450*/ 12102, // Rule ID 1861 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt4,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3633:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)  =>  (SHRA_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRA_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1861,
        GIR_Done,
      // Label 450: @12102
      GIM_Try, /*On fail goto*//*Label 451*/ 12157, // Rule ID 1862 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shrl_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt4,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3638:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)  =>  (SHRL_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRL_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1862,
        GIR_Done,
      // Label 451: @12157
      GIM_Try, /*On fail goto*//*Label 452*/ 12212, // Rule ID 1867 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt3,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3634:{ *:[iPTR] }, v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)  =>  (SHRA_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRA_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1867,
        GIR_Done,
      // Label 452: @12212
      GIM_Try, /*On fail goto*//*Label 453*/ 12267, // Rule ID 1868 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shrl_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt3,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3639:{ *:[iPTR] }, v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)  =>  (SHRL_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRL_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1868,
        GIR_Done,
      // Label 453: @12267
      GIM_Try, /*On fail goto*//*Label 454*/ 12319, // Rule ID 327 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addu_s_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3107:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDU_S_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDU_S_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 327,
        GIR_Done,
      // Label 454: @12319
      GIM_Try, /*On fail goto*//*Label 455*/ 12371, // Rule ID 328 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subu_s_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3726:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBU_S_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBU_S_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 328,
        GIR_Done,
      // Label 455: @12371
      GIM_Try, /*On fail goto*//*Label 456*/ 12423, // Rule ID 329 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addq_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3085:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQ_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDQ_S_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 329,
        GIR_Done,
      // Label 456: @12423
      GIM_Try, /*On fail goto*//*Label 457*/ 12475, // Rule ID 330 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subq_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3701:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQ_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBQ_S_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 330,
        GIR_Done,
      // Label 457: @12475
      GIM_Try, /*On fail goto*//*Label 458*/ 12527, // Rule ID 333 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_modsub,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 3533:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MODSUB:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MODSUB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 333,
        GIR_Done,
      // Label 458: @12527
      GIM_Try, /*On fail goto*//*Label 459*/ 12579, // Rule ID 337 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precrq_qb_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3609:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECRQ_QB_PH:{ *:[v4i8] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECRQ_QB_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 337,
        GIR_Done,
      // Label 459: @12579
      GIM_Try, /*On fail goto*//*Label 460*/ 12631, // Rule ID 338 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precrq_ph_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3608:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (PRECRQ_PH_W:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECRQ_PH_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 338,
        GIR_Done,
      // Label 460: @12631
      GIM_Try, /*On fail goto*//*Label 461*/ 12683, // Rule ID 352 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shrl_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3639:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRLV_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRLV_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 352,
        GIR_Done,
      // Label 461: @12683
      GIM_Try, /*On fail goto*//*Label 462*/ 12735, // Rule ID 356 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3633:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRAV_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRAV_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 356,
        GIR_Done,
      // Label 462: @12735
      GIM_Try, /*On fail goto*//*Label 463*/ 12787, // Rule ID 358 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_r_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3635:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRAV_R_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRAV_R_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 358,
        GIR_Done,
      // Label 463: @12787
      GIM_Try, /*On fail goto*//*Label 464*/ 12839, // Rule ID 362 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_r_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 3637:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRAV_R_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRAV_R_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 362,
        GIR_Done,
      // Label 464: @12839
      GIM_Try, /*On fail goto*//*Label 465*/ 12891, // Rule ID 399 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_packrl_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3580:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PACKRL_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PACKRL_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 399,
        GIR_Done,
      // Label 465: @12891
      GIM_Try, /*On fail goto*//*Label 466*/ 12943, // Rule ID 423 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_adduh_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3108:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDUH_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDUH_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 423,
        GIR_Done,
      // Label 466: @12943
      GIM_Try, /*On fail goto*//*Label 467*/ 12995, // Rule ID 424 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_adduh_r_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3109:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDUH_R_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDUH_R_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 424,
        GIR_Done,
      // Label 467: @12995
      GIM_Try, /*On fail goto*//*Label 468*/ 13047, // Rule ID 425 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subuh_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3727:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBUH_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBUH_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 425,
        GIR_Done,
      // Label 468: @13047
      GIM_Try, /*On fail goto*//*Label 469*/ 13099, // Rule ID 426 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subuh_r_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3728:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBUH_R_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBUH_R_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 426,
        GIR_Done,
      // Label 469: @13099
      GIM_Try, /*On fail goto*//*Label 470*/ 13151, // Rule ID 427 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addqh_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3087:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQH_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDQH_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 427,
        GIR_Done,
      // Label 470: @13151
      GIM_Try, /*On fail goto*//*Label 471*/ 13203, // Rule ID 428 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addqh_r_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3088:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQH_R_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDQH_R_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 428,
        GIR_Done,
      // Label 471: @13203
      GIM_Try, /*On fail goto*//*Label 472*/ 13255, // Rule ID 429 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subqh_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3703:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQH_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBQH_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 429,
        GIR_Done,
      // Label 472: @13255
      GIM_Try, /*On fail goto*//*Label 473*/ 13307, // Rule ID 430 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subqh_r_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3704:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQH_R_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBQH_R_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 430,
        GIR_Done,
      // Label 473: @13307
      GIM_Try, /*On fail goto*//*Label 474*/ 13359, // Rule ID 431 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addqh_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 3090:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQH_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDQH_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 431,
        GIR_Done,
      // Label 474: @13359
      GIM_Try, /*On fail goto*//*Label 475*/ 13411, // Rule ID 432 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addqh_r_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 3089:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQH_R_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDQH_R_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 432,
        GIR_Done,
      // Label 475: @13411
      GIM_Try, /*On fail goto*//*Label 476*/ 13463, // Rule ID 433 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subqh_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 3706:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQH_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBQH_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 433,
        GIR_Done,
      // Label 476: @13463
      GIM_Try, /*On fail goto*//*Label 477*/ 13515, // Rule ID 434 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subqh_r_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 3705:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQH_R_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBQH_R_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 434,
        GIR_Done,
      // Label 477: @13515
      GIM_Try, /*On fail goto*//*Label 478*/ 13567, // Rule ID 451 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3634:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRAV_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRAV_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 451,
        GIR_Done,
      // Label 478: @13567
      GIM_Try, /*On fail goto*//*Label 479*/ 13619, // Rule ID 453 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_r_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3636:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRAV_R_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRAV_R_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 453,
        GIR_Done,
      // Label 479: @13619
      GIM_Try, /*On fail goto*//*Label 480*/ 13671, // Rule ID 454 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shrl_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3638:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRLV_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRLV_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 454,
        GIR_Done,
      // Label 480: @13671
      GIM_Try, /*On fail goto*//*Label 481*/ 13723, // Rule ID 459 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_add_a_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3080:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ADD_A_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADD_A_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 459,
        GIR_Done,
      // Label 481: @13723
      GIM_Try, /*On fail goto*//*Label 482*/ 13775, // Rule ID 460 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_add_a_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3082:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ADD_A_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADD_A_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 460,
        GIR_Done,
      // Label 482: @13775
      GIM_Try, /*On fail goto*//*Label 483*/ 13827, // Rule ID 461 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_add_a_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3083:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ADD_A_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADD_A_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 461,
        GIR_Done,
      // Label 483: @13827
      GIM_Try, /*On fail goto*//*Label 484*/ 13879, // Rule ID 462 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_add_a_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3081:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ADD_A_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADD_A_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 462,
        GIR_Done,
      // Label 484: @13879
      GIM_Try, /*On fail goto*//*Label 485*/ 13931, // Rule ID 463 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_adds_a_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3091:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ADDS_A_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDS_A_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 463,
        GIR_Done,
      // Label 485: @13931
      GIM_Try, /*On fail goto*//*Label 486*/ 13983, // Rule ID 464 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_adds_a_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3093:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ADDS_A_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDS_A_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 464,
        GIR_Done,
      // Label 486: @13983
      GIM_Try, /*On fail goto*//*Label 487*/ 14035, // Rule ID 465 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_adds_a_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3094:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ADDS_A_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDS_A_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 465,
        GIR_Done,
      // Label 487: @14035
      GIM_Try, /*On fail goto*//*Label 488*/ 14087, // Rule ID 466 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_adds_a_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3092:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ADDS_A_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDS_A_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 466,
        GIR_Done,
      // Label 488: @14087
      GIM_Try, /*On fail goto*//*Label 489*/ 14139, // Rule ID 467 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_adds_s_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3095:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ADDS_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDS_S_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 467,
        GIR_Done,
      // Label 489: @14139
      GIM_Try, /*On fail goto*//*Label 490*/ 14191, // Rule ID 468 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_adds_s_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3097:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ADDS_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDS_S_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 468,
        GIR_Done,
      // Label 490: @14191
      GIM_Try, /*On fail goto*//*Label 491*/ 14243, // Rule ID 469 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_adds_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3098:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ADDS_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDS_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 469,
        GIR_Done,
      // Label 491: @14243
      GIM_Try, /*On fail goto*//*Label 492*/ 14295, // Rule ID 470 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_adds_s_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3096:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ADDS_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDS_S_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 470,
        GIR_Done,
      // Label 492: @14295
      GIM_Try, /*On fail goto*//*Label 493*/ 14347, // Rule ID 471 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_adds_u_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3099:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ADDS_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDS_U_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 471,
        GIR_Done,
      // Label 493: @14347
      GIM_Try, /*On fail goto*//*Label 494*/ 14399, // Rule ID 472 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_adds_u_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3101:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ADDS_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDS_U_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 472,
        GIR_Done,
      // Label 494: @14399
      GIM_Try, /*On fail goto*//*Label 495*/ 14451, // Rule ID 473 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_adds_u_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3102:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ADDS_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDS_U_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 473,
        GIR_Done,
      // Label 495: @14451
      GIM_Try, /*On fail goto*//*Label 496*/ 14503, // Rule ID 474 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_adds_u_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3100:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ADDS_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDS_U_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 474,
        GIR_Done,
      // Label 496: @14503
      GIM_Try, /*On fail goto*//*Label 497*/ 14555, // Rule ID 488 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_asub_s_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3122:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ASUB_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ASUB_S_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 488,
        GIR_Done,
      // Label 497: @14555
      GIM_Try, /*On fail goto*//*Label 498*/ 14607, // Rule ID 489 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_asub_s_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3124:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ASUB_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ASUB_S_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 489,
        GIR_Done,
      // Label 498: @14607
      GIM_Try, /*On fail goto*//*Label 499*/ 14659, // Rule ID 490 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_asub_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3125:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ASUB_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ASUB_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 490,
        GIR_Done,
      // Label 499: @14659
      GIM_Try, /*On fail goto*//*Label 500*/ 14711, // Rule ID 491 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_asub_s_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3123:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ASUB_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ASUB_S_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 491,
        GIR_Done,
      // Label 500: @14711
      GIM_Try, /*On fail goto*//*Label 501*/ 14763, // Rule ID 492 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_asub_u_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3126:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ASUB_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ASUB_U_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 492,
        GIR_Done,
      // Label 501: @14763
      GIM_Try, /*On fail goto*//*Label 502*/ 14815, // Rule ID 493 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_asub_u_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3128:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ASUB_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ASUB_U_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 493,
        GIR_Done,
      // Label 502: @14815
      GIM_Try, /*On fail goto*//*Label 503*/ 14867, // Rule ID 494 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_asub_u_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3129:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ASUB_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ASUB_U_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 494,
        GIR_Done,
      // Label 503: @14867
      GIM_Try, /*On fail goto*//*Label 504*/ 14919, // Rule ID 495 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_asub_u_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3127:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ASUB_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ASUB_U_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 495,
        GIR_Done,
      // Label 504: @14919
      GIM_Try, /*On fail goto*//*Label 505*/ 14971, // Rule ID 496 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ave_s_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3130:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (AVE_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::AVE_S_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 496,
        GIR_Done,
      // Label 505: @14971
      GIM_Try, /*On fail goto*//*Label 506*/ 15023, // Rule ID 497 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ave_s_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3132:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (AVE_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::AVE_S_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 497,
        GIR_Done,
      // Label 506: @15023
      GIM_Try, /*On fail goto*//*Label 507*/ 15075, // Rule ID 498 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ave_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3133:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (AVE_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::AVE_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 498,
        GIR_Done,
      // Label 507: @15075
      GIM_Try, /*On fail goto*//*Label 508*/ 15127, // Rule ID 499 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ave_s_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3131:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (AVE_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::AVE_S_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 499,
        GIR_Done,
      // Label 508: @15127
      GIM_Try, /*On fail goto*//*Label 509*/ 15179, // Rule ID 500 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ave_u_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3134:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (AVE_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::AVE_U_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 500,
        GIR_Done,
      // Label 509: @15179
      GIM_Try, /*On fail goto*//*Label 510*/ 15231, // Rule ID 501 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ave_u_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3136:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (AVE_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::AVE_U_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 501,
        GIR_Done,
      // Label 510: @15231
      GIM_Try, /*On fail goto*//*Label 511*/ 15283, // Rule ID 502 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ave_u_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3137:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (AVE_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::AVE_U_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 502,
        GIR_Done,
      // Label 511: @15283
      GIM_Try, /*On fail goto*//*Label 512*/ 15335, // Rule ID 503 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ave_u_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3135:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (AVE_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::AVE_U_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 503,
        GIR_Done,
      // Label 512: @15335
      GIM_Try, /*On fail goto*//*Label 513*/ 15387, // Rule ID 504 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_aver_s_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3138:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (AVER_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::AVER_S_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 504,
        GIR_Done,
      // Label 513: @15387
      GIM_Try, /*On fail goto*//*Label 514*/ 15439, // Rule ID 505 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_aver_s_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3140:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (AVER_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::AVER_S_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 505,
        GIR_Done,
      // Label 514: @15439
      GIM_Try, /*On fail goto*//*Label 515*/ 15491, // Rule ID 506 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_aver_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3141:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (AVER_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::AVER_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 506,
        GIR_Done,
      // Label 515: @15491
      GIM_Try, /*On fail goto*//*Label 516*/ 15543, // Rule ID 507 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_aver_s_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3139:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (AVER_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::AVER_S_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 507,
        GIR_Done,
      // Label 516: @15543
      GIM_Try, /*On fail goto*//*Label 517*/ 15595, // Rule ID 508 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_aver_u_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3142:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (AVER_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::AVER_U_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 508,
        GIR_Done,
      // Label 517: @15595
      GIM_Try, /*On fail goto*//*Label 518*/ 15647, // Rule ID 509 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_aver_u_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3144:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (AVER_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::AVER_U_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 509,
        GIR_Done,
      // Label 518: @15647
      GIM_Try, /*On fail goto*//*Label 519*/ 15699, // Rule ID 510 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_aver_u_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3145:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (AVER_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::AVER_U_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 510,
        GIR_Done,
      // Label 519: @15699
      GIM_Try, /*On fail goto*//*Label 520*/ 15751, // Rule ID 511 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_aver_u_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3143:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (AVER_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::AVER_U_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 511,
        GIR_Done,
      // Label 520: @15751
      GIM_Try, /*On fail goto*//*Label 521*/ 15803, // Rule ID 620 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dotp_s_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3277:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DOTP_S_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DOTP_S_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 620,
        GIR_Done,
      // Label 521: @15803
      GIM_Try, /*On fail goto*//*Label 522*/ 15855, // Rule ID 621 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dotp_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3278:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DOTP_S_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DOTP_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 621,
        GIR_Done,
      // Label 522: @15855
      GIM_Try, /*On fail goto*//*Label 523*/ 15907, // Rule ID 622 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dotp_s_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3276:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DOTP_S_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DOTP_S_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 622,
        GIR_Done,
      // Label 523: @15907
      GIM_Try, /*On fail goto*//*Label 524*/ 15959, // Rule ID 623 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dotp_u_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3280:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DOTP_U_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DOTP_U_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 623,
        GIR_Done,
      // Label 524: @15959
      GIM_Try, /*On fail goto*//*Label 525*/ 16011, // Rule ID 624 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dotp_u_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3281:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DOTP_U_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DOTP_U_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 624,
        GIR_Done,
      // Label 525: @16011
      GIM_Try, /*On fail goto*//*Label 526*/ 16063, // Rule ID 625 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dotp_u_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3279:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DOTP_U_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DOTP_U_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 625,
        GIR_Done,
      // Label 526: @16063
      GIM_Try, /*On fail goto*//*Label 527*/ 16115, // Rule ID 640 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fcaf_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3319:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FCAF_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FCAF_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 640,
        GIR_Done,
      // Label 527: @16115
      GIM_Try, /*On fail goto*//*Label 528*/ 16167, // Rule ID 641 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fcaf_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3318:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FCAF_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FCAF_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 641,
        GIR_Done,
      // Label 528: @16167
      GIM_Try, /*On fail goto*//*Label 529*/ 16219, // Rule ID 666 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fexdo_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v8f16] } 3344:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FEXDO_H:{ *:[v8f16] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FEXDO_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 666,
        GIR_Done,
      // Label 529: @16219
      GIM_Try, /*On fail goto*//*Label 530*/ 16271, // Rule ID 667 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fexdo_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 3345:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FEXDO_W:{ *:[v4f32] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FEXDO_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 667,
        GIR_Done,
      // Label 530: @16271
      GIM_Try, /*On fail goto*//*Label 531*/ 16323, // Rule ID 694 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fmax_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 3371:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FMAX_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FMAX_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 694,
        GIR_Done,
      // Label 531: @16323
      GIM_Try, /*On fail goto*//*Label 532*/ 16375, // Rule ID 695 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fmax_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 3370:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FMAX_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FMAX_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 695,
        GIR_Done,
      // Label 532: @16375
      GIM_Try, /*On fail goto*//*Label 533*/ 16427, // Rule ID 696 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fmax_a_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 3369:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FMAX_A_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FMAX_A_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 696,
        GIR_Done,
      // Label 533: @16427
      GIM_Try, /*On fail goto*//*Label 534*/ 16479, // Rule ID 697 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fmax_a_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 3368:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FMAX_A_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FMAX_A_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 697,
        GIR_Done,
      // Label 534: @16479
      GIM_Try, /*On fail goto*//*Label 535*/ 16531, // Rule ID 698 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fmin_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 3375:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FMIN_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FMIN_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 698,
        GIR_Done,
      // Label 535: @16531
      GIM_Try, /*On fail goto*//*Label 536*/ 16583, // Rule ID 699 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fmin_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 3374:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FMIN_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FMIN_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 699,
        GIR_Done,
      // Label 536: @16583
      GIM_Try, /*On fail goto*//*Label 537*/ 16635, // Rule ID 700 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fmin_a_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 3373:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FMIN_A_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FMIN_A_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 700,
        GIR_Done,
      // Label 537: @16635
      GIM_Try, /*On fail goto*//*Label 538*/ 16687, // Rule ID 701 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fmin_a_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 3372:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FMIN_A_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FMIN_A_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 701,
        GIR_Done,
      // Label 538: @16687
      GIM_Try, /*On fail goto*//*Label 539*/ 16739, // Rule ID 712 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsaf_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3387:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSAF_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSAF_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 712,
        GIR_Done,
      // Label 539: @16739
      GIM_Try, /*On fail goto*//*Label 540*/ 16791, // Rule ID 713 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsaf_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3386:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSAF_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSAF_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 713,
        GIR_Done,
      // Label 540: @16791
      GIM_Try, /*On fail goto*//*Label 541*/ 16843, // Rule ID 714 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fseq_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3389:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSEQ_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSEQ_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 714,
        GIR_Done,
      // Label 541: @16843
      GIM_Try, /*On fail goto*//*Label 542*/ 16895, // Rule ID 715 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fseq_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3388:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSEQ_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSEQ_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 715,
        GIR_Done,
      // Label 542: @16895
      GIM_Try, /*On fail goto*//*Label 543*/ 16947, // Rule ID 716 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsle_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3391:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSLE_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSLE_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 716,
        GIR_Done,
      // Label 543: @16947
      GIM_Try, /*On fail goto*//*Label 544*/ 16999, // Rule ID 717 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsle_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3390:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSLE_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSLE_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 717,
        GIR_Done,
      // Label 544: @16999
      GIM_Try, /*On fail goto*//*Label 545*/ 17051, // Rule ID 718 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fslt_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3393:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSLT_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSLT_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 718,
        GIR_Done,
      // Label 545: @17051
      GIM_Try, /*On fail goto*//*Label 546*/ 17103, // Rule ID 719 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fslt_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3392:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSLT_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSLT_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 719,
        GIR_Done,
      // Label 546: @17103
      GIM_Try, /*On fail goto*//*Label 547*/ 17155, // Rule ID 720 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsne_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3395:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSNE_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSNE_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 720,
        GIR_Done,
      // Label 547: @17155
      GIM_Try, /*On fail goto*//*Label 548*/ 17207, // Rule ID 721 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsne_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3394:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSNE_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSNE_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 721,
        GIR_Done,
      // Label 548: @17207
      GIM_Try, /*On fail goto*//*Label 549*/ 17259, // Rule ID 722 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsor_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3397:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSOR_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSOR_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 722,
        GIR_Done,
      // Label 549: @17259
      GIM_Try, /*On fail goto*//*Label 550*/ 17311, // Rule ID 723 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsor_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3396:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSOR_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSOR_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 723,
        GIR_Done,
      // Label 550: @17311
      GIM_Try, /*On fail goto*//*Label 551*/ 17363, // Rule ID 728 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsueq_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3403:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSUEQ_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSUEQ_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 728,
        GIR_Done,
      // Label 551: @17363
      GIM_Try, /*On fail goto*//*Label 552*/ 17415, // Rule ID 729 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsueq_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3402:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSUEQ_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSUEQ_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 729,
        GIR_Done,
      // Label 552: @17415
      GIM_Try, /*On fail goto*//*Label 553*/ 17467, // Rule ID 730 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsule_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3405:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSULE_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSULE_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 730,
        GIR_Done,
      // Label 553: @17467
      GIM_Try, /*On fail goto*//*Label 554*/ 17519, // Rule ID 731 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsule_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3404:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSULE_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSULE_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 731,
        GIR_Done,
      // Label 554: @17519
      GIM_Try, /*On fail goto*//*Label 555*/ 17571, // Rule ID 732 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsult_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3407:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSULT_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSULT_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 732,
        GIR_Done,
      // Label 555: @17571
      GIM_Try, /*On fail goto*//*Label 556*/ 17623, // Rule ID 733 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsult_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3406:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSULT_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSULT_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 733,
        GIR_Done,
      // Label 556: @17623
      GIM_Try, /*On fail goto*//*Label 557*/ 17675, // Rule ID 734 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsun_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3409:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSUN_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSUN_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 734,
        GIR_Done,
      // Label 557: @17675
      GIM_Try, /*On fail goto*//*Label 558*/ 17727, // Rule ID 735 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsun_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3408:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSUN_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSUN_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 735,
        GIR_Done,
      // Label 558: @17727
      GIM_Try, /*On fail goto*//*Label 559*/ 17779, // Rule ID 736 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsune_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3411:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSUNE_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSUNE_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 736,
        GIR_Done,
      // Label 559: @17779
      GIM_Try, /*On fail goto*//*Label 560*/ 17831, // Rule ID 737 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsune_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3410:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSUNE_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSUNE_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 737,
        GIR_Done,
      // Label 560: @17831
      GIM_Try, /*On fail goto*//*Label 561*/ 17883, // Rule ID 742 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ftq_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3416:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FTQ_H:{ *:[v8i16] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FTQ_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 742,
        GIR_Done,
      // Label 561: @17883
      GIM_Try, /*On fail goto*//*Label 562*/ 17935, // Rule ID 743 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ftq_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3417:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FTQ_W:{ *:[v4i32] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FTQ_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 743,
        GIR_Done,
      // Label 562: @17935
      GIM_Try, /*On fail goto*//*Label 563*/ 17987, // Rule ID 748 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_hadd_s_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3423:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (HADD_S_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::HADD_S_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 748,
        GIR_Done,
      // Label 563: @17987
      GIM_Try, /*On fail goto*//*Label 564*/ 18039, // Rule ID 749 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_hadd_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3424:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (HADD_S_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::HADD_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 749,
        GIR_Done,
      // Label 564: @18039
      GIM_Try, /*On fail goto*//*Label 565*/ 18091, // Rule ID 750 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_hadd_s_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3422:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (HADD_S_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::HADD_S_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 750,
        GIR_Done,
      // Label 565: @18091
      GIM_Try, /*On fail goto*//*Label 566*/ 18143, // Rule ID 751 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_hadd_u_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3426:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (HADD_U_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::HADD_U_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 751,
        GIR_Done,
      // Label 566: @18143
      GIM_Try, /*On fail goto*//*Label 567*/ 18195, // Rule ID 752 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_hadd_u_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3427:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (HADD_U_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::HADD_U_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 752,
        GIR_Done,
      // Label 567: @18195
      GIM_Try, /*On fail goto*//*Label 568*/ 18247, // Rule ID 753 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_hadd_u_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3425:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (HADD_U_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::HADD_U_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 753,
        GIR_Done,
      // Label 568: @18247
      GIM_Try, /*On fail goto*//*Label 569*/ 18299, // Rule ID 754 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_hsub_s_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3429:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (HSUB_S_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::HSUB_S_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 754,
        GIR_Done,
      // Label 569: @18299
      GIM_Try, /*On fail goto*//*Label 570*/ 18351, // Rule ID 755 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_hsub_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3430:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (HSUB_S_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::HSUB_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 755,
        GIR_Done,
      // Label 570: @18351
      GIM_Try, /*On fail goto*//*Label 571*/ 18403, // Rule ID 756 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_hsub_s_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3428:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (HSUB_S_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::HSUB_S_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 756,
        GIR_Done,
      // Label 571: @18403
      GIM_Try, /*On fail goto*//*Label 572*/ 18455, // Rule ID 757 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_hsub_u_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3432:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (HSUB_U_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::HSUB_U_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 757,
        GIR_Done,
      // Label 572: @18455
      GIM_Try, /*On fail goto*//*Label 573*/ 18507, // Rule ID 758 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_hsub_u_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3433:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (HSUB_U_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::HSUB_U_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 758,
        GIR_Done,
      // Label 573: @18507
      GIM_Try, /*On fail goto*//*Label 574*/ 18559, // Rule ID 759 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_hsub_u_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3431:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (HSUB_U_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::HSUB_U_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 759,
        GIR_Done,
      // Label 574: @18559
      GIM_Try, /*On fail goto*//*Label 575*/ 18611, // Rule ID 812 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_max_a_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3485:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (MAX_A_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MAX_A_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 812,
        GIR_Done,
      // Label 575: @18611
      GIM_Try, /*On fail goto*//*Label 576*/ 18663, // Rule ID 813 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_max_a_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3487:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MAX_A_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MAX_A_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 813,
        GIR_Done,
      // Label 576: @18663
      GIM_Try, /*On fail goto*//*Label 577*/ 18715, // Rule ID 814 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_max_a_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3488:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MAX_A_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MAX_A_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 814,
        GIR_Done,
      // Label 577: @18715
      GIM_Try, /*On fail goto*//*Label 578*/ 18767, // Rule ID 815 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_max_a_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3486:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (MAX_A_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MAX_A_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 815,
        GIR_Done,
      // Label 578: @18767
      GIM_Try, /*On fail goto*//*Label 579*/ 18819, // Rule ID 832 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_min_a_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3505:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (MIN_A_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MIN_A_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 832,
        GIR_Done,
      // Label 579: @18819
      GIM_Try, /*On fail goto*//*Label 580*/ 18871, // Rule ID 833 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_min_a_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3507:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MIN_A_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MIN_A_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 833,
        GIR_Done,
      // Label 580: @18871
      GIM_Try, /*On fail goto*//*Label 581*/ 18923, // Rule ID 834 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_min_a_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3508:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MIN_A_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MIN_A_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 834,
        GIR_Done,
      // Label 581: @18923
      GIM_Try, /*On fail goto*//*Label 582*/ 18975, // Rule ID 835 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_min_a_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3506:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (MIN_A_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MIN_A_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 835,
        GIR_Done,
      // Label 582: @18975
      GIM_Try, /*On fail goto*//*Label 583*/ 19027, // Rule ID 868 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_mul_q_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3547:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MUL_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MUL_Q_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 868,
        GIR_Done,
      // Label 583: @19027
      GIM_Try, /*On fail goto*//*Label 584*/ 19079, // Rule ID 869 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_mul_q_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3548:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MUL_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MUL_Q_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 869,
        GIR_Done,
      // Label 584: @19079
      GIM_Try, /*On fail goto*//*Label 585*/ 19131, // Rule ID 870 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_mulr_q_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3558:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MULR_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULR_Q_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 870,
        GIR_Done,
      // Label 585: @19131
      GIM_Try, /*On fail goto*//*Label 586*/ 19183, // Rule ID 871 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_mulr_q_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3559:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MULR_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULR_Q_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 871,
        GIR_Done,
      // Label 586: @19183
      GIM_Try, /*On fail goto*//*Label 587*/ 19235, // Rule ID 949 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_srar_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3672:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SRAR_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRAR_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 949,
        GIR_Done,
      // Label 587: @19235
      GIM_Try, /*On fail goto*//*Label 588*/ 19287, // Rule ID 950 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_srar_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3674:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SRAR_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRAR_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 950,
        GIR_Done,
      // Label 588: @19287
      GIM_Try, /*On fail goto*//*Label 589*/ 19339, // Rule ID 951 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_srar_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3675:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SRAR_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRAR_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 951,
        GIR_Done,
      // Label 589: @19339
      GIM_Try, /*On fail goto*//*Label 590*/ 19391, // Rule ID 952 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_srar_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3673:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SRAR_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRAR_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 952,
        GIR_Done,
      // Label 590: @19391
      GIM_Try, /*On fail goto*//*Label 591*/ 19443, // Rule ID 965 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_srlr_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3688:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SRLR_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRLR_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 965,
        GIR_Done,
      // Label 591: @19443
      GIM_Try, /*On fail goto*//*Label 592*/ 19495, // Rule ID 966 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_srlr_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3690:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SRLR_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRLR_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 966,
        GIR_Done,
      // Label 592: @19495
      GIM_Try, /*On fail goto*//*Label 593*/ 19547, // Rule ID 967 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_srlr_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3691:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SRLR_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRLR_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 967,
        GIR_Done,
      // Label 593: @19547
      GIM_Try, /*On fail goto*//*Label 594*/ 19599, // Rule ID 968 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_srlr_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3689:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SRLR_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRLR_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 968,
        GIR_Done,
      // Label 594: @19599
      GIM_Try, /*On fail goto*//*Label 595*/ 19651, // Rule ID 977 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subs_s_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3707:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SUBS_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBS_S_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 977,
        GIR_Done,
      // Label 595: @19651
      GIM_Try, /*On fail goto*//*Label 596*/ 19703, // Rule ID 978 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subs_s_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3709:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SUBS_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBS_S_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 978,
        GIR_Done,
      // Label 596: @19703
      GIM_Try, /*On fail goto*//*Label 597*/ 19755, // Rule ID 979 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subs_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3710:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SUBS_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBS_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 979,
        GIR_Done,
      // Label 597: @19755
      GIM_Try, /*On fail goto*//*Label 598*/ 19807, // Rule ID 980 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subs_s_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3708:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SUBS_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBS_S_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 980,
        GIR_Done,
      // Label 598: @19807
      GIM_Try, /*On fail goto*//*Label 599*/ 19859, // Rule ID 981 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subs_u_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3711:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SUBS_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBS_U_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 981,
        GIR_Done,
      // Label 599: @19859
      GIM_Try, /*On fail goto*//*Label 600*/ 19911, // Rule ID 982 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subs_u_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3713:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SUBS_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBS_U_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 982,
        GIR_Done,
      // Label 600: @19911
      GIM_Try, /*On fail goto*//*Label 601*/ 19963, // Rule ID 983 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subs_u_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3714:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SUBS_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBS_U_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 983,
        GIR_Done,
      // Label 601: @19963
      GIM_Try, /*On fail goto*//*Label 602*/ 20015, // Rule ID 984 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subs_u_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3712:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SUBS_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBS_U_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 984,
        GIR_Done,
      // Label 602: @20015
      GIM_Try, /*On fail goto*//*Label 603*/ 20067, // Rule ID 985 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subsus_u_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3715:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SUBSUS_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBSUS_U_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 985,
        GIR_Done,
      // Label 603: @20067
      GIM_Try, /*On fail goto*//*Label 604*/ 20119, // Rule ID 986 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subsus_u_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3717:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SUBSUS_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBSUS_U_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 986,
        GIR_Done,
      // Label 604: @20119
      GIM_Try, /*On fail goto*//*Label 605*/ 20171, // Rule ID 987 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subsus_u_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3718:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SUBSUS_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBSUS_U_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 987,
        GIR_Done,
      // Label 605: @20171
      GIM_Try, /*On fail goto*//*Label 606*/ 20223, // Rule ID 988 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subsus_u_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3716:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SUBSUS_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBSUS_U_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 988,
        GIR_Done,
      // Label 606: @20223
      GIM_Try, /*On fail goto*//*Label 607*/ 20275, // Rule ID 989 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subsuu_s_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3719:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SUBSUU_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBSUU_S_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 989,
        GIR_Done,
      // Label 607: @20275
      GIM_Try, /*On fail goto*//*Label 608*/ 20327, // Rule ID 990 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subsuu_s_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3721:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SUBSUU_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBSUU_S_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 990,
        GIR_Done,
      // Label 608: @20327
      GIM_Try, /*On fail goto*//*Label 609*/ 20379, // Rule ID 991 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subsuu_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3722:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SUBSUU_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBSUU_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 991,
        GIR_Done,
      // Label 609: @20379
      GIM_Try, /*On fail goto*//*Label 610*/ 20431, // Rule ID 992 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subsuu_s_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3720:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SUBSUU_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBSUU_S_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 992,
        GIR_Done,
      // Label 610: @20431
      GIM_Try, /*On fail goto*//*Label 611*/ 20483, // Rule ID 1189 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addq_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3085:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQ_S_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDQ_S_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1189,
        GIR_Done,
      // Label 611: @20483
      GIM_Try, /*On fail goto*//*Label 612*/ 20535, // Rule ID 1191 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addu_s_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3107:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDU_S_QB_MM:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDU_S_QB_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1191,
        GIR_Done,
      // Label 612: @20535
      GIM_Try, /*On fail goto*//*Label 613*/ 20587, // Rule ID 1212 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3633:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRAV_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRAV_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1212,
        GIR_Done,
      // Label 613: @20587
      GIM_Try, /*On fail goto*//*Label 614*/ 20639, // Rule ID 1213 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_r_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3635:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRAV_R_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRAV_R_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1213,
        GIR_Done,
      // Label 614: @20639
      GIM_Try, /*On fail goto*//*Label 615*/ 20691, // Rule ID 1214 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_r_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 3637:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRAV_R_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRAV_R_W_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1214,
        GIR_Done,
      // Label 615: @20691
      GIM_Try, /*On fail goto*//*Label 616*/ 20743, // Rule ID 1216 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shrl_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3639:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRLV_QB_MM:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRLV_QB_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1216,
        GIR_Done,
      // Label 616: @20743
      GIM_Try, /*On fail goto*//*Label 617*/ 20795, // Rule ID 1227 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subq_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3701:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQ_S_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBQ_S_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1227,
        GIR_Done,
      // Label 617: @20795
      GIM_Try, /*On fail goto*//*Label 618*/ 20847, // Rule ID 1229 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subu_s_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3726:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBU_S_QB_MM:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBU_S_QB_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1229,
        GIR_Done,
      // Label 618: @20847
      GIM_Try, /*On fail goto*//*Label 619*/ 20899, // Rule ID 1239 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precrq_ph_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3608:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (PRECRQ_PH_W_MM:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECRQ_PH_W_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1239,
        GIR_Done,
      // Label 619: @20899
      GIM_Try, /*On fail goto*//*Label 620*/ 20951, // Rule ID 1240 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precrq_qb_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3609:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECRQ_QB_PH_MM:{ *:[v4i8] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECRQ_QB_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1240,
        GIR_Done,
      // Label 620: @20951
      GIM_Try, /*On fail goto*//*Label 621*/ 21003, // Rule ID 1259 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_packrl_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3580:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PACKRL_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PACKRL_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1259,
        GIR_Done,
      // Label 621: @21003
      GIM_Try, /*On fail goto*//*Label 622*/ 21055, // Rule ID 1265 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_modsub,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 3533:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MODSUB_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MODSUB_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1265,
        GIR_Done,
      // Label 622: @21055
      GIM_Try, /*On fail goto*//*Label 623*/ 21107, // Rule ID 1278 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addqh_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3087:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQH_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDQH_PH_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1278,
        GIR_Done,
      // Label 623: @21107
      GIM_Try, /*On fail goto*//*Label 624*/ 21159, // Rule ID 1279 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addqh_r_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3088:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQH_R_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDQH_R_PH_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1279,
        GIR_Done,
      // Label 624: @21159
      GIM_Try, /*On fail goto*//*Label 625*/ 21211, // Rule ID 1280 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addqh_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 3090:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQH_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDQH_W_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1280,
        GIR_Done,
      // Label 625: @21211
      GIM_Try, /*On fail goto*//*Label 626*/ 21263, // Rule ID 1281 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addqh_r_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 3089:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQH_R_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDQH_R_W_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1281,
        GIR_Done,
      // Label 626: @21263
      GIM_Try, /*On fail goto*//*Label 627*/ 21315, // Rule ID 1284 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_adduh_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3108:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDUH_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDUH_QB_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1284,
        GIR_Done,
      // Label 627: @21315
      GIM_Try, /*On fail goto*//*Label 628*/ 21367, // Rule ID 1285 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_adduh_r_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3109:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDUH_R_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDUH_R_QB_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1285,
        GIR_Done,
      // Label 628: @21367
      GIM_Try, /*On fail goto*//*Label 629*/ 21419, // Rule ID 1291 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3634:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRAV_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRAV_QB_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1291,
        GIR_Done,
      // Label 629: @21419
      GIM_Try, /*On fail goto*//*Label 630*/ 21471, // Rule ID 1292 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_r_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3636:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRAV_R_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRAV_R_QB_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1292,
        GIR_Done,
      // Label 630: @21471
      GIM_Try, /*On fail goto*//*Label 631*/ 21523, // Rule ID 1297 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shrl_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3638:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRLV_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRLV_PH_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1297,
        GIR_Done,
      // Label 631: @21523
      GIM_Try, /*On fail goto*//*Label 632*/ 21575, // Rule ID 1298 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subqh_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3703:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQH_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBQH_PH_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1298,
        GIR_Done,
      // Label 632: @21575
      GIM_Try, /*On fail goto*//*Label 633*/ 21627, // Rule ID 1299 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subqh_r_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3704:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQH_R_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBQH_R_PH_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1299,
        GIR_Done,
      // Label 633: @21627
      GIM_Try, /*On fail goto*//*Label 634*/ 21679, // Rule ID 1300 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subqh_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 3706:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQH_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBQH_W_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1300,
        GIR_Done,
      // Label 634: @21679
      GIM_Try, /*On fail goto*//*Label 635*/ 21731, // Rule ID 1301 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subqh_r_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 3705:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQH_R_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBQH_R_W_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1301,
        GIR_Done,
      // Label 635: @21731
      GIM_Try, /*On fail goto*//*Label 636*/ 21783, // Rule ID 1304 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subuh_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3727:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBUH_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBUH_QB_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1304,
        GIR_Done,
      // Label 636: @21783
      GIM_Try, /*On fail goto*//*Label 637*/ 21835, // Rule ID 1305 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subuh_r_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3728:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBUH_R_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBUH_R_QB_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1305,
        GIR_Done,
      // Label 637: @21835
      GIM_Try, /*On fail goto*//*Label 638*/ 21879, // Rule ID 1843 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addq_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3084:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (ADDQ_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDQ_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1843,
        GIR_Done,
      // Label 638: @21879
      GIM_Try, /*On fail goto*//*Label 639*/ 21923, // Rule ID 1845 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subq_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3700:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (SUBQ_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBQ_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1845,
        GIR_Done,
      // Label 639: @21923
      GIM_Try, /*On fail goto*//*Label 640*/ 21967, // Rule ID 1849 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addu_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3105:{ *:[iPTR] }, v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)  =>  (ADDU_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDU_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1849,
        GIR_Done,
      // Label 640: @21967
      GIM_Try, /*On fail goto*//*Label 641*/ 22011, // Rule ID 1851 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subu_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3724:{ *:[iPTR] }, v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)  =>  (SUBU_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBU_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1851,
        GIR_Done,
      // Label 641: @22011
      GIM_Reject,
    // Label 427: @22012
    GIM_Try, /*On fail goto*//*Label 642*/ 25060,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/5,
      GIM_Try, /*On fail goto*//*Label 643*/ 22088, // Rule ID 449 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precr_sra_ph_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3606:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$sa)  =>  (PRECR_SRA_PH_W:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECR_SRA_PH_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 449,
        GIR_Done,
      // Label 643: @22088
      GIM_Try, /*On fail goto*//*Label 644*/ 22159, // Rule ID 450 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precr_sra_r_ph_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3607:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$sa)  =>  (PRECR_SRA_R_PH_W:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECR_SRA_R_PH_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 450,
        GIR_Done,
      // Label 644: @22159
      GIM_Try, /*On fail goto*//*Label 645*/ 22230, // Rule ID 455 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_append,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 3121:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$sa)  =>  (APPEND:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::APPEND,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 455,
        GIR_Done,
      // Label 645: @22230
      GIM_Try, /*On fail goto*//*Label 646*/ 22301, // Rule ID 456 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_balign,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt2,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 3146:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt2>>:$sa)  =>  (BALIGN:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::BALIGN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 456,
        GIR_Done,
      // Label 646: @22301
      GIM_Try, /*On fail goto*//*Label 647*/ 22372, // Rule ID 457 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_prepend,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 3612:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$sa)  =>  (PREPEND:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PREPEND,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 457,
        GIR_Done,
      // Label 647: @22372
      GIM_Try, /*On fail goto*//*Label 648*/ 22443, // Rule ID 921 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_sldi_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt4,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3644:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$n)  =>  (SLDI_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, (imm:{ *:[i32] }):$n)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLDI_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // n
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 921,
        GIR_Done,
      // Label 648: @22443
      GIM_Try, /*On fail goto*//*Label 649*/ 22514, // Rule ID 922 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_sldi_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt3,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3646:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$n)  =>  (SLDI_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, (imm:{ *:[i32] }):$n)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLDI_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // n
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 922,
        GIR_Done,
      // Label 649: @22514
      GIM_Try, /*On fail goto*//*Label 650*/ 22585, // Rule ID 923 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_sldi_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt2,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3647:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, (imm:{ *:[i32] })<<P:Predicate_immZExt2>>:$n)  =>  (SLDI_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, (imm:{ *:[i32] }):$n)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLDI_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // n
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 923,
        GIR_Done,
      // Label 650: @22585
      GIM_Try, /*On fail goto*//*Label 651*/ 22656, // Rule ID 924 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_sldi_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt1,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3645:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, (imm:{ *:[i32] })<<P:Predicate_immZExt1>>:$n)  =>  (SLDI_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, (imm:{ *:[i32] }):$n)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLDI_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // n
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 924,
        GIR_Done,
      // Label 651: @22656
      GIM_Try, /*On fail goto*//*Label 652*/ 22727, // Rule ID 1293 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_balign,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt2,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 3146:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt2>>:$bp)  =>  (BALIGN_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$bp, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::BALIGN_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // bp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1293,
        GIR_Done,
      // Label 652: @22727
      GIM_Try, /*On fail goto*//*Label 653*/ 22798, // Rule ID 1315 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precr_sra_ph_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3606:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$sa)  =>  (PRECR_SRA_PH_W_MMR2:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECR_SRA_PH_W_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1315,
        GIR_Done,
      // Label 653: @22798
      GIM_Try, /*On fail goto*//*Label 654*/ 22869, // Rule ID 1316 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precr_sra_r_ph_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3607:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$sa)  =>  (PRECR_SRA_R_PH_W_MMR2:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECR_SRA_R_PH_W_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1316,
        GIR_Done,
      // Label 654: @22869
      GIM_Try, /*On fail goto*//*Label 655*/ 22940, // Rule ID 1317 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_prepend,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 3612:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$sa)  =>  (PREPEND_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PREPEND_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1317,
        GIR_Done,
      // Label 655: @22940
      GIM_Try, /*On fail goto*//*Label 656*/ 23011, // Rule ID 1318 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_append,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 3121:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$sa)  =>  (APPEND_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::APPEND_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1318,
        GIR_Done,
      // Label 656: @23011
      GIM_Try, /*On fail goto*//*Label 657*/ 23075, // Rule ID 520 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_binsl_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3155:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (BINSL_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::BINSL_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 520,
        GIR_Done,
      // Label 657: @23075
      GIM_Try, /*On fail goto*//*Label 658*/ 23139, // Rule ID 521 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_binsl_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3157:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (BINSL_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::BINSL_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 521,
        GIR_Done,
      // Label 658: @23139
      GIM_Try, /*On fail goto*//*Label 659*/ 23203, // Rule ID 522 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_binsl_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3158:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (BINSL_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::BINSL_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 522,
        GIR_Done,
      // Label 659: @23203
      GIM_Try, /*On fail goto*//*Label 660*/ 23267, // Rule ID 523 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_binsl_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3156:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (BINSL_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::BINSL_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 523,
        GIR_Done,
      // Label 660: @23267
      GIM_Try, /*On fail goto*//*Label 661*/ 23331, // Rule ID 528 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_binsr_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3163:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (BINSR_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::BINSR_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 528,
        GIR_Done,
      // Label 661: @23331
      GIM_Try, /*On fail goto*//*Label 662*/ 23395, // Rule ID 529 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_binsr_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3165:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (BINSR_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::BINSR_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 529,
        GIR_Done,
      // Label 662: @23395
      GIM_Try, /*On fail goto*//*Label 663*/ 23459, // Rule ID 530 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_binsr_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3166:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (BINSR_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::BINSR_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 530,
        GIR_Done,
      // Label 663: @23459
      GIM_Try, /*On fail goto*//*Label 664*/ 23523, // Rule ID 531 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_binsr_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3164:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (BINSR_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::BINSR_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 531,
        GIR_Done,
      // Label 664: @23523
      GIM_Try, /*On fail goto*//*Label 665*/ 23587, // Rule ID 626 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dpadd_s_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3284:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DPADD_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DPADD_S_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 626,
        GIR_Done,
      // Label 665: @23587
      GIM_Try, /*On fail goto*//*Label 666*/ 23651, // Rule ID 627 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dpadd_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3285:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DPADD_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DPADD_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 627,
        GIR_Done,
      // Label 666: @23651
      GIM_Try, /*On fail goto*//*Label 667*/ 23715, // Rule ID 628 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dpadd_s_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3283:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DPADD_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DPADD_S_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 628,
        GIR_Done,
      // Label 667: @23715
      GIM_Try, /*On fail goto*//*Label 668*/ 23779, // Rule ID 629 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dpadd_u_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3287:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DPADD_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DPADD_U_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 629,
        GIR_Done,
      // Label 668: @23779
      GIM_Try, /*On fail goto*//*Label 669*/ 23843, // Rule ID 630 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dpadd_u_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3288:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DPADD_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DPADD_U_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 630,
        GIR_Done,
      // Label 669: @23843
      GIM_Try, /*On fail goto*//*Label 670*/ 23907, // Rule ID 631 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dpadd_u_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3286:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DPADD_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DPADD_U_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 631,
        GIR_Done,
      // Label 670: @23907
      GIM_Try, /*On fail goto*//*Label 671*/ 23971, // Rule ID 632 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dpsub_s_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3304:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DPSUB_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DPSUB_S_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 632,
        GIR_Done,
      // Label 671: @23971
      GIM_Try, /*On fail goto*//*Label 672*/ 24035, // Rule ID 633 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dpsub_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3305:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DPSUB_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DPSUB_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 633,
        GIR_Done,
      // Label 672: @24035
      GIM_Try, /*On fail goto*//*Label 673*/ 24099, // Rule ID 634 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dpsub_s_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3303:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DPSUB_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DPSUB_S_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 634,
        GIR_Done,
      // Label 673: @24099
      GIM_Try, /*On fail goto*//*Label 674*/ 24163, // Rule ID 635 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dpsub_u_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3307:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DPSUB_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DPSUB_U_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 635,
        GIR_Done,
      // Label 674: @24163
      GIM_Try, /*On fail goto*//*Label 675*/ 24227, // Rule ID 636 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dpsub_u_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3308:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DPSUB_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DPSUB_U_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 636,
        GIR_Done,
      // Label 675: @24227
      GIM_Try, /*On fail goto*//*Label 676*/ 24291, // Rule ID 637 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dpsub_u_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3306:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DPSUB_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DPSUB_U_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 637,
        GIR_Done,
      // Label 676: @24291
      GIM_Try, /*On fail goto*//*Label 677*/ 24355, // Rule ID 804 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_madd_q_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3472:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MADD_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MADD_Q_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 804,
        GIR_Done,
      // Label 677: @24355
      GIM_Try, /*On fail goto*//*Label 678*/ 24419, // Rule ID 805 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_madd_q_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3473:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MADD_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MADD_Q_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 805,
        GIR_Done,
      // Label 678: @24419
      GIM_Try, /*On fail goto*//*Label 679*/ 24483, // Rule ID 806 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_maddr_q_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3474:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MADDR_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MADDR_Q_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 806,
        GIR_Done,
      // Label 679: @24483
      GIM_Try, /*On fail goto*//*Label 680*/ 24547, // Rule ID 807 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_maddr_q_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3475:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MADDR_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MADDR_Q_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 807,
        GIR_Done,
      // Label 680: @24547
      GIM_Try, /*On fail goto*//*Label 681*/ 24611, // Rule ID 860 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_msub_q_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3536:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MSUB_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MSUB_Q_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 860,
        GIR_Done,
      // Label 681: @24611
      GIM_Try, /*On fail goto*//*Label 682*/ 24675, // Rule ID 861 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_msub_q_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3537:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MSUB_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MSUB_Q_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 861,
        GIR_Done,
      // Label 682: @24675
      GIM_Try, /*On fail goto*//*Label 683*/ 24739, // Rule ID 862 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_msubr_q_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3538:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MSUBR_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MSUBR_Q_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 862,
        GIR_Done,
      // Label 683: @24739
      GIM_Try, /*On fail goto*//*Label 684*/ 24803, // Rule ID 863 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_msubr_q_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3539:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MSUBR_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MSUBR_Q_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 863,
        GIR_Done,
      // Label 684: @24803
      GIM_Try, /*On fail goto*//*Label 685*/ 24867, // Rule ID 917 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_sld_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3640:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SLD_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLD_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 917,
        GIR_Done,
      // Label 685: @24867
      GIM_Try, /*On fail goto*//*Label 686*/ 24931, // Rule ID 918 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_sld_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3642:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SLD_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLD_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 918,
        GIR_Done,
      // Label 686: @24931
      GIM_Try, /*On fail goto*//*Label 687*/ 24995, // Rule ID 919 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_sld_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3643:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SLD_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLD_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 919,
        GIR_Done,
      // Label 687: @24995
      GIM_Try, /*On fail goto*//*Label 688*/ 25059, // Rule ID 920 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_sld_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3641:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SLD_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLD_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 920,
        GIR_Done,
      // Label 688: @25059
      GIM_Reject,
    // Label 642: @25060
    GIM_Reject,
    // Label 15: @25061
    GIM_Try, /*On fail goto*//*Label 689*/ 25094, // Rule ID 326 //
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/2,
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_bposge32,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      // (intrinsic_w_chain:{ *:[i32] } 3189:{ *:[iPTR] })  =>  (BPOSGE32_PSEUDO:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::BPOSGE32_PSEUDO,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 326,
      GIR_Done,
    // Label 689: @25094
    GIM_Try, /*On fail goto*//*Label 690*/ 25996,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_Try, /*On fail goto*//*Label 691*/ 25151, // Rule ID 413 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_rddsp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt10,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_w_chain:{ *:[i32] } 3614:{ *:[iPTR] }, (imm:{ *:[i32] })<<P:Predicate_immZExt10>>:$mask)  =>  (RDDSP:{ *:[i32] } (imm:{ *:[i32] }):$mask)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::RDDSP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // mask
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 413,
        GIR_Done,
      // Label 691: @25151
      GIM_Try, /*On fail goto*//*Label 692*/ 25203, // Rule ID 414 //
        GIM_CheckFeatures, GIFBS_HasDSP_NotInMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::mips_wrdsp,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt10,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_void 3741:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt10>>:$mask)  =>  (WRDSP GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$mask)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::WRDSP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // mask
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 414,
        GIR_Done,
      // Label 692: @25203
      GIM_Try, /*On fail goto*//*Label 693*/ 25247, // Rule ID 335 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_absq_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3077:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ABSQ_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ABSQ_S_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 335,
        GIR_Done,
      // Label 693: @25247
      GIM_Try, /*On fail goto*//*Label 694*/ 25291, // Rule ID 336 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_absq_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3079:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ABSQ_S_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ABSQ_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 336,
        GIR_Done,
      // Label 694: @25291
      GIM_Try, /*On fail goto*//*Label 695*/ 25335, // Rule ID 422 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_absq_s_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v4i8] } 3078:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ABSQ_S_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ABSQ_S_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 422,
        GIR_Done,
      // Label 695: @25335
      GIM_Try, /*On fail goto*//*Label 696*/ 25379, // Rule ID 1196 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_absq_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3077:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs)  =>  (ABSQ_S_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ABSQ_S_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1196,
        GIR_Done,
      // Label 696: @25379
      GIM_Try, /*On fail goto*//*Label 697*/ 25423, // Rule ID 1197 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_absq_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3079:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs)  =>  (ABSQ_S_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ABSQ_S_W_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1197,
        GIR_Done,
      // Label 697: @25423
      GIM_Try, /*On fail goto*//*Label 698*/ 25467, // Rule ID 1277 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_absq_s_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v4i8] } 3078:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (ABSQ_S_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ABSQ_S_QB_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1277,
        GIR_Done,
      // Label 698: @25467
      GIM_Try, /*On fail goto*//*Label 699*/ 25511, // Rule ID 389 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::mips_cmpu_eq_qb,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_void 3255:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPU_EQ_QB DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPU_EQ_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 389,
        GIR_Done,
      // Label 699: @25511
      GIM_Try, /*On fail goto*//*Label 700*/ 25555, // Rule ID 390 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::mips_cmpu_lt_qb,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_void 3257:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPU_LT_QB DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPU_LT_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 390,
        GIR_Done,
      // Label 700: @25555
      GIM_Try, /*On fail goto*//*Label 701*/ 25599, // Rule ID 391 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::mips_cmpu_le_qb,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_void 3256:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPU_LE_QB DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPU_LE_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 391,
        GIR_Done,
      // Label 701: @25599
      GIM_Try, /*On fail goto*//*Label 702*/ 25643, // Rule ID 395 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::mips_cmp_eq_ph,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_void 3246:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (CMP_EQ_PH DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMP_EQ_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 395,
        GIR_Done,
      // Label 702: @25643
      GIM_Try, /*On fail goto*//*Label 703*/ 25687, // Rule ID 396 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::mips_cmp_lt_ph,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_void 3248:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (CMP_LT_PH DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMP_LT_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 396,
        GIR_Done,
      // Label 703: @25687
      GIM_Try, /*On fail goto*//*Label 704*/ 25731, // Rule ID 397 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::mips_cmp_le_ph,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_void 3247:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (CMP_LE_PH DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMP_LE_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 397,
        GIR_Done,
      // Label 704: @25731
      GIM_Try, /*On fail goto*//*Label 705*/ 25775, // Rule ID 1268 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::mips_cmp_eq_ph,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_void 3246:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (CMP_EQ_PH_MM DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMP_EQ_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1268,
        GIR_Done,
      // Label 705: @25775
      GIM_Try, /*On fail goto*//*Label 706*/ 25819, // Rule ID 1269 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::mips_cmp_lt_ph,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_void 3248:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (CMP_LT_PH_MM DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMP_LT_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1269,
        GIR_Done,
      // Label 706: @25819
      GIM_Try, /*On fail goto*//*Label 707*/ 25863, // Rule ID 1270 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::mips_cmp_le_ph,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_void 3247:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (CMP_LE_PH_MM DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMP_LE_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1270,
        GIR_Done,
      // Label 707: @25863
      GIM_Try, /*On fail goto*//*Label 708*/ 25907, // Rule ID 1274 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::mips_cmpu_eq_qb,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_void 3255:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPU_EQ_QB_MM DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPU_EQ_QB_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1274,
        GIR_Done,
      // Label 708: @25907
      GIM_Try, /*On fail goto*//*Label 709*/ 25951, // Rule ID 1275 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::mips_cmpu_lt_qb,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_void 3257:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPU_LT_QB_MM DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPU_LT_QB_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1275,
        GIR_Done,
      // Label 709: @25951
      GIM_Try, /*On fail goto*//*Label 710*/ 25995, // Rule ID 1276 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::mips_cmpu_le_qb,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_void 3256:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPU_LE_QB_MM DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPU_LE_QB_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1276,
        GIR_Done,
      // Label 710: @25995
      GIM_Reject,
    // Label 690: @25996
    GIM_Try, /*On fail goto*//*Label 711*/ 29984,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
      GIM_Try, /*On fail goto*//*Label 712*/ 26065, // Rule ID 354 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shll_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt4,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_w_chain:{ *:[v2i16] } 3631:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$rs_sa)  =>  (SHLL_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, (imm:{ *:[i32] }):$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHLL_S_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // rs_sa
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 354,
        GIR_Done,
      // Label 712: @26065
      GIM_Try, /*On fail goto*//*Label 713*/ 26129, // Rule ID 359 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shll_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_w_chain:{ *:[i32] } 3632:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$rs_sa)  =>  (SHLL_S_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] }):$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHLL_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // rs_sa
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 359,
        GIR_Done,
      // Label 713: @26129
      GIM_Try, /*On fail goto*//*Label 714*/ 26193, // Rule ID 1205 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shll_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt4,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_w_chain:{ *:[v2i16] } 3631:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$sa)  =>  (SHLL_S_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, (imm:{ *:[i32] }):$sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHLL_S_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1205,
        GIR_Done,
      // Label 714: @26193
      GIM_Try, /*On fail goto*//*Label 715*/ 26257, // Rule ID 1210 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shll_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_w_chain:{ *:[i32] } 3632:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$sa)  =>  (SHLL_S_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHLL_S_W_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1210,
        GIR_Done,
      // Label 715: @26257
      GIM_Try, /*On fail goto*//*Label 716*/ 26312, // Rule ID 1860 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shll_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt4,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_w_chain:{ *:[v2i16] } 3629:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)  =>  (SHLL_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHLL_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1860,
        GIR_Done,
      // Label 716: @26312
      GIM_Try, /*On fail goto*//*Label 717*/ 26367, // Rule ID 1866 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shll_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt3,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_w_chain:{ *:[v4i8] } 3630:{ *:[iPTR] }, v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)  =>  (SHLL_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHLL_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1866,
        GIR_Done,
      // Label 717: @26367
      GIM_Try, /*On fail goto*//*Label 718*/ 26423, // Rule ID 331 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addq_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3086:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQ_S_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDQ_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 331,
        GIR_Done,
      // Label 718: @26423
      GIM_Try, /*On fail goto*//*Label 719*/ 26479, // Rule ID 332 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subq_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3702:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQ_S_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBQ_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 332,
        GIR_Done,
      // Label 719: @26479
      GIM_Try, /*On fail goto*//*Label 720*/ 26535, // Rule ID 339 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precrq_rs_ph_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3610:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (PRECRQ_RS_PH_W:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECRQ_RS_PH_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 339,
        GIR_Done,
      // Label 720: @26535
      GIM_Try, /*On fail goto*//*Label 721*/ 26591, // Rule ID 340 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precrqu_s_qb_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v4i8] } 3611:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECRQU_S_QB_PH:{ *:[v4i8] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECRQU_S_QB_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 340,
        GIR_Done,
      // Label 721: @26591
      GIM_Try, /*On fail goto*//*Label 722*/ 26647, // Rule ID 351 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shll_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[v4i8] } 3630:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHLLV_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHLLV_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 351,
        GIR_Done,
      // Label 722: @26647
      GIM_Try, /*On fail goto*//*Label 723*/ 26703, // Rule ID 353 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shll_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3629:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHLLV_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHLLV_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 353,
        GIR_Done,
      // Label 723: @26703
      GIM_Try, /*On fail goto*//*Label 724*/ 26759, // Rule ID 355 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shll_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3631:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHLLV_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHLLV_S_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 355,
        GIR_Done,
      // Label 724: @26759
      GIM_Try, /*On fail goto*//*Label 725*/ 26815, // Rule ID 360 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shll_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3632:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHLLV_S_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHLLV_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 360,
        GIR_Done,
      // Label 725: @26815
      GIM_Try, /*On fail goto*//*Label 726*/ 26871, // Rule ID 363 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_muleu_s_ph_qbl,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3552:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEU_S_PH_QBL:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULEU_S_PH_QBL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 363,
        GIR_Done,
      // Label 726: @26871
      GIM_Try, /*On fail goto*//*Label 727*/ 26927, // Rule ID 364 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_muleu_s_ph_qbr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3553:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEU_S_PH_QBR:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULEU_S_PH_QBR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 364,
        GIR_Done,
      // Label 727: @26927
      GIM_Try, /*On fail goto*//*Label 728*/ 26983, // Rule ID 365 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_muleq_s_w_phl,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3550:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEQ_S_W_PHL:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULEQ_S_W_PHL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 365,
        GIR_Done,
      // Label 728: @26983
      GIM_Try, /*On fail goto*//*Label 729*/ 27039, // Rule ID 366 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_muleq_s_w_phr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3551:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEQ_S_W_PHR:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULEQ_S_W_PHR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 366,
        GIR_Done,
      // Label 729: @27039
      GIM_Try, /*On fail goto*//*Label 730*/ 27095, // Rule ID 367 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_mulq_rs_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3554:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULQ_RS_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULQ_RS_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 367,
        GIR_Done,
      // Label 730: @27095
      GIM_Try, /*On fail goto*//*Label 731*/ 27151, // Rule ID 392 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_cmpgu_eq_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3252:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGU_EQ_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPGU_EQ_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 392,
        GIR_Done,
      // Label 731: @27151
      GIM_Try, /*On fail goto*//*Label 732*/ 27207, // Rule ID 393 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_cmpgu_lt_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3254:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGU_LT_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPGU_LT_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 393,
        GIR_Done,
      // Label 732: @27207
      GIM_Try, /*On fail goto*//*Label 733*/ 27263, // Rule ID 394 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_cmpgu_le_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3253:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGU_LE_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPGU_LE_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 394,
        GIR_Done,
      // Label 733: @27263
      GIM_Try, /*On fail goto*//*Label 734*/ 27319, // Rule ID 404 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_pick_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v4i8] } 3594:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PICK_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PICK_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 404,
        GIR_Done,
      // Label 734: @27319
      GIM_Try, /*On fail goto*//*Label 735*/ 27375, // Rule ID 405 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_pick_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3593:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PICK_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PICK_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 405,
        GIR_Done,
      // Label 735: @27375
      GIM_Try, /*On fail goto*//*Label 736*/ 27431, // Rule ID 409 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_insv,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3454:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs)  =>  (INSV:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::INSV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 409,
        GIR_Done,
      // Label 736: @27431
      GIM_Try, /*On fail goto*//*Label 737*/ 27487, // Rule ID 415 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addu_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3104:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDU_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDU_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 415,
        GIR_Done,
      // Label 737: @27487
      GIM_Try, /*On fail goto*//*Label 738*/ 27543, // Rule ID 416 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addu_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3106:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDU_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDU_S_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 416,
        GIR_Done,
      // Label 738: @27543
      GIM_Try, /*On fail goto*//*Label 739*/ 27599, // Rule ID 417 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subu_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3723:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBU_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBU_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 417,
        GIR_Done,
      // Label 739: @27599
      GIM_Try, /*On fail goto*//*Label 740*/ 27655, // Rule ID 418 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subu_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3725:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBU_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBU_S_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 418,
        GIR_Done,
      // Label 740: @27655
      GIM_Try, /*On fail goto*//*Label 741*/ 27711, // Rule ID 419 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_cmpgdu_eq_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3249:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGDU_EQ_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPGDU_EQ_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 419,
        GIR_Done,
      // Label 741: @27711
      GIM_Try, /*On fail goto*//*Label 742*/ 27767, // Rule ID 420 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_cmpgdu_lt_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3251:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGDU_LT_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPGDU_LT_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 420,
        GIR_Done,
      // Label 742: @27767
      GIM_Try, /*On fail goto*//*Label 743*/ 27823, // Rule ID 421 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_cmpgdu_le_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3250:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGDU_LE_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPGDU_LE_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 421,
        GIR_Done,
      // Label 743: @27823
      GIM_Try, /*On fail goto*//*Label 744*/ 27879, // Rule ID 435 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_mul_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3549:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MUL_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MUL_S_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 435,
        GIR_Done,
      // Label 744: @27879
      GIM_Try, /*On fail goto*//*Label 745*/ 27935, // Rule ID 436 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_mulq_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3557:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MULQ_S_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULQ_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 436,
        GIR_Done,
      // Label 745: @27935
      GIM_Try, /*On fail goto*//*Label 746*/ 27991, // Rule ID 437 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_mulq_rs_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3555:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MULQ_RS_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULQ_RS_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 437,
        GIR_Done,
      // Label 746: @27991
      GIM_Try, /*On fail goto*//*Label 747*/ 28047, // Rule ID 438 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_mulq_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3556:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULQ_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULQ_S_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 438,
        GIR_Done,
      // Label 747: @28047
      GIM_Try, /*On fail goto*//*Label 748*/ 28103, // Rule ID 448 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precr_qb_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v4i8] } 3605:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECR_QB_PH:{ *:[v4i8] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECR_QB_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 448,
        GIR_Done,
      // Label 748: @28103
      GIM_Try, /*On fail goto*//*Label 749*/ 28159, // Rule ID 1190 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addq_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3086:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQ_S_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDQ_S_W_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1190,
        GIR_Done,
      // Label 749: @28159
      GIM_Try, /*On fail goto*//*Label 750*/ 28215, // Rule ID 1198 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_insv,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3454:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs)  =>  (INSV_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::INSV_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1198,
        GIR_Done,
      // Label 750: @28215
      GIM_Try, /*On fail goto*//*Label 751*/ 28271, // Rule ID 1206 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shll_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3629:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHLLV_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHLLV_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1206,
        GIR_Done,
      // Label 751: @28271
      GIM_Try, /*On fail goto*//*Label 752*/ 28327, // Rule ID 1207 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shll_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3631:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHLLV_S_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHLLV_S_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1207,
        GIR_Done,
      // Label 752: @28327
      GIM_Try, /*On fail goto*//*Label 753*/ 28383, // Rule ID 1208 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shll_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[v4i8] } 3630:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHLLV_QB_MM:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHLLV_QB_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1208,
        GIR_Done,
      // Label 753: @28383
      GIM_Try, /*On fail goto*//*Label 754*/ 28439, // Rule ID 1209 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shll_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3632:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHLLV_S_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHLLV_S_W_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1209,
        GIR_Done,
      // Label 754: @28439
      GIM_Try, /*On fail goto*//*Label 755*/ 28495, // Rule ID 1228 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subq_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3702:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQ_S_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBQ_S_W_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1228,
        GIR_Done,
      // Label 755: @28495
      GIM_Try, /*On fail goto*//*Label 756*/ 28551, // Rule ID 1234 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_muleq_s_w_phl,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3550:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEQ_S_W_PHL_MM:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULEQ_S_W_PHL_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1234,
        GIR_Done,
      // Label 756: @28551
      GIM_Try, /*On fail goto*//*Label 757*/ 28607, // Rule ID 1235 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_muleq_s_w_phr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3551:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEQ_S_W_PHR_MM:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULEQ_S_W_PHR_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1235,
        GIR_Done,
      // Label 757: @28607
      GIM_Try, /*On fail goto*//*Label 758*/ 28663, // Rule ID 1236 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_muleu_s_ph_qbl,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3552:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEU_S_PH_QBL_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULEU_S_PH_QBL_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1236,
        GIR_Done,
      // Label 758: @28663
      GIM_Try, /*On fail goto*//*Label 759*/ 28719, // Rule ID 1237 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_muleu_s_ph_qbr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3553:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEU_S_PH_QBR_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULEU_S_PH_QBR_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1237,
        GIR_Done,
      // Label 759: @28719
      GIM_Try, /*On fail goto*//*Label 760*/ 28775, // Rule ID 1238 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_mulq_rs_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3554:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULQ_RS_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULQ_RS_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1238,
        GIR_Done,
      // Label 760: @28775
      GIM_Try, /*On fail goto*//*Label 761*/ 28831, // Rule ID 1241 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precrqu_s_qb_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v4i8] } 3611:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECRQU_S_QB_PH_MM:{ *:[v4i8] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECRQU_S_QB_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1241,
        GIR_Done,
      // Label 761: @28831
      GIM_Try, /*On fail goto*//*Label 762*/ 28887, // Rule ID 1242 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precrq_rs_ph_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3610:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (PRECRQ_RS_PH_W_MM:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECRQ_RS_PH_W_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1242,
        GIR_Done,
      // Label 762: @28887
      GIM_Try, /*On fail goto*//*Label 763*/ 28943, // Rule ID 1260 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_pick_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3593:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PICK_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PICK_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1260,
        GIR_Done,
      // Label 763: @28943
      GIM_Try, /*On fail goto*//*Label 764*/ 28999, // Rule ID 1261 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_pick_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v4i8] } 3594:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PICK_QB_MM:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PICK_QB_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1261,
        GIR_Done,
      // Label 764: @28999
      GIM_Try, /*On fail goto*//*Label 765*/ 29055, // Rule ID 1271 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_cmpgu_eq_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3252:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGU_EQ_QB_MM:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPGU_EQ_QB_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1271,
        GIR_Done,
      // Label 765: @29055
      GIM_Try, /*On fail goto*//*Label 766*/ 29111, // Rule ID 1272 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_cmpgu_lt_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3254:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGU_LT_QB_MM:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPGU_LT_QB_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1272,
        GIR_Done,
      // Label 766: @29111
      GIM_Try, /*On fail goto*//*Label 767*/ 29167, // Rule ID 1273 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_cmpgu_le_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3253:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGU_LE_QB_MM:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPGU_LE_QB_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1273,
        GIR_Done,
      // Label 767: @29167
      GIM_Try, /*On fail goto*//*Label 768*/ 29223, // Rule ID 1282 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addu_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3104:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDU_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDU_PH_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1282,
        GIR_Done,
      // Label 768: @29223
      GIM_Try, /*On fail goto*//*Label 769*/ 29279, // Rule ID 1283 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addu_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3106:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDU_S_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDU_S_PH_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1283,
        GIR_Done,
      // Label 769: @29279
      GIM_Try, /*On fail goto*//*Label 770*/ 29335, // Rule ID 1294 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_cmpgdu_eq_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3249:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGDU_EQ_QB_MMR2:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPGDU_EQ_QB_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1294,
        GIR_Done,
      // Label 770: @29335
      GIM_Try, /*On fail goto*//*Label 771*/ 29391, // Rule ID 1295 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_cmpgdu_lt_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3251:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGDU_LT_QB_MMR2:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPGDU_LT_QB_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1295,
        GIR_Done,
      // Label 771: @29391
      GIM_Try, /*On fail goto*//*Label 772*/ 29447, // Rule ID 1296 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_cmpgdu_le_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3250:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGDU_LE_QB_MMR2:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPGDU_LE_QB_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1296,
        GIR_Done,
      // Label 772: @29447
      GIM_Try, /*On fail goto*//*Label 773*/ 29503, // Rule ID 1302 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subu_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3723:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBU_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBU_PH_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1302,
        GIR_Done,
      // Label 773: @29503
      GIM_Try, /*On fail goto*//*Label 774*/ 29559, // Rule ID 1303 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subu_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3725:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBU_S_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBU_S_PH_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1303,
        GIR_Done,
      // Label 774: @29559
      GIM_Try, /*On fail goto*//*Label 775*/ 29615, // Rule ID 1310 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_mul_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3549:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MUL_S_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MUL_S_PH_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1310,
        GIR_Done,
      // Label 775: @29615
      GIM_Try, /*On fail goto*//*Label 776*/ 29671, // Rule ID 1311 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_mulq_rs_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3555:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MULQ_RS_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULQ_RS_W_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1311,
        GIR_Done,
      // Label 776: @29671
      GIM_Try, /*On fail goto*//*Label 777*/ 29727, // Rule ID 1312 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_mulq_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3556:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULQ_S_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULQ_S_PH_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1312,
        GIR_Done,
      // Label 777: @29727
      GIM_Try, /*On fail goto*//*Label 778*/ 29783, // Rule ID 1313 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_mulq_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3557:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MULQ_S_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULQ_S_W_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1313,
        GIR_Done,
      // Label 778: @29783
      GIM_Try, /*On fail goto*//*Label 779*/ 29839, // Rule ID 1314 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precr_qb_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v4i8] } 3605:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECR_QB_PH_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECR_QB_PH_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1314,
        GIR_Done,
      // Label 779: @29839
      GIM_Try, /*On fail goto*//*Label 780*/ 29887, // Rule ID 1847 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_mul_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3546:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (MUL_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MUL_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1847,
        GIR_Done,
      // Label 780: @29887
      GIM_Try, /*On fail goto*//*Label 781*/ 29935, // Rule ID 1853 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addsc,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3103:{ *:[iPTR] }, i32:{ *:[i32] }:$a, i32:{ *:[i32] }:$b)  =>  (ADDSC:{ *:[i32] } i32:{ *:[i32] }:$a, i32:{ *:[i32] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDSC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1853,
        GIR_Done,
      // Label 781: @29935
      GIM_Try, /*On fail goto*//*Label 782*/ 29983, // Rule ID 1855 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addwc,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3118:{ *:[iPTR] }, i32:{ *:[i32] }:$a, i32:{ *:[i32] }:$b)  =>  (ADDWC:{ *:[i32] } i32:{ *:[i32] }:$a, i32:{ *:[i32] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDWC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1855,
        GIR_Done,
      // Label 782: @29983
      GIM_Reject,
    // Label 711: @29984
    GIM_Reject,
    // Label 16: @29985
    GIM_Try, /*On fail goto*//*Label 783*/ 30041, // Rule ID 1523 //
      GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_IsGP64bit,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
      // (trunc:{ *:[i32] } GPR64:{ *:[i64] }:$src)  =>  (SLL:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i32] } GPR64:{ *:[i64] }:$src, sub_32:{ *:[i32] }), 0:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLL,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1523,
      GIR_Done,
    // Label 783: @30041
    GIM_Reject,
    // Label 17: @30042
    GIM_Try, /*On fail goto*//*Label 784*/ 30101,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 785*/ 30074, // Rule ID 2077 //
        GIM_CheckFeatures, GIFBS_InMicroMips,
        GIM_CheckI64ImmPredicate, /*MI*/0, /*Predicate*/GIPFP_I64_Predicate_immLi16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        // MIs[0] Operand 1
        // No operand predicates
        // (imm:{ *:[i32] })<<P:Predicate_immLi16>>:$imm  =>  (LI16_MM:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_immLi16>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::LI16_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2077,
        GIR_Done,
      // Label 785: @30074
      GIM_Try, /*On fail goto*//*Label 786*/ 30100, // Rule ID 1771 //
        GIM_CheckFeatures, GIFBS_InMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
        // MIs[0] Operand 1
        // No operand predicates
        // (imm:{ *:[i32] }):$imm  =>  (LwConstant32:{ *:[i32] } (imm:{ *:[i32] }):$imm, -1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::LwConstant32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rx
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1771,
        GIR_Done,
      // Label 786: @30100
      GIM_Reject,
    // Label 784: @30101
    GIM_Reject,
    // Label 18: @30102
    GIM_Try, /*On fail goto*//*Label 787*/ 30129, // Rule ID 1530 //
      GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_IsGP64bit,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      // (sext:{ *:[i64] } GPR32:{ *:[i32] }:$src)  =>  (SLL64_32:{ *:[i64] } GPR32:{ *:[i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SLL64_32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1530,
      GIR_Done,
    // Label 787: @30129
    GIM_Reject,
    // Label 19: @30130
    GIM_Try, /*On fail goto*//*Label 788*/ 30214,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      GIM_Try, /*On fail goto*//*Label 789*/ 30187, // Rule ID 1529 //
        GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_IsGP64bit,
        // (zext:{ *:[i64] } GPR32:{ *:[i32] }:$src)  =>  (DSRL:{ *:[i64] } (DSLL64_32:{ *:[i64] } GPR32:{ *:[i32] }:$src), 32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::DSLL64_32,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DSRL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1529,
        GIR_Done,
      // Label 789: @30187
      GIM_Try, /*On fail goto*//*Label 790*/ 30213, // Rule ID 1531 //
        GIM_CheckFeatures, GIFBS_HasMips64r2_HasStdEnc_IsGP64bit_NotInMicroMips,
        // (zext:{ *:[i64] } GPR32:{ *:[i32] }:$src)  =>  (DEXT64_32:{ *:[i64] } GPR32:{ *:[i32] }:$src, 0:{ *:[i32] }, 32:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DEXT64_32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1531,
        GIR_Done,
      // Label 790: @30213
      GIM_Reject,
    // Label 788: @30214
    GIM_Reject,
    // Label 20: @30215
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 9, /*)*//*default:*//*Label 797*/ 30738,
    /*GILLT_s32*//*Label 791*/ 30229,
    /*GILLT_s64*//*Label 792*/ 30482, 0,
    /*GILLT_v2s64*//*Label 793*/ 30610, 0,
    /*GILLT_v4s32*//*Label 794*/ 30642,
    /*GILLT_v8s16*//*Label 795*/ 30674,
    /*GILLT_v16s8*//*Label 796*/ 30706,
    // Label 791: @30229
    GIM_Try, /*On fail goto*//*Label 798*/ 30481,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 799*/ 30282, // Rule ID 43 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (shl:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$shamt)  =>  (SLL:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] }):$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 43,
        GIR_Done,
      // Label 799: @30282
      GIM_Try, /*On fail goto*//*Label 800*/ 30325, // Rule ID 1753 //
        GIM_CheckFeatures, GIFBS_InMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (shl:{ *:[i32] } CPU16Regs:{ *:[i32] }:$in, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)  =>  (SllX16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$in, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SllX16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rx
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1753,
        GIR_Done,
      // Label 800: @30325
      GIM_Try, /*On fail goto*//*Label 801*/ 30368, // Rule ID 2089 //
        GIM_CheckFeatures, GIFBS_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPRMM16RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt2Shift,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (shl:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt2Shift>>:$imm)  =>  (SLL16_MM:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt2Shift>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLL16_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2089,
        GIR_Done,
      // Label 801: @30368
      GIM_Try, /*On fail goto*//*Label 802*/ 30411, // Rule ID 2090 //
        GIM_CheckFeatures, GIFBS_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (shl:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)  =>  (SLL_MM:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLL_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2090,
        GIR_Done,
      // Label 802: @30411
      GIM_Try, /*On fail goto*//*Label 803*/ 30434, // Rule ID 46 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (shl:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SLLV:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SLLV,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46,
        GIR_Done,
      // Label 803: @30434
      GIM_Try, /*On fail goto*//*Label 804*/ 30457, // Rule ID 1756 //
        GIM_CheckFeatures, GIFBS_InMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::CPU16RegsRegClassID,
        // (shl:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r, CPU16Regs:{ *:[i32] }:$ra)  =>  (SllvRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r, CPU16Regs:{ *:[i32] }:$ra)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SllvRxRy16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1756,
        GIR_Done,
      // Label 804: @30457
      GIM_Try, /*On fail goto*//*Label 805*/ 30480, // Rule ID 2091 //
        GIM_CheckFeatures, GIFBS_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (shl:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs)  =>  (SLLV_MM:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SLLV_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2091,
        GIR_Done,
      // Label 805: @30480
      GIM_Reject,
    // Label 798: @30481
    GIM_Reject,
    // Label 792: @30482
    GIM_Try, /*On fail goto*//*Label 806*/ 30609,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 807*/ 30535, // Rule ID 188 //
        GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_NotInMicroMips,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt6,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (shl:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt6>>:$shamt)  =>  (DSLL:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, (imm:{ *:[i32] }):$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DSLL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 188,
        GIR_Done,
      // Label 807: @30535
      GIM_Try, /*On fail goto*//*Label 808*/ 30593, // Rule ID 1524 //
        GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_IsGP64bit,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (shl:{ *:[i64] } GPR64:{ *:[i64] }:$rt, (trunc:{ *:[i32] } GPR64:{ *:[i64] }:$rs))  =>  (DSLLV:{ *:[i64] } GPR64:{ *:[i64] }:$rt, (EXTRACT_SUBREG:{ *:[i32] } GPR64:{ *:[i64] }:$rs, sub_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/1, // rs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DSLLV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1524,
        GIR_Done,
      // Label 808: @30593
      GIM_Try, /*On fail goto*//*Label 809*/ 30608, // Rule ID 191 //
        GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (shl:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (DSLLV:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DSLLV,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 191,
        GIR_Done,
      // Label 809: @30608
      GIM_Reject,
    // Label 806: @30609
    GIM_Reject,
    // Label 793: @30610
    GIM_Try, /*On fail goto*//*Label 810*/ 30641, // Rule ID 928 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
      // (shl:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SLL_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SLL_D,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 928,
      GIR_Done,
    // Label 810: @30641
    GIM_Reject,
    // Label 794: @30642
    GIM_Try, /*On fail goto*//*Label 811*/ 30673, // Rule ID 927 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
      // (shl:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SLL_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SLL_W,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 927,
      GIR_Done,
    // Label 811: @30673
    GIM_Reject,
    // Label 795: @30674
    GIM_Try, /*On fail goto*//*Label 812*/ 30705, // Rule ID 926 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
      // (shl:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SLL_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SLL_H,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 926,
      GIR_Done,
    // Label 812: @30705
    GIM_Reject,
    // Label 796: @30706
    GIM_Try, /*On fail goto*//*Label 813*/ 30737, // Rule ID 925 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
      // (shl:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SLL_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SLL_B,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 925,
      GIR_Done,
    // Label 813: @30737
    GIM_Reject,
    // Label 797: @30738
    GIM_Reject,
    // Label 21: @30739
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 9, /*)*//*default:*//*Label 820*/ 31262,
    /*GILLT_s32*//*Label 814*/ 30753,
    /*GILLT_s64*//*Label 815*/ 31006, 0,
    /*GILLT_v2s64*//*Label 816*/ 31134, 0,
    /*GILLT_v4s32*//*Label 817*/ 31166,
    /*GILLT_v8s16*//*Label 818*/ 31198,
    /*GILLT_v16s8*//*Label 819*/ 31230,
    // Label 814: @30753
    GIM_Try, /*On fail goto*//*Label 821*/ 31005,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 822*/ 30806, // Rule ID 44 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (srl:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$shamt)  =>  (SRL:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] }):$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44,
        GIR_Done,
      // Label 822: @30806
      GIM_Try, /*On fail goto*//*Label 823*/ 30849, // Rule ID 1754 //
        GIM_CheckFeatures, GIFBS_InMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (srl:{ *:[i32] } CPU16Regs:{ *:[i32] }:$in, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)  =>  (SrlX16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$in, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SrlX16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rx
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1754,
        GIR_Done,
      // Label 823: @30849
      GIM_Try, /*On fail goto*//*Label 824*/ 30892, // Rule ID 2092 //
        GIM_CheckFeatures, GIFBS_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPRMM16RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt2Shift,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (srl:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt2Shift>>:$imm)  =>  (SRL16_MM:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt2Shift>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRL16_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2092,
        GIR_Done,
      // Label 824: @30892
      GIM_Try, /*On fail goto*//*Label 825*/ 30935, // Rule ID 2093 //
        GIM_CheckFeatures, GIFBS_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (srl:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)  =>  (SRL_MM:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRL_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2093,
        GIR_Done,
      // Label 825: @30935
      GIM_Try, /*On fail goto*//*Label 826*/ 30958, // Rule ID 47 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (srl:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SRLV:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SRLV,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47,
        GIR_Done,
      // Label 826: @30958
      GIM_Try, /*On fail goto*//*Label 827*/ 30981, // Rule ID 1758 //
        GIM_CheckFeatures, GIFBS_InMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::CPU16RegsRegClassID,
        // (srl:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r, CPU16Regs:{ *:[i32] }:$ra)  =>  (SrlvRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r, CPU16Regs:{ *:[i32] }:$ra)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SrlvRxRy16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1758,
        GIR_Done,
      // Label 827: @30981
      GIM_Try, /*On fail goto*//*Label 828*/ 31004, // Rule ID 2094 //
        GIM_CheckFeatures, GIFBS_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (srl:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs)  =>  (SRLV_MM:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SRLV_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2094,
        GIR_Done,
      // Label 828: @31004
      GIM_Reject,
    // Label 821: @31005
    GIM_Reject,
    // Label 815: @31006
    GIM_Try, /*On fail goto*//*Label 829*/ 31133,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 830*/ 31059, // Rule ID 189 //
        GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_NotInMicroMips,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt6,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (srl:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt6>>:$shamt)  =>  (DSRL:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, (imm:{ *:[i32] }):$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DSRL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 189,
        GIR_Done,
      // Label 830: @31059
      GIM_Try, /*On fail goto*//*Label 831*/ 31117, // Rule ID 1525 //
        GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_IsGP64bit,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (srl:{ *:[i64] } GPR64:{ *:[i64] }:$rt, (trunc:{ *:[i32] } GPR64:{ *:[i64] }:$rs))  =>  (DSRLV:{ *:[i64] } GPR64:{ *:[i64] }:$rt, (EXTRACT_SUBREG:{ *:[i32] } GPR64:{ *:[i64] }:$rs, sub_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/1, // rs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DSRLV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1525,
        GIR_Done,
      // Label 831: @31117
      GIM_Try, /*On fail goto*//*Label 832*/ 31132, // Rule ID 193 //
        GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (srl:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (DSRLV:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DSRLV,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 193,
        GIR_Done,
      // Label 832: @31132
      GIM_Reject,
    // Label 829: @31133
    GIM_Reject,
    // Label 816: @31134
    GIM_Try, /*On fail goto*//*Label 833*/ 31165, // Rule ID 960 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
      // (srl:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SRL_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SRL_D,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 960,
      GIR_Done,
    // Label 833: @31165
    GIM_Reject,
    // Label 817: @31166
    GIM_Try, /*On fail goto*//*Label 834*/ 31197, // Rule ID 959 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
      // (srl:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SRL_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SRL_W,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 959,
      GIR_Done,
    // Label 834: @31197
    GIM_Reject,
    // Label 818: @31198
    GIM_Try, /*On fail goto*//*Label 835*/ 31229, // Rule ID 958 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
      // (srl:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SRL_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SRL_H,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 958,
      GIR_Done,
    // Label 835: @31229
    GIM_Reject,
    // Label 819: @31230
    GIM_Try, /*On fail goto*//*Label 836*/ 31261, // Rule ID 957 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
      // (srl:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SRL_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SRL_B,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 957,
      GIR_Done,
    // Label 836: @31261
    GIM_Reject,
    // Label 820: @31262
    GIM_Reject,
    // Label 22: @31263
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 9, /*)*//*default:*//*Label 843*/ 31743,
    /*GILLT_s32*//*Label 837*/ 31277,
    /*GILLT_s64*//*Label 838*/ 31487, 0,
    /*GILLT_v2s64*//*Label 839*/ 31615, 0,
    /*GILLT_v4s32*//*Label 840*/ 31647,
    /*GILLT_v8s16*//*Label 841*/ 31679,
    /*GILLT_v16s8*//*Label 842*/ 31711,
    // Label 837: @31277
    GIM_Try, /*On fail goto*//*Label 844*/ 31486,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 845*/ 31330, // Rule ID 45 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sra:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$shamt)  =>  (SRA:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] }):$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45,
        GIR_Done,
      // Label 845: @31330
      GIM_Try, /*On fail goto*//*Label 846*/ 31373, // Rule ID 1755 //
        GIM_CheckFeatures, GIFBS_InMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sra:{ *:[i32] } CPU16Regs:{ *:[i32] }:$in, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)  =>  (SraX16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$in, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SraX16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rx
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1755,
        GIR_Done,
      // Label 846: @31373
      GIM_Try, /*On fail goto*//*Label 847*/ 31416, // Rule ID 2095 //
        GIM_CheckFeatures, GIFBS_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sra:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)  =>  (SRA_MM:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRA_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2095,
        GIR_Done,
      // Label 847: @31416
      GIM_Try, /*On fail goto*//*Label 848*/ 31439, // Rule ID 48 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (sra:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SRAV:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SRAV,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48,
        GIR_Done,
      // Label 848: @31439
      GIM_Try, /*On fail goto*//*Label 849*/ 31462, // Rule ID 1757 //
        GIM_CheckFeatures, GIFBS_InMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::CPU16RegsRegClassID,
        // (sra:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r, CPU16Regs:{ *:[i32] }:$ra)  =>  (SravRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r, CPU16Regs:{ *:[i32] }:$ra)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SravRxRy16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1757,
        GIR_Done,
      // Label 849: @31462
      GIM_Try, /*On fail goto*//*Label 850*/ 31485, // Rule ID 2096 //
        GIM_CheckFeatures, GIFBS_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (sra:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs)  =>  (SRAV_MM:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SRAV_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2096,
        GIR_Done,
      // Label 850: @31485
      GIM_Reject,
    // Label 844: @31486
    GIM_Reject,
    // Label 838: @31487
    GIM_Try, /*On fail goto*//*Label 851*/ 31614,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 852*/ 31540, // Rule ID 190 //
        GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_NotInMicroMips,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt6,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sra:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt6>>:$shamt)  =>  (DSRA:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, (imm:{ *:[i32] }):$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DSRA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 190,
        GIR_Done,
      // Label 852: @31540
      GIM_Try, /*On fail goto*//*Label 853*/ 31598, // Rule ID 1526 //
        GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_IsGP64bit,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sra:{ *:[i64] } GPR64:{ *:[i64] }:$rt, (trunc:{ *:[i32] } GPR64:{ *:[i64] }:$rs))  =>  (DSRAV:{ *:[i64] } GPR64:{ *:[i64] }:$rt, (EXTRACT_SUBREG:{ *:[i32] } GPR64:{ *:[i64] }:$rs, sub_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/1, // rs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DSRAV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1526,
        GIR_Done,
      // Label 853: @31598
      GIM_Try, /*On fail goto*//*Label 854*/ 31613, // Rule ID 192 //
        GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (sra:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (DSRAV:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DSRAV,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 192,
        GIR_Done,
      // Label 854: @31613
      GIM_Reject,
    // Label 851: @31614
    GIM_Reject,
    // Label 839: @31615
    GIM_Try, /*On fail goto*//*Label 855*/ 31646, // Rule ID 944 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
      // (sra:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SRA_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SRA_D,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 944,
      GIR_Done,
    // Label 855: @31646
    GIM_Reject,
    // Label 840: @31647
    GIM_Try, /*On fail goto*//*Label 856*/ 31678, // Rule ID 943 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
      // (sra:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SRA_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SRA_W,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 943,
      GIR_Done,
    // Label 856: @31678
    GIM_Reject,
    // Label 841: @31679
    GIM_Try, /*On fail goto*//*Label 857*/ 31710, // Rule ID 942 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
      // (sra:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SRA_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SRA_H,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 942,
      GIR_Done,
    // Label 857: @31710
    GIM_Reject,
    // Label 842: @31711
    GIM_Try, /*On fail goto*//*Label 858*/ 31742, // Rule ID 941 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
      // (sra:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SRA_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SRA_B,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 941,
      GIR_Done,
    // Label 858: @31742
    GIM_Reject,
    // Label 843: @31743
    GIM_Reject,
    // Label 23: @31744
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 861*/ 33197,
    /*GILLT_s32*//*Label 859*/ 31752,
    /*GILLT_s64*//*Label 860*/ 32551,
    // Label 859: @31752
    GIM_Try, /*On fail goto*//*Label 862*/ 31791, // Rule ID 267 //
      GIM_CheckFeatures, GIFBS_HasStdEnc_NotMips4_32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
      // (select:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$cond, GPR32Opnd:{ *:[i32] }:$T, GPR32Opnd:{ *:[i32] }:$F)  =>  (PseudoSELECT_I:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$cond, GPR32Opnd:{ *:[i32] }:$T, GPR32Opnd:{ *:[i32] }:$F)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::PseudoSELECT_I,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 267,
      GIR_Done,
    // Label 862: @31791
    GIM_Try, /*On fail goto*//*Label 863*/ 31830, // Rule ID 269 //
      GIM_CheckFeatures, GIFBS_HasStdEnc_NotMips4_32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::FGR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::FGR32RegClassID,
      // (select:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$cond, FGR32Opnd:{ *:[f32] }:$T, FGR32Opnd:{ *:[f32] }:$F)  =>  (PseudoSELECT_S:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$cond, FGR32Opnd:{ *:[f32] }:$T, FGR32Opnd:{ *:[f32] }:$F)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::PseudoSELECT_S,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 269,
      GIR_Done,
    // Label 863: @31830
    GIM_Try, /*On fail goto*//*Label 864*/ 31886, // Rule ID 306 //
      GIM_CheckFeatures, GIFBS_HasMips32r6_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGRCCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::FGR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::FGR32RegClassID,
      // (select:{ *:[f32] } FGRCCOpnd:{ *:[i32] }:$fd_in, FGR32Opnd:{ *:[f32] }:$ft, FGR32Opnd:{ *:[f32] }:$fs)  =>  (SEL_S:{ *:[f32] } FGRCCOpnd:{ *:[i32] }:$fd_in, FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SEL_S,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // fd_in
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // fs
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ft
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 306,
      GIR_Done,
    // Label 864: @31886
    GIM_Try, /*On fail goto*//*Label 865*/ 31942, // Rule ID 1179 //
      GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGRCCRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::FGR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::FGR32RegClassID,
      // (select:{ *:[f32] } FGRCCOpnd:{ *:[i32] }:$fd_in, FGR32Opnd:{ *:[f32] }:$ft, FGR32Opnd:{ *:[f32] }:$fs)  =>  (SEL_S_MMR6:{ *:[f32] } FGRCCOpnd:{ *:[i32] }:$fd_in, FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SEL_S_MMR6,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // fd_in
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // fs
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ft
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1179,
      GIR_Done,
    // Label 865: @31942
    GIM_Try, /*On fail goto*//*Label 866*/ 31998, // Rule ID 1576 //
      GIM_CheckFeatures, GIFBS_HasMips4_32_HasStdEnc_NotInMicroMips_NotMips32r6_NotMips64r6,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
      // (select:{ *:[i32] } GPR32:{ *:[i32] }:$cond, GPR32:{ *:[i32] }:$T, GPR32:{ *:[i32] }:$F)  =>  (MOVN_I_I:{ *:[i32] } GPR32:{ *:[i32] }:$T, GPR32:{ *:[i32] }:$cond, GPR32:{ *:[i32] }:$F)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MOVN_I_I,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // T
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // cond
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // F
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1576,
      GIR_Done,
    // Label 866: @31998
    GIM_Try, /*On fail goto*//*Label 867*/ 32054, // Rule ID 1615 //
      GIM_CheckFeatures, GIFBS_HasMips4_32_HasStdEnc_IsGP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
      // (select:{ *:[i32] } GPR64:{ *:[i64] }:$cond, GPR32:{ *:[i32] }:$T, GPR32:{ *:[i32] }:$F)  =>  (MOVN_I64_I:{ *:[i32] } GPR32:{ *:[i32] }:$T, GPR64:{ *:[i64] }:$cond, GPR32:{ *:[i32] }:$F)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MOVN_I64_I,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // T
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // cond
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // F
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1615,
      GIR_Done,
    // Label 867: @32054
    GIM_Try, /*On fail goto*//*Label 868*/ 32110, // Rule ID 1631 //
      GIM_CheckFeatures, GIFBS_HasMips4_32_HasStdEnc_NotInMicroMips_NotMips32r6_NotMips64r6,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::FGR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::FGR32RegClassID,
      // (select:{ *:[f32] } GPR32:{ *:[i32] }:$cond, FGR32:{ *:[f32] }:$T, FGR32:{ *:[f32] }:$F)  =>  (MOVN_I_S:{ *:[f32] } FGR32:{ *:[f32] }:$T, GPR32:{ *:[i32] }:$cond, FGR32:{ *:[f32] }:$F)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MOVN_I_S,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // T
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // cond
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // F
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1631,
      GIR_Done,
    // Label 868: @32110
    GIM_Try, /*On fail goto*//*Label 869*/ 32166, // Rule ID 1644 //
      GIM_CheckFeatures, GIFBS_HasMips4_32_HasStdEnc_IsGP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::FGR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::FGR32RegClassID,
      // (select:{ *:[f32] } GPR64:{ *:[i64] }:$cond, FGR32:{ *:[f32] }:$T, FGR32:{ *:[f32] }:$F)  =>  (MOVN_I64_S:{ *:[f32] } FGR32:{ *:[f32] }:$T, GPR64:{ *:[i64] }:$cond, FGR32:{ *:[f32] }:$F)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MOVN_I64_S,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // T
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // cond
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // F
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1644,
      GIR_Done,
    // Label 869: @32166
    GIM_Try, /*On fail goto*//*Label 870*/ 32222, // Rule ID 1802 //
      GIM_CheckFeatures, GIFBS_InMips16Mode,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::CPU16RegsRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::CPU16RegsRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::CPU16RegsRegClassID,
      // (select:{ *:[i32] } CPU16Regs:{ *:[i32] }:$a, CPU16Regs:{ *:[i32] }:$x, CPU16Regs:{ *:[i32] }:$y)  =>  (SelBneZ:{ *:[i32] } CPU16Regs:{ *:[i32] }:$x, CPU16Regs:{ *:[i32] }:$y, CPU16Regs:{ *:[i32] }:$a)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SelBneZ,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd_
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // x
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // y
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // a
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1802,
      GIR_Done,
    // Label 870: @32222
    GIM_Try, /*On fail goto*//*Label 871*/ 32278, // Rule ID 2147 //
      GIM_CheckFeatures, GIFBS_HasMips4_32_HasStdEnc_NotMips32r6_NotMips64r6,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
      // (select:{ *:[i32] } GPR32:{ *:[i32] }:$cond, GPR32:{ *:[i32] }:$T, GPR32:{ *:[i32] }:$F)  =>  (MOVN_I_MM:{ *:[i32] } GPR32:{ *:[i32] }:$T, GPR32:{ *:[i32] }:$cond, GPR32:{ *:[i32] }:$F)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MOVN_I_MM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // T
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // cond
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // F
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2147,
      GIR_Done,
    // Label 871: @32278
    GIM_Try, /*On fail goto*//*Label 872*/ 32334, // Rule ID 2161 //
      GIM_CheckFeatures, GIFBS_InMicroMips_NotMips32r6,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
      // (select:{ *:[i32] } GPR32:{ *:[i32] }:$cond, GPR32:{ *:[i32] }:$T, GPR32:{ *:[i32] }:$F)  =>  (MOVN_I_MM:{ *:[i32] } GPR32:{ *:[i32] }:$T, GPR32:{ *:[i32] }:$cond, GPR32:{ *:[i32] }:$F)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MOVN_I_MM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // T
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // cond
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // F
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2161,
      GIR_Done,
    // Label 872: @32334
    GIM_Try, /*On fail goto*//*Label 873*/ 32390, // Rule ID 2192 //
      GIM_CheckFeatures, GIFBS_InMicroMips_NotMips32r6,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::FGR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::FGR32RegClassID,
      // (select:{ *:[f32] } GPR32:{ *:[i32] }:$cond, FGR32:{ *:[f32] }:$T, FGR32:{ *:[f32] }:$F)  =>  (MOVN_I_S_MM:{ *:[f32] } FGR32:{ *:[f32] }:$T, GPR32:{ *:[i32] }:$cond, FGR32:{ *:[f32] }:$F)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MOVN_I_S_MM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // T
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // cond
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // F
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2192,
      GIR_Done,
    // Label 873: @32390
    GIM_Try, /*On fail goto*//*Label 874*/ 32470, // Rule ID 1713 //
      GIM_CheckFeatures, GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      // (select:{ *:[i32] } i32:{ *:[i32] }:$cond, i32:{ *:[i32] }:$t, i32:{ *:[i32] }:$f)  =>  (OR:{ *:[i32] } (SELNEZ:{ *:[i32] } i32:{ *:[i32] }:$t, i32:{ *:[i32] }:$cond), (SELEQZ:{ *:[i32] } i32:{ *:[i32] }:$f, i32:{ *:[i32] }:$cond))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/Mips::SELEQZ,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // f
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // cond
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SELNEZ,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // t
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // cond
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::OR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1713,
      GIR_Done,
    // Label 874: @32470
    GIM_Try, /*On fail goto*//*Label 875*/ 32550, // Rule ID 2209 //
      GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      // (select:{ *:[i32] } i32:{ *:[i32] }:$cond, i32:{ *:[i32] }:$t, i32:{ *:[i32] }:$f)  =>  (OR_MM:{ *:[i32] } (SELNEZ_MMR6:{ *:[i32] } i32:{ *:[i32] }:$t, i32:{ *:[i32] }:$cond), (SELEQZ_MMR6:{ *:[i32] } i32:{ *:[i32] }:$f, i32:{ *:[i32] }:$cond))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/Mips::SELEQZ_MMR6,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // f
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // cond
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SELNEZ_MMR6,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // t
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // cond
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::OR_MM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2209,
      GIR_Done,
    // Label 875: @32550
    GIM_Reject,
    // Label 860: @32551
    GIM_Try, /*On fail goto*//*Label 876*/ 32590, // Rule ID 268 //
      GIM_CheckFeatures, GIFBS_HasStdEnc_NotMips4_32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR64RegClassID,
      // (select:{ *:[i64] } GPR32Opnd:{ *:[i32] }:$cond, GPR64Opnd:{ *:[i64] }:$T, GPR64Opnd:{ *:[i64] }:$F)  =>  (PseudoSELECT_I64:{ *:[i64] } GPR32Opnd:{ *:[i32] }:$cond, GPR64Opnd:{ *:[i64] }:$T, GPR64Opnd:{ *:[i64] }:$F)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::PseudoSELECT_I64,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 268,
      GIR_Done,
    // Label 876: @32590
    GIM_Try, /*On fail goto*//*Label 877*/ 32629, // Rule ID 270 //
      GIM_CheckFeatures, GIFBS_HasStdEnc_NotFP64bit_NotMips4_32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::AFGR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::AFGR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::AFGR64RegClassID,
      // (select:{ *:[f64] } GPR32Opnd:{ *:[i32] }:$cond, AFGR64Opnd:{ *:[f64] }:$T, AFGR64Opnd:{ *:[f64] }:$F)  =>  (PseudoSELECT_D32:{ *:[f64] } GPR32Opnd:{ *:[i32] }:$cond, AFGR64Opnd:{ *:[f64] }:$T, AFGR64Opnd:{ *:[f64] }:$F)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::PseudoSELECT_D32,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 270,
      GIR_Done,
    // Label 877: @32629
    GIM_Try, /*On fail goto*//*Label 878*/ 32668, // Rule ID 271 //
      GIM_CheckFeatures, GIFBS_HasStdEnc_IsFP64bit_NotMips4_32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::FGR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::FGR64RegClassID,
      // (select:{ *:[f64] } GPR32Opnd:{ *:[i32] }:$cond, FGR64Opnd:{ *:[f64] }:$T, FGR64Opnd:{ *:[f64] }:$F)  =>  (PseudoSELECT_D64:{ *:[f64] } GPR32Opnd:{ *:[i32] }:$cond, FGR64Opnd:{ *:[f64] }:$T, FGR64Opnd:{ *:[f64] }:$F)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::PseudoSELECT_D64,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 271,
      GIR_Done,
    // Label 878: @32668
    GIM_Try, /*On fail goto*//*Label 879*/ 32724, // Rule ID 1612 //
      GIM_CheckFeatures, GIFBS_HasMips4_32_HasStdEnc_IsGP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR64RegClassID,
      // (select:{ *:[i64] } GPR32:{ *:[i32] }:$cond, GPR64:{ *:[i64] }:$T, GPR64:{ *:[i64] }:$F)  =>  (MOVN_I_I64:{ *:[i64] } GPR64:{ *:[i64] }:$T, GPR32:{ *:[i32] }:$cond, GPR64:{ *:[i64] }:$F)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MOVN_I_I64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // T
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // cond
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // F
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1612,
      GIR_Done,
    // Label 879: @32724
    GIM_Try, /*On fail goto*//*Label 880*/ 32780, // Rule ID 1618 //
      GIM_CheckFeatures, GIFBS_HasMips4_32_HasStdEnc_IsGP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR64RegClassID,
      // (select:{ *:[i64] } GPR64:{ *:[i64] }:$cond, GPR64:{ *:[i64] }:$T, GPR64:{ *:[i64] }:$F)  =>  (MOVN_I64_I64:{ *:[i64] } GPR64:{ *:[i64] }:$T, GPR64:{ *:[i64] }:$cond, GPR64:{ *:[i64] }:$F)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MOVN_I64_I64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // T
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // cond
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // F
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1618,
      GIR_Done,
    // Label 880: @32780
    GIM_Try, /*On fail goto*//*Label 881*/ 32836, // Rule ID 1657 //
      GIM_CheckFeatures, GIFBS_HasMips4_32_HasStdEnc_NotFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::AFGR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::AFGR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::AFGR64RegClassID,
      // (select:{ *:[f64] } GPR32:{ *:[i32] }:$cond, AFGR64:{ *:[f64] }:$T, AFGR64:{ *:[f64] }:$F)  =>  (MOVN_I_D32:{ *:[f64] } AFGR64:{ *:[f64] }:$T, GPR32:{ *:[i32] }:$cond, AFGR64:{ *:[f64] }:$F)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MOVN_I_D32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // T
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // cond
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // F
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1657,
      GIR_Done,
    // Label 881: @32836
    GIM_Try, /*On fail goto*//*Label 882*/ 32892, // Rule ID 1680 //
      GIM_CheckFeatures, GIFBS_HasMips4_32_HasStdEnc_IsFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::FGR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::FGR64RegClassID,
      // (select:{ *:[f64] } GPR32:{ *:[i32] }:$cond, FGR64:{ *:[f64] }:$T, FGR64:{ *:[f64] }:$F)  =>  (MOVN_I_D64:{ *:[f64] } FGR64:{ *:[f64] }:$T, GPR32:{ *:[i32] }:$cond, FGR64:{ *:[f64] }:$F)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MOVN_I_D64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // T
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // cond
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // F
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1680,
      GIR_Done,
    // Label 882: @32892
    GIM_Try, /*On fail goto*//*Label 883*/ 32948, // Rule ID 1683 //
      GIM_CheckFeatures, GIFBS_HasMips4_32_HasStdEnc_IsFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::FGR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::FGR64RegClassID,
      // (select:{ *:[f64] } GPR64:{ *:[i64] }:$cond, FGR64:{ *:[f64] }:$T, FGR64:{ *:[f64] }:$F)  =>  (MOVN_I64_D64:{ *:[f64] } FGR64:{ *:[f64] }:$T, GPR64:{ *:[i64] }:$cond, FGR64:{ *:[f64] }:$F)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MOVN_I64_D64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // T
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // cond
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // F
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1683,
      GIR_Done,
    // Label 883: @32948
    GIM_Try, /*On fail goto*//*Label 884*/ 33004, // Rule ID 2205 //
      GIM_CheckFeatures, GIFBS_InMicroMips_NotFP64bit_NotMips32r6,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::AFGR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::AFGR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::AFGR64RegClassID,
      // (select:{ *:[f64] } GPR32:{ *:[i32] }:$cond, AFGR64:{ *:[f64] }:$T, AFGR64:{ *:[f64] }:$F)  =>  (MOVN_I_D32_MM:{ *:[f64] } AFGR64:{ *:[f64] }:$T, GPR32:{ *:[i32] }:$cond, AFGR64:{ *:[f64] }:$F)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MOVN_I_D32_MM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // T
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // cond
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // F
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2205,
      GIR_Done,
    // Label 884: @33004
    GIM_Try, /*On fail goto*//*Label 885*/ 33084, // Rule ID 1716 //
      GIM_CheckFeatures, GIFBS_HasMips64r6_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      // (select:{ *:[i64] } i64:{ *:[i64] }:$cond, i64:{ *:[i64] }:$t, i64:{ *:[i64] }:$f)  =>  (OR64:{ *:[i64] } (SELNEZ64:{ *:[i64] } i64:{ *:[i64] }:$t, i64:{ *:[i64] }:$cond), (SELEQZ64:{ *:[i64] } i64:{ *:[i64] }:$f, i64:{ *:[i64] }:$cond))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/Mips::SELEQZ64,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // f
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // cond
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SELNEZ64,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // t
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // cond
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::OR64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1716,
      GIR_Done,
    // Label 885: @33084
    GIM_Try, /*On fail goto*//*Label 886*/ 33196, // Rule ID 1727 //
      GIM_CheckFeatures, GIFBS_HasMips64r6_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      // (select:{ *:[i64] } i32:{ *:[i32] }:$cond, i64:{ *:[i64] }:$t, i64:{ *:[i64] }:$f)  =>  (OR64:{ *:[i64] } (SELNEZ64:{ *:[i64] } i64:{ *:[i64] }:$t, (SLL64_32:{ *:[i64] } i32:{ *:[i32] }:$cond)), (SELEQZ64:{ *:[i64] } i64:{ *:[i64] }:$f, (SLL64_32:{ *:[i64] } i32:{ *:[i32] }:$cond)))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/Mips::SLL64_32,
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // cond
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/Mips::SELEQZ64,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/3, // f
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/Mips::SLL64_32,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // cond
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SELNEZ64,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // t
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::OR64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1727,
      GIR_Done,
    // Label 886: @33196
    GIM_Reject,
    // Label 861: @33197
    GIM_Reject,
    // Label 24: @33198
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 7, /*)*//*default:*//*Label 891*/ 34076,
    /*GILLT_s32*//*Label 887*/ 33210,
    /*GILLT_s64*//*Label 888*/ 33410, 0,
    /*GILLT_v2s64*//*Label 889*/ 33758, 0,
    /*GILLT_v4s32*//*Label 890*/ 33917,
    // Label 887: @33210
    GIM_Try, /*On fail goto*//*Label 892*/ 33409,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR32RegClassID,
      GIM_Try, /*On fail goto*//*Label 893*/ 33281, // Rule ID 145 //
        GIM_CheckFeatures, GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsNotSoftFloat_NotInMicroMips_NotMips32r6_NotMips64r6,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FMUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::FGR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::FGR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fadd:{ *:[f32] } (fmul:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft), FGR32Opnd:{ *:[f32] }:$fr)  =>  (MADD_S:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fr, FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MADD_S,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // fr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // fs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // ft
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 145,
        GIR_Done,
      // Label 893: @33281
      GIM_Try, /*On fail goto*//*Label 894*/ 33338, // Rule ID 2264 //
        GIM_CheckFeatures, GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsNotSoftFloat_NotInMicroMips_NotMips32r6_NotMips64r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FMUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::FGR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fadd:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fr, (fmul:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft))  =>  (MADD_S:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fr, FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MADD_S,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // fr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // fs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // ft
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2264,
        GIR_Done,
      // Label 894: @33338
      GIM_Try, /*On fail goto*//*Label 895*/ 33357, // Rule ID 133 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::FGR32RegClassID,
        // (fadd:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)  =>  (FADD_S:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FADD_S,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 133,
        GIR_Done,
      // Label 895: @33357
      GIM_Try, /*On fail goto*//*Label 896*/ 33376, // Rule ID 1098 //
        GIM_CheckFeatures, GIFBS_InMicroMips_IsNotSoftFloat,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::FGR32RegClassID,
        // (fadd:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)  =>  (FADD_S_MM:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FADD_S_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1098,
        GIR_Done,
      // Label 896: @33376
      GIM_Try, /*On fail goto*//*Label 897*/ 33408, // Rule ID 1154 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips_IsNotSoftFloat,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::FGR32RegClassID,
        // (fadd:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)  =>  (FADD_S_MMR6:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$ft, FGR32Opnd:{ *:[f32] }:$fs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FADD_S_MMR6,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ft
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // fs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1154,
        GIR_Done,
      // Label 897: @33408
      GIM_Reject,
    // Label 892: @33409
    GIM_Reject,
    // Label 888: @33410
    GIM_Try, /*On fail goto*//*Label 898*/ 33757,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 899*/ 33481, // Rule ID 147 //
        GIM_CheckFeatures, GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsNotSoftFloat_NotFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::AFGR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FMUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fadd:{ *:[f64] } (fmul:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft), AFGR64Opnd:{ *:[f64] }:$fr)  =>  (MADD_D32:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fr, AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MADD_D32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // fr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // fs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // ft
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 147,
        GIR_Done,
      // Label 899: @33481
      GIM_Try, /*On fail goto*//*Label 900*/ 33542, // Rule ID 149 //
        GIM_CheckFeatures, GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsFP64bit_IsNotSoftFloat_NotInMicroMips_NotMips32r6_NotMips64r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FMUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fadd:{ *:[f64] } (fmul:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fs, FGR64Opnd:{ *:[f64] }:$ft), FGR64Opnd:{ *:[f64] }:$fr)  =>  (MADD_D64:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fr, FGR64Opnd:{ *:[f64] }:$fs, FGR64Opnd:{ *:[f64] }:$ft)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MADD_D64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // fr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // fs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // ft
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 149,
        GIR_Done,
      // Label 900: @33542
      GIM_Try, /*On fail goto*//*Label 901*/ 33603, // Rule ID 2265 //
        GIM_CheckFeatures, GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsNotSoftFloat_NotFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::AFGR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FMUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fadd:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fr, (fmul:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft))  =>  (MADD_D32:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fr, AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MADD_D32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // fr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // fs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // ft
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2265,
        GIR_Done,
      // Label 901: @33603
      GIM_Try, /*On fail goto*//*Label 902*/ 33664, // Rule ID 2266 //
        GIM_CheckFeatures, GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsFP64bit_IsNotSoftFloat_NotInMicroMips_NotMips32r6_NotMips64r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FMUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fadd:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fr, (fmul:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fs, FGR64Opnd:{ *:[f64] }:$ft))  =>  (MADD_D64:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fr, FGR64Opnd:{ *:[f64] }:$fs, FGR64Opnd:{ *:[f64] }:$ft)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MADD_D64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // fr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // fs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // ft
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2266,
        GIR_Done,
      // Label 902: @33664
      GIM_Try, /*On fail goto*//*Label 903*/ 33687, // Rule ID 134 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_IsNotSoftFloat_NotFP64bit_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::AFGR64RegClassID,
        // (fadd:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft)  =>  (FADD_D32:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FADD_D32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 134,
        GIR_Done,
      // Label 903: @33687
      GIM_Try, /*On fail goto*//*Label 904*/ 33710, // Rule ID 135 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_IsFP64bit_IsNotSoftFloat_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::FGR64RegClassID,
        // (fadd:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fs, FGR64Opnd:{ *:[f64] }:$ft)  =>  (FADD_D64:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fs, FGR64Opnd:{ *:[f64] }:$ft)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FADD_D64,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 135,
        GIR_Done,
      // Label 904: @33710
      GIM_Try, /*On fail goto*//*Label 905*/ 33733, // Rule ID 1102 //
        GIM_CheckFeatures, GIFBS_InMicroMips_IsNotSoftFloat_NotFP64bit,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::AFGR64RegClassID,
        // (fadd:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft)  =>  (FADD_D32_MM:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FADD_D32_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1102,
        GIR_Done,
      // Label 905: @33733
      GIM_Try, /*On fail goto*//*Label 906*/ 33756, // Rule ID 1103 //
        GIM_CheckFeatures, GIFBS_InMicroMips_IsFP64bit_IsNotSoftFloat,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::FGR64RegClassID,
        // (fadd:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fs, FGR64Opnd:{ *:[f64] }:$ft)  =>  (FADD_D64_MM:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fs, FGR64Opnd:{ *:[f64] }:$ft)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FADD_D64_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1103,
        GIR_Done,
      // Label 906: @33756
      GIM_Reject,
    // Label 898: @33757
    GIM_Reject,
    // Label 889: @33758
    GIM_Try, /*On fail goto*//*Label 907*/ 33916,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 908*/ 33830, // Rule ID 2371 //
        GIM_CheckFeatures, GIFBS_AllowFPOpFusion_HasMSA_HasStdEnc,
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/0, /*OtherMI*/0, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FMUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fadd:{ *:[v2f64] } (fmul:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt), MSA128DOpnd:{ *:[v2f64] }:$wd)  =>  (FMADD_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$wd, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FMADD_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2371,
        GIR_Done,
      // Label 908: @33830
      GIM_Try, /*On fail goto*//*Label 909*/ 33892, // Rule ID 1911 //
        GIM_CheckFeatures, GIFBS_AllowFPOpFusion_HasMSA_HasStdEnc,
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/0, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FMUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fadd:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$wd, (fmul:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt))  =>  (FMADD_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$wd, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FMADD_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1911,
        GIR_Done,
      // Label 909: @33892
      GIM_Try, /*On fail goto*//*Label 910*/ 33915, // Rule ID 639 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        // (fadd:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FADD_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FADD_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 639,
        GIR_Done,
      // Label 910: @33915
      GIM_Reject,
    // Label 907: @33916
    GIM_Reject,
    // Label 890: @33917
    GIM_Try, /*On fail goto*//*Label 911*/ 34075,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 912*/ 33989, // Rule ID 2370 //
        GIM_CheckFeatures, GIFBS_AllowFPOpFusion_HasMSA_HasStdEnc,
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/0, /*OtherMI*/0, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FMUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fadd:{ *:[v4f32] } (fmul:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt), MSA128WOpnd:{ *:[v4f32] }:$wd)  =>  (FMADD_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$wd, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FMADD_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2370,
        GIR_Done,
      // Label 912: @33989
      GIM_Try, /*On fail goto*//*Label 913*/ 34051, // Rule ID 1910 //
        GIM_CheckFeatures, GIFBS_AllowFPOpFusion_HasMSA_HasStdEnc,
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/0, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FMUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fadd:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$wd, (fmul:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt))  =>  (FMADD_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$wd, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FMADD_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1910,
        GIR_Done,
      // Label 913: @34051
      GIM_Try, /*On fail goto*//*Label 914*/ 34074, // Rule ID 638 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // (fadd:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FADD_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FADD_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 638,
        GIR_Done,
      // Label 914: @34074
      GIM_Reject,
    // Label 911: @34075
    GIM_Reject,
    // Label 891: @34076
    GIM_Reject,
    // Label 25: @34077
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 7, /*)*//*default:*//*Label 919*/ 34652,
    /*GILLT_s32*//*Label 915*/ 34089,
    /*GILLT_s64*//*Label 916*/ 34232, 0,
    /*GILLT_v2s64*//*Label 917*/ 34458, 0,
    /*GILLT_v4s32*//*Label 918*/ 34555,
    // Label 915: @34089
    GIM_Try, /*On fail goto*//*Label 920*/ 34231,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR32RegClassID,
      GIM_Try, /*On fail goto*//*Label 921*/ 34160, // Rule ID 146 //
        GIM_CheckFeatures, GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsNotSoftFloat_NotInMicroMips_NotMips32r6_NotMips64r6,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FMUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::FGR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::FGR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fsub:{ *:[f32] } (fmul:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft), FGR32Opnd:{ *:[f32] }:$fr)  =>  (MSUB_S:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fr, FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MSUB_S,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // fr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // fs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // ft
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 146,
        GIR_Done,
      // Label 921: @34160
      GIM_Try, /*On fail goto*//*Label 922*/ 34179, // Rule ID 142 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::FGR32RegClassID,
        // (fsub:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)  =>  (FSUB_S:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FSUB_S,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 142,
        GIR_Done,
      // Label 922: @34179
      GIM_Try, /*On fail goto*//*Label 923*/ 34198, // Rule ID 1101 //
        GIM_CheckFeatures, GIFBS_InMicroMips_IsNotSoftFloat,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::FGR32RegClassID,
        // (fsub:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)  =>  (FSUB_S_MM:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FSUB_S_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1101,
        GIR_Done,
      // Label 923: @34198
      GIM_Try, /*On fail goto*//*Label 924*/ 34230, // Rule ID 1155 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips_IsNotSoftFloat,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::FGR32RegClassID,
        // (fsub:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)  =>  (FSUB_S_MMR6:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$ft, FGR32Opnd:{ *:[f32] }:$fs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSUB_S_MMR6,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ft
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // fs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1155,
        GIR_Done,
      // Label 924: @34230
      GIM_Reject,
    // Label 920: @34231
    GIM_Reject,
    // Label 916: @34232
    GIM_Try, /*On fail goto*//*Label 925*/ 34457,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 926*/ 34303, // Rule ID 148 //
        GIM_CheckFeatures, GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsNotSoftFloat_NotFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::AFGR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FMUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fsub:{ *:[f64] } (fmul:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft), AFGR64Opnd:{ *:[f64] }:$fr)  =>  (MSUB_D32:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fr, AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MSUB_D32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // fr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // fs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // ft
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 148,
        GIR_Done,
      // Label 926: @34303
      GIM_Try, /*On fail goto*//*Label 927*/ 34364, // Rule ID 150 //
        GIM_CheckFeatures, GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsFP64bit_IsNotSoftFloat_NotInMicroMips_NotMips32r6_NotMips64r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FMUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fsub:{ *:[f64] } (fmul:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fs, FGR64Opnd:{ *:[f64] }:$ft), FGR64Opnd:{ *:[f64] }:$fr)  =>  (MSUB_D64:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fr, FGR64Opnd:{ *:[f64] }:$fs, FGR64Opnd:{ *:[f64] }:$ft)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MSUB_D64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // fr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // fs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // ft
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 150,
        GIR_Done,
      // Label 927: @34364
      GIM_Try, /*On fail goto*//*Label 928*/ 34387, // Rule ID 143 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_IsNotSoftFloat_NotFP64bit_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::AFGR64RegClassID,
        // (fsub:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft)  =>  (FSUB_D32:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FSUB_D32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 143,
        GIR_Done,
      // Label 928: @34387
      GIM_Try, /*On fail goto*//*Label 929*/ 34410, // Rule ID 144 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_IsFP64bit_IsNotSoftFloat_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::FGR64RegClassID,
        // (fsub:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fs, FGR64Opnd:{ *:[f64] }:$ft)  =>  (FSUB_D64:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fs, FGR64Opnd:{ *:[f64] }:$ft)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FSUB_D64,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 144,
        GIR_Done,
      // Label 929: @34410
      GIM_Try, /*On fail goto*//*Label 930*/ 34433, // Rule ID 1108 //
        GIM_CheckFeatures, GIFBS_InMicroMips_IsNotSoftFloat_NotFP64bit,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::AFGR64RegClassID,
        // (fsub:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft)  =>  (FSUB_D32_MM:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FSUB_D32_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1108,
        GIR_Done,
      // Label 930: @34433
      GIM_Try, /*On fail goto*//*Label 931*/ 34456, // Rule ID 1109 //
        GIM_CheckFeatures, GIFBS_InMicroMips_IsFP64bit_IsNotSoftFloat,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::FGR64RegClassID,
        // (fsub:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fs, FGR64Opnd:{ *:[f64] }:$ft)  =>  (FSUB_D64_MM:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fs, FGR64Opnd:{ *:[f64] }:$ft)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FSUB_D64_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1109,
        GIR_Done,
      // Label 931: @34456
      GIM_Reject,
    // Label 925: @34457
    GIM_Reject,
    // Label 917: @34458
    GIM_Try, /*On fail goto*//*Label 932*/ 34554,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 933*/ 34530, // Rule ID 1909 //
        GIM_CheckFeatures, GIFBS_AllowFPOpFusion_HasMSA_HasStdEnc,
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/0, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FMUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fsub:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$wd, (fmul:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt))  =>  (FMSUB_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$wd, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FMSUB_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1909,
        GIR_Done,
      // Label 933: @34530
      GIM_Try, /*On fail goto*//*Label 934*/ 34553, // Rule ID 727 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        // (fsub:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSUB_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FSUB_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 727,
        GIR_Done,
      // Label 934: @34553
      GIM_Reject,
    // Label 932: @34554
    GIM_Reject,
    // Label 918: @34555
    GIM_Try, /*On fail goto*//*Label 935*/ 34651,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 936*/ 34627, // Rule ID 1908 //
        GIM_CheckFeatures, GIFBS_AllowFPOpFusion_HasMSA_HasStdEnc,
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/0, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FMUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fsub:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$wd, (fmul:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt))  =>  (FMSUB_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$wd, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FMSUB_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1908,
        GIR_Done,
      // Label 936: @34627
      GIM_Try, /*On fail goto*//*Label 937*/ 34650, // Rule ID 726 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // (fsub:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSUB_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FSUB_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 726,
        GIR_Done,
      // Label 937: @34650
      GIM_Reject,
    // Label 935: @34651
    GIM_Reject,
    // Label 919: @34652
    GIM_Reject,
    // Label 26: @34653
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 7, /*)*//*default:*//*Label 942*/ 35089,
    /*GILLT_s32*//*Label 938*/ 34665,
    /*GILLT_s64*//*Label 939*/ 34735, 0,
    /*GILLT_v2s64*//*Label 940*/ 34839, 0,
    /*GILLT_v4s32*//*Label 941*/ 34964,
    // Label 938: @34665
    GIM_Try, /*On fail goto*//*Label 943*/ 34734,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::FGR32RegClassID,
      GIM_Try, /*On fail goto*//*Label 944*/ 34698, // Rule ID 139 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
        // (fmul:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)  =>  (FMUL_S:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FMUL_S,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 139,
        GIR_Done,
      // Label 944: @34698
      GIM_Try, /*On fail goto*//*Label 945*/ 34709, // Rule ID 1100 //
        GIM_CheckFeatures, GIFBS_InMicroMips_IsNotSoftFloat,
        // (fmul:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)  =>  (FMUL_S_MM:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FMUL_S_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1100,
        GIR_Done,
      // Label 945: @34709
      GIM_Try, /*On fail goto*//*Label 946*/ 34733, // Rule ID 1156 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips_IsNotSoftFloat,
        // (fmul:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)  =>  (FMUL_S_MMR6:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$ft, FGR32Opnd:{ *:[f32] }:$fs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FMUL_S_MMR6,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ft
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // fs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1156,
        GIR_Done,
      // Label 946: @34733
      GIM_Reject,
    // Label 943: @34734
    GIM_Reject,
    // Label 939: @34735
    GIM_Try, /*On fail goto*//*Label 947*/ 34838,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 948*/ 34768, // Rule ID 140 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_IsNotSoftFloat_NotFP64bit_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::AFGR64RegClassID,
        // (fmul:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft)  =>  (FMUL_D32:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FMUL_D32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 140,
        GIR_Done,
      // Label 948: @34768
      GIM_Try, /*On fail goto*//*Label 949*/ 34791, // Rule ID 141 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_IsFP64bit_IsNotSoftFloat_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::FGR64RegClassID,
        // (fmul:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fs, FGR64Opnd:{ *:[f64] }:$ft)  =>  (FMUL_D64:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fs, FGR64Opnd:{ *:[f64] }:$ft)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FMUL_D64,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 141,
        GIR_Done,
      // Label 949: @34791
      GIM_Try, /*On fail goto*//*Label 950*/ 34814, // Rule ID 1106 //
        GIM_CheckFeatures, GIFBS_InMicroMips_IsNotSoftFloat_NotFP64bit,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::AFGR64RegClassID,
        // (fmul:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft)  =>  (FMUL_D32_MM:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FMUL_D32_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1106,
        GIR_Done,
      // Label 950: @34814
      GIM_Try, /*On fail goto*//*Label 951*/ 34837, // Rule ID 1107 //
        GIM_CheckFeatures, GIFBS_InMicroMips_IsFP64bit_IsNotSoftFloat,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::FGR64RegClassID,
        // (fmul:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fs, FGR64Opnd:{ *:[f64] }:$ft)  =>  (FMUL_D64_MM:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fs, FGR64Opnd:{ *:[f64] }:$ft)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FMUL_D64_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1107,
        GIR_Done,
      // Label 951: @34837
      GIM_Reject,
    // Label 947: @34838
    GIM_Reject,
    // Label 940: @34839
    GIM_Try, /*On fail goto*//*Label 952*/ 34963,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_Try, /*On fail goto*//*Label 953*/ 34898, // Rule ID 2312 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FEXP2,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fmul:{ *:[v2f64] } (fexp2:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$wt), MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FEXP2_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FEXP2_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2312,
        GIR_Done,
      // Label 953: @34898
      GIM_Try, /*On fail goto*//*Label 954*/ 34943, // Rule ID 669 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FEXP2,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fmul:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, (fexp2:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$wt))  =>  (FEXP2_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FEXP2_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 669,
        GIR_Done,
      // Label 954: @34943
      GIM_Try, /*On fail goto*//*Label 955*/ 34962, // Rule ID 705 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        // (fmul:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FMUL_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FMUL_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 705,
        GIR_Done,
      // Label 955: @34962
      GIM_Reject,
    // Label 952: @34963
    GIM_Reject,
    // Label 941: @34964
    GIM_Try, /*On fail goto*//*Label 956*/ 35088,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_Try, /*On fail goto*//*Label 957*/ 35023, // Rule ID 2311 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FEXP2,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fmul:{ *:[v4f32] } (fexp2:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$wt), MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FEXP2_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FEXP2_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2311,
        GIR_Done,
      // Label 957: @35023
      GIM_Try, /*On fail goto*//*Label 958*/ 35068, // Rule ID 668 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FEXP2,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (fmul:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, (fexp2:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$wt))  =>  (FEXP2_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FEXP2_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 668,
        GIR_Done,
      // Label 958: @35068
      GIM_Try, /*On fail goto*//*Label 959*/ 35087, // Rule ID 704 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // (fmul:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FMUL_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FMUL_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 704,
        GIR_Done,
      // Label 959: @35087
      GIM_Reject,
    // Label 956: @35088
    GIM_Reject,
    // Label 942: @35089
    GIM_Reject,
    // Label 27: @35090
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/4, 7, /*)*//*default:*//*Label 962*/ 35179,
    /*GILLT_v2s64*//*Label 960*/ 35099, 0,
    /*GILLT_v4s32*//*Label 961*/ 35139,
    // Label 960: @35099
    GIM_Try, /*On fail goto*//*Label 963*/ 35138, // Rule ID 693 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
      // (fma:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$wd_in, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FMADD_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$wd_in, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FMADD_D,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 693,
      GIR_Done,
    // Label 963: @35138
    GIM_Reject,
    // Label 961: @35139
    GIM_Try, /*On fail goto*//*Label 964*/ 35178, // Rule ID 692 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
      // (fma:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$wd_in, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FMADD_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$wd_in, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FMADD_W,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 692,
      GIR_Done,
    // Label 964: @35178
    GIM_Reject,
    // Label 962: @35179
    GIM_Reject,
    // Label 28: @35180
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 7, /*)*//*default:*//*Label 969*/ 35430,
    /*GILLT_s32*//*Label 965*/ 35192,
    /*GILLT_s64*//*Label 966*/ 35262, 0,
    /*GILLT_v2s64*//*Label 967*/ 35366, 0,
    /*GILLT_v4s32*//*Label 968*/ 35398,
    // Label 965: @35192
    GIM_Try, /*On fail goto*//*Label 970*/ 35261,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::FGR32RegClassID,
      GIM_Try, /*On fail goto*//*Label 971*/ 35225, // Rule ID 136 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
        // (fdiv:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)  =>  (FDIV_S:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FDIV_S,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 136,
        GIR_Done,
      // Label 971: @35225
      GIM_Try, /*On fail goto*//*Label 972*/ 35236, // Rule ID 1099 //
        GIM_CheckFeatures, GIFBS_InMicroMips_IsNotSoftFloat,
        // (fdiv:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)  =>  (FDIV_S_MM:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FDIV_S_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1099,
        GIR_Done,
      // Label 972: @35236
      GIM_Try, /*On fail goto*//*Label 973*/ 35260, // Rule ID 1157 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips_IsNotSoftFloat,
        // (fdiv:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)  =>  (FDIV_S_MMR6:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$ft, FGR32Opnd:{ *:[f32] }:$fs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FDIV_S_MMR6,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ft
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // fs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1157,
        GIR_Done,
      // Label 973: @35260
      GIM_Reject,
    // Label 970: @35261
    GIM_Reject,
    // Label 966: @35262
    GIM_Try, /*On fail goto*//*Label 974*/ 35365,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 975*/ 35295, // Rule ID 137 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_IsNotSoftFloat_NotFP64bit_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::AFGR64RegClassID,
        // (fdiv:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft)  =>  (FDIV_D32:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FDIV_D32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 137,
        GIR_Done,
      // Label 975: @35295
      GIM_Try, /*On fail goto*//*Label 976*/ 35318, // Rule ID 138 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_IsFP64bit_IsNotSoftFloat_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::FGR64RegClassID,
        // (fdiv:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fs, FGR64Opnd:{ *:[f64] }:$ft)  =>  (FDIV_D64:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fs, FGR64Opnd:{ *:[f64] }:$ft)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FDIV_D64,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 138,
        GIR_Done,
      // Label 976: @35318
      GIM_Try, /*On fail goto*//*Label 977*/ 35341, // Rule ID 1104 //
        GIM_CheckFeatures, GIFBS_InMicroMips_IsNotSoftFloat_NotFP64bit,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::AFGR64RegClassID,
        // (fdiv:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft)  =>  (FDIV_D32_MM:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FDIV_D32_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1104,
        GIR_Done,
      // Label 977: @35341
      GIM_Try, /*On fail goto*//*Label 978*/ 35364, // Rule ID 1105 //
        GIM_CheckFeatures, GIFBS_InMicroMips_IsFP64bit_IsNotSoftFloat,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::FGR64RegClassID,
        // (fdiv:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fs, FGR64Opnd:{ *:[f64] }:$ft)  =>  (FDIV_D64_MM:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fs, FGR64Opnd:{ *:[f64] }:$ft)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FDIV_D64_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1105,
        GIR_Done,
      // Label 978: @35364
      GIM_Reject,
    // Label 974: @35365
    GIM_Reject,
    // Label 967: @35366
    GIM_Try, /*On fail goto*//*Label 979*/ 35397, // Rule ID 665 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
      // (fdiv:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FDIV_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FDIV_D,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 665,
      GIR_Done,
    // Label 979: @35397
    GIM_Reject,
    // Label 968: @35398
    GIM_Try, /*On fail goto*//*Label 980*/ 35429, // Rule ID 664 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
      // (fdiv:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FDIV_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FDIV_W,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 664,
      GIR_Done,
    // Label 980: @35429
    GIM_Reject,
    // Label 969: @35430
    GIM_Reject,
    // Label 29: @35431
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/4, 7, /*)*//*default:*//*Label 983*/ 35488,
    /*GILLT_v2s64*//*Label 981*/ 35440, 0,
    /*GILLT_v4s32*//*Label 982*/ 35464,
    // Label 981: @35440
    GIM_Try, /*On fail goto*//*Label 984*/ 35463, // Rule ID 671 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      // (fexp2:{ *:[v2f64] } MSA128D:{ *:[v2f64] }:$ws)  =>  (FEXP2_D_1_PSEUDO:{ *:[v2f64] } MSA128D:{ *:[v2f64] }:$ws)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FEXP2_D_1_PSEUDO,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 671,
      GIR_Done,
    // Label 984: @35463
    GIM_Reject,
    // Label 982: @35464
    GIM_Try, /*On fail goto*//*Label 985*/ 35487, // Rule ID 670 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
      // (fexp2:{ *:[v4f32] } MSA128W:{ *:[v4f32] }:$ws)  =>  (FEXP2_W_1_PSEUDO:{ *:[v4f32] } MSA128W:{ *:[v4f32] }:$ws)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FEXP2_W_1_PSEUDO,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 670,
      GIR_Done,
    // Label 985: @35487
    GIM_Reject,
    // Label 983: @35488
    GIM_Reject,
    // Label 30: @35489
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/4, 7, /*)*//*default:*//*Label 988*/ 35546,
    /*GILLT_v2s64*//*Label 986*/ 35498, 0,
    /*GILLT_v4s32*//*Label 987*/ 35522,
    // Label 986: @35498
    GIM_Try, /*On fail goto*//*Label 989*/ 35521, // Rule ID 691 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      // (flog2:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FLOG2_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FLOG2_D,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 691,
      GIR_Done,
    // Label 989: @35521
    GIM_Reject,
    // Label 987: @35522
    GIM_Try, /*On fail goto*//*Label 990*/ 35545, // Rule ID 690 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
      // (flog2:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FLOG2_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FLOG2_W,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 690,
      GIR_Done,
    // Label 990: @35545
    GIM_Reject,
    // Label 988: @35546
    GIM_Reject,
    // Label 31: @35547
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 993*/ 36842,
    /*GILLT_s32*//*Label 991*/ 35555,
    /*GILLT_s64*//*Label 992*/ 36056,
    // Label 991: @35555
    GIM_Try, /*On fail goto*//*Label 994*/ 36055,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR32RegClassID,
      GIM_Try, /*On fail goto*//*Label 995*/ 35639, // Rule ID 1423 //
        GIM_CheckFeatures, GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_NoNaNsFPMath_NotInMicroMips_NotMips32r6_NotMips64r6,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FADD,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FMUL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/Mips::FGR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::FGR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (fneg:{ *:[f32] } (fadd:{ *:[f32] } (fmul:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft), FGR32Opnd:{ *:[f32] }:$fr))  =>  (NMADD_S:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fr, FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NMADD_S,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // fr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // fs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // ft
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1423,
        GIR_Done,
      // Label 995: @35639
      GIM_Try, /*On fail goto*//*Label 996*/ 35713, // Rule ID 2163 //
        GIM_CheckFeatures, GIFBS_HasMadd4_InMicroMips_InMicroMips_NoNaNsFPMath_NotMips32r6_NotMips32r6,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FADD,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FMUL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/Mips::FGR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::FGR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (fneg:{ *:[f32] } (fadd:{ *:[f32] } (fmul:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft), FGR32Opnd:{ *:[f32] }:$fr))  =>  (NMADD_S_MM:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fr, FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NMADD_S_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // fr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // fs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // ft
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2163,
        GIR_Done,
      // Label 996: @35713
      GIM_Try, /*On fail goto*//*Label 997*/ 35787, // Rule ID 2346 //
        GIM_CheckFeatures, GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_NoNaNsFPMath_NotInMicroMips_NotMips32r6_NotMips64r6,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FADD,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FMUL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/Mips::FGR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (fneg:{ *:[f32] } (fadd:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fr, (fmul:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)))  =>  (NMADD_S:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fr, FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NMADD_S,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // fr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // fs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // ft
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2346,
        GIR_Done,
      // Label 997: @35787
      GIM_Try, /*On fail goto*//*Label 998*/ 35861, // Rule ID 2443 //
        GIM_CheckFeatures, GIFBS_HasMadd4_InMicroMips_InMicroMips_NoNaNsFPMath_NotMips32r6_NotMips32r6,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FADD,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FMUL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/Mips::FGR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (fneg:{ *:[f32] } (fadd:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fr, (fmul:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)))  =>  (NMADD_S_MM:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fr, FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NMADD_S_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // fr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // fs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // ft
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2443,
        GIR_Done,
      // Label 998: @35861
      GIM_Try, /*On fail goto*//*Label 999*/ 35935, // Rule ID 1424 //
        GIM_CheckFeatures, GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_NoNaNsFPMath_NotInMicroMips_NotMips32r6_NotMips64r6,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FSUB,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FMUL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/Mips::FGR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::FGR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (fneg:{ *:[f32] } (fsub:{ *:[f32] } (fmul:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft), FGR32Opnd:{ *:[f32] }:$fr))  =>  (NMSUB_S:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fr, FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NMSUB_S,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // fr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // fs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // ft
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1424,
        GIR_Done,
      // Label 999: @35935
      GIM_Try, /*On fail goto*//*Label 1000*/ 36009, // Rule ID 2164 //
        GIM_CheckFeatures, GIFBS_HasMadd4_InMicroMips_InMicroMips_NoNaNsFPMath_NotMips32r6_NotMips32r6,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FSUB,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FMUL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/Mips::FGR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::FGR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (fneg:{ *:[f32] } (fsub:{ *:[f32] } (fmul:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft), FGR32Opnd:{ *:[f32] }:$fr))  =>  (NMSUB_S_MM:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fr, FGR32Opnd:{ *:[f32] }:$fs, FGR32Opnd:{ *:[f32] }:$ft)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NMSUB_S_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // fr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // fs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // ft
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2164,
        GIR_Done,
      // Label 1000: @36009
      GIM_Try, /*On fail goto*//*Label 1001*/ 36024, // Rule ID 111 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_IsNotSoftFloat,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
        // (fneg:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs)  =>  (FNEG_S:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FNEG_S,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 111,
        GIR_Done,
      // Label 1001: @36024
      GIM_Try, /*On fail goto*//*Label 1002*/ 36039, // Rule ID 1121 //
        GIM_CheckFeatures, GIFBS_InMicroMips_IsNotSoftFloat,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
        // (fneg:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs)  =>  (FNEG_S_MM:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FNEG_S_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1121,
        GIR_Done,
      // Label 1002: @36039
      GIM_Try, /*On fail goto*//*Label 1003*/ 36054, // Rule ID 1158 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips_IsNotSoftFloat,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
        // (fneg:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs)  =>  (FNEG_S_MMR6:{ *:[f32] } FGR32Opnd:{ *:[f32] }:$fs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FNEG_S_MMR6,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1158,
        GIR_Done,
      // Label 1003: @36054
      GIM_Reject,
    // Label 994: @36055
    GIM_Reject,
    // Label 992: @36056
    GIM_Try, /*On fail goto*//*Label 1004*/ 36841,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 1005*/ 36140, // Rule ID 1425 //
        GIM_CheckFeatures, GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_NoNaNsFPMath_NotFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::AFGR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FADD,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FMUL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (fneg:{ *:[f64] } (fadd:{ *:[f64] } (fmul:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft), AFGR64Opnd:{ *:[f64] }:$fr))  =>  (NMADD_D32:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fr, AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NMADD_D32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // fr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // fs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // ft
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1425,
        GIR_Done,
      // Label 1005: @36140
      GIM_Try, /*On fail goto*//*Label 1006*/ 36218, // Rule ID 1427 //
        GIM_CheckFeatures, GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsFP64bit_NoNaNsFPMath_NotInMicroMips_NotMips32r6_NotMips64r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FADD,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FMUL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (fneg:{ *:[f64] } (fadd:{ *:[f64] } (fmul:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fs, FGR64Opnd:{ *:[f64] }:$ft), FGR64Opnd:{ *:[f64] }:$fr))  =>  (NMADD_D64:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fr, FGR64Opnd:{ *:[f64] }:$fs, FGR64Opnd:{ *:[f64] }:$ft)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NMADD_D64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // fr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // fs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // ft
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1427,
        GIR_Done,
      // Label 1006: @36218
      GIM_Try, /*On fail goto*//*Label 1007*/ 36296, // Rule ID 2165 //
        GIM_CheckFeatures, GIFBS_HasMadd4_InMicroMips_InMicroMips_NoNaNsFPMath_NotFP64bit_NotMips32r6_NotMips32r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::AFGR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FADD,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FMUL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (fneg:{ *:[f64] } (fadd:{ *:[f64] } (fmul:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft), AFGR64Opnd:{ *:[f64] }:$fr))  =>  (NMADD_D32_MM:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fr, AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NMADD_D32_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // fr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // fs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // ft
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2165,
        GIR_Done,
      // Label 1007: @36296
      GIM_Try, /*On fail goto*//*Label 1008*/ 36374, // Rule ID 2347 //
        GIM_CheckFeatures, GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_NoNaNsFPMath_NotFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::AFGR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FADD,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::AFGR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FMUL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (fneg:{ *:[f64] } (fadd:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fr, (fmul:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft)))  =>  (NMADD_D32:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fr, AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NMADD_D32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // fr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // fs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // ft
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2347,
        GIR_Done,
      // Label 1008: @36374
      GIM_Try, /*On fail goto*//*Label 1009*/ 36452, // Rule ID 2348 //
        GIM_CheckFeatures, GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsFP64bit_NoNaNsFPMath_NotInMicroMips_NotMips32r6_NotMips64r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FADD,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::FGR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FMUL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (fneg:{ *:[f64] } (fadd:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fr, (fmul:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fs, FGR64Opnd:{ *:[f64] }:$ft)))  =>  (NMADD_D64:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fr, FGR64Opnd:{ *:[f64] }:$fs, FGR64Opnd:{ *:[f64] }:$ft)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NMADD_D64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // fr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // fs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // ft
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2348,
        GIR_Done,
      // Label 1009: @36452
      GIM_Try, /*On fail goto*//*Label 1010*/ 36530, // Rule ID 2444 //
        GIM_CheckFeatures, GIFBS_HasMadd4_InMicroMips_InMicroMips_NoNaNsFPMath_NotFP64bit_NotMips32r6_NotMips32r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::AFGR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FADD,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::AFGR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FMUL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (fneg:{ *:[f64] } (fadd:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fr, (fmul:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft)))  =>  (NMADD_D32_MM:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fr, AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NMADD_D32_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // fr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // fs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // ft
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2444,
        GIR_Done,
      // Label 1010: @36530
      GIM_Try, /*On fail goto*//*Label 1011*/ 36608, // Rule ID 1426 //
        GIM_CheckFeatures, GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_NoNaNsFPMath_NotFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::AFGR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FSUB,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FMUL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (fneg:{ *:[f64] } (fsub:{ *:[f64] } (fmul:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft), AFGR64Opnd:{ *:[f64] }:$fr))  =>  (NMSUB_D32:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fr, AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NMSUB_D32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // fr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // fs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // ft
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1426,
        GIR_Done,
      // Label 1011: @36608
      GIM_Try, /*On fail goto*//*Label 1012*/ 36686, // Rule ID 1428 //
        GIM_CheckFeatures, GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsFP64bit_NoNaNsFPMath_NotInMicroMips_NotMips32r6_NotMips64r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FSUB,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FMUL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (fneg:{ *:[f64] } (fsub:{ *:[f64] } (fmul:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fs, FGR64Opnd:{ *:[f64] }:$ft), FGR64Opnd:{ *:[f64] }:$fr))  =>  (NMSUB_D64:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fr, FGR64Opnd:{ *:[f64] }:$fs, FGR64Opnd:{ *:[f64] }:$ft)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NMSUB_D64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // fr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // fs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // ft
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1428,
        GIR_Done,
      // Label 1012: @36686
      GIM_Try, /*On fail goto*//*Label 1013*/ 36764, // Rule ID 2166 //
        GIM_CheckFeatures, GIFBS_HasMadd4_InMicroMips_InMicroMips_NoNaNsFPMath_NotFP64bit_NotMips32r6_NotMips32r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::AFGR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_FSUB,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_FMUL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (fneg:{ *:[f64] } (fsub:{ *:[f64] } (fmul:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft), AFGR64Opnd:{ *:[f64] }:$fr))  =>  (NMSUB_D32_MM:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fr, AFGR64Opnd:{ *:[f64] }:$fs, AFGR64Opnd:{ *:[f64] }:$ft)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NMSUB_D32_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // fd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // fr
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // fs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // ft
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2166,
        GIR_Done,
      // Label 1013: @36764
      GIM_Try, /*On fail goto*//*Label 1014*/ 36783, // Rule ID 112 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_IsNotSoftFloat_NotFP64bit_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::AFGR64RegClassID,
        // (fneg:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fs)  =>  (FNEG_D32:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FNEG_D32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 112,
        GIR_Done,
      // Label 1014: @36783
      GIM_Try, /*On fail goto*//*Label 1015*/ 36802, // Rule ID 113 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_IsFP64bit_IsNotSoftFloat_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR64RegClassID,
        // (fneg:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fs)  =>  (FNEG_D64:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FNEG_D64,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 113,
        GIR_Done,
      // Label 1015: @36802
      GIM_Try, /*On fail goto*//*Label 1016*/ 36821, // Rule ID 1122 //
        GIM_CheckFeatures, GIFBS_InMicroMips_IsNotSoftFloat_NotFP64bit,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::AFGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::AFGR64RegClassID,
        // (fneg:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fs)  =>  (FNEG_D32_MM:{ *:[f64] } AFGR64Opnd:{ *:[f64] }:$fs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FNEG_D32_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1122,
        GIR_Done,
      // Label 1016: @36821
      GIM_Try, /*On fail goto*//*Label 1017*/ 36840, // Rule ID 1123 //
        GIM_CheckFeatures, GIFBS_InMicroMips_IsFP64bit_IsNotSoftFloat,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR64RegClassID,
        // (fneg:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fs)  =>  (FNEG_D64_MM:{ *:[f64] } FGR64Opnd:{ *:[f64] }:$fs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FNEG_D64_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1123,
        GIR_Done,
      // Label 1017: @36840
      GIM_Reject,
    // Label 1004: @36841
    GIM_Reject,
    // Label 993: @36842
    GIM_Reject,
    // Label 32: @36843
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 1020*/ 36991,
    /*GILLT_s32*//*Label 1018*/ 36851,
    /*GILLT_s64*//*Label 1019*/ 36875,
    // Label 1018: @36851
    GIM_Try, /*On fail goto*//*Label 1021*/ 36874, // Rule ID 1024 //
      GIM_CheckFeatures, GIFBS_HasMSA,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128F16RegClassID,
      // (fpextend:{ *:[f32] } MSA128F16:{ *:[f16] }:$ws)  =>  (MSA_FP_EXTEND_W_PSEUDO:{ *:[f32] } MSA128F16:{ *:[f16] }:$ws)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MSA_FP_EXTEND_W_PSEUDO,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1024,
      GIR_Done,
    // Label 1021: @36874
    GIM_Reject,
    // Label 1019: @36875
    GIM_Try, /*On fail goto*//*Label 1022*/ 36898, // Rule ID 1026 //
      GIM_CheckFeatures, GIFBS_HasMSA,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128F16RegClassID,
      // (fpextend:{ *:[f64] } MSA128F16:{ *:[f16] }:$ws)  =>  (MSA_FP_EXTEND_D_PSEUDO:{ *:[f64] } MSA128F16:{ *:[f16] }:$ws)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MSA_FP_EXTEND_D_PSEUDO,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1026,
      GIR_Done,
    // Label 1022: @36898
    GIM_Try, /*On fail goto*//*Label 1023*/ 36921, // Rule ID 1412 //
      GIM_CheckFeatures, GIFBS_HasStdEnc_NotFP64bit_NotInMicroMips,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::AFGR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
      // (fpextend:{ *:[f64] } FGR32Opnd:{ *:[f32] }:$src)  =>  (CVT_D32_S:{ *:[f64] } FGR32Opnd:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::CVT_D32_S,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1412,
      GIR_Done,
    // Label 1023: @36921
    GIM_Try, /*On fail goto*//*Label 1024*/ 36944, // Rule ID 1422 //
      GIM_CheckFeatures, GIFBS_HasStdEnc_IsFP64bit_NotInMicroMips,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
      // (fpextend:{ *:[f64] } FGR32Opnd:{ *:[f32] }:$src)  =>  (CVT_D64_S:{ *:[f64] } FGR32Opnd:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::CVT_D64_S,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1422,
      GIR_Done,
    // Label 1024: @36944
    GIM_Try, /*On fail goto*//*Label 1025*/ 36967, // Rule ID 2175 //
      GIM_CheckFeatures, GIFBS_InMicroMips_IsFP64bit,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
      // (fpextend:{ *:[f64] } FGR32Opnd:{ *:[f32] }:$src)  =>  (CVT_D64_S_MM:{ *:[f64] } FGR32Opnd:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::CVT_D64_S_MM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2175,
      GIR_Done,
    // Label 1025: @36967
    GIM_Try, /*On fail goto*//*Label 1026*/ 36990, // Rule ID 2177 //
      GIM_CheckFeatures, GIFBS_InMicroMips_NotFP64bit,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::AFGR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
      // (fpextend:{ *:[f64] } FGR32Opnd:{ *:[f32] }:$src)  =>  (CVT_D32_S_MM:{ *:[f64] } FGR32Opnd:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::CVT_D32_S_MM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2177,
      GIR_Done,
    // Label 1026: @36990
    GIM_Reject,
    // Label 1020: @36991
    GIM_Reject,
    // Label 33: @36992
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/0, 2, /*)*//*default:*//*Label 1029*/ 37119,
    /*GILLT_s16*//*Label 1027*/ 37000,
    /*GILLT_s32*//*Label 1028*/ 37047,
    // Label 1027: @37000
    GIM_Try, /*On fail goto*//*Label 1030*/ 37023, // Rule ID 1025 //
      GIM_CheckFeatures, GIFBS_HasMSA,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128F16RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
      // (fpround:{ *:[f16] } FGR32Opnd:{ *:[f32] }:$fs)  =>  (MSA_FP_ROUND_W_PSEUDO:{ *:[f16] } FGR32Opnd:{ *:[f32] }:$fs)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MSA_FP_ROUND_W_PSEUDO,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1025,
      GIR_Done,
    // Label 1030: @37023
    GIM_Try, /*On fail goto*//*Label 1031*/ 37046, // Rule ID 1027 //
      GIM_CheckFeatures, GIFBS_HasMSA,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128F16RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR64RegClassID,
      // (fpround:{ *:[f16] } FGR64Opnd:{ *:[f64] }:$fs)  =>  (MSA_FP_ROUND_D_PSEUDO:{ *:[f16] } FGR64Opnd:{ *:[f64] }:$fs)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MSA_FP_ROUND_D_PSEUDO,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1027,
      GIR_Done,
    // Label 1031: @37046
    GIM_Reject,
    // Label 1028: @37047
    GIM_Try, /*On fail goto*//*Label 1032*/ 37118,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR32RegClassID,
      GIM_Try, /*On fail goto*//*Label 1033*/ 37072, // Rule ID 1411 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotFP64bit_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::AFGR64RegClassID,
        // (fpround:{ *:[f32] } AFGR64Opnd:{ *:[f64] }:$src)  =>  (CVT_S_D32:{ *:[f32] } AFGR64Opnd:{ *:[f64] }:$src)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::CVT_S_D32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1411,
        GIR_Done,
      // Label 1033: @37072
      GIM_Try, /*On fail goto*//*Label 1034*/ 37087, // Rule ID 1421 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_IsFP64bit_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR64RegClassID,
        // (fpround:{ *:[f32] } FGR64Opnd:{ *:[f64] }:$src)  =>  (CVT_S_D64:{ *:[f32] } FGR64Opnd:{ *:[f64] }:$src)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::CVT_S_D64,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1421,
        GIR_Done,
      // Label 1034: @37087
      GIM_Try, /*On fail goto*//*Label 1035*/ 37102, // Rule ID 2174 //
        GIM_CheckFeatures, GIFBS_InMicroMips_IsFP64bit,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR64RegClassID,
        // (fpround:{ *:[f32] } FGR64Opnd:{ *:[f64] }:$src)  =>  (CVT_S_D64_MM:{ *:[f32] } FGR64Opnd:{ *:[f64] }:$src)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::CVT_S_D64_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2174,
        GIR_Done,
      // Label 1035: @37102
      GIM_Try, /*On fail goto*//*Label 1036*/ 37117, // Rule ID 2176 //
        GIM_CheckFeatures, GIFBS_InMicroMips_NotFP64bit,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::AFGR64RegClassID,
        // (fpround:{ *:[f32] } AFGR64Opnd:{ *:[f64] }:$src)  =>  (CVT_S_D32_MM:{ *:[f32] } AFGR64Opnd:{ *:[f64] }:$src)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::CVT_S_D32_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2176,
        GIR_Done,
      // Label 1036: @37117
      GIM_Reject,
    // Label 1032: @37118
    GIM_Reject,
    // Label 1029: @37119
    GIM_Reject,
    // Label 34: @37120
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/4, 7, /*)*//*default:*//*Label 1039*/ 37177,
    /*GILLT_v2s64*//*Label 1037*/ 37129, 0,
    /*GILLT_v4s32*//*Label 1038*/ 37153,
    // Label 1037: @37129
    GIM_Try, /*On fail goto*//*Label 1040*/ 37152, // Rule ID 745 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      // (fp_to_sint:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FTRUNC_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FTRUNC_S_D,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 745,
      GIR_Done,
    // Label 1040: @37152
    GIM_Reject,
    // Label 1038: @37153
    GIM_Try, /*On fail goto*//*Label 1041*/ 37176, // Rule ID 744 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
      // (fp_to_sint:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FTRUNC_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FTRUNC_S_W,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 744,
      GIR_Done,
    // Label 1041: @37176
    GIM_Reject,
    // Label 1039: @37177
    GIM_Reject,
    // Label 35: @37178
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/4, 7, /*)*//*default:*//*Label 1044*/ 37235,
    /*GILLT_v2s64*//*Label 1042*/ 37187, 0,
    /*GILLT_v4s32*//*Label 1043*/ 37211,
    // Label 1042: @37187
    GIM_Try, /*On fail goto*//*Label 1045*/ 37210, // Rule ID 747 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      // (fp_to_uint:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FTRUNC_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FTRUNC_U_D,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 747,
      GIR_Done,
    // Label 1045: @37210
    GIM_Reject,
    // Label 1043: @37211
    GIM_Try, /*On fail goto*//*Label 1046*/ 37234, // Rule ID 746 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
      // (fp_to_uint:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FTRUNC_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FTRUNC_U_W,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 746,
      GIR_Done,
    // Label 1046: @37234
    GIM_Reject,
    // Label 1044: @37235
    GIM_Reject,
    // Label 36: @37236
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 7, /*)*//*default:*//*Label 1051*/ 37388,
    /*GILLT_s32*//*Label 1047*/ 37248,
    /*GILLT_s64*//*Label 1048*/ 37270, 0,
    /*GILLT_v2s64*//*Label 1049*/ 37340, 0,
    /*GILLT_v4s32*//*Label 1050*/ 37364,
    // Label 1047: @37248
    GIM_Try, /*On fail goto*//*Label 1052*/ 37269, // Rule ID 1406 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      // (sint_to_fp:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$src)  =>  (PseudoCVT_S_W:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::PseudoCVT_S_W,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1406,
      GIR_Done,
    // Label 1052: @37269
    GIM_Reject,
    // Label 1048: @37270
    GIM_Try, /*On fail goto*//*Label 1053*/ 37293, // Rule ID 1409 //
      GIM_CheckFeatures, GIFBS_NotFP64bit,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::AFGR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      // (sint_to_fp:{ *:[f64] } GPR32Opnd:{ *:[i32] }:$src)  =>  (PseudoCVT_D32_W:{ *:[f64] } GPR32Opnd:{ *:[i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::PseudoCVT_D32_W,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1409,
      GIR_Done,
    // Label 1053: @37293
    GIM_Try, /*On fail goto*//*Label 1054*/ 37316, // Rule ID 1415 //
      GIM_CheckFeatures, GIFBS_IsFP64bit,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      // (sint_to_fp:{ *:[f64] } GPR32Opnd:{ *:[i32] }:$src)  =>  (PseudoCVT_D64_W:{ *:[f64] } GPR32Opnd:{ *:[i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::PseudoCVT_D64_W,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1415,
      GIR_Done,
    // Label 1054: @37316
    GIM_Try, /*On fail goto*//*Label 1055*/ 37339, // Rule ID 1417 //
      GIM_CheckFeatures, GIFBS_IsFP64bit,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
      // (sint_to_fp:{ *:[f64] } GPR64Opnd:{ *:[i64] }:$src)  =>  (PseudoCVT_D64_L:{ *:[f64] } GPR64Opnd:{ *:[i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::PseudoCVT_D64_L,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1417,
      GIR_Done,
    // Label 1055: @37339
    GIM_Reject,
    // Label 1049: @37340
    GIM_Try, /*On fail goto*//*Label 1056*/ 37363, // Rule ID 677 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      // (sint_to_fp:{ *:[v2f64] } MSA128DOpnd:{ *:[v2i64] }:$ws)  =>  (FFINT_S_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2i64] }:$ws)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FFINT_S_D,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 677,
      GIR_Done,
    // Label 1056: @37363
    GIM_Reject,
    // Label 1050: @37364
    GIM_Try, /*On fail goto*//*Label 1057*/ 37387, // Rule ID 676 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
      // (sint_to_fp:{ *:[v4f32] } MSA128WOpnd:{ *:[v4i32] }:$ws)  =>  (FFINT_S_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4i32] }:$ws)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FFINT_S_W,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 676,
      GIR_Done,
    // Label 1057: @37387
    GIM_Reject,
    // Label 1051: @37388
    GIM_Reject,
    // Label 37: @37389
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/4, 7, /*)*//*default:*//*Label 1060*/ 37446,
    /*GILLT_v2s64*//*Label 1058*/ 37398, 0,
    /*GILLT_v4s32*//*Label 1059*/ 37422,
    // Label 1058: @37398
    GIM_Try, /*On fail goto*//*Label 1061*/ 37421, // Rule ID 679 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      // (uint_to_fp:{ *:[v2f64] } MSA128DOpnd:{ *:[v2i64] }:$ws)  =>  (FFINT_U_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2i64] }:$ws)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FFINT_U_D,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 679,
      GIR_Done,
    // Label 1061: @37421
    GIM_Reject,
    // Label 1059: @37422
    GIM_Try, /*On fail goto*//*Label 1062*/ 37445, // Rule ID 678 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
      // (uint_to_fp:{ *:[v4f32] } MSA128WOpnd:{ *:[v4i32] }:$ws)  =>  (FFINT_U_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4i32] }:$ws)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::FFINT_U_W,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 678,
      GIR_Done,
    // Label 1062: @37445
    GIM_Reject,
    // Label 1060: @37446
    GIM_Reject,
    // Label 38: @37447
    GIM_Try, /*On fail goto*//*Label 1063*/ 37531,
      GIM_CheckIsMBB, /*MI*/0, /*Op*/0,
      GIM_Try, /*On fail goto*//*Label 1064*/ 37466, // Rule ID 73 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips_RelocNotPIC,
        // (br (bb:{ *:[Other] }):$target)  =>  (J (bb:{ *:[Other] }):$target)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::J,
        GIR_AddImplicitDef, /*InsnID*/0, Mips::AT,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 73,
        GIR_Done,
      // Label 1064: @37466
      GIM_Try, /*On fail goto*//*Label 1065*/ 37480, // Rule ID 80 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
        // (br (bb:{ *:[Other] }):$offset)  =>  (B (bb:{ *:[Other] }):$offset)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::B,
        GIR_AddImplicitDef, /*InsnID*/0, Mips::AT,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 80,
        GIR_Done,
      // Label 1065: @37480
      GIM_Try, /*On fail goto*//*Label 1066*/ 37494, // Rule ID 1072 //
        GIM_CheckFeatures, GIFBS_InMicroMips_NotMips32r6_RelocNotPIC,
        // (br (bb:{ *:[Other] }):$target)  =>  (J_MM (bb:{ *:[Other] }):$target)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::J_MM,
        GIR_AddImplicitDef, /*InsnID*/0, Mips::AT,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1072,
        GIR_Done,
      // Label 1066: @37494
      GIM_Try, /*On fail goto*//*Label 1067*/ 37508, // Rule ID 1081 //
        GIM_CheckFeatures, GIFBS_InMicroMips_NotMips32r6_RelocPIC,
        // (br (bb:{ *:[Other] }):$offset)  =>  (B_MM (bb:{ *:[Other] }):$offset)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::B_MM,
        GIR_AddImplicitDef, /*InsnID*/0, Mips::AT,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1081,
        GIR_Done,
      // Label 1067: @37508
      GIM_Try, /*On fail goto*//*Label 1068*/ 37519, // Rule ID 1137 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
        // (br (bb:{ *:[Other] }):$offset)  =>  (BC_MMR6 (bb:{ *:[Other] }):$offset)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::BC_MMR6,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1137,
        GIR_Done,
      // Label 1068: @37519
      GIM_Try, /*On fail goto*//*Label 1069*/ 37530, // Rule ID 1785 //
        GIM_CheckFeatures, GIFBS_InMips16Mode,
        // (br (bb:{ *:[Other] }):$imm16)  =>  (Bimm16 (bb:{ *:[Other] }):$imm16)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::Bimm16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1785,
        GIR_Done,
      // Label 1069: @37530
      GIM_Reject,
    // Label 1063: @37531
    GIM_Reject,
    // Label 39: @37532
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 9, /*)*//*default:*//*Label 1076*/ 37966,
    /*GILLT_s32*//*Label 1070*/ 37546,
    /*GILLT_s64*//*Label 1071*/ 37738, 0,
    /*GILLT_v2s64*//*Label 1072*/ 37870, 0,
    /*GILLT_v4s32*//*Label 1073*/ 37894,
    /*GILLT_v8s16*//*Label 1074*/ 37918,
    /*GILLT_v16s8*//*Label 1075*/ 37942,
    // Label 1070: @37546
    GIM_Try, /*On fail goto*//*Label 1077*/ 37737,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      GIM_Try, /*On fail goto*//*Label 1078*/ 37601, // Rule ID 91 //
        GIM_CheckFeatures, GIFBS_HasMips32_HasStdEnc_NotInMicroMips_NotMips32r6_NotMips64r6,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (ctlz:{ *:[i32] } (xor:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, -1:{ *:[i32] }))  =>  (CLO:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CLO,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 91,
        GIR_Done,
      // Label 1078: @37601
      GIM_Try, /*On fail goto*//*Label 1079*/ 37646, // Rule ID 282 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_HasStdEnc,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (ctlz:{ *:[i32] } (xor:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, -1:{ *:[i32] }))  =>  (CLO_R6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CLO_R6,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 282,
        GIR_Done,
      // Label 1079: @37646
      GIM_Try, /*On fail goto*//*Label 1080*/ 37691, // Rule ID 1068 //
        GIM_CheckFeatures, GIFBS_InMicroMips,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (ctlz:{ *:[i32] } (xor:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, -1:{ *:[i32] }))  =>  (CLO_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CLO_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1068,
        GIR_Done,
      // Label 1080: @37691
      GIM_Try, /*On fail goto*//*Label 1081*/ 37706, // Rule ID 90 //
        GIM_CheckFeatures, GIFBS_HasMips32_HasStdEnc_NotInMicroMips_NotMips32r6_NotMips64r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        // (ctlz:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs)  =>  (CLZ:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::CLZ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 90,
        GIR_Done,
      // Label 1081: @37706
      GIM_Try, /*On fail goto*//*Label 1082*/ 37721, // Rule ID 283 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        // (ctlz:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs)  =>  (CLZ_R6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::CLZ_R6,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 283,
        GIR_Done,
      // Label 1082: @37721
      GIM_Try, /*On fail goto*//*Label 1083*/ 37736, // Rule ID 1067 //
        GIM_CheckFeatures, GIFBS_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        // (ctlz:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs)  =>  (CLZ_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::CLZ_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1067,
        GIR_Done,
      // Label 1083: @37736
      GIM_Reject,
    // Label 1077: @37737
    GIM_Reject,
    // Label 1071: @37738
    GIM_Try, /*On fail goto*//*Label 1084*/ 37869,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 1085*/ 37793, // Rule ID 236 //
        GIM_CheckFeatures, GIFBS_HasMips64_HasStdEnc_NotInMicroMips_NotMips64r6,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (ctlz:{ *:[i64] } (xor:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, -1:{ *:[i64] }))  =>  (DCLO:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DCLO,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 236,
        GIR_Done,
      // Label 1085: @37793
      GIM_Try, /*On fail goto*//*Label 1086*/ 37838, // Rule ID 311 //
        GIM_CheckFeatures, GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (ctlz:{ *:[i64] } (xor:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, -1:{ *:[i64] }))  =>  (DCLO_R6:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DCLO_R6,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 311,
        GIR_Done,
      // Label 1086: @37838
      GIM_Try, /*On fail goto*//*Label 1087*/ 37853, // Rule ID 235 //
        GIM_CheckFeatures, GIFBS_HasMips64_HasStdEnc_NotInMicroMips_NotMips64r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
        // (ctlz:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs)  =>  (DCLZ:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DCLZ,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 235,
        GIR_Done,
      // Label 1087: @37853
      GIM_Try, /*On fail goto*//*Label 1088*/ 37868, // Rule ID 312 //
        GIM_CheckFeatures, GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
        // (ctlz:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs)  =>  (DCLZ_R6:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DCLZ_R6,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 312,
        GIR_Done,
      // Label 1088: @37868
      GIM_Reject,
    // Label 1084: @37869
    GIM_Reject,
    // Label 1072: @37870
    GIM_Try, /*On fail goto*//*Label 1089*/ 37893, // Rule ID 883 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      // (ctlz:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws)  =>  (NLZC_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::NLZC_D,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 883,
      GIR_Done,
    // Label 1089: @37893
    GIM_Reject,
    // Label 1073: @37894
    GIM_Try, /*On fail goto*//*Label 1090*/ 37917, // Rule ID 882 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
      // (ctlz:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws)  =>  (NLZC_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::NLZC_W,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 882,
      GIR_Done,
    // Label 1090: @37917
    GIM_Reject,
    // Label 1074: @37918
    GIM_Try, /*On fail goto*//*Label 1091*/ 37941, // Rule ID 881 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
      // (ctlz:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws)  =>  (NLZC_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::NLZC_H,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 881,
      GIR_Done,
    // Label 1091: @37941
    GIM_Reject,
    // Label 1075: @37942
    GIM_Try, /*On fail goto*//*Label 1092*/ 37965, // Rule ID 880 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
      // (ctlz:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws)  =>  (NLZC_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::NLZC_B,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 880,
      GIR_Done,
    // Label 1092: @37965
    GIM_Reject,
    // Label 1076: @37966
    GIM_Reject,
    // Label 40: @37967
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 9, /*)*//*default:*//*Label 1099*/ 38125,
    /*GILLT_s32*//*Label 1093*/ 37981,
    /*GILLT_s64*//*Label 1094*/ 38005, 0,
    /*GILLT_v2s64*//*Label 1095*/ 38029, 0,
    /*GILLT_v4s32*//*Label 1096*/ 38053,
    /*GILLT_v8s16*//*Label 1097*/ 38077,
    /*GILLT_v16s8*//*Label 1098*/ 38101,
    // Label 1093: @37981
    GIM_Try, /*On fail goto*//*Label 1100*/ 38004, // Rule ID 250 //
      GIM_CheckFeatures, GIFBS_HasCnMips,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      // (ctpop:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs)  =>  (POP:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::POP,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 250,
      GIR_Done,
    // Label 1100: @38004
    GIM_Reject,
    // Label 1094: @38005
    