; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s                                   -mtriple=x86_64-- -verify-machineinstrs | FileCheck %s --check-prefixes X64,SDAG-X64
; RUN: llc < %s -global-isel -global-isel-abort=1 -mtriple=x86_64-- -verify-machineinstrs | FileCheck %s --check-prefixes X64,GISEL-X64
; RUN: llc < %s                                   -mattr=+avx512f -mtriple=x86_64-- -verify-machineinstrs | FileCheck %s --check-prefixes AVX512,SDAG-AVX512
; RUN: llc < %s -global-isel -global-isel-abort=1 -mattr=+avx512f -mtriple=x86_64-- -verify-machineinstrs | FileCheck %s --check-prefixes AVX512,GISEL-AVX512

define i64 @test_double_to_ui64(double %x) {
; SDAG-X64-LABEL: test_double_to_ui64:
; SDAG-X64:       # %bb.0: # %entry
; SDAG-X64-NEXT:    cvttsd2si %xmm0, %rcx
; SDAG-X64-NEXT:    movq %rcx, %rdx
; SDAG-X64-NEXT:    sarq $63, %rdx
; SDAG-X64-NEXT:    subsd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SDAG-X64-NEXT:    cvttsd2si %xmm0, %rax
; SDAG-X64-NEXT:    andq %rdx, %rax
; SDAG-X64-NEXT:    orq %rcx, %rax
; SDAG-X64-NEXT:    retq
;
; GISEL-X64-LABEL: test_double_to_ui64:
; GISEL-X64:       # %bb.0: # %entry
; GISEL-X64-NEXT:    cvttsd2si %xmm0, %rcx
; GISEL-X64-NEXT:    movsd {{.*#+}} xmm1 = [9.2233720368547758E+18,0.0E+0]
; GISEL-X64-NEXT:    movapd %xmm0, %xmm2
; GISEL-X64-NEXT:    subsd %xmm1, %xmm2
; GISEL-X64-NEXT:    cvttsd2si %xmm2, %rdx
; GISEL-X64-NEXT:    movabsq $-9223372036854775808, %rax # imm = 0x8000000000000000
; GISEL-X64-NEXT:    xorq %rdx, %rax
; GISEL-X64-NEXT:    xorl %edx, %edx
; GISEL-X64-NEXT:    ucomisd %xmm1, %xmm0
; GISEL-X64-NEXT:    setb %dl
; GISEL-X64-NEXT:    andl $1, %edx
; GISEL-X64-NEXT:    cmovneq %rcx, %rax
; GISEL-X64-NEXT:    retq
;
; AVX512-LABEL: test_double_to_ui64:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttsd2usi %xmm0, %rax
; AVX512-NEXT:    retq
entry:
  %conv = fptoui double %x to i64
  ret i64 %conv
}

define i32 @test_double_to_ui32(double %x) {
; X64-LABEL: test_double_to_ui32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    cvttsd2si %xmm0, %rax
; X64-NEXT:    # kill: def $eax killed $eax killed $rax
; X64-NEXT:    retq
;
; AVX512-LABEL: test_double_to_ui32:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttsd2usi %xmm0, %eax
; AVX512-NEXT:    retq
entry:
  %conv = fptoui double %x to i32
  ret i32 %conv
}

define zeroext i16 @test_double_to_ui16(double %x) {
; X64-LABEL: test_double_to_ui16:
; X64:       # %bb.0: # %entry
; X64-NEXT:    cvttsd2si %xmm0, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
;
; SDAG-AVX512-LABEL: test_double_to_ui16:
; SDAG-AVX512:       # %bb.0: # %entry
; SDAG-AVX512-NEXT:    vcvttsd2si %xmm0, %eax
; SDAG-AVX512-NEXT:    # kill: def $ax killed $ax killed $eax
; SDAG-AVX512-NEXT:    retq
;
; GISEL-AVX512-LABEL: test_double_to_ui16:
; GISEL-AVX512:       # %bb.0: # %entry
; GISEL-AVX512-NEXT:    vcvttsd2usi %xmm0, %eax
; GISEL-AVX512-NEXT:    # kill: def $ax killed $ax killed $eax
; GISEL-AVX512-NEXT:    retq
entry:
  %conv = fptoui double %x to i16
  ret i16 %conv
}

define zeroext i8 @test_double_to_ui8(double %x) {
; X64-LABEL: test_double_to_ui8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    cvttsd2si %xmm0, %eax
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
;
; SDAG-AVX512-LABEL: test_double_to_ui8:
; SDAG-AVX512:       # %bb.0: # %entry
; SDAG-AVX512-NEXT:    vcvttsd2si %xmm0, %eax
; SDAG-AVX512-NEXT:    # kill: def $al killed $al killed $eax
; SDAG-AVX512-NEXT:    retq
;
; GISEL-AVX512-LABEL: test_double_to_ui8:
; GISEL-AVX512:       # %bb.0: # %entry
; GISEL-AVX512-NEXT:    vcvttsd2usi %xmm0, %eax
; GISEL-AVX512-NEXT:    # kill: def $al killed $al killed $eax
; GISEL-AVX512-NEXT:    retq
entry:
  %conv = fptoui double %x to i8
  ret i8 %conv
}

define i64 @test_float_to_ui64(float %x) {
; SDAG-X64-LABEL: test_float_to_ui64:
; SDAG-X64:       # %bb.0: # %entry
; SDAG-X64-NEXT:    cvttss2si %xmm0, %rcx
; SDAG-X64-NEXT:    movq %rcx, %rdx
; SDAG-X64-NEXT:    sarq $63, %rdx
; SDAG-X64-NEXT:    subss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SDAG-X64-NEXT:    cvttss2si %xmm0, %rax
; SDAG-X64-NEXT:    andq %rdx, %rax
; SDAG-X64-NEXT:    orq %rcx, %rax
; SDAG-X64-NEXT:    retq
;
; GISEL-X64-LABEL: test_float_to_ui64:
; GISEL-X64:       # %bb.0: # %entry
; GISEL-X64-NEXT:    cvttss2si %xmm0, %rcx
; GISEL-X64-NEXT:    movss {{.*#+}} xmm1 = [9.22337203E+18,0.0E+0,0.0E+0,0.0E+0]
; GISEL-X64-NEXT:    movaps %xmm0, %xmm2
; GISEL-X64-NEXT:    subss %xmm1, %xmm2
; GISEL-X64-NEXT:    cvttss2si %xmm2, %rdx
; GISEL-X64-NEXT:    movabsq $-9223372036854775808, %rax # imm = 0x8000000000000000
; GISEL-X64-NEXT:    xorq %rdx, %rax
; GISEL-X64-NEXT:    xorl %edx, %edx
; GISEL-X64-NEXT:    ucomiss %xmm1, %xmm0
; GISEL-X64-NEXT:    setb %dl
; GISEL-X64-NEXT:    andl $1, %edx
; GISEL-X64-NEXT:    cmovneq %rcx, %rax
; GISEL-X64-NEXT:    retq
;
; AVX512-LABEL: test_float_to_ui64:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttss2usi %xmm0, %rax
; AVX512-NEXT:    retq
entry:
  %conv = fptoui float %x to i64
  ret i64 %conv
}

define i32 @test_float_to_ui32(float %x) {
; X64-LABEL: test_float_to_ui32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    cvttss2si %xmm0, %rax
; X64-NEXT:    # kill: def $eax killed $eax killed $rax
; X64-NEXT:    retq
;
; AVX512-LABEL: test_float_to_ui32:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttss2usi %xmm0, %eax
; AVX512-NEXT:    retq
entry:
  %conv = fptoui float %x to i32
  ret i32 %conv
}

define zeroext i16 @test_float_to_ui16(float %x) {
; X64-LABEL: test_float_to_ui16:
; X64:       # %bb.0: # %entry
; X64-NEXT:    cvttss2si %xmm0, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
;
; SDAG-AVX512-LABEL: test_float_to_ui16:
; SDAG-AVX512:       # %bb.0: # %entry
; SDAG-AVX512-NEXT:    vcvttss2si %xmm0, %eax
; SDAG-AVX512-NEXT:    # kill: def $ax killed $ax killed $eax
; SDAG-AVX512-NEXT:    retq
;
; GISEL-AVX512-LABEL: test_float_to_ui16:
; GISEL-AVX512:       # %bb.0: # %entry
; GISEL-AVX512-NEXT:    vcvttss2usi %xmm0, %eax
; GISEL-AVX512-NEXT:    # kill: def $ax killed $ax killed $eax
; GISEL-AVX512-NEXT:    retq
entry:
  %conv = fptoui float %x to i16
  ret i16 %conv
}

define zeroext i8 @test_float_to_ui8(float %x) {
; X64-LABEL: test_float_to_ui8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    cvttss2si %xmm0, %eax
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
;
; SDAG-AVX512-LABEL: test_float_to_ui8:
; SDAG-AVX512:       # %bb.0: # %entry
; SDAG-AVX512-NEXT:    vcvttss2si %xmm0, %eax
; SDAG-AVX512-NEXT:    # kill: def $al killed $al killed $eax
; SDAG-AVX512-NEXT:    retq
;
; GISEL-AVX512-LABEL: test_float_to_ui8:
; GISEL-AVX512:       # %bb.0: # %entry
; GISEL-AVX512-NEXT:    vcvttss2usi %xmm0, %eax
; GISEL-AVX512-NEXT:    # kill: def $al killed $al killed $eax
; GISEL-AVX512-NEXT:    retq
entry:
  %conv = fptoui float %x to i8
  ret i8 %conv
}

define i64 @test_double_to_si64(double %x) {
; X64-LABEL: test_double_to_si64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    cvttsd2si %xmm0, %rax
; X64-NEXT:    retq
;
; AVX512-LABEL: test_double_to_si64:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttsd2si %xmm0, %rax
; AVX512-NEXT:    retq
entry:
  %conv = fptosi double %x to i64
  ret i64 %conv
}

define i32 @test_double_to_si32(double %x) {
; X64-LABEL: test_double_to_si32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    cvttsd2si %xmm0, %eax
; X64-NEXT:    retq
;
; AVX512-LABEL: test_double_to_si32:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttsd2si %xmm0, %eax
; AVX512-NEXT:    retq
entry:
  %conv = fptosi double %x to i32
  ret i32 %conv
}

define signext i16 @test_double_to_si16(double %x) {
; X64-LABEL: test_double_to_si16:
; X64:       # %bb.0: # %entry
; X64-NEXT:    cvttsd2si %xmm0, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
;
; AVX512-LABEL: test_double_to_si16:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttsd2si %xmm0, %eax
; AVX512-NEXT:    # kill: def $ax killed $ax killed $eax
; AVX512-NEXT:    retq
entry:
  %conv = fptosi double %x to i16
  ret i16 %conv
}

define signext i8 @test_double_to_si8(double %x) {
; X64-LABEL: test_double_to_si8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    cvttsd2si %xmm0, %eax
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
;
; AVX512-LABEL: test_double_to_si8:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttsd2si %xmm0, %eax
; AVX512-NEXT:    # kill: def $al killed $al killed $eax
; AVX512-NEXT:    retq
entry:
  %conv = fptosi double %x to i8
  ret i8 %conv
}

define i31 @test_double_to_si31(double %x) {
; X64-LABEL: test_double_to_si31:
; X64:       # %bb.0: # %entry
; X64-NEXT:    cvttsd2si %xmm0, %eax
; X64-NEXT:    retq
;
; AVX512-LABEL: test_double_to_si31:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttsd2si %xmm0, %eax
; AVX512-NEXT:    retq
entry:
  %conv = fptosi double %x to i31
  ret i31 %conv
}

define i33 @test_double_to_si33(double %x) {
; X64-LABEL: test_double_to_si33:
; X64:       # %bb.0: # %entry
; X64-NEXT:    cvttsd2si %xmm0, %rax
; X64-NEXT:    retq
;
; AVX512-LABEL: test_double_to_si33:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttsd2si %xmm0, %rax
; AVX512-NEXT:    retq
entry:
  %conv = fptosi double %x to i33
  ret i33 %conv
}

define i64 @test_float_to_si64(float %x) {
; X64-LABEL: test_float_to_si64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    cvttss2si %xmm0, %rax
; X64-NEXT:    retq
;
; AVX512-LABEL: test_float_to_si64:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttss2si %xmm0, %rax
; AVX512-NEXT:    retq
entry:
  %conv = fptosi float %x to i64
  ret i64 %conv
}

define i32 @test_float_to_si32(float %x) {
; X64-LABEL: test_float_to_si32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    cvttss2si %xmm0, %eax
; X64-NEXT:    retq
;
; AVX512-LABEL: test_float_to_si32:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttss2si %xmm0, %eax
; AVX512-NEXT:    retq
entry:
  %conv = fptosi float %x to i32
  ret i32 %conv
}

define signext i16 @test_float_to_si16(float %x) {
; X64-LABEL: test_float_to_si16:
; X64:       # %bb.0: # %entry
; X64-NEXT:    cvttss2si %xmm0, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
;
; AVX512-LABEL: test_float_to_si16:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttss2si %xmm0, %eax
; AVX512-NEXT:    # kill: def $ax killed $ax killed $eax
; AVX512-NEXT:    retq
entry:
  %conv = fptosi float %x to i16
  ret i16 %conv
}

define signext i8 @test_float_to_si8(float %x) {
; X64-LABEL: test_float_to_si8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    cvttss2si %xmm0, %eax
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
;
; AVX512-LABEL: test_float_to_si8:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttss2si %xmm0, %eax
; AVX512-NEXT:    # kill: def $al killed $al killed $eax
; AVX512-NEXT:    retq
entry:
  %conv = fptosi float %x to i8
  ret i8 %conv
}

define i31 @test_float_to_si31(float %x) {
; X64-LABEL: test_float_to_si31:
; X64:       # %bb.0: # %entry
; X64-NEXT:    cvttss2si %xmm0, %eax
; X64-NEXT:    retq
;
; AVX512-LABEL: test_float_to_si31:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttss2si %xmm0, %eax
; AVX512-NEXT:    retq
entry:
  %conv = fptosi float %x to i31
  ret i31 %conv
}

define i33 @test_float_to_si33(float %x) {
; X64-LABEL: test_float_to_si33:
; X64:       # %bb.0: # %entry
; X64-NEXT:    cvttss2si %xmm0, %rax
; X64-NEXT:    retq
;
; AVX512-LABEL: test_float_to_si33:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vcvttss2si %xmm0, %rax
; AVX512-NEXT:    retq
entry:
  %conv = fptosi float %x to i33
  ret i33 %conv
}
