; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple riscv32 -mattr=+v %s -o - \
; RUN:     -verify-machineinstrs | FileCheck %s
; RUN: llc -mtriple riscv64 -mattr=+v %s -o - \
; RUN:     -verify-machineinstrs | FileCheck %s

define void @vadd_vint8m1(ptr %pc, ptr %pa, ptr %pb) nounwind {
; CHECK-LABEL: vadd_vint8m1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl1r.v v8, (a1)
; CHECK-NEXT:    vl1r.v v9, (a2)
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vadd.vv v8, v8, v9
; CHECK-NEXT:    vs1r.v v8, (a0)
; CHECK-NEXT:    ret
  %va = load <vscale x 8 x i8>, ptr %pa
  %vb = load <vscale x 8 x i8>, ptr %pb
  %vc = add <vscale x 8 x i8> %va, %vb
  store <vscale x 8 x i8> %vc, ptr %pc
  ret void
}

define void @vadd_vint8m2(ptr %pc, ptr %pa, ptr %pb) nounwind {
; CHECK-LABEL: vadd_vint8m2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl2r.v v8, (a1)
; CHECK-NEXT:    vl2r.v v10, (a2)
; CHECK-NEXT:    vsetvli a1, zero, e8, m2, ta, ma
; CHECK-NEXT:    vadd.vv v8, v8, v10
; CHECK-NEXT:    vs2r.v v8, (a0)
; CHECK-NEXT:    ret
  %va = load <vscale x 16 x i8>, ptr %pa
  %vb = load <vscale x 16 x i8>, ptr %pb
  %vc = add <vscale x 16 x i8> %va, %vb
  store <vscale x 16 x i8> %vc, ptr %pc
  ret void
}

define void @vadd_vint8m4(ptr %pc, ptr %pa, ptr %pb) nounwind {
; CHECK-LABEL: vadd_vint8m4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl4r.v v8, (a1)
; CHECK-NEXT:    vl4r.v v12, (a2)
; CHECK-NEXT:    vsetvli a1, zero, e8, m4, ta, ma
; CHECK-NEXT:    vadd.vv v8, v8, v12
; CHECK-NEXT:    vs4r.v v8, (a0)
; CHECK-NEXT:    ret
  %va = load <vscale x 32 x i8>, ptr %pa
  %vb = load <vscale x 32 x i8>, ptr %pb
  %vc = add <vscale x 32 x i8> %va, %vb
  store <vscale x 32 x i8> %vc, ptr %pc
  ret void
}

define void @vadd_vint8m8(ptr %pc, ptr %pa, ptr %pb) nounwind {
; CHECK-LABEL: vadd_vint8m8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl8r.v v8, (a1)
; CHECK-NEXT:    vl8r.v v16, (a2)
; CHECK-NEXT:    vsetvli a1, zero, e8, m8, ta, ma
; CHECK-NEXT:    vadd.vv v8, v8, v16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    ret
  %va = load <vscale x 64 x i8>, ptr %pa
  %vb = load <vscale x 64 x i8>, ptr %pb
  %vc = add <vscale x 64 x i8> %va, %vb
  store <vscale x 64 x i8> %vc, ptr %pc
  ret void
}

define void @vadd_vint8mf2(ptr %pc, ptr %pa, ptr %pb) nounwind {
; CHECK-LABEL: vadd_vint8mf2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a3, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vle8.v v8, (a1)
; CHECK-NEXT:    vle8.v v9, (a2)
; CHECK-NEXT:    vadd.vv v8, v8, v9
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
  %va = load <vscale x 4 x i8>, ptr %pa
  %vb = load <vscale x 4 x i8>, ptr %pb
  %vc = add <vscale x 4 x i8> %va, %vb
  store <vscale x 4 x i8> %vc, ptr %pc
  ret void
}

define void @vadd_vint8mf4(ptr %pc, ptr %pa, ptr %pb) nounwind {
; CHECK-LABEL: vadd_vint8mf4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a3, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vle8.v v8, (a1)
; CHECK-NEXT:    vle8.v v9, (a2)
; CHECK-NEXT:    vadd.vv v8, v8, v9
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
  %va = load <vscale x 2 x i8>, ptr %pa
  %vb = load <vscale x 2 x i8>, ptr %pb
  %vc = add <vscale x 2 x i8> %va, %vb
  store <vscale x 2 x i8> %vc, ptr %pc
  ret void
}

define void @vadd_vint8mf8(ptr %pc, ptr %pa, ptr %pb) nounwind {
; CHECK-LABEL: vadd_vint8mf8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a3, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vle8.v v8, (a1)
; CHECK-NEXT:    vle8.v v9, (a2)
; CHECK-NEXT:    vadd.vv v8, v8, v9
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
  %va = load <vscale x 1 x i8>, ptr %pa
  %vb = load <vscale x 1 x i8>, ptr %pb
  %vc = add <vscale x 1 x i8> %va, %vb
  store <vscale x 1 x i8> %vc, ptr %pc
  ret void
}

define void @vadd_vint16m1(ptr %pc, ptr %pa, ptr %pb) nounwind {
; CHECK-LABEL: vadd_vint16m1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl1re16.v v8, (a1)
; CHECK-NEXT:    vl1re16.v v9, (a2)
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vadd.vv v8, v8, v9
; CHECK-NEXT:    vs1r.v v8, (a0)
; CHECK-NEXT:    ret
  %va = load <vscale x 4 x i16>, ptr %pa
  %vb = load <vscale x 4 x i16>, ptr %pb
  %vc = add <vscale x 4 x i16> %va, %vb
  store <vscale x 4 x i16> %vc, ptr %pc
  ret void
}

define void @vadd_vint16m2(ptr %pc, ptr %pa, ptr %pb) nounwind {
; CHECK-LABEL: vadd_vint16m2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl2re16.v v8, (a1)
; CHECK-NEXT:    vl2re16.v v10, (a2)
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vadd.vv v8, v8, v10
; CHECK-NEXT:    vs2r.v v8, (a0)
; CHECK-NEXT:    ret
  %va = load <vscale x 8 x i16>, ptr %pa
  %vb = load <vscale x 8 x i16>, ptr %pb
  %vc = add <vscale x 8 x i16> %va, %vb
  store <vscale x 8 x i16> %vc, ptr %pc
  ret void
}

define void @vadd_vint16m4(ptr %pc, ptr %pa, ptr %pb) nounwind {
; CHECK-LABEL: vadd_vint16m4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl4re16.v v8, (a1)
; CHECK-NEXT:    vl4re16.v v12, (a2)
; CHECK-NEXT:    vsetvli a1, zero, e16, m4, ta, ma
; CHECK-NEXT:    vadd.vv v8, v8, v12
; CHECK-NEXT:    vs4r.v v8, (a0)
; CHECK-NEXT:    ret
  %va = load <vscale x 16 x i16>, ptr %pa
  %vb = load <vscale x 16 x i16>, ptr %pb
  %vc = add <vscale x 16 x i16> %va, %vb
  store <vscale x 16 x i16> %vc, ptr %pc
  ret void
}

define void @vadd_vint16m8(ptr %pc, ptr %pa, ptr %pb) nounwind {
; CHECK-LABEL: vadd_vint16m8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl8re16.v v8, (a1)
; CHECK-NEXT:    vl8re16.v v16, (a2)
; CHECK-NEXT:    vsetvli a1, zero, e16, m8, ta, ma
; CHECK-NEXT:    vadd.vv v8, v8, v16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    ret
  %va = load <vscale x 32 x i16>, ptr %pa
  %vb = load <vscale x 32 x i16>, ptr %pb
  %vc = add <vscale x 32 x i16> %va, %vb
  store <vscale x 32 x i16> %vc, ptr %pc
  ret void
}

define void @vadd_vint16mf2(ptr %pc, ptr %pa, ptr %pb) nounwind {
; CHECK-LABEL: vadd_vint16mf2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a3, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vle16.v v8, (a1)
; CHECK-NEXT:    vle16.v v9, (a2)
; CHECK-NEXT:    vadd.vv v8, v8, v9
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %va = load <vscale x 2 x i16>, ptr %pa
  %vb = load <vscale x 2 x i16>, ptr %pb
  %vc = add <vscale x 2 x i16> %va, %vb
  store <vscale x 2 x i16> %vc, ptr %pc
  ret void
}

define void @vadd_vint16mf4(ptr %pc, ptr %pa, ptr %pb) nounwind {
; CHECK-LABEL: vadd_vint16mf4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a3, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vle16.v v8, (a1)
; CHECK-NEXT:    vle16.v v9, (a2)
; CHECK-NEXT:    vadd.vv v8, v8, v9
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %va = load <vscale x 1 x i16>, ptr %pa
  %vb = load <vscale x 1 x i16>, ptr %pb
  %vc = add <vscale x 1 x i16> %va, %vb
  store <vscale x 1 x i16> %vc, ptr %pc
  ret void
}

define void @vadd_vint32m1(ptr %pc, ptr %pa, ptr %pb) nounwind {
; CHECK-LABEL: vadd_vint32m1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl1re32.v v8, (a1)
; CHECK-NEXT:    vl1re32.v v9, (a2)
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vadd.vv v8, v8, v9
; CHECK-NEXT:    vs1r.v v8, (a0)
; CHECK-NEXT:    ret
  %va = load <vscale x 2 x i32>, ptr %pa
  %vb = load <vscale x 2 x i32>, ptr %pb
  %vc = add <vscale x 2 x i32> %va, %vb
  store <vscale x 2 x i32> %vc, ptr %pc
  ret void
}

define void @vadd_vint32m2(ptr %pc, ptr %pa, ptr %pb) nounwind {
; CHECK-LABEL: vadd_vint32m2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl2re32.v v8, (a1)
; CHECK-NEXT:    vl2re32.v v10, (a2)
; CHECK-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; CHECK-NEXT:    vadd.vv v8, v8, v10
; CHECK-NEXT:    vs2r.v v8, (a0)
; CHECK-NEXT:    ret
  %va = load <vscale x 4 x i32>, ptr %pa
  %vb = load <vscale x 4 x i32>, ptr %pb
  %vc = add <vscale x 4 x i32> %va, %vb
  store <vscale x 4 x i32> %vc, ptr %pc
  ret void
}

define void @vadd_vint32m4(ptr %pc, ptr %pa, ptr %pb) nounwind {
; CHECK-LABEL: vadd_vint32m4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl4re32.v v8, (a1)
; CHECK-NEXT:    vl4re32.v v12, (a2)
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vadd.vv v8, v8, v12
; CHECK-NEXT:    vs4r.v v8, (a0)
; CHECK-NEXT:    ret
  %va = load <vscale x 8 x i32>, ptr %pa
  %vb = load <vscale x 8 x i32>, ptr %pb
  %vc = add <vscale x 8 x i32> %va, %vb
  store <vscale x 8 x i32> %vc, ptr %pc
  ret void
}

define void @vadd_vint32m8(ptr %pc, ptr %pa, ptr %pb) nounwind {
; CHECK-LABEL: vadd_vint32m8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl8re32.v v8, (a1)
; CHECK-NEXT:    vl8re32.v v16, (a2)
; CHECK-NEXT:    vsetvli a1, zero, e32, m8, ta, ma
; CHECK-NEXT:    vadd.vv v8, v8, v16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    ret
  %va = load <vscale x 16 x i32>, ptr %pa
  %vb = load <vscale x 16 x i32>, ptr %pb
  %vc = add <vscale x 16 x i32> %va, %vb
  store <vscale x 16 x i32> %vc, ptr %pc
  ret void
}

define void @vadd_vint32mf2(ptr %pc, ptr %pa, ptr %pb) nounwind {
; CHECK-LABEL: vadd_vint32mf2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a3, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a1)
; CHECK-NEXT:    vle32.v v9, (a2)
; CHECK-NEXT:    vadd.vv v8, v8, v9
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %va = load <vscale x 1 x i32>, ptr %pa
  %vb = load <vscale x 1 x i32>, ptr %pb
  %vc = add <vscale x 1 x i32> %va, %vb
  store <vscale x 1 x i32> %vc, ptr %pc
  ret void
}

define void @vadd_vint64m1(ptr %pc, ptr %pa, ptr %pb) nounwind {
; CHECK-LABEL: vadd_vint64m1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl1re64.v v8, (a1)
; CHECK-NEXT:    vl1re64.v v9, (a2)
; CHECK-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-NEXT:    vadd.vv v8, v8, v9
; CHECK-NEXT:    vs1r.v v8, (a0)
; CHECK-NEXT:    ret
  %va = load <vscale x 1 x i64>, ptr %pa
  %vb = load <vscale x 1 x i64>, ptr %pb
  %vc = add <vscale x 1 x i64> %va, %vb
  store <vscale x 1 x i64> %vc, ptr %pc
  ret void
}

define void @vadd_vint64m2(ptr %pc, ptr %pa, ptr %pb) nounwind {
; CHECK-LABEL: vadd_vint64m2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl2re64.v v8, (a1)
; CHECK-NEXT:    vl2re64.v v10, (a2)
; CHECK-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; CHECK-NEXT:    vadd.vv v8, v8, v10
; CHECK-NEXT:    vs2r.v v8, (a0)
; CHECK-NEXT:    ret
  %va = load <vscale x 2 x i64>, ptr %pa
  %vb = load <vscale x 2 x i64>, ptr %pb
  %vc = add <vscale x 2 x i64> %va, %vb
  store <vscale x 2 x i64> %vc, ptr %pc
  ret void
}

define void @vadd_vint64m4(ptr %pc, ptr %pa, ptr %pb) nounwind {
; CHECK-LABEL: vadd_vint64m4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl4re64.v v8, (a1)
; CHECK-NEXT:    vl4re64.v v12, (a2)
; CHECK-NEXT:    vsetvli a1, zero, e64, m4, ta, ma
; CHECK-NEXT:    vadd.vv v8, v8, v12
; CHECK-NEXT:    vs4r.v v8, (a0)
; CHECK-NEXT:    ret
  %va = load <vscale x 4 x i64>, ptr %pa
  %vb = load <vscale x 4 x i64>, ptr %pb
  %vc = add <vscale x 4 x i64> %va, %vb
  store <vscale x 4 x i64> %vc, ptr %pc
  ret void
}

define void @vadd_vint64m8(ptr %pc, ptr %pa, ptr %pb) nounwind {
; CHECK-LABEL: vadd_vint64m8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl8re64.v v8, (a1)
; CHECK-NEXT:    vl8re64.v v16, (a2)
; CHECK-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; CHECK-NEXT:    vadd.vv v8, v8, v16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    ret
  %va = load <vscale x 8 x i64>, ptr %pa
  %vb = load <vscale x 8 x i64>, ptr %pb
  %vc = add <vscale x 8 x i64> %va, %vb
  store <vscale x 8 x i64> %vc, ptr %pc
  ret void
}


define void @exact_vlen_vadd_vint8m1(ptr %pc, ptr %pa, ptr %pb) nounwind vscale_range(2,2) {
; CHECK-LABEL: exact_vlen_vadd_vint8m1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl1r.v v8, (a1)
; CHECK-NEXT:    vl1r.v v9, (a2)
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vadd.vv v8, v8, v9
; CHECK-NEXT:    vs1r.v v8, (a0)
; CHECK-NEXT:    ret
  %va = load <vscale x 8 x i8>, ptr %pa
  %vb = load <vscale x 8 x i8>, ptr %pb
  %vc = add <vscale x 8 x i8> %va, %vb
  store <vscale x 8 x i8> %vc, ptr %pc
  ret void
}

define void @exact_vlen_vadd_vint8m2(ptr %pc, ptr %pa, ptr %pb) nounwind vscale_range(2,2) {
; CHECK-LABEL: exact_vlen_vadd_vint8m2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl2r.v v8, (a1)
; CHECK-NEXT:    vl2r.v v10, (a2)
; CHECK-NEXT:    vsetvli a1, zero, e8, m2, ta, ma
; CHECK-NEXT:    vadd.vv v8, v8, v10
; CHECK-NEXT:    vs2r.v v8, (a0)
; CHECK-NEXT:    ret
  %va = load <vscale x 16 x i8>, ptr %pa
  %vb = load <vscale x 16 x i8>, ptr %pb
  %vc = add <vscale x 16 x i8> %va, %vb
  store <vscale x 16 x i8> %vc, ptr %pc
  ret void
}

define void @exact_vlen_vadd_vint8mf2(ptr %pc, ptr %pa, ptr %pb) nounwind vscale_range(2,2) {
; CHECK-LABEL: exact_vlen_vadd_vint8mf2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, ma
; CHECK-NEXT:    vle8.v v8, (a1)
; CHECK-NEXT:    vle8.v v9, (a2)
; CHECK-NEXT:    vadd.vv v8, v8, v9
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
  %va = load <vscale x 4 x i8>, ptr %pa
  %vb = load <vscale x 4 x i8>, ptr %pb
  %vc = add <vscale x 4 x i8> %va, %vb
  store <vscale x 4 x i8> %vc, ptr %pc
  ret void
}

define void @exact_vlen_vadd_vint8mf4(ptr %pc, ptr %pa, ptr %pb) nounwind vscale_range(2,2) {
; CHECK-LABEL: exact_vlen_vadd_vint8mf4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; CHECK-NEXT:    vle8.v v8, (a1)
; CHECK-NEXT:    vle8.v v9, (a2)
; CHECK-NEXT:    vadd.vv v8, v8, v9
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
  %va = load <vscale x 2 x i8>, ptr %pa
  %vb = load <vscale x 2 x i8>, ptr %pb
  %vc = add <vscale x 2 x i8> %va, %vb
  store <vscale x 2 x i8> %vc, ptr %pc
  ret void
}

define void @exact_vlen_vadd_vint8mf8(ptr %pc, ptr %pa, ptr %pb) nounwind vscale_range(2,2) {
; CHECK-LABEL: exact_vlen_vadd_vint8mf8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e8, mf8, ta, ma
; CHECK-NEXT:    vle8.v v8, (a1)
; CHECK-NEXT:    vle8.v v9, (a2)
; CHECK-NEXT:    vadd.vv v8, v8, v9
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
  %va = load <vscale x 1 x i8>, ptr %pa
  %vb = load <vscale x 1 x i8>, ptr %pb
  %vc = add <vscale x 1 x i8> %va, %vb
  store <vscale x 1 x i8> %vc, ptr %pc
  ret void
}

define void @exact_vlen_vadd_vint32m1(ptr %pc, ptr %pa, ptr %pb) nounwind vscale_range(2,2) {
; CHECK-LABEL: exact_vlen_vadd_vint32m1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl1re32.v v8, (a1)
; CHECK-NEXT:    vl1re32.v v9, (a2)
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vadd.vv v8, v8, v9
; CHECK-NEXT:    vs1r.v v8, (a0)
; CHECK-NEXT:    ret
  %va = load <vscale x 2 x i32>, ptr %pa
  %vb = load <vscale x 2 x i32>, ptr %pb
  %vc = add <vscale x 2 x i32> %va, %vb
  store <vscale x 2 x i32> %vc, ptr %pc
  ret void
}

define void @exact_vlen_vadd_vint32m2(ptr %pc, ptr %pa, ptr %pb) nounwind vscale_range(2,2) {
; CHECK-LABEL: exact_vlen_vadd_vint32m2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl2re32.v v8, (a1)
; CHECK-NEXT:    vl2re32.v v10, (a2)
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vadd.vv v8, v8, v10
; CHECK-NEXT:    vs2r.v v8, (a0)
; CHECK-NEXT:    ret
  %va = load <vscale x 4 x i32>, ptr %pa
  %vb = load <vscale x 4 x i32>, ptr %pb
  %vc = add <vscale x 4 x i32> %va, %vb
  store <vscale x 4 x i32> %vc, ptr %pc
  ret void
}

define void @exact_vlen_vadd_vint32m4(ptr %pc, ptr %pa, ptr %pb) nounwind vscale_range(2,2) {
; CHECK-LABEL: exact_vlen_vadd_vint32m4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl4re32.v v8, (a1)
; CHECK-NEXT:    vl4re32.v v12, (a2)
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vadd.vv v8, v8, v12
; CHECK-NEXT:    vs4r.v v8, (a0)
; CHECK-NEXT:    ret
  %va = load <vscale x 8 x i32>, ptr %pa
  %vb = load <vscale x 8 x i32>, ptr %pb
  %vc = add <vscale x 8 x i32> %va, %vb
  store <vscale x 8 x i32> %vc, ptr %pc
  ret void
}

define void @exact_vlen_vadd_vint32m8(ptr %pc, ptr %pa, ptr %pb) nounwind vscale_range(2,2) {
; CHECK-LABEL: exact_vlen_vadd_vint32m8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl8re32.v v8, (a1)
; CHECK-NEXT:    vl8re32.v v16, (a2)
; CHECK-NEXT:    vsetvli a1, zero, e32, m8, ta, ma
; CHECK-NEXT:    vadd.vv v8, v8, v16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    ret
  %va = load <vscale x 16 x i32>, ptr %pa
  %vb = load <vscale x 16 x i32>, ptr %pb
  %vc = add <vscale x 16 x i32> %va, %vb
  store <vscale x 16 x i32> %vc, ptr %pc
  ret void
}
