; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -global-isel -verify-machineinstrs < %s \
; RUN:   -target-abi=lp64 | FileCheck %s -check-prefixes=CHECK,RV64I
; RUN: llc -mtriple=riscv64 -global-isel -mattr=+d -verify-machineinstrs < %s \
; RUN:   -target-abi=lp64d | FileCheck %s -check-prefixes=CHECK,RV64ID

define i128 @fptosi_f64_to_i128(double %a) nounwind {
; CHECK-LABEL: fptosi_f64_to_i128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call __fixdfti
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = fptosi double %a to i128
  ret i128 %1
}

define i128 @fptoui_f64_to_i128(double %a) nounwind {
; CHECK-LABEL: fptoui_f64_to_i128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call __fixunsdfti
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = fptoui double %a to i128
  ret i128 %1
}

define double @sitofp_i128_to_f64(i128 %a) nounwind {
; CHECK-LABEL: sitofp_i128_to_f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call __floattidf
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = sitofp i128 %a to double
  ret double %1
}

define double @uitofp_i128_to_f64(i128 %a) nounwind {
; CHECK-LABEL: uitofp_i128_to_f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    call __floatuntidf
; CHECK-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %1 = uitofp i128 %a to double
  ret double %1
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; RV64I: {{.*}}
; RV64ID: {{.*}}
