; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -mtriple=riscv32 -mattr=+v,+zfh,+zvfh -passes="print<cost-model>" -cost-kind=throughput 2>&1 -disable-output | FileCheck %s -check-prefixes=RV32ZVFH
; RUN: opt < %s -mtriple=riscv32 -mattr=+v,+zfh,+zvfhmin -passes="print<cost-model>" -cost-kind=throughput 2>&1 -disable-output | FileCheck %s -check-prefixes=RV32ZVFHMIN
; RUN: opt < %s -mtriple=riscv64 -mattr=+v,+zfh,+zvfh -passes="print<cost-model>" -cost-kind=throughput 2>&1 -disable-output | FileCheck %s -check-prefixes=RV64ZVFH
; RUN: opt < %s -mtriple=riscv64 -mattr=+v,+zfh,+zvfhmin -passes="print<cost-model>" -cost-kind=throughput 2>&1 -disable-output | FileCheck %s -check-prefixes=RV64ZVFHMIN

define void @fptosi() {
; RV32ZVFH-LABEL: 'fptosi'
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f16_v2i8 = fptosi <2 x half> undef to <2 x i8>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f16_v2i16 = fptosi <2 x half> undef to <2 x i16>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f16_v2i32 = fptosi <2 x half> undef to <2 x i32>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f16_v2i64 = fptosi <2 x half> undef to <2 x i64>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2f16_v2i1 = fptosi <2 x half> undef to <2 x i1>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f16_v4i8 = fptosi <4 x half> undef to <4 x i8>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f16_v4i16 = fptosi <4 x half> undef to <4 x i16>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f16_v4i32 = fptosi <4 x half> undef to <4 x i32>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4f16_v4i64 = fptosi <4 x half> undef to <4 x i64>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4f16_v4i1 = fptosi <4 x half> undef to <4 x i1>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8f16_v8i8 = fptosi <8 x half> undef to <8 x i8>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8f16_v8i16 = fptosi <8 x half> undef to <8 x i16>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f16_v8i32 = fptosi <8 x half> undef to <8 x i32>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v8f16_v8i64 = fptosi <8 x half> undef to <8 x i64>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8f16_v8i1 = fptosi <8 x half> undef to <8 x i1>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16f16_v16i8 = fptosi <16 x half> undef to <16 x i8>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16f16_v16i16 = fptosi <16 x half> undef to <16 x i16>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16f16_v16i32 = fptosi <16 x half> undef to <16 x i32>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v16f16_v16i64 = fptosi <16 x half> undef to <16 x i64>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16f16_v16i1 = fptosi <16 x half> undef to <16 x i1>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32f16_v32i8 = fptosi <32 x half> undef to <32 x i8>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32f16_v32i16 = fptosi <32 x half> undef to <32 x i16>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v32f16_v32i32 = fptosi <32 x half> undef to <32 x i32>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %v32f16_v32i64 = fptosi <32 x half> undef to <32 x i64>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v32f16_v32i1 = fptosi <32 x half> undef to <32 x i1>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v64f16_v64i8 = fptosi <64 x half> undef to <64 x i8>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v64f16_v64i16 = fptosi <64 x half> undef to <64 x i16>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %v64f16_v64i32 = fptosi <64 x half> undef to <64 x i32>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 51 for instruction: %v64f16_v64i64 = fptosi <64 x half> undef to <64 x i64>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v64f16_v64i1 = fptosi <64 x half> undef to <64 x i1>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v128f16_v128i8 = fptosi <128 x half> undef to <128 x i8>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v128f16_v128i16 = fptosi <128 x half> undef to <128 x i16>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %v128f16_v128i32 = fptosi <128 x half> undef to <128 x i32>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 102 for instruction: %v128f16_v128i64 = fptosi <128 x half> undef to <128 x i64>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %v128f16_v128i1 = fptosi <128 x half> undef to <128 x i1>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1f16_nxv1i8 = fptosi <vscale x 1 x half> undef to <vscale x 1 x i8>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1f16_nxv1i16 = fptosi <vscale x 1 x half> undef to <vscale x 1 x i16>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1f16_nxv1i32 = fptosi <vscale x 1 x half> undef to <vscale x 1 x i32>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1f16_nxv1i64 = fptosi <vscale x 1 x half> undef to <vscale x 1 x i64>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv1f16_nxv1i1 = fptosi <vscale x 1 x half> undef to <vscale x 1 x i1>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f16_nxv2i8 = fptosi <vscale x 2 x half> undef to <vscale x 2 x i8>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f16_nxv2i16 = fptosi <vscale x 2 x half> undef to <vscale x 2 x i16>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f16_nxv2i32 = fptosi <vscale x 2 x half> undef to <vscale x 2 x i32>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2f16_nxv2i64 = fptosi <vscale x 2 x half> undef to <vscale x 2 x i64>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2f16_nxv2i1 = fptosi <vscale x 2 x half> undef to <vscale x 2 x i1>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4f16_nxv4i8 = fptosi <vscale x 4 x half> undef to <vscale x 4 x i8>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4f16_nxv4i16 = fptosi <vscale x 4 x half> undef to <vscale x 4 x i16>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4f16_nxv4i32 = fptosi <vscale x 4 x half> undef to <vscale x 4 x i32>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv4f16_nxv4i64 = fptosi <vscale x 4 x half> undef to <vscale x 4 x i64>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4f16_nxv4i1 = fptosi <vscale x 4 x half> undef to <vscale x 4 x i1>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8f16_nxv8i8 = fptosi <vscale x 8 x half> undef to <vscale x 8 x i8>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8f16_nxv8i16 = fptosi <vscale x 8 x half> undef to <vscale x 8 x i16>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8f16_nxv8i32 = fptosi <vscale x 8 x half> undef to <vscale x 8 x i32>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %nxv8f16_nxv8i64 = fptosi <vscale x 8 x half> undef to <vscale x 8 x i64>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8f16_nxv8i1 = fptosi <vscale x 8 x half> undef to <vscale x 8 x i1>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16f16_nxv16i8 = fptosi <vscale x 16 x half> undef to <vscale x 16 x i8>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16f16_nxv16i16 = fptosi <vscale x 16 x half> undef to <vscale x 16 x i16>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv16f16_nxv16i32 = fptosi <vscale x 16 x half> undef to <vscale x 16 x i32>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %nxv16f16_nxv16i64 = fptosi <vscale x 16 x half> undef to <vscale x 16 x i64>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv16f16_nxv16i1 = fptosi <vscale x 16 x half> undef to <vscale x 16 x i1>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv32f16_nxv32i8 = fptosi <vscale x 32 x half> undef to <vscale x 32 x i8>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv32f16_nxv32i16 = fptosi <vscale x 32 x half> undef to <vscale x 32 x i16>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %nxv32f16_nxv32i32 = fptosi <vscale x 32 x half> undef to <vscale x 32 x i32>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 51 for instruction: %nxv32f16_nxv32i64 = fptosi <vscale x 32 x half> undef to <vscale x 32 x i64>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %nxv32f16_nxv32i1 = fptosi <vscale x 32 x half> undef to <vscale x 32 x i1>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %nxv64f16_nxv64i8 = fptosi <vscale x 64 x half> undef to <vscale x 64 x i8>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64f16_nxv64i16 = fptosi <vscale x 64 x half> undef to <vscale x 64 x i16>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %nxv64f16_nxv64i32 = fptosi <vscale x 64 x half> undef to <vscale x 64 x i32>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 102 for instruction: %nxv64f16_nxv64i64 = fptosi <vscale x 64 x half> undef to <vscale x 64 x i64>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %nxv64f16_nxv64i1 = fptosi <vscale x 64 x half> undef to <vscale x 64 x i1>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV32ZVFHMIN-LABEL: 'fptosi'
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2f16_v2i8 = fptosi <2 x half> undef to <2 x i8>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f16_v2i16 = fptosi <2 x half> undef to <2 x i16>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f16_v2i32 = fptosi <2 x half> undef to <2 x i32>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f16_v2i64 = fptosi <2 x half> undef to <2 x i64>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v2f16_v2i1 = fptosi <2 x half> undef to <2 x i1>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4f16_v4i8 = fptosi <4 x half> undef to <4 x i8>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f16_v4i16 = fptosi <4 x half> undef to <4 x i16>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f16_v4i32 = fptosi <4 x half> undef to <4 x i32>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4f16_v4i64 = fptosi <4 x half> undef to <4 x i64>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v4f16_v4i1 = fptosi <4 x half> undef to <4 x i1>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8f16_v8i8 = fptosi <8 x half> undef to <8 x i8>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8f16_v8i16 = fptosi <8 x half> undef to <8 x i16>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8f16_v8i32 = fptosi <8 x half> undef to <8 x i32>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v8f16_v8i64 = fptosi <8 x half> undef to <8 x i64>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8f16_v8i1 = fptosi <8 x half> undef to <8 x i1>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v16f16_v16i8 = fptosi <16 x half> undef to <16 x i8>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v16f16_v16i16 = fptosi <16 x half> undef to <16 x i16>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v16f16_v16i32 = fptosi <16 x half> undef to <16 x i32>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v16f16_v16i64 = fptosi <16 x half> undef to <16 x i64>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v16f16_v16i1 = fptosi <16 x half> undef to <16 x i1>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %v32f16_v32i8 = fptosi <32 x half> undef to <32 x i8>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v32f16_v32i16 = fptosi <32 x half> undef to <32 x i16>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v32f16_v32i32 = fptosi <32 x half> undef to <32 x i32>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %v32f16_v32i64 = fptosi <32 x half> undef to <32 x i64>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %v32f16_v32i1 = fptosi <32 x half> undef to <32 x i1>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 29 for instruction: %v64f16_v64i8 = fptosi <64 x half> undef to <64 x i8>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %v64f16_v64i16 = fptosi <64 x half> undef to <64 x i16>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %v64f16_v64i32 = fptosi <64 x half> undef to <64 x i32>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 51 for instruction: %v64f16_v64i64 = fptosi <64 x half> undef to <64 x i64>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 41 for instruction: %v64f16_v64i1 = fptosi <64 x half> undef to <64 x i1>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %v128f16_v128i8 = fptosi <128 x half> undef to <128 x i8>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v128f16_v128i16 = fptosi <128 x half> undef to <128 x i16>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 66 for instruction: %v128f16_v128i32 = fptosi <128 x half> undef to <128 x i32>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 102 for instruction: %v128f16_v128i64 = fptosi <128 x half> undef to <128 x i64>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 83 for instruction: %v128f16_v128i1 = fptosi <128 x half> undef to <128 x i1>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv1f16_nxv1i8 = fptosi <vscale x 1 x half> undef to <vscale x 1 x i8>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1f16_nxv1i16 = fptosi <vscale x 1 x half> undef to <vscale x 1 x i16>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1f16_nxv1i32 = fptosi <vscale x 1 x half> undef to <vscale x 1 x i32>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1f16_nxv1i64 = fptosi <vscale x 1 x half> undef to <vscale x 1 x i64>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv1f16_nxv1i1 = fptosi <vscale x 1 x half> undef to <vscale x 1 x i1>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2f16_nxv2i8 = fptosi <vscale x 2 x half> undef to <vscale x 2 x i8>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f16_nxv2i16 = fptosi <vscale x 2 x half> undef to <vscale x 2 x i16>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f16_nxv2i32 = fptosi <vscale x 2 x half> undef to <vscale x 2 x i32>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2f16_nxv2i64 = fptosi <vscale x 2 x half> undef to <vscale x 2 x i64>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv2f16_nxv2i1 = fptosi <vscale x 2 x half> undef to <vscale x 2 x i1>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4f16_nxv4i8 = fptosi <vscale x 4 x half> undef to <vscale x 4 x i8>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4f16_nxv4i16 = fptosi <vscale x 4 x half> undef to <vscale x 4 x i16>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4f16_nxv4i32 = fptosi <vscale x 4 x half> undef to <vscale x 4 x i32>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv4f16_nxv4i64 = fptosi <vscale x 4 x half> undef to <vscale x 4 x i64>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv4f16_nxv4i1 = fptosi <vscale x 4 x half> undef to <vscale x 4 x i1>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %nxv8f16_nxv8i8 = fptosi <vscale x 8 x half> undef to <vscale x 8 x i8>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv8f16_nxv8i16 = fptosi <vscale x 8 x half> undef to <vscale x 8 x i16>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv8f16_nxv8i32 = fptosi <vscale x 8 x half> undef to <vscale x 8 x i32>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %nxv8f16_nxv8i64 = fptosi <vscale x 8 x half> undef to <vscale x 8 x i64>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %nxv8f16_nxv8i1 = fptosi <vscale x 8 x half> undef to <vscale x 8 x i1>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %nxv16f16_nxv16i8 = fptosi <vscale x 16 x half> undef to <vscale x 16 x i8>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %nxv16f16_nxv16i16 = fptosi <vscale x 16 x half> undef to <vscale x 16 x i16>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %nxv16f16_nxv16i32 = fptosi <vscale x 16 x half> undef to <vscale x 16 x i32>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %nxv16f16_nxv16i64 = fptosi <vscale x 16 x half> undef to <vscale x 16 x i64>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %nxv16f16_nxv16i1 = fptosi <vscale x 16 x half> undef to <vscale x 16 x i1>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 29 for instruction: %nxv32f16_nxv32i8 = fptosi <vscale x 32 x half> undef to <vscale x 32 x i8>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %nxv32f16_nxv32i16 = fptosi <vscale x 32 x half> undef to <vscale x 32 x i16>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %nxv32f16_nxv32i32 = fptosi <vscale x 32 x half> undef to <vscale x 32 x i32>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 51 for instruction: %nxv32f16_nxv32i64 = fptosi <vscale x 32 x half> undef to <vscale x 32 x i64>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 41 for instruction: %nxv32f16_nxv32i1 = fptosi <vscale x 32 x half> undef to <vscale x 32 x i1>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %nxv64f16_nxv64i8 = fptosi <vscale x 64 x half> undef to <vscale x 64 x i8>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64f16_nxv64i16 = fptosi <vscale x 64 x half> undef to <vscale x 64 x i16>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 66 for instruction: %nxv64f16_nxv64i32 = fptosi <vscale x 64 x half> undef to <vscale x 64 x i32>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 102 for instruction: %nxv64f16_nxv64i64 = fptosi <vscale x 64 x half> undef to <vscale x 64 x i64>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 83 for instruction: %nxv64f16_nxv64i1 = fptosi <vscale x 64 x half> undef to <vscale x 64 x i1>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV64ZVFH-LABEL: 'fptosi'
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f16_v2i8 = fptosi <2 x half> undef to <2 x i8>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f16_v2i16 = fptosi <2 x half> undef to <2 x i16>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f16_v2i32 = fptosi <2 x half> undef to <2 x i32>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f16_v2i64 = fptosi <2 x half> undef to <2 x i64>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2f16_v2i1 = fptosi <2 x half> undef to <2 x i1>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f16_v4i8 = fptosi <4 x half> undef to <4 x i8>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f16_v4i16 = fptosi <4 x half> undef to <4 x i16>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f16_v4i32 = fptosi <4 x half> undef to <4 x i32>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4f16_v4i64 = fptosi <4 x half> undef to <4 x i64>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4f16_v4i1 = fptosi <4 x half> undef to <4 x i1>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8f16_v8i8 = fptosi <8 x half> undef to <8 x i8>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8f16_v8i16 = fptosi <8 x half> undef to <8 x i16>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f16_v8i32 = fptosi <8 x half> undef to <8 x i32>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v8f16_v8i64 = fptosi <8 x half> undef to <8 x i64>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8f16_v8i1 = fptosi <8 x half> undef to <8 x i1>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16f16_v16i8 = fptosi <16 x half> undef to <16 x i8>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16f16_v16i16 = fptosi <16 x half> undef to <16 x i16>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16f16_v16i32 = fptosi <16 x half> undef to <16 x i32>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v16f16_v16i64 = fptosi <16 x half> undef to <16 x i64>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16f16_v16i1 = fptosi <16 x half> undef to <16 x i1>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32f16_v32i8 = fptosi <32 x half> undef to <32 x i8>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32f16_v32i16 = fptosi <32 x half> undef to <32 x i16>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v32f16_v32i32 = fptosi <32 x half> undef to <32 x i32>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %v32f16_v32i64 = fptosi <32 x half> undef to <32 x i64>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v32f16_v32i1 = fptosi <32 x half> undef to <32 x i1>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v64f16_v64i8 = fptosi <64 x half> undef to <64 x i8>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v64f16_v64i16 = fptosi <64 x half> undef to <64 x i16>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %v64f16_v64i32 = fptosi <64 x half> undef to <64 x i32>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 51 for instruction: %v64f16_v64i64 = fptosi <64 x half> undef to <64 x i64>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v64f16_v64i1 = fptosi <64 x half> undef to <64 x i1>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v128f16_v128i8 = fptosi <128 x half> undef to <128 x i8>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v128f16_v128i16 = fptosi <128 x half> undef to <128 x i16>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %v128f16_v128i32 = fptosi <128 x half> undef to <128 x i32>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 102 for instruction: %v128f16_v128i64 = fptosi <128 x half> undef to <128 x i64>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %v128f16_v128i1 = fptosi <128 x half> undef to <128 x i1>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1f16_nxv1i8 = fptosi <vscale x 1 x half> undef to <vscale x 1 x i8>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1f16_nxv1i16 = fptosi <vscale x 1 x half> undef to <vscale x 1 x i16>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1f16_nxv1i32 = fptosi <vscale x 1 x half> undef to <vscale x 1 x i32>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1f16_nxv1i64 = fptosi <vscale x 1 x half> undef to <vscale x 1 x i64>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv1f16_nxv1i1 = fptosi <vscale x 1 x half> undef to <vscale x 1 x i1>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f16_nxv2i8 = fptosi <vscale x 2 x half> undef to <vscale x 2 x i8>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f16_nxv2i16 = fptosi <vscale x 2 x half> undef to <vscale x 2 x i16>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f16_nxv2i32 = fptosi <vscale x 2 x half> undef to <vscale x 2 x i32>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2f16_nxv2i64 = fptosi <vscale x 2 x half> undef to <vscale x 2 x i64>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2f16_nxv2i1 = fptosi <vscale x 2 x half> undef to <vscale x 2 x i1>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4f16_nxv4i8 = fptosi <vscale x 4 x half> undef to <vscale x 4 x i8>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4f16_nxv4i16 = fptosi <vscale x 4 x half> undef to <vscale x 4 x i16>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4f16_nxv4i32 = fptosi <vscale x 4 x half> undef to <vscale x 4 x i32>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv4f16_nxv4i64 = fptosi <vscale x 4 x half> undef to <vscale x 4 x i64>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4f16_nxv4i1 = fptosi <vscale x 4 x half> undef to <vscale x 4 x i1>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8f16_nxv8i8 = fptosi <vscale x 8 x half> undef to <vscale x 8 x i8>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8f16_nxv8i16 = fptosi <vscale x 8 x half> undef to <vscale x 8 x i16>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8f16_nxv8i32 = fptosi <vscale x 8 x half> undef to <vscale x 8 x i32>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %nxv8f16_nxv8i64 = fptosi <vscale x 8 x half> undef to <vscale x 8 x i64>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8f16_nxv8i1 = fptosi <vscale x 8 x half> undef to <vscale x 8 x i1>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16f16_nxv16i8 = fptosi <vscale x 16 x half> undef to <vscale x 16 x i8>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16f16_nxv16i16 = fptosi <vscale x 16 x half> undef to <vscale x 16 x i16>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv16f16_nxv16i32 = fptosi <vscale x 16 x half> undef to <vscale x 16 x i32>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %nxv16f16_nxv16i64 = fptosi <vscale x 16 x half> undef to <vscale x 16 x i64>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv16f16_nxv16i1 = fptosi <vscale x 16 x half> undef to <vscale x 16 x i1>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv32f16_nxv32i8 = fptosi <vscale x 32 x half> undef to <vscale x 32 x i8>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv32f16_nxv32i16 = fptosi <vscale x 32 x half> undef to <vscale x 32 x i16>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %nxv32f16_nxv32i32 = fptosi <vscale x 32 x half> undef to <vscale x 32 x i32>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 51 for instruction: %nxv32f16_nxv32i64 = fptosi <vscale x 32 x half> undef to <vscale x 32 x i64>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %nxv32f16_nxv32i1 = fptosi <vscale x 32 x half> undef to <vscale x 32 x i1>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %nxv64f16_nxv64i8 = fptosi <vscale x 64 x half> undef to <vscale x 64 x i8>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64f16_nxv64i16 = fptosi <vscale x 64 x half> undef to <vscale x 64 x i16>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %nxv64f16_nxv64i32 = fptosi <vscale x 64 x half> undef to <vscale x 64 x i32>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 102 for instruction: %nxv64f16_nxv64i64 = fptosi <vscale x 64 x half> undef to <vscale x 64 x i64>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %nxv64f16_nxv64i1 = fptosi <vscale x 64 x half> undef to <vscale x 64 x i1>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV64ZVFHMIN-LABEL: 'fptosi'
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2f16_v2i8 = fptosi <2 x half> undef to <2 x i8>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f16_v2i16 = fptosi <2 x half> undef to <2 x i16>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f16_v2i32 = fptosi <2 x half> undef to <2 x i32>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f16_v2i64 = fptosi <2 x half> undef to <2 x i64>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v2f16_v2i1 = fptosi <2 x half> undef to <2 x i1>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4f16_v4i8 = fptosi <4 x half> undef to <4 x i8>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f16_v4i16 = fptosi <4 x half> undef to <4 x i16>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f16_v4i32 = fptosi <4 x half> undef to <4 x i32>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4f16_v4i64 = fptosi <4 x half> undef to <4 x i64>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v4f16_v4i1 = fptosi <4 x half> undef to <4 x i1>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8f16_v8i8 = fptosi <8 x half> undef to <8 x i8>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8f16_v8i16 = fptosi <8 x half> undef to <8 x i16>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8f16_v8i32 = fptosi <8 x half> undef to <8 x i32>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v8f16_v8i64 = fptosi <8 x half> undef to <8 x i64>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8f16_v8i1 = fptosi <8 x half> undef to <8 x i1>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v16f16_v16i8 = fptosi <16 x half> undef to <16 x i8>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v16f16_v16i16 = fptosi <16 x half> undef to <16 x i16>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v16f16_v16i32 = fptosi <16 x half> undef to <16 x i32>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v16f16_v16i64 = fptosi <16 x half> undef to <16 x i64>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v16f16_v16i1 = fptosi <16 x half> undef to <16 x i1>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %v32f16_v32i8 = fptosi <32 x half> undef to <32 x i8>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v32f16_v32i16 = fptosi <32 x half> undef to <32 x i16>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v32f16_v32i32 = fptosi <32 x half> undef to <32 x i32>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %v32f16_v32i64 = fptosi <32 x half> undef to <32 x i64>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %v32f16_v32i1 = fptosi <32 x half> undef to <32 x i1>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 29 for instruction: %v64f16_v64i8 = fptosi <64 x half> undef to <64 x i8>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %v64f16_v64i16 = fptosi <64 x half> undef to <64 x i16>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %v64f16_v64i32 = fptosi <64 x half> undef to <64 x i32>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 51 for instruction: %v64f16_v64i64 = fptosi <64 x half> undef to <64 x i64>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 41 for instruction: %v64f16_v64i1 = fptosi <64 x half> undef to <64 x i1>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %v128f16_v128i8 = fptosi <128 x half> undef to <128 x i8>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v128f16_v128i16 = fptosi <128 x half> undef to <128 x i16>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 66 for instruction: %v128f16_v128i32 = fptosi <128 x half> undef to <128 x i32>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 102 for instruction: %v128f16_v128i64 = fptosi <128 x half> undef to <128 x i64>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 83 for instruction: %v128f16_v128i1 = fptosi <128 x half> undef to <128 x i1>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv1f16_nxv1i8 = fptosi <vscale x 1 x half> undef to <vscale x 1 x i8>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1f16_nxv1i16 = fptosi <vscale x 1 x half> undef to <vscale x 1 x i16>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1f16_nxv1i32 = fptosi <vscale x 1 x half> undef to <vscale x 1 x i32>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1f16_nxv1i64 = fptosi <vscale x 1 x half> undef to <vscale x 1 x i64>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv1f16_nxv1i1 = fptosi <vscale x 1 x half> undef to <vscale x 1 x i1>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2f16_nxv2i8 = fptosi <vscale x 2 x half> undef to <vscale x 2 x i8>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f16_nxv2i16 = fptosi <vscale x 2 x half> undef to <vscale x 2 x i16>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f16_nxv2i32 = fptosi <vscale x 2 x half> undef to <vscale x 2 x i32>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2f16_nxv2i64 = fptosi <vscale x 2 x half> undef to <vscale x 2 x i64>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv2f16_nxv2i1 = fptosi <vscale x 2 x half> undef to <vscale x 2 x i1>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4f16_nxv4i8 = fptosi <vscale x 4 x half> undef to <vscale x 4 x i8>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4f16_nxv4i16 = fptosi <vscale x 4 x half> undef to <vscale x 4 x i16>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4f16_nxv4i32 = fptosi <vscale x 4 x half> undef to <vscale x 4 x i32>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv4f16_nxv4i64 = fptosi <vscale x 4 x half> undef to <vscale x 4 x i64>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv4f16_nxv4i1 = fptosi <vscale x 4 x half> undef to <vscale x 4 x i1>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %nxv8f16_nxv8i8 = fptosi <vscale x 8 x half> undef to <vscale x 8 x i8>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv8f16_nxv8i16 = fptosi <vscale x 8 x half> undef to <vscale x 8 x i16>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv8f16_nxv8i32 = fptosi <vscale x 8 x half> undef to <vscale x 8 x i32>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %nxv8f16_nxv8i64 = fptosi <vscale x 8 x half> undef to <vscale x 8 x i64>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %nxv8f16_nxv8i1 = fptosi <vscale x 8 x half> undef to <vscale x 8 x i1>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %nxv16f16_nxv16i8 = fptosi <vscale x 16 x half> undef to <vscale x 16 x i8>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %nxv16f16_nxv16i16 = fptosi <vscale x 16 x half> undef to <vscale x 16 x i16>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %nxv16f16_nxv16i32 = fptosi <vscale x 16 x half> undef to <vscale x 16 x i32>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %nxv16f16_nxv16i64 = fptosi <vscale x 16 x half> undef to <vscale x 16 x i64>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %nxv16f16_nxv16i1 = fptosi <vscale x 16 x half> undef to <vscale x 16 x i1>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 29 for instruction: %nxv32f16_nxv32i8 = fptosi <vscale x 32 x half> undef to <vscale x 32 x i8>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %nxv32f16_nxv32i16 = fptosi <vscale x 32 x half> undef to <vscale x 32 x i16>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %nxv32f16_nxv32i32 = fptosi <vscale x 32 x half> undef to <vscale x 32 x i32>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 51 for instruction: %nxv32f16_nxv32i64 = fptosi <vscale x 32 x half> undef to <vscale x 32 x i64>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 41 for instruction: %nxv32f16_nxv32i1 = fptosi <vscale x 32 x half> undef to <vscale x 32 x i1>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %nxv64f16_nxv64i8 = fptosi <vscale x 64 x half> undef to <vscale x 64 x i8>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64f16_nxv64i16 = fptosi <vscale x 64 x half> undef to <vscale x 64 x i16>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 66 for instruction: %nxv64f16_nxv64i32 = fptosi <vscale x 64 x half> undef to <vscale x 64 x i32>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 102 for instruction: %nxv64f16_nxv64i64 = fptosi <vscale x 64 x half> undef to <vscale x 64 x i64>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 83 for instruction: %nxv64f16_nxv64i1 = fptosi <vscale x 64 x half> undef to <vscale x 64 x i1>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %v2f16_v2i8 = fptosi <2 x half> undef to <2 x i8>
  %v2f16_v2i16 = fptosi <2 x half> undef to <2 x i16>
  %v2f16_v2i32 = fptosi <2 x half> undef to <2 x i32>
  %v2f16_v2i64 = fptosi <2 x half> undef to <2 x i64>
  %v2f16_v2i1 = fptosi <2 x half> undef to <2 x i1>
  %v4f16_v4i8 = fptosi <4 x half> undef to <4 x i8>
  %v4f16_v4i16 = fptosi <4 x half> undef to <4 x i16>
  %v4f16_v4i32 = fptosi <4 x half> undef to <4 x i32>
  %v4f16_v4i64 = fptosi <4 x half> undef to <4 x i64>
  %v4f16_v4i1 = fptosi <4 x half> undef to <4 x i1>
  %v8f16_v8i8 = fptosi <8 x half> undef to <8 x i8>
  %v8f16_v8i16 = fptosi <8 x half> undef to <8 x i16>
  %v8f16_v8i32 = fptosi <8 x half> undef to <8 x i32>
  %v8f16_v8i64 = fptosi <8 x half> undef to <8 x i64>
  %v8f16_v8i1 = fptosi <8 x half> undef to <8 x i1>
  %v16f16_v16i8 = fptosi <16 x half> undef to <16 x i8>
  %v16f16_v16i16 = fptosi <16 x half> undef to <16 x i16>
  %v16f16_v16i32 = fptosi <16 x half> undef to <16 x i32>
  %v16f16_v16i64 = fptosi <16 x half> undef to <16 x i64>
  %v16f16_v16i1 = fptosi <16 x half> undef to <16 x i1>
  %v32f16_v32i8 = fptosi <32 x half> undef to <32 x i8>
  %v32f16_v32i16 = fptosi <32 x half> undef to <32 x i16>
  %v32f16_v32i32 = fptosi <32 x half> undef to <32 x i32>
  %v32f16_v32i64 = fptosi <32 x half> undef to <32 x i64>
  %v32f16_v32i1 = fptosi <32 x half> undef to <32 x i1>
  %v64f16_v64i8 = fptosi <64 x half> undef to <64 x i8>
  %v64f16_v64i16 = fptosi <64 x half> undef to <64 x i16>
  %v64f16_v64i32 = fptosi <64 x half> undef to <64 x i32>
  %v64f16_v64i64 = fptosi <64 x half> undef to <64 x i64>
  %v64f16_v64i1 = fptosi <64 x half> undef to <64 x i1>
  %v128f16_v128i8 = fptosi <128 x half> undef to <128 x i8>
  %v128f16_v128i16 = fptosi <128 x half> undef to <128 x i16>
  %v128f16_v128i32 = fptosi <128 x half> undef to <128 x i32>
  %v128f16_v128i64 = fptosi <128 x half> undef to <128 x i64>
  %v128f16_v128i1 = fptosi <128 x half> undef to <128 x i1>
  %nxv1f16_nxv1i8 = fptosi <vscale x 1 x half> undef to <vscale x 1 x i8>
  %nxv1f16_nxv1i16 = fptosi <vscale x 1 x half> undef to <vscale x 1 x i16>
  %nxv1f16_nxv1i32 = fptosi <vscale x 1 x half> undef to <vscale x 1 x i32>
  %nxv1f16_nxv1i64 = fptosi <vscale x 1 x half> undef to <vscale x 1 x i64>
  %nxv1f16_nxv1i1 = fptosi <vscale x 1 x half> undef to <vscale x 1 x i1>
  %nxv2f16_nxv2i8 = fptosi <vscale x 2 x half> undef to <vscale x 2 x i8>
  %nxv2f16_nxv2i16 = fptosi <vscale x 2 x half> undef to <vscale x 2 x i16>
  %nxv2f16_nxv2i32 = fptosi <vscale x 2 x half> undef to <vscale x 2 x i32>
  %nxv2f16_nxv2i64 = fptosi <vscale x 2 x half> undef to <vscale x 2 x i64>
  %nxv2f16_nxv2i1 = fptosi <vscale x 2 x half> undef to <vscale x 2 x i1>
  %nxv4f16_nxv4i8 = fptosi <vscale x 4 x half> undef to <vscale x 4 x i8>
  %nxv4f16_nxv4i16 = fptosi <vscale x 4 x half> undef to <vscale x 4 x i16>
  %nxv4f16_nxv4i32 = fptosi <vscale x 4 x half> undef to <vscale x 4 x i32>
  %nxv4f16_nxv4i64 = fptosi <vscale x 4 x half> undef to <vscale x 4 x i64>
  %nxv4f16_nxv4i1 = fptosi <vscale x 4 x half> undef to <vscale x 4 x i1>
  %nxv8f16_nxv8i8 = fptosi <vscale x 8 x half> undef to <vscale x 8 x i8>
  %nxv8f16_nxv8i16 = fptosi <vscale x 8 x half> undef to <vscale x 8 x i16>
  %nxv8f16_nxv8i32 = fptosi <vscale x 8 x half> undef to <vscale x 8 x i32>
  %nxv8f16_nxv8i64 = fptosi <vscale x 8 x half> undef to <vscale x 8 x i64>
  %nxv8f16_nxv8i1 = fptosi <vscale x 8 x half> undef to <vscale x 8 x i1>
  %nxv16f16_nxv16i8 = fptosi <vscale x 16 x half> undef to <vscale x 16 x i8>
  %nxv16f16_nxv16i16 = fptosi <vscale x 16 x half> undef to <vscale x 16 x i16>
  %nxv16f16_nxv16i32 = fptosi <vscale x 16 x half> undef to <vscale x 16 x i32>
  %nxv16f16_nxv16i64 = fptosi <vscale x 16 x half> undef to <vscale x 16 x i64>
  %nxv16f16_nxv16i1 = fptosi <vscale x 16 x half> undef to <vscale x 16 x i1>
  %nxv32f16_nxv32i8 = fptosi <vscale x 32 x half> undef to <vscale x 32 x i8>
  %nxv32f16_nxv32i16 = fptosi <vscale x 32 x half> undef to <vscale x 32 x i16>
  %nxv32f16_nxv32i32 = fptosi <vscale x 32 x half> undef to <vscale x 32 x i32>
  %nxv32f16_nxv32i64 = fptosi <vscale x 32 x half> undef to <vscale x 32 x i64>
  %nxv32f16_nxv32i1 = fptosi <vscale x 32 x half> undef to <vscale x 32 x i1>
  %nxv64f16_nxv64i8 = fptosi <vscale x 64 x half> undef to <vscale x 64 x i8>
  %nxv64f16_nxv64i16 = fptosi <vscale x 64 x half> undef to <vscale x 64 x i16>
  %nxv64f16_nxv64i32 = fptosi <vscale x 64 x half> undef to <vscale x 64 x i32>
  %nxv64f16_nxv64i64 = fptosi <vscale x 64 x half> undef to <vscale x 64 x i64>
  %nxv64f16_nxv64i1 = fptosi <vscale x 64 x half> undef to <vscale x 64 x i1>
  ret void
}

define void @fptoui() {
; RV32ZVFH-LABEL: 'fptoui'
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f16_v2i8 = fptoui <2 x half> undef to <2 x i8>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f16_v2i16 = fptoui <2 x half> undef to <2 x i16>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f16_v2i32 = fptoui <2 x half> undef to <2 x i32>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f16_v2i64 = fptoui <2 x half> undef to <2 x i64>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2f16_v2i1 = fptoui <2 x half> undef to <2 x i1>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f16_v4i8 = fptoui <4 x half> undef to <4 x i8>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f16_v4i16 = fptoui <4 x half> undef to <4 x i16>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f16_v4i32 = fptoui <4 x half> undef to <4 x i32>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4f16_v4i64 = fptoui <4 x half> undef to <4 x i64>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4f16_v4i1 = fptoui <4 x half> undef to <4 x i1>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8f16_v8i8 = fptoui <8 x half> undef to <8 x i8>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8f16_v8i16 = fptoui <8 x half> undef to <8 x i16>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f16_v8i32 = fptoui <8 x half> undef to <8 x i32>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v8f16_v8i64 = fptoui <8 x half> undef to <8 x i64>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8f16_v8i1 = fptoui <8 x half> undef to <8 x i1>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16f16_v16i8 = fptoui <16 x half> undef to <16 x i8>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16f16_v16i16 = fptoui <16 x half> undef to <16 x i16>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16f16_v16i32 = fptoui <16 x half> undef to <16 x i32>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v16f16_v16i64 = fptoui <16 x half> undef to <16 x i64>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16f16_v16i1 = fptoui <16 x half> undef to <16 x i1>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32f16_v32i8 = fptoui <32 x half> undef to <32 x i8>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32f16_v32i16 = fptoui <32 x half> undef to <32 x i16>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v32f16_v32i32 = fptoui <32 x half> undef to <32 x i32>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %v32f16_v32i64 = fptoui <32 x half> undef to <32 x i64>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v32f16_v32i1 = fptoui <32 x half> undef to <32 x i1>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v64f16_v64i8 = fptoui <64 x half> undef to <64 x i8>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v64f16_v64i16 = fptoui <64 x half> undef to <64 x i16>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %v64f16_v64i32 = fptoui <64 x half> undef to <64 x i32>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 51 for instruction: %v64f16_v64i64 = fptoui <64 x half> undef to <64 x i64>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v64f16_v64i1 = fptoui <64 x half> undef to <64 x i1>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v128f16_v128i8 = fptoui <128 x half> undef to <128 x i8>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v128f16_v128i16 = fptoui <128 x half> undef to <128 x i16>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %v128f16_v128i32 = fptoui <128 x half> undef to <128 x i32>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 102 for instruction: %v128f16_v128i64 = fptoui <128 x half> undef to <128 x i64>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %v128f16_v128i1 = fptoui <128 x half> undef to <128 x i1>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1f16_nxv1i8 = fptoui <vscale x 1 x half> undef to <vscale x 1 x i8>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1f16_nxv1i16 = fptoui <vscale x 1 x half> undef to <vscale x 1 x i16>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1f16_nxv1i32 = fptoui <vscale x 1 x half> undef to <vscale x 1 x i32>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1f16_nxv1i64 = fptoui <vscale x 1 x half> undef to <vscale x 1 x i64>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv1f16_nxv1i1 = fptoui <vscale x 1 x half> undef to <vscale x 1 x i1>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f16_nxv2i8 = fptoui <vscale x 2 x half> undef to <vscale x 2 x i8>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f16_nxv2i16 = fptoui <vscale x 2 x half> undef to <vscale x 2 x i16>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f16_nxv2i32 = fptoui <vscale x 2 x half> undef to <vscale x 2 x i32>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2f16_nxv2i64 = fptoui <vscale x 2 x half> undef to <vscale x 2 x i64>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2f16_nxv2i1 = fptoui <vscale x 2 x half> undef to <vscale x 2 x i1>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4f16_nxv4i8 = fptoui <vscale x 4 x half> undef to <vscale x 4 x i8>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4f16_nxv4i16 = fptoui <vscale x 4 x half> undef to <vscale x 4 x i16>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4f16_nxv4i32 = fptoui <vscale x 4 x half> undef to <vscale x 4 x i32>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv4f16_nxv4i64 = fptoui <vscale x 4 x half> undef to <vscale x 4 x i64>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4f16_nxv4i1 = fptoui <vscale x 4 x half> undef to <vscale x 4 x i1>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8f16_nxv8i8 = fptoui <vscale x 8 x half> undef to <vscale x 8 x i8>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8f16_nxv8i16 = fptoui <vscale x 8 x half> undef to <vscale x 8 x i16>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8f16_nxv8i32 = fptoui <vscale x 8 x half> undef to <vscale x 8 x i32>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %nxv8f16_nxv8i64 = fptoui <vscale x 8 x half> undef to <vscale x 8 x i64>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8f16_nxv8i1 = fptoui <vscale x 8 x half> undef to <vscale x 8 x i1>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16f16_nxv16i8 = fptoui <vscale x 16 x half> undef to <vscale x 16 x i8>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16f16_nxv16i16 = fptoui <vscale x 16 x half> undef to <vscale x 16 x i16>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv16f16_nxv16i32 = fptoui <vscale x 16 x half> undef to <vscale x 16 x i32>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %nxv16f16_nxv16i64 = fptoui <vscale x 16 x half> undef to <vscale x 16 x i64>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv16f16_nxv16i1 = fptoui <vscale x 16 x half> undef to <vscale x 16 x i1>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv32f16_nxv32i8 = fptoui <vscale x 32 x half> undef to <vscale x 32 x i8>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv32f16_nxv32i16 = fptoui <vscale x 32 x half> undef to <vscale x 32 x i16>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %nxv32f16_nxv32i32 = fptoui <vscale x 32 x half> undef to <vscale x 32 x i32>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 51 for instruction: %nxv32f16_nxv32i64 = fptoui <vscale x 32 x half> undef to <vscale x 32 x i64>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %nxv32f16_nxv32i1 = fptoui <vscale x 32 x half> undef to <vscale x 32 x i1>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %nxv64f16_nxv64i8 = fptoui <vscale x 64 x half> undef to <vscale x 64 x i8>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64f16_nxv64i16 = fptoui <vscale x 64 x half> undef to <vscale x 64 x i16>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %nxv64f16_nxv64i32 = fptoui <vscale x 64 x half> undef to <vscale x 64 x i32>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 102 for instruction: %nxv64f16_nxv64i64 = fptoui <vscale x 64 x half> undef to <vscale x 64 x i64>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %nxv64f16_nxv64i1 = fptoui <vscale x 64 x half> undef to <vscale x 64 x i1>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV32ZVFHMIN-LABEL: 'fptoui'
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2f16_v2i8 = fptoui <2 x half> undef to <2 x i8>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f16_v2i16 = fptoui <2 x half> undef to <2 x i16>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f16_v2i32 = fptoui <2 x half> undef to <2 x i32>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f16_v2i64 = fptoui <2 x half> undef to <2 x i64>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v2f16_v2i1 = fptoui <2 x half> undef to <2 x i1>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4f16_v4i8 = fptoui <4 x half> undef to <4 x i8>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f16_v4i16 = fptoui <4 x half> undef to <4 x i16>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f16_v4i32 = fptoui <4 x half> undef to <4 x i32>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4f16_v4i64 = fptoui <4 x half> undef to <4 x i64>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v4f16_v4i1 = fptoui <4 x half> undef to <4 x i1>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8f16_v8i8 = fptoui <8 x half> undef to <8 x i8>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8f16_v8i16 = fptoui <8 x half> undef to <8 x i16>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8f16_v8i32 = fptoui <8 x half> undef to <8 x i32>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v8f16_v8i64 = fptoui <8 x half> undef to <8 x i64>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8f16_v8i1 = fptoui <8 x half> undef to <8 x i1>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v16f16_v16i8 = fptoui <16 x half> undef to <16 x i8>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v16f16_v16i16 = fptoui <16 x half> undef to <16 x i16>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v16f16_v16i32 = fptoui <16 x half> undef to <16 x i32>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v16f16_v16i64 = fptoui <16 x half> undef to <16 x i64>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v16f16_v16i1 = fptoui <16 x half> undef to <16 x i1>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %v32f16_v32i8 = fptoui <32 x half> undef to <32 x i8>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v32f16_v32i16 = fptoui <32 x half> undef to <32 x i16>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v32f16_v32i32 = fptoui <32 x half> undef to <32 x i32>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %v32f16_v32i64 = fptoui <32 x half> undef to <32 x i64>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %v32f16_v32i1 = fptoui <32 x half> undef to <32 x i1>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 29 for instruction: %v64f16_v64i8 = fptoui <64 x half> undef to <64 x i8>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %v64f16_v64i16 = fptoui <64 x half> undef to <64 x i16>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %v64f16_v64i32 = fptoui <64 x half> undef to <64 x i32>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 51 for instruction: %v64f16_v64i64 = fptoui <64 x half> undef to <64 x i64>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 41 for instruction: %v64f16_v64i1 = fptoui <64 x half> undef to <64 x i1>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %v128f16_v128i8 = fptoui <128 x half> undef to <128 x i8>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v128f16_v128i16 = fptoui <128 x half> undef to <128 x i16>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 66 for instruction: %v128f16_v128i32 = fptoui <128 x half> undef to <128 x i32>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 102 for instruction: %v128f16_v128i64 = fptoui <128 x half> undef to <128 x i64>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 83 for instruction: %v128f16_v128i1 = fptoui <128 x half> undef to <128 x i1>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv1f16_nxv1i8 = fptoui <vscale x 1 x half> undef to <vscale x 1 x i8>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1f16_nxv1i16 = fptoui <vscale x 1 x half> undef to <vscale x 1 x i16>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1f16_nxv1i32 = fptoui <vscale x 1 x half> undef to <vscale x 1 x i32>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1f16_nxv1i64 = fptoui <vscale x 1 x half> undef to <vscale x 1 x i64>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv1f16_nxv1i1 = fptoui <vscale x 1 x half> undef to <vscale x 1 x i1>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2f16_nxv2i8 = fptoui <vscale x 2 x half> undef to <vscale x 2 x i8>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f16_nxv2i16 = fptoui <vscale x 2 x half> undef to <vscale x 2 x i16>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f16_nxv2i32 = fptoui <vscale x 2 x half> undef to <vscale x 2 x i32>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2f16_nxv2i64 = fptoui <vscale x 2 x half> undef to <vscale x 2 x i64>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv2f16_nxv2i1 = fptoui <vscale x 2 x half> undef to <vscale x 2 x i1>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4f16_nxv4i8 = fptoui <vscale x 4 x half> undef to <vscale x 4 x i8>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4f16_nxv4i16 = fptoui <vscale x 4 x half> undef to <vscale x 4 x i16>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4f16_nxv4i32 = fptoui <vscale x 4 x half> undef to <vscale x 4 x i32>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv4f16_nxv4i64 = fptoui <vscale x 4 x half> undef to <vscale x 4 x i64>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv4f16_nxv4i1 = fptoui <vscale x 4 x half> undef to <vscale x 4 x i1>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %nxv8f16_nxv8i8 = fptoui <vscale x 8 x half> undef to <vscale x 8 x i8>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv8f16_nxv8i16 = fptoui <vscale x 8 x half> undef to <vscale x 8 x i16>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv8f16_nxv8i32 = fptoui <vscale x 8 x half> undef to <vscale x 8 x i32>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %nxv8f16_nxv8i64 = fptoui <vscale x 8 x half> undef to <vscale x 8 x i64>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %nxv8f16_nxv8i1 = fptoui <vscale x 8 x half> undef to <vscale x 8 x i1>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %nxv16f16_nxv16i8 = fptoui <vscale x 16 x half> undef to <vscale x 16 x i8>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %nxv16f16_nxv16i16 = fptoui <vscale x 16 x half> undef to <vscale x 16 x i16>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %nxv16f16_nxv16i32 = fptoui <vscale x 16 x half> undef to <vscale x 16 x i32>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %nxv16f16_nxv16i64 = fptoui <vscale x 16 x half> undef to <vscale x 16 x i64>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %nxv16f16_nxv16i1 = fptoui <vscale x 16 x half> undef to <vscale x 16 x i1>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 29 for instruction: %nxv32f16_nxv32i8 = fptoui <vscale x 32 x half> undef to <vscale x 32 x i8>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %nxv32f16_nxv32i16 = fptoui <vscale x 32 x half> undef to <vscale x 32 x i16>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %nxv32f16_nxv32i32 = fptoui <vscale x 32 x half> undef to <vscale x 32 x i32>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 51 for instruction: %nxv32f16_nxv32i64 = fptoui <vscale x 32 x half> undef to <vscale x 32 x i64>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 41 for instruction: %nxv32f16_nxv32i1 = fptoui <vscale x 32 x half> undef to <vscale x 32 x i1>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %nxv64f16_nxv64i8 = fptoui <vscale x 64 x half> undef to <vscale x 64 x i8>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64f16_nxv64i16 = fptoui <vscale x 64 x half> undef to <vscale x 64 x i16>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 66 for instruction: %nxv64f16_nxv64i32 = fptoui <vscale x 64 x half> undef to <vscale x 64 x i32>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 102 for instruction: %nxv64f16_nxv64i64 = fptoui <vscale x 64 x half> undef to <vscale x 64 x i64>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 83 for instruction: %nxv64f16_nxv64i1 = fptoui <vscale x 64 x half> undef to <vscale x 64 x i1>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV64ZVFH-LABEL: 'fptoui'
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f16_v2i8 = fptoui <2 x half> undef to <2 x i8>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f16_v2i16 = fptoui <2 x half> undef to <2 x i16>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f16_v2i32 = fptoui <2 x half> undef to <2 x i32>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f16_v2i64 = fptoui <2 x half> undef to <2 x i64>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2f16_v2i1 = fptoui <2 x half> undef to <2 x i1>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f16_v4i8 = fptoui <4 x half> undef to <4 x i8>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f16_v4i16 = fptoui <4 x half> undef to <4 x i16>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f16_v4i32 = fptoui <4 x half> undef to <4 x i32>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4f16_v4i64 = fptoui <4 x half> undef to <4 x i64>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4f16_v4i1 = fptoui <4 x half> undef to <4 x i1>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8f16_v8i8 = fptoui <8 x half> undef to <8 x i8>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8f16_v8i16 = fptoui <8 x half> undef to <8 x i16>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f16_v8i32 = fptoui <8 x half> undef to <8 x i32>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v8f16_v8i64 = fptoui <8 x half> undef to <8 x i64>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8f16_v8i1 = fptoui <8 x half> undef to <8 x i1>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16f16_v16i8 = fptoui <16 x half> undef to <16 x i8>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16f16_v16i16 = fptoui <16 x half> undef to <16 x i16>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16f16_v16i32 = fptoui <16 x half> undef to <16 x i32>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v16f16_v16i64 = fptoui <16 x half> undef to <16 x i64>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16f16_v16i1 = fptoui <16 x half> undef to <16 x i1>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32f16_v32i8 = fptoui <32 x half> undef to <32 x i8>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32f16_v32i16 = fptoui <32 x half> undef to <32 x i16>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v32f16_v32i32 = fptoui <32 x half> undef to <32 x i32>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %v32f16_v32i64 = fptoui <32 x half> undef to <32 x i64>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v32f16_v32i1 = fptoui <32 x half> undef to <32 x i1>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v64f16_v64i8 = fptoui <64 x half> undef to <64 x i8>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v64f16_v64i16 = fptoui <64 x half> undef to <64 x i16>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %v64f16_v64i32 = fptoui <64 x half> undef to <64 x i32>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 51 for instruction: %v64f16_v64i64 = fptoui <64 x half> undef to <64 x i64>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v64f16_v64i1 = fptoui <64 x half> undef to <64 x i1>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v128f16_v128i8 = fptoui <128 x half> undef to <128 x i8>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v128f16_v128i16 = fptoui <128 x half> undef to <128 x i16>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %v128f16_v128i32 = fptoui <128 x half> undef to <128 x i32>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 102 for instruction: %v128f16_v128i64 = fptoui <128 x half> undef to <128 x i64>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %v128f16_v128i1 = fptoui <128 x half> undef to <128 x i1>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1f16_nxv1i8 = fptoui <vscale x 1 x half> undef to <vscale x 1 x i8>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1f16_nxv1i16 = fptoui <vscale x 1 x half> undef to <vscale x 1 x i16>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1f16_nxv1i32 = fptoui <vscale x 1 x half> undef to <vscale x 1 x i32>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1f16_nxv1i64 = fptoui <vscale x 1 x half> undef to <vscale x 1 x i64>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv1f16_nxv1i1 = fptoui <vscale x 1 x half> undef to <vscale x 1 x i1>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f16_nxv2i8 = fptoui <vscale x 2 x half> undef to <vscale x 2 x i8>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f16_nxv2i16 = fptoui <vscale x 2 x half> undef to <vscale x 2 x i16>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f16_nxv2i32 = fptoui <vscale x 2 x half> undef to <vscale x 2 x i32>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2f16_nxv2i64 = fptoui <vscale x 2 x half> undef to <vscale x 2 x i64>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2f16_nxv2i1 = fptoui <vscale x 2 x half> undef to <vscale x 2 x i1>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4f16_nxv4i8 = fptoui <vscale x 4 x half> undef to <vscale x 4 x i8>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4f16_nxv4i16 = fptoui <vscale x 4 x half> undef to <vscale x 4 x i16>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4f16_nxv4i32 = fptoui <vscale x 4 x half> undef to <vscale x 4 x i32>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv4f16_nxv4i64 = fptoui <vscale x 4 x half> undef to <vscale x 4 x i64>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4f16_nxv4i1 = fptoui <vscale x 4 x half> undef to <vscale x 4 x i1>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8f16_nxv8i8 = fptoui <vscale x 8 x half> undef to <vscale x 8 x i8>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8f16_nxv8i16 = fptoui <vscale x 8 x half> undef to <vscale x 8 x i16>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8f16_nxv8i32 = fptoui <vscale x 8 x half> undef to <vscale x 8 x i32>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %nxv8f16_nxv8i64 = fptoui <vscale x 8 x half> undef to <vscale x 8 x i64>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8f16_nxv8i1 = fptoui <vscale x 8 x half> undef to <vscale x 8 x i1>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16f16_nxv16i8 = fptoui <vscale x 16 x half> undef to <vscale x 16 x i8>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16f16_nxv16i16 = fptoui <vscale x 16 x half> undef to <vscale x 16 x i16>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv16f16_nxv16i32 = fptoui <vscale x 16 x half> undef to <vscale x 16 x i32>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %nxv16f16_nxv16i64 = fptoui <vscale x 16 x half> undef to <vscale x 16 x i64>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv16f16_nxv16i1 = fptoui <vscale x 16 x half> undef to <vscale x 16 x i1>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv32f16_nxv32i8 = fptoui <vscale x 32 x half> undef to <vscale x 32 x i8>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv32f16_nxv32i16 = fptoui <vscale x 32 x half> undef to <vscale x 32 x i16>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %nxv32f16_nxv32i32 = fptoui <vscale x 32 x half> undef to <vscale x 32 x i32>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 51 for instruction: %nxv32f16_nxv32i64 = fptoui <vscale x 32 x half> undef to <vscale x 32 x i64>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %nxv32f16_nxv32i1 = fptoui <vscale x 32 x half> undef to <vscale x 32 x i1>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %nxv64f16_nxv64i8 = fptoui <vscale x 64 x half> undef to <vscale x 64 x i8>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64f16_nxv64i16 = fptoui <vscale x 64 x half> undef to <vscale x 64 x i16>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %nxv64f16_nxv64i32 = fptoui <vscale x 64 x half> undef to <vscale x 64 x i32>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 102 for instruction: %nxv64f16_nxv64i64 = fptoui <vscale x 64 x half> undef to <vscale x 64 x i64>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %nxv64f16_nxv64i1 = fptoui <vscale x 64 x half> undef to <vscale x 64 x i1>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV64ZVFHMIN-LABEL: 'fptoui'
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2f16_v2i8 = fptoui <2 x half> undef to <2 x i8>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f16_v2i16 = fptoui <2 x half> undef to <2 x i16>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f16_v2i32 = fptoui <2 x half> undef to <2 x i32>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f16_v2i64 = fptoui <2 x half> undef to <2 x i64>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v2f16_v2i1 = fptoui <2 x half> undef to <2 x i1>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4f16_v4i8 = fptoui <4 x half> undef to <4 x i8>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f16_v4i16 = fptoui <4 x half> undef to <4 x i16>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f16_v4i32 = fptoui <4 x half> undef to <4 x i32>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4f16_v4i64 = fptoui <4 x half> undef to <4 x i64>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v4f16_v4i1 = fptoui <4 x half> undef to <4 x i1>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8f16_v8i8 = fptoui <8 x half> undef to <8 x i8>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8f16_v8i16 = fptoui <8 x half> undef to <8 x i16>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8f16_v8i32 = fptoui <8 x half> undef to <8 x i32>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v8f16_v8i64 = fptoui <8 x half> undef to <8 x i64>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8f16_v8i1 = fptoui <8 x half> undef to <8 x i1>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v16f16_v16i8 = fptoui <16 x half> undef to <16 x i8>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v16f16_v16i16 = fptoui <16 x half> undef to <16 x i16>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v16f16_v16i32 = fptoui <16 x half> undef to <16 x i32>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v16f16_v16i64 = fptoui <16 x half> undef to <16 x i64>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v16f16_v16i1 = fptoui <16 x half> undef to <16 x i1>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %v32f16_v32i8 = fptoui <32 x half> undef to <32 x i8>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v32f16_v32i16 = fptoui <32 x half> undef to <32 x i16>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v32f16_v32i32 = fptoui <32 x half> undef to <32 x i32>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %v32f16_v32i64 = fptoui <32 x half> undef to <32 x i64>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %v32f16_v32i1 = fptoui <32 x half> undef to <32 x i1>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 29 for instruction: %v64f16_v64i8 = fptoui <64 x half> undef to <64 x i8>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %v64f16_v64i16 = fptoui <64 x half> undef to <64 x i16>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %v64f16_v64i32 = fptoui <64 x half> undef to <64 x i32>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 51 for instruction: %v64f16_v64i64 = fptoui <64 x half> undef to <64 x i64>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 41 for instruction: %v64f16_v64i1 = fptoui <64 x half> undef to <64 x i1>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %v128f16_v128i8 = fptoui <128 x half> undef to <128 x i8>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v128f16_v128i16 = fptoui <128 x half> undef to <128 x i16>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 66 for instruction: %v128f16_v128i32 = fptoui <128 x half> undef to <128 x i32>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 102 for instruction: %v128f16_v128i64 = fptoui <128 x half> undef to <128 x i64>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 83 for instruction: %v128f16_v128i1 = fptoui <128 x half> undef to <128 x i1>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv1f16_nxv1i8 = fptoui <vscale x 1 x half> undef to <vscale x 1 x i8>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1f16_nxv1i16 = fptoui <vscale x 1 x half> undef to <vscale x 1 x i16>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1f16_nxv1i32 = fptoui <vscale x 1 x half> undef to <vscale x 1 x i32>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1f16_nxv1i64 = fptoui <vscale x 1 x half> undef to <vscale x 1 x i64>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv1f16_nxv1i1 = fptoui <vscale x 1 x half> undef to <vscale x 1 x i1>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2f16_nxv2i8 = fptoui <vscale x 2 x half> undef to <vscale x 2 x i8>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f16_nxv2i16 = fptoui <vscale x 2 x half> undef to <vscale x 2 x i16>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f16_nxv2i32 = fptoui <vscale x 2 x half> undef to <vscale x 2 x i32>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2f16_nxv2i64 = fptoui <vscale x 2 x half> undef to <vscale x 2 x i64>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv2f16_nxv2i1 = fptoui <vscale x 2 x half> undef to <vscale x 2 x i1>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4f16_nxv4i8 = fptoui <vscale x 4 x half> undef to <vscale x 4 x i8>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4f16_nxv4i16 = fptoui <vscale x 4 x half> undef to <vscale x 4 x i16>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4f16_nxv4i32 = fptoui <vscale x 4 x half> undef to <vscale x 4 x i32>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv4f16_nxv4i64 = fptoui <vscale x 4 x half> undef to <vscale x 4 x i64>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv4f16_nxv4i1 = fptoui <vscale x 4 x half> undef to <vscale x 4 x i1>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %nxv8f16_nxv8i8 = fptoui <vscale x 8 x half> undef to <vscale x 8 x i8>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv8f16_nxv8i16 = fptoui <vscale x 8 x half> undef to <vscale x 8 x i16>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv8f16_nxv8i32 = fptoui <vscale x 8 x half> undef to <vscale x 8 x i32>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %nxv8f16_nxv8i64 = fptoui <vscale x 8 x half> undef to <vscale x 8 x i64>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %nxv8f16_nxv8i1 = fptoui <vscale x 8 x half> undef to <vscale x 8 x i1>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %nxv16f16_nxv16i8 = fptoui <vscale x 16 x half> undef to <vscale x 16 x i8>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %nxv16f16_nxv16i16 = fptoui <vscale x 16 x half> undef to <vscale x 16 x i16>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %nxv16f16_nxv16i32 = fptoui <vscale x 16 x half> undef to <vscale x 16 x i32>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %nxv16f16_nxv16i64 = fptoui <vscale x 16 x half> undef to <vscale x 16 x i64>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %nxv16f16_nxv16i1 = fptoui <vscale x 16 x half> undef to <vscale x 16 x i1>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 29 for instruction: %nxv32f16_nxv32i8 = fptoui <vscale x 32 x half> undef to <vscale x 32 x i8>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %nxv32f16_nxv32i16 = fptoui <vscale x 32 x half> undef to <vscale x 32 x i16>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %nxv32f16_nxv32i32 = fptoui <vscale x 32 x half> undef to <vscale x 32 x i32>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 51 for instruction: %nxv32f16_nxv32i64 = fptoui <vscale x 32 x half> undef to <vscale x 32 x i64>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 41 for instruction: %nxv32f16_nxv32i1 = fptoui <vscale x 32 x half> undef to <vscale x 32 x i1>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %nxv64f16_nxv64i8 = fptoui <vscale x 64 x half> undef to <vscale x 64 x i8>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64f16_nxv64i16 = fptoui <vscale x 64 x half> undef to <vscale x 64 x i16>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 66 for instruction: %nxv64f16_nxv64i32 = fptoui <vscale x 64 x half> undef to <vscale x 64 x i32>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 102 for instruction: %nxv64f16_nxv64i64 = fptoui <vscale x 64 x half> undef to <vscale x 64 x i64>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 83 for instruction: %nxv64f16_nxv64i1 = fptoui <vscale x 64 x half> undef to <vscale x 64 x i1>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %v2f16_v2i8 = fptoui <2 x half> undef to <2 x i8>
  %v2f16_v2i16 = fptoui <2 x half> undef to <2 x i16>
  %v2f16_v2i32 = fptoui <2 x half> undef to <2 x i32>
  %v2f16_v2i64 = fptoui <2 x half> undef to <2 x i64>
  %v2f16_v2i1 = fptoui <2 x half> undef to <2 x i1>
  %v4f16_v4i8 = fptoui <4 x half> undef to <4 x i8>
  %v4f16_v4i16 = fptoui <4 x half> undef to <4 x i16>
  %v4f16_v4i32 = fptoui <4 x half> undef to <4 x i32>
  %v4f16_v4i64 = fptoui <4 x half> undef to <4 x i64>
  %v4f16_v4i1 = fptoui <4 x half> undef to <4 x i1>
  %v8f16_v8i8 = fptoui <8 x half> undef to <8 x i8>
  %v8f16_v8i16 = fptoui <8 x half> undef to <8 x i16>
  %v8f16_v8i32 = fptoui <8 x half> undef to <8 x i32>
  %v8f16_v8i64 = fptoui <8 x half> undef to <8 x i64>
  %v8f16_v8i1 = fptoui <8 x half> undef to <8 x i1>
  %v16f16_v16i8 = fptoui <16 x half> undef to <16 x i8>
  %v16f16_v16i16 = fptoui <16 x half> undef to <16 x i16>
  %v16f16_v16i32 = fptoui <16 x half> undef to <16 x i32>
  %v16f16_v16i64 = fptoui <16 x half> undef to <16 x i64>
  %v16f16_v16i1 = fptoui <16 x half> undef to <16 x i1>
  %v32f16_v32i8 = fptoui <32 x half> undef to <32 x i8>
  %v32f16_v32i16 = fptoui <32 x half> undef to <32 x i16>
  %v32f16_v32i32 = fptoui <32 x half> undef to <32 x i32>
  %v32f16_v32i64 = fptoui <32 x half> undef to <32 x i64>
  %v32f16_v32i1 = fptoui <32 x half> undef to <32 x i1>
  %v64f16_v64i8 = fptoui <64 x half> undef to <64 x i8>
  %v64f16_v64i16 = fptoui <64 x half> undef to <64 x i16>
  %v64f16_v64i32 = fptoui <64 x half> undef to <64 x i32>
  %v64f16_v64i64 = fptoui <64 x half> undef to <64 x i64>
  %v64f16_v64i1 = fptoui <64 x half> undef to <64 x i1>
  %v128f16_v128i8 = fptoui <128 x half> undef to <128 x i8>
  %v128f16_v128i16 = fptoui <128 x half> undef to <128 x i16>
  %v128f16_v128i32 = fptoui <128 x half> undef to <128 x i32>
  %v128f16_v128i64 = fptoui <128 x half> undef to <128 x i64>
  %v128f16_v128i1 = fptoui <128 x half> undef to <128 x i1>
  %nxv1f16_nxv1i8 = fptoui <vscale x 1 x half> undef to <vscale x 1 x i8>
  %nxv1f16_nxv1i16 = fptoui <vscale x 1 x half> undef to <vscale x 1 x i16>
  %nxv1f16_nxv1i32 = fptoui <vscale x 1 x half> undef to <vscale x 1 x i32>
  %nxv1f16_nxv1i64 = fptoui <vscale x 1 x half> undef to <vscale x 1 x i64>
  %nxv1f16_nxv1i1 = fptoui <vscale x 1 x half> undef to <vscale x 1 x i1>
  %nxv2f16_nxv2i8 = fptoui <vscale x 2 x half> undef to <vscale x 2 x i8>
  %nxv2f16_nxv2i16 = fptoui <vscale x 2 x half> undef to <vscale x 2 x i16>
  %nxv2f16_nxv2i32 = fptoui <vscale x 2 x half> undef to <vscale x 2 x i32>
  %nxv2f16_nxv2i64 = fptoui <vscale x 2 x half> undef to <vscale x 2 x i64>
  %nxv2f16_nxv2i1 = fptoui <vscale x 2 x half> undef to <vscale x 2 x i1>
  %nxv4f16_nxv4i8 = fptoui <vscale x 4 x half> undef to <vscale x 4 x i8>
  %nxv4f16_nxv4i16 = fptoui <vscale x 4 x half> undef to <vscale x 4 x i16>
  %nxv4f16_nxv4i32 = fptoui <vscale x 4 x half> undef to <vscale x 4 x i32>
  %nxv4f16_nxv4i64 = fptoui <vscale x 4 x half> undef to <vscale x 4 x i64>
  %nxv4f16_nxv4i1 = fptoui <vscale x 4 x half> undef to <vscale x 4 x i1>
  %nxv8f16_nxv8i8 = fptoui <vscale x 8 x half> undef to <vscale x 8 x i8>
  %nxv8f16_nxv8i16 = fptoui <vscale x 8 x half> undef to <vscale x 8 x i16>
  %nxv8f16_nxv8i32 = fptoui <vscale x 8 x half> undef to <vscale x 8 x i32>
  %nxv8f16_nxv8i64 = fptoui <vscale x 8 x half> undef to <vscale x 8 x i64>
  %nxv8f16_nxv8i1 = fptoui <vscale x 8 x half> undef to <vscale x 8 x i1>
  %nxv16f16_nxv16i8 = fptoui <vscale x 16 x half> undef to <vscale x 16 x i8>
  %nxv16f16_nxv16i16 = fptoui <vscale x 16 x half> undef to <vscale x 16 x i16>
  %nxv16f16_nxv16i32 = fptoui <vscale x 16 x half> undef to <vscale x 16 x i32>
  %nxv16f16_nxv16i64 = fptoui <vscale x 16 x half> undef to <vscale x 16 x i64>
  %nxv16f16_nxv16i1 = fptoui <vscale x 16 x half> undef to <vscale x 16 x i1>
  %nxv32f16_nxv32i8 = fptoui <vscale x 32 x half> undef to <vscale x 32 x i8>
  %nxv32f16_nxv32i16 = fptoui <vscale x 32 x half> undef to <vscale x 32 x i16>
  %nxv32f16_nxv32i32 = fptoui <vscale x 32 x half> undef to <vscale x 32 x i32>
  %nxv32f16_nxv32i64 = fptoui <vscale x 32 x half> undef to <vscale x 32 x i64>
  %nxv32f16_nxv32i1 = fptoui <vscale x 32 x half> undef to <vscale x 32 x i1>
  %nxv64f16_nxv64i8 = fptoui <vscale x 64 x half> undef to <vscale x 64 x i8>
  %nxv64f16_nxv64i16 = fptoui <vscale x 64 x half> undef to <vscale x 64 x i16>
  %nxv64f16_nxv64i32 = fptoui <vscale x 64 x half> undef to <vscale x 64 x i32>
  %nxv64f16_nxv64i64 = fptoui <vscale x 64 x half> undef to <vscale x 64 x i64>
  %nxv64f16_nxv64i1 = fptoui <vscale x 64 x half> undef to <vscale x 64 x i1>
  ret void
}

define void @sitofp() {
; RV32ZVFH-LABEL: 'sitofp'
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8_v2f16 = sitofp <2 x i8> undef to <2 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_v2f16 = sitofp <2 x i16> undef to <2 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i32_v2f16 = sitofp <2 x i32> undef to <2 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i64_v2f16 = sitofp <2 x i64> undef to <2 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2i1_v2f16 = sitofp <2 x i1> undef to <2 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_v4f16 = sitofp <4 x i8> undef to <4 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_v4f16 = sitofp <4 x i16> undef to <4 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i32_v4f16 = sitofp <4 x i32> undef to <4 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i64_v4f16 = sitofp <4 x i64> undef to <4 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i1_v4f16 = sitofp <4 x i1> undef to <4 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8_v8f16 = sitofp <8 x i8> undef to <8 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16_v8f16 = sitofp <8 x i16> undef to <8 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i32_v8f16 = sitofp <8 x i32> undef to <8 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i64_v8f16 = sitofp <8 x i64> undef to <8 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i1_v8f16 = sitofp <8 x i1> undef to <8 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i8_v16f16 = sitofp <16 x i8> undef to <16 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i16_v16f16 = sitofp <16 x i16> undef to <16 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i32_v16f16 = sitofp <16 x i32> undef to <16 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v16i64_v16f16 = sitofp <16 x i64> undef to <16 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i1_v16f16 = sitofp <16 x i1> undef to <16 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32i8_v32f16 = sitofp <32 x i8> undef to <32 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32i16_v32f16 = sitofp <32 x i16> undef to <32 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32i32_v32f16 = sitofp <32 x i32> undef to <32 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %v32i64_v32f16 = sitofp <32 x i64> undef to <32 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v32i1_v32f16 = sitofp <32 x i1> undef to <32 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v64i8_v64f16 = sitofp <64 x i8> undef to <64 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v64i16_v64f16 = sitofp <64 x i16> undef to <64 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v64i32_v64f16 = sitofp <64 x i32> undef to <64 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 27 for instruction: %v64i64_v64f16 = sitofp <64 x i64> undef to <64 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v64i1_v64f16 = sitofp <64 x i1> undef to <64 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %v128i8_v128f16 = sitofp <128 x i8> undef to <128 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v128i16_v128f16 = sitofp <128 x i16> undef to <128 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %v128i32_v128f16 = sitofp <128 x i32> undef to <128 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 54 for instruction: %v128i64_v128f16 = sitofp <128 x i64> undef to <128 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %v128i1_v128f16 = sitofp <128 x i1> undef to <128 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i8_nxv1f16 = sitofp <vscale x 1 x i8> undef to <vscale x 1 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i16_nxv1f16 = sitofp <vscale x 1 x i16> undef to <vscale x 1 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i32_nxv1f16 = sitofp <vscale x 1 x i32> undef to <vscale x 1 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1i64_nxv1f16 = sitofp <vscale x 1 x i64> undef to <vscale x 1 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv1i1_nxv1f16 = sitofp <vscale x 1 x i1> undef to <vscale x 1 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i8_nxv2f16 = sitofp <vscale x 2 x i8> undef to <vscale x 2 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i16_nxv2f16 = sitofp <vscale x 2 x i16> undef to <vscale x 2 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i32_nxv2f16 = sitofp <vscale x 2 x i32> undef to <vscale x 2 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i64_nxv2f16 = sitofp <vscale x 2 x i64> undef to <vscale x 2 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2i1_nxv2f16 = sitofp <vscale x 2 x i1> undef to <vscale x 2 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i8_nxv4f16 = sitofp <vscale x 4 x i8> undef to <vscale x 4 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i16_nxv4f16 = sitofp <vscale x 4 x i16> undef to <vscale x 4 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i32_nxv4f16 = sitofp <vscale x 4 x i32> undef to <vscale x 4 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i64_nxv4f16 = sitofp <vscale x 4 x i64> undef to <vscale x 4 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i1_nxv4f16 = sitofp <vscale x 4 x i1> undef to <vscale x 4 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i8_nxv8f16 = sitofp <vscale x 8 x i8> undef to <vscale x 8 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i16_nxv8f16 = sitofp <vscale x 8 x i16> undef to <vscale x 8 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i32_nxv8f16 = sitofp <vscale x 8 x i32> undef to <vscale x 8 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv8i64_nxv8f16 = sitofp <vscale x 8 x i64> undef to <vscale x 8 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8i1_nxv8f16 = sitofp <vscale x 8 x i1> undef to <vscale x 8 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16i8_nxv16f16 = sitofp <vscale x 16 x i8> undef to <vscale x 16 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16i16_nxv16f16 = sitofp <vscale x 16 x i16> undef to <vscale x 16 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16i32_nxv16f16 = sitofp <vscale x 16 x i32> undef to <vscale x 16 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %nxv16i64_nxv16f16 = sitofp <vscale x 16 x i64> undef to <vscale x 16 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv16i1_nxv16f16 = sitofp <vscale x 16 x i1> undef to <vscale x 16 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv32i8_nxv32f16 = sitofp <vscale x 32 x i8> undef to <vscale x 32 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv32i16_nxv32f16 = sitofp <vscale x 32 x i16> undef to <vscale x 32 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %nxv32i32_nxv32f16 = sitofp <vscale x 32 x i32> undef to <vscale x 32 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 27 for instruction: %nxv32i64_nxv32f16 = sitofp <vscale x 32 x i64> undef to <vscale x 32 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %nxv32i1_nxv32f16 = sitofp <vscale x 32 x i1> undef to <vscale x 32 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %nxv64i8_nxv64f16 = sitofp <vscale x 64 x i8> undef to <vscale x 64 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64i16_nxv64f16 = sitofp <vscale x 64 x i16> undef to <vscale x 64 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %nxv64i32_nxv64f16 = sitofp <vscale x 64 x i32> undef to <vscale x 64 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 54 for instruction: %nxv64i64_nxv64f16 = sitofp <vscale x 64 x i64> undef to <vscale x 64 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %nxv64i1_nxv64f16 = sitofp <vscale x 64 x i1> undef to <vscale x 64 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV32ZVFHMIN-LABEL: 'sitofp'
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2i8_v2f16 = sitofp <2 x i8> undef to <2 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i16_v2f16 = sitofp <2 x i16> undef to <2 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i32_v2f16 = sitofp <2 x i32> undef to <2 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i64_v2f16 = sitofp <2 x i64> undef to <2 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v2i1_v2f16 = sitofp <2 x i1> undef to <2 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i8_v4f16 = sitofp <4 x i8> undef to <4 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i16_v4f16 = sitofp <4 x i16> undef to <4 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i32_v4f16 = sitofp <4 x i32> undef to <4 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i64_v4f16 = sitofp <4 x i64> undef to <4 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v4i1_v4f16 = sitofp <4 x i1> undef to <4 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i8_v8f16 = sitofp <8 x i8> undef to <8 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i16_v8f16 = sitofp <8 x i16> undef to <8 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i32_v8f16 = sitofp <8 x i32> undef to <8 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i64_v8f16 = sitofp <8 x i64> undef to <8 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8i1_v8f16 = sitofp <8 x i1> undef to <8 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v16i8_v16f16 = sitofp <16 x i8> undef to <16 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v16i16_v16f16 = sitofp <16 x i16> undef to <16 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v16i32_v16f16 = sitofp <16 x i32> undef to <16 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v16i64_v16f16 = sitofp <16 x i64> undef to <16 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v16i1_v16f16 = sitofp <16 x i1> undef to <16 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v32i8_v32f16 = sitofp <32 x i8> undef to <32 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v32i16_v32f16 = sitofp <32 x i16> undef to <32 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v32i32_v32f16 = sitofp <32 x i32> undef to <32 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %v32i64_v32f16 = sitofp <32 x i64> undef to <32 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %v32i1_v32f16 = sitofp <32 x i1> undef to <32 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 41 for instruction: %v64i8_v64f16 = sitofp <64 x i8> undef to <64 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %v64i16_v64f16 = sitofp <64 x i16> undef to <64 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %v64i32_v64f16 = sitofp <64 x i32> undef to <64 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 27 for instruction: %v64i64_v64f16 = sitofp <64 x i64> undef to <64 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 49 for instruction: %v64i1_v64f16 = sitofp <64 x i1> undef to <64 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 83 for instruction: %v128i8_v128f16 = sitofp <128 x i8> undef to <128 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 66 for instruction: %v128i16_v128f16 = sitofp <128 x i16> undef to <128 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 50 for instruction: %v128i32_v128f16 = sitofp <128 x i32> undef to <128 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 54 for instruction: %v128i64_v128f16 = sitofp <128 x i64> undef to <128 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %v128i1_v128f16 = sitofp <128 x i1> undef to <128 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv1i8_nxv1f16 = sitofp <vscale x 1 x i8> undef to <vscale x 1 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1i16_nxv1f16 = sitofp <vscale x 1 x i16> undef to <vscale x 1 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1i32_nxv1f16 = sitofp <vscale x 1 x i32> undef to <vscale x 1 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1i64_nxv1f16 = sitofp <vscale x 1 x i64> undef to <vscale x 1 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv1i1_nxv1f16 = sitofp <vscale x 1 x i1> undef to <vscale x 1 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2i8_nxv2f16 = sitofp <vscale x 2 x i8> undef to <vscale x 2 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i16_nxv2f16 = sitofp <vscale x 2 x i16> undef to <vscale x 2 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i32_nxv2f16 = sitofp <vscale x 2 x i32> undef to <vscale x 2 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i64_nxv2f16 = sitofp <vscale x 2 x i64> undef to <vscale x 2 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv2i1_nxv2f16 = sitofp <vscale x 2 x i1> undef to <vscale x 2 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4i8_nxv4f16 = sitofp <vscale x 4 x i8> undef to <vscale x 4 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i16_nxv4f16 = sitofp <vscale x 4 x i16> undef to <vscale x 4 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i32_nxv4f16 = sitofp <vscale x 4 x i32> undef to <vscale x 4 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i64_nxv4f16 = sitofp <vscale x 4 x i64> undef to <vscale x 4 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv4i1_nxv4f16 = sitofp <vscale x 4 x i1> undef to <vscale x 4 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv8i8_nxv8f16 = sitofp <vscale x 8 x i8> undef to <vscale x 8 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv8i16_nxv8f16 = sitofp <vscale x 8 x i16> undef to <vscale x 8 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv8i32_nxv8f16 = sitofp <vscale x 8 x i32> undef to <vscale x 8 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv8i64_nxv8f16 = sitofp <vscale x 8 x i64> undef to <vscale x 8 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %nxv8i1_nxv8f16 = sitofp <vscale x 8 x i1> undef to <vscale x 8 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %nxv16i8_nxv16f16 = sitofp <vscale x 16 x i8> undef to <vscale x 16 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %nxv16i16_nxv16f16 = sitofp <vscale x 16 x i16> undef to <vscale x 16 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %nxv16i32_nxv16f16 = sitofp <vscale x 16 x i32> undef to <vscale x 16 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %nxv16i64_nxv16f16 = sitofp <vscale x 16 x i64> undef to <vscale x 16 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %nxv16i1_nxv16f16 = sitofp <vscale x 16 x i1> undef to <vscale x 16 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 41 for instruction: %nxv32i8_nxv32f16 = sitofp <vscale x 32 x i8> undef to <vscale x 32 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %nxv32i16_nxv32f16 = sitofp <vscale x 32 x i16> undef to <vscale x 32 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %nxv32i32_nxv32f16 = sitofp <vscale x 32 x i32> undef to <vscale x 32 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 27 for instruction: %nxv32i64_nxv32f16 = sitofp <vscale x 32 x i64> undef to <vscale x 32 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 49 for instruction: %nxv32i1_nxv32f16 = sitofp <vscale x 32 x i1> undef to <vscale x 32 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 83 for instruction: %nxv64i8_nxv64f16 = sitofp <vscale x 64 x i8> undef to <vscale x 64 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64i16_nxv64f16 = sitofp <vscale x 64 x i16> undef to <vscale x 64 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 50 for instruction: %nxv64i32_nxv64f16 = sitofp <vscale x 64 x i32> undef to <vscale x 64 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 54 for instruction: %nxv64i64_nxv64f16 = sitofp <vscale x 64 x i64> undef to <vscale x 64 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %nxv64i1_nxv64f16 = sitofp <vscale x 64 x i1> undef to <vscale x 64 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV64ZVFH-LABEL: 'sitofp'
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8_v2f16 = sitofp <2 x i8> undef to <2 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_v2f16 = sitofp <2 x i16> undef to <2 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i32_v2f16 = sitofp <2 x i32> undef to <2 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i64_v2f16 = sitofp <2 x i64> undef to <2 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2i1_v2f16 = sitofp <2 x i1> undef to <2 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_v4f16 = sitofp <4 x i8> undef to <4 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_v4f16 = sitofp <4 x i16> undef to <4 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i32_v4f16 = sitofp <4 x i32> undef to <4 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i64_v4f16 = sitofp <4 x i64> undef to <4 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i1_v4f16 = sitofp <4 x i1> undef to <4 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8_v8f16 = sitofp <8 x i8> undef to <8 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16_v8f16 = sitofp <8 x i16> undef to <8 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i32_v8f16 = sitofp <8 x i32> undef to <8 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i64_v8f16 = sitofp <8 x i64> undef to <8 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i1_v8f16 = sitofp <8 x i1> undef to <8 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i8_v16f16 = sitofp <16 x i8> undef to <16 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i16_v16f16 = sitofp <16 x i16> undef to <16 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i32_v16f16 = sitofp <16 x i32> undef to <16 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v16i64_v16f16 = sitofp <16 x i64> undef to <16 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i1_v16f16 = sitofp <16 x i1> undef to <16 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32i8_v32f16 = sitofp <32 x i8> undef to <32 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32i16_v32f16 = sitofp <32 x i16> undef to <32 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32i32_v32f16 = sitofp <32 x i32> undef to <32 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %v32i64_v32f16 = sitofp <32 x i64> undef to <32 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v32i1_v32f16 = sitofp <32 x i1> undef to <32 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v64i8_v64f16 = sitofp <64 x i8> undef to <64 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v64i16_v64f16 = sitofp <64 x i16> undef to <64 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v64i32_v64f16 = sitofp <64 x i32> undef to <64 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 27 for instruction: %v64i64_v64f16 = sitofp <64 x i64> undef to <64 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v64i1_v64f16 = sitofp <64 x i1> undef to <64 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %v128i8_v128f16 = sitofp <128 x i8> undef to <128 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v128i16_v128f16 = sitofp <128 x i16> undef to <128 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %v128i32_v128f16 = sitofp <128 x i32> undef to <128 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 54 for instruction: %v128i64_v128f16 = sitofp <128 x i64> undef to <128 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %v128i1_v128f16 = sitofp <128 x i1> undef to <128 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i8_nxv1f16 = sitofp <vscale x 1 x i8> undef to <vscale x 1 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i16_nxv1f16 = sitofp <vscale x 1 x i16> undef to <vscale x 1 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i32_nxv1f16 = sitofp <vscale x 1 x i32> undef to <vscale x 1 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1i64_nxv1f16 = sitofp <vscale x 1 x i64> undef to <vscale x 1 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv1i1_nxv1f16 = sitofp <vscale x 1 x i1> undef to <vscale x 1 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i8_nxv2f16 = sitofp <vscale x 2 x i8> undef to <vscale x 2 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i16_nxv2f16 = sitofp <vscale x 2 x i16> undef to <vscale x 2 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i32_nxv2f16 = sitofp <vscale x 2 x i32> undef to <vscale x 2 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i64_nxv2f16 = sitofp <vscale x 2 x i64> undef to <vscale x 2 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2i1_nxv2f16 = sitofp <vscale x 2 x i1> undef to <vscale x 2 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i8_nxv4f16 = sitofp <vscale x 4 x i8> undef to <vscale x 4 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i16_nxv4f16 = sitofp <vscale x 4 x i16> undef to <vscale x 4 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i32_nxv4f16 = sitofp <vscale x 4 x i32> undef to <vscale x 4 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i64_nxv4f16 = sitofp <vscale x 4 x i64> undef to <vscale x 4 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i1_nxv4f16 = sitofp <vscale x 4 x i1> undef to <vscale x 4 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i8_nxv8f16 = sitofp <vscale x 8 x i8> undef to <vscale x 8 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i16_nxv8f16 = sitofp <vscale x 8 x i16> undef to <vscale x 8 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i32_nxv8f16 = sitofp <vscale x 8 x i32> undef to <vscale x 8 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv8i64_nxv8f16 = sitofp <vscale x 8 x i64> undef to <vscale x 8 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8i1_nxv8f16 = sitofp <vscale x 8 x i1> undef to <vscale x 8 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16i8_nxv16f16 = sitofp <vscale x 16 x i8> undef to <vscale x 16 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16i16_nxv16f16 = sitofp <vscale x 16 x i16> undef to <vscale x 16 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16i32_nxv16f16 = sitofp <vscale x 16 x i32> undef to <vscale x 16 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %nxv16i64_nxv16f16 = sitofp <vscale x 16 x i64> undef to <vscale x 16 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv16i1_nxv16f16 = sitofp <vscale x 16 x i1> undef to <vscale x 16 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv32i8_nxv32f16 = sitofp <vscale x 32 x i8> undef to <vscale x 32 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv32i16_nxv32f16 = sitofp <vscale x 32 x i16> undef to <vscale x 32 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %nxv32i32_nxv32f16 = sitofp <vscale x 32 x i32> undef to <vscale x 32 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 27 for instruction: %nxv32i64_nxv32f16 = sitofp <vscale x 32 x i64> undef to <vscale x 32 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %nxv32i1_nxv32f16 = sitofp <vscale x 32 x i1> undef to <vscale x 32 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %nxv64i8_nxv64f16 = sitofp <vscale x 64 x i8> undef to <vscale x 64 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64i16_nxv64f16 = sitofp <vscale x 64 x i16> undef to <vscale x 64 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %nxv64i32_nxv64f16 = sitofp <vscale x 64 x i32> undef to <vscale x 64 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 54 for instruction: %nxv64i64_nxv64f16 = sitofp <vscale x 64 x i64> undef to <vscale x 64 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %nxv64i1_nxv64f16 = sitofp <vscale x 64 x i1> undef to <vscale x 64 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV64ZVFHMIN-LABEL: 'sitofp'
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2i8_v2f16 = sitofp <2 x i8> undef to <2 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i16_v2f16 = sitofp <2 x i16> undef to <2 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i32_v2f16 = sitofp <2 x i32> undef to <2 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i64_v2f16 = sitofp <2 x i64> undef to <2 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v2i1_v2f16 = sitofp <2 x i1> undef to <2 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i8_v4f16 = sitofp <4 x i8> undef to <4 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i16_v4f16 = sitofp <4 x i16> undef to <4 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i32_v4f16 = sitofp <4 x i32> undef to <4 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i64_v4f16 = sitofp <4 x i64> undef to <4 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v4i1_v4f16 = sitofp <4 x i1> undef to <4 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i8_v8f16 = sitofp <8 x i8> undef to <8 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i16_v8f16 = sitofp <8 x i16> undef to <8 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i32_v8f16 = sitofp <8 x i32> undef to <8 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i64_v8f16 = sitofp <8 x i64> undef to <8 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8i1_v8f16 = sitofp <8 x i1> undef to <8 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v16i8_v16f16 = sitofp <16 x i8> undef to <16 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v16i16_v16f16 = sitofp <16 x i16> undef to <16 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v16i32_v16f16 = sitofp <16 x i32> undef to <16 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v16i64_v16f16 = sitofp <16 x i64> undef to <16 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v16i1_v16f16 = sitofp <16 x i1> undef to <16 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v32i8_v32f16 = sitofp <32 x i8> undef to <32 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v32i16_v32f16 = sitofp <32 x i16> undef to <32 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v32i32_v32f16 = sitofp <32 x i32> undef to <32 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %v32i64_v32f16 = sitofp <32 x i64> undef to <32 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %v32i1_v32f16 = sitofp <32 x i1> undef to <32 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 41 for instruction: %v64i8_v64f16 = sitofp <64 x i8> undef to <64 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %v64i16_v64f16 = sitofp <64 x i16> undef to <64 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %v64i32_v64f16 = sitofp <64 x i32> undef to <64 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 27 for instruction: %v64i64_v64f16 = sitofp <64 x i64> undef to <64 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 49 for instruction: %v64i1_v64f16 = sitofp <64 x i1> undef to <64 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 83 for instruction: %v128i8_v128f16 = sitofp <128 x i8> undef to <128 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 66 for instruction: %v128i16_v128f16 = sitofp <128 x i16> undef to <128 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 50 for instruction: %v128i32_v128f16 = sitofp <128 x i32> undef to <128 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 54 for instruction: %v128i64_v128f16 = sitofp <128 x i64> undef to <128 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %v128i1_v128f16 = sitofp <128 x i1> undef to <128 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv1i8_nxv1f16 = sitofp <vscale x 1 x i8> undef to <vscale x 1 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1i16_nxv1f16 = sitofp <vscale x 1 x i16> undef to <vscale x 1 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1i32_nxv1f16 = sitofp <vscale x 1 x i32> undef to <vscale x 1 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1i64_nxv1f16 = sitofp <vscale x 1 x i64> undef to <vscale x 1 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv1i1_nxv1f16 = sitofp <vscale x 1 x i1> undef to <vscale x 1 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2i8_nxv2f16 = sitofp <vscale x 2 x i8> undef to <vscale x 2 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i16_nxv2f16 = sitofp <vscale x 2 x i16> undef to <vscale x 2 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i32_nxv2f16 = sitofp <vscale x 2 x i32> undef to <vscale x 2 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i64_nxv2f16 = sitofp <vscale x 2 x i64> undef to <vscale x 2 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv2i1_nxv2f16 = sitofp <vscale x 2 x i1> undef to <vscale x 2 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4i8_nxv4f16 = sitofp <vscale x 4 x i8> undef to <vscale x 4 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i16_nxv4f16 = sitofp <vscale x 4 x i16> undef to <vscale x 4 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i32_nxv4f16 = sitofp <vscale x 4 x i32> undef to <vscale x 4 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i64_nxv4f16 = sitofp <vscale x 4 x i64> undef to <vscale x 4 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv4i1_nxv4f16 = sitofp <vscale x 4 x i1> undef to <vscale x 4 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv8i8_nxv8f16 = sitofp <vscale x 8 x i8> undef to <vscale x 8 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv8i16_nxv8f16 = sitofp <vscale x 8 x i16> undef to <vscale x 8 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv8i32_nxv8f16 = sitofp <vscale x 8 x i32> undef to <vscale x 8 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv8i64_nxv8f16 = sitofp <vscale x 8 x i64> undef to <vscale x 8 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %nxv8i1_nxv8f16 = sitofp <vscale x 8 x i1> undef to <vscale x 8 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %nxv16i8_nxv16f16 = sitofp <vscale x 16 x i8> undef to <vscale x 16 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %nxv16i16_nxv16f16 = sitofp <vscale x 16 x i16> undef to <vscale x 16 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %nxv16i32_nxv16f16 = sitofp <vscale x 16 x i32> undef to <vscale x 16 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %nxv16i64_nxv16f16 = sitofp <vscale x 16 x i64> undef to <vscale x 16 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %nxv16i1_nxv16f16 = sitofp <vscale x 16 x i1> undef to <vscale x 16 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 41 for instruction: %nxv32i8_nxv32f16 = sitofp <vscale x 32 x i8> undef to <vscale x 32 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %nxv32i16_nxv32f16 = sitofp <vscale x 32 x i16> undef to <vscale x 32 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %nxv32i32_nxv32f16 = sitofp <vscale x 32 x i32> undef to <vscale x 32 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 27 for instruction: %nxv32i64_nxv32f16 = sitofp <vscale x 32 x i64> undef to <vscale x 32 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 49 for instruction: %nxv32i1_nxv32f16 = sitofp <vscale x 32 x i1> undef to <vscale x 32 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 83 for instruction: %nxv64i8_nxv64f16 = sitofp <vscale x 64 x i8> undef to <vscale x 64 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64i16_nxv64f16 = sitofp <vscale x 64 x i16> undef to <vscale x 64 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 50 for instruction: %nxv64i32_nxv64f16 = sitofp <vscale x 64 x i32> undef to <vscale x 64 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 54 for instruction: %nxv64i64_nxv64f16 = sitofp <vscale x 64 x i64> undef to <vscale x 64 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %nxv64i1_nxv64f16 = sitofp <vscale x 64 x i1> undef to <vscale x 64 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %v2i8_v2f16 = sitofp <2 x i8> undef to <2 x half>
  %v2i16_v2f16 = sitofp <2 x i16> undef to <2 x half>
  %v2i32_v2f16 = sitofp <2 x i32> undef to <2 x half>
  %v2i64_v2f16 = sitofp <2 x i64> undef to <2 x half>
  %v2i1_v2f16 = sitofp <2 x i1> undef to <2 x half>
  %v4i8_v4f16 = sitofp <4 x i8> undef to <4 x half>
  %v4i16_v4f16 = sitofp <4 x i16> undef to <4 x half>
  %v4i32_v4f16 = sitofp <4 x i32> undef to <4 x half>
  %v4i64_v4f16 = sitofp <4 x i64> undef to <4 x half>
  %v4i1_v4f16 = sitofp <4 x i1> undef to <4 x half>
  %v8i8_v8f16 = sitofp <8 x i8> undef to <8 x half>
  %v8i16_v8f16 = sitofp <8 x i16> undef to <8 x half>
  %v8i32_v8f16 = sitofp <8 x i32> undef to <8 x half>
  %v8i64_v8f16 = sitofp <8 x i64> undef to <8 x half>
  %v8i1_v8f16 = sitofp <8 x i1> undef to <8 x half>
  %v16i8_v16f16 = sitofp <16 x i8> undef to <16 x half>
  %v16i16_v16f16 = sitofp <16 x i16> undef to <16 x half>
  %v16i32_v16f16 = sitofp <16 x i32> undef to <16 x half>
  %v16i64_v16f16 = sitofp <16 x i64> undef to <16 x half>
  %v16i1_v16f16 = sitofp <16 x i1> undef to <16 x half>
  %v32i8_v32f16 = sitofp <32 x i8> undef to <32 x half>
  %v32i16_v32f16 = sitofp <32 x i16> undef to <32 x half>
  %v32i32_v32f16 = sitofp <32 x i32> undef to <32 x half>
  %v32i64_v32f16 = sitofp <32 x i64> undef to <32 x half>
  %v32i1_v32f16 = sitofp <32 x i1> undef to <32 x half>
  %v64i8_v64f16 = sitofp <64 x i8> undef to <64 x half>
  %v64i16_v64f16 = sitofp <64 x i16> undef to <64 x half>
  %v64i32_v64f16 = sitofp <64 x i32> undef to <64 x half>
  %v64i64_v64f16 = sitofp <64 x i64> undef to <64 x half>
  %v64i1_v64f16 = sitofp <64 x i1> undef to <64 x half>
  %v128i8_v128f16 = sitofp <128 x i8> undef to <128 x half>
  %v128i16_v128f16 = sitofp <128 x i16> undef to <128 x half>
  %v128i32_v128f16 = sitofp <128 x i32> undef to <128 x half>
  %v128i64_v128f16 = sitofp <128 x i64> undef to <128 x half>
  %v128i1_v128f16 = sitofp <128 x i1> undef to <128 x half>
  %nxv1i8_nxv1f16 = sitofp <vscale x 1 x i8> undef to <vscale x 1 x half>
  %nxv1i16_nxv1f16 = sitofp <vscale x 1 x i16> undef to <vscale x 1 x half>
  %nxv1i32_nxv1f16 = sitofp <vscale x 1 x i32> undef to <vscale x 1 x half>
  %nxv1i64_nxv1f16 = sitofp <vscale x 1 x i64> undef to <vscale x 1 x half>
  %nxv1i1_nxv1f16 = sitofp <vscale x 1 x i1> undef to <vscale x 1 x half>
  %nxv2i8_nxv2f16 = sitofp <vscale x 2 x i8> undef to <vscale x 2 x half>
  %nxv2i16_nxv2f16 = sitofp <vscale x 2 x i16> undef to <vscale x 2 x half>
  %nxv2i32_nxv2f16 = sitofp <vscale x 2 x i32> undef to <vscale x 2 x half>
  %nxv2i64_nxv2f16 = sitofp <vscale x 2 x i64> undef to <vscale x 2 x half>
  %nxv2i1_nxv2f16 = sitofp <vscale x 2 x i1> undef to <vscale x 2 x half>
  %nxv4i8_nxv4f16 = sitofp <vscale x 4 x i8> undef to <vscale x 4 x half>
  %nxv4i16_nxv4f16 = sitofp <vscale x 4 x i16> undef to <vscale x 4 x half>
  %nxv4i32_nxv4f16 = sitofp <vscale x 4 x i32> undef to <vscale x 4 x half>
  %nxv4i64_nxv4f16 = sitofp <vscale x 4 x i64> undef to <vscale x 4 x half>
  %nxv4i1_nxv4f16 = sitofp <vscale x 4 x i1> undef to <vscale x 4 x half>
  %nxv8i8_nxv8f16 = sitofp <vscale x 8 x i8> undef to <vscale x 8 x half>
  %nxv8i16_nxv8f16 = sitofp <vscale x 8 x i16> undef to <vscale x 8 x half>
  %nxv8i32_nxv8f16 = sitofp <vscale x 8 x i32> undef to <vscale x 8 x half>
  %nxv8i64_nxv8f16 = sitofp <vscale x 8 x i64> undef to <vscale x 8 x half>
  %nxv8i1_nxv8f16 = sitofp <vscale x 8 x i1> undef to <vscale x 8 x half>
  %nxv16i8_nxv16f16 = sitofp <vscale x 16 x i8> undef to <vscale x 16 x half>
  %nxv16i16_nxv16f16 = sitofp <vscale x 16 x i16> undef to <vscale x 16 x half>
  %nxv16i32_nxv16f16 = sitofp <vscale x 16 x i32> undef to <vscale x 16 x half>
  %nxv16i64_nxv16f16 = sitofp <vscale x 16 x i64> undef to <vscale x 16 x half>
  %nxv16i1_nxv16f16 = sitofp <vscale x 16 x i1> undef to <vscale x 16 x half>
  %nxv32i8_nxv32f16 = sitofp <vscale x 32 x i8> undef to <vscale x 32 x half>
  %nxv32i16_nxv32f16 = sitofp <vscale x 32 x i16> undef to <vscale x 32 x half>
  %nxv32i32_nxv32f16 = sitofp <vscale x 32 x i32> undef to <vscale x 32 x half>
  %nxv32i64_nxv32f16 = sitofp <vscale x 32 x i64> undef to <vscale x 32 x half>
  %nxv32i1_nxv32f16 = sitofp <vscale x 32 x i1> undef to <vscale x 32 x half>
  %nxv64i8_nxv64f16 = sitofp <vscale x 64 x i8> undef to <vscale x 64 x half>
  %nxv64i16_nxv64f16 = sitofp <vscale x 64 x i16> undef to <vscale x 64 x half>
  %nxv64i32_nxv64f16 = sitofp <vscale x 64 x i32> undef to <vscale x 64 x half>
  %nxv64i64_nxv64f16 = sitofp <vscale x 64 x i64> undef to <vscale x 64 x half>
  %nxv64i1_nxv64f16 = sitofp <vscale x 64 x i1> undef to <vscale x 64 x half>
  ret void
}

define void @uitofp() {
; RV32ZVFH-LABEL: 'uitofp'
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8_v2f16 = uitofp <2 x i8> undef to <2 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_v2f16 = uitofp <2 x i16> undef to <2 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i32_v2f16 = uitofp <2 x i32> undef to <2 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i64_v2f16 = uitofp <2 x i64> undef to <2 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2i1_v2f16 = uitofp <2 x i1> undef to <2 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_v4f16 = uitofp <4 x i8> undef to <4 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_v4f16 = uitofp <4 x i16> undef to <4 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i32_v4f16 = uitofp <4 x i32> undef to <4 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i64_v4f16 = uitofp <4 x i64> undef to <4 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i1_v4f16 = uitofp <4 x i1> undef to <4 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8_v8f16 = uitofp <8 x i8> undef to <8 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16_v8f16 = uitofp <8 x i16> undef to <8 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i32_v8f16 = uitofp <8 x i32> undef to <8 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i64_v8f16 = uitofp <8 x i64> undef to <8 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i1_v8f16 = uitofp <8 x i1> undef to <8 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i8_v16f16 = uitofp <16 x i8> undef to <16 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i16_v16f16 = uitofp <16 x i16> undef to <16 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i32_v16f16 = uitofp <16 x i32> undef to <16 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v16i64_v16f16 = uitofp <16 x i64> undef to <16 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i1_v16f16 = uitofp <16 x i1> undef to <16 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32i8_v32f16 = uitofp <32 x i8> undef to <32 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32i16_v32f16 = uitofp <32 x i16> undef to <32 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32i32_v32f16 = uitofp <32 x i32> undef to <32 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %v32i64_v32f16 = uitofp <32 x i64> undef to <32 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v32i1_v32f16 = uitofp <32 x i1> undef to <32 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v64i8_v64f16 = uitofp <64 x i8> undef to <64 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v64i16_v64f16 = uitofp <64 x i16> undef to <64 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v64i32_v64f16 = uitofp <64 x i32> undef to <64 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 27 for instruction: %v64i64_v64f16 = uitofp <64 x i64> undef to <64 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v64i1_v64f16 = uitofp <64 x i1> undef to <64 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %v128i8_v128f16 = uitofp <128 x i8> undef to <128 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v128i16_v128f16 = uitofp <128 x i16> undef to <128 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %v128i32_v128f16 = uitofp <128 x i32> undef to <128 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 54 for instruction: %v128i64_v128f16 = uitofp <128 x i64> undef to <128 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %v128i1_v128f16 = uitofp <128 x i1> undef to <128 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i8_nxv1f16 = uitofp <vscale x 1 x i8> undef to <vscale x 1 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i16_nxv1f16 = uitofp <vscale x 1 x i16> undef to <vscale x 1 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i32_nxv1f16 = uitofp <vscale x 1 x i32> undef to <vscale x 1 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1i64_nxv1f16 = uitofp <vscale x 1 x i64> undef to <vscale x 1 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv1i1_nxv1f16 = uitofp <vscale x 1 x i1> undef to <vscale x 1 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i8_nxv2f16 = uitofp <vscale x 2 x i8> undef to <vscale x 2 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i16_nxv2f16 = uitofp <vscale x 2 x i16> undef to <vscale x 2 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i32_nxv2f16 = uitofp <vscale x 2 x i32> undef to <vscale x 2 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i64_nxv2f16 = uitofp <vscale x 2 x i64> undef to <vscale x 2 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2i1_nxv2f16 = uitofp <vscale x 2 x i1> undef to <vscale x 2 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i8_nxv4f16 = uitofp <vscale x 4 x i8> undef to <vscale x 4 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i16_nxv4f16 = uitofp <vscale x 4 x i16> undef to <vscale x 4 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i32_nxv4f16 = uitofp <vscale x 4 x i32> undef to <vscale x 4 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i64_nxv4f16 = uitofp <vscale x 4 x i64> undef to <vscale x 4 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i1_nxv4f16 = uitofp <vscale x 4 x i1> undef to <vscale x 4 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i8_nxv8f16 = uitofp <vscale x 8 x i8> undef to <vscale x 8 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i16_nxv8f16 = uitofp <vscale x 8 x i16> undef to <vscale x 8 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i32_nxv8f16 = uitofp <vscale x 8 x i32> undef to <vscale x 8 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv8i64_nxv8f16 = uitofp <vscale x 8 x i64> undef to <vscale x 8 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8i1_nxv8f16 = uitofp <vscale x 8 x i1> undef to <vscale x 8 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16i8_nxv16f16 = uitofp <vscale x 16 x i8> undef to <vscale x 16 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16i16_nxv16f16 = uitofp <vscale x 16 x i16> undef to <vscale x 16 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16i32_nxv16f16 = uitofp <vscale x 16 x i32> undef to <vscale x 16 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %nxv16i64_nxv16f16 = uitofp <vscale x 16 x i64> undef to <vscale x 16 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv16i1_nxv16f16 = uitofp <vscale x 16 x i1> undef to <vscale x 16 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv32i8_nxv32f16 = uitofp <vscale x 32 x i8> undef to <vscale x 32 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv32i16_nxv32f16 = uitofp <vscale x 32 x i16> undef to <vscale x 32 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %nxv32i32_nxv32f16 = uitofp <vscale x 32 x i32> undef to <vscale x 32 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 27 for instruction: %nxv32i64_nxv32f16 = uitofp <vscale x 32 x i64> undef to <vscale x 32 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %nxv32i1_nxv32f16 = uitofp <vscale x 32 x i1> undef to <vscale x 32 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %nxv64i8_nxv64f16 = uitofp <vscale x 64 x i8> undef to <vscale x 64 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64i16_nxv64f16 = uitofp <vscale x 64 x i16> undef to <vscale x 64 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %nxv64i32_nxv64f16 = uitofp <vscale x 64 x i32> undef to <vscale x 64 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 54 for instruction: %nxv64i64_nxv64f16 = uitofp <vscale x 64 x i64> undef to <vscale x 64 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %nxv64i1_nxv64f16 = uitofp <vscale x 64 x i1> undef to <vscale x 64 x half>
; RV32ZVFH-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV32ZVFHMIN-LABEL: 'uitofp'
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2i8_v2f16 = uitofp <2 x i8> undef to <2 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i16_v2f16 = uitofp <2 x i16> undef to <2 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i32_v2f16 = uitofp <2 x i32> undef to <2 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i64_v2f16 = uitofp <2 x i64> undef to <2 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v2i1_v2f16 = uitofp <2 x i1> undef to <2 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i8_v4f16 = uitofp <4 x i8> undef to <4 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i16_v4f16 = uitofp <4 x i16> undef to <4 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i32_v4f16 = uitofp <4 x i32> undef to <4 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i64_v4f16 = uitofp <4 x i64> undef to <4 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v4i1_v4f16 = uitofp <4 x i1> undef to <4 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i8_v8f16 = uitofp <8 x i8> undef to <8 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i16_v8f16 = uitofp <8 x i16> undef to <8 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i32_v8f16 = uitofp <8 x i32> undef to <8 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i64_v8f16 = uitofp <8 x i64> undef to <8 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8i1_v8f16 = uitofp <8 x i1> undef to <8 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v16i8_v16f16 = uitofp <16 x i8> undef to <16 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v16i16_v16f16 = uitofp <16 x i16> undef to <16 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v16i32_v16f16 = uitofp <16 x i32> undef to <16 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v16i64_v16f16 = uitofp <16 x i64> undef to <16 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v16i1_v16f16 = uitofp <16 x i1> undef to <16 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v32i8_v32f16 = uitofp <32 x i8> undef to <32 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v32i16_v32f16 = uitofp <32 x i16> undef to <32 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v32i32_v32f16 = uitofp <32 x i32> undef to <32 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %v32i64_v32f16 = uitofp <32 x i64> undef to <32 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %v32i1_v32f16 = uitofp <32 x i1> undef to <32 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 41 for instruction: %v64i8_v64f16 = uitofp <64 x i8> undef to <64 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %v64i16_v64f16 = uitofp <64 x i16> undef to <64 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %v64i32_v64f16 = uitofp <64 x i32> undef to <64 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 27 for instruction: %v64i64_v64f16 = uitofp <64 x i64> undef to <64 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 49 for instruction: %v64i1_v64f16 = uitofp <64 x i1> undef to <64 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 83 for instruction: %v128i8_v128f16 = uitofp <128 x i8> undef to <128 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 66 for instruction: %v128i16_v128f16 = uitofp <128 x i16> undef to <128 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 50 for instruction: %v128i32_v128f16 = uitofp <128 x i32> undef to <128 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 54 for instruction: %v128i64_v128f16 = uitofp <128 x i64> undef to <128 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %v128i1_v128f16 = uitofp <128 x i1> undef to <128 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv1i8_nxv1f16 = uitofp <vscale x 1 x i8> undef to <vscale x 1 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1i16_nxv1f16 = uitofp <vscale x 1 x i16> undef to <vscale x 1 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1i32_nxv1f16 = uitofp <vscale x 1 x i32> undef to <vscale x 1 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1i64_nxv1f16 = uitofp <vscale x 1 x i64> undef to <vscale x 1 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv1i1_nxv1f16 = uitofp <vscale x 1 x i1> undef to <vscale x 1 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2i8_nxv2f16 = uitofp <vscale x 2 x i8> undef to <vscale x 2 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i16_nxv2f16 = uitofp <vscale x 2 x i16> undef to <vscale x 2 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i32_nxv2f16 = uitofp <vscale x 2 x i32> undef to <vscale x 2 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i64_nxv2f16 = uitofp <vscale x 2 x i64> undef to <vscale x 2 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv2i1_nxv2f16 = uitofp <vscale x 2 x i1> undef to <vscale x 2 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4i8_nxv4f16 = uitofp <vscale x 4 x i8> undef to <vscale x 4 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i16_nxv4f16 = uitofp <vscale x 4 x i16> undef to <vscale x 4 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i32_nxv4f16 = uitofp <vscale x 4 x i32> undef to <vscale x 4 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i64_nxv4f16 = uitofp <vscale x 4 x i64> undef to <vscale x 4 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv4i1_nxv4f16 = uitofp <vscale x 4 x i1> undef to <vscale x 4 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv8i8_nxv8f16 = uitofp <vscale x 8 x i8> undef to <vscale x 8 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv8i16_nxv8f16 = uitofp <vscale x 8 x i16> undef to <vscale x 8 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv8i32_nxv8f16 = uitofp <vscale x 8 x i32> undef to <vscale x 8 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv8i64_nxv8f16 = uitofp <vscale x 8 x i64> undef to <vscale x 8 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %nxv8i1_nxv8f16 = uitofp <vscale x 8 x i1> undef to <vscale x 8 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %nxv16i8_nxv16f16 = uitofp <vscale x 16 x i8> undef to <vscale x 16 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %nxv16i16_nxv16f16 = uitofp <vscale x 16 x i16> undef to <vscale x 16 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %nxv16i32_nxv16f16 = uitofp <vscale x 16 x i32> undef to <vscale x 16 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %nxv16i64_nxv16f16 = uitofp <vscale x 16 x i64> undef to <vscale x 16 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %nxv16i1_nxv16f16 = uitofp <vscale x 16 x i1> undef to <vscale x 16 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 41 for instruction: %nxv32i8_nxv32f16 = uitofp <vscale x 32 x i8> undef to <vscale x 32 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %nxv32i16_nxv32f16 = uitofp <vscale x 32 x i16> undef to <vscale x 32 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %nxv32i32_nxv32f16 = uitofp <vscale x 32 x i32> undef to <vscale x 32 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 27 for instruction: %nxv32i64_nxv32f16 = uitofp <vscale x 32 x i64> undef to <vscale x 32 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 49 for instruction: %nxv32i1_nxv32f16 = uitofp <vscale x 32 x i1> undef to <vscale x 32 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 83 for instruction: %nxv64i8_nxv64f16 = uitofp <vscale x 64 x i8> undef to <vscale x 64 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64i16_nxv64f16 = uitofp <vscale x 64 x i16> undef to <vscale x 64 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 50 for instruction: %nxv64i32_nxv64f16 = uitofp <vscale x 64 x i32> undef to <vscale x 64 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 54 for instruction: %nxv64i64_nxv64f16 = uitofp <vscale x 64 x i64> undef to <vscale x 64 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %nxv64i1_nxv64f16 = uitofp <vscale x 64 x i1> undef to <vscale x 64 x half>
; RV32ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV64ZVFH-LABEL: 'uitofp'
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8_v2f16 = uitofp <2 x i8> undef to <2 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_v2f16 = uitofp <2 x i16> undef to <2 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i32_v2f16 = uitofp <2 x i32> undef to <2 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i64_v2f16 = uitofp <2 x i64> undef to <2 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2i1_v2f16 = uitofp <2 x i1> undef to <2 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_v4f16 = uitofp <4 x i8> undef to <4 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_v4f16 = uitofp <4 x i16> undef to <4 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i32_v4f16 = uitofp <4 x i32> undef to <4 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i64_v4f16 = uitofp <4 x i64> undef to <4 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i1_v4f16 = uitofp <4 x i1> undef to <4 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8_v8f16 = uitofp <8 x i8> undef to <8 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16_v8f16 = uitofp <8 x i16> undef to <8 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i32_v8f16 = uitofp <8 x i32> undef to <8 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i64_v8f16 = uitofp <8 x i64> undef to <8 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i1_v8f16 = uitofp <8 x i1> undef to <8 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i8_v16f16 = uitofp <16 x i8> undef to <16 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i16_v16f16 = uitofp <16 x i16> undef to <16 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i32_v16f16 = uitofp <16 x i32> undef to <16 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v16i64_v16f16 = uitofp <16 x i64> undef to <16 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i1_v16f16 = uitofp <16 x i1> undef to <16 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32i8_v32f16 = uitofp <32 x i8> undef to <32 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32i16_v32f16 = uitofp <32 x i16> undef to <32 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32i32_v32f16 = uitofp <32 x i32> undef to <32 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %v32i64_v32f16 = uitofp <32 x i64> undef to <32 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v32i1_v32f16 = uitofp <32 x i1> undef to <32 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v64i8_v64f16 = uitofp <64 x i8> undef to <64 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v64i16_v64f16 = uitofp <64 x i16> undef to <64 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v64i32_v64f16 = uitofp <64 x i32> undef to <64 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 27 for instruction: %v64i64_v64f16 = uitofp <64 x i64> undef to <64 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v64i1_v64f16 = uitofp <64 x i1> undef to <64 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %v128i8_v128f16 = uitofp <128 x i8> undef to <128 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v128i16_v128f16 = uitofp <128 x i16> undef to <128 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %v128i32_v128f16 = uitofp <128 x i32> undef to <128 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 54 for instruction: %v128i64_v128f16 = uitofp <128 x i64> undef to <128 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %v128i1_v128f16 = uitofp <128 x i1> undef to <128 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i8_nxv1f16 = uitofp <vscale x 1 x i8> undef to <vscale x 1 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i16_nxv1f16 = uitofp <vscale x 1 x i16> undef to <vscale x 1 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv1i32_nxv1f16 = uitofp <vscale x 1 x i32> undef to <vscale x 1 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1i64_nxv1f16 = uitofp <vscale x 1 x i64> undef to <vscale x 1 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv1i1_nxv1f16 = uitofp <vscale x 1 x i1> undef to <vscale x 1 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i8_nxv2f16 = uitofp <vscale x 2 x i8> undef to <vscale x 2 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i16_nxv2f16 = uitofp <vscale x 2 x i16> undef to <vscale x 2 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i32_nxv2f16 = uitofp <vscale x 2 x i32> undef to <vscale x 2 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i64_nxv2f16 = uitofp <vscale x 2 x i64> undef to <vscale x 2 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2i1_nxv2f16 = uitofp <vscale x 2 x i1> undef to <vscale x 2 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i8_nxv4f16 = uitofp <vscale x 4 x i8> undef to <vscale x 4 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i16_nxv4f16 = uitofp <vscale x 4 x i16> undef to <vscale x 4 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i32_nxv4f16 = uitofp <vscale x 4 x i32> undef to <vscale x 4 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i64_nxv4f16 = uitofp <vscale x 4 x i64> undef to <vscale x 4 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i1_nxv4f16 = uitofp <vscale x 4 x i1> undef to <vscale x 4 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i8_nxv8f16 = uitofp <vscale x 8 x i8> undef to <vscale x 8 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i16_nxv8f16 = uitofp <vscale x 8 x i16> undef to <vscale x 8 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i32_nxv8f16 = uitofp <vscale x 8 x i32> undef to <vscale x 8 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv8i64_nxv8f16 = uitofp <vscale x 8 x i64> undef to <vscale x 8 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8i1_nxv8f16 = uitofp <vscale x 8 x i1> undef to <vscale x 8 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16i8_nxv16f16 = uitofp <vscale x 16 x i8> undef to <vscale x 16 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16i16_nxv16f16 = uitofp <vscale x 16 x i16> undef to <vscale x 16 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16i32_nxv16f16 = uitofp <vscale x 16 x i32> undef to <vscale x 16 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %nxv16i64_nxv16f16 = uitofp <vscale x 16 x i64> undef to <vscale x 16 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv16i1_nxv16f16 = uitofp <vscale x 16 x i1> undef to <vscale x 16 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv32i8_nxv32f16 = uitofp <vscale x 32 x i8> undef to <vscale x 32 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv32i16_nxv32f16 = uitofp <vscale x 32 x i16> undef to <vscale x 32 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %nxv32i32_nxv32f16 = uitofp <vscale x 32 x i32> undef to <vscale x 32 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 27 for instruction: %nxv32i64_nxv32f16 = uitofp <vscale x 32 x i64> undef to <vscale x 32 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %nxv32i1_nxv32f16 = uitofp <vscale x 32 x i1> undef to <vscale x 32 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %nxv64i8_nxv64f16 = uitofp <vscale x 64 x i8> undef to <vscale x 64 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64i16_nxv64f16 = uitofp <vscale x 64 x i16> undef to <vscale x 64 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %nxv64i32_nxv64f16 = uitofp <vscale x 64 x i32> undef to <vscale x 64 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 54 for instruction: %nxv64i64_nxv64f16 = uitofp <vscale x 64 x i64> undef to <vscale x 64 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %nxv64i1_nxv64f16 = uitofp <vscale x 64 x i1> undef to <vscale x 64 x half>
; RV64ZVFH-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV64ZVFHMIN-LABEL: 'uitofp'
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2i8_v2f16 = uitofp <2 x i8> undef to <2 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i16_v2f16 = uitofp <2 x i16> undef to <2 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i32_v2f16 = uitofp <2 x i32> undef to <2 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i64_v2f16 = uitofp <2 x i64> undef to <2 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v2i1_v2f16 = uitofp <2 x i1> undef to <2 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i8_v4f16 = uitofp <4 x i8> undef to <4 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i16_v4f16 = uitofp <4 x i16> undef to <4 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i32_v4f16 = uitofp <4 x i32> undef to <4 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i64_v4f16 = uitofp <4 x i64> undef to <4 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v4i1_v4f16 = uitofp <4 x i1> undef to <4 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i8_v8f16 = uitofp <8 x i8> undef to <8 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i16_v8f16 = uitofp <8 x i16> undef to <8 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i32_v8f16 = uitofp <8 x i32> undef to <8 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i64_v8f16 = uitofp <8 x i64> undef to <8 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8i1_v8f16 = uitofp <8 x i1> undef to <8 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %v16i8_v16f16 = uitofp <16 x i8> undef to <16 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v16i16_v16f16 = uitofp <16 x i16> undef to <16 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v16i32_v16f16 = uitofp <16 x i32> undef to <16 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v16i64_v16f16 = uitofp <16 x i64> undef to <16 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v16i1_v16f16 = uitofp <16 x i1> undef to <16 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %v32i8_v32f16 = uitofp <32 x i8> undef to <32 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v32i16_v32f16 = uitofp <32 x i16> undef to <32 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %v32i32_v32f16 = uitofp <32 x i32> undef to <32 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %v32i64_v32f16 = uitofp <32 x i64> undef to <32 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %v32i1_v32f16 = uitofp <32 x i1> undef to <32 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 41 for instruction: %v64i8_v64f16 = uitofp <64 x i8> undef to <64 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %v64i16_v64f16 = uitofp <64 x i16> undef to <64 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %v64i32_v64f16 = uitofp <64 x i32> undef to <64 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 27 for instruction: %v64i64_v64f16 = uitofp <64 x i64> undef to <64 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 49 for instruction: %v64i1_v64f16 = uitofp <64 x i1> undef to <64 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 83 for instruction: %v128i8_v128f16 = uitofp <128 x i8> undef to <128 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 66 for instruction: %v128i16_v128f16 = uitofp <128 x i16> undef to <128 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 50 for instruction: %v128i32_v128f16 = uitofp <128 x i32> undef to <128 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 54 for instruction: %v128i64_v128f16 = uitofp <128 x i64> undef to <128 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %v128i1_v128f16 = uitofp <128 x i1> undef to <128 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv1i8_nxv1f16 = uitofp <vscale x 1 x i8> undef to <vscale x 1 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1i16_nxv1f16 = uitofp <vscale x 1 x i16> undef to <vscale x 1 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1i32_nxv1f16 = uitofp <vscale x 1 x i32> undef to <vscale x 1 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv1i64_nxv1f16 = uitofp <vscale x 1 x i64> undef to <vscale x 1 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv1i1_nxv1f16 = uitofp <vscale x 1 x i1> undef to <vscale x 1 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2i8_nxv2f16 = uitofp <vscale x 2 x i8> undef to <vscale x 2 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i16_nxv2f16 = uitofp <vscale x 2 x i16> undef to <vscale x 2 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i32_nxv2f16 = uitofp <vscale x 2 x i32> undef to <vscale x 2 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i64_nxv2f16 = uitofp <vscale x 2 x i64> undef to <vscale x 2 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv2i1_nxv2f16 = uitofp <vscale x 2 x i1> undef to <vscale x 2 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4i8_nxv4f16 = uitofp <vscale x 4 x i8> undef to <vscale x 4 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i16_nxv4f16 = uitofp <vscale x 4 x i16> undef to <vscale x 4 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i32_nxv4f16 = uitofp <vscale x 4 x i32> undef to <vscale x 4 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i64_nxv4f16 = uitofp <vscale x 4 x i64> undef to <vscale x 4 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv4i1_nxv4f16 = uitofp <vscale x 4 x i1> undef to <vscale x 4 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %nxv8i8_nxv8f16 = uitofp <vscale x 8 x i8> undef to <vscale x 8 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv8i16_nxv8f16 = uitofp <vscale x 8 x i16> undef to <vscale x 8 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv8i32_nxv8f16 = uitofp <vscale x 8 x i32> undef to <vscale x 8 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv8i64_nxv8f16 = uitofp <vscale x 8 x i64> undef to <vscale x 8 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %nxv8i1_nxv8f16 = uitofp <vscale x 8 x i1> undef to <vscale x 8 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %nxv16i8_nxv16f16 = uitofp <vscale x 16 x i8> undef to <vscale x 16 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %nxv16i16_nxv16f16 = uitofp <vscale x 16 x i16> undef to <vscale x 16 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %nxv16i32_nxv16f16 = uitofp <vscale x 16 x i32> undef to <vscale x 16 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %nxv16i64_nxv16f16 = uitofp <vscale x 16 x i64> undef to <vscale x 16 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %nxv16i1_nxv16f16 = uitofp <vscale x 16 x i1> undef to <vscale x 16 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 41 for instruction: %nxv32i8_nxv32f16 = uitofp <vscale x 32 x i8> undef to <vscale x 32 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %nxv32i16_nxv32f16 = uitofp <vscale x 32 x i16> undef to <vscale x 32 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %nxv32i32_nxv32f16 = uitofp <vscale x 32 x i32> undef to <vscale x 32 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 27 for instruction: %nxv32i64_nxv32f16 = uitofp <vscale x 32 x i64> undef to <vscale x 32 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 49 for instruction: %nxv32i1_nxv32f16 = uitofp <vscale x 32 x i1> undef to <vscale x 32 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 83 for instruction: %nxv64i8_nxv64f16 = uitofp <vscale x 64 x i8> undef to <vscale x 64 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64i16_nxv64f16 = uitofp <vscale x 64 x i16> undef to <vscale x 64 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 50 for instruction: %nxv64i32_nxv64f16 = uitofp <vscale x 64 x i32> undef to <vscale x 64 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 54 for instruction: %nxv64i64_nxv64f16 = uitofp <vscale x 64 x i64> undef to <vscale x 64 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %nxv64i1_nxv64f16 = uitofp <vscale x 64 x i1> undef to <vscale x 64 x half>
; RV64ZVFHMIN-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %v2i8_v2f16 = uitofp <2 x i8> undef to <2 x half>
  %v2i16_v2f16 = uitofp <2 x i16> undef to <2 x half>
  %v2i32_v2f16 = uitofp <2 x i32> undef to <2 x half>
  %v2i64_v2f16 = uitofp <2 x i64> undef to <2 x half>
  %v2i1_v2f16 = uitofp <2 x i1> undef to <2 x half>
  %v4i8_v4f16 = uitofp <4 x i8> undef to <4 x half>
  %v4i16_v4f16 = uitofp <4 x i16> undef to <4 x half>
  %v4i32_v4f16 = uitofp <4 x i32> undef to <4 x half>
  %v4i64_v4f16 = uitofp <4 x i64> undef to <4 x half>
  %v4i1_v4f16 = uitofp <4 x i1> undef to <4 x half>
  %v8i8_v8f16 = uitofp <8 x i8> undef to <8 x half>
  %v8i16_v8f16 = uitofp <8 x i16> undef to <8 x half>
  %v8i32_v8f16 = uitofp <8 x i32> undef to <8 x half>
  %v8i64_v8f16 = uitofp <8 x i64> undef to <8 x half>
  %v8i1_v8f16 = uitofp <8 x i1> undef to <8 x half>
  %v16i8_v16f16 = uitofp <16 x i8> undef to <16 x half>
  %v16i16_v16f16 = uitofp <16 x i16> undef to <16 x half>
  %v16i32_v16f16 = uitofp <16 x i32> undef to <16 x half>
  %v16i64_v16f16 = uitofp <16 x i64> undef to <16 x half>
  %v16i1_v16f16 = uitofp <16 x i1> undef to <16 x half>
  %v32i8_v32f16 = uitofp <32 x i8> undef to <32 x half>
  %v32i16_v32f16 = uitofp <32 x i16> undef to <32 x half>
  %v32i32_v32f16 = uitofp <32 x i32> undef to <32 x half>
  %v32i64_v32f16 = uitofp <32 x i64> undef to <32 x half>
  %v32i1_v32f16 = uitofp <32 x i1> undef to <32 x half>
  %v64i8_v64f16 = uitofp <64 x i8> undef to <64 x half>
  %v64i16_v64f16 = uitofp <64 x i16> undef to <64 x half>
  %v64i32_v64f16 = uitofp <64 x i32> undef to <64 x half>
  %v64i64_v64f16 = uitofp <64 x i64> undef to <64 x half>
  %v64i1_v64f16 = uitofp <64 x i1> undef to <64 x half>
  %v128i8_v128f16 = uitofp <128 x i8> undef to <128 x half>
  %v128i16_v128f16 = uitofp <128 x i16> undef to <128 x half>
  %v128i32_v128f16 = uitofp <128 x i32> undef to <128 x half>
  %v128i64_v128f16 = uitofp <128 x i64> undef to <128 x half>
  %v128i1_v128f16 = uitofp <128 x i1> undef to <128 x half>
  %nxv1i8_nxv1f16 = uitofp <vscale x 1 x i8> undef to <vscale x 1 x half>
  %nxv1i16_nxv1f16 = uitofp <vscale x 1 x i16> undef to <vscale x 1 x half>
  %nxv1i32_nxv1f16 = uitofp <vscale x 1 x i32> undef to <vscale x 1 x half>
  %nxv1i64_nxv1f16 = uitofp <vscale x 1 x i64> undef to <vscale x 1 x half>
  %nxv1i1_nxv1f16 = uitofp <vscale x 1 x i1> undef to <vscale x 1 x half>
  %nxv2i8_nxv2f16 = uitofp <vscale x 2 x i8> undef to <vscale x 2 x half>
  %nxv2i16_nxv2f16 = uitofp <vscale x 2 x i16> undef to <vscale x 2 x half>
  %nxv2i32_nxv2f16 = uitofp <vscale x 2 x i32> undef to <vscale x 2 x half>
  %nxv2i64_nxv2f16 = uitofp <vscale x 2 x i64> undef to <vscale x 2 x half>
  %nxv2i1_nxv2f16 = uitofp <vscale x 2 x i1> undef to <vscale x 2 x half>
  %nxv4i8_nxv4f16 = uitofp <vscale x 4 x i8> undef to <vscale x 4 x half>
  %nxv4i16_nxv4f16 = uitofp <vscale x 4 x i16> undef to <vscale x 4 x half>
  %nxv4i32_nxv4f16 = uitofp <vscale x 4 x i32> undef to <vscale x 4 x half>
  %nxv4i64_nxv4f16 = uitofp <vscale x 4 x i64> undef to <vscale x 4 x half>
  %nxv4i1_nxv4f16 = uitofp <vscale x 4 x i1> undef to <vscale x 4 x half>
  %nxv8i8_nxv8f16 = uitofp <vscale x 8 x i8> undef to <vscale x 8 x half>
  %nxv8i16_nxv8f16 = uitofp <vscale x 8 x i16> undef to <vscale x 8 x half>
  %nxv8i32_nxv8f16 = uitofp <vscale x 8 x i32> undef to <vscale x 8 x half>
  %nxv8i64_nxv8f16 = uitofp <vscale x 8 x i64> undef to <vscale x 8 x half>
  %nxv8i1_nxv8f16 = uitofp <vscale x 8 x i1> undef to <vscale x 8 x half>
  %nxv16i8_nxv16f16 = uitofp <vscale x 16 x i8> undef to <vscale x 16 x half>
  %nxv16i16_nxv16f16 = uitofp <vscale x 16 x i16> undef to <vscale x 16 x half>
  %nxv16i32_nxv16f16 = uitofp <vscale x 16 x i32> undef to <vscale x 16 x half>
  %nxv16i64_nxv16f16 = uitofp <vscale x 16 x i64> undef to <vscale x 16 x half>
  %nxv16i1_nxv16f16 = uitofp <vscale x 16 x i1> undef to <vscale x 16 x half>
  %nxv32i8_nxv32f16 = uitofp <vscale x 32 x i8> undef to <vscale x 32 x half>
  %nxv32i16_nxv32f16 = uitofp <vscale x 32 x i16> undef to <vscale x 32 x half>
  %nxv32i32_nxv32f16 = uitofp <vscale x 32 x i32> undef to <vscale x 32 x half>
  %nxv32i64_nxv32f16 = uitofp <vscale x 32 x i64> undef to <vscale x 32 x half>
  %nxv32i1_nxv32f16 = uitofp <vscale x 32 x i1> undef to <vscale x 32 x half>
  %nxv64i8_nxv64f16 = uitofp <vscale x 64 x i8> undef to <vscale x 64 x half>
  %nxv64i16_nxv64f16 = uitofp <vscale x 64 x i16> undef to <vscale x 64 x half>
  %nxv64i32_nxv64f16 = uitofp <vscale x 64 x i32> undef to <vscale x 64 x half>
  %nxv64i64_nxv64f16 = uitofp <vscale x 64 x i64> undef to <vscale x 64 x half>
  %nxv64i1_nxv64f16 = uitofp <vscale x 64 x i1> undef to <vscale x 64 x half>
  ret void
}
