; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --include-generated-funcs
; RUN: opt -S -passes=verify,iroutliner -ir-outlining-no-cost < %s | FileCheck %s

; When the an outlined section contains a PHINode with an incoming block
; outside of the region, the predecessors to be handled specially to ensure that
; a global value is properly assigned.  This ensures that there is no crash
; in that situation.

define void @fn1() local_unnamed_addr #0 {
entry:
  br label %block_1

block_1:
  %a = phi i32 [ 0, %block_2], [ 1, %entry ]
  br i1 0, label %block_3, label %block_2
block_2:
  br i1 0, label %block_3, label %block_1

block_3:
  %b = phi i32 [ 0, %block_2 ], [ 1, %block_1 ]
  br label %block_4

block_4:
  %c = phi i32 [ 0, %block_5 ], [ 1, %block_3 ]
  br i1 0, label %block_6, label %block_5

block_5:
  br i1 0, label %block_6, label %block_4

block_6:
  unreachable
}
; CHECK-LABEL: @fn1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[B_CE_LOC:%.*]] = alloca i32, align 4
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 -1, ptr [[B_CE_LOC]])
; CHECK-NEXT:    call void @outlined_ir_func_0(ptr [[B_CE_LOC]], i32 0)
; CHECK-NEXT:    [[B_CE_RELOAD:%.*]] = load i32, ptr [[B_CE_LOC]], align 4
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 -1, ptr [[B_CE_LOC]])
; CHECK-NEXT:    br label [[BLOCK_3:%.*]]
; CHECK:       block_3:
; CHECK-NEXT:    [[B:%.*]] = phi i32 [ [[B_CE_RELOAD]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    call void @outlined_ir_func_0(ptr null, i32 -1)
; CHECK-NEXT:    br label [[BLOCK_6:%.*]]
; CHECK:       block_6:
; CHECK-NEXT:    unreachable
;
;
; CHECK-LABEL: define internal void @outlined_ir_func_0(
; CHECK-NEXT:  newFuncRoot:
; CHECK-NEXT:    br label [[ENTRY_TO_OUTLINE:%.*]]
; CHECK:       entry_to_outline:
; CHECK-NEXT:    br label [[BLOCK_1:%.*]]
; CHECK:       block_1:
; CHECK-NEXT:    [[A:%.*]] = phi i32 [ 0, [[BLOCK_2:%.*]] ], [ 1, [[ENTRY_TO_OUTLINE]] ]
; CHECK-NEXT:    br i1 false, label [[BLOCK_3_SPLIT:%.*]], label [[BLOCK_2]]
; CHECK:       block_2:
; CHECK-NEXT:    br i1 false, label [[BLOCK_3_SPLIT]], label [[BLOCK_1]]
; CHECK:       block_3.split:
; CHECK-NEXT:    [[B_CE:%.*]] = phi i32 [ 0, [[BLOCK_2]] ], [ 1, [[BLOCK_1]] ]
; CHECK-NEXT:    br label [[BLOCK_3_EXITSTUB:%.*]]
; CHECK:       block_3.exitStub:
; CHECK-NEXT:    switch i32 [[TMP1:%.*]], label [[FINAL_BLOCK_0:%.*]] [
; CHECK-NEXT:    i32 0, label [[OUTPUT_BLOCK_0_0:%.*]]
; CHECK-NEXT:    ]
; CHECK:       output_block_0_0:
; CHECK-NEXT:    store i32 [[B_CE]], ptr [[TMP0:%.*]], align 4
; CHECK-NEXT:    br label [[FINAL_BLOCK_0]]
; CHECK:       final_block_0:
; CHECK-NEXT:    ret void
;
