; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.2,+gfni | FileCheck %s --check-prefixes=GFNISSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx,+gfni | FileCheck %s --check-prefixes=GFNIAVX,GFNIAVX1OR2,GFNIAVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2,+gfni | FileCheck %s --check-prefixes=GFNIAVX,GFNIAVX1OR2,GFNIAVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vl,+gfni | FileCheck %s --check-prefixes=GFNIAVX,GFNIAVX512,GFNIAVX512VL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+avx512vl,+gfni | FileCheck %s --check-prefixes=GFNIAVX,GFNIAVX512,GFNIAVX512BW

define <16 x i8> @testv16i8(<16 x i8> %in) nounwind {
; GFNISSE-LABEL: testv16i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    pcmpeqd %xmm1, %xmm1
; GFNISSE-NEXT:    paddb %xmm0, %xmm1
; GFNISSE-NEXT:    pandn %xmm1, %xmm0
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; GFNISSE-NEXT:    pand %xmm0, %xmm2
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm1 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; GFNISSE-NEXT:    movdqa %xmm1, %xmm3
; GFNISSE-NEXT:    pshufb %xmm2, %xmm3
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; GFNISSE-NEXT:    pshufb %xmm0, %xmm1
; GFNISSE-NEXT:    paddb %xmm3, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1OR2-LABEL: testv16i8:
; GFNIAVX1OR2:       # %bb.0:
; GFNIAVX1OR2-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; GFNIAVX1OR2-NEXT:    vpaddb %xmm1, %xmm0, %xmm1
; GFNIAVX1OR2-NEXT:    vpandn %xmm1, %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; GFNIAVX1OR2-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; GFNIAVX1OR2-NEXT:    vpshufb %xmm1, %xmm2, %xmm1
; GFNIAVX1OR2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    vpshufb %xmm0, %xmm2, %xmm0
; GFNIAVX1OR2-NEXT:    vpaddb %xmm1, %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    retq
;
; GFNIAVX512-LABEL: testv16i8:
; GFNIAVX512:       # %bb.0:
; GFNIAVX512-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; GFNIAVX512-NEXT:    vpaddb %xmm1, %xmm0, %xmm1
; GFNIAVX512-NEXT:    vpandn %xmm1, %xmm0, %xmm0
; GFNIAVX512-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm1
; GFNIAVX512-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; GFNIAVX512-NEXT:    vpshufb %xmm1, %xmm2, %xmm1
; GFNIAVX512-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %xmm0
; GFNIAVX512-NEXT:    vpshufb %xmm0, %xmm2, %xmm0
; GFNIAVX512-NEXT:    vpaddb %xmm1, %xmm0, %xmm0
; GFNIAVX512-NEXT:    retq
  %out = call <16 x i8> @llvm.cttz.v16i8(<16 x i8> %in, i1 0)
  ret <16 x i8> %out
}

define <16 x i8> @testv16i8u(<16 x i8> %in) nounwind {
; GFNISSE-LABEL: testv16i8u:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    pcmpeqd %xmm1, %xmm1
; GFNISSE-NEXT:    paddb %xmm0, %xmm1
; GFNISSE-NEXT:    pandn %xmm1, %xmm0
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; GFNISSE-NEXT:    pand %xmm0, %xmm2
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm1 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; GFNISSE-NEXT:    movdqa %xmm1, %xmm3
; GFNISSE-NEXT:    pshufb %xmm2, %xmm3
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; GFNISSE-NEXT:    pshufb %xmm0, %xmm1
; GFNISSE-NEXT:    paddb %xmm3, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1OR2-LABEL: testv16i8u:
; GFNIAVX1OR2:       # %bb.0:
; GFNIAVX1OR2-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; GFNIAVX1OR2-NEXT:    vpaddb %xmm1, %xmm0, %xmm1
; GFNIAVX1OR2-NEXT:    vpandn %xmm1, %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; GFNIAVX1OR2-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; GFNIAVX1OR2-NEXT:    vpshufb %xmm1, %xmm2, %xmm1
; GFNIAVX1OR2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    vpshufb %xmm0, %xmm2, %xmm0
; GFNIAVX1OR2-NEXT:    vpaddb %xmm1, %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    retq
;
; GFNIAVX512-LABEL: testv16i8u:
; GFNIAVX512:       # %bb.0:
; GFNIAVX512-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; GFNIAVX512-NEXT:    vpaddb %xmm1, %xmm0, %xmm1
; GFNIAVX512-NEXT:    vpandn %xmm1, %xmm0, %xmm0
; GFNIAVX512-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm1
; GFNIAVX512-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; GFNIAVX512-NEXT:    vpshufb %xmm1, %xmm2, %xmm1
; GFNIAVX512-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %xmm0
; GFNIAVX512-NEXT:    vpshufb %xmm0, %xmm2, %xmm0
; GFNIAVX512-NEXT:    vpaddb %xmm1, %xmm0, %xmm0
; GFNIAVX512-NEXT:    retq
  %out = call <16 x i8> @llvm.cttz.v16i8(<16 x i8> %in, i1 -1)
  ret <16 x i8> %out
}

define <32 x i8> @testv32i8(<32 x i8> %in) nounwind {
; GFNISSE-LABEL: testv32i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    pcmpeqd %xmm4, %xmm4
; GFNISSE-NEXT:    movdqa %xmm0, %xmm2
; GFNISSE-NEXT:    paddb %xmm4, %xmm2
; GFNISSE-NEXT:    pandn %xmm2, %xmm0
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm5 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; GFNISSE-NEXT:    movdqa %xmm0, %xmm3
; GFNISSE-NEXT:    pand %xmm5, %xmm3
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm2 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; GFNISSE-NEXT:    movdqa %xmm2, %xmm6
; GFNISSE-NEXT:    pshufb %xmm3, %xmm6
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm7 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm7, %xmm0
; GFNISSE-NEXT:    movdqa %xmm2, %xmm3
; GFNISSE-NEXT:    pshufb %xmm0, %xmm3
; GFNISSE-NEXT:    paddb %xmm6, %xmm3
; GFNISSE-NEXT:    paddb %xmm1, %xmm4
; GFNISSE-NEXT:    pandn %xmm4, %xmm1
; GFNISSE-NEXT:    pand %xmm1, %xmm5
; GFNISSE-NEXT:    movdqa %xmm2, %xmm0
; GFNISSE-NEXT:    pshufb %xmm5, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm7, %xmm1
; GFNISSE-NEXT:    pshufb %xmm1, %xmm2
; GFNISSE-NEXT:    paddb %xmm0, %xmm2
; GFNISSE-NEXT:    movdqa %xmm3, %xmm0
; GFNISSE-NEXT:    movdqa %xmm2, %xmm1
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: testv32i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; GFNIAVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpaddb %xmm2, %xmm1, %xmm3
; GFNIAVX1-NEXT:    vpandn %xmm3, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vbroadcastss {{.*#+}} xmm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; GFNIAVX1-NEXT:    vpand %xmm3, %xmm1, %xmm4
; GFNIAVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; GFNIAVX1-NEXT:    vpshufb %xmm4, %xmm5, %xmm4
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm6 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNIAVX1-NEXT:    # xmm6 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm6, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpshufb %xmm1, %xmm5, %xmm1
; GFNIAVX1-NEXT:    vpaddb %xmm4, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpaddb %xmm2, %xmm0, %xmm2
; GFNIAVX1-NEXT:    vpandn %xmm2, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpand %xmm3, %xmm0, %xmm2
; GFNIAVX1-NEXT:    vpshufb %xmm2, %xmm5, %xmm2
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm6, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpshufb %xmm0, %xmm5, %xmm0
; GFNIAVX1-NEXT:    vpaddb %xmm2, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: testv32i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpaddb %ymm1, %ymm0, %ymm1
; GFNIAVX2-NEXT:    vpandn %ymm1, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm1
; GFNIAVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm2 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; GFNIAVX2-NEXT:    # ymm2 = mem[0,1,0,1]
; GFNIAVX2-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpshufb %ymm0, %ymm2, %ymm0
; GFNIAVX2-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512-LABEL: testv32i8:
; GFNIAVX512:       # %bb.0:
; GFNIAVX512-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; GFNIAVX512-NEXT:    vpaddb %ymm1, %ymm0, %ymm1
; GFNIAVX512-NEXT:    vpandn %ymm1, %ymm0, %ymm0
; GFNIAVX512-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm1
; GFNIAVX512-NEXT:    vbroadcasti128 {{.*#+}} ymm2 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; GFNIAVX512-NEXT:    # ymm2 = mem[0,1,0,1]
; GFNIAVX512-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; GFNIAVX512-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm0
; GFNIAVX512-NEXT:    vpshufb %ymm0, %ymm2, %ymm0
; GFNIAVX512-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; GFNIAVX512-NEXT:    retq
  %out = call <32 x i8> @llvm.cttz.v32i8(<32 x i8> %in, i1 0)
  ret <32 x i8> %out
}

define <32 x i8> @testv32i8u(<32 x i8> %in) nounwind {
; GFNISSE-LABEL: testv32i8u:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    pcmpeqd %xmm4, %xmm4
; GFNISSE-NEXT:    movdqa %xmm0, %xmm2
; GFNISSE-NEXT:    paddb %xmm4, %xmm2
; GFNISSE-NEXT:    pandn %xmm2, %xmm0
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm5 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; GFNISSE-NEXT:    movdqa %xmm0, %xmm3
; GFNISSE-NEXT:    pand %xmm5, %xmm3
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm2 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; GFNISSE-NEXT:    movdqa %xmm2, %xmm6
; GFNISSE-NEXT:    pshufb %xmm3, %xmm6
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm7 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm7, %xmm0
; GFNISSE-NEXT:    movdqa %xmm2, %xmm3
; GFNISSE-NEXT:    pshufb %xmm0, %xmm3
; GFNISSE-NEXT:    paddb %xmm6, %xmm3
; GFNISSE-NEXT:    paddb %xmm1, %xmm4
; GFNISSE-NEXT:    pandn %xmm4, %xmm1
; GFNISSE-NEXT:    pand %xmm1, %xmm5
; GFNISSE-NEXT:    movdqa %xmm2, %xmm0
; GFNISSE-NEXT:    pshufb %xmm5, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm7, %xmm1
; GFNISSE-NEXT:    pshufb %xmm1, %xmm2
; GFNISSE-NEXT:    paddb %xmm0, %xmm2
; GFNISSE-NEXT:    movdqa %xmm3, %xmm0
; GFNISSE-NEXT:    movdqa %xmm2, %xmm1
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: testv32i8u:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; GFNIAVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpaddb %xmm2, %xmm1, %xmm3
; GFNIAVX1-NEXT:    vpandn %xmm3, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vbroadcastss {{.*#+}} xmm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; GFNIAVX1-NEXT:    vpand %xmm3, %xmm1, %xmm4
; GFNIAVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; GFNIAVX1-NEXT:    vpshufb %xmm4, %xmm5, %xmm4
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm6 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNIAVX1-NEXT:    # xmm6 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm6, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpshufb %xmm1, %xmm5, %xmm1
; GFNIAVX1-NEXT:    vpaddb %xmm4, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpaddb %xmm2, %xmm0, %xmm2
; GFNIAVX1-NEXT:    vpandn %xmm2, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpand %xmm3, %xmm0, %xmm2
; GFNIAVX1-NEXT:    vpshufb %xmm2, %xmm5, %xmm2
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm6, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpshufb %xmm0, %xmm5, %xmm0
; GFNIAVX1-NEXT:    vpaddb %xmm2, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: testv32i8u:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpaddb %ymm1, %ymm0, %ymm1
; GFNIAVX2-NEXT:    vpandn %ymm1, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm1
; GFNIAVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm2 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; GFNIAVX2-NEXT:    # ymm2 = mem[0,1,0,1]
; GFNIAVX2-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpshufb %ymm0, %ymm2, %ymm0
; GFNIAVX2-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512-LABEL: testv32i8u:
; GFNIAVX512:       # %bb.0:
; GFNIAVX512-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; GFNIAVX512-NEXT:    vpaddb %ymm1, %ymm0, %ymm1
; GFNIAVX512-NEXT:    vpandn %ymm1, %ymm0, %ymm0
; GFNIAVX512-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm1
; GFNIAVX512-NEXT:    vbroadcasti128 {{.*#+}} ymm2 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; GFNIAVX512-NEXT:    # ymm2 = mem[0,1,0,1]
; GFNIAVX512-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; GFNIAVX512-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm0
; GFNIAVX512-NEXT:    vpshufb %ymm0, %ymm2, %ymm0
; GFNIAVX512-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; GFNIAVX512-NEXT:    retq
  %out = call <32 x i8> @llvm.cttz.v32i8(<32 x i8> %in, i1 -1)
  ret <32 x i8> %out
}

define <64 x i8> @testv64i8(<64 x i8> %in) nounwind {
; GFNISSE-LABEL: testv64i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm1, %xmm5
; GFNISSE-NEXT:    movdqa %xmm0, %xmm1
; GFNISSE-NEXT:    pcmpeqd %xmm6, %xmm6
; GFNISSE-NEXT:    paddb %xmm6, %xmm0
; GFNISSE-NEXT:    pandn %xmm0, %xmm1
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm7 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; GFNISSE-NEXT:    movdqa %xmm1, %xmm0
; GFNISSE-NEXT:    pand %xmm7, %xmm0
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; GFNISSE-NEXT:    movdqa %xmm4, %xmm9
; GFNISSE-NEXT:    pshufb %xmm0, %xmm9
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm8 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm8, %xmm1
; GFNISSE-NEXT:    movdqa %xmm4, %xmm0
; GFNISSE-NEXT:    pshufb %xmm1, %xmm0
; GFNISSE-NEXT:    paddb %xmm9, %xmm0
; GFNISSE-NEXT:    movdqa %xmm5, %xmm1
; GFNISSE-NEXT:    paddb %xmm6, %xmm1
; GFNISSE-NEXT:    pandn %xmm1, %xmm5
; GFNISSE-NEXT:    movdqa %xmm5, %xmm1
; GFNISSE-NEXT:    pand %xmm7, %xmm1
; GFNISSE-NEXT:    movdqa %xmm4, %xmm9
; GFNISSE-NEXT:    pshufb %xmm1, %xmm9
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm8, %xmm5
; GFNISSE-NEXT:    movdqa %xmm4, %xmm1
; GFNISSE-NEXT:    pshufb %xmm5, %xmm1
; GFNISSE-NEXT:    paddb %xmm9, %xmm1
; GFNISSE-NEXT:    movdqa %xmm2, %xmm5
; GFNISSE-NEXT:    paddb %xmm6, %xmm5
; GFNISSE-NEXT:    pandn %xmm5, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm5
; GFNISSE-NEXT:    pand %xmm7, %xmm5
; GFNISSE-NEXT:    movdqa %xmm4, %xmm9
; GFNISSE-NEXT:    pshufb %xmm5, %xmm9
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm8, %xmm2
; GFNISSE-NEXT:    movdqa %xmm4, %xmm5
; GFNISSE-NEXT:    pshufb %xmm2, %xmm5
; GFNISSE-NEXT:    paddb %xmm9, %xmm5
; GFNISSE-NEXT:    paddb %xmm3, %xmm6
; GFNISSE-NEXT:    pandn %xmm6, %xmm3
; GFNISSE-NEXT:    pand %xmm3, %xmm7
; GFNISSE-NEXT:    movdqa %xmm4, %xmm2
; GFNISSE-NEXT:    pshufb %xmm7, %xmm2
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm8, %xmm3
; GFNISSE-NEXT:    pshufb %xmm3, %xmm4
; GFNISSE-NEXT:    paddb %xmm2, %xmm4
; GFNISSE-NEXT:    movdqa %xmm5, %xmm2
; GFNISSE-NEXT:    movdqa %xmm4, %xmm3
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: testv64i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; GFNIAVX1-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpaddb %xmm3, %xmm2, %xmm4
; GFNIAVX1-NEXT:    vpandn %xmm4, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vbroadcastss {{.*#+}} xmm4 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; GFNIAVX1-NEXT:    vpand %xmm4, %xmm2, %xmm5
; GFNIAVX1-NEXT:    vmovdqa {{.*#+}} xmm6 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; GFNIAVX1-NEXT:    vpshufb %xmm5, %xmm6, %xmm5
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm7 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNIAVX1-NEXT:    # xmm7 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm7, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpshufb %xmm2, %xmm6, %xmm2
; GFNIAVX1-NEXT:    vpaddb %xmm5, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpaddb %xmm3, %xmm0, %xmm5
; GFNIAVX1-NEXT:    vpandn %xmm5, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpand %xmm4, %xmm0, %xmm5
; GFNIAVX1-NEXT:    vpshufb %xmm5, %xmm6, %xmm5
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm7, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpshufb %xmm0, %xmm6, %xmm0
; GFNIAVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; GFNIAVX1-NEXT:    vpaddb %xmm3, %xmm2, %xmm5
; GFNIAVX1-NEXT:    vpandn %xmm5, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpand %xmm4, %xmm2, %xmm5
; GFNIAVX1-NEXT:    vpshufb %xmm5, %xmm6, %xmm5
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm7, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpshufb %xmm2, %xmm6, %xmm2
; GFNIAVX1-NEXT:    vpaddb %xmm5, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm3
; GFNIAVX1-NEXT:    vpandn %xmm3, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpand %xmm4, %xmm1, %xmm3
; GFNIAVX1-NEXT:    vpshufb %xmm3, %xmm6, %xmm3
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm7, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpshufb %xmm1, %xmm6, %xmm1
; GFNIAVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: testv64i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm3
; GFNIAVX2-NEXT:    vpandn %ymm3, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpbroadcastb {{.*#+}} ymm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; GFNIAVX2-NEXT:    vpand %ymm3, %ymm0, %ymm4
; GFNIAVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; GFNIAVX2-NEXT:    # ymm5 = mem[0,1,0,1]
; GFNIAVX2-NEXT:    vpshufb %ymm4, %ymm5, %ymm4
; GFNIAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm6 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm6, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpshufb %ymm0, %ymm5, %ymm0
; GFNIAVX2-NEXT:    vpaddb %ymm4, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpaddb %ymm2, %ymm1, %ymm2
; GFNIAVX2-NEXT:    vpandn %ymm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpand %ymm3, %ymm1, %ymm2
; GFNIAVX2-NEXT:    vpshufb %ymm2, %ymm5, %ymm2
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm6, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpshufb %ymm1, %ymm5, %ymm1
; GFNIAVX2-NEXT:    vpaddb %ymm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: testv64i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; GFNIAVX512VL-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpaddb %ymm2, %ymm1, %ymm3
; GFNIAVX512VL-NEXT:    vpandn %ymm3, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpbroadcastd {{.*#+}} ymm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; GFNIAVX512VL-NEXT:    vpand %ymm3, %ymm1, %ymm4
; GFNIAVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; GFNIAVX512VL-NEXT:    # ymm5 = mem[0,1,0,1]
; GFNIAVX512VL-NEXT:    vpshufb %ymm4, %ymm5, %ymm4
; GFNIAVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm6 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm6, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpshufb %ymm1, %ymm5, %ymm1
; GFNIAVX512VL-NEXT:    vpaddb %ymm4, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpaddb %ymm2, %ymm0, %ymm2
; GFNIAVX512VL-NEXT:    vpandn %ymm2, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpand %ymm3, %ymm0, %ymm2
; GFNIAVX512VL-NEXT:    vpshufb %ymm2, %ymm5, %ymm2
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm6, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpshufb %ymm0, %ymm5, %ymm0
; GFNIAVX512VL-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: testv64i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpternlogd {{.*#+}} zmm1 = -1
; GFNIAVX512BW-NEXT:    vpaddb %zmm1, %zmm0, %zmm1
; GFNIAVX512BW-NEXT:    vpandnq %zmm1, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %zmm1
; GFNIAVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm2 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; GFNIAVX512BW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; GFNIAVX512BW-NEXT:    vpshufb %zmm1, %zmm2, %zmm1
; GFNIAVX512BW-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpshufb %zmm0, %zmm2, %zmm0
; GFNIAVX512BW-NEXT:    vpaddb %zmm1, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    retq
  %out = call <64 x i8> @llvm.cttz.v64i8(<64 x i8> %in, i1 0)
  ret <64 x i8> %out
}

define <64 x i8> @testv64i8u(<64 x i8> %in) nounwind {
; GFNISSE-LABEL: testv64i8u:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm1, %xmm5
; GFNISSE-NEXT:    movdqa %xmm0, %xmm1
; GFNISSE-NEXT:    pcmpeqd %xmm6, %xmm6
; GFNISSE-NEXT:    paddb %xmm6, %xmm0
; GFNISSE-NEXT:    pandn %xmm0, %xmm1
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm7 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; GFNISSE-NEXT:    movdqa %xmm1, %xmm0
; GFNISSE-NEXT:    pand %xmm7, %xmm0
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm4 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; GFNISSE-NEXT:    movdqa %xmm4, %xmm9
; GFNISSE-NEXT:    pshufb %xmm0, %xmm9
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm8 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm8, %xmm1
; GFNISSE-NEXT:    movdqa %xmm4, %xmm0
; GFNISSE-NEXT:    pshufb %xmm1, %xmm0
; GFNISSE-NEXT:    paddb %xmm9, %xmm0
; GFNISSE-NEXT:    movdqa %xmm5, %xmm1
; GFNISSE-NEXT:    paddb %xmm6, %xmm1
; GFNISSE-NEXT:    pandn %xmm1, %xmm5
; GFNISSE-NEXT:    movdqa %xmm5, %xmm1
; GFNISSE-NEXT:    pand %xmm7, %xmm1
; GFNISSE-NEXT:    movdqa %xmm4, %xmm9
; GFNISSE-NEXT:    pshufb %xmm1, %xmm9
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm8, %xmm5
; GFNISSE-NEXT:    movdqa %xmm4, %xmm1
; GFNISSE-NEXT:    pshufb %xmm5, %xmm1
; GFNISSE-NEXT:    paddb %xmm9, %xmm1
; GFNISSE-NEXT:    movdqa %xmm2, %xmm5
; GFNISSE-NEXT:    paddb %xmm6, %xmm5
; GFNISSE-NEXT:    pandn %xmm5, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm5
; GFNISSE-NEXT:    pand %xmm7, %xmm5
; GFNISSE-NEXT:    movdqa %xmm4, %xmm9
; GFNISSE-NEXT:    pshufb %xmm5, %xmm9
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm8, %xmm2
; GFNISSE-NEXT:    movdqa %xmm4, %xmm5
; GFNISSE-NEXT:    pshufb %xmm2, %xmm5
; GFNISSE-NEXT:    paddb %xmm9, %xmm5
; GFNISSE-NEXT:    paddb %xmm3, %xmm6
; GFNISSE-NEXT:    pandn %xmm6, %xmm3
; GFNISSE-NEXT:    pand %xmm3, %xmm7
; GFNISSE-NEXT:    movdqa %xmm4, %xmm2
; GFNISSE-NEXT:    pshufb %xmm7, %xmm2
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm8, %xmm3
; GFNISSE-NEXT:    pshufb %xmm3, %xmm4
; GFNISSE-NEXT:    paddb %xmm2, %xmm4
; GFNISSE-NEXT:    movdqa %xmm5, %xmm2
; GFNISSE-NEXT:    movdqa %xmm4, %xmm3
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: testv64i8u:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; GFNIAVX1-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpaddb %xmm3, %xmm2, %xmm4
; GFNIAVX1-NEXT:    vpandn %xmm4, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vbroadcastss {{.*#+}} xmm4 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; GFNIAVX1-NEXT:    vpand %xmm4, %xmm2, %xmm5
; GFNIAVX1-NEXT:    vmovdqa {{.*#+}} xmm6 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; GFNIAVX1-NEXT:    vpshufb %xmm5, %xmm6, %xmm5
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm7 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNIAVX1-NEXT:    # xmm7 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm7, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpshufb %xmm2, %xmm6, %xmm2
; GFNIAVX1-NEXT:    vpaddb %xmm5, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpaddb %xmm3, %xmm0, %xmm5
; GFNIAVX1-NEXT:    vpandn %xmm5, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpand %xmm4, %xmm0, %xmm5
; GFNIAVX1-NEXT:    vpshufb %xmm5, %xmm6, %xmm5
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm7, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpshufb %xmm0, %xmm6, %xmm0
; GFNIAVX1-NEXT:    vpaddb %xmm5, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; GFNIAVX1-NEXT:    vpaddb %xmm3, %xmm2, %xmm5
; GFNIAVX1-NEXT:    vpandn %xmm5, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpand %xmm4, %xmm2, %xmm5
; GFNIAVX1-NEXT:    vpshufb %xmm5, %xmm6, %xmm5
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm7, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpshufb %xmm2, %xmm6, %xmm2
; GFNIAVX1-NEXT:    vpaddb %xmm5, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm3
; GFNIAVX1-NEXT:    vpandn %xmm3, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpand %xmm4, %xmm1, %xmm3
; GFNIAVX1-NEXT:    vpshufb %xmm3, %xmm6, %xmm3
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm7, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpshufb %xmm1, %xmm6, %xmm1
; GFNIAVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: testv64i8u:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm3
; GFNIAVX2-NEXT:    vpandn %ymm3, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpbroadcastb {{.*#+}} ymm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; GFNIAVX2-NEXT:    vpand %ymm3, %ymm0, %ymm4
; GFNIAVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; GFNIAVX2-NEXT:    # ymm5 = mem[0,1,0,1]
; GFNIAVX2-NEXT:    vpshufb %ymm4, %ymm5, %ymm4
; GFNIAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm6 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm6, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpshufb %ymm0, %ymm5, %ymm0
; GFNIAVX2-NEXT:    vpaddb %ymm4, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpaddb %ymm2, %ymm1, %ymm2
; GFNIAVX2-NEXT:    vpandn %ymm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpand %ymm3, %ymm1, %ymm2
; GFNIAVX2-NEXT:    vpshufb %ymm2, %ymm5, %ymm2
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm6, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpshufb %ymm1, %ymm5, %ymm1
; GFNIAVX2-NEXT:    vpaddb %ymm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: testv64i8u:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; GFNIAVX512VL-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpaddb %ymm2, %ymm1, %ymm3
; GFNIAVX512VL-NEXT:    vpandn %ymm3, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpbroadcastd {{.*#+}} ymm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; GFNIAVX512VL-NEXT:    vpand %ymm3, %ymm1, %ymm4
; GFNIAVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; GFNIAVX512VL-NEXT:    # ymm5 = mem[0,1,0,1]
; GFNIAVX512VL-NEXT:    vpshufb %ymm4, %ymm5, %ymm4
; GFNIAVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm6 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm6, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpshufb %ymm1, %ymm5, %ymm1
; GFNIAVX512VL-NEXT:    vpaddb %ymm4, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpaddb %ymm2, %ymm0, %ymm2
; GFNIAVX512VL-NEXT:    vpandn %ymm2, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpand %ymm3, %ymm0, %ymm2
; GFNIAVX512VL-NEXT:    vpshufb %ymm2, %ymm5, %ymm2
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm6, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpshufb %ymm0, %ymm5, %ymm0
; GFNIAVX512VL-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: testv64i8u:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpternlogd {{.*#+}} zmm1 = -1
; GFNIAVX512BW-NEXT:    vpaddb %zmm1, %zmm0, %zmm1
; GFNIAVX512BW-NEXT:    vpandnq %zmm1, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %zmm1
; GFNIAVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm2 = [0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4]
; GFNIAVX512BW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; GFNIAVX512BW-NEXT:    vpshufb %zmm1, %zmm2, %zmm1
; GFNIAVX512BW-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpshufb %zmm0, %zmm2, %zmm0
; GFNIAVX512BW-NEXT:    vpaddb %zmm1, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    retq
  %out = call <64 x i8> @llvm.cttz.v64i8(<64 x i8> %in, i1 -1)
  ret <64 x i8> %out
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GFNIAVX: {{.*}}
