; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -O2 -verify-machineinstrs -mcpu=pwr4 -mattr=-altivec \
; RUN: -mtriple powerpc64-ibm-aix-xcoff < %s | FileCheck %s

define i32 @int_va_arg(i32 %a, ...) local_unnamed_addr  {
; CHECK-LABEL: int_va_arg:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    std 4, 56(1)
; CHECK-NEXT:    addi 4, 1, 56
; CHECK-NEXT:    std 4, -16(1)
; CHECK-NEXT:    std 4, -8(1)
; CHECK-NEXT:    ld 4, -16(1)
; CHECK-NEXT:    std 5, 64(1)
; CHECK-NEXT:    addi 5, 1, 60
; CHECK-NEXT:    std 5, -8(1)
; CHECK-NEXT:    addi 5, 4, 4
; CHECK-NEXT:    std 6, 72(1)
; CHECK-NEXT:    std 7, 80(1)
; CHECK-NEXT:    std 8, 88(1)
; CHECK-NEXT:    std 9, 96(1)
; CHECK-NEXT:    std 10, 104(1)
; CHECK-NEXT:    std 5, -16(1)
; CHECK-NEXT:    lwz 11, 56(1)
; CHECK-NEXT:    lwz 4, 0(4)
; CHECK-NEXT:    add 3, 11, 3
; CHECK-NEXT:    slwi 4, 4, 1
; CHECK-NEXT:    add 3, 3, 4
; CHECK-NEXT:    blr
entry:
  %arg1 = alloca ptr, align 8
  %arg2 = alloca ptr, align 8
  call void @llvm.lifetime.start.p0(i64 8, ptr nonnull %arg1)
  call void @llvm.lifetime.start.p0(i64 8, ptr nonnull %arg2)
  call void @llvm.va_start(ptr nonnull %arg1)
  call void @llvm.va_copy(ptr nonnull %arg2, ptr nonnull %arg1)
  %0 = va_arg ptr %arg1, i32
  %add = add nsw i32 %0, %a
  %1 = va_arg ptr %arg2, i32
  %mul = shl i32 %1, 1
  %add3 = add nsw i32 %add, %mul
  call void @llvm.va_end(ptr nonnull %arg1)
  call void @llvm.va_end(ptr nonnull %arg2)
  call void @llvm.lifetime.end.p0(i64 8, ptr nonnull %arg2)
  call void @llvm.lifetime.end.p0(i64 8, ptr nonnull %arg1)
  ret i32 %add3
}

declare void @llvm.lifetime.start.p0(i64 immarg, ptr nocapture)
declare void @llvm.va_start(ptr)
declare void @llvm.va_copy(ptr, ptr)
declare void @llvm.va_end(ptr)
declare void @llvm.lifetime.end.p0(i64 immarg, ptr nocapture)

define i32 @int_stack_va_arg(i32 %one, i32 %two, i32 %three, i32 %four, i32 %five, i32 %six, i32 %seven, i32 %eight, ...) local_unnamed_addr {
; CHECK-LABEL: int_stack_va_arg:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    add 3, 4, 3
; CHECK-NEXT:    lwz 11, 112(1)
; CHECK-NEXT:    add 3, 3, 5
; CHECK-NEXT:    add 3, 3, 6
; CHECK-NEXT:    add 3, 3, 7
; CHECK-NEXT:    add 3, 3, 8
; CHECK-NEXT:    add 3, 3, 9
; CHECK-NEXT:    add 3, 3, 10
; CHECK-NEXT:    add 3, 3, 11
; CHECK-NEXT:    slwi 4, 11, 1
; CHECK-NEXT:    add 3, 3, 4
; CHECK-NEXT:    blr
entry:
  %arg1 = alloca ptr, align 8
  %arg2 = alloca ptr, align 8
  call void @llvm.lifetime.start.p0(i64 8, ptr nonnull %arg1)
  call void @llvm.lifetime.start.p0(i64 8, ptr nonnull %arg2)
  call void @llvm.va_start(ptr nonnull %arg1)
  call void @llvm.va_copy(ptr nonnull %arg2, ptr nonnull %arg1)
  %add = add nsw i32 %two, %one
  %add2 = add nsw i32 %add, %three
  %add3 = add nsw i32 %add2, %four
  %add4 = add nsw i32 %add3, %five
  %add5 = add nsw i32 %add4, %six
  %add6 = add nsw i32 %add5, %seven
  %add7 = add nsw i32 %add6, %eight
  %0 = va_arg ptr %arg1, i32
  %add8 = add nsw i32 %add7, %0
  %1 = va_arg ptr %arg2, i32
  %mul = shl i32 %1, 1
  %add10 = add nsw i32 %add8, %mul
  call void @llvm.va_end(ptr nonnull %arg1)
  call void @llvm.va_end(ptr nonnull %arg2)
  call void @llvm.lifetime.end.p0(i64 8, ptr nonnull %arg2)
  call void @llvm.lifetime.end.p0(i64 8, ptr nonnull %arg1)
  ret i32 %add10
}

define double @double_va_arg(double %a, ...) local_unnamed_addr  {
; CHECK-LABEL: double_va_arg:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi 3, 1, 56
; CHECK-NEXT:    std 4, 56(1)
; CHECK-NEXT:    std 3, -8(1)
; CHECK-NEXT:    std 3, -16(1)
; CHECK-NEXT:    addi 3, 1, 64
; CHECK-NEXT:    std 3, -8(1)
; CHECK-NEXT:    ld 3, -16(1)
; CHECK-NEXT:    lfd 0, 56(1)
; CHECK-NEXT:    addi 4, 3, 8
; CHECK-NEXT:    std 5, 64(1)
; CHECK-NEXT:    fadd 0, 0, 1
; CHECK-NEXT:    std 6, 72(1)
; CHECK-NEXT:    std 7, 80(1)
; CHECK-NEXT:    std 8, 88(1)
; CHECK-NEXT:    std 9, 96(1)
; CHECK-NEXT:    std 10, 104(1)
; CHECK-NEXT:    std 4, -16(1)
; CHECK-NEXT:    lfd 1, 0(3)
; CHECK-NEXT:    fadd 1, 1, 1
; CHECK-NEXT:    fadd 1, 0, 1
; CHECK-NEXT:    blr
entry:
  %arg1 = alloca ptr, align 8
  %arg2 = alloca ptr, align 8
  call void @llvm.lifetime.start.p0(i64 8, ptr nonnull %arg1)
  call void @llvm.lifetime.start.p0(i64 8, ptr nonnull %arg2)
  call void @llvm.va_start(ptr nonnull %arg1)
  call void @llvm.va_copy(ptr nonnull %arg2, ptr nonnull %arg1)
  %0 = va_arg ptr %arg1, double
  %add = fadd double %0, %a
  %1 = va_arg ptr %arg2, double
  %mul = fmul double %1, 2.000000e+00
  %add3 = fadd double %add, %mul
  call void @llvm.va_end(ptr nonnull %arg1)
  call void @llvm.va_end(ptr nonnull %arg2)
  call void @llvm.lifetime.end.p0(i64 8, ptr nonnull %arg2)
  call void @llvm.lifetime.end.p0(i64 8, ptr nonnull %arg1)
  ret double %add3
}

define double @double_stack_va_arg(double %one, double %two, double %three, double %four, double %five, double %six, double %seven, double %eight, double %nine, double %ten, double %eleven, double %twelve, double %thirteen, ...) local_unnamed_addr  {
; CHECK-LABEL: double_stack_va_arg:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fadd 1, 1, 2
; CHECK-NEXT:    lfd 0, 152(1)
; CHECK-NEXT:    fadd 1, 1, 3
; CHECK-NEXT:    fadd 1, 1, 4
; CHECK-NEXT:    fadd 1, 1, 5
; CHECK-NEXT:    fadd 1, 1, 6
; CHECK-NEXT:    fadd 1, 1, 7
; CHECK-NEXT:    fadd 1, 1, 8
; CHECK-NEXT:    fadd 1, 1, 9
; CHECK-NEXT:    fadd 1, 1, 10
; CHECK-NEXT:    fadd 1, 1, 11
; CHECK-NEXT:    fadd 1, 1, 12
; CHECK-NEXT:    fadd 1, 1, 13
; CHECK-NEXT:    fadd 1, 1, 0
; CHECK-NEXT:    fadd 0, 0, 0
; CHECK-NEXT:    fadd 1, 1, 0
; CHECK-NEXT:    blr
entry:
  %arg1 = alloca ptr, align 8
  %arg2 = alloca ptr, align 8
  call void @llvm.lifetime.start.p0(i64 8, ptr nonnull %arg1)
  call void @llvm.lifetime.start.p0(i64 8, ptr nonnull %arg2)
  call void @llvm.va_start(ptr nonnull %arg1)
  call void @llvm.va_copy(ptr nonnull %arg2, ptr nonnull %arg1)
  %add = fadd double %one, %two
  %add2 = fadd double %add, %three
  %add3 = fadd double %add2, %four
  %add4 = fadd double %add3, %five
  %add5 = fadd double %add4, %six
  %add6 = fadd double %add5, %seven
  %add7 = fadd double %add6, %eight
  %add8 = fadd double %add7, %nine
  %add9 = fadd double %add8, %ten
  %add10 = fadd double %add9, %eleven
  %add11 = fadd double %add10, %twelve
  %add12 = fadd double %add11, %thirteen
  %0 = va_arg ptr %arg1, double
  %add13 = fadd double %add12, %0
  %1 = va_arg ptr %arg2, double
  %mul = fmul double %1, 2.000000e+00
  %add15 = fadd double %add13, %mul
  call void @llvm.lifetime.end.p0(i64 8, ptr nonnull %arg2)
  call void @llvm.lifetime.end.p0(i64 8, ptr nonnull %arg1)
  ret double %add15
}
