; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

; Memcpy is copying known-undef, and is thus removable
define void @test(ptr %dest) {
; CHECK-LABEL: @test(
; CHECK-NEXT:    ret void
;
  %a = alloca [7 x i8]
  call void @llvm.memcpy.p0.p0.i64(ptr %dest, ptr %a, i64 7, i1 false)
  ret void
}

; Some non-undef elements
define void @test2(ptr %dest) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    [[A:%.*]] = alloca [7 x i8], align 1
; CHECK-NEXT:    store i8 0, ptr [[A]], align 1
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 1 dereferenceable(7) [[DEST:%.*]], ptr noundef nonnull align 1 dereferenceable(7) [[A]], i64 7, i1 false)
; CHECK-NEXT:    ret void
;
  %a = alloca [7 x i8]
  store i8 0, ptr %a
  call void @llvm.memcpy.p0.p0.i64(ptr %dest, ptr %a, i64 7, i1 false)
  ret void
}

; Volatile write is still required
define void @test3(ptr %dest) {
; CHECK-LABEL: @test3(
; CHECK-NEXT:    [[A:%.*]] = alloca [7 x i8], align 1
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr [[DEST:%.*]], ptr [[A]], i64 7, i1 true)
; CHECK-NEXT:    ret void
;
  %a = alloca [7 x i8]
  call void @llvm.memcpy.p0.p0.i64(ptr %dest, ptr %a, i64 7, i1 true)
  ret void
}

define void @test4(ptr %dest) {
; CHECK-LABEL: @test4(
; CHECK-NEXT:    ret void
;
  %a = alloca [7 x i8]
  call void @llvm.memcpy.p0.p0.i64(ptr %dest, ptr %a, i64 7, i1 false)
  ret void
}

define void @test5(ptr %dest) {
; CHECK-LABEL: @test5(
; CHECK-NEXT:    ret void
;
  %a = alloca [7 x i8]
  %p2 = getelementptr i32, ptr %a, i32 1
  call void @llvm.memcpy.p0.p0.i64(ptr %dest, ptr %p2, i64 3, i1 false)
  ret void
}

define void @test6(ptr %dest) {
; CHECK-LABEL: @test6(
; CHECK-NEXT:    [[A:%.*]] = alloca [7 x i8], align 1
; CHECK-NEXT:    [[P2:%.*]] = getelementptr inbounds nuw i8, ptr [[A]], i64 2
; CHECK-NEXT:    store i16 42, ptr [[P2]], align 2
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 1 dereferenceable(7) [[DEST:%.*]], ptr noundef nonnull align 1 dereferenceable(7) [[P2]], i64 7, i1 false)
; CHECK-NEXT:    ret void
;
  %a = alloca [7 x i8]
  %p2 = getelementptr i16, ptr %a, i32 1
  store i16 42, ptr %p2
  call void @llvm.memcpy.p0.p0.i64(ptr %dest, ptr %p2, i64 7, i1 false)
  ret void
}

declare void @llvm.memcpy.p0.p0.i64(ptr, ptr, i64, i1)
