; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -O0 -verify-machineinstrs -mtriple=x86_64-unknown-unknown --show-mc-encoding -mattr=+amx-tile,+amx-avx512,+avx10.2-512 | FileCheck %s

define <16 x float> @test_tcvtrowd2ps(i32 %A) {
; CHECK-LABEL: test_tcvtrowd2ps:
; CHECK:       # %bb.0:
; CHECK-NEXT:    tcvtrowd2ps %edi, %tmm1, %zmm0 # encoding: [0x62,0xf2,0x46,0x48,0x4a,0xc1]
; CHECK-NEXT:    retq # encoding: [0xc3]
  %ret = call <16 x float> @llvm.x86.tcvtrowd2ps(i8 1, i32 %A)
  ret <16 x float> %ret
}

define <16 x float> @test_tcvtrowd2psi() {
; CHECK-LABEL: test_tcvtrowd2psi:
; CHECK:       # %bb.0:
; CHECK-NEXT:    tcvtrowd2ps $127, %tmm1, %zmm0 # encoding: [0x62,0xf3,0x7e,0x48,0x07,0xc1,0x7f]
; CHECK-NEXT:    retq # encoding: [0xc3]
  %ret = call <16 x float> @llvm.x86.tcvtrowd2ps(i8 1, i32 127)
  ret <16 x float> %ret
}
declare <16 x float> @llvm.x86.tcvtrowd2ps(i8 %A, i32 %B)

define <32 x bfloat> @test_tcvtrowps2bf16h(i32 %A) {
; CHECK-LABEL: test_tcvtrowps2bf16h:
; CHECK:       # %bb.0:
; CHECK-NEXT:    tcvtrowps2bf16h %edi, %tmm1, %zmm0 # encoding: [0x62,0xf2,0x47,0x48,0x6d,0xc1]
; CHECK-NEXT:    retq # encoding: [0xc3]
  %ret = call <32 x bfloat> @llvm.x86.tcvtrowps2bf16h(i8 1, i32 %A)
  ret <32 x bfloat> %ret
}

define <32 x bfloat> @test_tcvtrowps2bf16hi() {
; CHECK-LABEL: test_tcvtrowps2bf16hi:
; CHECK:       # %bb.0:
; CHECK-NEXT:    tcvtrowps2bf16h $127, %tmm1, %zmm0 # encoding: [0x62,0xf3,0x7f,0x48,0x07,0xc1,0x7f]
; CHECK-NEXT:    retq # encoding: [0xc3]
  %ret = call <32 x bfloat> @llvm.x86.tcvtrowps2bf16h(i8 1, i32 127)
  ret <32 x bfloat> %ret
}
declare <32 x bfloat> @llvm.x86.tcvtrowps2bf16h(i8 %A, i32 %B)

define <32 x bfloat> @test_tcvtrowps2bf16l(i32 %A) {
; CHECK-LABEL: test_tcvtrowps2bf16l:
; CHECK:       # %bb.0:
; CHECK-NEXT:    tcvtrowps2bf16l %edi, %tmm1, %zmm0 # encoding: [0x62,0xf2,0x46,0x48,0x6d,0xc1]
; CHECK-NEXT:    retq # encoding: [0xc3]
  %ret = call <32 x bfloat> @llvm.x86.tcvtrowps2bf16l(i8 1, i32 %A)
  ret <32 x bfloat> %ret
}

define <32 x bfloat> @test_tcvtrowps2bf16li() {
; CHECK-LABEL: test_tcvtrowps2bf16li:
; CHECK:       # %bb.0:
; CHECK-NEXT:    tcvtrowps2bf16l $127, %tmm1, %zmm0 # encoding: [0x62,0xf3,0x7e,0x48,0x77,0xc1,0x7f]
; CHECK-NEXT:    retq # encoding: [0xc3]
  %ret = call <32 x bfloat> @llvm.x86.tcvtrowps2bf16l(i8 1, i32 127)
  ret <32 x bfloat> %ret
}
declare <32 x bfloat> @llvm.x86.tcvtrowps2bf16l(i8 %A, i32 %B)

define <32 x half> @test_tcvtrowps2phh(i32 %A) {
; CHECK-LABEL: test_tcvtrowps2phh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    tcvtrowps2phh %edi, %tmm1, %zmm0 # encoding: [0x62,0xf2,0x44,0x48,0x6d,0xc1]
; CHECK-NEXT:    retq # encoding: [0xc3]
  %ret = call <32 x half> @llvm.x86.tcvtrowps2phh(i8 1, i32 %A)
  ret <32 x half> %ret
}

define <32 x half> @test_tcvtrowps2phhi() {
; CHECK-LABEL: test_tcvtrowps2phhi:
; CHECK:       # %bb.0:
; CHECK-NEXT:    tcvtrowps2phh $127, %tmm1, %zmm0 # encoding: [0x62,0xf3,0x7c,0x48,0x07,0xc1,0x7f]
; CHECK-NEXT:    retq # encoding: [0xc3]
  %ret = call <32 x half> @llvm.x86.tcvtrowps2phh(i8 1, i32 127)
  ret <32 x half> %ret
}
declare <32 x half> @llvm.x86.tcvtrowps2phh(i8 %A, i32 %B)

define <32 x half> @test_tcvtrowps2phl(i32 %A) {
; CHECK-LABEL: test_tcvtrowps2phl:
; CHECK:       # %bb.0:
; CHECK-NEXT:    tcvtrowps2phl %edi, %tmm1, %zmm0 # encoding: [0x62,0xf2,0x45,0x48,0x6d,0xc1]
; CHECK-NEXT:    retq # encoding: [0xc3]
  %ret = call <32 x half> @llvm.x86.tcvtrowps2phl(i8 1, i32 %A)
  ret <32 x half> %ret
}

define <32 x half> @test_tcvtrowps2phli() {
; CHECK-LABEL: test_tcvtrowps2phli:
; CHECK:       # %bb.0:
; CHECK-NEXT:    tcvtrowps2phl $127, %tmm1, %zmm0 # encoding: [0x62,0xf3,0x7f,0x48,0x77,0xc1,0x7f]
; CHECK-NEXT:    retq # encoding: [0xc3]
  %ret = call <32 x half> @llvm.x86.tcvtrowps2phl(i8 1, i32 127)
  ret <32 x half> %ret
}
declare <32 x half> @llvm.x86.tcvtrowps2phl(i8 %A, i32 %B)

define <16 x i32> @test_tilemovrow(i32 %A) {
; CHECK-LABEL: test_tilemovrow:
; CHECK:       # %bb.0:
; CHECK-NEXT:    tilemovrow %edi, %tmm1, %zmm0 # encoding: [0x62,0xf2,0x45,0x48,0x4a,0xc1]
; CHECK-NEXT:    retq # encoding: [0xc3]
  %ret = call <16 x i32> @llvm.x86.tilemovrow(i8 1, i32 %A)
  ret <16 x i32> %ret
}

define <16 x i32> @test_tilemovrowi() {
; CHECK-LABEL: test_tilemovrowi:
; CHECK:       # %bb.0:
; CHECK-NEXT:    tilemovrow $127, %tmm1, %zmm0 # encoding: [0x62,0xf3,0x7d,0x48,0x07,0xc1,0x7f]
; CHECK-NEXT:    retq # encoding: [0xc3]
  %ret = call <16 x i32> @llvm.x86.tilemovrow(i8 1, i32 127)
  ret <16 x i32> %ret
}
declare <16 x i32> @llvm.x86.tilemovrow(i8 %A, i32 %B)
