; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx700 < %s | FileCheck -check-prefix=GFX7 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 < %s | FileCheck -check-prefix=GFX9 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1200 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX12,GFX12-TRUE16 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1200 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX12,GFX12-FAKE16 %s

; Test if fcmp+select patterns form min/max instructions when allowed
; by flags.

; TODO: Merge with fmin_legacy.ll/fmax_legacy.ll

define float @v_test_fmin_legacy_ule_f32_safe(float %a, float %b) {
; GFX7-LABEL: v_test_fmin_legacy_ule_f32_safe:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_min_legacy_f32_e32 v0, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmin_legacy_ule_f32_safe:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ngt_f32_e32 vcc, v0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_test_fmin_legacy_ule_f32_safe:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_cmp_ngt_f32_e32 vcc_lo, v0, v1
; GFX12-NEXT:    s_wait_alu 0xfffd
; GFX12-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc_lo
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp ule float %a, %b
  %val = select i1 %cmp, float %a, float %b
  ret float %val
}

define float @v_test_fmin_legacy_ule_f32_nnan_flag(float %a, float %b) {
; GFX7-LABEL: v_test_fmin_legacy_ule_f32_nnan_flag:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_min_legacy_f32_e32 v0, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmin_legacy_ule_f32_nnan_flag:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ngt_f32_e32 vcc, v0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_test_fmin_legacy_ule_f32_nnan_flag:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_cmp_ngt_f32_e32 vcc_lo, v0, v1
; GFX12-NEXT:    s_wait_alu 0xfffd
; GFX12-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc_lo
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp ule float %a, %b
  %val = select nnan i1 %cmp, float %a, float %b
  ret float %val
}

define float @v_test_fmin_legacy_ule_f32_nsz_flag(float %a, float %b) {
; GFX7-LABEL: v_test_fmin_legacy_ule_f32_nsz_flag:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_min_legacy_f32_e32 v0, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmin_legacy_ule_f32_nsz_flag:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ngt_f32_e32 vcc, v0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_test_fmin_legacy_ule_f32_nsz_flag:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_cmp_ngt_f32_e32 vcc_lo, v0, v1
; GFX12-NEXT:    s_wait_alu 0xfffd
; GFX12-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc_lo
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp ule float %a, %b
  %val = select nsz i1 %cmp, float %a, float %b
  ret float %val
}

define float @v_test_fmin_legacy_ule_f32_nnan_nsz_flag(float %a, float %b) {
; GFX7-LABEL: v_test_fmin_legacy_ule_f32_nnan_nsz_flag:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_min_f32_e32 v0, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmin_legacy_ule_f32_nnan_nsz_flag:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_min_f32_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_test_fmin_legacy_ule_f32_nnan_nsz_flag:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_min_num_f32_e32 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp ule float %a, %b
  %val = select nnan nsz i1 %cmp, float %a, float %b
  ret float %val
}

define float @v_test_fmax_legacy_uge_f32_safe(float %a, float %b) {
; GFX7-LABEL: v_test_fmax_legacy_uge_f32_safe:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_max_legacy_f32_e32 v0, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmax_legacy_uge_f32_safe:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_nlt_f32_e32 vcc, v0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_test_fmax_legacy_uge_f32_safe:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_cmp_nlt_f32_e32 vcc_lo, v0, v1
; GFX12-NEXT:    s_wait_alu 0xfffd
; GFX12-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc_lo
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp uge float %a, %b
  %val = select i1 %cmp, float %a, float %b
  ret float %val
}

define float @v_test_fmax_legacy_uge_f32_nnan_flag(float %a, float %b) {
; GFX7-LABEL: v_test_fmax_legacy_uge_f32_nnan_flag:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_max_legacy_f32_e32 v0, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmax_legacy_uge_f32_nnan_flag:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_nlt_f32_e32 vcc, v0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_test_fmax_legacy_uge_f32_nnan_flag:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_cmp_nlt_f32_e32 vcc_lo, v0, v1
; GFX12-NEXT:    s_wait_alu 0xfffd
; GFX12-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc_lo
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp uge float %a, %b
  %val = select nnan i1 %cmp, float %a, float %b
  ret float %val
}

define float @v_test_fmax_legacy_uge_f32_nsz_flag(float %a, float %b) {
; GFX7-LABEL: v_test_fmax_legacy_uge_f32_nsz_flag:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_max_legacy_f32_e32 v0, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmax_legacy_uge_f32_nsz_flag:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_nlt_f32_e32 vcc, v0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_test_fmax_legacy_uge_f32_nsz_flag:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_cmp_nlt_f32_e32 vcc_lo, v0, v1
; GFX12-NEXT:    s_wait_alu 0xfffd
; GFX12-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc_lo
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp uge float %a, %b
  %val = select nsz i1 %cmp, float %a, float %b
  ret float %val
}

define float @v_test_fmax_legacy_uge_f32_nnan_nsz_flag(float %a, float %b) {
; GFX7-LABEL: v_test_fmax_legacy_uge_f32_nnan_nsz_flag:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmax_legacy_uge_f32_nnan_nsz_flag:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_test_fmax_legacy_uge_f32_nnan_nsz_flag:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f32_e32 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp uge float %a, %b
  %val = select nnan nsz i1 %cmp, float %a, float %b
  ret float %val
}

define <2 x float> @v_test_fmin_legacy_ule_v2f32_safe(<2 x float> %a, <2 x float> %b) {
; GFX7-LABEL: v_test_fmin_legacy_ule_v2f32_safe:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_min_legacy_f32_e32 v0, v2, v0
; GFX7-NEXT:    v_min_legacy_f32_e32 v1, v3, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmin_legacy_ule_v2f32_safe:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ngt_f32_e32 vcc, v0, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX9-NEXT:    v_cmp_ngt_f32_e32 vcc, v1, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_test_fmin_legacy_ule_v2f32_safe:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_cmp_ngt_f32_e32 vcc_lo, v0, v2
; GFX12-NEXT:    s_wait_alu 0xfffd
; GFX12-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX12-NEXT:    v_cmp_ngt_f32_e32 vcc_lo, v1, v3
; GFX12-NEXT:    s_wait_alu 0xfffd
; GFX12-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp ule <2 x float> %a, %b
  %val = select <2 x i1> %cmp, <2 x float> %a, <2 x float> %b
  ret <2 x float> %val
}

define <2 x float> @v_test_fmin_legacy_ule_v2f32_nnan_flag(<2 x float> %a, <2 x float> %b) {
; GFX7-LABEL: v_test_fmin_legacy_ule_v2f32_nnan_flag:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_min_legacy_f32_e32 v0, v2, v0
; GFX7-NEXT:    v_min_legacy_f32_e32 v1, v3, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmin_legacy_ule_v2f32_nnan_flag:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ngt_f32_e32 vcc, v0, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX9-NEXT:    v_cmp_ngt_f32_e32 vcc, v1, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_test_fmin_legacy_ule_v2f32_nnan_flag:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_cmp_ngt_f32_e32 vcc_lo, v0, v2
; GFX12-NEXT:    s_wait_alu 0xfffd
; GFX12-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX12-NEXT:    v_cmp_ngt_f32_e32 vcc_lo, v1, v3
; GFX12-NEXT:    s_wait_alu 0xfffd
; GFX12-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp ule <2 x float> %a, %b
  %val = select nnan <2 x i1> %cmp, <2 x float> %a, <2 x float> %b
  ret <2 x float> %val
}

define <2 x float> @v_test_fmin_legacy_ule_v2f32_nsz_flag(<2 x float> %a, <2 x float> %b) {
; GFX7-LABEL: v_test_fmin_legacy_ule_v2f32_nsz_flag:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_min_legacy_f32_e32 v0, v2, v0
; GFX7-NEXT:    v_min_legacy_f32_e32 v1, v3, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmin_legacy_ule_v2f32_nsz_flag:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ngt_f32_e32 vcc, v0, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX9-NEXT:    v_cmp_ngt_f32_e32 vcc, v1, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_test_fmin_legacy_ule_v2f32_nsz_flag:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_cmp_ngt_f32_e32 vcc_lo, v0, v2
; GFX12-NEXT:    s_wait_alu 0xfffd
; GFX12-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX12-NEXT:    v_cmp_ngt_f32_e32 vcc_lo, v1, v3
; GFX12-NEXT:    s_wait_alu 0xfffd
; GFX12-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp ule <2 x float> %a, %b
  %val = select nsz <2 x i1> %cmp, <2 x float> %a, <2 x float> %b
  ret <2 x float> %val
}

define <2 x float> @v_test_fmin_legacy_ule_v2f32_nnan_nsz_flag(<2 x float> %a, <2 x float> %b) {
; GFX7-LABEL: v_test_fmin_legacy_ule_v2f32_nnan_nsz_flag:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_min_f32_e32 v0, v0, v2
; GFX7-NEXT:    v_min_f32_e32 v1, v1, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmin_legacy_ule_v2f32_nnan_nsz_flag:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_min_f32_e32 v0, v0, v2
; GFX9-NEXT:    v_min_f32_e32 v1, v1, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_test_fmin_legacy_ule_v2f32_nnan_nsz_flag:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_min_num_f32 v0, v0, v2 :: v_dual_min_num_f32 v1, v1, v3
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp ule <2 x float> %a, %b
  %val = select nnan nsz <2 x i1> %cmp, <2 x float> %a, <2 x float> %b
  ret <2 x float> %val
}

define <2 x float> @v_test_fmax_legacy_uge_v2f32_safe(<2 x float> %a, <2 x float> %b) {
; GFX7-LABEL: v_test_fmax_legacy_uge_v2f32_safe:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_max_legacy_f32_e32 v0, v2, v0
; GFX7-NEXT:    v_max_legacy_f32_e32 v1, v3, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmax_legacy_uge_v2f32_safe:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_nlt_f32_e32 vcc, v0, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX9-NEXT:    v_cmp_nlt_f32_e32 vcc, v1, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_test_fmax_legacy_uge_v2f32_safe:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_cmp_nlt_f32_e32 vcc_lo, v0, v2
; GFX12-NEXT:    s_wait_alu 0xfffd
; GFX12-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX12-NEXT:    v_cmp_nlt_f32_e32 vcc_lo, v1, v3
; GFX12-NEXT:    s_wait_alu 0xfffd
; GFX12-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp uge <2 x float> %a, %b
  %val = select <2 x i1> %cmp, <2 x float> %a, <2 x float> %b
  ret <2 x float> %val
}

define <2 x float> @v_test_fmax_legacy_uge_v2f32_nnan_flag(<2 x float> %a, <2 x float> %b) {
; GFX7-LABEL: v_test_fmax_legacy_uge_v2f32_nnan_flag:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_max_legacy_f32_e32 v0, v2, v0
; GFX7-NEXT:    v_max_legacy_f32_e32 v1, v3, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmax_legacy_uge_v2f32_nnan_flag:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_nlt_f32_e32 vcc, v0, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX9-NEXT:    v_cmp_nlt_f32_e32 vcc, v1, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_test_fmax_legacy_uge_v2f32_nnan_flag:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_cmp_nlt_f32_e32 vcc_lo, v0, v2
; GFX12-NEXT:    s_wait_alu 0xfffd
; GFX12-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX12-NEXT:    v_cmp_nlt_f32_e32 vcc_lo, v1, v3
; GFX12-NEXT:    s_wait_alu 0xfffd
; GFX12-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp uge <2 x float> %a, %b
  %val = select nnan <2 x i1> %cmp, <2 x float> %a, <2 x float> %b
  ret <2 x float> %val
}

define <2 x float> @v_test_fmax_legacy_uge_v2f32_nsz_flag(<2 x float> %a, <2 x float> %b) {
; GFX7-LABEL: v_test_fmax_legacy_uge_v2f32_nsz_flag:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_max_legacy_f32_e32 v0, v2, v0
; GFX7-NEXT:    v_max_legacy_f32_e32 v1, v3, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmax_legacy_uge_v2f32_nsz_flag:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_nlt_f32_e32 vcc, v0, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX9-NEXT:    v_cmp_nlt_f32_e32 vcc, v1, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_test_fmax_legacy_uge_v2f32_nsz_flag:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_cmp_nlt_f32_e32 vcc_lo, v0, v2
; GFX12-NEXT:    s_wait_alu 0xfffd
; GFX12-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX12-NEXT:    v_cmp_nlt_f32_e32 vcc_lo, v1, v3
; GFX12-NEXT:    s_wait_alu 0xfffd
; GFX12-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp uge <2 x float> %a, %b
  %val = select nsz <2 x i1> %cmp, <2 x float> %a, <2 x float> %b
  ret <2 x float> %val
}

define <2 x float> @v_test_fmax_legacy_uge_v2f32_nnan_nsz_flag(<2 x float> %a, <2 x float> %b) {
; GFX7-LABEL: v_test_fmax_legacy_uge_v2f32_nnan_nsz_flag:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v2
; GFX7-NEXT:    v_max_f32_e32 v1, v1, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmax_legacy_uge_v2f32_nnan_nsz_flag:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v2
; GFX9-NEXT:    v_max_f32_e32 v1, v1, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_test_fmax_legacy_uge_v2f32_nnan_nsz_flag:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_max_num_f32 v0, v0, v2 :: v_dual_max_num_f32 v1, v1, v3
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp uge <2 x float> %a, %b
  %val = select nnan nsz <2 x i1> %cmp, <2 x float> %a, <2 x float> %b
  ret <2 x float> %val
}

define half @v_test_fmin_legacy_ule_f16_safe(half %a, half %b) {
; GFX7-LABEL: v_test_fmin_legacy_ule_f16_safe:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_min_legacy_f32_e32 v0, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmin_legacy_ule_f16_safe:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ngt_f16_e32 vcc, v0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_test_fmin_legacy_ule_f16_safe:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_cmp_ngt_f16_e32 vcc_lo, v0.l, v1.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v1.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_test_fmin_legacy_ule_f16_safe:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_cmp_ngt_f16_e32 vcc_lo, v0, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc_lo
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp ule half %a, %b
  %val = select i1 %cmp, half %a, half %b
  ret half %val
}

define half @v_test_fmin_legacy_ule_f16_nnan_flag(half %a, half %b) {
; GFX7-LABEL: v_test_fmin_legacy_ule_f16_nnan_flag:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_min_legacy_f32_e32 v0, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmin_legacy_ule_f16_nnan_flag:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ngt_f16_e32 vcc, v0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_test_fmin_legacy_ule_f16_nnan_flag:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_cmp_ngt_f16_e32 vcc_lo, v0.l, v1.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v1.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_test_fmin_legacy_ule_f16_nnan_flag:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_cmp_ngt_f16_e32 vcc_lo, v0, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc_lo
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp ule half %a, %b
  %val = select nnan i1 %cmp, half %a, half %b
  ret half %val
}

define half @v_test_fmin_legacy_ule_f16_nsz_flag(half %a, half %b) {
; GFX7-LABEL: v_test_fmin_legacy_ule_f16_nsz_flag:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_min_legacy_f32_e32 v0, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmin_legacy_ule_f16_nsz_flag:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ngt_f16_e32 vcc, v0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_test_fmin_legacy_ule_f16_nsz_flag:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_cmp_ngt_f16_e32 vcc_lo, v0.l, v1.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v1.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_test_fmin_legacy_ule_f16_nsz_flag:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_cmp_ngt_f16_e32 vcc_lo, v0, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc_lo
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp ule half %a, %b
  %val = select nsz i1 %cmp, half %a, half %b
  ret half %val
}

define half @v_test_fmin_legacy_ule_f16_nnan_nsz_flag(half %a, half %b) {
; GFX7-LABEL: v_test_fmin_legacy_ule_f16_nnan_nsz_flag:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_min_f32_e32 v0, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmin_legacy_ule_f16_nnan_nsz_flag:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_min_f16_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_test_fmin_legacy_ule_f16_nnan_nsz_flag:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_min_num_f16_e32 v0.l, v0.l, v1.l
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_test_fmin_legacy_ule_f16_nnan_nsz_flag:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_min_num_f16_e32 v0, v0, v1
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp ule half %a, %b
  %val = select nnan nsz i1 %cmp, half %a, half %b
  ret half %val
}

define half @v_test_fmax_legacy_uge_f16_safe(half %a, half %b) {
; GFX7-LABEL: v_test_fmax_legacy_uge_f16_safe:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_max_legacy_f32_e32 v0, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmax_legacy_uge_f16_safe:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_nlt_f16_e32 vcc, v0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_test_fmax_legacy_uge_f16_safe:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, v0.l, v1.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v1.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_test_fmax_legacy_uge_f16_safe:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, v0, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc_lo
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp uge half %a, %b
  %val = select i1 %cmp, half %a, half %b
  ret half %val
}

define half @v_test_fmax_legacy_uge_f16_nnan_flag(half %a, half %b) {
; GFX7-LABEL: v_test_fmax_legacy_uge_f16_nnan_flag:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_max_legacy_f32_e32 v0, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmax_legacy_uge_f16_nnan_flag:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_nlt_f16_e32 vcc, v0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_test_fmax_legacy_uge_f16_nnan_flag:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, v0.l, v1.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v1.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_test_fmax_legacy_uge_f16_nnan_flag:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, v0, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc_lo
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp uge half %a, %b
  %val = select nnan i1 %cmp, half %a, half %b
  ret half %val
}

define half @v_test_fmax_legacy_uge_f16_nsz_flag(half %a, half %b) {
; GFX7-LABEL: v_test_fmax_legacy_uge_f16_nsz_flag:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_max_legacy_f32_e32 v0, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmax_legacy_uge_f16_nsz_flag:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_nlt_f16_e32 vcc, v0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_test_fmax_legacy_uge_f16_nsz_flag:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, v0.l, v1.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v1.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_test_fmax_legacy_uge_f16_nsz_flag:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, v0, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc_lo
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp uge half %a, %b
  %val = select nsz i1 %cmp, half %a, half %b
  ret half %val
}

define half @v_test_fmax_legacy_uge_f16_nnan_nsz_flag(half %a, half %b) {
; GFX7-LABEL: v_test_fmax_legacy_uge_f16_nnan_nsz_flag:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmax_legacy_uge_f16_nnan_nsz_flag:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_test_fmax_legacy_uge_f16_nnan_nsz_flag:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_max_num_f16_e32 v0.l, v0.l, v1.l
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_test_fmax_legacy_uge_f16_nnan_nsz_flag:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_max_num_f16_e32 v0, v0, v1
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp uge half %a, %b
  %val = select nnan nsz i1 %cmp, half %a, half %b
  ret half %val
}

define <2 x half> @v_test_fmin_legacy_ule_v2f16_safe(<2 x half> %a, <2 x half> %b) {
; GFX7-LABEL: v_test_fmin_legacy_ule_v2f16_safe:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_min_legacy_f32_e32 v0, v2, v0
; GFX7-NEXT:    v_min_legacy_f32_e32 v1, v3, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmin_legacy_ule_v2f16_safe:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX9-NEXT:    v_cmp_ngt_f16_e32 vcc, v3, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GFX9-NEXT:    v_cmp_ngt_f16_e32 vcc, v0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v2, v0, s4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_test_fmin_legacy_ule_v2f16_safe:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_cmp_ngt_f16_e32 vcc_lo, v0.h, v1.h
; GFX12-TRUE16-NEXT:    v_cmp_ngt_f16_e64 s0, v0.l, v1.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v1.h, v0.h, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v1.l, v0.l, s0
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_test_fmin_legacy_ule_v2f16_safe:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_ngt_f16_e32 vcc_lo, v3, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_ngt_f16_e32 vcc_lo, v0, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_perm_b32 v0, v2, v0, 0x5040100
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp ule <2 x half> %a, %b
  %val = select <2 x i1> %cmp, <2 x half> %a, <2 x half> %b
  ret <2 x half> %val
}

define <2 x half> @v_test_fmin_legacy_ule_v2f16_nnan_flag(<2 x half> %a, <2 x half> %b) {
; GFX7-LABEL: v_test_fmin_legacy_ule_v2f16_nnan_flag:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_min_legacy_f32_e32 v0, v2, v0
; GFX7-NEXT:    v_min_legacy_f32_e32 v1, v3, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmin_legacy_ule_v2f16_nnan_flag:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX9-NEXT:    v_cmp_ngt_f16_e32 vcc, v3, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GFX9-NEXT:    v_cmp_ngt_f16_e32 vcc, v0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v2, v0, s4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_test_fmin_legacy_ule_v2f16_nnan_flag:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_cmp_ngt_f16_e32 vcc_lo, v0.h, v1.h
; GFX12-TRUE16-NEXT:    v_cmp_ngt_f16_e64 s0, v0.l, v1.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v1.h, v0.h, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v1.l, v0.l, s0
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_test_fmin_legacy_ule_v2f16_nnan_flag:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_ngt_f16_e32 vcc_lo, v3, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_ngt_f16_e32 vcc_lo, v0, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_perm_b32 v0, v2, v0, 0x5040100
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp ule <2 x half> %a, %b
  %val = select nnan <2 x i1> %cmp, <2 x half> %a, <2 x half> %b
  ret <2 x half> %val
}

define <2 x half> @v_test_fmin_legacy_ule_v2f16_nsz_flag(<2 x half> %a, <2 x half> %b) {
; GFX7-LABEL: v_test_fmin_legacy_ule_v2f16_nsz_flag:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_min_legacy_f32_e32 v0, v2, v0
; GFX7-NEXT:    v_min_legacy_f32_e32 v1, v3, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmin_legacy_ule_v2f16_nsz_flag:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX9-NEXT:    v_cmp_ngt_f16_e32 vcc, v3, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GFX9-NEXT:    v_cmp_ngt_f16_e32 vcc, v0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v2, v0, s4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_test_fmin_legacy_ule_v2f16_nsz_flag:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_cmp_ngt_f16_e32 vcc_lo, v0.h, v1.h
; GFX12-TRUE16-NEXT:    v_cmp_ngt_f16_e64 s0, v0.l, v1.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v1.h, v0.h, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v1.l, v0.l, s0
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_test_fmin_legacy_ule_v2f16_nsz_flag:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_ngt_f16_e32 vcc_lo, v3, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_ngt_f16_e32 vcc_lo, v0, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_perm_b32 v0, v2, v0, 0x5040100
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp ule <2 x half> %a, %b
  %val = select nsz <2 x i1> %cmp, <2 x half> %a, <2 x half> %b
  ret <2 x half> %val
}

define <2 x half> @v_test_fmin_legacy_ule_v2f16_nnan_nsz_flag(<2 x half> %a, <2 x half> %b) {
; GFX7-LABEL: v_test_fmin_legacy_ule_v2f16_nnan_nsz_flag:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_min_f32_e32 v0, v0, v2
; GFX7-NEXT:    v_min_f32_e32 v1, v1, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmin_legacy_ule_v2f16_nnan_nsz_flag:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_min_f16 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_test_fmin_legacy_ule_v2f16_nnan_nsz_flag:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_pk_min_num_f16 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp ule <2 x half> %a, %b
  %val = select nnan nsz <2 x i1> %cmp, <2 x half> %a, <2 x half> %b
  ret <2 x half> %val
}

define <2 x half> @v_test_fmax_legacy_uge_v2f16_safe(<2 x half> %a, <2 x half> %b) {
; GFX7-LABEL: v_test_fmax_legacy_uge_v2f16_safe:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_max_legacy_f32_e32 v0, v2, v0
; GFX7-NEXT:    v_max_legacy_f32_e32 v1, v3, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmax_legacy_uge_v2f16_safe:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX9-NEXT:    v_cmp_nlt_f16_e32 vcc, v3, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GFX9-NEXT:    v_cmp_nlt_f16_e32 vcc, v0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v2, v0, s4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_test_fmax_legacy_uge_v2f16_safe:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, v0.h, v1.h
; GFX12-TRUE16-NEXT:    v_cmp_nlt_f16_e64 s0, v0.l, v1.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v1.h, v0.h, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v1.l, v0.l, s0
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_test_fmax_legacy_uge_v2f16_safe:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, v3, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, v0, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_perm_b32 v0, v2, v0, 0x5040100
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp uge <2 x half> %a, %b
  %val = select <2 x i1> %cmp, <2 x half> %a, <2 x half> %b
  ret <2 x half> %val
}

define <2 x half> @v_test_fmax_legacy_uge_v2f16_nnan_flag(<2 x half> %a, <2 x half> %b) {
; GFX7-LABEL: v_test_fmax_legacy_uge_v2f16_nnan_flag:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_max_legacy_f32_e32 v0, v2, v0
; GFX7-NEXT:    v_max_legacy_f32_e32 v1, v3, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmax_legacy_uge_v2f16_nnan_flag:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX9-NEXT:    v_cmp_nlt_f16_e32 vcc, v3, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GFX9-NEXT:    v_cmp_nlt_f16_e32 vcc, v0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v2, v0, s4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_test_fmax_legacy_uge_v2f16_nnan_flag:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, v0.h, v1.h
; GFX12-TRUE16-NEXT:    v_cmp_nlt_f16_e64 s0, v0.l, v1.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v1.h, v0.h, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v1.l, v0.l, s0
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_test_fmax_legacy_uge_v2f16_nnan_flag:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, v3, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, v0, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_perm_b32 v0, v2, v0, 0x5040100
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp uge <2 x half> %a, %b
  %val = select nnan <2 x i1> %cmp, <2 x half> %a, <2 x half> %b
  ret <2 x half> %val
}

define <2 x half> @v_test_fmax_legacy_uge_v2f16_nsz_flag(<2 x half> %a, <2 x half> %b) {
; GFX7-LABEL: v_test_fmax_legacy_uge_v2f16_nsz_flag:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_max_legacy_f32_e32 v0, v2, v0
; GFX7-NEXT:    v_max_legacy_f32_e32 v1, v3, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmax_legacy_uge_v2f16_nsz_flag:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX9-NEXT:    v_cmp_nlt_f16_e32 vcc, v3, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GFX9-NEXT:    v_cmp_nlt_f16_e32 vcc, v0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v2, v0, s4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_test_fmax_legacy_uge_v2f16_nsz_flag:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, v0.h, v1.h
; GFX12-TRUE16-NEXT:    v_cmp_nlt_f16_e64 s0, v0.l, v1.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v1.h, v0.h, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v1.l, v0.l, s0
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_test_fmax_legacy_uge_v2f16_nsz_flag:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, v3, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, v0, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_perm_b32 v0, v2, v0, 0x5040100
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp uge <2 x half> %a, %b
  %val = select nsz <2 x i1> %cmp, <2 x half> %a, <2 x half> %b
  ret <2 x half> %val
}

define <2 x half> @v_test_fmax_legacy_uge_v2f16_nnan_nsz_flag(<2 x half> %a, <2 x half> %b) {
; GFX7-LABEL: v_test_fmax_legacy_uge_v2f16_nnan_nsz_flag:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v2
; GFX7-NEXT:    v_max_f32_e32 v1, v1, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmax_legacy_uge_v2f16_nnan_nsz_flag:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_max_f16 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_test_fmax_legacy_uge_v2f16_nnan_nsz_flag:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_pk_max_num_f16 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp uge <2 x half> %a, %b
  %val = select nnan nsz <2 x i1> %cmp, <2 x half> %a, <2 x half> %b
  ret <2 x half> %val
}

define <4 x half> @v_test_fmin_legacy_ule_v4f16_safe(<4 x half> %a, <4 x half> %b) {
; GFX7-LABEL: v_test_fmin_legacy_ule_v4f16_safe:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v7
; GFX7-NEXT:    v_min_legacy_f32_e32 v0, v4, v0
; GFX7-NEXT:    v_min_legacy_f32_e32 v1, v5, v1
; GFX7-NEXT:    v_min_legacy_f32_e32 v2, v6, v2
; GFX7-NEXT:    v_min_legacy_f32_e32 v3, v7, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmin_legacy_ule_v4f16_safe:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; GFX9-NEXT:    v_cmp_ngt_f16_e32 vcc, v7, v6
; GFX9-NEXT:    v_cndmask_b32_e32 v6, v6, v7, vcc
; GFX9-NEXT:    v_cmp_ngt_f16_e32 vcc, v5, v4
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; GFX9-NEXT:    v_cmp_ngt_f16_e32 vcc, v1, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX9-NEXT:    v_cmp_ngt_f16_e32 vcc, v0, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v4, v0, s4
; GFX9-NEXT:    v_perm_b32 v1, v6, v1, s4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_test_fmin_legacy_ule_v4f16_safe:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_cmp_ngt_f16_e32 vcc_lo, v1.h, v3.h
; GFX12-TRUE16-NEXT:    v_cmp_ngt_f16_e64 s0, v0.h, v2.h
; GFX12-TRUE16-NEXT:    v_cmp_ngt_f16_e64 s1, v0.l, v2.l
; GFX12-TRUE16-NEXT:    v_cmp_ngt_f16_e64 s2, v1.l, v3.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.h, v3.h, v1.h, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v2.h, v0.h, s0
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v2.l, v0.l, s1
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v3.l, v1.l, s2
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_test_fmin_legacy_ule_v4f16_safe:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v4, 16, v3
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 16, v1
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 16, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_ngt_f16_e32 vcc_lo, v5, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_ngt_f16_e32 vcc_lo, v7, v6
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v6, v7, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_ngt_f16_e32 vcc_lo, v0, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_ngt_f16_e32 vcc_lo, v1, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_perm_b32 v0, v5, v0, 0x5040100
; GFX12-FAKE16-NEXT:    v_perm_b32 v1, v4, v1, 0x5040100
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp ule <4 x half> %a, %b
  %val = select <4 x i1> %cmp, <4 x half> %a, <4 x half> %b
  ret <4 x half> %val
}

define <4 x half> @v_test_fmin_legacy_ule_v4f16_nnan_flag(<4 x half> %a, <4 x half> %b) {
; GFX7-LABEL: v_test_fmin_legacy_ule_v4f16_nnan_flag:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v7
; GFX7-NEXT:    v_min_legacy_f32_e32 v0, v4, v0
; GFX7-NEXT:    v_min_legacy_f32_e32 v1, v5, v1
; GFX7-NEXT:    v_min_legacy_f32_e32 v2, v6, v2
; GFX7-NEXT:    v_min_legacy_f32_e32 v3, v7, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmin_legacy_ule_v4f16_nnan_flag:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; GFX9-NEXT:    v_cmp_ngt_f16_e32 vcc, v7, v6
; GFX9-NEXT:    v_cndmask_b32_e32 v6, v6, v7, vcc
; GFX9-NEXT:    v_cmp_ngt_f16_e32 vcc, v5, v4
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; GFX9-NEXT:    v_cmp_ngt_f16_e32 vcc, v1, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX9-NEXT:    v_cmp_ngt_f16_e32 vcc, v0, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v4, v0, s4
; GFX9-NEXT:    v_perm_b32 v1, v6, v1, s4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_test_fmin_legacy_ule_v4f16_nnan_flag:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_cmp_ngt_f16_e32 vcc_lo, v1.h, v3.h
; GFX12-TRUE16-NEXT:    v_cmp_ngt_f16_e64 s0, v0.h, v2.h
; GFX12-TRUE16-NEXT:    v_cmp_ngt_f16_e64 s1, v0.l, v2.l
; GFX12-TRUE16-NEXT:    v_cmp_ngt_f16_e64 s2, v1.l, v3.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.h, v3.h, v1.h, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v2.h, v0.h, s0
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v2.l, v0.l, s1
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v3.l, v1.l, s2
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_test_fmin_legacy_ule_v4f16_nnan_flag:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v4, 16, v3
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 16, v1
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 16, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_ngt_f16_e32 vcc_lo, v5, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_ngt_f16_e32 vcc_lo, v7, v6
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v6, v7, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_ngt_f16_e32 vcc_lo, v0, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_ngt_f16_e32 vcc_lo, v1, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_perm_b32 v0, v5, v0, 0x5040100
; GFX12-FAKE16-NEXT:    v_perm_b32 v1, v4, v1, 0x5040100
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp ule <4 x half> %a, %b
  %val = select nnan <4 x i1> %cmp, <4 x half> %a, <4 x half> %b
  ret <4 x half> %val
}

define <4 x half> @v_test_fmin_legacy_ule_v4f16_nsz_flag(<4 x half> %a, <4 x half> %b) {
; GFX7-LABEL: v_test_fmin_legacy_ule_v4f16_nsz_flag:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v7
; GFX7-NEXT:    v_min_legacy_f32_e32 v0, v4, v0
; GFX7-NEXT:    v_min_legacy_f32_e32 v1, v5, v1
; GFX7-NEXT:    v_min_legacy_f32_e32 v2, v6, v2
; GFX7-NEXT:    v_min_legacy_f32_e32 v3, v7, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmin_legacy_ule_v4f16_nsz_flag:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; GFX9-NEXT:    v_cmp_ngt_f16_e32 vcc, v7, v6
; GFX9-NEXT:    v_cndmask_b32_e32 v6, v6, v7, vcc
; GFX9-NEXT:    v_cmp_ngt_f16_e32 vcc, v5, v4
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; GFX9-NEXT:    v_cmp_ngt_f16_e32 vcc, v1, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX9-NEXT:    v_cmp_ngt_f16_e32 vcc, v0, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v4, v0, s4
; GFX9-NEXT:    v_perm_b32 v1, v6, v1, s4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_test_fmin_legacy_ule_v4f16_nsz_flag:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_cmp_ngt_f16_e32 vcc_lo, v1.h, v3.h
; GFX12-TRUE16-NEXT:    v_cmp_ngt_f16_e64 s0, v0.h, v2.h
; GFX12-TRUE16-NEXT:    v_cmp_ngt_f16_e64 s1, v0.l, v2.l
; GFX12-TRUE16-NEXT:    v_cmp_ngt_f16_e64 s2, v1.l, v3.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.h, v3.h, v1.h, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v2.h, v0.h, s0
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v2.l, v0.l, s1
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v3.l, v1.l, s2
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_test_fmin_legacy_ule_v4f16_nsz_flag:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v4, 16, v3
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 16, v1
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 16, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_ngt_f16_e32 vcc_lo, v5, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_ngt_f16_e32 vcc_lo, v7, v6
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v6, v7, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_ngt_f16_e32 vcc_lo, v0, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_ngt_f16_e32 vcc_lo, v1, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_perm_b32 v0, v5, v0, 0x5040100
; GFX12-FAKE16-NEXT:    v_perm_b32 v1, v4, v1, 0x5040100
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp ule <4 x half> %a, %b
  %val = select nsz <4 x i1> %cmp, <4 x half> %a, <4 x half> %b
  ret <4 x half> %val
}

define <4 x half> @v_test_fmin_legacy_ule_v4f16_nnan_nsz_flag(<4 x half> %a, <4 x half> %b) {
; GFX7-LABEL: v_test_fmin_legacy_ule_v4f16_nnan_nsz_flag:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_min_f32_e32 v0, v0, v4
; GFX7-NEXT:    v_min_f32_e32 v1, v1, v5
; GFX7-NEXT:    v_min_f32_e32 v2, v2, v6
; GFX7-NEXT:    v_min_f32_e32 v3, v3, v7
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmin_legacy_ule_v4f16_nnan_nsz_flag:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_min_f16 v0, v0, v2
; GFX9-NEXT:    v_pk_min_f16 v1, v1, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_test_fmin_legacy_ule_v4f16_nnan_nsz_flag:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_pk_min_num_f16 v0, v0, v2
; GFX12-NEXT:    v_pk_min_num_f16 v1, v1, v3
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp ule <4 x half> %a, %b
  %val = select nnan nsz <4 x i1> %cmp, <4 x half> %a, <4 x half> %b
  ret <4 x half> %val
}

define <4 x half> @v_test_fmax_legacy_uge_v4f16_safe(<4 x half> %a, <4 x half> %b) {
; GFX7-LABEL: v_test_fmax_legacy_uge_v4f16_safe:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v7
; GFX7-NEXT:    v_max_legacy_f32_e32 v0, v4, v0
; GFX7-NEXT:    v_max_legacy_f32_e32 v1, v5, v1
; GFX7-NEXT:    v_max_legacy_f32_e32 v2, v6, v2
; GFX7-NEXT:    v_max_legacy_f32_e32 v3, v7, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmax_legacy_uge_v4f16_safe:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; GFX9-NEXT:    v_cmp_nlt_f16_e32 vcc, v7, v6
; GFX9-NEXT:    v_cndmask_b32_e32 v6, v6, v7, vcc
; GFX9-NEXT:    v_cmp_nlt_f16_e32 vcc, v5, v4
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; GFX9-NEXT:    v_cmp_nlt_f16_e32 vcc, v1, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX9-NEXT:    v_cmp_nlt_f16_e32 vcc, v0, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v4, v0, s4
; GFX9-NEXT:    v_perm_b32 v1, v6, v1, s4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_test_fmax_legacy_uge_v4f16_safe:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, v1.h, v3.h
; GFX12-TRUE16-NEXT:    v_cmp_nlt_f16_e64 s0, v0.h, v2.h
; GFX12-TRUE16-NEXT:    v_cmp_nlt_f16_e64 s1, v0.l, v2.l
; GFX12-TRUE16-NEXT:    v_cmp_nlt_f16_e64 s2, v1.l, v3.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.h, v3.h, v1.h, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v2.h, v0.h, s0
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v2.l, v0.l, s1
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v3.l, v1.l, s2
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_test_fmax_legacy_uge_v4f16_safe:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v4, 16, v3
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 16, v1
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 16, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, v5, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, v7, v6
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v6, v7, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, v0, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, v1, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_perm_b32 v0, v5, v0, 0x5040100
; GFX12-FAKE16-NEXT:    v_perm_b32 v1, v4, v1, 0x5040100
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp uge <4 x half> %a, %b
  %val = select <4 x i1> %cmp, <4 x half> %a, <4 x half> %b
  ret <4 x half> %val
}

define <4 x half> @v_test_fmax_legacy_uge_v4f16_nnan_flag(<4 x half> %a, <4 x half> %b) {
; GFX7-LABEL: v_test_fmax_legacy_uge_v4f16_nnan_flag:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v7
; GFX7-NEXT:    v_max_legacy_f32_e32 v0, v4, v0
; GFX7-NEXT:    v_max_legacy_f32_e32 v1, v5, v1
; GFX7-NEXT:    v_max_legacy_f32_e32 v2, v6, v2
; GFX7-NEXT:    v_max_legacy_f32_e32 v3, v7, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmax_legacy_uge_v4f16_nnan_flag:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; GFX9-NEXT:    v_cmp_nlt_f16_e32 vcc, v7, v6
; GFX9-NEXT:    v_cndmask_b32_e32 v6, v6, v7, vcc
; GFX9-NEXT:    v_cmp_nlt_f16_e32 vcc, v5, v4
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; GFX9-NEXT:    v_cmp_nlt_f16_e32 vcc, v1, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX9-NEXT:    v_cmp_nlt_f16_e32 vcc, v0, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v4, v0, s4
; GFX9-NEXT:    v_perm_b32 v1, v6, v1, s4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_test_fmax_legacy_uge_v4f16_nnan_flag:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, v1.h, v3.h
; GFX12-TRUE16-NEXT:    v_cmp_nlt_f16_e64 s0, v0.h, v2.h
; GFX12-TRUE16-NEXT:    v_cmp_nlt_f16_e64 s1, v0.l, v2.l
; GFX12-TRUE16-NEXT:    v_cmp_nlt_f16_e64 s2, v1.l, v3.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.h, v3.h, v1.h, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v2.h, v0.h, s0
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v2.l, v0.l, s1
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v3.l, v1.l, s2
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_test_fmax_legacy_uge_v4f16_nnan_flag:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v4, 16, v3
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 16, v1
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 16, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, v5, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, v7, v6
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v6, v7, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, v0, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, v1, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_perm_b32 v0, v5, v0, 0x5040100
; GFX12-FAKE16-NEXT:    v_perm_b32 v1, v4, v1, 0x5040100
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp uge <4 x half> %a, %b
  %val = select nnan <4 x i1> %cmp, <4 x half> %a, <4 x half> %b
  ret <4 x half> %val
}

define <4 x half> @v_test_fmax_legacy_uge_v4f16_nsz_flag(<4 x half> %a, <4 x half> %b) {
; GFX7-LABEL: v_test_fmax_legacy_uge_v4f16_nsz_flag:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v7
; GFX7-NEXT:    v_max_legacy_f32_e32 v0, v4, v0
; GFX7-NEXT:    v_max_legacy_f32_e32 v1, v5, v1
; GFX7-NEXT:    v_max_legacy_f32_e32 v2, v6, v2
; GFX7-NEXT:    v_max_legacy_f32_e32 v3, v7, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmax_legacy_uge_v4f16_nsz_flag:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; GFX9-NEXT:    v_cmp_nlt_f16_e32 vcc, v7, v6
; GFX9-NEXT:    v_cndmask_b32_e32 v6, v6, v7, vcc
; GFX9-NEXT:    v_cmp_nlt_f16_e32 vcc, v5, v4
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; GFX9-NEXT:    v_cmp_nlt_f16_e32 vcc, v1, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX9-NEXT:    v_cmp_nlt_f16_e32 vcc, v0, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v4, v0, s4
; GFX9-NEXT:    v_perm_b32 v1, v6, v1, s4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_test_fmax_legacy_uge_v4f16_nsz_flag:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, v1.h, v3.h
; GFX12-TRUE16-NEXT:    v_cmp_nlt_f16_e64 s0, v0.h, v2.h
; GFX12-TRUE16-NEXT:    v_cmp_nlt_f16_e64 s1, v0.l, v2.l
; GFX12-TRUE16-NEXT:    v_cmp_nlt_f16_e64 s2, v1.l, v3.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.h, v3.h, v1.h, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v2.h, v0.h, s0
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v2.l, v0.l, s1
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v3.l, v1.l, s2
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_test_fmax_legacy_uge_v4f16_nsz_flag:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v4, 16, v3
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 16, v1
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 16, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, v5, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, v7, v6
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v6, v7, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, v0, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, v1, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_perm_b32 v0, v5, v0, 0x5040100
; GFX12-FAKE16-NEXT:    v_perm_b32 v1, v4, v1, 0x5040100
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp uge <4 x half> %a, %b
  %val = select nsz <4 x i1> %cmp, <4 x half> %a, <4 x half> %b
  ret <4 x half> %val
}

define <4 x half> @v_test_fmax_legacy_uge_v4f16_nnan_nsz_flag(<4 x half> %a, <4 x half> %b) {
; GFX7-LABEL: v_test_fmax_legacy_uge_v4f16_nnan_nsz_flag:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v4
; GFX7-NEXT:    v_max_f32_e32 v1, v1, v5
; GFX7-NEXT:    v_max_f32_e32 v2, v2, v6
; GFX7-NEXT:    v_max_f32_e32 v3, v3, v7
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmax_legacy_uge_v4f16_nnan_nsz_flag:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX9-NEXT:    v_pk_max_f16 v1, v1, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_test_fmax_legacy_uge_v4f16_nnan_nsz_flag:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_pk_max_num_f16 v0, v0, v2
; GFX12-NEXT:    v_pk_max_num_f16 v1, v1, v3
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %cmp = fcmp uge <4 x half> %a, %b
  %val = select nnan nsz <4 x i1> %cmp, <4 x half> %a, <4 x half> %b
  ret <4 x half> %val
}

define float @v_test_fmin_legacy_uge_f32_nsz_flag__nnan_srcs(float %arg0, float %arg1) {
; GFX7-LABEL: v_test_fmin_legacy_uge_f32_nsz_flag__nnan_srcs:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v0, v0, v0
; GFX7-NEXT:    v_add_f32_e32 v1, v1, v1
; GFX7-NEXT:    v_min_f32_e32 v0, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmin_legacy_uge_f32_nsz_flag__nnan_srcs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_f32_e32 v0, v0, v0
; GFX9-NEXT:    v_add_f32_e32 v1, v1, v1
; GFX9-NEXT:    v_min_f32_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_test_fmin_legacy_uge_f32_nsz_flag__nnan_srcs:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_add_f32 v0, v0, v0 :: v_dual_add_f32 v1, v1, v1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_min_num_f32_e32 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %a = fadd nnan float %arg0, %arg0
  %b = fadd nnan float %arg1, %arg1
  %cmp = fcmp ule float %a, %b
  %val = select nsz i1 %cmp, float %a, float %b
  ret float %val
}

define float @v_test_fmax_legacy_uge_f32_nsz_flag__nnan_srcs(float %arg0, float %arg1) {
; GFX7-LABEL: v_test_fmax_legacy_uge_f32_nsz_flag__nnan_srcs:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v0, v0, v0
; GFX7-NEXT:    v_add_f32_e32 v1, v1, v1
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_test_fmax_legacy_uge_f32_nsz_flag__nnan_srcs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_f32_e32 v0, v0, v0
; GFX9-NEXT:    v_add_f32_e32 v1, v1, v1
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_test_fmax_legacy_uge_f32_nsz_flag__nnan_srcs:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_add_f32 v0, v0, v0 :: v_dual_add_f32 v1, v1, v1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_max_num_f32_e32 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %a = fadd nnan float %arg0, %arg0
  %b = fadd nnan float %arg1, %arg1
  %cmp = fcmp uge float %a, %b
  %val = select nsz i1 %cmp, float %a, float %b
  ret float %val
}
