/* 
 * Unix privileges layer for Cygwin
 * Copyright (C) 2014 Daniel Boland
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/**************** unistd.h *****************/

#include <unistd.h>

uid_t su_getuid(void);
uid_t su_geteuid(void);
gid_t su_getgid(void);
gid_t su_getegid(void);

#define getuid() 			su_getuid()
#define geteuid() 		su_geteuid()
#define getgid() 			su_getgid()
#define getegid() 		su_getegid()

int su_setuid(uid_t uid);
int su_seteuid(uid_t euid);
int su_setgid(gid_t gid);
int su_setegid(gid_t egid);
int su_setreuid(uid_t ruid, uid_t euid);
int su_setregid(gid_t rgid, gid_t egid);

#define setuid(a) 		su_setuid(a)
#define seteuid(a) 		su_seteuid(a)
#define setreuid(a,b) 	su_setreuid(a,b)
#define setgid(a) 		su_setgid(a)
#define setegid(a) 		su_setegid(a)
#define setregid(a,b) 	su_setregid(a,b)

int su_getgroups(int size, gid_t list[]);
int su_setgroups(int size, const gid_t *list);

#define getgroups(a,b)	su_getgroups(a,b)
#define setgroups(a,b)	su_setgroups(a,b)

int su_chown(const char *path, uid_t owner, gid_t group);
int su_fchown(int fd, uid_t owner, gid_t group);
int su_lchown(const char *path, uid_t owner, gid_t group);

#define chown(a,b,c)		su_chown(a,b,c)
#define fchown(a,b,c)	su_fchown(a,b,c)
#define lchown(a,b,c)	su_lchown(a,b,c)

int su_setfsuid(uid_t fsuid);
int su_setfsgid(uid_t fsgid);

#define setfsuid(a)		su_setfsuid(a)
#define setfsgid(a)		su_setfsgid(a)

/***************** pwd.h *********************/

#include <pwd.h>

struct passwd *su_getpwnam(const char *name);
struct passwd *su_getpwuid(uid_t uid);

#define getpwnam(a)		su_getpwnam(a)
#define getpwuid(a)		su_getpwuid(a)

int su_getpwnam_r(const char *name, struct passwd *pwd, char *buf, size_t buflen, struct passwd **result);
int su_getpwuid_r(uid_t uid, struct passwd *pwd, char *buf, size_t buflen, struct passwd **result);

#define getpwnam_r(a,b,c,d,e)		su_getpwnam_r(a,b,c,d,e)
#define getpwuid_r(a,b,c,d,e)		su_getpwuid_r(a,b,c,d,e)

/***************** grp.h *********************/

#include <grp.h>

struct group *su_getgrgid(gid_t gid);
struct group *su_getgrnam(const char *name);

#define getgrgid(a)		su_getgrgid(a)
#define getgrnam(a)		su_getgrnam(a)

int su_getgrnam_r(const char *name, struct group *grp, char *buf, size_t buflen, struct group **result);
int su_getgrgid_r(gid_t gid, struct group *grp, char *buf, size_t buflen, struct group **result);

#define getgrnam_r(a,b,c,d,e)		su_getgrnam_r(a,b,c,d,e)
#define getgrgid_r(a,b,c,d,e)		su_getgrgid_r(a,b,c,d,e)

/*************** sys/stat.h ******************/

#include <sys/stat.h>

int su_stat(const char *path, struct stat *buf);
int su_fstat(int fd, struct stat *buf);
int su_lstat(const char *path, struct stat *buf);

#define stat(a,b) 		su_stat(a,b)
#define fstat(a,b) 		su_fstat(a,b)
#define lstat(a,b) 		su_lstat(a,b)

/*********************************************/

void fakesu(const char *name);

/* Set to 1 for logging the fakesu() function */

extern int SU_LOG_LEVEL;

