; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-none-elf %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc -mtriple=aarch64-none-elf -global-isel %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-GI

define i32 @xori64i32(i64 %a) {
; CHECK-LABEL: xori64i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    asr x8, x0, #63
; CHECK-NEXT:    eor w0, w8, #0x7fffffff
; CHECK-NEXT:    ret
  %shr4 = ashr i64 %a, 63
  %conv5 = trunc i64 %shr4 to i32
  %xor = xor i32 %conv5, 2147483647
  ret i32 %xor
}

define i64 @selecti64i64(i64 %a) {
; CHECK-SD-LABEL: selecti64i64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    asr x8, x0, #63
; CHECK-SD-NEXT:    eor x0, x8, #0x7fffffff
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: selecti64i64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov x8, #-2147483648 // =0xffffffff80000000
; CHECK-GI-NEXT:    mov w9, #2147483647 // =0x7fffffff
; CHECK-GI-NEXT:    cmp x0, #0
; CHECK-GI-NEXT:    csel x0, x9, x8, ge
; CHECK-GI-NEXT:    ret
  %c = icmp sgt i64 %a, -1
  %s = select i1 %c, i64 2147483647, i64 -2147483648
  ret i64 %s
}

define i32 @selecti64i32(i64 %a) {
; CHECK-SD-LABEL: selecti64i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    asr x8, x0, #63
; CHECK-SD-NEXT:    eor w0, w8, #0x7fffffff
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: selecti64i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    cmp x0, #0
; CHECK-GI-NEXT:    mov w9, #-2147483648 // =0x80000000
; CHECK-GI-NEXT:    cset w8, ge
; CHECK-GI-NEXT:    sbfx w8, w8, #0, #1
; CHECK-GI-NEXT:    add w0, w8, w9
; CHECK-GI-NEXT:    ret
  %c = icmp sgt i64 %a, -1
  %s = select i1 %c, i32 2147483647, i32 -2147483648
  ret i32 %s
}

define i64 @selecti32i64(i32 %a) {
; CHECK-SD-LABEL: selecti32i64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-SD-NEXT:    sbfx x8, x0, #31, #1
; CHECK-SD-NEXT:    eor x0, x8, #0x7fffffff
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: selecti32i64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov x8, #-2147483648 // =0xffffffff80000000
; CHECK-GI-NEXT:    mov w9, #2147483647 // =0x7fffffff
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    csel x0, x9, x8, ge
; CHECK-GI-NEXT:    ret
  %c = icmp sgt i32 %a, -1
  %s = select i1 %c, i64 2147483647, i64 -2147483648
  ret i64 %s
}



define i8 @xori32i8(i32 %a) {
; CHECK-LABEL: xori32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #84 // =0x54
; CHECK-NEXT:    eor w0, w8, w0, asr #31
; CHECK-NEXT:    ret
  %shr4 = ashr i32 %a, 31
  %conv5 = trunc i32 %shr4 to i8
  %xor = xor i8 %conv5, 84
  ret i8 %xor
}

define i32 @selecti32i32(i32 %a) {
; CHECK-SD-LABEL: selecti32i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #84 // =0x54
; CHECK-SD-NEXT:    eor w0, w8, w0, asr #31
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: selecti32i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov w8, #-85 // =0xffffffab
; CHECK-GI-NEXT:    mov w9, #84 // =0x54
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    csel w0, w9, w8, ge
; CHECK-GI-NEXT:    ret
  %c = icmp sgt i32 %a, -1
  %s = select i1 %c, i32 84, i32 -85
  ret i32 %s
}

define i8 @selecti32i8(i32 %a) {
; CHECK-SD-LABEL: selecti32i8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #84 // =0x54
; CHECK-SD-NEXT:    eor w0, w8, w0, asr #31
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: selecti32i8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov w8, #84 // =0x54
; CHECK-GI-NEXT:    mov w9, #-85 // =0xffffffab
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    csel w0, w8, w9, ge
; CHECK-GI-NEXT:    ret
  %c = icmp sgt i32 %a, -1
  %s = select i1 %c, i8 84, i8 -85
  ret i8 %s
}

define i32 @selecti8i32(i8 %a) {
; CHECK-SD-LABEL: selecti8i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    sxtb w8, w0
; CHECK-SD-NEXT:    mov w9, #84 // =0x54
; CHECK-SD-NEXT:    eor w0, w9, w8, asr #7
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: selecti8i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sxtb w8, w0
; CHECK-GI-NEXT:    mov w9, #-85 // =0xffffffab
; CHECK-GI-NEXT:    mov w10, #84 // =0x54
; CHECK-GI-NEXT:    cmp w8, #0
; CHECK-GI-NEXT:    csel w0, w10, w9, ge
; CHECK-GI-NEXT:    ret
  %c = icmp sgt i8 %a, -1
  %s = select i1 %c, i32 84, i32 -85
  ret i32 %s
}

define i32 @icmpasreq(i32 %input, i32 %a, i32 %b) {
; CHECK-SD-LABEL: icmpasreq:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    csel w0, w1, w2, lt
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: icmpasreq:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-GI-NEXT:    cmp w8, w0, asr #31
; CHECK-GI-NEXT:    csel w0, w1, w2, eq
; CHECK-GI-NEXT:    ret
  %sh = ashr i32 %input, 31
  %c = icmp eq i32 %sh, -1
  %s = select i1 %c, i32 %a, i32 %b
  ret i32 %s
}

define i32 @icmpasrne(i32 %input, i32 %a, i32 %b) {
; CHECK-SD-LABEL: icmpasrne:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmn w0, #1
; CHECK-SD-NEXT:    csel w0, w1, w2, gt
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: icmpasrne:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov w8, #-1 // =0xffffffff
; CHECK-GI-NEXT:    cmp w8, w0, asr #31
; CHECK-GI-NEXT:    csel w0, w1, w2, ne
; CHECK-GI-NEXT:    ret
  %sh = ashr i32 %input, 31
  %c = icmp ne i32 %sh, -1
  %s = select i1 %c, i32 %a, i32 %b
  ret i32 %s
}

define i32 @selecti32i32_0(i32 %a) {
; CHECK-SD-LABEL: selecti32i32_0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    asr w0, w0, #31
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: selecti32i32_0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    cset w8, lt
; CHECK-GI-NEXT:    sbfx w0, w8, #0, #1
; CHECK-GI-NEXT:    ret
  %c = icmp sgt i32 %a, -1
  %s = select i1 %c, i32 0, i32 -1
  ret i32 %s
}

define i32 @selecti32i32_m1(i32 %a) {
; CHECK-SD-LABEL: selecti32i32_m1:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mvn w8, w0
; CHECK-SD-NEXT:    asr w0, w8, #31
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: selecti32i32_m1:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    cset w8, ge
; CHECK-GI-NEXT:    sbfx w0, w8, #0, #1
; CHECK-GI-NEXT:    ret
  %c = icmp sgt i32 %a, -1
  %s = select i1 %c, i32 -1, i32 0
  ret i32 %s
}

define i32 @selecti32i32_1(i32 %a) {
; CHECK-SD-LABEL: selecti32i32_1:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    asr w8, w0, #31
; CHECK-SD-NEXT:    eor w0, w8, #0x1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: selecti32i32_1:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov w8, #-2 // =0xfffffffe
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    csinc w0, w8, wzr, lt
; CHECK-GI-NEXT:    ret
  %c = icmp sgt i32 %a, -1
  %s = select i1 %c, i32 1, i32 -2
  ret i32 %s
}

define i32 @selecti32i32_sge(i32 %a) {
; CHECK-SD-LABEL: selecti32i32_sge:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    asr w8, w0, #31
; CHECK-SD-NEXT:    eor w0, w8, #0xc
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: selecti32i32_sge:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov w8, #-13 // =0xfffffff3
; CHECK-GI-NEXT:    mov w9, #12 // =0xc
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    csel w0, w9, w8, ge
; CHECK-GI-NEXT:    ret
  %c = icmp sge i32 %a, 0
  %s = select i1 %c, i32 12, i32 -13
  ret i32 %s
}

define i32 @selecti32i32_slt(i32 %a) {
; CHECK-SD-LABEL: selecti32i32_slt:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    asr w8, w0, #31
; CHECK-SD-NEXT:    eor w0, w8, #0xc
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: selecti32i32_slt:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov w8, #12 // =0xc
; CHECK-GI-NEXT:    mov w9, #-13 // =0xfffffff3
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    csel w0, w9, w8, lt
; CHECK-GI-NEXT:    ret
  %c = icmp slt i32 %a, 0
  %s = select i1 %c, i32 -13, i32 12
  ret i32 %s
}

define i32 @selecti32i32_sle(i32 %a) {
; CHECK-SD-LABEL: selecti32i32_sle:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    asr w8, w0, #31
; CHECK-SD-NEXT:    eor w0, w8, #0xc
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: selecti32i32_sle:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov w8, #12 // =0xc
; CHECK-GI-NEXT:    mov w9, #-13 // =0xfffffff3
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    csel w0, w9, w8, lt
; CHECK-GI-NEXT:    ret
  %c = icmp sle i32 %a, -1
  %s = select i1 %c, i32 -13, i32 12
  ret i32 %s
}

define i32 @selecti32i32_sgt(i32 %a) {
; CHECK-SD-LABEL: selecti32i32_sgt:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    asr w8, w0, #31
; CHECK-SD-NEXT:    eor w0, w8, #0xc
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: selecti32i32_sgt:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov w8, #12 // =0xc
; CHECK-GI-NEXT:    mov w9, #-13 // =0xfffffff3
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    csel w0, w9, w8, lt
; CHECK-GI-NEXT:    ret
  %c = icmp sle i32 %a, -1
  %s = select i1 %c, i32 -13, i32 12
  ret i32 %s
}

define i32 @oneusecmp(i32 %a, i32 %b, i32 %d) {
; CHECK-SD-LABEL: oneusecmp:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    asr w8, w0, #31
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    csel w9, w2, w1, lt
; CHECK-SD-NEXT:    eor w8, w8, #0x7f
; CHECK-SD-NEXT:    add w0, w8, w9
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: oneusecmp:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov w8, #127 // =0x7f
; CHECK-GI-NEXT:    mov w9, #-128 // =0xffffff80
; CHECK-GI-NEXT:    cmp w0, #0
; CHECK-GI-NEXT:    csel w8, w9, w8, lt
; CHECK-GI-NEXT:    csel w9, w2, w1, lt
; CHECK-GI-NEXT:    add w0, w8, w9
; CHECK-GI-NEXT:    ret
  %c = icmp sle i32 %a, -1
  %s = select i1 %c, i32 -128, i32 127
  %s2 = select i1 %c, i32 %d, i32 %b
  %x = add i32 %s, %s2
  ret i32 %x
}
