//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

// <unordered_map>

// template <class Key, class T, class Hash = hash<Key>, class Pred = equal_to<Key>,
//           class Alloc = allocator<pair<const Key, T>>>
// class unordered_map

// float load_factor() const

#include <unordered_map>
#include <string>
#include <cassert>
#include <cmath>
#include <cfloat>
#include <iterator>

#include "test_macros.h"
#include "min_allocator.h"

int main(int, char**) {
  {
    typedef std::unordered_map<int, std::string> C;
    typedef std::pair<int, std::string> P;
    P a[] = {
        P(10, "ten"),
        P(20, "twenty"),
        P(30, "thirty"),
        P(40, "forty"),
        P(50, "fifty"),
        P(60, "sixty"),
        P(70, "seventy"),
        P(80, "eighty"),
    };
    const C c(std::begin(a), std::end(a));
    assert(std::fabs(c.load_factor() - (float)c.size() / c.bucket_count()) < FLT_EPSILON);
  }
  {
    typedef std::unordered_map<int, std::string> C;
    const C c;
    assert(c.load_factor() == 0);
  }
#if TEST_STD_VER >= 11
  {
    typedef std::unordered_map<int,
                               std::string,
                               std::hash<int>,
                               std::equal_to<int>,
                               min_allocator<std::pair<const int, std::string>>>
        C;
    typedef std::pair<int, std::string> P;
    P a[] = {
        P(10, "ten"),
        P(20, "twenty"),
        P(30, "thirty"),
        P(40, "forty"),
        P(50, "fifty"),
        P(60, "sixty"),
        P(70, "seventy"),
        P(80, "eighty"),
    };
    const C c(std::begin(a), std::end(a));
    assert(std::fabs(c.load_factor() - (float)c.size() / c.bucket_count()) < FLT_EPSILON);
  }
  {
    typedef std::unordered_map<int,
                               std::string,
                               std::hash<int>,
                               std::equal_to<int>,
                               min_allocator<std::pair<const int, std::string>>>
        C;
    const C c;
    assert(c.load_factor() == 0);
  }
#endif

  return 0;
}
