; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-ibm-aix \
; RUN:   -mcpu=pwr7 < %s | FileCheck %s
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux \
; RUN:   -mcpu=pwr8 < %s | FileCheck %s
; RUN: llc < %s -mtriple powerpc64le-unknown-linux -debug-only=machine-scheduler \
; RUN:   2>&1 | FileCheck %s --check-prefix=LOG

; REQUIRES: asserts

define dso_local void @test_builtin_ppc_fence() {
; CHECK-LABEL: test_builtin_ppc_fence:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    #FENCE
; CHECK-NEXT:    blr
entry:
  call void @llvm.ppc.fence()
  ret void
}
declare void @llvm.ppc.fence()

; LOG: ***** MI Scheduling *****
; LOG-NEXT: motion:%bb.0 entry
; LOG: ExitSU: FENCE implicit-def dead $rm
; LOG: ***** MI Scheduling *****
; LOG-NEXT: motion:%bb.0 entry
; LOG: ExitSU: FENCE implicit-def dead $rm
;
; LOG: ***** MI Scheduling *****
; LOG-NEXT: motion:%bb.0 entry
; LOG: ExitSU: FENCE implicit-def dead $rm
; LOG: ***** MI Scheduling *****
; LOG-NEXT: motion:%bb.0 entry
; LOG: ExitSU: FENCE implicit-def dead $rm
define double @motion(double %a, double %b, double %c, double %d) {
entry:
  %0 = fdiv double %a, %b
  %1 = fdiv double %b, %d
  call void @llvm.ppc.fence()
  %2 = fdiv double %c, %d
  %3 = fdiv double %a, %c
  call void @llvm.ppc.fence()
  %4 = fadd double %0, %1
  %5 = fadd double %2, %3
  %6 = fsub double %4, %5
  ret double %6
}
