; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-ibm-aix-xcoff -vec-extabi -mcpu=pwr9 < %s | FileCheck %s -check-prefix=CHECK-64
; RUN: llc -verify-machineinstrs -mtriple=powerpc-ibm-aix-xcoff -vec-extabi -mcpu=pwr9 < %s | FileCheck %s -check-prefix=CHECK-32

define zeroext i8 @test1(<16 x i8> %a, i32 signext %index) {
; CHECK-64-LABEL: test1:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    clrldi 3, 3, 32
; CHECK-64-NEXT:    vextublx 3, 3, 2
; CHECK-64-NEXT:    clrldi 3, 3, 56
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: test1:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    addi 4, 1, -16
; CHECK-32-NEXT:    clrlwi 3, 3, 28
; CHECK-32-NEXT:    stxv 34, -16(1)
; CHECK-32-NEXT:    lbzx 3, 4, 3
; CHECK-32-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %a, i32 %index
  ret i8 %vecext
}

define signext i8 @test2(<16 x i8> %a, i32 signext %index) {
; CHECK-64-LABEL: test2:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    clrldi 3, 3, 32
; CHECK-64-NEXT:    vextublx 3, 3, 2
; CHECK-64-NEXT:    extsb 3, 3
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: test2:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    addi 4, 1, -16
; CHECK-32-NEXT:    clrlwi 3, 3, 28
; CHECK-32-NEXT:    stxv 34, -16(1)
; CHECK-32-NEXT:    lbzx 3, 4, 3
; CHECK-32-NEXT:    extsb 3, 3
; CHECK-32-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %a, i32 %index
  ret i8 %vecext
}

define zeroext i16 @test3(<8 x i16> %a, i32 signext %index) {
; CHECK-64-LABEL: test3:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    clrldi 3, 3, 32
; CHECK-64-NEXT:    rlwinm 3, 3, 1, 28, 30
; CHECK-64-NEXT:    vextuhlx 3, 3, 2
; CHECK-64-NEXT:    clrldi 3, 3, 48
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: test3:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    addi 4, 1, -16
; CHECK-32-NEXT:    rlwinm 3, 3, 1, 28, 30
; CHECK-32-NEXT:    stxv 34, -16(1)
; CHECK-32-NEXT:    lhzx 3, 4, 3
; CHECK-32-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %a, i32 %index
  ret i16 %vecext
}

define signext i16 @test4(<8 x i16> %a, i32 signext %index) {
; CHECK-64-LABEL: test4:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    clrldi 3, 3, 32
; CHECK-64-NEXT:    rlwinm 3, 3, 1, 28, 30
; CHECK-64-NEXT:    vextuhlx 3, 3, 2
; CHECK-64-NEXT:    extsh 3, 3
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: test4:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    addi 4, 1, -16
; CHECK-32-NEXT:    rlwinm 3, 3, 1, 28, 30
; CHECK-32-NEXT:    stxv 34, -16(1)
; CHECK-32-NEXT:    lhax 3, 4, 3
; CHECK-32-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %a, i32 %index
  ret i16 %vecext
}

define zeroext i32 @test5(<4 x i32> %a, i32 signext %index) {
; CHECK-64-LABEL: test5:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    clrldi 3, 3, 32
; CHECK-64-NEXT:    rlwinm 3, 3, 2, 28, 29
; CHECK-64-NEXT:    vextuwlx 3, 3, 2
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: test5:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    addi 4, 1, -16
; CHECK-32-NEXT:    rlwinm 3, 3, 2, 28, 29
; CHECK-32-NEXT:    stxv 34, -16(1)
; CHECK-32-NEXT:    lwzx 3, 4, 3
; CHECK-32-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %a, i32 %index
  ret i32 %vecext
}

define signext i32 @test6(<4 x i32> %a, i32 signext %index) {
; CHECK-64-LABEL: test6:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    clrldi 3, 3, 32
; CHECK-64-NEXT:    rlwinm 3, 3, 2, 28, 29
; CHECK-64-NEXT:    vextuwlx 3, 3, 2
; CHECK-64-NEXT:    extsw 3, 3
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: test6:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    addi 4, 1, -16
; CHECK-32-NEXT:    rlwinm 3, 3, 2, 28, 29
; CHECK-32-NEXT:    stxv 34, -16(1)
; CHECK-32-NEXT:    lwzx 3, 4, 3
; CHECK-32-NEXT:    blr
entry:
  %vecext = extractelement <4 x i32> %a, i32 %index
  ret i32 %vecext
}

; Test with immediate index
define zeroext i8 @test7(<16 x i8> %a) {
; CHECK-64-LABEL: test7:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    li 3, 1
; CHECK-64-NEXT:    vextublx 3, 3, 2
; CHECK-64-NEXT:    clrldi 3, 3, 56
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: test7:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    stxv 34, -16(1)
; CHECK-32-NEXT:    lbz 3, -15(1)
; CHECK-32-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %a, i32 1
  ret i8 %vecext
}

define zeroext i16 @test8(<8 x i16> %a) {
; CHECK-64-LABEL: test8:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    li 3, 2
; CHECK-64-NEXT:    vextuhlx 3, 3, 2
; CHECK-64-NEXT:    clrldi 3, 3, 48
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: test8:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    stxv 34, -16(1)
; CHECK-32-NEXT:    lhz 3, -14(1)
; CHECK-32-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %a, i32 1
  ret i16 %vecext
}

define zeroext i32 @test9(<4 x i32> %a) {
; CHECK-64-LABEL: test9:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    li 3, 12
; CHECK-64-NEXT:    vextuwlx 3, 3, 2
; CHECK-64-NEXT:    blr
;
; CHECK-32-LABEL: test9:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    stxv 34, -16(1)
; CHECK-32-NEXT:    lwz 3, -4(1)
; CHECK-32-NEXT:    blr
  %vecext = extractelement <4 x i32> %a, i32 3
  ret i32 %vecext
}
