; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --no-generate-body-for-unused-prefixes
; RUN: llc -fast-isel -fast-isel-abort=3 < %s | FileCheck %s
target datalayout = "e-m:e-i64:64-i128:128-n32:64-S128"
target triple = "aarch64-linux-gnu"

declare { i64, i64 } @ret_s2i64()

define i64 @call_ret_s2i64() {
; CHECK-LABEL: call_ret_s2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    bl ret_s2i64
; CHECK-NEXT:    add x0, x0, x1
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %ret = call { i64, i64 } @ret_s2i64()
  %ext0 = extractvalue { i64, i64 } %ret, 0
  %ext1 = extractvalue { i64, i64 } %ret, 1
  %sum = add i64 %ext0, %ext1
  ret i64 %sum
}

declare { i64, i64, i64, i64, i64, i64, i64, i64 } @ret_s8i64()

define i64 @call_ret_s8i64() {
; CHECK-LABEL: call_ret_s8i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    bl ret_s8i64
; CHECK-NEXT:    add x0, x0, x7
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %ret = call { i64, i64, i64, i64, i64, i64, i64, i64 } @ret_s8i64()
  %ext0 = extractvalue { i64, i64, i64, i64, i64, i64, i64, i64 } %ret, 0
  %ext7 = extractvalue { i64, i64, i64, i64, i64, i64, i64, i64 } %ret, 7
  %sum = add i64 %ext0, %ext7
  ret i64 %sum
}
