/* setup.c generated by valac 0.26.2, the Vala compiler
 * generated from setup.vala, do not modify */

/* 
 * Copyright (C) 2011-2014 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2014 Red Hat, Inc.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <libutil.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libkkc/libkkc.h>
#include <config.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <ibus.h>
#include <stdio.h>


#define TYPE_DICTIONARY_CELL_RENDERER (dictionary_cell_renderer_get_type ())
#define DICTIONARY_CELL_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DICTIONARY_CELL_RENDERER, DictionaryCellRenderer))
#define DICTIONARY_CELL_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DICTIONARY_CELL_RENDERER, DictionaryCellRendererClass))
#define IS_DICTIONARY_CELL_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DICTIONARY_CELL_RENDERER))
#define IS_DICTIONARY_CELL_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DICTIONARY_CELL_RENDERER))
#define DICTIONARY_CELL_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DICTIONARY_CELL_RENDERER, DictionaryCellRendererClass))

typedef struct _DictionaryCellRenderer DictionaryCellRenderer;
typedef struct _DictionaryCellRendererClass DictionaryCellRendererClass;
typedef struct _DictionaryCellRendererPrivate DictionaryCellRendererPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DICTIONARY_DIALOG (dictionary_dialog_get_type ())
#define DICTIONARY_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DICTIONARY_DIALOG, DictionaryDialog))
#define DICTIONARY_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DICTIONARY_DIALOG, DictionaryDialogClass))
#define IS_DICTIONARY_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DICTIONARY_DIALOG))
#define IS_DICTIONARY_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DICTIONARY_DIALOG))
#define DICTIONARY_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DICTIONARY_DIALOG, DictionaryDialogClass))

typedef struct _DictionaryDialog DictionaryDialog;
typedef struct _DictionaryDialogClass DictionaryDialogClass;
typedef struct _DictionaryDialogPrivate DictionaryDialogPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define __g_list_free__gtk_tree_path_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_tree_path_free0_ (var), NULL)))

#define TYPE_SHORTCUT_DIALOG (shortcut_dialog_get_type ())
#define SHORTCUT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SHORTCUT_DIALOG, ShortcutDialog))
#define SHORTCUT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SHORTCUT_DIALOG, ShortcutDialogClass))
#define IS_SHORTCUT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SHORTCUT_DIALOG))
#define IS_SHORTCUT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SHORTCUT_DIALOG))
#define SHORTCUT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SHORTCUT_DIALOG, ShortcutDialogClass))

typedef struct _ShortcutDialog ShortcutDialog;
typedef struct _ShortcutDialogClass ShortcutDialogClass;
typedef struct _ShortcutDialogPrivate ShortcutDialogPrivate;

#define TYPE_SETUP_DIALOG (setup_dialog_get_type ())
#define SETUP_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETUP_DIALOG, SetupDialog))
#define SETUP_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETUP_DIALOG, SetupDialogClass))
#define IS_SETUP_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETUP_DIALOG))
#define IS_SETUP_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETUP_DIALOG))
#define SETUP_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETUP_DIALOG, SetupDialogClass))

typedef struct _SetupDialog SetupDialog;
typedef struct _SetupDialogClass SetupDialogClass;
typedef struct _SetupDialogPrivate SetupDialogPrivate;
typedef struct _Block1Data Block1Data;

#define SETUP_DIALOG_TYPE_KEY_EVENT_CELL_RENDERER (setup_dialog_key_event_cell_renderer_get_type ())
#define SETUP_DIALOG_KEY_EVENT_CELL_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SETUP_DIALOG_TYPE_KEY_EVENT_CELL_RENDERER, SetupDialogKeyEventCellRenderer))
#define SETUP_DIALOG_KEY_EVENT_CELL_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SETUP_DIALOG_TYPE_KEY_EVENT_CELL_RENDERER, SetupDialogKeyEventCellRendererClass))
#define SETUP_DIALOG_IS_KEY_EVENT_CELL_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SETUP_DIALOG_TYPE_KEY_EVENT_CELL_RENDERER))
#define SETUP_DIALOG_IS_KEY_EVENT_CELL_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SETUP_DIALOG_TYPE_KEY_EVENT_CELL_RENDERER))
#define SETUP_DIALOG_KEY_EVENT_CELL_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SETUP_DIALOG_TYPE_KEY_EVENT_CELL_RENDERER, SetupDialogKeyEventCellRendererClass))

typedef struct _SetupDialogKeyEventCellRenderer SetupDialogKeyEventCellRenderer;
typedef struct _SetupDialogKeyEventCellRendererClass SetupDialogKeyEventCellRendererClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _SetupDialogKeyEventCellRendererPrivate SetupDialogKeyEventCellRendererPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _DictionaryCellRenderer {
	GtkCellRendererText parent_instance;
	DictionaryCellRendererPrivate * priv;
};

struct _DictionaryCellRendererClass {
	GtkCellRendererTextClass parent_class;
};

struct _DictionaryCellRendererPrivate {
	DictionaryMetadata* _metadata;
};

struct _DictionaryDialog {
	GtkDialog parent_instance;
	DictionaryDialogPrivate * priv;
};

struct _DictionaryDialogClass {
	GtkDialogClass parent_class;
};

struct _DictionaryDialogPrivate {
	GtkTreeView* available_dictionaries_treeview;
	Preferences* preferences;
};

struct _ShortcutDialog {
	GtkDialog parent_instance;
	ShortcutDialogPrivate * priv;
};

struct _ShortcutDialogClass {
	GtkDialogClass parent_class;
};

struct _ShortcutDialogPrivate {
	GtkComboBox* shortcut_command_combobox;
};

struct _SetupDialog {
	GtkDialog parent_instance;
	SetupDialogPrivate * priv;
};

struct _SetupDialogClass {
	GtkDialogClass parent_class;
};

struct _SetupDialogPrivate {
	GtkTreeView* dictionaries_treeview;
	GtkComboBox* punctuation_style_combobox;
	GtkCheckButton* auto_correct_checkbutton;
	GtkCheckButton* use_custom_keymap_checkbutton;
	GtkComboBox* keymap_combobox;
	GtkSpinButton* page_size_spinbutton;
	GtkSpinButton* pagination_start_spinbutton;
	GtkCheckButton* show_annotation_checkbutton;
	GtkComboBox* initial_input_mode_combobox;
	GtkComboBox* typing_rule_combobox;
	GtkTreeView* input_mode_treeview;
	GtkToolButton* add_dict_toolbutton;
	GtkToolButton* remove_dict_toolbutton;
	GtkToolButton* up_dict_toolbutton;
	GtkToolButton* down_dict_toolbutton;
	GtkTreeView* shortcut_treeview;
	GtkToolButton* add_shortcut_toolbutton;
	GtkToolButton* remove_shortcut_toolbutton;
	GtkLabel* version_label;
	Preferences* preferences;
	KkcUserRule* shortcut_rule;
	KkcInputMode shortcut_input_mode;
};

struct _Block1Data {
	int _ref_count_;
	SetupDialog* self;
	GtkTreeSelection* input_mode_selection;
	GtkTreeSelection* shortcut_selection;
	GtkTreeSelection* dictionaries_selection;
};

struct _Block2Data {
	int _ref_count_;
	SetupDialog* self;
	gchar* name;
	GtkSpinButton* spin;
};

struct _Block3Data {
	int _ref_count_;
	SetupDialog* self;
	gchar* name;
	GtkToggleButton* toggle;
};

struct _Block4Data {
	int _ref_count_;
	SetupDialog* self;
	gchar* name;
	GtkComboBox* combo;
	gint column;
};

struct _Block5Data {
	int _ref_count_;
	SetupDialog* self;
	gchar* name;
	GtkComboBox* combo;
	gint column;
};

struct _SetupDialogKeyEventCellRenderer {
	GtkCellRendererAccel parent_instance;
	SetupDialogKeyEventCellRendererPrivate * priv;
};

struct _SetupDialogKeyEventCellRendererClass {
	GtkCellRendererAccelClass parent_class;
};

struct _SetupDialogKeyEventCellRendererPrivate {
	KkcKeyEvent* _event;
};


static gpointer dictionary_cell_renderer_parent_class = NULL;
static gpointer dictionary_dialog_parent_class = NULL;
static gpointer shortcut_dialog_parent_class = NULL;
static gpointer setup_dialog_parent_class = NULL;
static gpointer setup_dialog_key_event_cell_renderer_parent_class = NULL;

GType dictionary_cell_renderer_get_type (void) G_GNUC_CONST;
#define DICTIONARY_CELL_RENDERER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DICTIONARY_CELL_RENDERER, DictionaryCellRendererPrivate))
enum  {
	DICTIONARY_CELL_RENDERER_DUMMY_PROPERTY,
	DICTIONARY_CELL_RENDERER_METADATA
};
DictionaryCellRenderer* dictionary_cell_renderer_new (void);
DictionaryCellRenderer* dictionary_cell_renderer_construct (GType object_type);
DictionaryMetadata* dictionary_cell_renderer_get_metadata (DictionaryCellRenderer* self);
void dictionary_cell_renderer_set_metadata (DictionaryCellRenderer* self, DictionaryMetadata* value);
static void dictionary_cell_renderer_finalize (GObject* obj);
static void _vala_dictionary_cell_renderer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dictionary_cell_renderer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType dictionary_dialog_get_type (void) G_GNUC_CONST;
#define DICTIONARY_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DICTIONARY_DIALOG, DictionaryDialogPrivate))
enum  {
	DICTIONARY_DIALOG_DUMMY_PROPERTY
};
DictionaryDialog* dictionary_dialog_new (Preferences* preferences);
DictionaryDialog* dictionary_dialog_construct (GType object_type, Preferences* preferences);
static void dictionary_dialog_populate_available_dictionaries_treeview (DictionaryDialog* self);
DictionaryMetadata** dictionary_dialog_get_dictionaries (DictionaryDialog* self, int* result_length1);
static void _vala_array_add1 (DictionaryMetadata*** array, int* length, int* size, DictionaryMetadata* value);
static void _gtk_tree_path_free0_ (gpointer var);
static void _g_list_free__gtk_tree_path_free0_ (GList* self);
static void dictionary_dialog_finalize (GObject* obj);
GType shortcut_dialog_get_type (void) G_GNUC_CONST;
#define SHORTCUT_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SHORTCUT_DIALOG, ShortcutDialogPrivate))
enum  {
	SHORTCUT_DIALOG_DUMMY_PROPERTY
};
ShortcutDialog* shortcut_dialog_new (void);
ShortcutDialog* shortcut_dialog_construct (GType object_type);
static gchar* shortcut_dialog_combobox_get_active_string (ShortcutDialog* self, GtkComboBox* combo, gint column);
gchar* shortcut_dialog_get_command (ShortcutDialog* self);
static void shortcut_dialog_finalize (GObject* obj);
GType setup_dialog_get_type (void) G_GNUC_CONST;
#define SETUP_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SETUP_DIALOG, SetupDialogPrivate))
enum  {
	SETUP_DIALOG_DUMMY_PROPERTY
};
SetupDialog* setup_dialog_new (Preferences* preferences);
SetupDialog* setup_dialog_construct (GType object_type, Preferences* preferences);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda4_ (Block1Data* _data1_);
static void setup_dialog_populate_shortcut_treeview (SetupDialog* self, KkcInputMode input_mode);
static void ___lambda4__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static GType setup_dialog_key_event_cell_renderer_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SetupDialogKeyEventCellRenderer* setup_dialog_key_event_cell_renderer_new (void);
static SetupDialogKeyEventCellRenderer* setup_dialog_key_event_cell_renderer_construct (GType object_type);
static void setup_dialog_accel_edited (SetupDialog* self, const gchar* path_string, guint keyval, GdkModifierType modifiers, guint keycode);
static void _setup_dialog_accel_edited_gtk_cell_renderer_accel_accel_edited (GtkCellRendererAccel* _sender, const gchar* path_string, guint accel_key, GdkModifierType accel_mods, guint hardware_keycode, gpointer self);
static void setup_dialog_accel_cleared (SetupDialog* self, const gchar* path_string);
static void _setup_dialog_accel_cleared_gtk_cell_renderer_accel_accel_cleared (GtkCellRendererAccel* _sender, const gchar* path_string, gpointer self);
static void __lambda5_ (Block1Data* _data1_);
static void ___lambda5__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static void setup_dialog_add_shortcut (SetupDialog* self);
static void _setup_dialog_add_shortcut_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void setup_dialog_remove_shortcut (SetupDialog* self);
static void _setup_dialog_remove_shortcut_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda6_ (SetupDialog* self);
static void ___lambda6__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void setup_dialog_load (SetupDialog* self);
static void setup_dialog_add_dict (SetupDialog* self);
static void _setup_dialog_add_dict_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void setup_dialog_remove_dict (SetupDialog* self);
static void _setup_dialog_remove_dict_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void setup_dialog_up_dict (SetupDialog* self);
static void _setup_dialog_up_dict_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void setup_dialog_down_dict (SetupDialog* self);
static void _setup_dialog_down_dict_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda11_ (Block1Data* _data1_);
static void ___lambda11__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static gboolean _vala_uint_array_contains (guint* stack, int stack_length, guint needle);
static void setup_dialog_populate_dictionaries_treeview (SetupDialog* self);
static void _vala_KkcKeymapEntry_array_free (KkcKeymapEntry* array, gint array_length);
static void setup_dialog_save_dictionaries (SetupDialog* self, const gchar* name);
static void setup_dialog_load_spinbutton (SetupDialog* self, const gchar* name, GtkSpinButton* spin);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda10_ (Block2Data* _data2_);
static GVariant* _variant_new1 (gint value);
static void ___lambda10__gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
static void setup_dialog_load_togglebutton (SetupDialog* self, const gchar* name, GtkToggleButton* toggle);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda9_ (Block3Data* _data3_);
static GVariant* _variant_new2 (gboolean value);
static void ___lambda9__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void setup_dialog_load_combobox (SetupDialog* self, const gchar* name, GtkComboBox* combo, gint column);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda8_ (Block4Data* _data4_);
static void setup_dialog_save_combobox (SetupDialog* self, const gchar* name, GtkComboBox* combo, gint column);
static void ___lambda8__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void setup_dialog_load_combobox_string (SetupDialog* self, const gchar* name, GtkComboBox* combo, gint column);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda7_ (Block5Data* _data5_);
static void setup_dialog_save_combobox_string (SetupDialog* self, const gchar* name, GtkComboBox* combo, gint column);
static void ___lambda7__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void setup_dialog_select_shortcut_section (SetupDialog* self, KkcInputMode input_mode);
static GVariant* _variant_new3 (gchar** value, gint value_length1);
static GVariant* _variant_new4 (gint value);
static GVariant* _variant_new5 (const gchar* value);
gint setup_dialog_main (gchar** args, int args_length1);
#define SETUP_DIALOG_KEY_EVENT_CELL_RENDERER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SETUP_DIALOG_TYPE_KEY_EVENT_CELL_RENDERER, SetupDialogKeyEventCellRendererPrivate))
enum  {
	SETUP_DIALOG_KEY_EVENT_CELL_RENDERER_DUMMY_PROPERTY,
	SETUP_DIALOG_KEY_EVENT_CELL_RENDERER_EVENT
};
static KkcKeyEvent* setup_dialog_key_event_cell_renderer_get_event (SetupDialogKeyEventCellRenderer* self);
static void setup_dialog_key_event_cell_renderer_set_event (SetupDialogKeyEventCellRenderer* self, KkcKeyEvent* value);
static void setup_dialog_key_event_cell_renderer_finalize (GObject* obj);
static void _vala_setup_dialog_key_event_cell_renderer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_setup_dialog_key_event_cell_renderer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void setup_dialog_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const guint SETUP_DIALOG_IGNORED_KEYVALS[2] = {KKC_KEYSYMS_BackSpace, KKC_KEYSYMS_Escape};

DictionaryCellRenderer* dictionary_cell_renderer_construct (GType object_type) {
	DictionaryCellRenderer * self = NULL;
	self = (DictionaryCellRenderer*) g_object_new (object_type, NULL);
	return self;
}


DictionaryCellRenderer* dictionary_cell_renderer_new (void) {
	return dictionary_cell_renderer_construct (TYPE_DICTIONARY_CELL_RENDERER);
}


DictionaryMetadata* dictionary_cell_renderer_get_metadata (DictionaryCellRenderer* self) {
	DictionaryMetadata* result;
	DictionaryMetadata* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_metadata;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void dictionary_cell_renderer_set_metadata (DictionaryCellRenderer* self, DictionaryMetadata* value) {
	DictionaryMetadata* _tmp0_ = NULL;
	DictionaryMetadata* _tmp1_ = NULL;
	DictionaryMetadata* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_metadata);
	self->priv->_metadata = _tmp1_;
	_tmp2_ = self->priv->_metadata;
	_tmp3_ = dictionary_metadata_get_name (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_dgettext (NULL, _tmp4_);
	g_object_set ((GtkCellRendererText*) self, "text", _tmp5_, NULL);
	g_object_notify ((GObject *) self, "metadata");
}


static void dictionary_cell_renderer_class_init (DictionaryCellRendererClass * klass) {
	dictionary_cell_renderer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DictionaryCellRendererPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dictionary_cell_renderer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dictionary_cell_renderer_set_property;
	G_OBJECT_CLASS (klass)->finalize = dictionary_cell_renderer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DICTIONARY_CELL_RENDERER_METADATA, g_param_spec_object ("metadata", "metadata", "metadata", TYPE_DICTIONARY_METADATA, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void dictionary_cell_renderer_instance_init (DictionaryCellRenderer * self) {
	self->priv = DICTIONARY_CELL_RENDERER_GET_PRIVATE (self);
}


static void dictionary_cell_renderer_finalize (GObject* obj) {
	DictionaryCellRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DICTIONARY_CELL_RENDERER, DictionaryCellRenderer);
	_g_object_unref0 (self->priv->_metadata);
	G_OBJECT_CLASS (dictionary_cell_renderer_parent_class)->finalize (obj);
}


GType dictionary_cell_renderer_get_type (void) {
	static volatile gsize dictionary_cell_renderer_type_id__volatile = 0;
	if (g_once_init_enter (&dictionary_cell_renderer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DictionaryCellRendererClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dictionary_cell_renderer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DictionaryCellRenderer), 0, (GInstanceInitFunc) dictionary_cell_renderer_instance_init, NULL };
		GType dictionary_cell_renderer_type_id;
		dictionary_cell_renderer_type_id = g_type_register_static (gtk_cell_renderer_text_get_type (), "DictionaryCellRenderer", &g_define_type_info, 0);
		g_once_init_leave (&dictionary_cell_renderer_type_id__volatile, dictionary_cell_renderer_type_id);
	}
	return dictionary_cell_renderer_type_id__volatile;
}


static void _vala_dictionary_cell_renderer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DictionaryCellRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DICTIONARY_CELL_RENDERER, DictionaryCellRenderer);
	switch (property_id) {
		case DICTIONARY_CELL_RENDERER_METADATA:
		g_value_set_object (value, dictionary_cell_renderer_get_metadata (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dictionary_cell_renderer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DictionaryCellRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DICTIONARY_CELL_RENDERER, DictionaryCellRenderer);
	switch (property_id) {
		case DICTIONARY_CELL_RENDERER_METADATA:
		dictionary_cell_renderer_set_metadata (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


DictionaryDialog* dictionary_dialog_construct (GType object_type, Preferences* preferences) {
	DictionaryDialog * self = NULL;
	Preferences* _tmp0_ = NULL;
	Preferences* _tmp1_ = NULL;
	GtkListStore* model = NULL;
	GtkCellRenderer* renderer = NULL;
	GtkTreeViewColumn* column = NULL;
	GtkListStore* _tmp2_ = NULL;
	GtkTreeView* _tmp3_ = NULL;
	DictionaryCellRenderer* _tmp4_ = NULL;
	GtkTreeViewColumn* _tmp5_ = NULL;
	GtkTreeView* _tmp6_ = NULL;
	g_return_val_if_fail (preferences != NULL, NULL);
	self = (DictionaryDialog*) g_object_new (object_type, NULL);
	_tmp0_ = preferences;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->preferences);
	self->priv->preferences = _tmp1_;
	_tmp2_ = gtk_list_store_new (2, TYPE_DICTIONARY_METADATA, G_TYPE_STRING, -1);
	_g_object_unref0 (model);
	model = _tmp2_;
	_tmp3_ = self->priv->available_dictionaries_treeview;
	gtk_tree_view_set_model (_tmp3_, (GtkTreeModel*) model);
	_tmp4_ = dictionary_cell_renderer_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (renderer);
	renderer = (GtkCellRenderer*) _tmp4_;
	_tmp5_ = gtk_tree_view_column_new_with_attributes ("dict", renderer, "metadata", 0, NULL);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (column);
	column = _tmp5_;
	_tmp6_ = self->priv->available_dictionaries_treeview;
	gtk_tree_view_append_column (_tmp6_, column);
	dictionary_dialog_populate_available_dictionaries_treeview (self);
	_g_object_unref0 (column);
	_g_object_unref0 (renderer);
	_g_object_unref0 (model);
	return self;
}


DictionaryDialog* dictionary_dialog_new (Preferences* preferences) {
	return dictionary_dialog_construct (TYPE_DICTIONARY_DIALOG, preferences);
}


static void dictionary_dialog_populate_available_dictionaries_treeview (DictionaryDialog* self) {
	GVariant* variant = NULL;
	Preferences* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	gchar** strv = NULL;
	GVariant* _tmp3_ = NULL;
	size_t _tmp4_;
	gchar** _tmp5_ = NULL;
	gint strv_length1 = 0;
	gint _strv_size_ = 0;
	GeeSet* enabled = NULL;
	GeeHashSet* _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	GtkListStore* model = NULL;
	GtkTreeView* _tmp11_ = NULL;
	GtkTreeModel* _tmp12_ = NULL;
	GtkListStore* _tmp13_ = NULL;
	GtkListStore* _tmp14_ = NULL;
	DictionaryMetadata** available_dictionaries = NULL;
	Preferences* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	DictionaryMetadata** _tmp17_ = NULL;
	gint available_dictionaries_length1 = 0;
	gint _available_dictionaries_size_ = 0;
	DictionaryMetadata** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preferences;
	_tmp1_ = preferences_get (_tmp0_, "system_dictionaries");
	variant = _tmp1_;
	_tmp2_ = variant;
	_vala_assert (_tmp2_ != NULL, "variant != null");
	_tmp3_ = variant;
	_tmp5_ = g_variant_dup_strv (_tmp3_, &_tmp4_);
	strv = _tmp5_;
	strv_length1 = _tmp4_;
	_strv_size_ = strv_length1;
	_tmp6_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	enabled = (GeeSet*) _tmp6_;
	_tmp7_ = strv;
	_tmp7__length1 = strv_length1;
	{
		gchar** str_collection = NULL;
		gint str_collection_length1 = 0;
		gint _str_collection_size_ = 0;
		gint str_it = 0;
		str_collection = _tmp7_;
		str_collection_length1 = _tmp7__length1;
		for (str_it = 0; str_it < _tmp7__length1; str_it = str_it + 1) {
			gchar* _tmp8_ = NULL;
			gchar* str = NULL;
			_tmp8_ = g_strdup (str_collection[str_it]);
			str = _tmp8_;
			{
				GeeSet* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				_tmp9_ = enabled;
				_tmp10_ = str;
				gee_collection_add ((GeeCollection*) _tmp9_, _tmp10_);
				_g_free0 (str);
			}
		}
	}
	_tmp11_ = self->priv->available_dictionaries_treeview;
	_tmp12_ = gtk_tree_view_get_model (_tmp11_);
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_list_store_get_type (), GtkListStore));
	model = _tmp13_;
	_tmp14_ = model;
	gtk_list_store_clear (_tmp14_);
	_tmp15_ = self->priv->preferences;
	_tmp17_ = preferences_list_available_dictionaries (_tmp15_, &_tmp16_);
	available_dictionaries = _tmp17_;
	available_dictionaries_length1 = _tmp16_;
	_available_dictionaries_size_ = available_dictionaries_length1;
	_tmp18_ = available_dictionaries;
	_tmp18__length1 = available_dictionaries_length1;
	{
		DictionaryMetadata** metadata_collection = NULL;
		gint metadata_collection_length1 = 0;
		gint _metadata_collection_size_ = 0;
		gint metadata_it = 0;
		metadata_collection = _tmp18_;
		metadata_collection_length1 = _tmp18__length1;
		for (metadata_it = 0; metadata_it < _tmp18__length1; metadata_it = metadata_it + 1) {
			DictionaryMetadata* _tmp19_ = NULL;
			DictionaryMetadata* metadata = NULL;
			_tmp19_ = _g_object_ref0 (metadata_collection[metadata_it]);
			metadata = _tmp19_;
			{
				GeeSet* _tmp20_ = NULL;
				DictionaryMetadata* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				gboolean _tmp24_ = FALSE;
				_tmp20_ = enabled;
				_tmp21_ = metadata;
				_tmp22_ = dictionary_metadata_get_id (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = gee_collection_contains ((GeeCollection*) _tmp20_, _tmp23_);
				if (!_tmp24_) {
					GtkTreeIter iter = {0};
					GtkListStore* _tmp25_ = NULL;
					GtkTreeIter _tmp26_ = {0};
					GtkListStore* _tmp27_ = NULL;
					GtkTreeIter _tmp28_ = {0};
					DictionaryMetadata* _tmp29_ = NULL;
					DictionaryMetadata* _tmp30_ = NULL;
					const gchar* _tmp31_ = NULL;
					const gchar* _tmp32_ = NULL;
					const gchar* _tmp33_ = NULL;
					_tmp25_ = model;
					gtk_list_store_append (_tmp25_, &_tmp26_);
					iter = _tmp26_;
					_tmp27_ = model;
					_tmp28_ = iter;
					_tmp29_ = metadata;
					_tmp30_ = metadata;
					_tmp31_ = dictionary_metadata_get_description (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp33_ = g_dgettext (NULL, _tmp32_);
					gtk_list_store_set (_tmp27_, &_tmp28_, 0, _tmp29_, 1, _tmp33_, -1);
				}
				_g_object_unref0 (metadata);
			}
		}
	}
	available_dictionaries = (_vala_array_free (available_dictionaries, available_dictionaries_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (model);
	_g_object_unref0 (enabled);
	strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
	_g_variant_unref0 (variant);
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


static void _vala_array_add1 (DictionaryMetadata*** array, int* length, int* size, DictionaryMetadata* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (DictionaryMetadata*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _gtk_tree_path_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL));
}


static void _g_list_free__gtk_tree_path_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gtk_tree_path_free0_, NULL);
	g_list_free (self);
}


DictionaryMetadata** dictionary_dialog_get_dictionaries (DictionaryDialog* self, int* result_length1) {
	DictionaryMetadata** result = NULL;
	DictionaryMetadata** dictionaries = NULL;
	DictionaryMetadata** _tmp0_ = NULL;
	gint dictionaries_length1 = 0;
	gint _dictionaries_size_ = 0;
	GtkTreeSelection* selection = NULL;
	GtkTreeView* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_ = NULL;
	GtkTreeSelection* _tmp3_ = NULL;
	GtkTreeModel* available_model = NULL;
	GList* rows = NULL;
	GtkTreeSelection* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GList* _tmp6_ = NULL;
	GtkTreeModel* _tmp7_ = NULL;
	GList* _tmp8_ = NULL;
	DictionaryMetadata** _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (DictionaryMetadata*, 0 + 1);
	dictionaries = _tmp0_;
	dictionaries_length1 = 0;
	_dictionaries_size_ = dictionaries_length1;
	_tmp1_ = self->priv->available_dictionaries_treeview;
	_tmp2_ = gtk_tree_view_get_selection (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	selection = _tmp3_;
	_tmp4_ = selection;
	_tmp6_ = gtk_tree_selection_get_selected_rows (_tmp4_, &_tmp5_);
	_g_object_unref0 (available_model);
	_tmp7_ = _g_object_ref0 (_tmp5_);
	available_model = _tmp7_;
	rows = _tmp6_;
	_tmp8_ = rows;
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp8_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkTreePath* _tmp9_ = NULL;
			GtkTreePath* row = NULL;
			_tmp9_ = _gtk_tree_path_copy0 ((GtkTreePath*) row_it->data);
			row = _tmp9_;
			{
				GtkTreeIter available_iter = {0};
				GtkTreeModel* _tmp10_ = NULL;
				GtkTreePath* _tmp11_ = NULL;
				GtkTreeIter _tmp12_ = {0};
				gboolean _tmp13_ = FALSE;
				_tmp10_ = available_model;
				_tmp11_ = row;
				_tmp13_ = gtk_tree_model_get_iter (_tmp10_, &_tmp12_, _tmp11_);
				available_iter = _tmp12_;
				if (_tmp13_) {
					DictionaryMetadata* metadata = NULL;
					GtkTreeModel* _tmp14_ = NULL;
					GtkTreeIter _tmp15_ = {0};
					DictionaryMetadata** _tmp16_ = NULL;
					gint _tmp16__length1 = 0;
					DictionaryMetadata* _tmp17_ = NULL;
					DictionaryMetadata* _tmp18_ = NULL;
					_tmp14_ = available_model;
					_tmp15_ = available_iter;
					gtk_tree_model_get (_tmp14_, &_tmp15_, 0, &metadata, -1, -1);
					_tmp16_ = dictionaries;
					_tmp16__length1 = dictionaries_length1;
					_tmp17_ = metadata;
					_tmp18_ = _g_object_ref0 (_tmp17_);
					_vala_array_add1 (&dictionaries, &dictionaries_length1, &_dictionaries_size_, _tmp18_);
					_g_object_unref0 (metadata);
				}
				_gtk_tree_path_free0 (row);
			}
		}
	}
	_tmp19_ = dictionaries;
	_tmp19__length1 = dictionaries_length1;
	if (result_length1) {
		*result_length1 = _tmp19__length1;
	}
	result = _tmp19_;
	__g_list_free__gtk_tree_path_free0_0 (rows);
	_g_object_unref0 (available_model);
	_g_object_unref0 (selection);
	return result;
}


static void dictionary_dialog_class_init (DictionaryDialogClass * klass) {
	gint DictionaryDialog_private_offset;
	dictionary_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DictionaryDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = dictionary_dialog_finalize;
	DictionaryDialog_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/freedesktop/ibus/engine/kkc/dictionary-dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "available_dictionaries_treeview", FALSE, DictionaryDialog_private_offset + G_STRUCT_OFFSET (DictionaryDialogPrivate, available_dictionaries_treeview));
}


static void dictionary_dialog_instance_init (DictionaryDialog * self) {
	self->priv = DICTIONARY_DIALOG_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void dictionary_dialog_finalize (GObject* obj) {
	DictionaryDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DICTIONARY_DIALOG, DictionaryDialog);
	_g_object_unref0 (self->priv->available_dictionaries_treeview);
	_g_object_unref0 (self->priv->preferences);
	G_OBJECT_CLASS (dictionary_dialog_parent_class)->finalize (obj);
}


GType dictionary_dialog_get_type (void) {
	static volatile gsize dictionary_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&dictionary_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DictionaryDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dictionary_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DictionaryDialog), 0, (GInstanceInitFunc) dictionary_dialog_instance_init, NULL };
		GType dictionary_dialog_type_id;
		dictionary_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "DictionaryDialog", &g_define_type_info, 0);
		g_once_init_leave (&dictionary_dialog_type_id__volatile, dictionary_dialog_type_id);
	}
	return dictionary_dialog_type_id__volatile;
}


ShortcutDialog* shortcut_dialog_construct (GType object_type) {
	ShortcutDialog * self = NULL;
	GtkListStore* model = NULL;
	GtkCellRenderer* renderer = NULL;
	GtkListStore* _tmp0_ = NULL;
	GtkListStore* _tmp1_ = NULL;
	GtkComboBox* _tmp2_ = NULL;
	GtkListStore* _tmp3_ = NULL;
	gchar** commands = NULL;
	gint _tmp4_ = 0;
	gchar** _tmp5_ = NULL;
	gint commands_length1 = 0;
	gint _commands_size_ = 0;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	GtkComboBox* _tmp16_ = NULL;
	GtkCellRendererText* _tmp17_ = NULL;
	GtkComboBox* _tmp18_ = NULL;
	GtkComboBox* _tmp19_ = NULL;
	self = (ShortcutDialog*) g_object_new (object_type, NULL);
	_tmp0_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING, -1);
	_g_object_unref0 (model);
	model = _tmp0_;
	_tmp1_ = model;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp1_, 1, GTK_SORT_ASCENDING);
	_tmp2_ = self->priv->shortcut_command_combobox;
	_tmp3_ = model;
	gtk_combo_box_set_model (_tmp2_, (GtkTreeModel*) _tmp3_);
	_tmp5_ = kkc_keymap_commands (&_tmp4_);
	commands = _tmp5_;
	commands_length1 = _tmp4_;
	_commands_size_ = commands_length1;
	_tmp6_ = commands;
	_tmp6__length1 = commands_length1;
	{
		gchar** command_collection = NULL;
		gint command_collection_length1 = 0;
		gint _command_collection_size_ = 0;
		gint command_it = 0;
		command_collection = _tmp6_;
		command_collection_length1 = _tmp6__length1;
		for (command_it = 0; command_it < _tmp6__length1; command_it = command_it + 1) {
			gchar* _tmp7_ = NULL;
			gchar* command = NULL;
			_tmp7_ = g_strdup (command_collection[command_it]);
			command = _tmp7_;
			{
				GtkTreeIter iter = {0};
				GtkListStore* _tmp8_ = NULL;
				GtkTreeIter _tmp9_ = {0};
				GtkListStore* _tmp10_ = NULL;
				GtkTreeIter _tmp11_ = {0};
				const gchar* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				_tmp8_ = model;
				gtk_list_store_append (_tmp8_, &_tmp9_);
				iter = _tmp9_;
				_tmp10_ = model;
				_tmp11_ = iter;
				_tmp12_ = command;
				_tmp13_ = command;
				_tmp14_ = kkc_keymap_get_command_label (_tmp13_);
				_tmp15_ = _tmp14_;
				gtk_list_store_set (_tmp10_, &_tmp11_, 0, _tmp12_, 1, _tmp15_, -1);
				_g_free0 (_tmp15_);
				_g_free0 (command);
			}
		}
	}
	_tmp16_ = self->priv->shortcut_command_combobox;
	gtk_combo_box_set_active (_tmp16_, 0);
	_tmp17_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (renderer);
	renderer = (GtkCellRenderer*) _tmp17_;
	_tmp18_ = self->priv->shortcut_command_combobox;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp18_, renderer, FALSE);
	_tmp19_ = self->priv->shortcut_command_combobox;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp19_, renderer, "text", 1, NULL);
	commands = (_vala_array_free (commands, commands_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (renderer);
	_g_object_unref0 (model);
	return self;
}


ShortcutDialog* shortcut_dialog_new (void) {
	return shortcut_dialog_construct (TYPE_SHORTCUT_DIALOG);
}


static gchar* shortcut_dialog_combobox_get_active_string (ShortcutDialog* self, GtkComboBox* combo, gint column) {
	gchar* result = NULL;
	gchar* text = NULL;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (combo != NULL, NULL);
	_tmp0_ = combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		GtkListStore* model = NULL;
		GtkComboBox* _tmp3_ = NULL;
		GtkTreeModel* _tmp4_ = NULL;
		GtkListStore* _tmp5_ = NULL;
		GtkTreeIter _tmp6_ = {0};
		gint _tmp7_ = 0;
		_tmp3_ = combo;
		_tmp4_ = gtk_combo_box_get_model (_tmp3_);
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_list_store_get_type (), GtkListStore));
		model = _tmp5_;
		_tmp6_ = iter;
		_tmp7_ = column;
		gtk_tree_model_get ((GtkTreeModel*) model, &_tmp6_, _tmp7_, &text, -1, -1);
		_g_object_unref0 (model);
	} else {
		g_assert_not_reached ();
	}
	result = text;
	return result;
}


gchar* shortcut_dialog_get_command (ShortcutDialog* self) {
	gchar* result = NULL;
	GtkComboBox* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->shortcut_command_combobox;
	_tmp1_ = shortcut_dialog_combobox_get_active_string (self, _tmp0_, 0);
	result = _tmp1_;
	return result;
}


static void shortcut_dialog_class_init (ShortcutDialogClass * klass) {
	gint ShortcutDialog_private_offset;
	shortcut_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ShortcutDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = shortcut_dialog_finalize;
	ShortcutDialog_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/freedesktop/ibus/engine/kkc/shortcut-dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "shortcut_command_combobox", FALSE, ShortcutDialog_private_offset + G_STRUCT_OFFSET (ShortcutDialogPrivate, shortcut_command_combobox));
}


static void shortcut_dialog_instance_init (ShortcutDialog * self) {
	self->priv = SHORTCUT_DIALOG_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void shortcut_dialog_finalize (GObject* obj) {
	ShortcutDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SHORTCUT_DIALOG, ShortcutDialog);
	_g_object_unref0 (self->priv->shortcut_command_combobox);
	G_OBJECT_CLASS (shortcut_dialog_parent_class)->finalize (obj);
}


GType shortcut_dialog_get_type (void) {
	static volatile gsize shortcut_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&shortcut_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ShortcutDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) shortcut_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ShortcutDialog), 0, (GInstanceInitFunc) shortcut_dialog_instance_init, NULL };
		GType shortcut_dialog_type_id;
		shortcut_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "ShortcutDialog", &g_define_type_info, 0);
		g_once_init_leave (&shortcut_dialog_type_id__volatile, shortcut_dialog_type_id);
	}
	return shortcut_dialog_type_id__volatile;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		SetupDialog* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->dictionaries_selection);
		_g_object_unref0 (_data1_->shortcut_selection);
		_g_object_unref0 (_data1_->input_mode_selection);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda4_ (Block1Data* _data1_) {
	SetupDialog* self;
	GtkTreeIter iter = {0};
	GtkTreeModel* _model = NULL;
	GtkTreeSelection* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	GtkTreeModel* _tmp4_ = NULL;
	self = _data1_->self;
	_tmp0_ = _data1_->input_mode_selection;
	_tmp3_ = gtk_tree_selection_get_selected (_tmp0_, &_tmp1_, &_tmp2_);
	_g_object_unref0 (_model);
	_tmp4_ = _g_object_ref0 (_tmp1_);
	_model = _tmp4_;
	iter = _tmp2_;
	if (_tmp3_) {
		gint input_mode = 0;
		GtkTreeModel* _tmp5_ = NULL;
		GtkTreeIter _tmp6_ = {0};
		gint _tmp7_ = 0;
		_tmp5_ = _model;
		_tmp6_ = iter;
		gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &input_mode, -1, -1);
		_tmp7_ = input_mode;
		setup_dialog_populate_shortcut_treeview (self, (KkcInputMode) _tmp7_);
	}
	_g_object_unref0 (_model);
}


static void ___lambda4__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	__lambda4_ (self);
}


static void _setup_dialog_accel_edited_gtk_cell_renderer_accel_accel_edited (GtkCellRendererAccel* _sender, const gchar* path_string, guint accel_key, GdkModifierType accel_mods, guint hardware_keycode, gpointer self) {
	setup_dialog_accel_edited ((SetupDialog*) self, path_string, accel_key, accel_mods, hardware_keycode);
}


static void _setup_dialog_accel_cleared_gtk_cell_renderer_accel_accel_cleared (GtkCellRendererAccel* _sender, const gchar* path_string, gpointer self) {
	setup_dialog_accel_cleared ((SetupDialog*) self, path_string);
}


static void __lambda5_ (Block1Data* _data1_) {
	SetupDialog* self;
	gint count = 0;
	GtkTreeSelection* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	self = _data1_->self;
	_tmp0_ = _data1_->shortcut_selection;
	_tmp1_ = gtk_tree_selection_count_selected_rows (_tmp0_);
	count = _tmp1_;
	_tmp2_ = count;
	if (_tmp2_ > 0) {
		GtkToolButton* _tmp3_ = NULL;
		_tmp3_ = self->priv->remove_shortcut_toolbutton;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, TRUE);
	} else {
		gint _tmp4_ = 0;
		_tmp4_ = count;
		if (_tmp4_ == 0) {
			GtkToolButton* _tmp5_ = NULL;
			_tmp5_ = self->priv->remove_shortcut_toolbutton;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, FALSE);
		}
	}
}


static void ___lambda5__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	__lambda5_ (self);
}


static void _setup_dialog_add_shortcut_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	setup_dialog_add_shortcut ((SetupDialog*) self);
}


static void _setup_dialog_remove_shortcut_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	setup_dialog_remove_shortcut ((SetupDialog*) self);
}


static void __lambda6_ (SetupDialog* self) {
	GtkComboBox* _tmp0_ = NULL;
	GtkCheckButton* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	_tmp0_ = self->priv->keymap_combobox;
	_tmp1_ = self->priv->use_custom_keymap_checkbutton;
	_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp2_);
}


static void ___lambda6__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	__lambda6_ ((SetupDialog*) self);
}


static void _setup_dialog_add_dict_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	setup_dialog_add_dict ((SetupDialog*) self);
}


static void _setup_dialog_remove_dict_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	setup_dialog_remove_dict ((SetupDialog*) self);
}


static void _setup_dialog_up_dict_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	setup_dialog_up_dict ((SetupDialog*) self);
}


static void _setup_dialog_down_dict_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	setup_dialog_down_dict ((SetupDialog*) self);
}


static void __lambda11_ (Block1Data* _data1_) {
	SetupDialog* self;
	gint count = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	self = _data1_->self;
	_tmp0_ = gtk_tree_selection_count_selected_rows (_data1_->dictionaries_selection);
	count = _tmp0_;
	_tmp1_ = count;
	if (_tmp1_ > 0) {
		GtkToolButton* _tmp2_ = NULL;
		GtkTreeModel* _model = NULL;
		GtkTreeIter iter = {0};
		GtkTreeModel* _tmp3_ = NULL;
		GtkTreeIter _tmp4_ = {0};
		gboolean _tmp5_ = FALSE;
		GtkTreeModel* _tmp6_ = NULL;
		_tmp2_ = self->priv->remove_dict_toolbutton;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, TRUE);
		_tmp5_ = gtk_tree_selection_get_selected (_data1_->dictionaries_selection, &_tmp3_, &_tmp4_);
		_g_object_unref0 (_model);
		_tmp6_ = _g_object_ref0 (_tmp3_);
		_model = _tmp6_;
		iter = _tmp4_;
		if (_tmp5_) {
			GtkTreeIter prev = {0};
			GtkTreeIter _tmp7_ = {0};
			GtkToolButton* _tmp8_ = NULL;
			GtkTreeModel* _tmp9_ = NULL;
			gboolean _tmp10_ = FALSE;
			GtkTreeIter next = {0};
			GtkTreeIter _tmp11_ = {0};
			GtkToolButton* _tmp12_ = NULL;
			GtkTreeModel* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			_tmp7_ = iter;
			prev = _tmp7_;
			_tmp8_ = self->priv->up_dict_toolbutton;
			_tmp9_ = _model;
			_tmp10_ = gtk_tree_model_iter_previous (_tmp9_, &prev);
			gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, _tmp10_);
			_tmp11_ = iter;
			next = _tmp11_;
			_tmp12_ = self->priv->down_dict_toolbutton;
			_tmp13_ = _model;
			_tmp14_ = gtk_tree_model_iter_next (_tmp13_, &next);
			gtk_widget_set_sensitive ((GtkWidget*) _tmp12_, _tmp14_);
		}
		_g_object_unref0 (_model);
	} else {
		gint _tmp15_ = 0;
		_tmp15_ = count;
		if (_tmp15_ == 0) {
			GtkToolButton* _tmp16_ = NULL;
			GtkToolButton* _tmp17_ = NULL;
			GtkToolButton* _tmp18_ = NULL;
			_tmp16_ = self->priv->remove_dict_toolbutton;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp16_, FALSE);
			_tmp17_ = self->priv->up_dict_toolbutton;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp17_, FALSE);
			_tmp18_ = self->priv->down_dict_toolbutton;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp18_, FALSE);
		}
	}
}


static void ___lambda11__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	__lambda11_ (self);
}


SetupDialog* setup_dialog_construct (GType object_type, Preferences* preferences) {
	SetupDialog * self = NULL;
	Block1Data* _data1_;
	Preferences* _tmp0_ = NULL;
	Preferences* _tmp1_ = NULL;
	GtkLabel* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GtkSpinButton* _tmp6_ = NULL;
	GtkSpinButton* _tmp7_ = NULL;
	GtkSpinButton* _tmp8_ = NULL;
	GtkSpinButton* _tmp9_ = NULL;
	GtkListStore* model = NULL;
	GtkCellRenderer* renderer = NULL;
	GtkTreeViewColumn* column = NULL;
	GtkListStore* _tmp10_ = NULL;
	GtkTreeView* _tmp11_ = NULL;
	GtkListStore* _tmp12_ = NULL;
	DictionaryCellRenderer* _tmp13_ = NULL;
	GtkCellRenderer* _tmp14_ = NULL;
	GtkTreeViewColumn* _tmp15_ = NULL;
	GtkTreeView* _tmp16_ = NULL;
	GtkTreeViewColumn* _tmp17_ = NULL;
	GtkCellRendererText* _tmp18_ = NULL;
	GtkComboBox* _tmp19_ = NULL;
	GtkCellRenderer* _tmp20_ = NULL;
	GtkComboBox* _tmp21_ = NULL;
	GtkCellRenderer* _tmp22_ = NULL;
	GtkCellRendererText* _tmp23_ = NULL;
	GtkComboBox* _tmp24_ = NULL;
	GtkCellRenderer* _tmp25_ = NULL;
	GtkComboBox* _tmp26_ = NULL;
	GtkCellRenderer* _tmp27_ = NULL;
	GtkCellRendererText* _tmp28_ = NULL;
	GtkCellRenderer* _tmp29_ = NULL;
	GtkTreeViewColumn* _tmp30_ = NULL;
	GtkTreeView* _tmp31_ = NULL;
	GtkTreeViewColumn* _tmp32_ = NULL;
	GtkTreeView* _tmp33_ = NULL;
	GtkTreeSelection* _tmp34_ = NULL;
	GtkTreeSelection* _tmp35_ = NULL;
	GtkTreeSelection* _tmp36_ = NULL;
	GtkListStore* _tmp37_ = NULL;
	GtkListStore* _tmp38_ = NULL;
	GtkTreeView* _tmp39_ = NULL;
	GtkListStore* _tmp40_ = NULL;
	GtkCellRendererText* _tmp41_ = NULL;
	GtkCellRenderer* _tmp42_ = NULL;
	GtkTreeViewColumn* _tmp43_ = NULL;
	GtkTreeView* _tmp44_ = NULL;
	GtkTreeViewColumn* _tmp45_ = NULL;
	SetupDialogKeyEventCellRenderer* accel_renderer = NULL;
	SetupDialogKeyEventCellRenderer* _tmp46_ = NULL;
	SetupDialogKeyEventCellRenderer* _tmp47_ = NULL;
	SetupDialogKeyEventCellRenderer* _tmp48_ = NULL;
	GtkTreeViewColumn* _tmp49_ = NULL;
	GtkTreeView* _tmp50_ = NULL;
	GtkTreeViewColumn* _tmp51_ = NULL;
	SetupDialogKeyEventCellRenderer* _tmp52_ = NULL;
	SetupDialogKeyEventCellRenderer* _tmp53_ = NULL;
	GtkTreeView* _tmp54_ = NULL;
	GtkTreeSelection* _tmp55_ = NULL;
	GtkTreeSelection* _tmp56_ = NULL;
	GtkTreeSelection* _tmp57_ = NULL;
	GtkToolButton* _tmp58_ = NULL;
	GtkToolButton* _tmp59_ = NULL;
	GtkListStore* _tmp60_ = NULL;
	GtkListStore* _tmp61_ = NULL;
	GtkComboBox* _tmp62_ = NULL;
	GtkListStore* _tmp63_ = NULL;
	KkcRuleMetadata** rules = NULL;
	gint _tmp64_ = 0;
	KkcRuleMetadata** _tmp65_ = NULL;
	gint rules_length1 = 0;
	gint _rules_size_ = 0;
	KkcRuleMetadata** _tmp66_ = NULL;
	gint _tmp66__length1 = 0;
	GtkCellRendererText* _tmp81_ = NULL;
	GtkComboBox* _tmp82_ = NULL;
	GtkCellRenderer* _tmp83_ = NULL;
	GtkComboBox* _tmp84_ = NULL;
	GtkCellRenderer* _tmp85_ = NULL;
	GtkCellRendererText* _tmp86_ = NULL;
	GtkComboBox* _tmp87_ = NULL;
	GtkCellRenderer* _tmp88_ = NULL;
	GtkComboBox* _tmp89_ = NULL;
	GtkCellRenderer* _tmp90_ = NULL;
	GtkCheckButton* _tmp91_ = NULL;
	GtkToolButton* _tmp92_ = NULL;
	GtkToolButton* _tmp93_ = NULL;
	GtkToolButton* _tmp94_ = NULL;
	GtkToolButton* _tmp95_ = NULL;
	GtkTreeView* _tmp96_ = NULL;
	GtkTreeSelection* _tmp97_ = NULL;
	GtkTreeSelection* _tmp98_ = NULL;
	g_return_val_if_fail (preferences != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	self = (SetupDialog*) g_object_new (object_type, NULL);
	_data1_->self = g_object_ref (self);
	_tmp0_ = preferences;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->preferences);
	self->priv->preferences = _tmp1_;
	_tmp2_ = self->priv->version_label;
	gtk_label_set_use_markup (_tmp2_, TRUE);
	_tmp3_ = self->priv->version_label;
	_tmp4_ = g_strdup_printf ("<b>%s</b>", VERSION);
	_tmp5_ = _tmp4_;
	gtk_label_set_label (_tmp3_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->page_size_spinbutton;
	gtk_spin_button_set_range (_tmp6_, 7.0, 16.0);
	_tmp7_ = self->priv->page_size_spinbutton;
	gtk_spin_button_set_increments (_tmp7_, 1.0, 1.0);
	_tmp8_ = self->priv->pagination_start_spinbutton;
	gtk_spin_button_set_range (_tmp8_, 0.0, 7.0);
	_tmp9_ = self->priv->pagination_start_spinbutton;
	gtk_spin_button_set_increments (_tmp9_, 1.0, 1.0);
	_tmp10_ = gtk_list_store_new (2, TYPE_DICTIONARY_METADATA, G_TYPE_STRING, -1);
	_g_object_unref0 (model);
	model = _tmp10_;
	_tmp11_ = self->priv->dictionaries_treeview;
	_tmp12_ = model;
	gtk_tree_view_set_model (_tmp11_, (GtkTreeModel*) _tmp12_);
	_tmp13_ = dictionary_cell_renderer_new ();
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (renderer);
	renderer = (GtkCellRenderer*) _tmp13_;
	_tmp14_ = renderer;
	_tmp15_ = gtk_tree_view_column_new_with_attributes ("dict", _tmp14_, "metadata", 0, NULL);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (column);
	column = _tmp15_;
	_tmp16_ = self->priv->dictionaries_treeview;
	_tmp17_ = column;
	gtk_tree_view_append_column (_tmp16_, _tmp17_);
	_tmp18_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (renderer);
	renderer = (GtkCellRenderer*) _tmp18_;
	_tmp19_ = self->priv->punctuation_style_combobox;
	_tmp20_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp19_, _tmp20_, FALSE);
	_tmp21_ = self->priv->punctuation_style_combobox;
	_tmp22_ = renderer;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp21_, _tmp22_, "text", 0, NULL);
	_tmp23_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (renderer);
	renderer = (GtkCellRenderer*) _tmp23_;
	_tmp24_ = self->priv->initial_input_mode_combobox;
	_tmp25_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp24_, _tmp25_, FALSE);
	_tmp26_ = self->priv->initial_input_mode_combobox;
	_tmp27_ = renderer;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp26_, _tmp27_, "text", 0, NULL);
	_tmp28_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (renderer);
	renderer = (GtkCellRenderer*) _tmp28_;
	_tmp29_ = renderer;
	_tmp30_ = gtk_tree_view_column_new_with_attributes ("Mode", _tmp29_, "text", 0, NULL);
	g_object_ref_sink (_tmp30_);
	_g_object_unref0 (column);
	column = _tmp30_;
	_tmp31_ = self->priv->input_mode_treeview;
	_tmp32_ = column;
	gtk_tree_view_append_column (_tmp31_, _tmp32_);
	_tmp33_ = self->priv->input_mode_treeview;
	_tmp34_ = gtk_tree_view_get_selection (_tmp33_);
	_tmp35_ = _g_object_ref0 (_tmp34_);
	_data1_->input_mode_selection = _tmp35_;
	_tmp36_ = _data1_->input_mode_selection;
	g_signal_connect_data (_tmp36_, "changed", (GCallback) ___lambda4__gtk_tree_selection_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp37_ = gtk_list_store_new (3, G_TYPE_STRING, KKC_TYPE_KEY_EVENT, G_TYPE_STRING, -1);
	_g_object_unref0 (model);
	model = _tmp37_;
	_tmp38_ = model;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp38_, 0, GTK_SORT_ASCENDING);
	_tmp39_ = self->priv->shortcut_treeview;
	_tmp40_ = model;
	gtk_tree_view_set_model (_tmp39_, (GtkTreeModel*) _tmp40_);
	_tmp41_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp41_);
	_g_object_unref0 (renderer);
	renderer = (GtkCellRenderer*) _tmp41_;
	_tmp42_ = renderer;
	_tmp43_ = gtk_tree_view_column_new_with_attributes ("Command", _tmp42_, "text", 2, NULL);
	g_object_ref_sink (_tmp43_);
	_g_object_unref0 (column);
	column = _tmp43_;
	_tmp44_ = self->priv->shortcut_treeview;
	_tmp45_ = column;
	gtk_tree_view_append_column (_tmp44_, _tmp45_);
	_tmp46_ = setup_dialog_key_event_cell_renderer_new ();
	g_object_ref_sink (_tmp46_);
	accel_renderer = _tmp46_;
	_tmp47_ = accel_renderer;
	g_object_set ((GObject*) _tmp47_, "editable", TRUE, "accel-mode", GTK_CELL_RENDERER_ACCEL_MODE_OTHER, NULL, NULL);
	_tmp48_ = accel_renderer;
	_tmp49_ = gtk_tree_view_column_new_with_attributes ("Shortcut", (GtkCellRenderer*) _tmp48_, "event", 1, NULL);
	g_object_ref_sink (_tmp49_);
	_g_object_unref0 (column);
	column = _tmp49_;
	_tmp50_ = self->priv->shortcut_treeview;
	_tmp51_ = column;
	gtk_tree_view_append_column (_tmp50_, _tmp51_);
	_tmp52_ = accel_renderer;
	g_signal_connect_object ((GtkCellRendererAccel*) _tmp52_, "accel-edited", (GCallback) _setup_dialog_accel_edited_gtk_cell_renderer_accel_accel_edited, self, 0);
	_tmp53_ = accel_renderer;
	g_signal_connect_object ((GtkCellRendererAccel*) _tmp53_, "accel-cleared", (GCallback) _setup_dialog_accel_cleared_gtk_cell_renderer_accel_accel_cleared, self, 0);
	_tmp54_ = self->priv->shortcut_treeview;
	_tmp55_ = gtk_tree_view_get_selection (_tmp54_);
	_tmp56_ = _g_object_ref0 (_tmp55_);
	_data1_->shortcut_selection = _tmp56_;
	_tmp57_ = _data1_->shortcut_selection;
	g_signal_connect_data (_tmp57_, "changed", (GCallback) ___lambda5__gtk_tree_selection_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp58_ = self->priv->add_shortcut_toolbutton;
	g_signal_connect_object (_tmp58_, "clicked", (GCallback) _setup_dialog_add_shortcut_gtk_tool_button_clicked, self, 0);
	_tmp59_ = self->priv->remove_shortcut_toolbutton;
	g_signal_connect_object (_tmp59_, "clicked", (GCallback) _setup_dialog_remove_shortcut_gtk_tool_button_clicked, self, 0);
	_tmp60_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING, -1);
	_g_object_unref0 (model);
	model = _tmp60_;
	_tmp61_ = model;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp61_, 1, GTK_SORT_ASCENDING);
	_tmp62_ = self->priv->typing_rule_combobox;
	_tmp63_ = model;
	gtk_combo_box_set_model (_tmp62_, (GtkTreeModel*) _tmp63_);
	_tmp65_ = kkc_rule_list (&_tmp64_);
	rules = _tmp65_;
	rules_length1 = _tmp64_;
	_rules_size_ = rules_length1;
	_tmp66_ = rules;
	_tmp66__length1 = rules_length1;
	{
		KkcRuleMetadata** rule_collection = NULL;
		gint rule_collection_length1 = 0;
		gint _rule_collection_size_ = 0;
		gint rule_it = 0;
		rule_collection = _tmp66_;
		rule_collection_length1 = _tmp66__length1;
		for (rule_it = 0; rule_it < _tmp66__length1; rule_it = rule_it + 1) {
			KkcRuleMetadata* _tmp67_ = NULL;
			KkcRuleMetadata* rule = NULL;
			_tmp67_ = _g_object_ref0 (rule_collection[rule_it]);
			rule = _tmp67_;
			{
				KkcRuleMetadata* _tmp68_ = NULL;
				gint _tmp69_ = 0;
				gint _tmp70_ = 0;
				_tmp68_ = rule;
				_tmp69_ = kkc_rule_metadata_get_priority (_tmp68_);
				_tmp70_ = _tmp69_;
				if (_tmp70_ > 70) {
					GtkTreeIter iter = {0};
					GtkListStore* _tmp71_ = NULL;
					GtkTreeIter _tmp72_ = {0};
					GtkListStore* _tmp73_ = NULL;
					GtkTreeIter _tmp74_ = {0};
					KkcRuleMetadata* _tmp75_ = NULL;
					const gchar* _tmp76_ = NULL;
					const gchar* _tmp77_ = NULL;
					KkcRuleMetadata* _tmp78_ = NULL;
					const gchar* _tmp79_ = NULL;
					const gchar* _tmp80_ = NULL;
					_tmp71_ = model;
					gtk_list_store_append (_tmp71_, &_tmp72_);
					iter = _tmp72_;
					_tmp73_ = model;
					_tmp74_ = iter;
					_tmp75_ = rule;
					_tmp76_ = kkc_metadata_file_get_name ((KkcMetadataFile*) _tmp75_);
					_tmp77_ = _tmp76_;
					_tmp78_ = rule;
					_tmp79_ = kkc_metadata_file_get_label ((KkcMetadataFile*) _tmp78_);
					_tmp80_ = _tmp79_;
					gtk_list_store_set (_tmp73_, &_tmp74_, 0, _tmp77_, 1, _tmp80_, -1);
				}
				_g_object_unref0 (rule);
			}
		}
	}
	_tmp81_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp81_);
	_g_object_unref0 (renderer);
	renderer = (GtkCellRenderer*) _tmp81_;
	_tmp82_ = self->priv->typing_rule_combobox;
	_tmp83_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp82_, _tmp83_, FALSE);
	_tmp84_ = self->priv->typing_rule_combobox;
	_tmp85_ = renderer;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp84_, _tmp85_, "text", 1, NULL);
	_tmp86_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp86_);
	_g_object_unref0 (renderer);
	renderer = (GtkCellRenderer*) _tmp86_;
	_tmp87_ = self->priv->keymap_combobox;
	_tmp88_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp87_, _tmp88_, FALSE);
	_tmp89_ = self->priv->keymap_combobox;
	_tmp90_ = renderer;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp89_, _tmp90_, "text", 1, NULL);
	_tmp91_ = self->priv->use_custom_keymap_checkbutton;
	g_signal_connect_object ((GtkToggleButton*) _tmp91_, "toggled", (GCallback) ___lambda6__gtk_toggle_button_toggled, self, 0);
	setup_dialog_load (self);
	_tmp92_ = self->priv->add_dict_toolbutton;
	g_signal_connect_object (_tmp92_, "clicked", (GCallback) _setup_dialog_add_dict_gtk_tool_button_clicked, self, 0);
	_tmp93_ = self->priv->remove_dict_toolbutton;
	g_signal_connect_object (_tmp93_, "clicked", (GCallback) _setup_dialog_remove_dict_gtk_tool_button_clicked, self, 0);
	_tmp94_ = self->priv->up_dict_toolbutton;
	g_signal_connect_object (_tmp94_, "clicked", (GCallback) _setup_dialog_up_dict_gtk_tool_button_clicked, self, 0);
	_tmp95_ = self->priv->down_dict_toolbutton;
	g_signal_connect_object (_tmp95_, "clicked", (GCallback) _setup_dialog_down_dict_gtk_tool_button_clicked, self, 0);
	_tmp96_ = self->priv->dictionaries_treeview;
	_tmp97_ = gtk_tree_view_get_selection (_tmp96_);
	_tmp98_ = _g_object_ref0 (_tmp97_);
	_data1_->dictionaries_selection = _tmp98_;
	g_signal_connect_data (_data1_->dictionaries_selection, "changed", (GCallback) ___lambda11__gtk_tree_selection_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	rules = (_vala_array_free (rules, rules_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (accel_renderer);
	_g_object_unref0 (column);
	_g_object_unref0 (renderer);
	_g_object_unref0 (model);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return self;
}


SetupDialog* setup_dialog_new (Preferences* preferences) {
	return setup_dialog_construct (TYPE_SETUP_DIALOG, preferences);
}


static void setup_dialog_accel_edited (SetupDialog* self, const gchar* path_string, guint keyval, GdkModifierType modifiers, guint keycode) {
	GtkTreeIter iter = {0};
	GtkListStore* model = NULL;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkListStore* _tmp2_ = NULL;
	GtkListStore* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path_string != NULL);
	_tmp0_ = self->priv->shortcut_treeview;
	_tmp1_ = gtk_tree_view_get_model (_tmp0_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_list_store_get_type (), GtkListStore));
	model = _tmp2_;
	_tmp3_ = model;
	_tmp4_ = path_string;
	_tmp6_ = gtk_tree_model_get_iter_from_string ((GtkTreeModel*) _tmp3_, &_tmp5_, _tmp4_);
	iter = _tmp5_;
	if (_tmp6_) {
		KkcKeyEvent* new_event = NULL;
		guint _tmp7_ = 0U;
		guint _tmp8_ = 0U;
		GdkModifierType _tmp9_ = 0;
		KkcKeyEvent* _tmp10_ = NULL;
		KkcKeymap* keymap = NULL;
		KkcUserRule* _tmp11_ = NULL;
		KkcInputMode _tmp12_ = 0;
		KkcKeymap* _tmp13_ = NULL;
		gchar* old_command = NULL;
		KkcKeymap* _tmp14_ = NULL;
		KkcKeyEvent* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		_tmp7_ = keyval;
		_tmp8_ = keycode;
		_tmp9_ = modifiers;
		_tmp10_ = kkc_key_event_new_from_x_event (_tmp7_, _tmp8_, (KkcModifierType) _tmp9_);
		new_event = _tmp10_;
		_tmp11_ = self->priv->shortcut_rule;
		_tmp12_ = self->priv->shortcut_input_mode;
		_tmp13_ = kkc_rule_get_keymap ((KkcRule*) _tmp11_, _tmp12_);
		keymap = _tmp13_;
		_tmp14_ = keymap;
		_tmp15_ = new_event;
		_tmp16_ = kkc_keymap_lookup_key (_tmp14_, _tmp15_);
		old_command = _tmp16_;
		_tmp17_ = old_command;
		if (_tmp17_ != NULL) {
			gchar* new_command = NULL;
			GtkListStore* _tmp18_ = NULL;
			GtkTreeIter _tmp19_ = {0};
			const gchar* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			_tmp18_ = model;
			_tmp19_ = iter;
			gtk_tree_model_get ((GtkTreeModel*) _tmp18_, &_tmp19_, 0, &new_command, -1, -1);
			_tmp20_ = old_command;
			_tmp21_ = new_command;
			if (g_strcmp0 (_tmp20_, _tmp21_) != 0) {
				GtkMessageDialog* error_dialog = NULL;
				const gchar* _tmp22_ = NULL;
				KkcKeyEvent* _tmp23_ = NULL;
				gchar* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
				const gchar* _tmp26_ = NULL;
				GtkMessageDialog* _tmp27_ = NULL;
				GtkMessageDialog* _tmp28_ = NULL;
				GtkMessageDialog* _tmp29_ = NULL;
				GtkMessageDialog* _tmp30_ = NULL;
				_tmp22_ = _ ("Shortcut '%s' is already assigned to '%s'");
				_tmp23_ = new_event;
				_tmp24_ = kkc_key_event_to_string (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = old_command;
				_tmp27_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _tmp22_, _tmp25_, _tmp26_);
				g_object_ref_sink (_tmp27_);
				_tmp28_ = _tmp27_;
				_g_free0 (_tmp25_);
				error_dialog = _tmp28_;
				_tmp29_ = error_dialog;
				gtk_dialog_run ((GtkDialog*) _tmp29_);
				_tmp30_ = error_dialog;
				gtk_widget_destroy ((GtkWidget*) _tmp30_);
				_g_object_unref0 (error_dialog);
			}
			_g_free0 (new_command);
		} else {
			gchar* new_command = NULL;
			KkcKeyEvent* old_event = NULL;
			GtkListStore* _tmp31_ = NULL;
			GtkTreeIter _tmp32_ = {0};
			KkcKeyEvent* _tmp33_ = NULL;
			KkcKeymap* _tmp36_ = NULL;
			KkcKeyEvent* _tmp37_ = NULL;
			const gchar* _tmp38_ = NULL;
			GtkListStore* _tmp43_ = NULL;
			GtkTreeIter _tmp44_ = {0};
			KkcKeyEvent* _tmp45_ = NULL;
			GtkComboBox* _tmp46_ = NULL;
			_tmp31_ = model;
			_tmp32_ = iter;
			gtk_tree_model_get ((GtkTreeModel*) _tmp31_, &_tmp32_, 0, &new_command, 1, &old_event, -1, -1);
			_tmp33_ = old_event;
			if (_tmp33_ != NULL) {
				KkcKeymap* _tmp34_ = NULL;
				KkcKeyEvent* _tmp35_ = NULL;
				_tmp34_ = keymap;
				_tmp35_ = old_event;
				kkc_keymap_set (_tmp34_, _tmp35_, NULL);
			}
			_tmp36_ = keymap;
			_tmp37_ = new_event;
			_tmp38_ = new_command;
			kkc_keymap_set (_tmp36_, _tmp37_, _tmp38_);
			{
				KkcUserRule* _tmp39_ = NULL;
				KkcInputMode _tmp40_ = 0;
				_tmp39_ = self->priv->shortcut_rule;
				_tmp40_ = self->priv->shortcut_input_mode;
				kkc_user_rule_write (_tmp39_, _tmp40_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp41_ = NULL;
				const gchar* _tmp42_ = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp41_ = e;
				_tmp42_ = _tmp41_->message;
				g_warning ("setup.vala:381: can't write shortcut: %s", _tmp42_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (new_command);
				_g_free0 (old_command);
				_g_object_unref0 (keymap);
				_g_object_unref0 (new_event);
				_g_object_unref0 (model);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp43_ = model;
			_tmp44_ = iter;
			_tmp45_ = new_event;
			gtk_list_store_set (_tmp43_, &_tmp44_, 1, _tmp45_, -1, -1);
			_tmp46_ = self->priv->typing_rule_combobox;
			g_signal_emit_by_name (_tmp46_, "changed");
			_g_free0 (new_command);
		}
		_g_free0 (old_command);
		_g_object_unref0 (keymap);
		_g_object_unref0 (new_event);
	}
	_g_object_unref0 (model);
}


static void setup_dialog_accel_cleared (SetupDialog* self, const gchar* path_string) {
	GtkTreeIter iter = {0};
	GtkListStore* model = NULL;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkListStore* _tmp2_ = NULL;
	GtkListStore* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path_string != NULL);
	_tmp0_ = self->priv->shortcut_treeview;
	_tmp1_ = gtk_tree_view_get_model (_tmp0_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_list_store_get_type (), GtkListStore));
	model = _tmp2_;
	_tmp3_ = model;
	_tmp4_ = path_string;
	_tmp6_ = gtk_tree_model_get_iter_from_string ((GtkTreeModel*) _tmp3_, &_tmp5_, _tmp4_);
	iter = _tmp5_;
	if (_tmp6_) {
		KkcKeyEvent* old_event = NULL;
		GtkListStore* _tmp7_ = NULL;
		GtkTreeIter _tmp8_ = {0};
		KkcKeymap* keymap = NULL;
		KkcUserRule* _tmp9_ = NULL;
		KkcInputMode _tmp10_ = 0;
		KkcKeymap* _tmp11_ = NULL;
		KkcKeyEvent* _tmp12_ = NULL;
		GtkListStore* _tmp19_ = NULL;
		GtkTreeIter _tmp20_ = {0};
		_tmp7_ = model;
		_tmp8_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp7_, &_tmp8_, 1, &old_event, -1, -1);
		_tmp9_ = self->priv->shortcut_rule;
		_tmp10_ = self->priv->shortcut_input_mode;
		_tmp11_ = kkc_rule_get_keymap ((KkcRule*) _tmp9_, _tmp10_);
		keymap = _tmp11_;
		_tmp12_ = old_event;
		if (_tmp12_ != NULL) {
			KkcKeymap* _tmp13_ = NULL;
			KkcKeyEvent* _tmp14_ = NULL;
			_tmp13_ = keymap;
			_tmp14_ = old_event;
			kkc_keymap_set (_tmp13_, _tmp14_, NULL);
		}
		{
			KkcUserRule* _tmp15_ = NULL;
			KkcInputMode _tmp16_ = 0;
			_tmp15_ = self->priv->shortcut_rule;
			_tmp16_ = self->priv->shortcut_input_mode;
			kkc_user_rule_write (_tmp15_, _tmp16_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp17_ = e;
			_tmp18_ = _tmp17_->message;
			g_warning ("setup.vala:403: can't write shortcut: %s", _tmp18_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (keymap);
			_g_object_unref0 (model);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp19_ = model;
		_tmp20_ = iter;
		gtk_list_store_remove (_tmp19_, &_tmp20_);
		_g_object_unref0 (keymap);
	}
	_g_object_unref0 (model);
}


static void setup_dialog_add_shortcut (SetupDialog* self) {
	ShortcutDialog* shortcut_dialog = NULL;
	ShortcutDialog* _tmp0_ = NULL;
	ShortcutDialog* _tmp1_ = NULL;
	ShortcutDialog* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	ShortcutDialog* _tmp17_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = shortcut_dialog_new ();
	g_object_ref_sink (_tmp0_);
	shortcut_dialog = _tmp0_;
	_tmp1_ = shortcut_dialog;
	gtk_window_set_transient_for ((GtkWindow*) _tmp1_, (GtkWindow*) self);
	_tmp2_ = shortcut_dialog;
	_tmp3_ = gtk_dialog_run ((GtkDialog*) _tmp2_);
	if (_tmp3_ == ((gint) GTK_RESPONSE_OK)) {
		gchar* command = NULL;
		ShortcutDialog* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GtkTreeIter iter = {0};
		GtkListStore* model = NULL;
		GtkTreeView* _tmp6_ = NULL;
		GtkTreeModel* _tmp7_ = NULL;
		GtkListStore* _tmp8_ = NULL;
		GtkListStore* _tmp9_ = NULL;
		GtkTreeIter _tmp10_ = {0};
		GtkListStore* _tmp11_ = NULL;
		GtkTreeIter _tmp12_ = {0};
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		_tmp4_ = shortcut_dialog;
		_tmp5_ = shortcut_dialog_get_command (_tmp4_);
		command = _tmp5_;
		_tmp6_ = self->priv->shortcut_treeview;
		_tmp7_ = gtk_tree_view_get_model (_tmp6_);
		_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_list_store_get_type (), GtkListStore));
		model = _tmp8_;
		_tmp9_ = model;
		gtk_list_store_append (_tmp9_, &_tmp10_);
		iter = _tmp10_;
		_tmp11_ = model;
		_tmp12_ = iter;
		_tmp13_ = command;
		_tmp14_ = command;
		_tmp15_ = kkc_keymap_get_command_label (_tmp14_);
		_tmp16_ = _tmp15_;
		gtk_list_store_set (_tmp11_, &_tmp12_, 0, _tmp13_, 1, NULL, 2, _tmp16_, -1, -1);
		_g_free0 (_tmp16_);
		_g_object_unref0 (model);
		_g_free0 (command);
	}
	_tmp17_ = shortcut_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp17_);
	_g_object_unref0 (shortcut_dialog);
}


static gboolean _vala_uint_array_contains (guint* stack, int stack_length, guint needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}


static void setup_dialog_remove_shortcut (SetupDialog* self) {
	GtkTreeSelection* selection = NULL;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_ = NULL;
	GtkTreeModel* model = NULL;
	GList* rows = NULL;
	GtkTreeSelection* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	GtkTreeModel* _tmp6_ = NULL;
	KkcKeymap* keymap = NULL;
	KkcUserRule* _tmp7_ = NULL;
	KkcInputMode _tmp8_ = 0;
	KkcKeymap* _tmp9_ = NULL;
	GList* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->shortcut_treeview;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	selection = _tmp2_;
	_tmp3_ = selection;
	_tmp5_ = gtk_tree_selection_get_selected_rows (_tmp3_, &_tmp4_);
	_g_object_unref0 (model);
	_tmp6_ = _g_object_ref0 (_tmp4_);
	model = _tmp6_;
	rows = _tmp5_;
	_tmp7_ = self->priv->shortcut_rule;
	_tmp8_ = self->priv->shortcut_input_mode;
	_tmp9_ = kkc_rule_get_keymap ((KkcRule*) _tmp7_, _tmp8_);
	keymap = _tmp9_;
	_tmp10_ = rows;
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp10_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkTreePath* _tmp11_ = NULL;
			GtkTreePath* row = NULL;
			_tmp11_ = _gtk_tree_path_copy0 ((GtkTreePath*) row_it->data);
			row = _tmp11_;
			{
				GtkTreeIter iter = {0};
				GtkTreeModel* _tmp12_ = NULL;
				GtkTreePath* _tmp13_ = NULL;
				GtkTreeIter _tmp14_ = {0};
				gboolean _tmp15_ = FALSE;
				_tmp12_ = model;
				_tmp13_ = row;
				_tmp15_ = gtk_tree_model_get_iter (_tmp12_, &_tmp14_, _tmp13_);
				iter = _tmp14_;
				if (_tmp15_) {
					KkcKeyEvent* old_event = NULL;
					GtkTreeModel* _tmp16_ = NULL;
					GtkTreeIter _tmp17_ = {0};
					KkcKeyEvent* _tmp18_ = NULL;
					GtkTreeModel* _tmp28_ = NULL;
					GtkTreeIter _tmp29_ = {0};
					_tmp16_ = model;
					_tmp17_ = iter;
					gtk_tree_model_get (_tmp16_, &_tmp17_, 1, &old_event, -1, -1);
					_tmp18_ = old_event;
					if (_tmp18_ != NULL) {
						gboolean _tmp19_ = FALSE;
						KkcKeyEvent* _tmp20_ = NULL;
						KkcModifierType _tmp21_ = 0;
						KkcModifierType _tmp22_ = 0;
						KkcKeymap* _tmp26_ = NULL;
						KkcKeyEvent* _tmp27_ = NULL;
						_tmp20_ = old_event;
						_tmp21_ = kkc_key_event_get_modifiers (_tmp20_);
						_tmp22_ = _tmp21_;
						if (_tmp22_ == 0) {
							KkcKeyEvent* _tmp23_ = NULL;
							guint _tmp24_ = 0U;
							guint _tmp25_ = 0U;
							_tmp23_ = old_event;
							_tmp24_ = kkc_key_event_get_keyval (_tmp23_);
							_tmp25_ = _tmp24_;
							_tmp19_ = _vala_uint_array_contains (SETUP_DIALOG_IGNORED_KEYVALS, G_N_ELEMENTS (SETUP_DIALOG_IGNORED_KEYVALS), _tmp25_);
						} else {
							_tmp19_ = FALSE;
						}
						if (_tmp19_) {
							_gtk_tree_path_free0 (row);
							continue;
						}
						_tmp26_ = keymap;
						_tmp27_ = old_event;
						kkc_keymap_set (_tmp26_, _tmp27_, NULL);
					}
					_tmp28_ = model;
					_tmp29_ = iter;
					gtk_list_store_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_list_store_get_type (), GtkListStore), &_tmp29_);
				}
				_gtk_tree_path_free0 (row);
			}
		}
	}
	{
		KkcUserRule* _tmp30_ = NULL;
		KkcInputMode _tmp31_ = 0;
		_tmp30_ = self->priv->shortcut_rule;
		_tmp31_ = self->priv->shortcut_input_mode;
		kkc_user_rule_write (_tmp30_, _tmp31_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp32_ = e;
		_tmp33_ = _tmp32_->message;
		g_warning ("setup.vala:448: can't write shortcut: %s", _tmp33_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (keymap);
		__g_list_free__gtk_tree_path_free0_0 (rows);
		_g_object_unref0 (model);
		_g_object_unref0 (selection);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (keymap);
	__g_list_free__gtk_tree_path_free0_0 (rows);
	_g_object_unref0 (model);
	_g_object_unref0 (selection);
}


static void setup_dialog_populate_dictionaries_treeview (SetupDialog* self) {
	GVariant* variant = NULL;
	Preferences* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	gchar** strv = NULL;
	GVariant* _tmp3_ = NULL;
	size_t _tmp4_;
	gchar** _tmp5_ = NULL;
	gint strv_length1 = 0;
	gint _strv_size_ = 0;
	GtkListStore* model = NULL;
	GtkTreeView* _tmp6_ = NULL;
	GtkTreeModel* _tmp7_ = NULL;
	GtkListStore* _tmp8_ = NULL;
	gchar** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preferences;
	_tmp1_ = preferences_get (_tmp0_, "system_dictionaries");
	variant = _tmp1_;
	_tmp2_ = variant;
	_vala_assert (_tmp2_ != NULL, "variant != null");
	_tmp3_ = variant;
	_tmp5_ = g_variant_dup_strv (_tmp3_, &_tmp4_);
	strv = _tmp5_;
	strv_length1 = _tmp4_;
	_strv_size_ = strv_length1;
	_tmp6_ = self->priv->dictionaries_treeview;
	_tmp7_ = gtk_tree_view_get_model (_tmp6_);
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_list_store_get_type (), GtkListStore));
	model = _tmp8_;
	_tmp9_ = strv;
	_tmp9__length1 = strv_length1;
	{
		gchar** id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp9_;
		id_collection_length1 = _tmp9__length1;
		for (id_it = 0; id_it < _tmp9__length1; id_it = id_it + 1) {
			gchar* _tmp10_ = NULL;
			gchar* id = NULL;
			_tmp10_ = g_strdup (id_collection[id_it]);
			id = _tmp10_;
			{
				DictionaryMetadata* metadata = NULL;
				Preferences* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				DictionaryMetadata* _tmp13_ = NULL;
				DictionaryMetadata* _tmp14_ = NULL;
				_tmp11_ = self->priv->preferences;
				_tmp12_ = id;
				_tmp13_ = preferences_get_dictionary_metadata (_tmp11_, _tmp12_);
				metadata = _tmp13_;
				_tmp14_ = metadata;
				if (_tmp14_ != NULL) {
					GtkTreeIter iter = {0};
					GtkListStore* _tmp15_ = NULL;
					GtkTreeIter _tmp16_ = {0};
					GtkListStore* _tmp17_ = NULL;
					GtkTreeIter _tmp18_ = {0};
					DictionaryMetadata* _tmp19_ = NULL;
					DictionaryMetadata* _tmp20_ = NULL;
					const gchar* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					const gchar* _tmp23_ = NULL;
					_tmp15_ = model;
					gtk_list_store_append (_tmp15_, &_tmp16_);
					iter = _tmp16_;
					_tmp17_ = model;
					_tmp18_ = iter;
					_tmp19_ = metadata;
					_tmp20_ = metadata;
					_tmp21_ = dictionary_metadata_get_description (_tmp20_);
					_tmp22_ = _tmp21_;
					_tmp23_ = g_dgettext (NULL, _tmp22_);
					gtk_list_store_set (_tmp17_, &_tmp18_, 0, _tmp19_, 1, _tmp23_, -1);
				}
				_g_object_unref0 (metadata);
				_g_free0 (id);
			}
		}
	}
	_g_object_unref0 (model);
	strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
	_g_variant_unref0 (variant);
}


static void _vala_KkcKeymapEntry_array_free (KkcKeymapEntry* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			kkc_keymap_entry_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void setup_dialog_populate_shortcut_treeview (SetupDialog* self, KkcInputMode input_mode) {
	GVariant* variant = NULL;
	Preferences* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	KkcRuleMetadata* parent_metadata = NULL;
	const gchar* _tmp2_ = NULL;
	KkcRuleMetadata* _tmp3_ = NULL;
	gchar* base_dir = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	KkcUserRule* rule = NULL;
	GtkListStore* model = NULL;
	GtkTreeView* _tmp11_ = NULL;
	GtkTreeModel* _tmp12_ = NULL;
	GtkListStore* _tmp13_ = NULL;
	GtkListStore* _tmp14_ = NULL;
	KkcKeymapEntry* entries = NULL;
	KkcInputMode _tmp15_ = 0;
	KkcKeymap* _tmp16_ = NULL;
	KkcKeymap* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	KkcKeymapEntry* _tmp19_ = NULL;
	KkcKeymapEntry* _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gint entries_length1 = 0;
	gint _entries_size_ = 0;
	KkcKeymapEntry* _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	KkcInputMode _tmp37_ = 0;
	KkcUserRule* _tmp38_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preferences;
	_tmp1_ = preferences_get (_tmp0_, "typing_rule");
	variant = _tmp1_;
	_vala_assert (variant != NULL, "variant != null");
	_tmp2_ = g_variant_get_string (variant, NULL);
	_tmp3_ = kkc_rule_metadata_find (_tmp2_);
	parent_metadata = _tmp3_;
	_vala_assert (parent_metadata != NULL, "parent_metadata != null");
	_tmp4_ = g_get_user_config_dir ();
	_tmp5_ = g_build_filename (_tmp4_, "ibus-kkc", "rules", NULL);
	base_dir = _tmp5_;
	{
		KkcUserRule* _tmp6_ = NULL;
		KkcUserRule* _tmp7_ = NULL;
		KkcUserRule* _tmp8_ = NULL;
		_tmp7_ = kkc_user_rule_new (parent_metadata, base_dir, "ibus-kkc", &_inner_error_);
		_tmp6_ = _tmp7_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
		_tmp8_ = _tmp6_;
		_tmp6_ = NULL;
		_g_object_unref0 (rule);
		rule = _tmp8_;
		_g_object_unref0 (_tmp6_);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = g_variant_get_string (variant, NULL);
		_tmp10_ = e->message;
		g_error ("setup.vala:484: can't load typing rule %s: %s", _tmp9_, _tmp10_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (rule);
		_g_free0 (base_dir);
		_g_object_unref0 (parent_metadata);
		_g_variant_unref0 (variant);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp11_ = self->priv->shortcut_treeview;
	_tmp12_ = gtk_tree_view_get_model (_tmp11_);
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_list_store_get_type (), GtkListStore));
	model = _tmp13_;
	_tmp14_ = model;
	gtk_list_store_clear (_tmp14_);
	_tmp15_ = input_mode;
	_tmp16_ = kkc_rule_get_keymap ((KkcRule*) rule, _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp19_ = kkc_keymap_entries (_tmp17_, &_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp20__length1 = _tmp18_;
	_g_object_unref0 (_tmp17_);
	entries = _tmp20_;
	entries_length1 = _tmp20__length1;
	_entries_size_ = entries_length1;
	_tmp21_ = entries;
	_tmp21__length1 = entries_length1;
	{
		KkcKeymapEntry* entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = _tmp21_;
		entry_collection_length1 = _tmp21__length1;
		for (entry_it = 0; entry_it < _tmp21__length1; entry_it = entry_it + 1) {
			KkcKeymapEntry _tmp22_ = {0};
			KkcKeymapEntry entry = {0};
			kkc_keymap_entry_copy (&entry_collection[entry_it], &_tmp22_);
			entry = _tmp22_;
			{
				KkcKeymapEntry _tmp23_ = {0};
				const gchar* _tmp24_ = NULL;
				_tmp23_ = entry;
				_tmp24_ = _tmp23_.command;
				if (_tmp24_ != NULL) {
					GtkTreeIter iter = {0};
					GtkListStore* _tmp25_ = NULL;
					GtkTreeIter _tmp26_ = {0};
					GtkListStore* _tmp27_ = NULL;
					GtkTreeIter _tmp28_ = {0};
					KkcKeymapEntry _tmp29_ = {0};
					const gchar* _tmp30_ = NULL;
					KkcKeymapEntry _tmp31_ = {0};
					KkcKeyEvent* _tmp32_ = NULL;
					KkcKeymapEntry _tmp33_ = {0};
					const gchar* _tmp34_ = NULL;
					gchar* _tmp35_ = NULL;
					gchar* _tmp36_ = NULL;
					_tmp25_ = model;
					gtk_list_store_append (_tmp25_, &_tmp26_);
					iter = _tmp26_;
					_tmp27_ = model;
					_tmp28_ = iter;
					_tmp29_ = entry;
					_tmp30_ = _tmp29_.command;
					_tmp31_ = entry;
					_tmp32_ = _tmp31_.key;
					_tmp33_ = entry;
					_tmp34_ = _tmp33_.command;
					_tmp35_ = kkc_keymap_get_command_label (_tmp34_);
					_tmp36_ = _tmp35_;
					gtk_list_store_set (_tmp27_, &_tmp28_, 0, _tmp30_, 1, _tmp32_, 2, _tmp36_, -1);
					_g_free0 (_tmp36_);
				}
				kkc_keymap_entry_destroy (&entry);
			}
		}
	}
	_tmp37_ = input_mode;
	self->priv->shortcut_input_mode = _tmp37_;
	_tmp38_ = _g_object_ref0 (rule);
	_g_object_unref0 (self->priv->shortcut_rule);
	self->priv->shortcut_rule = _tmp38_;
	entries = (_vala_KkcKeymapEntry_array_free (entries, entries_length1), NULL);
	_g_object_unref0 (model);
	_g_object_unref0 (rule);
	_g_free0 (base_dir);
	_g_object_unref0 (parent_metadata);
	_g_variant_unref0 (variant);
}


static void setup_dialog_add_dict (SetupDialog* self) {
	DictionaryDialog* dictionary_dialog = NULL;
	Preferences* _tmp0_ = NULL;
	DictionaryDialog* _tmp1_ = NULL;
	DictionaryDialog* _tmp2_ = NULL;
	DictionaryDialog* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	DictionaryDialog* _tmp18_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preferences;
	_tmp1_ = dictionary_dialog_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	dictionary_dialog = _tmp1_;
	_tmp2_ = dictionary_dialog;
	gtk_window_set_transient_for ((GtkWindow*) _tmp2_, (GtkWindow*) self);
	_tmp3_ = dictionary_dialog;
	_tmp4_ = gtk_dialog_run ((GtkDialog*) _tmp3_);
	if (_tmp4_ == ((gint) GTK_RESPONSE_OK)) {
		DictionaryMetadata** dictionaries = NULL;
		DictionaryDialog* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		DictionaryMetadata** _tmp7_ = NULL;
		gint dictionaries_length1 = 0;
		gint _dictionaries_size_ = 0;
		GtkListStore* model = NULL;
		GtkTreeView* _tmp8_ = NULL;
		GtkTreeModel* _tmp9_ = NULL;
		GtkListStore* _tmp10_ = NULL;
		DictionaryMetadata** _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		_tmp5_ = dictionary_dialog;
		_tmp7_ = dictionary_dialog_get_dictionaries (_tmp5_, &_tmp6_);
		dictionaries = _tmp7_;
		dictionaries_length1 = _tmp6_;
		_dictionaries_size_ = dictionaries_length1;
		_tmp8_ = self->priv->dictionaries_treeview;
		_tmp9_ = gtk_tree_view_get_model (_tmp8_);
		_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_list_store_get_type (), GtkListStore));
		model = _tmp10_;
		_tmp11_ = dictionaries;
		_tmp11__length1 = dictionaries_length1;
		{
			DictionaryMetadata** dictionary_collection = NULL;
			gint dictionary_collection_length1 = 0;
			gint _dictionary_collection_size_ = 0;
			gint dictionary_it = 0;
			dictionary_collection = _tmp11_;
			dictionary_collection_length1 = _tmp11__length1;
			for (dictionary_it = 0; dictionary_it < _tmp11__length1; dictionary_it = dictionary_it + 1) {
				DictionaryMetadata* _tmp12_ = NULL;
				DictionaryMetadata* dictionary = NULL;
				_tmp12_ = _g_object_ref0 (dictionary_collection[dictionary_it]);
				dictionary = _tmp12_;
				{
					GtkTreeIter iter = {0};
					GtkListStore* _tmp13_ = NULL;
					GtkTreeIter _tmp14_ = {0};
					GtkListStore* _tmp15_ = NULL;
					GtkTreeIter _tmp16_ = {0};
					DictionaryMetadata* _tmp17_ = NULL;
					_tmp13_ = model;
					gtk_list_store_append (_tmp13_, &_tmp14_);
					iter = _tmp14_;
					_tmp15_ = model;
					_tmp16_ = iter;
					_tmp17_ = dictionary;
					gtk_list_store_set (_tmp15_, &_tmp16_, 0, _tmp17_, -1);
					_g_object_unref0 (dictionary);
				}
			}
		}
		setup_dialog_save_dictionaries (self, "system_dictionaries");
		_g_object_unref0 (model);
		dictionaries = (_vala_array_free (dictionaries, dictionaries_length1, (GDestroyNotify) g_object_unref), NULL);
	}
	_tmp18_ = dictionary_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp18_);
	_g_object_unref0 (dictionary_dialog);
}


static void setup_dialog_remove_dict (SetupDialog* self) {
	GtkTreeSelection* selection = NULL;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_ = NULL;
	GtkTreeModel* model = NULL;
	GList* rows = NULL;
	GtkTreeSelection* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	GtkTreeModel* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dictionaries_treeview;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	selection = _tmp2_;
	_tmp3_ = selection;
	_tmp5_ = gtk_tree_selection_get_selected_rows (_tmp3_, &_tmp4_);
	_g_object_unref0 (model);
	_tmp6_ = _g_object_ref0 (_tmp4_);
	model = _tmp6_;
	rows = _tmp5_;
	_tmp7_ = rows;
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp7_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkTreePath* _tmp8_ = NULL;
			GtkTreePath* row = NULL;
			_tmp8_ = _gtk_tree_path_copy0 ((GtkTreePath*) row_it->data);
			row = _tmp8_;
			{
				GtkTreeIter iter = {0};
				GtkTreeModel* _tmp9_ = NULL;
				GtkTreePath* _tmp10_ = NULL;
				GtkTreeIter _tmp11_ = {0};
				gboolean _tmp12_ = FALSE;
				_tmp9_ = model;
				_tmp10_ = row;
				_tmp12_ = gtk_tree_model_get_iter (_tmp9_, &_tmp11_, _tmp10_);
				iter = _tmp11_;
				if (_tmp12_) {
					GtkTreeModel* _tmp13_ = NULL;
					GtkTreeIter _tmp14_ = {0};
					_tmp13_ = model;
					_tmp14_ = iter;
					gtk_list_store_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_list_store_get_type (), GtkListStore), &_tmp14_);
				}
				_gtk_tree_path_free0 (row);
			}
		}
	}
	setup_dialog_save_dictionaries (self, "system_dictionaries");
	__g_list_free__gtk_tree_path_free0_0 (rows);
	_g_object_unref0 (model);
	_g_object_unref0 (selection);
}


static void setup_dialog_up_dict (SetupDialog* self) {
	GtkTreeSelection* selection = NULL;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_ = NULL;
	GtkTreeModel* model = NULL;
	GtkTreeIter iter = {0};
	GtkTreeSelection* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
	GtkTreeModel* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dictionaries_treeview;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	selection = _tmp2_;
	_tmp3_ = selection;
	_tmp6_ = gtk_tree_selection_get_selected (_tmp3_, &_tmp4_, &_tmp5_);
	_g_object_unref0 (model);
	_tmp7_ = _g_object_ref0 (_tmp4_);
	model = _tmp7_;
	iter = _tmp5_;
	if (_tmp6_) {
		GtkTreeIter prev = {0};
		GtkTreeIter _tmp8_ = {0};
		GtkTreeModel* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		_tmp8_ = iter;
		prev = _tmp8_;
		_tmp9_ = model;
		_tmp10_ = gtk_tree_model_iter_previous (_tmp9_, &prev);
		if (_tmp10_) {
			GtkTreeModel* _tmp11_ = NULL;
			GtkTreeIter _tmp12_ = {0};
			GtkTreeIter _tmp13_ = {0};
			_tmp11_ = model;
			_tmp12_ = iter;
			_tmp13_ = prev;
			gtk_list_store_swap (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_list_store_get_type (), GtkListStore), &_tmp12_, &_tmp13_);
		}
	}
	setup_dialog_save_dictionaries (self, "system_dictionaries");
	_g_object_unref0 (model);
	_g_object_unref0 (selection);
}


static void setup_dialog_down_dict (SetupDialog* self) {
	GtkTreeSelection* selection = NULL;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_ = NULL;
	GtkTreeModel* model = NULL;
	GtkTreeIter iter = {0};
	GtkTreeSelection* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
	GtkTreeModel* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dictionaries_treeview;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	selection = _tmp2_;
	_tmp3_ = selection;
	_tmp6_ = gtk_tree_selection_get_selected (_tmp3_, &_tmp4_, &_tmp5_);
	_g_object_unref0 (model);
	_tmp7_ = _g_object_ref0 (_tmp4_);
	model = _tmp7_;
	iter = _tmp5_;
	if (_tmp6_) {
		GtkTreeIter next = {0};
		GtkTreeIter _tmp8_ = {0};
		GtkTreeModel* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		_tmp8_ = iter;
		next = _tmp8_;
		_tmp9_ = model;
		_tmp10_ = gtk_tree_model_iter_next (_tmp9_, &next);
		if (_tmp10_) {
			GtkTreeModel* _tmp11_ = NULL;
			GtkTreeIter _tmp12_ = {0};
			GtkTreeIter _tmp13_ = {0};
			_tmp11_ = model;
			_tmp12_ = iter;
			_tmp13_ = next;
			gtk_list_store_swap (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_list_store_get_type (), GtkListStore), &_tmp12_, &_tmp13_);
		}
	}
	setup_dialog_save_dictionaries (self, "system_dictionaries");
	_g_object_unref0 (model);
	_g_object_unref0 (selection);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		SetupDialog* self;
		self = _data2_->self;
		_g_free0 (_data2_->name);
		_g_object_unref0 (_data2_->spin);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static GVariant* _variant_new1 (gint value) {
	return g_variant_ref_sink (g_variant_new_int32 (value));
}


static void __lambda10_ (Block2Data* _data2_) {
	SetupDialog* self;
	Preferences* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkSpinButton* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	GVariant* _tmp5_ = NULL;
	self = _data2_->self;
	_tmp0_ = self->priv->preferences;
	_tmp1_ = _data2_->name;
	_tmp2_ = _data2_->spin;
	_tmp3_ = gtk_spin_button_get_value (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _variant_new1 ((gint) _tmp4_);
	preferences_set (_tmp0_, _tmp1_, _tmp5_);
	_g_variant_unref0 (_tmp5_);
}


static void ___lambda10__gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
	__lambda10_ (self);
}


static void setup_dialog_load_spinbutton (SetupDialog* self, const gchar* name, GtkSpinButton* spin) {
	Block2Data* _data2_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GtkSpinButton* _tmp2_ = NULL;
	GtkSpinButton* _tmp3_ = NULL;
	GVariant* variant = NULL;
	Preferences* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GVariant* _tmp6_ = NULL;
	GtkSpinButton* _tmp7_ = NULL;
	gint32 _tmp8_ = 0;
	GtkSpinButton* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (spin != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data2_->name);
	_data2_->name = _tmp1_;
	_tmp2_ = spin;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data2_->spin);
	_data2_->spin = _tmp3_;
	_tmp4_ = self->priv->preferences;
	_tmp5_ = _data2_->name;
	_tmp6_ = preferences_get (_tmp4_, _tmp5_);
	variant = _tmp6_;
	_vala_assert (variant != NULL, "variant != null");
	_tmp7_ = _data2_->spin;
	_tmp8_ = g_variant_get_int32 (variant);
	gtk_spin_button_set_value (_tmp7_, (gdouble) _tmp8_);
	_tmp9_ = _data2_->spin;
	g_signal_connect_data (_tmp9_, "value-changed", (GCallback) ___lambda10__gtk_spin_button_value_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_g_variant_unref0 (variant);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		SetupDialog* self;
		self = _data3_->self;
		_g_free0 (_data3_->name);
		_g_object_unref0 (_data3_->toggle);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static GVariant* _variant_new2 (gboolean value) {
	return g_variant_ref_sink (g_variant_new_boolean (value));
}


static void __lambda9_ (Block3Data* _data3_) {
	SetupDialog* self;
	Preferences* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkToggleButton* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GVariant* _tmp5_ = NULL;
	self = _data3_->self;
	_tmp0_ = self->priv->preferences;
	_tmp1_ = _data3_->name;
	_tmp2_ = _data3_->toggle;
	_tmp3_ = gtk_toggle_button_get_active (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _variant_new2 (_tmp4_);
	preferences_set (_tmp0_, _tmp1_, _tmp5_);
	_g_variant_unref0 (_tmp5_);
}


static void ___lambda9__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	__lambda9_ (self);
}


static void setup_dialog_load_togglebutton (SetupDialog* self, const gchar* name, GtkToggleButton* toggle) {
	Block3Data* _data3_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GtkToggleButton* _tmp2_ = NULL;
	GtkToggleButton* _tmp3_ = NULL;
	GVariant* variant = NULL;
	Preferences* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GVariant* _tmp6_ = NULL;
	GtkToggleButton* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	GtkToggleButton* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (toggle != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data3_->name);
	_data3_->name = _tmp1_;
	_tmp2_ = toggle;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data3_->toggle);
	_data3_->toggle = _tmp3_;
	_tmp4_ = self->priv->preferences;
	_tmp5_ = _data3_->name;
	_tmp6_ = preferences_get (_tmp4_, _tmp5_);
	variant = _tmp6_;
	_vala_assert (variant != NULL, "variant != null");
	_tmp7_ = _data3_->toggle;
	_tmp8_ = g_variant_get_boolean (variant);
	gtk_toggle_button_set_active (_tmp7_, _tmp8_);
	_tmp9_ = _data3_->toggle;
	g_signal_connect_data (_tmp9_, "toggled", (GCallback) ___lambda9__gtk_toggle_button_toggled, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_g_variant_unref0 (variant);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		SetupDialog* self;
		self = _data4_->self;
		_g_free0 (_data4_->name);
		_g_object_unref0 (_data4_->combo);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static void __lambda8_ (Block4Data* _data4_) {
	SetupDialog* self;
	const gchar* _tmp0_ = NULL;
	GtkComboBox* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	self = _data4_->self;
	_tmp0_ = _data4_->name;
	_tmp1_ = _data4_->combo;
	_tmp2_ = _data4_->column;
	setup_dialog_save_combobox (self, _tmp0_, _tmp1_, _tmp2_);
}


static void ___lambda8__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	__lambda8_ (self);
}


static void setup_dialog_load_combobox (SetupDialog* self, const gchar* name, GtkComboBox* combo, gint column) {
	Block4Data* _data4_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GtkComboBox* _tmp2_ = NULL;
	GtkComboBox* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GVariant* variant = NULL;
	Preferences* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	GVariant* _tmp8_ = NULL;
	GtkTreeIter iter = {0};
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp9_ = NULL;
	GtkTreeModel* _tmp10_ = NULL;
	GtkTreeModel* _tmp11_ = NULL;
	GtkTreeModel* _tmp12_ = NULL;
	GtkTreeIter _tmp13_ = {0};
	gboolean _tmp14_ = FALSE;
	GtkComboBox* _tmp27_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (combo != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data4_->name);
	_data4_->name = _tmp1_;
	_tmp2_ = combo;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data4_->combo);
	_data4_->combo = _tmp3_;
	_tmp4_ = column;
	_data4_->column = _tmp4_;
	_tmp5_ = self->priv->preferences;
	_tmp6_ = _data4_->name;
	_tmp7_ = preferences_get (_tmp5_, _tmp6_);
	variant = _tmp7_;
	_tmp8_ = variant;
	_vala_assert (_tmp8_ != NULL, "variant != null");
	_tmp9_ = _data4_->combo;
	_tmp10_ = gtk_combo_box_get_model (_tmp9_);
	_tmp11_ = _g_object_ref0 (_tmp10_);
	model = _tmp11_;
	_tmp12_ = model;
	_tmp14_ = gtk_tree_model_get_iter_first (_tmp12_, &_tmp13_);
	iter = _tmp13_;
	if (_tmp14_) {
		gint32 index = 0;
		GVariant* _tmp15_ = NULL;
		gint32 _tmp16_ = 0;
		gint _index = 0;
		_tmp15_ = variant;
		_tmp16_ = g_variant_get_int32 (_tmp15_);
		index = _tmp16_;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				GtkTreeModel* _tmp20_ = NULL;
				GtkTreeIter _tmp21_ = {0};
				gint _tmp22_ = 0;
				gint32 _tmp23_ = 0;
				gint _tmp24_ = 0;
				if (!_tmp17_) {
					GtkTreeModel* _tmp18_ = NULL;
					gboolean _tmp19_ = FALSE;
					_tmp18_ = model;
					_tmp19_ = gtk_tree_model_iter_next (_tmp18_, &iter);
					if (!_tmp19_) {
						break;
					}
				}
				_tmp17_ = FALSE;
				_tmp20_ = model;
				_tmp21_ = iter;
				_tmp22_ = _data4_->column;
				gtk_tree_model_get (_tmp20_, &_tmp21_, _tmp22_, &_index, -1, -1);
				_tmp23_ = index;
				_tmp24_ = _index;
				if (_tmp23_ == ((gint32) _tmp24_)) {
					GtkComboBox* _tmp25_ = NULL;
					GtkTreeIter _tmp26_ = {0};
					_tmp25_ = _data4_->combo;
					_tmp26_ = iter;
					gtk_combo_box_set_active_iter (_tmp25_, &_tmp26_);
					break;
				}
			}
		}
	}
	_tmp27_ = _data4_->combo;
	g_signal_connect_data (_tmp27_, "changed", (GCallback) ___lambda8__gtk_combo_box_changed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_g_object_unref0 (model);
	_g_variant_unref0 (variant);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		SetupDialog* self;
		self = _data5_->self;
		_g_free0 (_data5_->name);
		_g_object_unref0 (_data5_->combo);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static void __lambda7_ (Block5Data* _data5_) {
	SetupDialog* self;
	const gchar* _tmp0_ = NULL;
	GtkComboBox* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	self = _data5_->self;
	_tmp0_ = _data5_->name;
	_tmp1_ = _data5_->combo;
	_tmp2_ = _data5_->column;
	setup_dialog_save_combobox_string (self, _tmp0_, _tmp1_, _tmp2_);
}


static void ___lambda7__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	__lambda7_ (self);
}


static void setup_dialog_load_combobox_string (SetupDialog* self, const gchar* name, GtkComboBox* combo, gint column) {
	Block5Data* _data5_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GtkComboBox* _tmp2_ = NULL;
	GtkComboBox* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GVariant* variant = NULL;
	Preferences* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	GVariant* _tmp8_ = NULL;
	GtkTreeIter iter = {0};
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp9_ = NULL;
	GtkTreeModel* _tmp10_ = NULL;
	GtkTreeModel* _tmp11_ = NULL;
	GtkTreeModel* _tmp12_ = NULL;
	GtkTreeIter _tmp13_ = {0};
	gboolean _tmp14_ = FALSE;
	GtkComboBox* _tmp28_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (combo != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data5_->name);
	_data5_->name = _tmp1_;
	_tmp2_ = combo;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data5_->combo);
	_data5_->combo = _tmp3_;
	_tmp4_ = column;
	_data5_->column = _tmp4_;
	_tmp5_ = self->priv->preferences;
	_tmp6_ = _data5_->name;
	_tmp7_ = preferences_get (_tmp5_, _tmp6_);
	variant = _tmp7_;
	_tmp8_ = variant;
	_vala_assert (_tmp8_ != NULL, "variant != null");
	_tmp9_ = _data5_->combo;
	_tmp10_ = gtk_combo_box_get_model (_tmp9_);
	_tmp11_ = _g_object_ref0 (_tmp10_);
	model = _tmp11_;
	_tmp12_ = model;
	_tmp14_ = gtk_tree_model_get_iter_first (_tmp12_, &_tmp13_);
	iter = _tmp13_;
	if (_tmp14_) {
		gchar* str = NULL;
		GVariant* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		_tmp15_ = variant;
		_tmp16_ = g_variant_get_string (_tmp15_, NULL);
		_tmp17_ = g_strdup (_tmp16_);
		str = _tmp17_;
		{
			gboolean _tmp18_ = FALSE;
			_tmp18_ = TRUE;
			while (TRUE) {
				gchar* _str = NULL;
				GtkTreeModel* _tmp21_ = NULL;
				GtkTreeIter _tmp22_ = {0};
				gint _tmp23_ = 0;
				const gchar* _tmp24_ = NULL;
				const gchar* _tmp25_ = NULL;
				if (!_tmp18_) {
					GtkTreeModel* _tmp19_ = NULL;
					gboolean _tmp20_ = FALSE;
					_tmp19_ = model;
					_tmp20_ = gtk_tree_model_iter_next (_tmp19_, &iter);
					if (!_tmp20_) {
						break;
					}
				}
				_tmp18_ = FALSE;
				_tmp21_ = model;
				_tmp22_ = iter;
				_tmp23_ = _data5_->column;
				gtk_tree_model_get (_tmp21_, &_tmp22_, _tmp23_, &_str, -1, -1);
				_tmp24_ = str;
				_tmp25_ = _str;
				if (g_strcmp0 (_tmp24_, _tmp25_) == 0) {
					GtkComboBox* _tmp26_ = NULL;
					GtkTreeIter _tmp27_ = {0};
					_tmp26_ = _data5_->combo;
					_tmp27_ = iter;
					gtk_combo_box_set_active_iter (_tmp26_, &_tmp27_);
					_g_free0 (_str);
					break;
				}
				_g_free0 (_str);
			}
		}
		_g_free0 (str);
	}
	_tmp28_ = _data5_->combo;
	g_signal_connect_data (_tmp28_, "changed", (GCallback) ___lambda7__gtk_combo_box_changed, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_g_object_unref0 (model);
	_g_variant_unref0 (variant);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}


static void setup_dialog_select_shortcut_section (SetupDialog* self, KkcInputMode input_mode) {
	GtkTreeIter iter = {0};
	GtkTreeModel* model = NULL;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->input_mode_treeview;
	_tmp1_ = gtk_tree_view_get_model (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	model = _tmp2_;
	_tmp3_ = model;
	_tmp5_ = gtk_tree_model_get_iter_first (_tmp3_, &_tmp4_);
	iter = _tmp4_;
	if (_tmp5_) {
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gint _input_mode = 0;
				GtkTreeModel* _tmp9_ = NULL;
				GtkTreeIter _tmp10_ = {0};
				gint _tmp11_ = 0;
				KkcInputMode _tmp12_ = 0;
				if (!_tmp6_) {
					GtkTreeModel* _tmp7_ = NULL;
					gboolean _tmp8_ = FALSE;
					_tmp7_ = model;
					_tmp8_ = gtk_tree_model_iter_next (_tmp7_, &iter);
					if (!_tmp8_) {
						break;
					}
				}
				_tmp6_ = FALSE;
				_tmp9_ = model;
				_tmp10_ = iter;
				gtk_tree_model_get (_tmp9_, &_tmp10_, 1, &_input_mode, -1, -1);
				_tmp11_ = _input_mode;
				_tmp12_ = input_mode;
				if (_tmp11_ == ((gint) _tmp12_)) {
					GtkTreeSelection* selection = NULL;
					GtkTreeView* _tmp13_ = NULL;
					GtkTreeSelection* _tmp14_ = NULL;
					GtkTreeSelection* _tmp15_ = NULL;
					GtkTreeSelection* _tmp16_ = NULL;
					GtkTreeIter _tmp17_ = {0};
					_tmp13_ = self->priv->input_mode_treeview;
					_tmp14_ = gtk_tree_view_get_selection (_tmp13_);
					_tmp15_ = _g_object_ref0 (_tmp14_);
					selection = _tmp15_;
					_tmp16_ = selection;
					_tmp17_ = iter;
					gtk_tree_selection_select_iter (_tmp16_, &_tmp17_);
					_g_object_unref0 (selection);
					break;
				}
			}
		}
	}
	_g_object_unref0 (model);
}


static void setup_dialog_load (SetupDialog* self) {
	GtkComboBox* _tmp0_ = NULL;
	GtkComboBox* _tmp1_ = NULL;
	GtkComboBox* _tmp2_ = NULL;
	GtkCheckButton* _tmp3_ = NULL;
	GtkCheckButton* _tmp4_ = NULL;
	GtkComboBox* _tmp5_ = NULL;
	GtkSpinButton* _tmp6_ = NULL;
	GtkSpinButton* _tmp7_ = NULL;
	GtkCheckButton* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->typing_rule_combobox;
	setup_dialog_load_combobox_string (self, "typing_rule", _tmp0_, 0);
	_tmp1_ = self->priv->initial_input_mode_combobox;
	setup_dialog_load_combobox (self, "initial_input_mode", _tmp1_, 1);
	_tmp2_ = self->priv->punctuation_style_combobox;
	setup_dialog_load_combobox (self, "punctuation_style", _tmp2_, 1);
	_tmp3_ = self->priv->auto_correct_checkbutton;
	setup_dialog_load_togglebutton (self, "auto_correct", (GtkToggleButton*) _tmp3_);
	_tmp4_ = self->priv->use_custom_keymap_checkbutton;
	setup_dialog_load_togglebutton (self, "use_custom_keymap", (GtkToggleButton*) _tmp4_);
	_tmp5_ = self->priv->keymap_combobox;
	setup_dialog_load_combobox_string (self, "keymap", _tmp5_, 0);
	_tmp6_ = self->priv->page_size_spinbutton;
	setup_dialog_load_spinbutton (self, "page_size", _tmp6_);
	_tmp7_ = self->priv->pagination_start_spinbutton;
	setup_dialog_load_spinbutton (self, "pagination_start", _tmp7_);
	_tmp8_ = self->priv->show_annotation_checkbutton;
	setup_dialog_load_togglebutton (self, "show_annotation", (GtkToggleButton*) _tmp8_);
	setup_dialog_populate_dictionaries_treeview (self);
	setup_dialog_select_shortcut_section (self, KKC_INPUT_MODE_HIRAGANA);
}


static GVariant* _variant_new3 (gchar** value, gint value_length1) {
	gchar** _tmp22_;
	GVariantBuilder _tmp23_;
	int _tmp24_;
	_tmp22_ = value;
	g_variant_builder_init (&_tmp23_, G_VARIANT_TYPE ("as"));
	for (_tmp24_ = 0; _tmp24_ < value_length1; _tmp24_++) {
		g_variant_builder_add_value (&_tmp23_, g_variant_new_string (*_tmp22_));
		_tmp22_++;
	}
	return g_variant_ref_sink (g_variant_builder_end (&_tmp23_));
}


static void setup_dialog_save_dictionaries (SetupDialog* self, const gchar* name) {
	GtkTreeModel* model = NULL;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->dictionaries_treeview;
	_tmp1_ = gtk_tree_view_get_model (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	model = _tmp2_;
	_tmp3_ = model;
	_tmp5_ = gtk_tree_model_get_iter_first (_tmp3_, &_tmp4_);
	iter = _tmp4_;
	if (_tmp5_) {
		GeeArrayList* dictionaries = NULL;
		GeeArrayList* _tmp6_ = NULL;
		Preferences* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		GeeArrayList* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		gpointer* _tmp20_ = NULL;
		gchar** _tmp21_ = NULL;
		gint _tmp21__length1 = 0;
		GVariant* _tmp25_ = NULL;
		_tmp6_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
		dictionaries = _tmp6_;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				DictionaryMetadata* metadata = NULL;
				GtkTreeModel* _tmp10_ = NULL;
				GtkTreeIter _tmp11_ = {0};
				GeeArrayList* _tmp12_ = NULL;
				DictionaryMetadata* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				if (!_tmp7_) {
					GtkTreeModel* _tmp8_ = NULL;
					gboolean _tmp9_ = FALSE;
					_tmp8_ = model;
					_tmp9_ = gtk_tree_model_iter_next (_tmp8_, &iter);
					if (!_tmp9_) {
						break;
					}
				}
				_tmp7_ = FALSE;
				_tmp10_ = model;
				_tmp11_ = iter;
				gtk_tree_model_get (_tmp10_, &_tmp11_, 0, &metadata, -1, -1);
				_tmp12_ = dictionaries;
				_tmp13_ = metadata;
				_tmp14_ = dictionary_metadata_get_id (_tmp13_);
				_tmp15_ = _tmp14_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, _tmp15_);
				_g_object_unref0 (metadata);
			}
		}
		_tmp16_ = self->priv->preferences;
		_tmp17_ = name;
		_tmp18_ = dictionaries;
		_tmp20_ = gee_collection_to_array ((GeeCollection*) _tmp18_, &_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp21__length1 = _tmp19_;
		_tmp25_ = _variant_new3 (_tmp21_, _tmp19_);
		preferences_set (_tmp16_, _tmp17_, _tmp25_);
		_g_variant_unref0 (_tmp25_);
		_tmp21_ = (_vala_array_free (_tmp21_, _tmp21__length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (dictionaries);
	}
	_g_object_unref0 (model);
}


static GVariant* _variant_new4 (gint value) {
	return g_variant_ref_sink (g_variant_new_int32 (value));
}


static void setup_dialog_save_combobox (SetupDialog* self, const gchar* name, GtkComboBox* combo, gint column) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		gint index = 0;
		GtkTreeModel* model = NULL;
		GtkComboBox* _tmp3_ = NULL;
		GtkTreeModel* _tmp4_ = NULL;
		GtkTreeModel* _tmp5_ = NULL;
		GtkTreeModel* _tmp6_ = NULL;
		GtkTreeIter _tmp7_ = {0};
		gint _tmp8_ = 0;
		Preferences* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		GVariant* _tmp12_ = NULL;
		_tmp3_ = combo;
		_tmp4_ = gtk_combo_box_get_model (_tmp3_);
		_tmp5_ = _g_object_ref0 (_tmp4_);
		model = _tmp5_;
		_tmp6_ = model;
		_tmp7_ = iter;
		_tmp8_ = column;
		gtk_tree_model_get (_tmp6_, &_tmp7_, _tmp8_, &index, -1, -1);
		_tmp9_ = self->priv->preferences;
		_tmp10_ = name;
		_tmp11_ = index;
		_tmp12_ = _variant_new4 (_tmp11_);
		preferences_set (_tmp9_, _tmp10_, _tmp12_);
		_g_variant_unref0 (_tmp12_);
		_g_object_unref0 (model);
	}
}


static GVariant* _variant_new5 (const gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static void setup_dialog_save_combobox_string (SetupDialog* self, const gchar* name, GtkComboBox* combo, gint column) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		gchar* str = NULL;
		GtkTreeModel* model = NULL;
		GtkComboBox* _tmp3_ = NULL;
		GtkTreeModel* _tmp4_ = NULL;
		GtkTreeModel* _tmp5_ = NULL;
		GtkTreeModel* _tmp6_ = NULL;
		GtkTreeIter _tmp7_ = {0};
		gint _tmp8_ = 0;
		Preferences* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		GVariant* _tmp12_ = NULL;
		_tmp3_ = combo;
		_tmp4_ = gtk_combo_box_get_model (_tmp3_);
		_tmp5_ = _g_object_ref0 (_tmp4_);
		model = _tmp5_;
		_tmp6_ = model;
		_tmp7_ = iter;
		_tmp8_ = column;
		gtk_tree_model_get (_tmp6_, &_tmp7_, _tmp8_, &str, -1, -1);
		_tmp9_ = self->priv->preferences;
		_tmp10_ = name;
		_tmp11_ = str;
		_tmp12_ = _variant_new5 (_tmp11_);
		preferences_set (_tmp9_, _tmp10_, _tmp12_);
		_g_variant_unref0 (_tmp12_);
		_g_object_unref0 (model);
		_g_free0 (str);
	}
}


gint setup_dialog_main (gchar** args, int args_length1) {
	gint result = 0;
	IBusBus* bus = NULL;
	IBusBus* _tmp0_ = NULL;
	IBusBus* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	IBusConfig* config = NULL;
	IBusBus* _tmp4_ = NULL;
	IBusConfig* _tmp5_ = NULL;
	IBusConfig* _tmp6_ = NULL;
	IBusConfig* _tmp7_ = NULL;
	SetupDialog* setup_dialog = NULL;
	IBusConfig* _tmp9_ = NULL;
	Preferences* _tmp10_ = NULL;
	Preferences* _tmp11_ = NULL;
	SetupDialog* _tmp12_ = NULL;
	SetupDialog* _tmp13_ = NULL;
	SetupDialog* _tmp14_ = NULL;
	ibus_init ();
	kkc_init ();
	gtk_init (&args_length1, &args);
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = ibus_bus_new ();
	g_object_ref_sink (_tmp0_);
	bus = _tmp0_;
	_tmp1_ = bus;
	_tmp2_ = ibus_bus_is_connected (_tmp1_);
	if (!_tmp2_) {
		FILE* _tmp3_ = NULL;
		_tmp3_ = stderr;
		fprintf (_tmp3_, "cannot connect to ibus-daemon!\n");
		result = 1;
		_g_object_unref0 (bus);
		return result;
	}
	_tmp4_ = bus;
	_tmp5_ = ibus_bus_get_config (_tmp4_);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	config = _tmp6_;
	_tmp7_ = config;
	if (_tmp7_ == NULL) {
		FILE* _tmp8_ = NULL;
		_tmp8_ = stderr;
		fprintf (_tmp8_, "ibus-config component is not running!\n");
		result = 1;
		_g_object_unref0 (config);
		_g_object_unref0 (bus);
		return result;
	}
	_tmp9_ = config;
	_tmp10_ = preferences_new (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = setup_dialog_new (_tmp11_);
	g_object_ref_sink (_tmp12_);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp11_);
	setup_dialog = _tmp13_;
	_tmp14_ = setup_dialog;
	gtk_dialog_run ((GtkDialog*) _tmp14_);
	result = 0;
	_g_object_unref0 (setup_dialog);
	_g_object_unref0 (config);
	_g_object_unref0 (bus);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return setup_dialog_main (argv, argc);
}


static SetupDialogKeyEventCellRenderer* setup_dialog_key_event_cell_renderer_construct (GType object_type) {
	SetupDialogKeyEventCellRenderer * self = NULL;
	self = (SetupDialogKeyEventCellRenderer*) g_object_new (object_type, NULL);
	return self;
}


static SetupDialogKeyEventCellRenderer* setup_dialog_key_event_cell_renderer_new (void) {
	return setup_dialog_key_event_cell_renderer_construct (SETUP_DIALOG_TYPE_KEY_EVENT_CELL_RENDERER);
}


static KkcKeyEvent* setup_dialog_key_event_cell_renderer_get_event (SetupDialogKeyEventCellRenderer* self) {
	KkcKeyEvent* result;
	KkcKeyEvent* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_event;
	result = _tmp0_;
	return result;
}


static void setup_dialog_key_event_cell_renderer_set_event (SetupDialogKeyEventCellRenderer* self, KkcKeyEvent* value) {
	KkcKeyEvent* _tmp0_ = NULL;
	KkcKeyEvent* _tmp1_ = NULL;
	KkcKeyEvent* _tmp2_ = NULL;
	gboolean _tmp12_ = FALSE;
	GdkModifierType _tmp13_ = 0;
	GdkModifierType _tmp14_ = 0;
	g_return_if_fail (self != NULL);
	g_object_set ((GtkCellRendererAccel*) self, "accel-mode", GTK_CELL_RENDERER_ACCEL_MODE_OTHER, NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_event);
	self->priv->_event = _tmp1_;
	_tmp2_ = self->priv->_event;
	if (_tmp2_ == NULL) {
		g_object_set ((GtkCellRendererAccel*) self, "accel-key", (guint) 0, NULL);
		g_object_set ((GtkCellRendererAccel*) self, "accel-mods", 0, NULL);
		g_object_set ((GtkCellRendererAccel*) self, "keycode", (guint) 0, NULL);
	} else {
		KkcKeyEvent* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
		guint _tmp5_ = 0U;
		KkcKeyEvent* _tmp6_ = NULL;
		KkcModifierType _tmp7_ = 0;
		KkcModifierType _tmp8_ = 0;
		KkcKeyEvent* _tmp9_ = NULL;
		guint _tmp10_ = 0U;
		guint _tmp11_ = 0U;
		_tmp3_ = self->priv->_event;
		_tmp4_ = kkc_key_event_get_keyval (_tmp3_);
		_tmp5_ = _tmp4_;
		g_object_set ((GtkCellRendererAccel*) self, "accel-key", _tmp5_, NULL);
		_tmp6_ = self->priv->_event;
		_tmp7_ = kkc_key_event_get_modifiers (_tmp6_);
		_tmp8_ = _tmp7_;
		g_object_set ((GtkCellRendererAccel*) self, "accel-mods", (GdkModifierType) _tmp8_, NULL);
		_tmp9_ = self->priv->_event;
		_tmp10_ = kkc_key_event_get_keycode (_tmp9_);
		_tmp11_ = _tmp10_;
		g_object_set ((GtkCellRendererAccel*) self, "keycode", _tmp11_, NULL);
	}
	g_object_get ((GtkCellRendererAccel*) self, "accel-mods", &_tmp13_, NULL);
	_tmp14_ = _tmp13_;
	if (_tmp14_ == 0) {
		guint _tmp15_ = 0U;
		guint _tmp16_ = 0U;
		g_object_get ((GtkCellRendererAccel*) self, "accel-key", &_tmp15_, NULL);
		_tmp16_ = _tmp15_;
		_tmp12_ = _vala_uint_array_contains (SETUP_DIALOG_IGNORED_KEYVALS, G_N_ELEMENTS (SETUP_DIALOG_IGNORED_KEYVALS), _tmp16_);
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		g_object_set ((GtkCellRendererText*) self, "editable", FALSE, NULL);
	} else {
		g_object_set ((GtkCellRendererText*) self, "editable", TRUE, NULL);
	}
	g_object_notify ((GObject *) self, "event");
}


static void setup_dialog_key_event_cell_renderer_class_init (SetupDialogKeyEventCellRendererClass * klass) {
	setup_dialog_key_event_cell_renderer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SetupDialogKeyEventCellRendererPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_setup_dialog_key_event_cell_renderer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_setup_dialog_key_event_cell_renderer_set_property;
	G_OBJECT_CLASS (klass)->finalize = setup_dialog_key_event_cell_renderer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETUP_DIALOG_KEY_EVENT_CELL_RENDERER_EVENT, g_param_spec_object ("event", "event", "event", KKC_TYPE_KEY_EVENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void setup_dialog_key_event_cell_renderer_instance_init (SetupDialogKeyEventCellRenderer * self) {
	self->priv = SETUP_DIALOG_KEY_EVENT_CELL_RENDERER_GET_PRIVATE (self);
}


static void setup_dialog_key_event_cell_renderer_finalize (GObject* obj) {
	SetupDialogKeyEventCellRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SETUP_DIALOG_TYPE_KEY_EVENT_CELL_RENDERER, SetupDialogKeyEventCellRenderer);
	_g_object_unref0 (self->priv->_event);
	G_OBJECT_CLASS (setup_dialog_key_event_cell_renderer_parent_class)->finalize (obj);
}


static GType setup_dialog_key_event_cell_renderer_get_type (void) {
	static volatile gsize setup_dialog_key_event_cell_renderer_type_id__volatile = 0;
	if (g_once_init_enter (&setup_dialog_key_event_cell_renderer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SetupDialogKeyEventCellRendererClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) setup_dialog_key_event_cell_renderer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SetupDialogKeyEventCellRenderer), 0, (GInstanceInitFunc) setup_dialog_key_event_cell_renderer_instance_init, NULL };
		GType setup_dialog_key_event_cell_renderer_type_id;
		setup_dialog_key_event_cell_renderer_type_id = g_type_register_static (gtk_cell_renderer_accel_get_type (), "SetupDialogKeyEventCellRenderer", &g_define_type_info, 0);
		g_once_init_leave (&setup_dialog_key_event_cell_renderer_type_id__volatile, setup_dialog_key_event_cell_renderer_type_id);
	}
	return setup_dialog_key_event_cell_renderer_type_id__volatile;
}


static void _vala_setup_dialog_key_event_cell_renderer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SetupDialogKeyEventCellRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SETUP_DIALOG_TYPE_KEY_EVENT_CELL_RENDERER, SetupDialogKeyEventCellRenderer);
	switch (property_id) {
		case SETUP_DIALOG_KEY_EVENT_CELL_RENDERER_EVENT:
		g_value_set_object (value, setup_dialog_key_event_cell_renderer_get_event (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_setup_dialog_key_event_cell_renderer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SetupDialogKeyEventCellRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SETUP_DIALOG_TYPE_KEY_EVENT_CELL_RENDERER, SetupDialogKeyEventCellRenderer);
	switch (property_id) {
		case SETUP_DIALOG_KEY_EVENT_CELL_RENDERER_EVENT:
		setup_dialog_key_event_cell_renderer_set_event (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void setup_dialog_class_init (SetupDialogClass * klass) {
	gint SetupDialog_private_offset;
	setup_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SetupDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = setup_dialog_finalize;
	SetupDialog_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/freedesktop/ibus/engine/kkc/setup-dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "dictionaries_treeview", FALSE, SetupDialog_private_offset + G_STRUCT_OFFSET (SetupDialogPrivate, dictionaries_treeview));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "punctuation_style_combobox", FALSE, SetupDialog_private_offset + G_STRUCT_OFFSET (SetupDialogPrivate, punctuation_style_combobox));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "auto_correct_checkbutton", FALSE, SetupDialog_private_offset + G_STRUCT_OFFSET (SetupDialogPrivate, auto_correct_checkbutton));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "use_custom_keymap_checkbutton", FALSE, SetupDialog_private_offset + G_STRUCT_OFFSET (SetupDialogPrivate, use_custom_keymap_checkbutton));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "keymap_combobox", FALSE, SetupDialog_private_offset + G_STRUCT_OFFSET (SetupDialogPrivate, keymap_combobox));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "page_size_spinbutton", FALSE, SetupDialog_private_offset + G_STRUCT_OFFSET (SetupDialogPrivate, page_size_spinbutton));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "pagination_start_spinbutton", FALSE, SetupDialog_private_offset + G_STRUCT_OFFSET (SetupDialogPrivate, pagination_start_spinbutton));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "show_annotation_checkbutton", FALSE, SetupDialog_private_offset + G_STRUCT_OFFSET (SetupDialogPrivate, show_annotation_checkbutton));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "initial_input_mode_combobox", FALSE, SetupDialog_private_offset + G_STRUCT_OFFSET (SetupDialogPrivate, initial_input_mode_combobox));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "typing_rule_combobox", FALSE, SetupDialog_private_offset + G_STRUCT_OFFSET (SetupDialogPrivate, typing_rule_combobox));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "input_mode_treeview", FALSE, SetupDialog_private_offset + G_STRUCT_OFFSET (SetupDialogPrivate, input_mode_treeview));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "add_dict_toolbutton", FALSE, SetupDialog_private_offset + G_STRUCT_OFFSET (SetupDialogPrivate, add_dict_toolbutton));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "remove_dict_toolbutton", FALSE, SetupDialog_private_offset + G_STRUCT_OFFSET (SetupDialogPrivate, remove_dict_toolbutton));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "up_dict_toolbutton", FALSE, SetupDialog_private_offset + G_STRUCT_OFFSET (SetupDialogPrivate, up_dict_toolbutton));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "down_dict_toolbutton", FALSE, SetupDialog_private_offset + G_STRUCT_OFFSET (SetupDialogPrivate, down_dict_toolbutton));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "shortcut_treeview", FALSE, SetupDialog_private_offset + G_STRUCT_OFFSET (SetupDialogPrivate, shortcut_treeview));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "add_shortcut_toolbutton", FALSE, SetupDialog_private_offset + G_STRUCT_OFFSET (SetupDialogPrivate, add_shortcut_toolbutton));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "remove_shortcut_toolbutton", FALSE, SetupDialog_private_offset + G_STRUCT_OFFSET (SetupDialogPrivate, remove_shortcut_toolbutton));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "version_label", FALSE, SetupDialog_private_offset + G_STRUCT_OFFSET (SetupDialogPrivate, version_label));
}


static void setup_dialog_instance_init (SetupDialog * self) {
	self->priv = SETUP_DIALOG_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void setup_dialog_finalize (GObject* obj) {
	SetupDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SETUP_DIALOG, SetupDialog);
	_g_object_unref0 (self->priv->dictionaries_treeview);
	_g_object_unref0 (self->priv->punctuation_style_combobox);
	_g_object_unref0 (self->priv->auto_correct_checkbutton);
	_g_object_unref0 (self->priv->use_custom_keymap_checkbutton);
	_g_object_unref0 (self->priv->keymap_combobox);
	_g_object_unref0 (self->priv->page_size_spinbutton);
	_g_object_unref0 (self->priv->pagination_start_spinbutton);
	_g_object_unref0 (self->priv->show_annotation_checkbutton);
	_g_object_unref0 (self->priv->initial_input_mode_combobox);
	_g_object_unref0 (self->priv->typing_rule_combobox);
	_g_object_unref0 (self->priv->input_mode_treeview);
	_g_object_unref0 (self->priv->add_dict_toolbutton);
	_g_object_unref0 (self->priv->remove_dict_toolbutton);
	_g_object_unref0 (self->priv->up_dict_toolbutton);
	_g_object_unref0 (self->priv->down_dict_toolbutton);
	_g_object_unref0 (self->priv->shortcut_treeview);
	_g_object_unref0 (self->priv->add_shortcut_toolbutton);
	_g_object_unref0 (self->priv->remove_shortcut_toolbutton);
	_g_object_unref0 (self->priv->version_label);
	_g_object_unref0 (self->priv->preferences);
	_g_object_unref0 (self->priv->shortcut_rule);
	G_OBJECT_CLASS (setup_dialog_parent_class)->finalize (obj);
}


GType setup_dialog_get_type (void) {
	static volatile gsize setup_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&setup_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SetupDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) setup_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SetupDialog), 0, (GInstanceInitFunc) setup_dialog_instance_init, NULL };
		GType setup_dialog_type_id;
		setup_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "SetupDialog", &g_define_type_info, 0);
		g_once_init_leave (&setup_dialog_type_id__volatile, setup_dialog_type_id);
	}
	return setup_dialog_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



