/* contacts-avatar-dialog.c generated by valac 0.38.4, the Vala compiler
 * generated from contacts-avatar-dialog.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <libgnome-desktop/gnome-desktop-thumbnail.h>
#include <cc-crop-area.h>
#include <cheese-flash.h>
#include <cheese/cheese-camera-device-monitor.h>
#include <cheese/cheese-widget.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <folks/folks.h>
#include <stdlib.h>
#include <string.h>
#include <cheese/cheese-camera-device.h>
#include <math.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <cheese/cheese-camera.h>


#define CONTACTS_TYPE_AVATAR_DIALOG (contacts_avatar_dialog_get_type ())
#define CONTACTS_AVATAR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_AVATAR_DIALOG, ContactsAvatarDialog))
#define CONTACTS_AVATAR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_AVATAR_DIALOG, ContactsAvatarDialogClass))
#define CONTACTS_IS_AVATAR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_AVATAR_DIALOG))
#define CONTACTS_IS_AVATAR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_AVATAR_DIALOG))
#define CONTACTS_AVATAR_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_AVATAR_DIALOG, ContactsAvatarDialogClass))

typedef struct _ContactsAvatarDialog ContactsAvatarDialog;
typedef struct _ContactsAvatarDialogClass ContactsAvatarDialogClass;
typedef struct _ContactsAvatarDialogPrivate ContactsAvatarDialogPrivate;

#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;

#define CONTACTS_TYPE_CONTACT_FRAME (contacts_contact_frame_get_type ())
#define CONTACTS_CONTACT_FRAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_FRAME, ContactsContactFrame))
#define CONTACTS_CONTACT_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_FRAME, ContactsContactFrameClass))
#define CONTACTS_IS_CONTACT_FRAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_FRAME))
#define CONTACTS_IS_CONTACT_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_FRAME))
#define CONTACTS_CONTACT_FRAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_FRAME, ContactsContactFrameClass))

typedef struct _ContactsContactFrame ContactsContactFrame;
typedef struct _ContactsContactFrameClass ContactsContactFrameClass;
enum  {
	CONTACTS_AVATAR_DIALOG_0_PROPERTY,
	CONTACTS_AVATAR_DIALOG_NUM_PROPERTIES
};
static GParamSpec* contacts_avatar_dialog_properties[CONTACTS_AVATAR_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CONTACTS_TYPE_WINDOW (contacts_window_get_type ())
#define CONTACTS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_WINDOW, ContactsWindow))
#define CONTACTS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_WINDOW, ContactsWindowClass))
#define CONTACTS_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_WINDOW))
#define CONTACTS_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_WINDOW))
#define CONTACTS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_WINDOW, ContactsWindowClass))

typedef struct _ContactsWindow ContactsWindow;
typedef struct _ContactsWindowClass ContactsWindowClass;
typedef struct _Block30Data Block30Data;
typedef struct _ContactsContactPrivate ContactsContactPrivate;

#define CONTACTS_TYPE_STORE (contacts_store_get_type ())
#define CONTACTS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_STORE, ContactsStore))
#define CONTACTS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_STORE, ContactsStoreClass))
#define CONTACTS_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_STORE))
#define CONTACTS_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_STORE))
#define CONTACTS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_STORE, ContactsStoreClass))

typedef struct _ContactsStore ContactsStore;
typedef struct _ContactsStoreClass ContactsStoreClass;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
typedef struct _Block31Data Block31Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
typedef struct _Block32Data Block32Data;
enum  {
	CONTACTS_AVATAR_DIALOG_SET_AVATAR_SIGNAL,
	CONTACTS_AVATAR_DIALOG_NUM_SIGNALS
};
static guint contacts_avatar_dialog_signals[CONTACTS_AVATAR_DIALOG_NUM_SIGNALS] = {0};

struct _ContactsAvatarDialog {
	GtkDialog parent_instance;
	ContactsAvatarDialogPrivate * priv;
};

struct _ContactsAvatarDialogClass {
	GtkDialogClass parent_class;
};

struct _ContactsAvatarDialogPrivate {
	ContactsContact* contact;
	GnomeDesktopThumbnailFactory* thumbnail_factory;
	GtkGrid* grid;
	GtkLabel* contact_name_label;
	GtkStack* views_stack;
	GtkFlowBox* personas_thumbnail_grid;
	GtkFlowBox* stock_thumbnail_grid;
	GtkGrid* crop_page;
	CcCropArea* crop_area;
	GtkGrid* photobooth_page;
	GtkButton* webcam_button;
	GtkBox* webcam_button_box;
	ContactsContactFrame* current_avatar;
	CheeseFlash* flash;
	CheeseCameraDeviceMonitor* camera_monitor;
	CheeseWidget* cheese;
	gint num_cameras;
	GdkPixbuf* new_pixbuf;
};

struct _Block30Data {
	int _ref_count_;
	ContactsAvatarDialog* self;
	ContactsContact* contact;
};

struct _ContactsContact {
	GObject parent_instance;
	ContactsContactPrivate * priv;
	ContactsStore* store;
	gboolean is_main;
	FolksIndividual* individual;
	FolksPersona* fake_persona;
};

struct _ContactsContactClass {
	GObjectClass parent_class;
};

struct _Block31Data {
	int _ref_count_;
	ContactsAvatarDialog* self;
	GdkPixbuf* avatar_pixbuf;
};

struct _Block32Data {
	int _ref_count_;
	ContactsAvatarDialog* self;
	GtkFileChooserDialog* chooser;
};


static gpointer contacts_avatar_dialog_parent_class = NULL;

GType contacts_avatar_dialog_get_type (void) G_GNUC_CONST;
GType contacts_contact_get_type (void) G_GNUC_CONST;
GType contacts_contact_frame_get_type (void) G_GNUC_CONST;
#define CONTACTS_AVATAR_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_AVATAR_DIALOG, ContactsAvatarDialogPrivate))
#define CONTACTS_AVATAR_DIALOG_MAIN_SIZE 128
#define CONTACTS_AVATAR_DIALOG_ICONS_SIZE 64
GType contacts_window_get_type (void) G_GNUC_CONST;
ContactsAvatarDialog* contacts_avatar_dialog_new (ContactsWindow* main_window, ContactsContact* contact);
ContactsAvatarDialog* contacts_avatar_dialog_construct (GType object_type, ContactsWindow* main_window, ContactsContact* contact);
static Block30Data* block30_data_ref (Block30Data* _data30_);
static void block30_data_unref (void * _userdata_);
ContactsContactFrame* contacts_contact_frame_new (gint size, gboolean with_button);
ContactsContactFrame* contacts_contact_frame_construct (GType object_type, gint size, gboolean with_button);
void contacts_contact_keep_widget_uptodate (ContactsContact* self, GtkWidget* w, GtkCallback callback, void* callback_target, GDestroyNotify callback_target_destroy_notify);
static void ___lambda56_ (Block30Data* _data30_, GtkWidget* w);
void contacts_contact_frame_set_image (ContactsContactFrame* self, FolksAvatarDetails* details, ContactsContact* contact);
GType contacts_store_get_type (void) G_GNUC_CONST;
static void ____lambda56__gtk_callback (GtkWidget* widget, gpointer self);
const gchar* contacts_contact_get_display_name (ContactsContact* self);
static void __lambda57_ (ContactsAvatarDialog* self);
static void ___lambda57__cheese_camera_device_monitor_added (CheeseCameraDeviceMonitor* _sender, CheeseCameraDevice* device, gpointer self);
static void __lambda58_ (ContactsAvatarDialog* self);
static void ___lambda58__cheese_camera_device_monitor_removed (CheeseCameraDeviceMonitor* _sender, const gchar* uuid, gpointer self);
static void* __lambda59_ (ContactsAvatarDialog* self);
static gpointer ___lambda59__gthread_func (gpointer self);
static void contacts_avatar_dialog_update_thumbnail_grids (ContactsAvatarDialog* self);
static GdkPixbuf* contacts_avatar_dialog_scale_pixbuf_for_avatar_use (ContactsAvatarDialog* self, GdkPixbuf* pixbuf);
static ContactsContactFrame* contacts_avatar_dialog_create_frame (ContactsAvatarDialog* self, GdkPixbuf* source_pixbuf);
static Block31Data* block31_data_ref (Block31Data* _data31_);
static void block31_data_unref (void * _userdata_);
void contacts_contact_frame_set_pixbuf (ContactsContactFrame* self, GdkPixbuf* a_pixbuf);
static void __lambda60_ (Block31Data* _data31_);
static void contacts_avatar_dialog_selected_pixbuf (ContactsAvatarDialog* self, GdkPixbuf* pixbuf);
static void ___lambda60__contacts_contact_frame_clicked (ContactsContactFrame* _sender, gpointer self);
static ContactsContactFrame* contacts_avatar_dialog_frame_for_persona (ContactsAvatarDialog* self, FolksPersona* persona);
static ContactsContactFrame* contacts_avatar_dialog_frame_for_filename (ContactsAvatarDialog* self, const gchar* filename);
gchar** contacts_utils_get_stock_avatars (int* result_length1);
void contacts_avatar_dialog_update_preview (ContactsAvatarDialog* self, GtkFileChooser* chooser);
static void contacts_avatar_dialog_set_crop_widget (ContactsAvatarDialog* self, GdkPixbuf* pixbuf);
static void contacts_avatar_dialog_real_response (GtkDialog* base, gint response_id);
static void contacts_avatar_dialog_select_avatar_file_cb (ContactsAvatarDialog* self, GtkButton* button);
static Block32Data* block32_data_ref (Block32Data* _data32_);
static void block32_data_unref (void * _userdata_);
static void _contacts_avatar_dialog_update_preview_gtk_file_chooser_update_preview (GtkFileChooser* _sender, gpointer self);
static void __lambda61_ (Block32Data* _data32_, gint response);
static void ___lambda61__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void _contacts_avatar_dialog_select_avatar_file_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void contacts_avatar_dialog_on_webcam_button_clicked (ContactsAvatarDialog* self, GtkButton* button);
static void _contacts_avatar_dialog_on_webcam_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void contacts_avatar_dialog_on_photobooth_page_select_button_clicked (ContactsAvatarDialog* self, GtkButton* button);
static void __lambda62_ (ContactsAvatarDialog* self, GdkPixbuf* pix);
static void ___lambda62__cheese_camera_photo_taken (CheeseCamera* _sender, GdkPixbuf* pixbuf, gpointer self);
static void _contacts_avatar_dialog_on_photobooth_page_select_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void contacts_avatar_dialog_on_photobooth_page_cancel_button_clicked (ContactsAvatarDialog* self, GtkButton* button);
static void _contacts_avatar_dialog_on_photobooth_page_cancel_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void contacts_avatar_dialog_on_crop_page_select_button_clicked (ContactsAvatarDialog* self, GtkButton* button);
static void _contacts_avatar_dialog_on_crop_page_select_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void contacts_avatar_dialog_on_crop_page_cancel_button_clicked (ContactsAvatarDialog* self, GtkButton* button);
static void _contacts_avatar_dialog_on_crop_page_cancel_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void contacts_avatar_dialog_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block30Data* block30_data_ref (Block30Data* _data30_) {
	g_atomic_int_inc (&_data30_->_ref_count_);
	return _data30_;
}


static void block30_data_unref (void * _userdata_) {
	Block30Data* _data30_;
	_data30_ = (Block30Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data30_->_ref_count_)) {
		ContactsAvatarDialog* self;
		self = _data30_->self;
		_g_object_unref0 (_data30_->contact);
		_g_object_unref0 (self);
		g_slice_free (Block30Data, _data30_);
	}
}


static void ___lambda56_ (Block30Data* _data30_, GtkWidget* w) {
	ContactsAvatarDialog* self;
	GtkWidget* _tmp0_;
	ContactsContact* _tmp1_;
	FolksIndividual* _tmp2_;
	ContactsContact* _tmp3_;
	self = _data30_->self;
	g_return_if_fail (w != NULL);
	_tmp0_ = w;
	_tmp1_ = _data30_->contact;
	_tmp2_ = _tmp1_->individual;
	_tmp3_ = _data30_->contact;
	contacts_contact_frame_set_image (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, CONTACTS_TYPE_CONTACT_FRAME) ? ((ContactsContactFrame*) _tmp0_) : NULL, (FolksAvatarDetails*) _tmp2_, _tmp3_);
}


static void ____lambda56__gtk_callback (GtkWidget* widget, gpointer self) {
	___lambda56_ (self, widget);
}


static void __lambda57_ (ContactsAvatarDialog* self) {
	gint _tmp0_;
	GtkButton* _tmp1_;
	gint _tmp2_;
	_tmp0_ = self->priv->num_cameras;
	self->priv->num_cameras = _tmp0_ + 1;
	_tmp1_ = self->priv->webcam_button;
	_tmp2_ = self->priv->num_cameras;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, _tmp2_ > 0);
}


static void ___lambda57__cheese_camera_device_monitor_added (CheeseCameraDeviceMonitor* _sender, CheeseCameraDevice* device, gpointer self) {
	__lambda57_ ((ContactsAvatarDialog*) self);
}


static void __lambda58_ (ContactsAvatarDialog* self) {
	gint _tmp0_;
	GtkButton* _tmp1_;
	gint _tmp2_;
	_tmp0_ = self->priv->num_cameras;
	self->priv->num_cameras = _tmp0_ - 1;
	_tmp1_ = self->priv->webcam_button;
	_tmp2_ = self->priv->num_cameras;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, _tmp2_ > 0);
}


static void ___lambda58__cheese_camera_device_monitor_removed (CheeseCameraDeviceMonitor* _sender, const gchar* uuid, gpointer self) {
	__lambda58_ ((ContactsAvatarDialog*) self);
}


static void* __lambda59_ (ContactsAvatarDialog* self) {
	void* result = NULL;
	CheeseCameraDeviceMonitor* _tmp0_;
	_tmp0_ = self->priv->camera_monitor;
	cheese_camera_device_monitor_coldplug (_tmp0_);
	result = NULL;
	return result;
}


static gpointer ___lambda59__gthread_func (gpointer self) {
	gpointer result;
	result = __lambda59_ ((ContactsAvatarDialog*) self);
	g_object_unref (self);
	return result;
}


ContactsAvatarDialog* contacts_avatar_dialog_construct (GType object_type, ContactsWindow* main_window, ContactsContact* contact) {
	ContactsAvatarDialog * self = NULL;
	Block30Data* _data30_;
	ContactsContact* _tmp0_;
	ContactsContact* _tmp1_;
	ContactsWindow* _tmp2_;
	GnomeDesktopThumbnailFactory* _tmp3_;
	ContactsContact* _tmp4_;
	ContactsContact* _tmp5_;
	ContactsContactFrame* _tmp6_;
	ContactsContact* _tmp7_;
	ContactsContactFrame* _tmp11_;
	ContactsContactFrame* _tmp12_;
	GtkGrid* _tmp13_;
	ContactsContactFrame* _tmp14_;
	ContactsContact* _tmp15_;
	GtkBox* _tmp20_;
	CheeseCameraDeviceMonitor* _tmp21_;
	CheeseCameraDeviceMonitor* _tmp22_;
	CheeseCameraDeviceMonitor* _tmp23_;
	GThread* _tmp24_;
	GThread* _tmp25_;
	CheeseWidget* _tmp26_;
	CheeseWidget* _tmp27_;
	CheeseWidget* _tmp28_;
	CheeseWidget* _tmp29_;
	GtkGrid* _tmp30_;
	CheeseWidget* _tmp31_;
	GtkGrid* _tmp32_;
	CheeseFlash* _tmp33_;
	GtkStack* _tmp34_;
	g_return_val_if_fail (main_window != NULL, NULL);
	_data30_ = g_slice_new0 (Block30Data);
	_data30_->_ref_count_ = 1;
	_tmp0_ = contact;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data30_->contact);
	_data30_->contact = _tmp1_;
	_tmp2_ = main_window;
	self = (ContactsAvatarDialog*) g_object_new (object_type, "transient-for", _tmp2_, "use-header-bar", 1, NULL);
	_data30_->self = g_object_ref (self);
	_tmp3_ = gnome_desktop_thumbnail_factory_new (GNOME_DESKTOP_THUMBNAIL_SIZE_NORMAL);
	_g_object_unref0 (self->priv->thumbnail_factory);
	self->priv->thumbnail_factory = _tmp3_;
	_tmp4_ = _data30_->contact;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->contact);
	self->priv->contact = _tmp5_;
	_tmp6_ = contacts_contact_frame_new (CONTACTS_AVATAR_DIALOG_MAIN_SIZE, FALSE);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->current_avatar);
	self->priv->current_avatar = _tmp6_;
	_tmp7_ = _data30_->contact;
	if (_tmp7_ != NULL) {
		ContactsContact* _tmp8_;
		ContactsContactFrame* _tmp9_;
		_tmp8_ = _data30_->contact;
		_tmp9_ = self->priv->current_avatar;
		contacts_contact_keep_widget_uptodate (_tmp8_, (GtkWidget*) _tmp9_, ____lambda56__gtk_callback, block30_data_ref (_data30_), block30_data_unref);
	} else {
		ContactsContactFrame* _tmp10_;
		_tmp10_ = self->priv->current_avatar;
		contacts_contact_frame_set_image (_tmp10_, NULL, NULL);
	}
	_tmp11_ = self->priv->current_avatar;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp11_, FALSE);
	_tmp12_ = self->priv->current_avatar;
	gtk_widget_show ((GtkWidget*) _tmp12_);
	_tmp13_ = self->priv->grid;
	_tmp14_ = self->priv->current_avatar;
	gtk_grid_attach (_tmp13_, (GtkWidget*) _tmp14_, 0, 0, 1, 1);
	_tmp15_ = _data30_->contact;
	if (_tmp15_ != NULL) {
		GtkLabel* _tmp16_;
		ContactsContact* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		_tmp16_ = self->priv->contact_name_label;
		_tmp17_ = _data30_->contact;
		_tmp18_ = contacts_contact_get_display_name (_tmp17_);
		_tmp19_ = _tmp18_;
		gtk_label_set_label (_tmp16_, _tmp19_);
	}
	_tmp20_ = self->priv->webcam_button_box;
	gtk_widget_show ((GtkWidget*) _tmp20_);
	_tmp21_ = (CheeseCameraDeviceMonitor*) cheese_camera_device_monitor_new ();
	_g_object_unref0 (self->priv->camera_monitor);
	self->priv->camera_monitor = _tmp21_;
	_tmp22_ = self->priv->camera_monitor;
	g_signal_connect_object (_tmp22_, "added", (GCallback) ___lambda57__cheese_camera_device_monitor_added, self, 0);
	_tmp23_ = self->priv->camera_monitor;
	g_signal_connect_object (_tmp23_, "removed", (GCallback) ___lambda58__cheese_camera_device_monitor_removed, self, 0);
	_tmp24_ = g_thread_new ("camera-loader", ___lambda59__gthread_func, g_object_ref (self));
	_tmp25_ = _tmp24_;
	_g_thread_unref0 (_tmp25_);
	_tmp26_ = (CheeseWidget*) cheese_widget_new ();
	g_object_ref_sink (_tmp26_);
	_g_object_unref0 (self->priv->cheese);
	self->priv->cheese = _tmp26_;
	_tmp27_ = self->priv->cheese;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp27_, TRUE);
	_tmp28_ = self->priv->cheese;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp28_, TRUE);
	_tmp29_ = self->priv->cheese;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp29_, TRUE);
	_tmp30_ = self->priv->photobooth_page;
	_tmp31_ = self->priv->cheese;
	gtk_grid_attach (_tmp30_, (GtkWidget*) _tmp31_, 0, 0, 1, 1);
	_tmp32_ = self->priv->photobooth_page;
	gtk_widget_show ((GtkWidget*) _tmp32_);
	_tmp33_ = (CheeseFlash*) cheese_flash_new ((GtkWidget*) self);
	g_object_ref_sink (_tmp33_);
	_g_object_unref0 (self->priv->flash);
	self->priv->flash = _tmp33_;
	_tmp34_ = self->priv->views_stack;
	gtk_stack_set_visible_child_name (_tmp34_, "thumbnail-page");
	contacts_avatar_dialog_update_thumbnail_grids (self);
	block30_data_unref (_data30_);
	_data30_ = NULL;
	return self;
}


ContactsAvatarDialog* contacts_avatar_dialog_new (ContactsWindow* main_window, ContactsContact* contact) {
	return contacts_avatar_dialog_construct (CONTACTS_TYPE_AVATAR_DIALOG, main_window, contact);
}


static GdkPixbuf* contacts_avatar_dialog_scale_pixbuf_for_avatar_use (ContactsAvatarDialog* self, GdkPixbuf* pixbuf) {
	GdkPixbuf* result = NULL;
	gint w = 0;
	GdkPixbuf* _tmp0_;
	gint _tmp1_;
	gint h = 0;
	GdkPixbuf* _tmp2_;
	gint _tmp3_;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_;
	gint _tmp9_;
	gint _tmp10_;
	GdkPixbuf* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	GdkPixbuf* _tmp20_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pixbuf != NULL, NULL);
	_tmp0_ = pixbuf;
	_tmp1_ = gdk_pixbuf_get_width (_tmp0_);
	w = _tmp1_;
	_tmp2_ = pixbuf;
	_tmp3_ = gdk_pixbuf_get_height (_tmp2_);
	h = _tmp3_;
	_tmp5_ = w;
	if (_tmp5_ <= 128) {
		gint _tmp6_;
		_tmp6_ = h;
		_tmp4_ = _tmp6_ <= 128;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GdkPixbuf* _tmp7_;
		GdkPixbuf* _tmp8_;
		_tmp7_ = pixbuf;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		result = _tmp8_;
		return result;
	}
	_tmp9_ = w;
	_tmp10_ = h;
	if (_tmp9_ > _tmp10_) {
		gint _tmp11_;
		gint _tmp12_;
		gdouble _tmp13_;
		_tmp11_ = h;
		_tmp12_ = w;
		_tmp13_ = round ((_tmp11_ * 128.0) / _tmp12_);
		h = (gint) _tmp13_;
		w = 128;
	} else {
		gint _tmp14_;
		gint _tmp15_;
		gdouble _tmp16_;
		_tmp14_ = w;
		_tmp15_ = h;
		_tmp16_ = round ((_tmp14_ * 128.0) / _tmp15_);
		w = (gint) _tmp16_;
		h = 128;
	}
	_tmp17_ = pixbuf;
	_tmp18_ = w;
	_tmp19_ = h;
	_tmp20_ = gdk_pixbuf_scale_simple (_tmp17_, _tmp18_, _tmp19_, GDK_INTERP_HYPER);
	result = _tmp20_;
	return result;
}


static Block31Data* block31_data_ref (Block31Data* _data31_) {
	g_atomic_int_inc (&_data31_->_ref_count_);
	return _data31_;
}


static void block31_data_unref (void * _userdata_) {
	Block31Data* _data31_;
	_data31_ = (Block31Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data31_->_ref_count_)) {
		ContactsAvatarDialog* self;
		self = _data31_->self;
		_g_object_unref0 (_data31_->avatar_pixbuf);
		_g_object_unref0 (self);
		g_slice_free (Block31Data, _data31_);
	}
}


static void __lambda60_ (Block31Data* _data31_) {
	ContactsAvatarDialog* self;
	self = _data31_->self;
	contacts_avatar_dialog_selected_pixbuf (self, _data31_->avatar_pixbuf);
}


static void ___lambda60__contacts_contact_frame_clicked (ContactsContactFrame* _sender, gpointer self) {
	__lambda60_ (self);
}


static ContactsContactFrame* contacts_avatar_dialog_create_frame (ContactsAvatarDialog* self, GdkPixbuf* source_pixbuf) {
	ContactsContactFrame* result = NULL;
	Block31Data* _data31_;
	ContactsContactFrame* image_frame = NULL;
	ContactsContactFrame* _tmp0_;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (source_pixbuf != NULL, NULL);
	_data31_ = g_slice_new0 (Block31Data);
	_data31_->_ref_count_ = 1;
	_data31_->self = g_object_ref (self);
	_tmp0_ = contacts_contact_frame_new (CONTACTS_AVATAR_DIALOG_ICONS_SIZE, TRUE);
	g_object_ref_sink (_tmp0_);
	image_frame = _tmp0_;
	_tmp1_ = source_pixbuf;
	_tmp2_ = gdk_pixbuf_scale_simple (_tmp1_, CONTACTS_AVATAR_DIALOG_ICONS_SIZE, CONTACTS_AVATAR_DIALOG_ICONS_SIZE, GDK_INTERP_HYPER);
	pixbuf = _tmp2_;
	contacts_contact_frame_set_pixbuf (image_frame, pixbuf);
	_tmp3_ = source_pixbuf;
	_tmp4_ = contacts_avatar_dialog_scale_pixbuf_for_avatar_use (self, _tmp3_);
	_data31_->avatar_pixbuf = _tmp4_;
	g_signal_connect_data (image_frame, "clicked", (GCallback) ___lambda60__contacts_contact_frame_clicked, block31_data_ref (_data31_), (GClosureNotify) block31_data_unref, 0);
	result = image_frame;
	_g_object_unref0 (pixbuf);
	block31_data_unref (_data31_);
	_data31_ = NULL;
	return result;
}


static ContactsContactFrame* contacts_avatar_dialog_frame_for_persona (ContactsAvatarDialog* self, FolksPersona* persona) {
	ContactsContactFrame* result = NULL;
	FolksAvatarDetails* details = NULL;
	FolksPersona* _tmp0_;
	FolksAvatarDetails* _tmp1_;
	gboolean _tmp2_ = FALSE;
	FolksAvatarDetails* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (persona != NULL, NULL);
	_tmp0_ = persona;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, FOLKS_TYPE_AVATAR_DETAILS) ? ((FolksAvatarDetails*) _tmp0_) : NULL);
	details = _tmp1_;
	_tmp3_ = details;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		FolksAvatarDetails* _tmp4_;
		GLoadableIcon* _tmp5_;
		GLoadableIcon* _tmp6_;
		_tmp4_ = details;
		_tmp5_ = folks_avatar_details_get_avatar (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ == NULL;
	}
	if (_tmp2_) {
		result = NULL;
		_g_object_unref0 (details);
		return result;
	}
	{
		GInputStream* stream = NULL;
		FolksAvatarDetails* _tmp7_;
		GLoadableIcon* _tmp8_;
		GLoadableIcon* _tmp9_;
		GInputStream* _tmp10_;
		GdkPixbuf* pixbuf = NULL;
		GInputStream* _tmp11_;
		GdkPixbuf* _tmp12_;
		GdkPixbuf* _tmp13_;
		ContactsContactFrame* _tmp14_;
		_tmp7_ = details;
		_tmp8_ = folks_avatar_details_get_avatar (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_loadable_icon_load (_tmp9_, 128, NULL, NULL, &_inner_error_);
		stream = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch33_g_error;
		}
		_tmp11_ = stream;
		_tmp12_ = gdk_pixbuf_new_from_stream (_tmp11_, NULL, &_inner_error_);
		pixbuf = _tmp12_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (stream);
			goto __catch33_g_error;
		}
		_tmp13_ = pixbuf;
		_tmp14_ = contacts_avatar_dialog_create_frame (self, _tmp13_);
		result = _tmp14_;
		_g_object_unref0 (pixbuf);
		_g_object_unref0 (stream);
		_g_object_unref0 (details);
		return result;
	}
	goto __finally33;
	__catch33_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally33:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (details);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (details);
	return result;
}


static ContactsContactFrame* contacts_avatar_dialog_frame_for_filename (ContactsAvatarDialog* self, const gchar* filename) {
	ContactsContactFrame* result = NULL;
	ContactsContactFrame* image_frame = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	image_frame = NULL;
	{
		GdkPixbuf* pixbuf = NULL;
		const gchar* _tmp0_;
		GdkPixbuf* _tmp1_;
		ContactsContactFrame* _tmp2_;
		_tmp0_ = filename;
		_tmp1_ = gdk_pixbuf_new_from_file (_tmp0_, &_inner_error_);
		pixbuf = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch34_g_error;
		}
		_tmp2_ = contacts_avatar_dialog_create_frame (self, pixbuf);
		result = _tmp2_;
		_g_object_unref0 (pixbuf);
		_g_object_unref0 (image_frame);
		return result;
	}
	goto __finally34;
	__catch34_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally34:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (image_frame);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = image_frame;
	return result;
}


static void contacts_avatar_dialog_selected_pixbuf (ContactsAvatarDialog* self, GdkPixbuf* pixbuf) {
	GdkPixbuf* p = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	ContactsContactFrame* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pixbuf != NULL);
	_tmp0_ = pixbuf;
	_tmp1_ = gdk_pixbuf_scale_simple (_tmp0_, CONTACTS_AVATAR_DIALOG_MAIN_SIZE, CONTACTS_AVATAR_DIALOG_MAIN_SIZE, GDK_INTERP_HYPER);
	p = _tmp1_;
	_tmp2_ = self->priv->current_avatar;
	contacts_contact_frame_set_pixbuf (_tmp2_, p);
	_tmp3_ = pixbuf;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->new_pixbuf);
	self->priv->new_pixbuf = _tmp4_;
	gtk_dialog_set_response_sensitive ((GtkDialog*) self, (gint) GTK_RESPONSE_OK, TRUE);
	_g_object_unref0 (p);
}


static void contacts_avatar_dialog_update_thumbnail_grids (ContactsAvatarDialog* self) {
	ContactsContact* _tmp0_;
	GtkFlowBox* _tmp15_;
	gchar** stock_files = NULL;
	gint _tmp16_;
	gchar** _tmp17_;
	gint stock_files_length1;
	gint _stock_files_size_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	GtkFlowBox* _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->contact;
	if (_tmp0_ != NULL) {
		{
			GeeIterator* _p_it = NULL;
			ContactsContact* _tmp1_;
			FolksIndividual* _tmp2_;
			GeeSet* _tmp3_;
			GeeSet* _tmp4_;
			GeeIterator* _tmp5_;
			_tmp1_ = self->priv->contact;
			_tmp2_ = _tmp1_->individual;
			_tmp3_ = folks_individual_get_personas (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
			_p_it = _tmp5_;
			while (TRUE) {
				GeeIterator* _tmp6_;
				gboolean _tmp7_;
				FolksPersona* p = NULL;
				GeeIterator* _tmp8_;
				gpointer _tmp9_;
				ContactsContactFrame* frame = NULL;
				FolksPersona* _tmp10_;
				ContactsContactFrame* _tmp11_;
				ContactsContactFrame* _tmp12_;
				_tmp6_ = _p_it;
				_tmp7_ = gee_iterator_next (_tmp6_);
				if (!_tmp7_) {
					break;
				}
				_tmp8_ = _p_it;
				_tmp9_ = gee_iterator_get (_tmp8_);
				p = (FolksPersona*) _tmp9_;
				_tmp10_ = p;
				_tmp11_ = contacts_avatar_dialog_frame_for_persona (self, _tmp10_);
				frame = _tmp11_;
				_tmp12_ = frame;
				if (_tmp12_ != NULL) {
					GtkFlowBox* _tmp13_;
					ContactsContactFrame* _tmp14_;
					_tmp13_ = self->priv->personas_thumbnail_grid;
					_tmp14_ = frame;
					gtk_container_add ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp14_);
				}
				_g_object_unref0 (frame);
				_g_object_unref0 (p);
			}
			_g_object_unref0 (_p_it);
		}
	}
	_tmp15_ = self->priv->personas_thumbnail_grid;
	gtk_widget_show_all ((GtkWidget*) _tmp15_);
	_tmp17_ = contacts_utils_get_stock_avatars (&_tmp16_);
	stock_files = _tmp17_;
	stock_files_length1 = _tmp16_;
	_stock_files_size_ = stock_files_length1;
	_tmp18_ = stock_files;
	_tmp18__length1 = stock_files_length1;
	{
		gchar** file_name_collection = NULL;
		gint file_name_collection_length1 = 0;
		gint _file_name_collection_size_ = 0;
		gint file_name_it = 0;
		file_name_collection = _tmp18_;
		file_name_collection_length1 = _tmp18__length1;
		for (file_name_it = 0; file_name_it < _tmp18__length1; file_name_it = file_name_it + 1) {
			gchar* _tmp19_;
			gchar* file_name = NULL;
			_tmp19_ = g_strdup (file_name_collection[file_name_it]);
			file_name = _tmp19_;
			{
				ContactsContactFrame* frame = NULL;
				const gchar* _tmp20_;
				ContactsContactFrame* _tmp21_;
				ContactsContactFrame* _tmp22_;
				_tmp20_ = file_name;
				_tmp21_ = contacts_avatar_dialog_frame_for_filename (self, _tmp20_);
				frame = _tmp21_;
				_tmp22_ = frame;
				if (_tmp22_ != NULL) {
					GtkFlowBox* _tmp23_;
					ContactsContactFrame* _tmp24_;
					_tmp23_ = self->priv->stock_thumbnail_grid;
					_tmp24_ = frame;
					gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
				}
				_g_object_unref0 (frame);
				_g_free0 (file_name);
			}
		}
	}
	_tmp25_ = self->priv->stock_thumbnail_grid;
	gtk_widget_show_all ((GtkWidget*) _tmp25_);
	stock_files = (_vala_array_free (stock_files, stock_files_length1, (GDestroyNotify) g_free), NULL);
}


void contacts_avatar_dialog_update_preview (ContactsAvatarDialog* self, GtkFileChooser* chooser) {
	gchar* uri = NULL;
	GtkFileChooser* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GtkFileChooser* _tmp26_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (chooser != NULL);
	_tmp0_ = chooser;
	_tmp1_ = gtk_file_chooser_get_preview_uri (_tmp0_);
	uri = _tmp1_;
	_tmp2_ = uri;
	if (_tmp2_ != NULL) {
		GdkPixbuf* pixbuf = NULL;
		GtkImage* preview = NULL;
		GtkFileChooser* _tmp3_;
		GtkWidget* _tmp4_;
		GtkImage* _tmp5_;
		GFile* file = NULL;
		const gchar* _tmp6_;
		GFile* _tmp7_;
		GtkFileChooser* _tmp20_;
		GdkPixbuf* _tmp21_;
		GdkPixbuf* _tmp22_;
		pixbuf = NULL;
		_tmp3_ = chooser;
		_tmp4_ = gtk_file_chooser_get_preview_widget (_tmp3_);
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_image_get_type ()) ? ((GtkImage*) _tmp4_) : NULL);
		preview = _tmp5_;
		_tmp6_ = uri;
		_tmp7_ = g_file_new_for_uri (_tmp6_);
		file = _tmp7_;
		{
			GFileInfo* file_info = NULL;
			GFile* _tmp8_;
			GFileInfo* _tmp9_;
			GFileInfo* _tmp10_;
			_tmp8_ = file;
			_tmp9_ = g_file_query_info (_tmp8_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
			file_info = _tmp9_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch35_g_error;
			}
			_tmp10_ = file_info;
			if (_tmp10_ != NULL) {
				gchar* mime_type = NULL;
				GFileInfo* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				const gchar* _tmp14_;
				_tmp11_ = file_info;
				_tmp12_ = g_file_info_get_content_type (_tmp11_);
				_tmp13_ = g_strdup (_tmp12_);
				mime_type = _tmp13_;
				_tmp14_ = mime_type;
				if (_tmp14_ != NULL) {
					GnomeDesktopThumbnailFactory* _tmp15_;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
					GdkPixbuf* _tmp18_;
					GdkPixbuf* _tmp19_;
					_tmp15_ = self->priv->thumbnail_factory;
					_tmp16_ = uri;
					_tmp17_ = mime_type;
					_tmp18_ = gnome_desktop_thumbnail_factory_generate_thumbnail (_tmp15_, _tmp16_, _tmp17_);
					_tmp19_ = _g_object_ref0 (_tmp18_);
					_g_object_unref0 (pixbuf);
					pixbuf = _tmp19_;
				}
				_g_free0 (mime_type);
			}
			_g_object_unref0 (file_info);
		}
		goto __finally35;
		__catch35_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally35:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (file);
			_g_object_unref0 (preview);
			_g_object_unref0 (pixbuf);
			_g_free0 (uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp20_ = chooser;
		_tmp21_ = pixbuf;
		gtk_dialog_set_response_sensitive (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp20_) : NULL, (gint) GTK_RESPONSE_ACCEPT, _tmp21_ != NULL);
		_tmp22_ = pixbuf;
		if (_tmp22_ != NULL) {
			GtkImage* _tmp23_;
			GdkPixbuf* _tmp24_;
			_tmp23_ = preview;
			_tmp24_ = pixbuf;
			gtk_image_set_from_pixbuf (_tmp23_, _tmp24_);
		} else {
			GtkImage* _tmp25_;
			_tmp25_ = preview;
			gtk_image_set_from_icon_name (_tmp25_, "dialog-question", GTK_ICON_SIZE_DIALOG);
		}
		_g_object_unref0 (file);
		_g_object_unref0 (preview);
		_g_object_unref0 (pixbuf);
	}
	_tmp26_ = chooser;
	gtk_file_chooser_set_preview_widget_active (_tmp26_, TRUE);
	_g_free0 (uri);
}


static void contacts_avatar_dialog_set_crop_widget (ContactsAvatarDialog* self, GdkPixbuf* pixbuf) {
	CcCropArea* _tmp0_;
	CcCropArea* _tmp1_;
	CcCropArea* _tmp2_;
	CcCropArea* _tmp3_;
	CcCropArea* _tmp4_;
	CcCropArea* _tmp5_;
	GdkPixbuf* _tmp6_;
	GtkGrid* _tmp7_;
	CcCropArea* _tmp8_;
	GtkGrid* _tmp9_;
	GtkStack* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pixbuf != NULL);
	_tmp0_ = (CcCropArea*) cc_crop_area_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->crop_area);
	self->priv->crop_area = _tmp0_;
	_tmp1_ = self->priv->crop_area;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = self->priv->crop_area;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp2_, TRUE);
	_tmp3_ = self->priv->crop_area;
	cc_crop_area_set_min_size (_tmp3_, 48, 48);
	_tmp4_ = self->priv->crop_area;
	cc_crop_area_set_constrain_aspect (_tmp4_, TRUE);
	_tmp5_ = self->priv->crop_area;
	_tmp6_ = pixbuf;
	cc_crop_area_set_picture (_tmp5_, _tmp6_);
	_tmp7_ = self->priv->crop_page;
	_tmp8_ = self->priv->crop_area;
	gtk_grid_attach (_tmp7_, (GtkWidget*) _tmp8_, 0, 0, 1, 1);
	_tmp9_ = self->priv->crop_page;
	gtk_widget_show_all ((GtkWidget*) _tmp9_);
	_tmp10_ = self->priv->views_stack;
	gtk_stack_set_visible_child_name (_tmp10_, "crop-page");
}


static void contacts_avatar_dialog_real_response (GtkDialog* base, gint response_id) {
	ContactsAvatarDialog * self;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	self = (ContactsAvatarDialog*) base;
	_tmp1_ = response_id;
	if (_tmp1_ == ((gint) GTK_RESPONSE_OK)) {
		GdkPixbuf* _tmp2_;
		_tmp2_ = self->priv->new_pixbuf;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			guint8* buffer = NULL;
			gint buffer_length1 = 0;
			gint _buffer_size_ = 0;
			gboolean _tmp3_ = FALSE;
			GdkPixbuf* _tmp4_;
			guint8* _tmp5_ = NULL;
			gsize _tmp6_;
			gboolean _tmp7_;
			_tmp4_ = self->priv->new_pixbuf;
			_tmp7_ = gdk_pixbuf_save_to_buffer (_tmp4_, &_tmp5_, &_tmp6_, "png", &_inner_error_, NULL, NULL);
			buffer = (g_free (buffer), NULL);
			buffer = _tmp5_;
			buffer_length1 = _tmp6_;
			_buffer_size_ = buffer_length1;
			_tmp3_ = _tmp7_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				buffer = (g_free (buffer), NULL);
				goto __catch36_g_error;
			}
			if (_tmp3_) {
				GBytesIcon* icon = NULL;
				guint8* _tmp8_;
				gint _tmp8__length1;
				GBytes* _tmp9_;
				GBytes* _tmp10_;
				GBytesIcon* _tmp11_;
				GBytesIcon* _tmp12_;
				GBytesIcon* _tmp13_;
				_tmp8_ = buffer;
				_tmp8__length1 = buffer_length1;
				_tmp9_ = g_bytes_new (_tmp8_, _tmp8__length1);
				_tmp10_ = _tmp9_;
				_tmp11_ = (GBytesIcon*) g_bytes_icon_new (_tmp10_);
				_tmp12_ = _tmp11_;
				_g_bytes_unref0 (_tmp10_);
				icon = _tmp12_;
				_tmp13_ = icon;
				g_signal_emit (self, contacts_avatar_dialog_signals[CONTACTS_AVATAR_DIALOG_SET_AVATAR_SIGNAL], 0, (GIcon*) _tmp13_);
				_g_object_unref0 (icon);
			} else {
			}
			buffer = (g_free (buffer), NULL);
		}
		goto __finally36;
		__catch36_g_error:
		{
			g_clear_error (&_inner_error_);
			_inner_error_ = NULL;
		}
		__finally36:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (self->priv->cheese);
	self->priv->cheese = NULL;
	gtk_widget_destroy ((GtkWidget*) self);
}


static Block32Data* block32_data_ref (Block32Data* _data32_) {
	g_atomic_int_inc (&_data32_->_ref_count_);
	return _data32_;
}


static void block32_data_unref (void * _userdata_) {
	Block32Data* _data32_;
	_data32_ = (Block32Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data32_->_ref_count_)) {
		ContactsAvatarDialog* self;
		self = _data32_->self;
		_g_object_unref0 (_data32_->chooser);
		_g_object_unref0 (self);
		g_slice_free (Block32Data, _data32_);
	}
}


static void _contacts_avatar_dialog_update_preview_gtk_file_chooser_update_preview (GtkFileChooser* _sender, gpointer self) {
	contacts_avatar_dialog_update_preview ((ContactsAvatarDialog*) self, _sender);
}


static void __lambda61_ (Block32Data* _data32_, gint response) {
	ContactsAvatarDialog* self;
	gint _tmp0_;
	GtkFileChooserDialog* _tmp21_;
	GError * _inner_error_ = NULL;
	self = _data32_->self;
	_tmp0_ = response;
	if (_tmp0_ != ((gint) GTK_RESPONSE_ACCEPT)) {
		GtkFileChooserDialog* _tmp1_;
		_tmp1_ = _data32_->chooser;
		gtk_widget_destroy ((GtkWidget*) _tmp1_);
		return;
	}
	{
		GFile* file = NULL;
		GtkFileChooserDialog* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		GFileInputStream* in_stream = NULL;
		GFile* _tmp7_;
		GFileInputStream* _tmp8_;
		GdkPixbuf* pixbuf = NULL;
		GFileInputStream* _tmp9_;
		GdkPixbuf* _tmp10_;
		GFileInputStream* _tmp11_;
		gboolean _tmp12_ = FALSE;
		GdkPixbuf* _tmp13_;
		gint _tmp14_;
		_tmp2_ = _data32_->chooser;
		_tmp3_ = gtk_file_chooser_get_uri ((GtkFileChooser*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_new_for_uri (_tmp4_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		file = _tmp6_;
		_tmp7_ = file;
		_tmp8_ = g_file_read (_tmp7_, NULL, &_inner_error_);
		in_stream = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (file);
			goto __catch37_g_error;
		}
		_tmp9_ = in_stream;
		_tmp10_ = gdk_pixbuf_new_from_stream ((GInputStream*) _tmp9_, NULL, &_inner_error_);
		pixbuf = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (in_stream);
			_g_object_unref0 (file);
			goto __catch37_g_error;
		}
		_tmp11_ = in_stream;
		g_input_stream_close ((GInputStream*) _tmp11_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (pixbuf);
			_g_object_unref0 (in_stream);
			_g_object_unref0 (file);
			goto __catch37_g_error;
		}
		_tmp13_ = pixbuf;
		_tmp14_ = gdk_pixbuf_get_width (_tmp13_);
		if (_tmp14_ > 128) {
			_tmp12_ = TRUE;
		} else {
			GdkPixbuf* _tmp15_;
			gint _tmp16_;
			_tmp15_ = pixbuf;
			_tmp16_ = gdk_pixbuf_get_height (_tmp15_);
			_tmp12_ = _tmp16_ > 128;
		}
		if (_tmp12_) {
			GdkPixbuf* _tmp17_;
			_tmp17_ = pixbuf;
			contacts_avatar_dialog_set_crop_widget (self, _tmp17_);
		} else {
			GdkPixbuf* _tmp18_;
			GdkPixbuf* _tmp19_;
			GdkPixbuf* _tmp20_;
			_tmp18_ = pixbuf;
			_tmp19_ = contacts_avatar_dialog_scale_pixbuf_for_avatar_use (self, _tmp18_);
			_tmp20_ = _tmp19_;
			contacts_avatar_dialog_selected_pixbuf (self, _tmp20_);
			_g_object_unref0 (_tmp20_);
		}
		contacts_avatar_dialog_update_thumbnail_grids (self);
		_g_object_unref0 (pixbuf);
		_g_object_unref0 (in_stream);
		_g_object_unref0 (file);
	}
	goto __finally37;
	__catch37_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally37:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp21_ = _data32_->chooser;
	gtk_widget_destroy ((GtkWidget*) _tmp21_);
}


static void ___lambda61__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda61_ (self, response_id);
}


static void contacts_avatar_dialog_select_avatar_file_cb (ContactsAvatarDialog* self, GtkButton* button) {
	Block32Data* _data32_;
	GtkWidget* _tmp0_;
	GtkFileChooserDialog* _tmp1_;
	GtkFileChooserDialog* _tmp2_;
	GtkFileChooserDialog* _tmp3_;
	GtkImage* preview = NULL;
	GtkImage* _tmp4_;
	GtkImage* _tmp5_;
	GtkFileChooserDialog* _tmp6_;
	GtkImage* _tmp7_;
	GtkFileChooserDialog* _tmp8_;
	GtkImage* _tmp9_;
	GtkFileChooserDialog* _tmp10_;
	gchar* folder = NULL;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	GtkFileChooserDialog* _tmp16_;
	GtkFileChooserDialog* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_data32_ = g_slice_new0 (Block32Data);
	_data32_->_ref_count_ = 1;
	_data32_->self = g_object_ref (self);
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp1_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Browse for more pictures"), G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_window_get_type (), GtkWindow), GTK_FILE_CHOOSER_ACTION_OPEN, _ ("_Cancel"), GTK_RESPONSE_CANCEL, _ ("_Open"), GTK_RESPONSE_ACCEPT, NULL);
	g_object_ref_sink (_tmp1_);
	_data32_->chooser = _tmp1_;
	_tmp2_ = _data32_->chooser;
	gtk_window_set_modal ((GtkWindow*) _tmp2_, TRUE);
	_tmp3_ = _data32_->chooser;
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp3_, FALSE);
	_tmp4_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp4_);
	preview = _tmp4_;
	_tmp5_ = preview;
	gtk_widget_set_size_request ((GtkWidget*) _tmp5_, 128, -1);
	_tmp6_ = _data32_->chooser;
	_tmp7_ = preview;
	gtk_file_chooser_set_preview_widget ((GtkFileChooser*) _tmp6_, (GtkWidget*) _tmp7_);
	_tmp8_ = _data32_->chooser;
	gtk_file_chooser_set_use_preview_label ((GtkFileChooser*) _tmp8_, FALSE);
	_tmp9_ = preview;
	gtk_widget_show ((GtkWidget*) _tmp9_);
	_tmp10_ = _data32_->chooser;
	g_signal_connect_object ((GtkFileChooser*) _tmp10_, "update-preview", (GCallback) _contacts_avatar_dialog_update_preview_gtk_file_chooser_update_preview, self, 0);
	_tmp11_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
	_tmp12_ = g_strdup (_tmp11_);
	folder = _tmp12_;
	_tmp13_ = folder;
	if (_tmp13_ != NULL) {
		GtkFileChooserDialog* _tmp14_;
		const gchar* _tmp15_;
		_tmp14_ = _data32_->chooser;
		_tmp15_ = folder;
		gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp14_, _tmp15_);
	}
	_tmp16_ = _data32_->chooser;
	g_signal_connect_data ((GtkDialog*) _tmp16_, "response", (GCallback) ___lambda61__gtk_dialog_response, block32_data_ref (_data32_), (GClosureNotify) block32_data_unref, 0);
	_tmp17_ = _data32_->chooser;
	gtk_window_present ((GtkWindow*) _tmp17_);
	_g_free0 (folder);
	_g_object_unref0 (preview);
	block32_data_unref (_data32_);
	_data32_ = NULL;
}


static void _contacts_avatar_dialog_select_avatar_file_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	contacts_avatar_dialog_select_avatar_file_cb ((ContactsAvatarDialog*) self, _sender);
}


static void contacts_avatar_dialog_on_webcam_button_clicked (ContactsAvatarDialog* self, GtkButton* button) {
	GtkStack* _tmp0_;
	CheeseWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->views_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "photobooth-page");
	_tmp1_ = self->priv->cheese;
	gtk_widget_show ((GtkWidget*) _tmp1_);
}


static void _contacts_avatar_dialog_on_webcam_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	contacts_avatar_dialog_on_webcam_button_clicked ((ContactsAvatarDialog*) self, _sender);
}


static void __lambda62_ (ContactsAvatarDialog* self, GdkPixbuf* pix) {
	GdkPixbuf* _tmp0_;
	CheeseWidget* _tmp1_;
	g_return_if_fail (pix != NULL);
	_tmp0_ = pix;
	contacts_avatar_dialog_set_crop_widget (self, _tmp0_);
	_tmp1_ = self->priv->cheese;
	gtk_widget_hide ((GtkWidget*) _tmp1_);
}


static void ___lambda62__cheese_camera_photo_taken (CheeseCamera* _sender, GdkPixbuf* pixbuf, gpointer self) {
	__lambda62_ ((ContactsAvatarDialog*) self, pixbuf);
}


static void contacts_avatar_dialog_on_photobooth_page_select_button_clicked (ContactsAvatarDialog* self, GtkButton* button) {
	CheeseCamera* camera = NULL;
	CheeseWidget* _tmp0_;
	GObject* _tmp1_;
	CheeseCamera* _tmp2_;
	CheeseFlash* _tmp3_;
	CheeseCamera* _tmp4_;
	CheeseCamera* _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->cheese;
	_tmp1_ = cheese_widget_get_camera (_tmp0_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, CHEESE_TYPE_CAMERA) ? ((CheeseCamera*) _tmp1_) : NULL);
	camera = _tmp2_;
	_tmp3_ = self->priv->flash;
	cheese_flash_fire (_tmp3_);
	_tmp4_ = camera;
	g_signal_connect_object (_tmp4_, "photo-taken", (GCallback) ___lambda62__cheese_camera_photo_taken, self, 0);
	_tmp5_ = camera;
	_tmp6_ = cheese_camera_take_photo_pixbuf (_tmp5_);
	if (!_tmp6_) {
		g_warning ("contacts-avatar-dialog.vala:364: Unable to take photo");
	}
	_g_object_unref0 (camera);
}


static void _contacts_avatar_dialog_on_photobooth_page_select_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	contacts_avatar_dialog_on_photobooth_page_select_button_clicked ((ContactsAvatarDialog*) self, _sender);
}


static void contacts_avatar_dialog_on_photobooth_page_cancel_button_clicked (ContactsAvatarDialog* self, GtkButton* button) {
	GtkStack* _tmp0_;
	CheeseWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->views_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "thumbnail-page");
	_tmp1_ = self->priv->cheese;
	gtk_widget_hide ((GtkWidget*) _tmp1_);
}


static void _contacts_avatar_dialog_on_photobooth_page_cancel_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	contacts_avatar_dialog_on_photobooth_page_cancel_button_clicked ((ContactsAvatarDialog*) self, _sender);
}


static void contacts_avatar_dialog_on_crop_page_select_button_clicked (ContactsAvatarDialog* self, GtkButton* button) {
	GdkPixbuf* pix = NULL;
	CcCropArea* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	CcCropArea* _tmp4_;
	GtkStack* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->crop_area;
	_tmp1_ = cc_crop_area_get_picture (_tmp0_);
	pix = _tmp1_;
	_tmp2_ = contacts_avatar_dialog_scale_pixbuf_for_avatar_use (self, pix);
	_tmp3_ = _tmp2_;
	contacts_avatar_dialog_selected_pixbuf (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->crop_area;
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->views_stack;
	gtk_stack_set_visible_child_name (_tmp5_, "thumbnail-page");
	_g_object_unref0 (pix);
}


static void _contacts_avatar_dialog_on_crop_page_select_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	contacts_avatar_dialog_on_crop_page_select_button_clicked ((ContactsAvatarDialog*) self, _sender);
}


static void contacts_avatar_dialog_on_crop_page_cancel_button_clicked (ContactsAvatarDialog* self, GtkButton* button) {
	CcCropArea* _tmp0_;
	GtkStack* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->crop_area;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->views_stack;
	gtk_stack_set_visible_child_name (_tmp1_, "thumbnail-page");
}


static void _contacts_avatar_dialog_on_crop_page_cancel_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	contacts_avatar_dialog_on_crop_page_cancel_button_clicked ((ContactsAvatarDialog*) self, _sender);
}


static void contacts_avatar_dialog_class_init (ContactsAvatarDialogClass * klass) {
	gint ContactsAvatarDialog_private_offset;
	contacts_avatar_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsAvatarDialogPrivate));
	((GtkDialogClass *) klass)->response = (void (*) (GtkDialog *, gint)) contacts_avatar_dialog_real_response;
	G_OBJECT_CLASS (klass)->finalize = contacts_avatar_dialog_finalize;
	ContactsAvatarDialog_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/contacts/ui/contacts-avatar-dialog.ui");
	/**
	   * Fired after the user has definitely chosen a new avatar.
	   */
	contacts_avatar_dialog_signals[CONTACTS_AVATAR_DIALOG_SET_AVATAR_SIGNAL] = g_signal_new ("set-avatar", CONTACTS_TYPE_AVATAR_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, g_icon_get_type ());
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "grid", FALSE, ContactsAvatarDialog_private_offset + G_STRUCT_OFFSET (ContactsAvatarDialogPrivate, grid));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "contact_name_label", FALSE, ContactsAvatarDialog_private_offset + G_STRUCT_OFFSET (ContactsAvatarDialogPrivate, contact_name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "views_stack", FALSE, ContactsAvatarDialog_private_offset + G_STRUCT_OFFSET (ContactsAvatarDialogPrivate, views_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "personas_thumbnail_grid", FALSE, ContactsAvatarDialog_private_offset + G_STRUCT_OFFSET (ContactsAvatarDialogPrivate, personas_thumbnail_grid));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stock_thumbnail_grid", FALSE, ContactsAvatarDialog_private_offset + G_STRUCT_OFFSET (ContactsAvatarDialogPrivate, stock_thumbnail_grid));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "crop_page", FALSE, ContactsAvatarDialog_private_offset + G_STRUCT_OFFSET (ContactsAvatarDialogPrivate, crop_page));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "photobooth_page", FALSE, ContactsAvatarDialog_private_offset + G_STRUCT_OFFSET (ContactsAvatarDialogPrivate, photobooth_page));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "webcam_button", FALSE, ContactsAvatarDialog_private_offset + G_STRUCT_OFFSET (ContactsAvatarDialogPrivate, webcam_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "webcam_button_box", FALSE, ContactsAvatarDialog_private_offset + G_STRUCT_OFFSET (ContactsAvatarDialogPrivate, webcam_button_box));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "select_avatar_file_cb", G_CALLBACK(_contacts_avatar_dialog_select_avatar_file_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_webcam_button_clicked", G_CALLBACK(_contacts_avatar_dialog_on_webcam_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_photobooth_page_select_button_clicked", G_CALLBACK(_contacts_avatar_dialog_on_photobooth_page_select_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_photobooth_page_cancel_button_clicked", G_CALLBACK(_contacts_avatar_dialog_on_photobooth_page_cancel_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_crop_page_select_button_clicked", G_CALLBACK(_contacts_avatar_dialog_on_crop_page_select_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_crop_page_cancel_button_clicked", G_CALLBACK(_contacts_avatar_dialog_on_crop_page_cancel_button_clicked_gtk_button_clicked));
}


static void contacts_avatar_dialog_instance_init (ContactsAvatarDialog * self) {
	self->priv = CONTACTS_AVATAR_DIALOG_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void contacts_avatar_dialog_finalize (GObject * obj) {
	ContactsAvatarDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_AVATAR_DIALOG, ContactsAvatarDialog);
	_g_object_unref0 (self->priv->contact);
	_g_object_unref0 (self->priv->thumbnail_factory);
	_g_object_unref0 (self->priv->grid);
	_g_object_unref0 (self->priv->contact_name_label);
	_g_object_unref0 (self->priv->views_stack);
	_g_object_unref0 (self->priv->personas_thumbnail_grid);
	_g_object_unref0 (self->priv->stock_thumbnail_grid);
	_g_object_unref0 (self->priv->crop_page);
	_g_object_unref0 (self->priv->crop_area);
	_g_object_unref0 (self->priv->photobooth_page);
	_g_object_unref0 (self->priv->webcam_button);
	_g_object_unref0 (self->priv->webcam_button_box);
	_g_object_unref0 (self->priv->current_avatar);
	_g_object_unref0 (self->priv->flash);
	_g_object_unref0 (self->priv->camera_monitor);
	_g_object_unref0 (self->priv->cheese);
	_g_object_unref0 (self->priv->new_pixbuf);
	G_OBJECT_CLASS (contacts_avatar_dialog_parent_class)->finalize (obj);
}


/**
 * The AvatarDialog can be used to choose the avatar for a contact.
 * This can be done by either choosing a stock thumbnail, an image file
 * provided by the user, or -if cheese is enabled- by using a webcam.
 *
 * After a user has initially chosen an avatar, we provide a cropping tool.
 */
GType contacts_avatar_dialog_get_type (void) {
	static volatile gsize contacts_avatar_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_avatar_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsAvatarDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_avatar_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsAvatarDialog), 0, (GInstanceInitFunc) contacts_avatar_dialog_instance_init, NULL };
		GType contacts_avatar_dialog_type_id;
		contacts_avatar_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "ContactsAvatarDialog", &g_define_type_info, 0);
		g_once_init_leave (&contacts_avatar_dialog_type_id__volatile, contacts_avatar_dialog_type_id);
	}
	return contacts_avatar_dialog_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



