/* ListsPage.c generated by valac 0.38.7, the Vala compiler
 * generated from ListsPage.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "CbBundle.h"
#include <stdlib.h>
#include <string.h>
#include "CbMessageReceiver.h"
#include "CbDeltaUpdater.h"
#include <gio/gio.h>
#include "rest/oauth-proxy.h"
#include "CbUserStream.h"
#include "CbUserCounter.h"
#include "CbFilter.h"
#include <json-glib/json-glib.h>
#include <glib/gi18n-lib.h>


#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;
typedef struct _ScrollWidgetPrivate ScrollWidgetPrivate;

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_LISTS_PAGE (lists_page_get_type ())
#define LISTS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LISTS_PAGE, ListsPage))
#define LISTS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LISTS_PAGE, ListsPageClass))
#define IS_LISTS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LISTS_PAGE))
#define IS_LISTS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LISTS_PAGE))
#define LISTS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LISTS_PAGE, ListsPageClass))

typedef struct _ListsPage ListsPage;
typedef struct _ListsPageClass ListsPageClass;
typedef struct _ListsPagePrivate ListsPagePrivate;

#define TYPE_BADGE_RADIO_BUTTON (badge_radio_button_get_type ())
#define BADGE_RADIO_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButton))
#define BADGE_RADIO_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButtonClass))
#define IS_BADGE_RADIO_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BADGE_RADIO_BUTTON))
#define IS_BADGE_RADIO_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BADGE_RADIO_BUTTON))
#define BADGE_RADIO_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButtonClass))

typedef struct _BadgeRadioButton BadgeRadioButton;
typedef struct _BadgeRadioButtonClass BadgeRadioButtonClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_USER_LISTS_WIDGET (user_lists_widget_get_type ())
#define USER_LISTS_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_LISTS_WIDGET, UserListsWidget))
#define USER_LISTS_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_LISTS_WIDGET, UserListsWidgetClass))
#define IS_USER_LISTS_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_LISTS_WIDGET))
#define IS_USER_LISTS_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_LISTS_WIDGET))
#define USER_LISTS_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_LISTS_WIDGET, UserListsWidgetClass))

typedef struct _UserListsWidget UserListsWidget;
typedef struct _UserListsWidgetClass UserListsWidgetClass;
enum  {
	LISTS_PAGE_0_PROPERTY,
	LISTS_PAGE_UNREAD_COUNT_PROPERTY,
	LISTS_PAGE_WINDOW_PROPERTY,
	LISTS_PAGE_ACCOUNT_PROPERTY,
	LISTS_PAGE_DELTA_UPDATER_PROPERTY,
	LISTS_PAGE_ID_PROPERTY,
	LISTS_PAGE_NUM_PROPERTIES
};
static GParamSpec* lists_page_properties[LISTS_PAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ListsPageLoadNewestData ListsPageLoadNewestData;

#define TYPE_LIST_LIST_ENTRY (list_list_entry_get_type ())
#define LIST_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIST_LIST_ENTRY, ListListEntry))
#define LIST_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIST_LIST_ENTRY, ListListEntryClass))
#define IS_LIST_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIST_LIST_ENTRY))
#define IS_LIST_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIST_LIST_ENTRY))
#define LIST_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIST_LIST_ENTRY, ListListEntryClass))

typedef struct _ListListEntry ListListEntry;
typedef struct _ListListEntryClass ListListEntryClass;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

#define TYPE_TWITTER_LIST (twitter_list_get_type ())
typedef struct _TwitterList TwitterList;
typedef struct _ListsPageGetUserListsData ListsPageGetUserListsData;

struct _ScrollWidget {
	GtkScrolledWindow parent_instance;
	ScrollWidgetPrivate * priv;
};

struct _ScrollWidgetClass {
	GtkScrolledWindowClass parent_class;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, CbBundle* args);
	void (*on_leave) (IPage* self);
	void (*create_radio_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_radio_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	void (*set_window) (IPage* self, MainWindow* value);
};

struct _ListsPage {
	ScrollWidget parent_instance;
	ListsPagePrivate * priv;
};

struct _ListsPageClass {
	ScrollWidgetClass parent_class;
};

struct _ListsPagePrivate {
	BadgeRadioButton* radio_button;
	gint _unread_count;
	MainWindow* main_window;
	Account* _account;
	CbDeltaUpdater* _delta_updater;
	gint _id;
	gboolean inited;
	gint64 user_id;
	UserListsWidget* user_lists_widget;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _ListsPageLoadNewestData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ListsPage* self;
	UserListsWidget* _tmp0_;
	gint64 _tmp1_;
};

struct _TwitterList {
	gint64 id;
	gchar* name;
	gchar* description;
	gchar* mode;
	guint n_members;
};

struct _ListsPageGetUserListsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ListsPage* self;
	TwitterList* result;
	gint result_length1;
	gboolean _tmp0_;
	UserListsWidget* _tmp1_;
	gint64 _tmp2_;
	UserListsWidget* _tmp3_;
	gint _tmp4_;
	TwitterList* _tmp5_;
	TwitterList* _tmp6_;
	gint _tmp6__length1;
};


static gpointer lists_page_parent_class = NULL;
static IPageIface * lists_page_ipage_parent_iface = NULL;
static CbMessageReceiverInterface * lists_page_cb_message_receiver_parent_iface = NULL;

GType scroll_widget_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType lists_page_get_type (void) G_GNUC_CONST;
GType badge_radio_button_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType user_lists_widget_get_type (void) G_GNUC_CONST;
#define LISTS_PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LISTS_PAGE, ListsPagePrivate))
#define LISTS_PAGE_KEY_MODE 0
#define LISTS_PAGE_KEY_LIST_ID 1
#define LISTS_PAGE_MODE_DELETE 1
ListsPage* lists_page_new (gint id, Account* account);
ListsPage* lists_page_construct (GType object_type, gint id, Account* account);
ScrollWidget* scroll_widget_new (void);
ScrollWidget* scroll_widget_construct (GType object_type);
void ipage_set_id (IPage* self, gint value);
void lists_page_set_account (ListsPage* self, Account* value);
UserListsWidget* user_lists_widget_new (void);
UserListsWidget* user_lists_widget_construct (GType object_type);
void user_lists_widget_set_account (UserListsWidget* self, Account* value);
static void lists_page_real_on_join (IPage* base, gint page_id, CbBundle* args);
Account* lists_page_get_account (ListsPage* self);
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
static void lists_page_load_newest (ListsPage* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void lists_page_load_newest_finish (ListsPage* self, GAsyncResult* _res_);
void user_lists_widget_remove_list (UserListsWidget* self, gint64 list_id);
static void lists_page_real_on_leave (IPage* base);
void user_lists_widget_unreveal (UserListsWidget* self);
static void lists_page_load_newest_data_free (gpointer _data);
static gboolean lists_page_load_newest_co (ListsPageLoadNewestData* _data_);
void user_lists_widget_load_lists (UserListsWidget* self, gint64 user_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void user_lists_widget_load_lists_finish (UserListsWidget* self, GAsyncResult* _res_);
static void lists_page_load_newest_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void lists_page_real_stream_message_received (CbMessageReceiver* base, CbStreamMessageType type, JsonNode* root);
GType list_list_entry_get_type (void) G_GNUC_CONST;
ListListEntry* list_list_entry_new_from_json_data (JsonObject* obj, Account* account);
ListListEntry* list_list_entry_construct_from_json_data (GType object_type, JsonObject* obj, Account* account);
void user_lists_widget_add_list (UserListsWidget* self, ListListEntry* entry);
static void lists_page_update_list (ListsPage* self, gint64 list_id, JsonObject* obj);
void user_lists_widget_update_member_count (UserListsWidget* self, gint64 list_id, gint increase);
static void _vala_TwitterList_array_free (TwitterList * array, gint array_length);
static void lists_page_get_user_lists_data_free (gpointer _data);
GType twitter_list_get_type (void) G_GNUC_CONST;
TwitterList* twitter_list_dup (const TwitterList* self);
void twitter_list_free (TwitterList* self);
void twitter_list_copy (const TwitterList* self, TwitterList* dest);
void twitter_list_destroy (TwitterList* self);
void lists_page_get_user_lists (ListsPage* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
TwitterList* lists_page_get_user_lists_finish (ListsPage* self, GAsyncResult* _res_, int* result_length1);
static gboolean lists_page_get_user_lists_co (ListsPageGetUserListsData* _data_);
static void lists_page_get_user_lists_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
TwitterList* user_lists_widget_get_user_lists (UserListsWidget* self, int* result_length1);
void user_lists_widget_update_list (UserListsWidget* self, gint64 list_id, const gchar* name, const gchar* description, const gchar* mode);
static void lists_page_real_create_radio_button (IPage* base, GtkRadioButton* group);
BadgeRadioButton* badge_radio_button_new (GtkRadioButton* group, const gchar* icon_name, const gchar* text);
BadgeRadioButton* badge_radio_button_construct (GType object_type, GtkRadioButton* group, const gchar* icon_name, const gchar* text);
static gchar* lists_page_real_get_title (IPage* base);
static GtkRadioButton* lists_page_real_get_radio_button (IPage* base);
gint lists_page_get_unread_count (ListsPage* self);
void lists_page_set_unread_count (ListsPage* self, gint value);
void user_lists_widget_set_main_window (UserListsWidget* self, MainWindow* value);
CbDeltaUpdater* lists_page_get_delta_updater (ListsPage* self);
void lists_page_set_delta_updater (ListsPage* self, CbDeltaUpdater* value);
static void lists_page_finalize (GObject * obj);
gint ipage_get_id (IPage* self);
static void _vala_lists_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void ipage_set_window (IPage* self, MainWindow* value);
static void _vala_lists_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


ListsPage* lists_page_construct (GType object_type, gint id, Account* account) {
	ListsPage * self = NULL;
	gint _tmp0_;
	Account* _tmp1_;
	UserListsWidget* _tmp2_;
	UserListsWidget* _tmp3_;
	Account* _tmp4_;
	UserListsWidget* _tmp5_;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	self = (ListsPage*) scroll_widget_construct (object_type);
	_tmp0_ = id;
	ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), _tmp0_);
	_tmp1_ = account;
	lists_page_set_account (self, _tmp1_);
	gtk_scrolled_window_set_policy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	_tmp2_ = user_lists_widget_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->user_lists_widget);
	self->priv->user_lists_widget = _tmp2_;
	_tmp3_ = self->priv->user_lists_widget;
	_tmp4_ = account;
	user_lists_widget_set_account (_tmp3_, _tmp4_);
	_tmp5_ = self->priv->user_lists_widget;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
	return self;
}


ListsPage* lists_page_new (gint id, Account* account) {
	return lists_page_construct (TYPE_LISTS_PAGE, id, account);
}


static void lists_page_real_on_join (IPage* base, gint page_id, CbBundle* args) {
	ListsPage * self;
	gint mode = 0;
	GNetworkMonitor* _tmp0_;
	gboolean _tmp1_;
	CbBundle* _tmp2_;
	gboolean _tmp5_ = FALSE;
	gint _tmp6_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LISTS_PAGE, ListsPage);
	g_return_if_fail ((args == NULL) || CB_IS_BUNDLE (args));
	mode = 0;
	_tmp0_ = g_network_monitor_get_default ();
	_tmp1_ = g_network_monitor_get_network_available (_tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = args;
	if (_tmp2_ != NULL) {
		CbBundle* _tmp3_;
		gint _tmp4_;
		_tmp3_ = args;
		_tmp4_ = cb_bundle_get_int (_tmp3_, LISTS_PAGE_KEY_MODE);
		mode = _tmp4_;
	}
	_tmp6_ = mode;
	if (_tmp6_ == 0) {
		gboolean _tmp7_;
		_tmp7_ = self->priv->inited;
		_tmp5_ = !_tmp7_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		Account* _tmp8_;
		gint64 _tmp9_;
		self->priv->inited = TRUE;
		_tmp8_ = self->priv->_account;
		_tmp9_ = _tmp8_->id;
		self->priv->user_id = _tmp9_;
		lists_page_load_newest (self, NULL, NULL);
	} else {
		gint _tmp10_;
		_tmp10_ = mode;
		if (_tmp10_ == LISTS_PAGE_MODE_DELETE) {
			gint64 list_id = 0LL;
			CbBundle* _tmp11_;
			gint64 _tmp12_;
			gint64 _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			UserListsWidget* _tmp18_;
			gint64 _tmp19_;
			_tmp11_ = args;
			_tmp12_ = cb_bundle_get_int64 (_tmp11_, LISTS_PAGE_KEY_LIST_ID);
			list_id = _tmp12_;
			_tmp13_ = list_id;
			_tmp14_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strconcat ("Deleting list with id ", _tmp15_, NULL);
			_tmp17_ = _tmp16_;
			g_message ("ListsPage.vala:67: %s", _tmp17_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp15_);
			_tmp18_ = self->priv->user_lists_widget;
			_tmp19_ = list_id;
			user_lists_widget_remove_list (_tmp18_, _tmp19_);
		}
	}
}


static void lists_page_real_on_leave (IPage* base) {
	ListsPage * self;
	UserListsWidget* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LISTS_PAGE, ListsPage);
	_tmp0_ = self->priv->user_lists_widget;
	user_lists_widget_unreveal (_tmp0_);
}


static void lists_page_load_newest_data_free (gpointer _data) {
	ListsPageLoadNewestData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ListsPageLoadNewestData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void lists_page_load_newest (ListsPage* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ListsPageLoadNewestData* _data_;
	ListsPage* _tmp0_;
	_data_ = g_slice_new0 (ListsPageLoadNewestData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, lists_page_load_newest_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	lists_page_load_newest_co (_data_);
}


static void lists_page_load_newest_finish (ListsPage* self, GAsyncResult* _res_) {
	ListsPageLoadNewestData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static void lists_page_load_newest_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ListsPageLoadNewestData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	lists_page_load_newest_co (_data_);
}


static gboolean lists_page_load_newest_co (ListsPageLoadNewestData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->user_lists_widget;
	_data_->_tmp1_ = _data_->self->priv->user_id;
	_data_->_state_ = 1;
	user_lists_widget_load_lists (_data_->_tmp0_, _data_->_tmp1_, lists_page_load_newest_ready, _data_);
	return FALSE;
	_state_1:
	user_lists_widget_load_lists_finish (_data_->_tmp0_, _data_->_res_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static void lists_page_real_stream_message_received (CbMessageReceiver* base, CbStreamMessageType type, JsonNode* root) {
	ListsPage * self;
	gboolean _tmp0_ = FALSE;
	CbStreamMessageType _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LISTS_PAGE, ListsPage);
	g_return_if_fail (root != NULL);
	_tmp1_ = type;
	if (_tmp1_ == CB_STREAM_MESSAGE_EVENT_LIST_CREATED) {
		_tmp0_ = TRUE;
	} else {
		CbStreamMessageType _tmp2_;
		_tmp2_ = type;
		_tmp0_ = _tmp2_ == CB_STREAM_MESSAGE_EVENT_LIST_SUBSCRIBED;
	}
	if (_tmp0_) {
		JsonObject* obj = NULL;
		JsonNode* _tmp3_;
		JsonObject* _tmp4_;
		JsonObject* _tmp5_;
		JsonObject* _tmp6_;
		ListListEntry* entry = NULL;
		JsonObject* _tmp7_;
		Account* _tmp8_;
		ListListEntry* _tmp9_;
		UserListsWidget* _tmp10_;
		ListListEntry* _tmp11_;
		_tmp3_ = root;
		_tmp4_ = json_node_get_object (_tmp3_);
		_tmp5_ = json_object_get_object_member (_tmp4_, "target_object");
		_tmp6_ = _json_object_ref0 (_tmp5_);
		obj = _tmp6_;
		_tmp7_ = obj;
		_tmp8_ = self->priv->_account;
		_tmp9_ = list_list_entry_new_from_json_data (_tmp7_, _tmp8_);
		g_object_ref_sink (_tmp9_);
		entry = _tmp9_;
		_tmp10_ = self->priv->user_lists_widget;
		_tmp11_ = entry;
		user_lists_widget_add_list (_tmp10_, _tmp11_);
		_g_object_unref0 (entry);
		_json_object_unref0 (obj);
	} else {
		gboolean _tmp12_ = FALSE;
		CbStreamMessageType _tmp13_;
		_tmp13_ = type;
		if (_tmp13_ == CB_STREAM_MESSAGE_EVENT_LIST_DESTROYED) {
			_tmp12_ = TRUE;
		} else {
			CbStreamMessageType _tmp14_;
			_tmp14_ = type;
			_tmp12_ = _tmp14_ == CB_STREAM_MESSAGE_EVENT_LIST_UNSUBSCRIBED;
		}
		if (_tmp12_) {
			JsonObject* obj = NULL;
			JsonNode* _tmp15_;
			JsonObject* _tmp16_;
			JsonObject* _tmp17_;
			JsonObject* _tmp18_;
			gint64 list_id = 0LL;
			JsonObject* _tmp19_;
			gint64 _tmp20_;
			UserListsWidget* _tmp21_;
			gint64 _tmp22_;
			_tmp15_ = root;
			_tmp16_ = json_node_get_object (_tmp15_);
			_tmp17_ = json_object_get_object_member (_tmp16_, "target_object");
			_tmp18_ = _json_object_ref0 (_tmp17_);
			obj = _tmp18_;
			_tmp19_ = obj;
			_tmp20_ = json_object_get_int_member (_tmp19_, "id");
			list_id = _tmp20_;
			_tmp21_ = self->priv->user_lists_widget;
			_tmp22_ = list_id;
			user_lists_widget_remove_list (_tmp21_, _tmp22_);
			_json_object_unref0 (obj);
		} else {
			CbStreamMessageType _tmp23_;
			_tmp23_ = type;
			if (_tmp23_ == CB_STREAM_MESSAGE_EVENT_LIST_UPDATED) {
				JsonObject* obj = NULL;
				JsonNode* _tmp24_;
				JsonObject* _tmp25_;
				JsonObject* _tmp26_;
				JsonObject* _tmp27_;
				gint64 list_id = 0LL;
				JsonObject* _tmp28_;
				gint64 _tmp29_;
				gint64 _tmp30_;
				JsonObject* _tmp31_;
				_tmp24_ = root;
				_tmp25_ = json_node_get_object (_tmp24_);
				_tmp26_ = json_object_get_object_member (_tmp25_, "target_object");
				_tmp27_ = _json_object_ref0 (_tmp26_);
				obj = _tmp27_;
				_tmp28_ = obj;
				_tmp29_ = json_object_get_int_member (_tmp28_, "id");
				list_id = _tmp29_;
				_tmp30_ = list_id;
				_tmp31_ = obj;
				lists_page_update_list (self, _tmp30_, _tmp31_);
				_json_object_unref0 (obj);
			} else {
				CbStreamMessageType _tmp32_;
				_tmp32_ = type;
				if (_tmp32_ == CB_STREAM_MESSAGE_EVENT_LIST_MEMBER_ADDED) {
					JsonObject* obj = NULL;
					JsonNode* _tmp33_;
					JsonObject* _tmp34_;
					JsonObject* _tmp35_;
					JsonObject* _tmp36_;
					gint64 list_id = 0LL;
					JsonObject* _tmp37_;
					gint64 _tmp38_;
					UserListsWidget* _tmp39_;
					gint64 _tmp40_;
					_tmp33_ = root;
					_tmp34_ = json_node_get_object (_tmp33_);
					_tmp35_ = json_object_get_object_member (_tmp34_, "target_object");
					_tmp36_ = _json_object_ref0 (_tmp35_);
					obj = _tmp36_;
					_tmp37_ = obj;
					_tmp38_ = json_object_get_int_member (_tmp37_, "id");
					list_id = _tmp38_;
					_tmp39_ = self->priv->user_lists_widget;
					_tmp40_ = list_id;
					user_lists_widget_update_member_count (_tmp39_, _tmp40_, 1);
					_json_object_unref0 (obj);
				} else {
					CbStreamMessageType _tmp41_;
					_tmp41_ = type;
					if (_tmp41_ == CB_STREAM_MESSAGE_EVENT_LIST_MEMBER_REMOVED) {
						JsonObject* obj = NULL;
						JsonNode* _tmp42_;
						JsonObject* _tmp43_;
						JsonObject* _tmp44_;
						JsonObject* _tmp45_;
						gint64 list_id = 0LL;
						JsonObject* _tmp46_;
						gint64 _tmp47_;
						UserListsWidget* _tmp48_;
						gint64 _tmp49_;
						_tmp42_ = root;
						_tmp43_ = json_node_get_object (_tmp42_);
						_tmp44_ = json_object_get_object_member (_tmp43_, "target_object");
						_tmp45_ = _json_object_ref0 (_tmp44_);
						obj = _tmp45_;
						_tmp46_ = obj;
						_tmp47_ = json_object_get_int_member (_tmp46_, "id");
						list_id = _tmp47_;
						_tmp48_ = self->priv->user_lists_widget;
						_tmp49_ = list_id;
						user_lists_widget_update_member_count (_tmp48_, _tmp49_, -1);
						_json_object_unref0 (obj);
					}
				}
			}
		}
	}
}


static void _vala_TwitterList_array_free (TwitterList * array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			twitter_list_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void lists_page_get_user_lists_data_free (gpointer _data) {
	ListsPageGetUserListsData* _data_;
	_data_ = _data;
	_data_->result = (_vala_TwitterList_array_free (_data_->result, _data_->result_length1), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (ListsPageGetUserListsData, _data_);
}


void lists_page_get_user_lists (ListsPage* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ListsPageGetUserListsData* _data_;
	ListsPage* _tmp0_;
	_data_ = g_slice_new0 (ListsPageGetUserListsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, lists_page_get_user_lists_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	lists_page_get_user_lists_co (_data_);
}


TwitterList* lists_page_get_user_lists_finish (ListsPage* self, GAsyncResult* _res_, int* result_length1) {
	TwitterList* result;
	ListsPageGetUserListsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}


static void lists_page_get_user_lists_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ListsPageGetUserListsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	lists_page_get_user_lists_co (_data_);
}


static gboolean lists_page_get_user_lists_co (ListsPageGetUserListsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->inited;
	if (!_data_->_tmp0_) {
		_data_->self->priv->inited = TRUE;
		_data_->_tmp1_ = _data_->self->priv->user_lists_widget;
		_data_->_tmp2_ = _data_->self->priv->user_id;
		_data_->_state_ = 1;
		user_lists_widget_load_lists (_data_->_tmp1_, _data_->_tmp2_, lists_page_get_user_lists_ready, _data_);
		return FALSE;
		_state_1:
		user_lists_widget_load_lists_finish (_data_->_tmp1_, _data_->_res_);
	}
	_data_->_tmp3_ = _data_->self->priv->user_lists_widget;
	_data_->_tmp5_ = user_lists_widget_get_user_lists (_data_->_tmp3_, &_data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp6__length1 = _data_->_tmp4_;
	_data_->result_length1 = _data_->_tmp6__length1;
	_data_->result = _data_->_tmp6_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void lists_page_update_list (ListsPage* self, gint64 list_id, JsonObject* obj) {
	gchar* name = NULL;
	JsonObject* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* description = NULL;
	JsonObject* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* mode = NULL;
	JsonObject* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	UserListsWidget* _tmp9_;
	gint64 _tmp10_;
	g_return_if_fail (IS_LISTS_PAGE (self));
	g_return_if_fail (obj != NULL);
	_tmp0_ = obj;
	_tmp1_ = json_object_get_string_member (_tmp0_, "full_name");
	_tmp2_ = g_strdup (_tmp1_);
	name = _tmp2_;
	_tmp3_ = obj;
	_tmp4_ = json_object_get_string_member (_tmp3_, "description");
	_tmp5_ = g_strdup (_tmp4_);
	description = _tmp5_;
	_tmp6_ = obj;
	_tmp7_ = json_object_get_string_member (_tmp6_, "mode");
	_tmp8_ = g_strdup (_tmp7_);
	mode = _tmp8_;
	_tmp9_ = self->priv->user_lists_widget;
	_tmp10_ = list_id;
	user_lists_widget_update_list (_tmp9_, _tmp10_, name, description, mode);
	_g_free0 (mode);
	_g_free0 (description);
	_g_free0 (name);
}


static void lists_page_real_create_radio_button (IPage* base, GtkRadioButton* group) {
	ListsPage * self;
	GtkRadioButton* _tmp0_;
	BadgeRadioButton* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LISTS_PAGE, ListsPage);
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
	_tmp0_ = group;
	_tmp1_ = badge_radio_button_new (_tmp0_, "view-list-symbolic", _ ("Lists"));
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->radio_button);
	self->priv->radio_button = _tmp1_;
}


static gchar* lists_page_real_get_title (IPage* base) {
	ListsPage * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LISTS_PAGE, ListsPage);
	_tmp0_ = g_strdup (_ ("Lists"));
	result = _tmp0_;
	return result;
}


static GtkRadioButton* lists_page_real_get_radio_button (IPage* base) {
	ListsPage * self;
	GtkRadioButton* result = NULL;
	BadgeRadioButton* _tmp0_;
	GtkRadioButton* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LISTS_PAGE, ListsPage);
	_tmp0_ = self->priv->radio_button;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_radio_button_get_type (), GtkRadioButton));
	result = _tmp1_;
	return result;
}


gint lists_page_get_unread_count (ListsPage* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (IS_LISTS_PAGE (self), 0);
	_tmp0_ = self->priv->_unread_count;
	result = _tmp0_;
	return result;
}


void lists_page_set_unread_count (ListsPage* self, gint value) {
	g_return_if_fail (IS_LISTS_PAGE (self));
	if (lists_page_get_unread_count (self) != value) {
		gint _tmp0_;
		_tmp0_ = value;
		self->priv->_unread_count = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, lists_page_properties[LISTS_PAGE_UNREAD_COUNT_PROPERTY]);
	}
}


static void lists_page_real_set_window (IPage* base, MainWindow* value) {
	ListsPage* self;
	MainWindow* _tmp0_;
	UserListsWidget* _tmp1_;
	MainWindow* _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LISTS_PAGE, ListsPage);
	_tmp0_ = value;
	self->priv->main_window = _tmp0_;
	_tmp1_ = self->priv->user_lists_widget;
	_tmp2_ = value;
	user_lists_widget_set_main_window (_tmp1_, _tmp2_);
	g_object_notify_by_pspec ((GObject *) self, lists_page_properties[LISTS_PAGE_WINDOW_PROPERTY]);
}


Account* lists_page_get_account (ListsPage* self) {
	Account* result;
	Account* _tmp0_;
	g_return_val_if_fail (IS_LISTS_PAGE (self), NULL);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}


void lists_page_set_account (ListsPage* self, Account* value) {
	g_return_if_fail (IS_LISTS_PAGE (self));
	if (lists_page_get_account (self) != value) {
		Account* _tmp0_;
		_tmp0_ = value;
		self->priv->_account = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, lists_page_properties[LISTS_PAGE_ACCOUNT_PROPERTY]);
	}
}


CbDeltaUpdater* lists_page_get_delta_updater (ListsPage* self) {
	CbDeltaUpdater* result;
	CbDeltaUpdater* _tmp0_;
	g_return_val_if_fail (IS_LISTS_PAGE (self), NULL);
	_tmp0_ = self->priv->_delta_updater;
	result = _tmp0_;
	return result;
}


void lists_page_set_delta_updater (ListsPage* self, CbDeltaUpdater* value) {
	g_return_if_fail (IS_LISTS_PAGE (self));
	if (lists_page_get_delta_updater (self) != value) {
		CbDeltaUpdater* _tmp0_;
		_tmp0_ = value;
		self->priv->_delta_updater = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, lists_page_properties[LISTS_PAGE_DELTA_UPDATER_PROPERTY]);
	}
}


static gint lists_page_real_get_id (IPage* base) {
	gint result;
	ListsPage* self;
	gint _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LISTS_PAGE, ListsPage);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void lists_page_real_set_id (IPage* base, gint value) {
	ListsPage* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LISTS_PAGE, ListsPage);
	if (lists_page_real_get_id (base) != value) {
		gint _tmp0_;
		_tmp0_ = value;
		self->priv->_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, lists_page_properties[LISTS_PAGE_ID_PROPERTY]);
	}
}


static void lists_page_class_init (ListsPageClass * klass) {
	lists_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ListsPagePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_lists_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_lists_page_set_property;
	G_OBJECT_CLASS (klass)->finalize = lists_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), LISTS_PAGE_UNREAD_COUNT_PROPERTY, lists_page_properties[LISTS_PAGE_UNREAD_COUNT_PROPERTY] = g_param_spec_int ("unread-count", "unread-count", "unread-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), LISTS_PAGE_WINDOW_PROPERTY, lists_page_properties[LISTS_PAGE_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", TYPE_MAIN_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), LISTS_PAGE_ACCOUNT_PROPERTY, lists_page_properties[LISTS_PAGE_ACCOUNT_PROPERTY] = g_param_spec_object ("account", "account", "account", TYPE_ACCOUNT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), LISTS_PAGE_DELTA_UPDATER_PROPERTY, lists_page_properties[LISTS_PAGE_DELTA_UPDATER_PROPERTY] = g_param_spec_object ("delta-updater", "delta-updater", "delta-updater", CB_TYPE_DELTA_UPDATER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), LISTS_PAGE_ID_PROPERTY, lists_page_properties[LISTS_PAGE_ID_PROPERTY] = g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void lists_page_ipage_interface_init (IPageIface * iface) {
	lists_page_ipage_parent_iface = g_type_interface_peek_parent (iface);
	iface->on_join = (void (*) (IPage *, gint, CbBundle*)) lists_page_real_on_join;
	iface->on_leave = (void (*) (IPage *)) lists_page_real_on_leave;
	iface->create_radio_button = (void (*) (IPage *, GtkRadioButton*)) lists_page_real_create_radio_button;
	iface->get_title = (gchar* (*) (IPage *)) lists_page_real_get_title;
	iface->get_radio_button = (GtkRadioButton* (*) (IPage *)) lists_page_real_get_radio_button;
	iface->set_window = lists_page_real_set_window;
	iface->get_id = lists_page_real_get_id;
	iface->set_id = lists_page_real_set_id;
}


static void lists_page_cb_message_receiver_interface_init (CbMessageReceiverInterface * iface) {
	lists_page_cb_message_receiver_parent_iface = g_type_interface_peek_parent (iface);
	iface->stream_message_received = (void (*) (CbMessageReceiver *, CbStreamMessageType, JsonNode*)) lists_page_real_stream_message_received;
}


static void lists_page_instance_init (ListsPage * self) {
	self->priv = LISTS_PAGE_GET_PRIVATE (self);
	self->priv->inited = FALSE;
}


static void lists_page_finalize (GObject * obj) {
	ListsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LISTS_PAGE, ListsPage);
	_g_object_unref0 (self->priv->radio_button);
	_g_object_unref0 (self->priv->user_lists_widget);
	G_OBJECT_CLASS (lists_page_parent_class)->finalize (obj);
}


GType lists_page_get_type (void) {
	static volatile gsize lists_page_type_id__volatile = 0;
	if (g_once_init_enter (&lists_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ListsPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lists_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ListsPage), 0, (GInstanceInitFunc) lists_page_instance_init, NULL };
		static const GInterfaceInfo ipage_info = { (GInterfaceInitFunc) lists_page_ipage_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo cb_message_receiver_info = { (GInterfaceInitFunc) lists_page_cb_message_receiver_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType lists_page_type_id;
		lists_page_type_id = g_type_register_static (TYPE_SCROLL_WIDGET, "ListsPage", &g_define_type_info, 0);
		g_type_add_interface_static (lists_page_type_id, TYPE_IPAGE, &ipage_info);
		g_type_add_interface_static (lists_page_type_id, CB_TYPE_MESSAGE_RECEIVER, &cb_message_receiver_info);
		g_once_init_leave (&lists_page_type_id__volatile, lists_page_type_id);
	}
	return lists_page_type_id__volatile;
}


static void _vala_lists_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ListsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LISTS_PAGE, ListsPage);
	switch (property_id) {
		case LISTS_PAGE_UNREAD_COUNT_PROPERTY:
		g_value_set_int (value, lists_page_get_unread_count (self));
		break;
		case LISTS_PAGE_ACCOUNT_PROPERTY:
		g_value_set_object (value, lists_page_get_account (self));
		break;
		case LISTS_PAGE_DELTA_UPDATER_PROPERTY:
		g_value_set_object (value, lists_page_get_delta_updater (self));
		break;
		case LISTS_PAGE_ID_PROPERTY:
		g_value_set_int (value, ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_lists_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ListsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LISTS_PAGE, ListsPage);
	switch (property_id) {
		case LISTS_PAGE_UNREAD_COUNT_PROPERTY:
		lists_page_set_unread_count (self, g_value_get_int (value));
		break;
		case LISTS_PAGE_WINDOW_PROPERTY:
		ipage_set_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		case LISTS_PAGE_ACCOUNT_PROPERTY:
		lists_page_set_account (self, g_value_get_object (value));
		break;
		case LISTS_PAGE_DELTA_UPDATER_PROPERTY:
		lists_page_set_delta_updater (self, g_value_get_object (value));
		break;
		case LISTS_PAGE_ID_PROPERTY:
		ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



