; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+ndd -verify-machineinstrs --show-mc-encoding | FileCheck %s
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+ndd,nf -verify-machineinstrs --show-mc-encoding | FileCheck --check-prefix=NF %s
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+ndd,nf -x86-enable-apx-for-relocation=true -verify-machineinstrs --show-mc-encoding | FileCheck --check-prefix=NF %s

define i8 @and8rr(i8 noundef %a, i8 noundef %b) {
; CHECK-LABEL: and8rr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andl %esi, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x21,0xf7]
; CHECK-NEXT:    # kill: def $al killed $al killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and8rr:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} andl %esi, %edi, %eax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0x21,0xf7]
; NF-NEXT:    # kill: def $al killed $al killed $eax
; NF-NEXT:    retq # encoding: [0xc3]
entry:
    %and = and i8 %a, %b
    ret i8 %and
}

define i16 @and16rr(i16 noundef %a, i16 noundef %b) {
; CHECK-LABEL: and16rr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andl %esi, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x21,0xf7]
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and16rr:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} andl %esi, %edi, %eax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0x21,0xf7]
; NF-NEXT:    # kill: def $ax killed $ax killed $eax
; NF-NEXT:    retq # encoding: [0xc3]
entry:
    %and = and i16 %a, %b
    ret i16 %and
}

define i32 @and32rr(i32 noundef %a, i32 noundef %b) {
; CHECK-LABEL: and32rr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andl %esi, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x21,0xf7]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and32rr:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} andl %esi, %edi, %eax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0x21,0xf7]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
    %and = and i32 %a, %b
    ret i32 %and
}

define i64 @and64rr(i64 noundef %a, i64 noundef %b) {
; CHECK-LABEL: and64rr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andq %rsi, %rdi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0x21,0xf7]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and64rr:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} andq %rsi, %rdi, %rax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0xfc,0x1c,0x21,0xf7]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
    %and = and i64 %a, %b
    ret i64 %and
}

define i8 @and8rm(i8 noundef %a, ptr %b) {
; CHECK-LABEL: and8rm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andb (%rsi), %dil, %al # encoding: [0x62,0xf4,0x7c,0x18,0x22,0x3e]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and8rm:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} andb (%rsi), %dil, %al # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0x22,0x3e]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
    %t = load i8, ptr %b
    %and = and i8 %a, %t
    ret i8 %and
}

define i16 @and16rm(i16 noundef %a, ptr %b) {
; CHECK-LABEL: and16rm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andw (%rsi), %di, %ax # encoding: [0x62,0xf4,0x7d,0x18,0x23,0x3e]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and16rm:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} andw (%rsi), %di, %ax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7d,0x1c,0x23,0x3e]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
    %t = load i16, ptr %b
    %and = and i16 %a, %t
    ret i16 %and
}

define i32 @and32rm(i32 noundef %a, ptr %b) {
; CHECK-LABEL: and32rm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andl (%rsi), %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x23,0x3e]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and32rm:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} andl (%rsi), %edi, %eax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0x23,0x3e]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
    %t = load i32, ptr %b
    %and = and i32 %a, %t
    ret i32 %and
}

define i64 @and64rm(i64 noundef %a, ptr %b) {
; CHECK-LABEL: and64rm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andq (%rsi), %rdi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0x23,0x3e]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and64rm:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} andq (%rsi), %rdi, %rax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0xfc,0x1c,0x23,0x3e]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
    %t = load i64, ptr %b
    %and = and i64 %a, %t
    ret i64 %and
}

define i16 @and16ri8(i16 noundef %a) {
; CHECK-LABEL: and16ri8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andw $123, %di, %ax # encoding: [0x62,0xf4,0x7d,0x18,0x83,0xe7,0x7b]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and16ri8:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} andw $123, %di, %ax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7d,0x1c,0x83,0xe7,0x7b]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
    %and = and i16 %a, 123
    ret i16 %and
}

define i32 @and32ri8(i32 noundef %a) {
; CHECK-LABEL: and32ri8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andl $123, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x83,0xe7,0x7b]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and32ri8:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} andl $123, %edi, %eax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0x83,0xe7,0x7b]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
    %and = and i32 %a, 123
    ret i32 %and
}

define i64 @and64ri8(i64 noundef %a) {
; CHECK-LABEL: and64ri8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andl $123, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x83,0xe7,0x7b]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and64ri8:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} andl $123, %edi, %eax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0x83,0xe7,0x7b]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
    %and = and i64 %a, 123
    ret i64 %and
}

define i8 @and8ri(i8 noundef %a) {
; CHECK-LABEL: and8ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andb $123, %dil, %al # encoding: [0x62,0xf4,0x7c,0x18,0x80,0xe7,0x7b]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and8ri:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} andb $123, %dil, %al # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0x80,0xe7,0x7b]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
    %and = and i8 %a, 123
    ret i8 %and
}

define i16 @and16ri(i16 noundef %a) {
; CHECK-LABEL: and16ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andw $1234, %di, %ax # encoding: [0x62,0xf4,0x7d,0x18,0x81,0xe7,0xd2,0x04]
; CHECK-NEXT:    # imm = 0x4D2
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and16ri:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} andw $1234, %di, %ax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7d,0x1c,0x81,0xe7,0xd2,0x04]
; NF-NEXT:    # imm = 0x4D2
; NF-NEXT:    retq # encoding: [0xc3]
entry:
    %and = and i16 %a, 1234
    ret i16 %and
}

define i32 @and32ri(i32 noundef %a) {
; CHECK-LABEL: and32ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andl $123456, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x81,0xe7,0x40,0xe2,0x01,0x00]
; CHECK-NEXT:    # imm = 0x1E240
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and32ri:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} andl $123456, %edi, %eax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0x81,0xe7,0x40,0xe2,0x01,0x00]
; NF-NEXT:    # imm = 0x1E240
; NF-NEXT:    retq # encoding: [0xc3]
entry:
    %and = and i32 %a, 123456
    ret i32 %and
}

define i64 @and64ri(i64 noundef %a) {
; CHECK-LABEL: and64ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andl $123456, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x81,0xe7,0x40,0xe2,0x01,0x00]
; CHECK-NEXT:    # imm = 0x1E240
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and64ri:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} andl $123456, %edi, %eax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0x81,0xe7,0x40,0xe2,0x01,0x00]
; NF-NEXT:    # imm = 0x1E240
; NF-NEXT:    retq # encoding: [0xc3]
entry:
    %and = and i64 %a, 123456
    ret i64 %and
}

define i8 @and8mr(ptr %a, i8 noundef %b) {
; CHECK-LABEL: and8mr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andb (%rdi), %sil, %al # encoding: [0x62,0xf4,0x7c,0x18,0x22,0x37]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and8mr:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} andb (%rdi), %sil, %al # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0x22,0x37]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i8, ptr %a
  %and = and i8 %t, %b
  ret i8 %and
}

define i16 @and16mr(ptr %a, i16 noundef %b) {
; CHECK-LABEL: and16mr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andw (%rdi), %si, %ax # encoding: [0x62,0xf4,0x7d,0x18,0x23,0x37]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and16mr:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} andw (%rdi), %si, %ax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7d,0x1c,0x23,0x37]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i16, ptr %a
  %and = and i16 %t, %b
  ret i16 %and
}

define i32 @and32mr(ptr %a, i32 noundef %b) {
; CHECK-LABEL: and32mr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andl (%rdi), %esi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x23,0x37]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and32mr:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} andl (%rdi), %esi, %eax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0x23,0x37]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i32, ptr %a
  %and = and i32 %t, %b
  ret i32 %and
}

define i64 @and64mr(ptr %a, i64 noundef %b) {
; CHECK-LABEL: and64mr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andq (%rdi), %rsi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0x23,0x37]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and64mr:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} andq (%rdi), %rsi, %rax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0xfc,0x1c,0x23,0x37]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i64, ptr %a
  %and = and i64 %t, %b
  ret i64 %and
}

define i16 @and16mi8(ptr %a) {
; CHECK-LABEL: and16mi8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andw $123, (%rdi), %ax # encoding: [0x62,0xf4,0x7d,0x18,0x83,0x27,0x7b]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and16mi8:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} andw $123, (%rdi), %ax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7d,0x1c,0x83,0x27,0x7b]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i16, ptr %a
  %and = and i16 %t, 123
  ret i16 %and
}

define i32 @and32mi8(ptr %a) {
; CHECK-LABEL: and32mi8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andl $123, (%rdi), %eax # encoding: [0x62,0xf4,0x7c,0x18,0x83,0x27,0x7b]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and32mi8:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} andl $123, (%rdi), %eax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0x83,0x27,0x7b]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i32, ptr %a
  %and = and i32 %t, 123
  ret i32 %and
}

define i64 @and64mi8(ptr %a) {
; CHECK-LABEL: and64mi8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq (%rdi), %rax # encoding: [0x48,0x8b,0x07]
; CHECK-NEXT:    andl $123, %eax # EVEX TO LEGACY Compression encoding: [0x83,0xe0,0x7b]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and64mi8:
; NF:       # %bb.0: # %entry
; NF-NEXT:    movq (%rdi), %rax # encoding: [0x48,0x8b,0x07]
; NF-NEXT:    andl $123, %eax # EVEX TO LEGACY Compression encoding: [0x83,0xe0,0x7b]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i64, ptr %a
  %and = and i64 %t, 123
  ret i64 %and
}

define i8 @and8mi(ptr %a) {
; CHECK-LABEL: and8mi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andb $123, (%rdi), %al # encoding: [0x62,0xf4,0x7c,0x18,0x80,0x27,0x7b]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and8mi:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} andb $123, (%rdi), %al # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0x80,0x27,0x7b]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i8, ptr %a
  %and = and i8 %t, 123
  ret i8 %and
}

define i16 @and16mi(ptr %a) {
; CHECK-LABEL: and16mi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andw $1234, (%rdi), %ax # encoding: [0x62,0xf4,0x7d,0x18,0x81,0x27,0xd2,0x04]
; CHECK-NEXT:    # imm = 0x4D2
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and16mi:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} andw $1234, (%rdi), %ax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7d,0x1c,0x81,0x27,0xd2,0x04]
; NF-NEXT:    # imm = 0x4D2
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i16, ptr %a
  %and = and i16 %t, 1234
  ret i16 %and
}

define i32 @and32mi(ptr %a) {
; CHECK-LABEL: and32mi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andl $123456, (%rdi), %eax # encoding: [0x62,0xf4,0x7c,0x18,0x81,0x27,0x40,0xe2,0x01,0x00]
; CHECK-NEXT:    # imm = 0x1E240
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and32mi:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} andl $123456, (%rdi), %eax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0x81,0x27,0x40,0xe2,0x01,0x00]
; NF-NEXT:    # imm = 0x1E240
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i32, ptr %a
  %and = and i32 %t, 123456
  ret i32 %and
}

define i64 @and64mi(ptr %a) {
; CHECK-LABEL: and64mi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movq (%rdi), %rax # encoding: [0x48,0x8b,0x07]
; CHECK-NEXT:    andl $123456, %eax # EVEX TO LEGACY Compression encoding: [0x25,0x40,0xe2,0x01,0x00]
; CHECK-NEXT:    # imm = 0x1E240
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and64mi:
; NF:       # %bb.0: # %entry
; NF-NEXT:    movq (%rdi), %rax # encoding: [0x48,0x8b,0x07]
; NF-NEXT:    andl $123456, %eax # EVEX TO LEGACY Compression encoding: [0x25,0x40,0xe2,0x01,0x00]
; NF-NEXT:    # imm = 0x1E240
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i64, ptr %a
  %and = and i64 %t, 123456
  ret i64 %and
}

@d64 = dso_local global i64 0

define i1 @andflag8rr(i8 %a, i8 %b) {
; CHECK-LABEL: andflag8rr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    notb %sil, %al # encoding: [0x62,0xf4,0x7c,0x18,0xf6,0xd6]
; CHECK-NEXT:    andb %al, %dil, %cl # encoding: [0x62,0xf4,0x74,0x18,0x20,0xc7]
; CHECK-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; CHECK-NEXT:    movb %cl, d64(%rip) # encoding: [0x88,0x0d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 2, value: d64, kind: reloc_riprel_4byte
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: andflag8rr:
; NF:       # %bb.0:
; NF-NEXT:    notb %sil, %al # encoding: [0x62,0xf4,0x7c,0x18,0xf6,0xd6]
; NF-NEXT:    andb %al, %dil, %cl # encoding: [0x62,0xf4,0x74,0x18,0x20,0xc7]
; NF-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; NF-NEXT:    movb %cl, d64(%rip) # encoding: [0x88,0x0d,A,A,A,A]
; NF-NEXT:    # fixup A - offset: 2, value: d64, kind: reloc_riprel_4byte
; NF-NEXT:    retq # encoding: [0xc3]
  %xor = xor i8 %b, -1
  %v0 = and i8 %a, %xor  ; 0xff << 50
  %v1 = icmp eq i8 %v0, 0
  store i8 %v0, ptr @d64
  ret i1 %v1
}

define i1 @andflag16rr(i16 %a, i16 %b) {
; CHECK-LABEL: andflag16rr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    notw %si, %ax # encoding: [0x62,0xf4,0x7d,0x18,0xf7,0xd6]
; CHECK-NEXT:    andw %ax, %di, %cx # encoding: [0x62,0xf4,0x75,0x18,0x21,0xc7]
; CHECK-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; CHECK-NEXT:    movw %cx, d64(%rip) # encoding: [0x66,0x89,0x0d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: d64, kind: reloc_riprel_4byte
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: andflag16rr:
; NF:       # %bb.0:
; NF-NEXT:    notw %si, %ax # encoding: [0x62,0xf4,0x7d,0x18,0xf7,0xd6]
; NF-NEXT:    andw %ax, %di, %cx # encoding: [0x62,0xf4,0x75,0x18,0x21,0xc7]
; NF-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; NF-NEXT:    movw %cx, d64(%rip) # encoding: [0x66,0x89,0x0d,A,A,A,A]
; NF-NEXT:    # fixup A - offset: 3, value: d64, kind: reloc_riprel_4byte
; NF-NEXT:    retq # encoding: [0xc3]
  %xor = xor i16 %b, -1
  %v0 = and i16 %a, %xor  ; 0xff << 50
  %v1 = icmp eq i16 %v0, 0
  store i16 %v0, ptr @d64
  ret i1 %v1
}

define i1 @andflag32rr(i32 %a, i32 %b) {
; CHECK-LABEL: andflag32rr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andl %edi, %esi # EVEX TO LEGACY Compression encoding: [0x21,0xfe]
; CHECK-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; CHECK-NEXT:    movl %esi, d64(%rip) # encoding: [0x89,0x35,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 2, value: d64, kind: reloc_riprel_4byte
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: andflag32rr:
; NF:       # %bb.0:
; NF-NEXT:    andl %edi, %esi # EVEX TO LEGACY Compression encoding: [0x21,0xfe]
; NF-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; NF-NEXT:    movl %esi, d64(%rip) # encoding: [0x89,0x35,A,A,A,A]
; NF-NEXT:    # fixup A - offset: 2, value: d64, kind: reloc_riprel_4byte
; NF-NEXT:    retq # encoding: [0xc3]
  %v0 = and i32 %a, %b  ; 0xff << 50
  %v1 = icmp eq i32 %v0, 0
  store i32 %v0, ptr @d64
  ret i1 %v1
}

define i1 @andflag64rr(i64 %a, i64 %b) {
; CHECK-LABEL: andflag64rr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andq %rdi, %rsi # EVEX TO LEGACY Compression encoding: [0x48,0x21,0xfe]
; CHECK-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; CHECK-NEXT:    movq %rsi, d64(%rip) # encoding: [0x48,0x89,0x35,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: d64, kind: reloc_riprel_4byte
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: andflag64rr:
; NF:       # %bb.0:
; NF-NEXT:    andq %rdi, %rsi # EVEX TO LEGACY Compression encoding: [0x48,0x21,0xfe]
; NF-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; NF-NEXT:    movq %rsi, d64(%rip) # encoding: [0x48,0x89,0x35,A,A,A,A]
; NF-NEXT:    # fixup A - offset: 3, value: d64, kind: reloc_riprel_4byte
; NF-NEXT:    retq # encoding: [0xc3]
  %v0 = and i64 %a, %b  ; 0xff << 50
  %v1 = icmp eq i64 %v0, 0
  store i64 %v0, ptr @d64
  ret i1 %v1
}

define i1 @andflag8rm(ptr %ptr, i8 %b) {
; CHECK-LABEL: andflag8rm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    notb %sil, %al # encoding: [0x62,0xf4,0x7c,0x18,0xf6,0xd6]
; CHECK-NEXT:    andb (%rdi), %al, %cl # encoding: [0x62,0xf4,0x74,0x18,0x22,0x07]
; CHECK-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; CHECK-NEXT:    movb %cl, d64(%rip) # encoding: [0x88,0x0d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 2, value: d64, kind: reloc_riprel_4byte
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: andflag8rm:
; NF:       # %bb.0:
; NF-NEXT:    notb %sil, %al # encoding: [0x62,0xf4,0x7c,0x18,0xf6,0xd6]
; NF-NEXT:    andb (%rdi), %al, %cl # encoding: [0x62,0xf4,0x74,0x18,0x22,0x07]
; NF-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; NF-NEXT:    movb %cl, d64(%rip) # encoding: [0x88,0x0d,A,A,A,A]
; NF-NEXT:    # fixup A - offset: 2, value: d64, kind: reloc_riprel_4byte
; NF-NEXT:    retq # encoding: [0xc3]
  %a = load i8, ptr %ptr
  %xor = xor i8 %b, -1
  %v0 = and i8 %a, %xor  ; 0xff << 50
  %v1 = icmp eq i8 %v0, 0
  store i8 %v0, ptr @d64
  ret i1 %v1
}

define i1 @andflag16rm(ptr %ptr, i16 %b) {
; CHECK-LABEL: andflag16rm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    notw %si, %ax # encoding: [0x62,0xf4,0x7d,0x18,0xf7,0xd6]
; CHECK-NEXT:    andw (%rdi), %ax, %cx # encoding: [0x62,0xf4,0x75,0x18,0x23,0x07]
; CHECK-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; CHECK-NEXT:    movw %cx, d64(%rip) # encoding: [0x66,0x89,0x0d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: d64, kind: reloc_riprel_4byte
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: andflag16rm:
; NF:       # %bb.0:
; NF-NEXT:    notw %si, %ax # encoding: [0x62,0xf4,0x7d,0x18,0xf7,0xd6]
; NF-NEXT:    andw (%rdi), %ax, %cx # encoding: [0x62,0xf4,0x75,0x18,0x23,0x07]
; NF-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; NF-NEXT:    movw %cx, d64(%rip) # encoding: [0x66,0x89,0x0d,A,A,A,A]
; NF-NEXT:    # fixup A - offset: 3, value: d64, kind: reloc_riprel_4byte
; NF-NEXT:    retq # encoding: [0xc3]
  %a = load i16, ptr %ptr
  %xor = xor i16 %b, -1
  %v0 = and i16 %a, %xor  ; 0xff << 50
  %v1 = icmp eq i16 %v0, 0
  store i16 %v0, ptr @d64
  ret i1 %v1
}

define i1 @andflag32rm(ptr %ptr, i32 %b) {
; CHECK-LABEL: andflag32rm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andl (%rdi), %esi # EVEX TO LEGACY Compression encoding: [0x23,0x37]
; CHECK-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; CHECK-NEXT:    movl %esi, d64(%rip) # encoding: [0x89,0x35,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 2, value: d64, kind: reloc_riprel_4byte
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: andflag32rm:
; NF:       # %bb.0:
; NF-NEXT:    andl (%rdi), %esi # EVEX TO LEGACY Compression encoding: [0x23,0x37]
; NF-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; NF-NEXT:    movl %esi, d64(%rip) # encoding: [0x89,0x35,A,A,A,A]
; NF-NEXT:    # fixup A - offset: 2, value: d64, kind: reloc_riprel_4byte
; NF-NEXT:    retq # encoding: [0xc3]
  %a = load i32, ptr %ptr
  %v0 = and i32 %a, %b  ; 0xff << 50
  %v1 = icmp eq i32 %v0, 0
  store i32 %v0, ptr @d64
  ret i1 %v1
}

define i1 @andflag64rm(ptr %ptr, i64 %b) {
; CHECK-LABEL: andflag64rm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andq (%rdi), %rsi # EVEX TO LEGACY Compression encoding: [0x48,0x23,0x37]
; CHECK-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; CHECK-NEXT:    movq %rsi, d64(%rip) # encoding: [0x48,0x89,0x35,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: d64, kind: reloc_riprel_4byte
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: andflag64rm:
; NF:       # %bb.0:
; NF-NEXT:    andq (%rdi), %rsi # EVEX TO LEGACY Compression encoding: [0x48,0x23,0x37]
; NF-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; NF-NEXT:    movq %rsi, d64(%rip) # encoding: [0x48,0x89,0x35,A,A,A,A]
; NF-NEXT:    # fixup A - offset: 3, value: d64, kind: reloc_riprel_4byte
; NF-NEXT:    retq # encoding: [0xc3]
  %a = load i64, ptr %ptr
  %v0 = and i64 %a, %b  ; 0xff << 50
  %v1 = icmp eq i64 %v0, 0
  store i64 %v0, ptr @d64
  ret i1 %v1
}

define i1 @andflag8ri(i8 %a) {
; CHECK-LABEL: andflag8ri:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andb $-124, %dil, %cl # encoding: [0x62,0xf4,0x74,0x18,0x80,0xe7,0x84]
; CHECK-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; CHECK-NEXT:    movb %cl, d64(%rip) # encoding: [0x88,0x0d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 2, value: d64, kind: reloc_riprel_4byte
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: andflag8ri:
; NF:       # %bb.0:
; NF-NEXT:    andb $-124, %dil, %cl # encoding: [0x62,0xf4,0x74,0x18,0x80,0xe7,0x84]
; NF-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; NF-NEXT:    movb %cl, d64(%rip) # encoding: [0x88,0x0d,A,A,A,A]
; NF-NEXT:    # fixup A - offset: 2, value: d64, kind: reloc_riprel_4byte
; NF-NEXT:    retq # encoding: [0xc3]
  %xor = xor i8 123, -1
  %v0 = and i8 %a, %xor  ; 0xff << 50
  %v1 = icmp eq i8 %v0, 0
  store i8 %v0, ptr @d64
  ret i1 %v1
}

define i1 @andflag16ri(i16 %a) {
; CHECK-LABEL: andflag16ri:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andw $-1235, %di, %cx # encoding: [0x62,0xf4,0x75,0x18,0x81,0xe7,0x2d,0xfb]
; CHECK-NEXT:    # imm = 0xFB2D
; CHECK-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; CHECK-NEXT:    movw %cx, d64(%rip) # encoding: [0x66,0x89,0x0d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: d64, kind: reloc_riprel_4byte
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: andflag16ri:
; NF:       # %bb.0:
; NF-NEXT:    andw $-1235, %di, %cx # encoding: [0x62,0xf4,0x75,0x18,0x81,0xe7,0x2d,0xfb]
; NF-NEXT:    # imm = 0xFB2D
; NF-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; NF-NEXT:    movw %cx, d64(%rip) # encoding: [0x66,0x89,0x0d,A,A,A,A]
; NF-NEXT:    # fixup A - offset: 3, value: d64, kind: reloc_riprel_4byte
; NF-NEXT:    retq # encoding: [0xc3]
  %xor = xor i16 1234, -1
  %v0 = and i16 %a, %xor  ; 0xff << 50
  %v1 = icmp eq i16 %v0, 0
  store i16 %v0, ptr @d64
  ret i1 %v1
}

define i1 @andflag32ri(i32 %a) {
; CHECK-LABEL: andflag32ri:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andl $123456, %edi # EVEX TO LEGACY Compression encoding: [0x81,0xe7,0x40,0xe2,0x01,0x00]
; CHECK-NEXT:    # imm = 0x1E240
; CHECK-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; CHECK-NEXT:    movl %edi, d64(%rip) # encoding: [0x89,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 2, value: d64, kind: reloc_riprel_4byte
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: andflag32ri:
; NF:       # %bb.0:
; NF-NEXT:    andl $123456, %edi # EVEX TO LEGACY Compression encoding: [0x81,0xe7,0x40,0xe2,0x01,0x00]
; NF-NEXT:    # imm = 0x1E240
; NF-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; NF-NEXT:    movl %edi, d64(%rip) # encoding: [0x89,0x3d,A,A,A,A]
; NF-NEXT:    # fixup A - offset: 2, value: d64, kind: reloc_riprel_4byte
; NF-NEXT:    retq # encoding: [0xc3]
  %v0 = and i32 %a, 123456  ; 0xff << 50
  %v1 = icmp eq i32 %v0, 0
  store i32 %v0, ptr @d64
  ret i1 %v1
}

define i1 @andflag64ri(i64 %a) {
; CHECK-LABEL: andflag64ri:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andq $123456, %rdi # EVEX TO LEGACY Compression encoding: [0x48,0x81,0xe7,0x40,0xe2,0x01,0x00]
; CHECK-NEXT:    # imm = 0x1E240
; CHECK-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; CHECK-NEXT:    movq %rdi, d64(%rip) # encoding: [0x48,0x89,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: d64, kind: reloc_riprel_4byte
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: andflag64ri:
; NF:       # %bb.0:
; NF-NEXT:    andq $123456, %rdi # EVEX TO LEGACY Compression encoding: [0x48,0x81,0xe7,0x40,0xe2,0x01,0x00]
; NF-NEXT:    # imm = 0x1E240
; NF-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; NF-NEXT:    movq %rdi, d64(%rip) # encoding: [0x48,0x89,0x3d,A,A,A,A]
; NF-NEXT:    # fixup A - offset: 3, value: d64, kind: reloc_riprel_4byte
; NF-NEXT:    retq # encoding: [0xc3]
  %v0 = and i64 %a, 123456  ; 0xff << 50
  %v1 = icmp eq i64 %v0, 0
  store i64 %v0, ptr @d64
  ret i1 %v1
}

define i1 @andflag16ri8(i16 %a) {
; CHECK-LABEL: andflag16ri8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andw $-124, %di, %cx # encoding: [0x62,0xf4,0x75,0x18,0x83,0xe7,0x84]
; CHECK-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; CHECK-NEXT:    movw %cx, d64(%rip) # encoding: [0x66,0x89,0x0d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: d64, kind: reloc_riprel_4byte
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: andflag16ri8:
; NF:       # %bb.0:
; NF-NEXT:    andw $-124, %di, %cx # encoding: [0x62,0xf4,0x75,0x18,0x83,0xe7,0x84]
; NF-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; NF-NEXT:    movw %cx, d64(%rip) # encoding: [0x66,0x89,0x0d,A,A,A,A]
; NF-NEXT:    # fixup A - offset: 3, value: d64, kind: reloc_riprel_4byte
; NF-NEXT:    retq # encoding: [0xc3]
  %xor = xor i16 123, -1
  %v0 = and i16 %a, %xor  ; 0xff << 50
  %v1 = icmp eq i16 %v0, 0
  store i16 %v0, ptr @d64
  ret i1 %v1
}

define i1 @andflag32ri8(i32 %a) {
; CHECK-LABEL: andflag32ri8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andl $123, %edi # EVEX TO LEGACY Compression encoding: [0x83,0xe7,0x7b]
; CHECK-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; CHECK-NEXT:    movl %edi, d64(%rip) # encoding: [0x89,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 2, value: d64, kind: reloc_riprel_4byte
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: andflag32ri8:
; NF:       # %bb.0:
; NF-NEXT:    andl $123, %edi # EVEX TO LEGACY Compression encoding: [0x83,0xe7,0x7b]
; NF-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; NF-NEXT:    movl %edi, d64(%rip) # encoding: [0x89,0x3d,A,A,A,A]
; NF-NEXT:    # fixup A - offset: 2, value: d64, kind: reloc_riprel_4byte
; NF-NEXT:    retq # encoding: [0xc3]
  %v0 = and i32 %a, 123  ; 0xff << 50
  %v1 = icmp eq i32 %v0, 0
  store i32 %v0, ptr @d64
  ret i1 %v1
}

define i1 @andflag64ri8(i64 %a) {
; CHECK-LABEL: andflag64ri8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andq $123, %rdi # EVEX TO LEGACY Compression encoding: [0x48,0x83,0xe7,0x7b]
; CHECK-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; CHECK-NEXT:    movq %rdi, d64(%rip) # encoding: [0x48,0x89,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: d64, kind: reloc_riprel_4byte
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: andflag64ri8:
; NF:       # %bb.0:
; NF-NEXT:    andq $123, %rdi # EVEX TO LEGACY Compression encoding: [0x48,0x83,0xe7,0x7b]
; NF-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; NF-NEXT:    movq %rdi, d64(%rip) # encoding: [0x48,0x89,0x3d,A,A,A,A]
; NF-NEXT:    # fixup A - offset: 3, value: d64, kind: reloc_riprel_4byte
; NF-NEXT:    retq # encoding: [0xc3]
  %v0 = and i64 %a, 123  ; 0xff << 50
  %v1 = icmp eq i64 %v0, 0
  store i64 %v0, ptr @d64
  ret i1 %v1
}

define void @and8mr_legacy(ptr %a, i8 noundef %b) {
; CHECK-LABEL: and8mr_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andb %sil, (%rdi) # encoding: [0x40,0x20,0x37]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and8mr_legacy:
; NF:       # %bb.0: # %entry
; NF-NEXT:    andb %sil, (%rdi) # encoding: [0x40,0x20,0x37]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i8, ptr %a
  %and = and i8 %t, %b
  store i8 %and, ptr %a
  ret void
}

define void @and16mr_legacy(ptr %a, i16 noundef %b) {
; CHECK-LABEL: and16mr_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andw %si, (%rdi) # encoding: [0x66,0x21,0x37]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and16mr_legacy:
; NF:       # %bb.0: # %entry
; NF-NEXT:    andw %si, (%rdi) # encoding: [0x66,0x21,0x37]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i16, ptr %a
  %and = and i16 %t, %b
  store i16 %and, ptr %a
  ret void
}

define void @and32mr_legacy(ptr %a, i32 noundef %b) {
; CHECK-LABEL: and32mr_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andl %esi, (%rdi) # encoding: [0x21,0x37]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and32mr_legacy:
; NF:       # %bb.0: # %entry
; NF-NEXT:    andl %esi, (%rdi) # encoding: [0x21,0x37]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i32, ptr %a
  %and = and i32 %t, %b
  store i32 %and, ptr %a
  ret void
}

define void @and64mr_legacy(ptr %a, i64 noundef %b) {
; CHECK-LABEL: and64mr_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andq %rsi, (%rdi) # encoding: [0x48,0x21,0x37]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and64mr_legacy:
; NF:       # %bb.0: # %entry
; NF-NEXT:    andq %rsi, (%rdi) # encoding: [0x48,0x21,0x37]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i64, ptr %a
  %and = and i64 %t, %b
  store i64 %and, ptr %a
  ret void
}

define void @and8mi_legacy(ptr %a) {
; CHECK-LABEL: and8mi_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andb $123, (%rdi) # encoding: [0x80,0x27,0x7b]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and8mi_legacy:
; NF:       # %bb.0: # %entry
; NF-NEXT:    andb $123, (%rdi) # encoding: [0x80,0x27,0x7b]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i8, ptr %a
  %and = and i8 %t, 123
  store i8 %and, ptr %a
  ret void
}

define void @and16mi_legacy(ptr %a) {
; CHECK-LABEL: and16mi_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andw $1234, (%rdi) # encoding: [0x66,0x81,0x27,0xd2,0x04]
; CHECK-NEXT:    # imm = 0x4D2
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and16mi_legacy:
; NF:       # %bb.0: # %entry
; NF-NEXT:    andw $1234, (%rdi) # encoding: [0x66,0x81,0x27,0xd2,0x04]
; NF-NEXT:    # imm = 0x4D2
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i16, ptr %a
  %and = and i16 %t, 1234
  store i16 %and, ptr %a
  ret void
}

define void @and32mi_legacy(ptr %a) {
; CHECK-LABEL: and32mi_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andl $123456, (%rdi) # encoding: [0x81,0x27,0x40,0xe2,0x01,0x00]
; CHECK-NEXT:    # imm = 0x1E240
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and32mi_legacy:
; NF:       # %bb.0: # %entry
; NF-NEXT:    andl $123456, (%rdi) # encoding: [0x81,0x27,0x40,0xe2,0x01,0x00]
; NF-NEXT:    # imm = 0x1E240
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i32, ptr %a
  %and = and i32 %t, 123456
  store i32 %and, ptr %a
  ret void
}

define void @and64mi_legacy(ptr %a) {
; CHECK-LABEL: and64mi_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andq $123456, (%rdi) # encoding: [0x48,0x81,0x27,0x40,0xe2,0x01,0x00]
; CHECK-NEXT:    # imm = 0x1E240
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: and64mi_legacy:
; NF:       # %bb.0: # %entry
; NF-NEXT:    andq $123456, (%rdi) # encoding: [0x48,0x81,0x27,0x40,0xe2,0x01,0x00]
; NF-NEXT:    # imm = 0x1E240
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i64, ptr %a
  %and = and i64 %t, 123456
  store i64 %and, ptr %a
  ret void
}
