/* unified-privacy-files.c generated by valac 0.20.1, the Vala compiler
 * generated from unified-privacy-files.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; intend-tabs-mode: t -*- */
/* alm
 *
 * Copyright (C) 2012 Seif Lotfy <seif@lotfy.com>
 * Copyright (C) 2012 Manish Sinha <manishsinha@ubuntu.com>
 * Copyright (C) 2012 Intel Corp.
 *               Authored by: Seif Lotfy <seif.lotfy@collabora.co.uk>
 * Copyright (C) 2012 Stefano Candori <stefano.candori@gmail.com>
 *
 * alm is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * alm is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <zeitgeist-datamodel.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <pango/pango.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define ALM_TYPE_FILE_TYPE_BLACKLIST (alm_file_type_blacklist_get_type ())
#define ALM_FILE_TYPE_BLACKLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALM_TYPE_FILE_TYPE_BLACKLIST, AlmFileTypeBlacklist))
#define ALM_FILE_TYPE_BLACKLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALM_TYPE_FILE_TYPE_BLACKLIST, AlmFileTypeBlacklistClass))
#define ALM_IS_FILE_TYPE_BLACKLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALM_TYPE_FILE_TYPE_BLACKLIST))
#define ALM_IS_FILE_TYPE_BLACKLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALM_TYPE_FILE_TYPE_BLACKLIST))
#define ALM_FILE_TYPE_BLACKLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALM_TYPE_FILE_TYPE_BLACKLIST, AlmFileTypeBlacklistClass))

typedef struct _AlmFileTypeBlacklist AlmFileTypeBlacklist;
typedef struct _AlmFileTypeBlacklistClass AlmFileTypeBlacklistClass;
typedef struct _AlmFileTypeBlacklistPrivate AlmFileTypeBlacklistPrivate;

#define ALM_TYPE_BLACKLIST (alm_blacklist_get_type ())
#define ALM_BLACKLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALM_TYPE_BLACKLIST, AlmBlacklist))
#define ALM_BLACKLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALM_TYPE_BLACKLIST, AlmBlacklistClass))
#define ALM_IS_BLACKLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALM_TYPE_BLACKLIST))
#define ALM_IS_BLACKLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALM_TYPE_BLACKLIST))
#define ALM_BLACKLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALM_TYPE_BLACKLIST, AlmBlacklistClass))

typedef struct _AlmBlacklist AlmBlacklist;
typedef struct _AlmBlacklistClass AlmBlacklistClass;
#define _alm_blacklist_unref0(var) ((var == NULL) ? NULL : (var = (alm_blacklist_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _AlmParamSpecFileTypeBlacklist AlmParamSpecFileTypeBlacklist;

#define ALM_TYPE_PATH_BLACKLIST (alm_path_blacklist_get_type ())
#define ALM_PATH_BLACKLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALM_TYPE_PATH_BLACKLIST, AlmPathBlacklist))
#define ALM_PATH_BLACKLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALM_TYPE_PATH_BLACKLIST, AlmPathBlacklistClass))
#define ALM_IS_PATH_BLACKLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALM_TYPE_PATH_BLACKLIST))
#define ALM_IS_PATH_BLACKLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALM_TYPE_PATH_BLACKLIST))
#define ALM_PATH_BLACKLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALM_TYPE_PATH_BLACKLIST, AlmPathBlacklistClass))

typedef struct _AlmPathBlacklist AlmPathBlacklist;
typedef struct _AlmPathBlacklistClass AlmPathBlacklistClass;
typedef struct _AlmPathBlacklistPrivate AlmPathBlacklistPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _AlmParamSpecPathBlacklist AlmParamSpecPathBlacklist;

#define ALM_TYPE_FILES_CELL_RENDERER (alm_files_cell_renderer_get_type ())
#define ALM_FILES_CELL_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALM_TYPE_FILES_CELL_RENDERER, AlmFilesCellRenderer))
#define ALM_FILES_CELL_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALM_TYPE_FILES_CELL_RENDERER, AlmFilesCellRendererClass))
#define ALM_IS_FILES_CELL_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALM_TYPE_FILES_CELL_RENDERER))
#define ALM_IS_FILES_CELL_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALM_TYPE_FILES_CELL_RENDERER))
#define ALM_FILES_CELL_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALM_TYPE_FILES_CELL_RENDERER, AlmFilesCellRendererClass))

typedef struct _AlmFilesCellRenderer AlmFilesCellRenderer;
typedef struct _AlmFilesCellRendererClass AlmFilesCellRendererClass;
typedef struct _AlmFilesCellRendererPrivate AlmFilesCellRendererPrivate;
#define _pango_attribute_destroy0(var) ((var == NULL) ? NULL : (var = (pango_attribute_destroy (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define __vala_PangoAttrList_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoAttrList_free (var), NULL)))

struct _AlmFileTypeBlacklist {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AlmFileTypeBlacklistPrivate * priv;
};

struct _AlmFileTypeBlacklistClass {
	GTypeClass parent_class;
	void (*finalize) (AlmFileTypeBlacklist *self);
};

struct _AlmFileTypeBlacklistPrivate {
	AlmBlacklist* blacklist_interface;
	GeeHashMap* checkboxes;
};

struct _AlmParamSpecFileTypeBlacklist {
	GParamSpec parent_instance;
};

struct _AlmPathBlacklist {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AlmPathBlacklistPrivate * priv;
};

struct _AlmPathBlacklistClass {
	GTypeClass parent_class;
	void (*finalize) (AlmPathBlacklist *self);
};

struct _AlmPathBlacklistPrivate {
	AlmBlacklist* blacklist_interface;
	GeeHashSet* all_blocked_folder;
};

struct _AlmParamSpecPathBlacklist {
	GParamSpec parent_instance;
};

struct _AlmFilesCellRenderer {
	GtkCellRenderer parent_instance;
	AlmFilesCellRendererPrivate * priv;
};

struct _AlmFilesCellRendererClass {
	GtkCellRendererClass parent_class;
};

struct _AlmFilesCellRendererPrivate {
	GtkWidget* current_widget;
	GdkPixbuf* pixbuf_;
	gchar* text_;
	gchar* path_;
};


static gpointer alm_file_type_blacklist_parent_class = NULL;
extern gchar* alm_file_type_blacklist_interpretation_prefix;
gchar* alm_file_type_blacklist_interpretation_prefix = NULL;
static gpointer alm_path_blacklist_parent_class = NULL;
extern gchar* alm_path_blacklist_folder_prefix;
gchar* alm_path_blacklist_folder_prefix = NULL;
static gchar* alm_path_blacklist_suffix;
static gchar* alm_path_blacklist_suffix = NULL;
static gpointer alm_files_cell_renderer_parent_class = NULL;

gpointer alm_file_type_blacklist_ref (gpointer instance);
void alm_file_type_blacklist_unref (gpointer instance);
GParamSpec* alm_param_spec_file_type_blacklist (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void alm_value_set_file_type_blacklist (GValue* value, gpointer v_object);
void alm_value_take_file_type_blacklist (GValue* value, gpointer v_object);
gpointer alm_value_get_file_type_blacklist (const GValue* value);
GType alm_file_type_blacklist_get_type (void) G_GNUC_CONST;
gpointer alm_blacklist_ref (gpointer instance);
void alm_blacklist_unref (gpointer instance);
GParamSpec* alm_param_spec_blacklist (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void alm_value_set_blacklist (GValue* value, gpointer v_object);
void alm_value_take_blacklist (GValue* value, gpointer v_object);
gpointer alm_value_get_blacklist (const GValue* value);
GType alm_blacklist_get_type (void) G_GNUC_CONST;
#define ALM_FILE_TYPE_BLACKLIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ALM_TYPE_FILE_TYPE_BLACKLIST, AlmFileTypeBlacklistPrivate))
enum  {
	ALM_FILE_TYPE_BLACKLIST_DUMMY_PROPERTY
};
AlmFileTypeBlacklist* alm_file_type_blacklist_new (AlmBlacklist* blacklist_inter, GeeHashMap* all_checkboxes);
AlmFileTypeBlacklist* alm_file_type_blacklist_construct (GType object_type, AlmBlacklist* blacklist_inter, GeeHashMap* all_checkboxes);
static gchar* alm_file_type_blacklist_get_name (AlmFileTypeBlacklist* self, const gchar* interpretation);
void alm_file_type_blacklist_populate_file_types (AlmFileTypeBlacklist* self);
GHashTable* alm_blacklist_get_all_templates (AlmBlacklist* self);
void alm_file_type_blacklist_block (AlmFileTypeBlacklist* self, const gchar* interpretation);
void alm_blacklist_add_template (AlmBlacklist* self, const gchar* blacklist_id, ZeitgeistEvent* blacklist_template);
void alm_file_type_blacklist_unblock (AlmFileTypeBlacklist* self, const gchar* interpretation);
void alm_blacklist_remove_template (AlmBlacklist* self, const gchar* blacklist_id);
static void alm_file_type_blacklist_finalize (AlmFileTypeBlacklist* obj);
gpointer alm_path_blacklist_ref (gpointer instance);
void alm_path_blacklist_unref (gpointer instance);
GParamSpec* alm_param_spec_path_blacklist (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void alm_value_set_path_blacklist (GValue* value, gpointer v_object);
void alm_value_take_path_blacklist (GValue* value, gpointer v_object);
gpointer alm_value_get_path_blacklist (const GValue* value);
GType alm_path_blacklist_get_type (void) G_GNUC_CONST;
#define ALM_PATH_BLACKLIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ALM_TYPE_PATH_BLACKLIST, AlmPathBlacklistPrivate))
enum  {
	ALM_PATH_BLACKLIST_DUMMY_PROPERTY
};
AlmPathBlacklist* alm_path_blacklist_new (AlmBlacklist* blacklist_inter);
AlmPathBlacklist* alm_path_blacklist_construct (GType object_type, AlmBlacklist* blacklist_inter);
static void alm_path_blacklist_on_blacklist_added (AlmPathBlacklist* self, const gchar* blacklist_id, ZeitgeistEvent* ev);
static void _alm_path_blacklist_on_blacklist_added_alm_blacklist_template_added (AlmBlacklist* _sender, const gchar* blacklist_id, ZeitgeistEvent* blacklist_template, gpointer self);
static void alm_path_blacklist_on_blacklist_removed (AlmPathBlacklist* self, const gchar* blacklist_id, ZeitgeistEvent* ev);
static void _alm_path_blacklist_on_blacklist_removed_alm_blacklist_template_removed (AlmBlacklist* _sender, const gchar* blacklist_id, ZeitgeistEvent* blacklist_template, gpointer self);
static void alm_path_blacklist_get_blocked_folder (AlmPathBlacklist* self);
gboolean alm_path_blacklist_is_duplicate (AlmPathBlacklist* self, const gchar* path);
static gchar* alm_path_blacklist_get_folder (AlmPathBlacklist* self, ZeitgeistEvent* ev);
void alm_path_blacklist_block (AlmPathBlacklist* self, const gchar* folder);
void alm_path_blacklist_unblock (AlmPathBlacklist* self, const gchar* folder);
GeeHashSet* alm_path_blacklist_get_all_folders (AlmPathBlacklist* self);
static void alm_path_blacklist_finalize (AlmPathBlacklist* obj);
GType alm_files_cell_renderer_get_type (void) G_GNUC_CONST;
#define ALM_FILES_CELL_RENDERER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ALM_TYPE_FILES_CELL_RENDERER, AlmFilesCellRendererPrivate))
enum  {
	ALM_FILES_CELL_RENDERER_DUMMY_PROPERTY,
	ALM_FILES_CELL_RENDERER_PIXBUF,
	ALM_FILES_CELL_RENDERER_TEXT,
	ALM_FILES_CELL_RENDERER_PATH
};
#define ALM_FILES_CELL_RENDERER_PIXBUF_SIZE 24
#define ALM_FILES_CELL_RENDERER_xspacing 3
#define ALM_FILES_CELL_RENDERER_default_width 60
#define ALM_FILES_CELL_RENDERER_renderer_height 50
AlmFilesCellRenderer* alm_files_cell_renderer_new (void);
AlmFilesCellRenderer* alm_files_cell_renderer_construct (GType object_type);
static PangoLayout* alm_files_cell_renderer_get_text_layout (AlmFilesCellRenderer* self, GtkWidget* widget, GdkRectangle* cell_area, GtkCellRendererState flags, const gchar* text, gboolean bold, gint size);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static PangoAttrList* _vala_PangoAttrList_copy (PangoAttrList* self);
static void _vala_PangoAttrList_free (PangoAttrList* self);
static void alm_files_cell_renderer_real_get_size (GtkCellRenderer* base, GtkWidget* widget, GdkRectangle* cell_area, gint* x_offset, gint* y_offset, gint* width, gint* height);
static void alm_files_cell_renderer_do_get_size (AlmFilesCellRenderer* self, GtkWidget* widget, GdkRectangle* cell_area, PangoLayout* layout, gint* x_offset, gint* y_offset);
static void alm_files_cell_renderer_real_render (GtkCellRenderer* base, cairo_t* cr, GtkWidget* widget, GdkRectangle* background_area, GdkRectangle* cell_area, GtkCellRendererState flags);
const gchar* alm_files_cell_renderer_get_text (AlmFilesCellRenderer* self);
const gchar* alm_files_cell_renderer_get_path (AlmFilesCellRenderer* self);
GdkPixbuf* alm_files_cell_renderer_get_pixbuf (AlmFilesCellRenderer* self);
static void alm_files_cell_renderer_real_get_preferred_width (GtkCellRenderer* base, GtkWidget* widget, gint* min_width, gint* nat_width);
static void alm_files_cell_renderer_real_get_preferred_height_for_width (GtkCellRenderer* base, GtkWidget* widget, gint width, gint* minimum_height, gint* natural_height);
static void alm_files_cell_renderer_real_get_preferred_height (GtkCellRenderer* base, GtkWidget* widget, gint* minimum_size, gint* natural_size);
void alm_files_cell_renderer_set_pixbuf (AlmFilesCellRenderer* self, GdkPixbuf* value);
void alm_files_cell_renderer_set_text (AlmFilesCellRenderer* self, const gchar* value);
void alm_files_cell_renderer_set_path (AlmFilesCellRenderer* self, const gchar* value);
static void alm_files_cell_renderer_finalize (GObject* obj);
static void _vala_alm_files_cell_renderer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_alm_files_cell_renderer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _alm_blacklist_ref0 (gpointer self) {
	return self ? alm_blacklist_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


AlmFileTypeBlacklist* alm_file_type_blacklist_construct (GType object_type, AlmBlacklist* blacklist_inter, GeeHashMap* all_checkboxes) {
	AlmFileTypeBlacklist* self = NULL;
	AlmBlacklist* _tmp0_;
	AlmBlacklist* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp3_;
	g_return_val_if_fail (blacklist_inter != NULL, NULL);
	g_return_val_if_fail (all_checkboxes != NULL, NULL);
	self = (AlmFileTypeBlacklist*) g_type_create_instance (object_type);
	_tmp0_ = blacklist_inter;
	_tmp1_ = _alm_blacklist_ref0 (_tmp0_);
	_alm_blacklist_unref0 (self->priv->blacklist_interface);
	self->priv->blacklist_interface = _tmp1_;
	_tmp2_ = all_checkboxes;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->checkboxes);
	self->priv->checkboxes = _tmp3_;
	return self;
}


AlmFileTypeBlacklist* alm_file_type_blacklist_new (AlmBlacklist* blacklist_inter, GeeHashMap* all_checkboxes) {
	return alm_file_type_blacklist_construct (ALM_TYPE_FILE_TYPE_BLACKLIST, blacklist_inter, all_checkboxes);
}


static gchar* alm_file_type_blacklist_get_name (AlmFileTypeBlacklist* self, const gchar* interpretation) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** names;
	gint names_length1;
	gint _names_size_;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* name;
	const gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (interpretation != NULL, NULL);
	_tmp0_ = interpretation;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, "#", 0);
	names = _tmp2_;
	names_length1 = _vala_array_length (_tmp1_);
	_names_size_ = names_length1;
	_tmp3_ = names[names_length1 - 1];
	_tmp4_ = g_utf8_strdown (_tmp3_, (gssize) (-1));
	name = _tmp4_;
	_tmp5_ = alm_file_type_blacklist_interpretation_prefix;
	_tmp6_ = g_strdup_printf ("%s%s", _tmp5_, name);
	result = _tmp6_;
	_g_free0 (name);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


void alm_file_type_blacklist_populate_file_types (AlmFileTypeBlacklist* self) {
	AlmBlacklist* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	GList* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->blacklist_interface;
	_tmp1_ = alm_blacklist_get_all_templates (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_hash_table_get_keys (_tmp2_);
	{
		GList* key_collection = NULL;
		GList* key_it = NULL;
		key_collection = _tmp3_;
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
			gchar* _tmp4_;
			gchar* key = NULL;
			_tmp4_ = g_strdup ((const gchar*) key_it->data);
			key = _tmp4_;
			{
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				gboolean _tmp7_ = FALSE;
				_tmp5_ = key;
				_tmp6_ = alm_file_type_blacklist_interpretation_prefix;
				_tmp7_ = g_str_has_prefix (_tmp5_, _tmp6_);
				if (_tmp7_) {
					AlmBlacklist* _tmp8_;
					GHashTable* _tmp9_;
					GHashTable* _tmp10_;
					const gchar* _tmp11_;
					gconstpointer _tmp12_ = NULL;
					ZeitgeistSubject* _tmp13_ = NULL;
					ZeitgeistSubject* _tmp14_;
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					gchar* inter;
					gboolean _tmp19_ = FALSE;
					GeeHashMap* _tmp20_;
					const gchar* _tmp21_;
					gboolean _tmp22_ = FALSE;
					GeeHashMap* _tmp23_;
					const gchar* _tmp24_;
					gpointer _tmp25_ = NULL;
					GtkCheckButton* _tmp26_;
					gboolean _tmp27_;
					_tmp8_ = self->priv->blacklist_interface;
					_tmp9_ = alm_blacklist_get_all_templates (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = key;
					_tmp12_ = g_hash_table_lookup (_tmp10_, _tmp11_);
					_tmp13_ = zeitgeist_event_get_subject ((ZeitgeistEvent*) _tmp12_, 0);
					_tmp14_ = _tmp13_;
					_tmp15_ = zeitgeist_subject_get_interpretation (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = g_strdup (_tmp16_);
					_tmp18_ = _tmp17_;
					_g_object_unref0 (_tmp14_);
					inter = _tmp18_;
					_tmp20_ = self->priv->checkboxes;
					_tmp21_ = inter;
					_tmp22_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp20_, _tmp21_);
					if (_tmp22_) {
						_tmp19_ = FALSE;
					} else {
						_tmp19_ = TRUE;
					}
					_tmp23_ = self->priv->checkboxes;
					_tmp24_ = inter;
					_tmp25_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp23_, _tmp24_);
					_tmp26_ = (GtkCheckButton*) _tmp25_;
					_tmp27_ = _tmp19_;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp26_, _tmp27_);
					_g_object_unref0 (_tmp26_);
					_g_free0 (inter);
				}
				_g_free0 (key);
			}
		}
		_g_list_free0 (key_collection);
	}
}


void alm_file_type_blacklist_block (AlmFileTypeBlacklist* self, const gchar* interpretation) {
	ZeitgeistEvent* _tmp0_;
	ZeitgeistEvent* ev;
	ZeitgeistSubject* _tmp1_;
	ZeitgeistSubject* sub;
	const gchar* _tmp2_;
	AlmBlacklist* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (interpretation != NULL);
	_tmp0_ = zeitgeist_event_new ();
	ev = _tmp0_;
	_tmp1_ = zeitgeist_subject_new ();
	sub = _tmp1_;
	_tmp2_ = interpretation;
	zeitgeist_subject_set_interpretation (sub, _tmp2_);
	zeitgeist_event_add_subject (ev, sub);
	_tmp3_ = self->priv->blacklist_interface;
	_tmp4_ = interpretation;
	_tmp5_ = alm_file_type_blacklist_get_name (self, _tmp4_);
	_tmp6_ = _tmp5_;
	alm_blacklist_add_template (_tmp3_, _tmp6_, ev);
	_g_free0 (_tmp6_);
	_g_object_unref0 (sub);
	_g_object_unref0 (ev);
}


void alm_file_type_blacklist_unblock (AlmFileTypeBlacklist* self, const gchar* interpretation) {
	AlmBlacklist* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (interpretation != NULL);
	_tmp0_ = self->priv->blacklist_interface;
	_tmp1_ = interpretation;
	_tmp2_ = alm_file_type_blacklist_get_name (self, _tmp1_);
	_tmp3_ = _tmp2_;
	alm_blacklist_remove_template (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
}


static void alm_value_file_type_blacklist_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void alm_value_file_type_blacklist_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		alm_file_type_blacklist_unref (value->data[0].v_pointer);
	}
}


static void alm_value_file_type_blacklist_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = alm_file_type_blacklist_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer alm_value_file_type_blacklist_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* alm_value_file_type_blacklist_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		AlmFileTypeBlacklist* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = alm_file_type_blacklist_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* alm_value_file_type_blacklist_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	AlmFileTypeBlacklist** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = alm_file_type_blacklist_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* alm_param_spec_file_type_blacklist (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	AlmParamSpecFileTypeBlacklist* spec;
	g_return_val_if_fail (g_type_is_a (object_type, ALM_TYPE_FILE_TYPE_BLACKLIST), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer alm_value_get_file_type_blacklist (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ALM_TYPE_FILE_TYPE_BLACKLIST), NULL);
	return value->data[0].v_pointer;
}


void alm_value_set_file_type_blacklist (GValue* value, gpointer v_object) {
	AlmFileTypeBlacklist* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ALM_TYPE_FILE_TYPE_BLACKLIST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ALM_TYPE_FILE_TYPE_BLACKLIST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		alm_file_type_blacklist_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		alm_file_type_blacklist_unref (old);
	}
}


void alm_value_take_file_type_blacklist (GValue* value, gpointer v_object) {
	AlmFileTypeBlacklist* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ALM_TYPE_FILE_TYPE_BLACKLIST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ALM_TYPE_FILE_TYPE_BLACKLIST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		alm_file_type_blacklist_unref (old);
	}
}


static void alm_file_type_blacklist_class_init (AlmFileTypeBlacklistClass * klass) {
	gchar* _tmp0_;
	alm_file_type_blacklist_parent_class = g_type_class_peek_parent (klass);
	ALM_FILE_TYPE_BLACKLIST_CLASS (klass)->finalize = alm_file_type_blacklist_finalize;
	g_type_class_add_private (klass, sizeof (AlmFileTypeBlacklistPrivate));
	_tmp0_ = g_strdup ("interpretation-");
	alm_file_type_blacklist_interpretation_prefix = _tmp0_;
}


static void alm_file_type_blacklist_instance_init (AlmFileTypeBlacklist * self) {
	self->priv = ALM_FILE_TYPE_BLACKLIST_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void alm_file_type_blacklist_finalize (AlmFileTypeBlacklist* obj) {
	AlmFileTypeBlacklist * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ALM_TYPE_FILE_TYPE_BLACKLIST, AlmFileTypeBlacklist);
	_alm_blacklist_unref0 (self->priv->blacklist_interface);
	_g_object_unref0 (self->priv->checkboxes);
}


GType alm_file_type_blacklist_get_type (void) {
	static volatile gsize alm_file_type_blacklist_type_id__volatile = 0;
	if (g_once_init_enter (&alm_file_type_blacklist_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { alm_value_file_type_blacklist_init, alm_value_file_type_blacklist_free_value, alm_value_file_type_blacklist_copy_value, alm_value_file_type_blacklist_peek_pointer, "p", alm_value_file_type_blacklist_collect_value, "p", alm_value_file_type_blacklist_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AlmFileTypeBlacklistClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) alm_file_type_blacklist_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AlmFileTypeBlacklist), 0, (GInstanceInitFunc) alm_file_type_blacklist_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType alm_file_type_blacklist_type_id;
		alm_file_type_blacklist_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AlmFileTypeBlacklist", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&alm_file_type_blacklist_type_id__volatile, alm_file_type_blacklist_type_id);
	}
	return alm_file_type_blacklist_type_id__volatile;
}


gpointer alm_file_type_blacklist_ref (gpointer instance) {
	AlmFileTypeBlacklist* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void alm_file_type_blacklist_unref (gpointer instance) {
	AlmFileTypeBlacklist* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ALM_FILE_TYPE_BLACKLIST_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _alm_path_blacklist_on_blacklist_added_alm_blacklist_template_added (AlmBlacklist* _sender, const gchar* blacklist_id, ZeitgeistEvent* blacklist_template, gpointer self) {
	alm_path_blacklist_on_blacklist_added (self, blacklist_id, blacklist_template);
}


static void _alm_path_blacklist_on_blacklist_removed_alm_blacklist_template_removed (AlmBlacklist* _sender, const gchar* blacklist_id, ZeitgeistEvent* blacklist_template, gpointer self) {
	alm_path_blacklist_on_blacklist_removed (self, blacklist_id, blacklist_template);
}


AlmPathBlacklist* alm_path_blacklist_construct (GType object_type, AlmBlacklist* blacklist_inter) {
	AlmPathBlacklist* self = NULL;
	AlmBlacklist* _tmp0_;
	AlmBlacklist* _tmp1_;
	AlmBlacklist* _tmp2_;
	AlmBlacklist* _tmp3_;
	g_return_val_if_fail (blacklist_inter != NULL, NULL);
	self = (AlmPathBlacklist*) g_type_create_instance (object_type);
	_tmp0_ = blacklist_inter;
	_tmp1_ = _alm_blacklist_ref0 (_tmp0_);
	_alm_blacklist_unref0 (self->priv->blacklist_interface);
	self->priv->blacklist_interface = _tmp1_;
	_tmp2_ = self->priv->blacklist_interface;
	g_signal_connect (_tmp2_, "template-added", (GCallback) _alm_path_blacklist_on_blacklist_added_alm_blacklist_template_added, self);
	_tmp3_ = self->priv->blacklist_interface;
	g_signal_connect (_tmp3_, "template-removed", (GCallback) _alm_path_blacklist_on_blacklist_removed_alm_blacklist_template_removed, self);
	alm_path_blacklist_get_blocked_folder (self);
	return self;
}


AlmPathBlacklist* alm_path_blacklist_new (AlmBlacklist* blacklist_inter) {
	return alm_path_blacklist_construct (ALM_TYPE_PATH_BLACKLIST, blacklist_inter);
}


gboolean alm_path_blacklist_is_duplicate (AlmPathBlacklist* self, const gchar* path) {
	gboolean result = FALSE;
	GeeHashSet* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = self->priv->all_blocked_folder;
	_tmp1_ = path;
	_tmp2_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static void alm_path_blacklist_get_blocked_folder (AlmPathBlacklist* self) {
	GeeHashSet* _tmp0_;
	AlmBlacklist* _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GList* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	_g_object_unref0 (self->priv->all_blocked_folder);
	self->priv->all_blocked_folder = _tmp0_;
	_tmp1_ = self->priv->blacklist_interface;
	_tmp2_ = alm_blacklist_get_all_templates (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_hash_table_get_keys (_tmp3_);
	{
		GList* key_collection = NULL;
		GList* key_it = NULL;
		key_collection = _tmp4_;
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
			gchar* _tmp5_;
			gchar* key = NULL;
			_tmp5_ = g_strdup ((const gchar*) key_it->data);
			key = _tmp5_;
			{
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				gboolean _tmp8_ = FALSE;
				_tmp6_ = key;
				_tmp7_ = alm_path_blacklist_folder_prefix;
				_tmp8_ = g_str_has_prefix (_tmp6_, _tmp7_);
				if (_tmp8_) {
					AlmBlacklist* _tmp9_;
					GHashTable* _tmp10_;
					GHashTable* _tmp11_;
					const gchar* _tmp12_;
					gconstpointer _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					gchar* folder;
					const gchar* _tmp15_;
					_tmp9_ = self->priv->blacklist_interface;
					_tmp10_ = alm_blacklist_get_all_templates (_tmp9_);
					_tmp11_ = _tmp10_;
					_tmp12_ = key;
					_tmp13_ = g_hash_table_lookup (_tmp11_, _tmp12_);
					_tmp14_ = alm_path_blacklist_get_folder (self, (ZeitgeistEvent*) _tmp13_);
					folder = _tmp14_;
					_tmp15_ = folder;
					if (_tmp15_ != NULL) {
						GeeHashSet* _tmp16_;
						const gchar* _tmp17_;
						_tmp16_ = self->priv->all_blocked_folder;
						_tmp17_ = folder;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp17_);
					}
					_g_free0 (folder);
				}
				_g_free0 (key);
			}
		}
		_g_list_free0 (key_collection);
	}
}


static void alm_path_blacklist_on_blacklist_added (AlmPathBlacklist* self, const gchar* blacklist_id, ZeitgeistEvent* ev) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (blacklist_id != NULL);
	g_return_if_fail (ev != NULL);
	_tmp0_ = blacklist_id;
	_tmp1_ = alm_path_blacklist_folder_prefix;
	_tmp2_ = g_str_has_prefix (_tmp0_, _tmp1_);
	if (_tmp2_) {
		ZeitgeistEvent* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* uri;
		const gchar* _tmp5_;
		_tmp3_ = ev;
		_tmp4_ = alm_path_blacklist_get_folder (self, _tmp3_);
		uri = _tmp4_;
		_tmp5_ = uri;
		if (_tmp5_ != NULL) {
			const gchar* _tmp6_;
			GeeHashSet* _tmp7_;
			const gchar* _tmp8_;
			gboolean _tmp9_ = FALSE;
			_tmp6_ = uri;
			g_signal_emit_by_name (self, "folder-added", _tmp6_);
			_tmp7_ = self->priv->all_blocked_folder;
			_tmp8_ = uri;
			_tmp9_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp7_, _tmp8_);
			if (!_tmp9_) {
				GeeHashSet* _tmp10_;
				const gchar* _tmp11_;
				_tmp10_ = self->priv->all_blocked_folder;
				_tmp11_ = uri;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
			}
		}
		_g_free0 (uri);
	}
}


static void alm_path_blacklist_on_blacklist_removed (AlmPathBlacklist* self, const gchar* blacklist_id, ZeitgeistEvent* ev) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (blacklist_id != NULL);
	g_return_if_fail (ev != NULL);
	_tmp0_ = blacklist_id;
	_tmp1_ = alm_path_blacklist_folder_prefix;
	_tmp2_ = g_str_has_prefix (_tmp0_, _tmp1_);
	if (_tmp2_) {
		ZeitgeistEvent* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* uri;
		const gchar* _tmp5_;
		_tmp3_ = ev;
		_tmp4_ = alm_path_blacklist_get_folder (self, _tmp3_);
		uri = _tmp4_;
		_tmp5_ = uri;
		if (_tmp5_ != NULL) {
			const gchar* _tmp6_;
			GeeHashSet* _tmp7_;
			const gchar* _tmp8_;
			gboolean _tmp9_ = FALSE;
			_tmp6_ = uri;
			g_signal_emit_by_name (self, "folder-removed", _tmp6_);
			_tmp7_ = self->priv->all_blocked_folder;
			_tmp8_ = uri;
			_tmp9_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp7_, _tmp8_);
			if (_tmp9_) {
				GeeHashSet* _tmp10_;
				const gchar* _tmp11_;
				_tmp10_ = self->priv->all_blocked_folder;
				_tmp11_ = uri;
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp10_, _tmp11_);
			}
		}
		_g_free0 (uri);
	}
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally2;
	__catch2_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar* alm_path_blacklist_get_folder (AlmPathBlacklist* self, ZeitgeistEvent* ev) {
	gchar* result = NULL;
	ZeitgeistEvent* _tmp0_;
	ZeitgeistSubject* _tmp1_ = NULL;
	ZeitgeistSubject* sub;
	ZeitgeistSubject* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* uri;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_;
	GFile* _tmp10_ = NULL;
	GFile* blocked_uri;
	gchar* _tmp11_ = NULL;
	GFile* _tmp12_;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* final_path;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (ev != NULL, NULL);
	_tmp0_ = ev;
	_tmp1_ = zeitgeist_event_get_subject (_tmp0_, 0);
	sub = _tmp1_;
	_tmp2_ = sub;
	_tmp3_ = zeitgeist_subject_get_uri (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	uri = _tmp5_;
	_tmp6_ = uri;
	_tmp7_ = alm_path_blacklist_suffix;
	_tmp8_ = string_replace (_tmp6_, _tmp7_, "");
	_g_free0 (uri);
	uri = _tmp8_;
	_tmp9_ = uri;
	_tmp10_ = g_file_new_for_uri (_tmp9_);
	blocked_uri = _tmp10_;
	_tmp12_ = blocked_uri;
	_tmp13_ = g_file_query_exists (_tmp12_, NULL);
	if (_tmp13_) {
		GFile* _tmp14_;
		gchar* _tmp15_ = NULL;
		_tmp14_ = blocked_uri;
		_tmp15_ = g_file_get_path (_tmp14_);
		_g_free0 (_tmp11_);
		_tmp11_ = _tmp15_;
	} else {
		_g_free0 (_tmp11_);
		_tmp11_ = NULL;
	}
	_tmp16_ = _tmp11_;
	_tmp17_ = g_strdup (_tmp16_);
	final_path = _tmp17_;
	result = final_path;
	_g_free0 (_tmp11_);
	_g_object_unref0 (blocked_uri);
	_g_free0 (uri);
	_g_object_unref0 (sub);
	return result;
}


void alm_path_blacklist_block (AlmPathBlacklist* self, const gchar* folder) {
	ZeitgeistEvent* _tmp0_;
	ZeitgeistEvent* ev;
	ZeitgeistSubject* _tmp1_;
	ZeitgeistSubject* sub;
	const gchar* _tmp2_;
	GFile* _tmp3_ = NULL;
	GFile* block_path;
	GFile* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* uri;
	ZeitgeistSubject* _tmp10_;
	const gchar* _tmp11_;
	ZeitgeistEvent* _tmp12_;
	ZeitgeistSubject* _tmp13_;
	AlmBlacklist* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	ZeitgeistEvent* _tmp19_;
	GeeHashSet* _tmp20_;
	const gchar* _tmp21_;
	gboolean _tmp22_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (folder != NULL);
	_tmp0_ = zeitgeist_event_new ();
	ev = _tmp0_;
	_tmp1_ = zeitgeist_subject_new ();
	sub = _tmp1_;
	_tmp2_ = folder;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	block_path = _tmp3_;
	_tmp4_ = block_path;
	_tmp5_ = g_file_get_uri (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = alm_path_blacklist_suffix;
	_tmp8_ = g_strdup_printf ("%s%s", _tmp6_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp6_);
	uri = _tmp9_;
	_tmp10_ = sub;
	_tmp11_ = uri;
	zeitgeist_subject_set_uri (_tmp10_, _tmp11_);
	_tmp12_ = ev;
	_tmp13_ = sub;
	zeitgeist_event_add_subject (_tmp12_, _tmp13_);
	_tmp14_ = self->priv->blacklist_interface;
	_tmp15_ = alm_path_blacklist_folder_prefix;
	_tmp16_ = folder;
	_tmp17_ = g_strdup_printf ("%s%s", _tmp15_, _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = ev;
	alm_blacklist_add_template (_tmp14_, _tmp18_, _tmp19_);
	_g_free0 (_tmp18_);
	_tmp20_ = self->priv->all_blocked_folder;
	_tmp21_ = folder;
	_tmp22_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp20_, _tmp21_);
	if (!_tmp22_) {
		GeeHashSet* _tmp23_;
		const gchar* _tmp24_;
		_tmp23_ = self->priv->all_blocked_folder;
		_tmp24_ = folder;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, _tmp24_);
	}
	_g_free0 (uri);
	_g_object_unref0 (block_path);
	_g_object_unref0 (sub);
	_g_object_unref0 (ev);
}


void alm_path_blacklist_unblock (AlmPathBlacklist* self, const gchar* folder) {
	AlmBlacklist* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	GeeHashSet* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (folder != NULL);
	_tmp0_ = self->priv->blacklist_interface;
	_tmp1_ = alm_path_blacklist_folder_prefix;
	_tmp2_ = folder;
	_tmp3_ = g_strdup_printf ("%s%s", _tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	alm_blacklist_remove_template (_tmp0_, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->priv->all_blocked_folder;
	_tmp6_ = folder;
	_tmp7_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp5_, _tmp6_);
	if (_tmp7_) {
		GeeHashSet* _tmp8_;
		const gchar* _tmp9_;
		_tmp8_ = self->priv->all_blocked_folder;
		_tmp9_ = folder;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp8_, _tmp9_);
	}
}


GeeHashSet* alm_path_blacklist_get_all_folders (AlmPathBlacklist* self) {
	GeeHashSet* result;
	GeeHashSet* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->all_blocked_folder;
	result = _tmp0_;
	return result;
}


static void alm_value_path_blacklist_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void alm_value_path_blacklist_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		alm_path_blacklist_unref (value->data[0].v_pointer);
	}
}


static void alm_value_path_blacklist_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = alm_path_blacklist_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer alm_value_path_blacklist_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* alm_value_path_blacklist_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		AlmPathBlacklist* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = alm_path_blacklist_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* alm_value_path_blacklist_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	AlmPathBlacklist** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = alm_path_blacklist_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* alm_param_spec_path_blacklist (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	AlmParamSpecPathBlacklist* spec;
	g_return_val_if_fail (g_type_is_a (object_type, ALM_TYPE_PATH_BLACKLIST), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer alm_value_get_path_blacklist (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ALM_TYPE_PATH_BLACKLIST), NULL);
	return value->data[0].v_pointer;
}


void alm_value_set_path_blacklist (GValue* value, gpointer v_object) {
	AlmPathBlacklist* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ALM_TYPE_PATH_BLACKLIST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ALM_TYPE_PATH_BLACKLIST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		alm_path_blacklist_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		alm_path_blacklist_unref (old);
	}
}


void alm_value_take_path_blacklist (GValue* value, gpointer v_object) {
	AlmPathBlacklist* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ALM_TYPE_PATH_BLACKLIST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ALM_TYPE_PATH_BLACKLIST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		alm_path_blacklist_unref (old);
	}
}


static void alm_path_blacklist_class_init (AlmPathBlacklistClass * klass) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	alm_path_blacklist_parent_class = g_type_class_peek_parent (klass);
	ALM_PATH_BLACKLIST_CLASS (klass)->finalize = alm_path_blacklist_finalize;
	g_type_class_add_private (klass, sizeof (AlmPathBlacklistPrivate));
	g_signal_new ("folder_added", ALM_TYPE_PATH_BLACKLIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("folder_removed", ALM_TYPE_PATH_BLACKLIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	_tmp0_ = g_strdup ("dir-");
	alm_path_blacklist_folder_prefix = _tmp0_;
	_tmp1_ = g_strdup ("/*");
	alm_path_blacklist_suffix = _tmp1_;
}


static void alm_path_blacklist_instance_init (AlmPathBlacklist * self) {
	self->priv = ALM_PATH_BLACKLIST_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void alm_path_blacklist_finalize (AlmPathBlacklist* obj) {
	AlmPathBlacklist * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ALM_TYPE_PATH_BLACKLIST, AlmPathBlacklist);
	_alm_blacklist_unref0 (self->priv->blacklist_interface);
	_g_object_unref0 (self->priv->all_blocked_folder);
}


GType alm_path_blacklist_get_type (void) {
	static volatile gsize alm_path_blacklist_type_id__volatile = 0;
	if (g_once_init_enter (&alm_path_blacklist_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { alm_value_path_blacklist_init, alm_value_path_blacklist_free_value, alm_value_path_blacklist_copy_value, alm_value_path_blacklist_peek_pointer, "p", alm_value_path_blacklist_collect_value, "p", alm_value_path_blacklist_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AlmPathBlacklistClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) alm_path_blacklist_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AlmPathBlacklist), 0, (GInstanceInitFunc) alm_path_blacklist_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType alm_path_blacklist_type_id;
		alm_path_blacklist_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AlmPathBlacklist", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&alm_path_blacklist_type_id__volatile, alm_path_blacklist_type_id);
	}
	return alm_path_blacklist_type_id__volatile;
}


gpointer alm_path_blacklist_ref (gpointer instance) {
	AlmPathBlacklist* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void alm_path_blacklist_unref (gpointer instance) {
	AlmPathBlacklist* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ALM_PATH_BLACKLIST_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


AlmFilesCellRenderer* alm_files_cell_renderer_construct (GType object_type) {
	AlmFilesCellRenderer * self = NULL;
	self = (AlmFilesCellRenderer*) g_object_new (object_type, NULL);
	return self;
}


AlmFilesCellRenderer* alm_files_cell_renderer_new (void) {
	return alm_files_cell_renderer_construct (ALM_TYPE_FILES_CELL_RENDERER);
}


static void _vala_PangoFontDescription_free (PangoFontDescription* self) {
	g_boxed_free (pango_font_description_get_type (), self);
}


static PangoAttrList* _vala_PangoAttrList_copy (PangoAttrList* self) {
	return g_boxed_copy (pango_attr_list_get_type (), self);
}


static gpointer __vala_PangoAttrList_copy0 (gpointer self) {
	return self ? _vala_PangoAttrList_copy (self) : NULL;
}


static void _vala_PangoAttrList_free (PangoAttrList* self) {
	g_boxed_free (pango_attr_list_get_type (), self);
}


static PangoLayout* alm_files_cell_renderer_get_text_layout (AlmFilesCellRenderer* self, GtkWidget* widget, GdkRectangle* cell_area, GtkCellRendererState flags, const gchar* text, gboolean bold, gint size) {
	PangoLayout* result = NULL;
	PangoLayout* layout = NULL;
	gint xpad = 0;
	PangoAttrList* _tmp0_;
	PangoAttrList* attr_list;
	GtkWidget* _tmp1_;
	const gchar* _tmp2_;
	PangoLayout* _tmp3_ = NULL;
	gint _tmp4_;
	PangoAttrSize* _tmp5_;
	PangoAttrSize* attr;
	PangoAttrSize* _tmp6_;
	PangoAttrSize* _tmp7_;
	PangoAttrSize* _tmp8_;
	PangoAttrSize* _tmp9_;
	guint _tmp10_;
	const gchar* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	PangoAttrList* _tmp14_;
	PangoAttrSize* _tmp15_;
	gboolean _tmp16_;
	PangoLayout* _tmp23_;
	PangoAttrList* _tmp24_;
	PangoAttrList* _tmp25_;
	gint _tmp26_ = 0;
	PangoLayout* _tmp27_;
	PangoRectangle rect = {0};
	gint width = 0;
	gint text_width = 0;
	PangoLayout* _tmp28_;
	PangoRectangle _tmp29_ = {0};
	PangoRectangle _tmp30_;
	gint _tmp31_;
	GdkRectangle* _tmp32_;
	gint _tmp36_;
	gint _tmp37_;
	gint _tmp38_ = 0;
	PangoLayout* _tmp39_;
	gint _tmp40_;
	PangoAlignment align = 0;
	GtkWidget* _tmp41_;
	GtkTextDirection _tmp42_ = 0;
	PangoLayout* _tmp43_;
	PangoAlignment _tmp44_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (widget != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = pango_attr_list_new ();
	attr_list = _tmp0_;
	_tmp1_ = widget;
	_tmp2_ = text;
	_tmp3_ = gtk_widget_create_pango_layout (_tmp1_, _tmp2_);
	_g_object_unref0 (layout);
	layout = _tmp3_;
	_tmp4_ = size;
	_tmp5_ = (PangoAttrSize*) pango_attr_size_new (_tmp4_ * PANGO_SCALE);
	attr = _tmp5_;
	_tmp6_ = attr;
	_tmp6_->absolute = (guint) 1;
	_tmp7_ = attr;
	((PangoAttribute*) _tmp7_)->start_index = (guint) 0;
	_tmp8_ = attr;
	_tmp9_ = attr;
	_tmp10_ = ((PangoAttribute*) _tmp9_)->start_index;
	_tmp11_ = text;
	_tmp12_ = strlen (_tmp11_);
	_tmp13_ = _tmp12_;
	((PangoAttribute*) _tmp8_)->end_index = _tmp10_ + _tmp13_;
	_tmp14_ = attr_list;
	_tmp15_ = attr;
	attr = NULL;
	pango_attr_list_insert (_tmp14_, (PangoAttribute*) _tmp15_);
	_tmp16_ = bold;
	if (_tmp16_) {
		PangoFontDescription* _tmp17_;
		PangoFontDescription* desc;
		PangoFontDescription* _tmp18_;
		PangoFontDescription* _tmp19_;
		PangoAttrFontDesc* _tmp20_;
		PangoAttrFontDesc* attr_f;
		PangoAttrList* _tmp21_;
		PangoAttrFontDesc* _tmp22_;
		_tmp17_ = pango_font_description_new ();
		desc = _tmp17_;
		_tmp18_ = desc;
		pango_font_description_set_weight (_tmp18_, PANGO_WEIGHT_BOLD);
		_tmp19_ = desc;
		_tmp20_ = (PangoAttrFontDesc*) pango_attr_font_desc_new (_tmp19_);
		attr_f = _tmp20_;
		_tmp21_ = attr_list;
		_tmp22_ = attr_f;
		attr_f = NULL;
		pango_attr_list_insert (_tmp21_, (PangoAttribute*) _tmp22_);
		_pango_attribute_destroy0 (attr_f);
		__vala_PangoFontDescription_free0 (desc);
	}
	_tmp23_ = layout;
	_tmp24_ = attr_list;
	_tmp25_ = __vala_PangoAttrList_copy0 (_tmp24_);
	pango_layout_set_attributes (_tmp23_, _tmp25_);
	gtk_cell_renderer_get_padding ((GtkCellRenderer*) self, &_tmp26_, NULL);
	xpad = _tmp26_;
	_tmp27_ = layout;
	pango_layout_set_ellipsize (_tmp27_, PANGO_ELLIPSIZE_END);
	_tmp28_ = layout;
	pango_layout_get_extents (_tmp28_, NULL, &_tmp29_);
	rect = _tmp29_;
	_tmp30_ = rect;
	_tmp31_ = _tmp30_.width;
	text_width = _tmp31_;
	_tmp32_ = cell_area;
	if (_tmp32_ != NULL) {
		GdkRectangle* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		_tmp33_ = cell_area;
		_tmp34_ = (*_tmp33_).width;
		_tmp35_ = xpad;
		width = (_tmp34_ - _tmp35_) * PANGO_SCALE;
	} else {
		width = ALM_FILES_CELL_RENDERER_default_width * PANGO_SCALE;
	}
	_tmp36_ = width;
	_tmp37_ = text_width;
	_tmp38_ = MIN (_tmp36_, _tmp37_);
	width = _tmp38_;
	_tmp39_ = layout;
	_tmp40_ = width;
	pango_layout_set_width (_tmp39_, _tmp40_);
	_tmp41_ = widget;
	_tmp42_ = gtk_widget_get_direction (_tmp41_);
	if (_tmp42_ == GTK_TEXT_DIR_RTL) {
		align = PANGO_ALIGN_RIGHT;
	} else {
		align = PANGO_ALIGN_LEFT;
	}
	_tmp43_ = layout;
	_tmp44_ = align;
	pango_layout_set_alignment (_tmp43_, _tmp44_);
	result = layout;
	_pango_attribute_destroy0 (attr);
	__vala_PangoAttrList_free0 (attr_list);
	return result;
}


static void alm_files_cell_renderer_real_get_size (GtkCellRenderer* base, GtkWidget* widget, GdkRectangle* cell_area, gint* x_offset, gint* y_offset, gint* width, gint* height) {
	AlmFilesCellRenderer * self;
	gint _vala_x_offset = 0;
	gint _vala_y_offset = 0;
	gint _vala_width = 0;
	gint _vala_height = 0;
	self = (AlmFilesCellRenderer*) base;
	g_return_if_fail (widget != NULL);
	_vala_height = 0;
	_vala_width = _vala_height;
	_vala_y_offset = _vala_width;
	_vala_x_offset = _vala_y_offset;
	if (x_offset) {
		*x_offset = _vala_x_offset;
	}
	if (y_offset) {
		*y_offset = _vala_y_offset;
	}
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
}


static void alm_files_cell_renderer_do_get_size (AlmFilesCellRenderer* self, GtkWidget* widget, GdkRectangle* cell_area, PangoLayout* layout, gint* x_offset, gint* y_offset) {
	gint _vala_x_offset = 0;
	gint _vala_y_offset = 0;
	PangoRectangle rect = {0};
	gint xpad = 0;
	gint ypad = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	PangoLayout* _tmp2_;
	PangoRectangle _tmp3_ = {0};
	GdkRectangle* _tmp4_;
	gint _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	gtk_cell_renderer_get_padding ((GtkCellRenderer*) self, &_tmp0_, &_tmp1_);
	xpad = _tmp0_;
	ypad = _tmp1_;
	_tmp2_ = layout;
	pango_layout_get_pixel_extents (_tmp2_, NULL, &_tmp3_);
	rect = _tmp3_;
	_tmp4_ = cell_area;
	if (_tmp4_ != NULL) {
		PangoRectangle _tmp5_;
		gint _tmp6_;
		GdkRectangle* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_ = 0;
		GtkWidget* _tmp11_;
		GtkTextDirection _tmp12_ = 0;
		gint _tmp19_;
		gint _tmp20_ = 0;
		_tmp5_ = rect;
		_tmp6_ = _tmp5_.width;
		_tmp7_ = cell_area;
		_tmp8_ = (*_tmp7_).width;
		_tmp9_ = xpad;
		_tmp10_ = MIN (_tmp6_, (_tmp8_ - (2 * _tmp9_)) + ALM_FILES_CELL_RENDERER_xspacing);
		rect.width = _tmp10_;
		_tmp11_ = widget;
		_tmp12_ = gtk_widget_get_direction (_tmp11_);
		if (_tmp12_ == GTK_TEXT_DIR_RTL) {
			GdkRectangle* _tmp13_;
			gint _tmp14_;
			PangoRectangle _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			_tmp13_ = cell_area;
			_tmp14_ = (*_tmp13_).width;
			_tmp15_ = rect;
			_tmp16_ = _tmp15_.width;
			_tmp17_ = xpad;
			_vala_x_offset = _tmp14_ - (_tmp16_ + _tmp17_);
		} else {
			gint _tmp18_;
			_tmp18_ = xpad;
			_vala_x_offset = _tmp18_;
		}
		_tmp19_ = _vala_x_offset;
		_tmp20_ = MAX (_tmp19_, 0);
		_vala_x_offset = _tmp20_;
	} else {
		_vala_x_offset = 0;
	}
	_tmp21_ = ypad;
	_vala_y_offset = _tmp21_;
	if (x_offset) {
		*x_offset = _vala_x_offset;
	}
	if (y_offset) {
		*y_offset = _vala_y_offset;
	}
}


static void alm_files_cell_renderer_real_render (GtkCellRenderer* base, cairo_t* cr, GtkWidget* widget, GdkRectangle* background_area, GdkRectangle* cell_area, GtkCellRendererState flags) {
	AlmFilesCellRenderer * self;
	GtkStyleContext* context = NULL;
	PangoLayout* text_layout = NULL;
	PangoLayout* path_layout = NULL;
	gint text_x_offset;
	gint path_x_offset;
	gint text_y_offset;
	gint path_y_offset;
	gint xpad = 0;
	PangoRectangle text_rect = {0};
	PangoRectangle path_rect = {0};
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkStyleContext* _tmp3_ = NULL;
	GtkStyleContext* _tmp4_;
	PangoFontDescription* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint font_size;
	gint _tmp7_ = 0;
	GtkWidget* _tmp8_;
	GdkRectangle _tmp9_;
	GtkCellRendererState _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	PangoLayout* _tmp13_ = NULL;
	GtkWidget* _tmp14_;
	GdkRectangle _tmp15_;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	PangoRectangle _tmp18_ = {0};
	gint _tmp19_;
	PangoRectangle _tmp20_;
	gint _tmp21_;
	GtkWidget* _tmp22_;
	GdkRectangle _tmp23_;
	GtkCellRendererState _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	PangoLayout* _tmp27_ = NULL;
	GtkWidget* _tmp28_;
	GdkRectangle _tmp29_;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	PangoRectangle _tmp32_ = {0};
	gint _tmp33_;
	PangoRectangle _tmp34_;
	gint _tmp35_;
	cairo_t* _tmp36_;
	cairo_t* _tmp37_;
	GdkRectangle _tmp38_;
	cairo_t* _tmp39_;
	cairo_t* _tmp40_;
	GdkPixbuf* _tmp41_;
	GdkPixbuf* _tmp42_;
	GdkRectangle _tmp43_;
	gint _tmp44_;
	GdkRectangle _tmp45_;
	gint _tmp46_;
	cairo_t* _tmp47_;
	cairo_t* _tmp48_;
	GdkRectangle _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	GdkPixbuf* _tmp52_;
	GdkPixbuf* _tmp53_;
	gint _tmp54_;
	gint _tmp55_;
	GdkRectangle _tmp56_;
	gint _tmp57_;
	gint _tmp58_;
	cairo_t* _tmp59_;
	GdkRectangle _tmp60_;
	gint _tmp61_;
	gint _tmp62_;
	GdkRectangle _tmp63_;
	gint _tmp64_;
	gint _tmp65_;
	gint _tmp66_ = 0;
	cairo_t* _tmp67_;
	self = (AlmFilesCellRenderer*) base;
	g_return_if_fail (cr != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (background_area != NULL);
	g_return_if_fail (cell_area != NULL);
	text_x_offset = 0;
	path_x_offset = 0;
	text_y_offset = 0;
	path_y_offset = 0;
	_tmp0_ = widget;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->current_widget);
	self->priv->current_widget = _tmp1_;
	_tmp2_ = widget;
	_tmp3_ = gtk_widget_get_style_context (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (context);
	context = _tmp4_;
	_tmp5_ = gtk_style_context_get_font (context, GTK_STATE_FLAG_NORMAL);
	_tmp6_ = pango_font_description_get_size (_tmp5_);
	font_size = _tmp6_ / PANGO_SCALE;
	gtk_cell_renderer_get_padding ((GtkCellRenderer*) self, &_tmp7_, NULL);
	xpad = _tmp7_;
	_tmp8_ = widget;
	_tmp9_ = *cell_area;
	_tmp10_ = flags;
	_tmp11_ = alm_files_cell_renderer_get_text (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = alm_files_cell_renderer_get_text_layout (self, _tmp8_, &_tmp9_, _tmp10_, _tmp12_, TRUE, font_size);
	_g_object_unref0 (text_layout);
	text_layout = _tmp13_;
	_tmp14_ = widget;
	_tmp15_ = *cell_area;
	alm_files_cell_renderer_do_get_size (self, _tmp14_, &_tmp15_, text_layout, &_tmp16_, &_tmp17_);
	text_x_offset = _tmp16_;
	text_y_offset = _tmp17_;
	pango_layout_get_pixel_extents (text_layout, NULL, &_tmp18_);
	text_rect = _tmp18_;
	_tmp19_ = text_x_offset;
	_tmp20_ = text_rect;
	_tmp21_ = _tmp20_.x;
	text_x_offset = _tmp19_ - _tmp21_;
	_tmp22_ = widget;
	_tmp23_ = *cell_area;
	_tmp24_ = flags;
	_tmp25_ = alm_files_cell_renderer_get_path (self);
	_tmp26_ = _tmp25_;
	_tmp27_ = alm_files_cell_renderer_get_text_layout (self, _tmp22_, &_tmp23_, _tmp24_, _tmp26_, FALSE, font_size - 1);
	_g_object_unref0 (path_layout);
	path_layout = _tmp27_;
	_tmp28_ = widget;
	_tmp29_ = *cell_area;
	alm_files_cell_renderer_do_get_size (self, _tmp28_, &_tmp29_, path_layout, &_tmp30_, &_tmp31_);
	path_x_offset = _tmp30_;
	path_y_offset = _tmp31_;
	pango_layout_get_pixel_extents (path_layout, NULL, &_tmp32_);
	path_rect = _tmp32_;
	_tmp33_ = path_x_offset;
	_tmp34_ = path_rect;
	_tmp35_ = _tmp34_.x;
	path_x_offset = _tmp33_ - _tmp35_;
	_tmp36_ = cr;
	cairo_save (_tmp36_);
	_tmp37_ = cr;
	_tmp38_ = *cell_area;
	gdk_cairo_rectangle (_tmp37_, &_tmp38_);
	_tmp39_ = cr;
	cairo_clip (_tmp39_);
	_tmp40_ = cr;
	_tmp41_ = alm_files_cell_renderer_get_pixbuf (self);
	_tmp42_ = _tmp41_;
	_tmp43_ = *cell_area;
	_tmp44_ = _tmp43_.x;
	_tmp45_ = *cell_area;
	_tmp46_ = _tmp45_.y;
	gdk_cairo_set_source_pixbuf (_tmp40_, _tmp42_, (gdouble) _tmp44_, (gdouble) _tmp46_);
	_tmp47_ = cr;
	cairo_paint (_tmp47_);
	_tmp48_ = cr;
	_tmp49_ = *cell_area;
	_tmp50_ = _tmp49_.x;
	_tmp51_ = text_x_offset;
	_tmp52_ = alm_files_cell_renderer_get_pixbuf (self);
	_tmp53_ = _tmp52_;
	_tmp54_ = gdk_pixbuf_get_width (_tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = *cell_area;
	_tmp57_ = _tmp56_.y;
	_tmp58_ = text_y_offset;
	gtk_render_layout (context, _tmp48_, (gdouble) (((_tmp50_ + _tmp51_) + _tmp55_) + ALM_FILES_CELL_RENDERER_xspacing), (gdouble) ((_tmp57_ + _tmp58_) + 2), text_layout);
	_tmp59_ = cr;
	_tmp60_ = *cell_area;
	_tmp61_ = _tmp60_.x;
	_tmp62_ = path_x_offset;
	_tmp63_ = *cell_area;
	_tmp64_ = _tmp63_.y;
	_tmp65_ = path_y_offset;
	_tmp66_ = pango_layout_get_baseline (path_layout);
	gtk_render_layout (context, _tmp59_, (gdouble) (_tmp61_ + _tmp62_), (gdouble) ((((_tmp64_ + _tmp65_) + ALM_FILES_CELL_RENDERER_renderer_height) - 11) - (_tmp66_ / PANGO_SCALE)), path_layout);
	_tmp67_ = cr;
	cairo_restore (_tmp67_);
	_g_object_unref0 (path_layout);
	_g_object_unref0 (text_layout);
	_g_object_unref0 (context);
}


static void alm_files_cell_renderer_real_get_preferred_width (GtkCellRenderer* base, GtkWidget* widget, gint* min_width, gint* nat_width) {
	AlmFilesCellRenderer * self;
	gint _vala_min_width = 0;
	gint _vala_nat_width = 0;
	gint xpad = 0;
	gint _tmp0_ = 0;
	self = (AlmFilesCellRenderer*) base;
	g_return_if_fail (widget != NULL);
	gtk_cell_renderer_get_padding ((GtkCellRenderer*) self, &_tmp0_, NULL);
	xpad = _tmp0_;
	_vala_min_width = xpad + ALM_FILES_CELL_RENDERER_default_width;
	_vala_nat_width = _vala_min_width;
	if (min_width) {
		*min_width = _vala_min_width;
	}
	if (nat_width) {
		*nat_width = _vala_nat_width;
	}
}


static void alm_files_cell_renderer_real_get_preferred_height_for_width (GtkCellRenderer* base, GtkWidget* widget, gint width, gint* minimum_height, gint* natural_height) {
	AlmFilesCellRenderer * self;
	gint _vala_minimum_height = 0;
	gint _vala_natural_height = 0;
	gint ypad = 0;
	gint _tmp0_ = 0;
	self = (AlmFilesCellRenderer*) base;
	g_return_if_fail (widget != NULL);
	gtk_cell_renderer_get_padding ((GtkCellRenderer*) self, NULL, &_tmp0_);
	ypad = _tmp0_;
	_vala_minimum_height = ALM_FILES_CELL_RENDERER_renderer_height + ypad;
	_vala_natural_height = ALM_FILES_CELL_RENDERER_renderer_height + ypad;
	if (minimum_height) {
		*minimum_height = _vala_minimum_height;
	}
	if (natural_height) {
		*natural_height = _vala_natural_height;
	}
}


static void alm_files_cell_renderer_real_get_preferred_height (GtkCellRenderer* base, GtkWidget* widget, gint* minimum_size, gint* natural_size) {
	AlmFilesCellRenderer * self;
	gint _vala_minimum_size = 0;
	gint _vala_natural_size = 0;
	gint min_width = 0;
	GtkWidget* _tmp0_;
	gint _tmp1_ = 0;
	GtkWidget* _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	self = (AlmFilesCellRenderer*) base;
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	gtk_cell_renderer_get_preferred_width ((GtkCellRenderer*) self, _tmp0_, &_tmp1_, NULL);
	min_width = _tmp1_;
	_tmp2_ = widget;
	gtk_cell_renderer_get_preferred_height_for_width ((GtkCellRenderer*) self, _tmp2_, min_width, &_tmp3_, &_tmp4_);
	_vala_minimum_size = _tmp3_;
	_vala_natural_size = _tmp4_;
	if (minimum_size) {
		*minimum_size = _vala_minimum_size;
	}
	if (natural_size) {
		*natural_size = _vala_natural_size;
	}
}


GdkPixbuf* alm_files_cell_renderer_get_pixbuf (AlmFilesCellRenderer* self) {
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->pixbuf_;
	result = _tmp0_;
	return result;
}


void alm_files_cell_renderer_set_pixbuf (AlmFilesCellRenderer* self, GdkPixbuf* value) {
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->pixbuf_);
	self->priv->pixbuf_ = _tmp1_;
	g_object_notify ((GObject *) self, "pixbuf");
}


const gchar* alm_files_cell_renderer_get_text (AlmFilesCellRenderer* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->text_;
	result = _tmp0_;
	return result;
}


void alm_files_cell_renderer_set_text (AlmFilesCellRenderer* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->text_);
	self->priv->text_ = _tmp1_;
	g_object_notify ((GObject *) self, "text");
}


const gchar* alm_files_cell_renderer_get_path (AlmFilesCellRenderer* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->path_;
	result = _tmp0_;
	return result;
}


void alm_files_cell_renderer_set_path (AlmFilesCellRenderer* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->path_);
	self->priv->path_ = _tmp1_;
	g_object_notify ((GObject *) self, "path");
}


static void alm_files_cell_renderer_class_init (AlmFilesCellRendererClass * klass) {
	alm_files_cell_renderer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AlmFilesCellRendererPrivate));
	GTK_CELL_RENDERER_CLASS (klass)->get_size = alm_files_cell_renderer_real_get_size;
	GTK_CELL_RENDERER_CLASS (klass)->render = alm_files_cell_renderer_real_render;
	GTK_CELL_RENDERER_CLASS (klass)->get_preferred_width = alm_files_cell_renderer_real_get_preferred_width;
	GTK_CELL_RENDERER_CLASS (klass)->get_preferred_height_for_width = alm_files_cell_renderer_real_get_preferred_height_for_width;
	GTK_CELL_RENDERER_CLASS (klass)->get_preferred_height = alm_files_cell_renderer_real_get_preferred_height;
	G_OBJECT_CLASS (klass)->get_property = _vala_alm_files_cell_renderer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_alm_files_cell_renderer_set_property;
	G_OBJECT_CLASS (klass)->finalize = alm_files_cell_renderer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ALM_FILES_CELL_RENDERER_PIXBUF, g_param_spec_object ("pixbuf", "pixbuf", "pixbuf", GDK_TYPE_PIXBUF, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ALM_FILES_CELL_RENDERER_TEXT, g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ALM_FILES_CELL_RENDERER_PATH, g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void alm_files_cell_renderer_instance_init (AlmFilesCellRenderer * self) {
	self->priv = ALM_FILES_CELL_RENDERER_GET_PRIVATE (self);
}


static void alm_files_cell_renderer_finalize (GObject* obj) {
	AlmFilesCellRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ALM_TYPE_FILES_CELL_RENDERER, AlmFilesCellRenderer);
	_g_object_unref0 (self->priv->current_widget);
	_g_object_unref0 (self->priv->pixbuf_);
	_g_free0 (self->priv->text_);
	_g_free0 (self->priv->path_);
	G_OBJECT_CLASS (alm_files_cell_renderer_parent_class)->finalize (obj);
}


GType alm_files_cell_renderer_get_type (void) {
	static volatile gsize alm_files_cell_renderer_type_id__volatile = 0;
	if (g_once_init_enter (&alm_files_cell_renderer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AlmFilesCellRendererClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) alm_files_cell_renderer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AlmFilesCellRenderer), 0, (GInstanceInitFunc) alm_files_cell_renderer_instance_init, NULL };
		GType alm_files_cell_renderer_type_id;
		alm_files_cell_renderer_type_id = g_type_register_static (GTK_TYPE_CELL_RENDERER, "AlmFilesCellRenderer", &g_define_type_info, 0);
		g_once_init_leave (&alm_files_cell_renderer_type_id__volatile, alm_files_cell_renderer_type_id);
	}
	return alm_files_cell_renderer_type_id__volatile;
}


static void _vala_alm_files_cell_renderer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AlmFilesCellRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ALM_TYPE_FILES_CELL_RENDERER, AlmFilesCellRenderer);
	switch (property_id) {
		case ALM_FILES_CELL_RENDERER_PIXBUF:
		g_value_set_object (value, alm_files_cell_renderer_get_pixbuf (self));
		break;
		case ALM_FILES_CELL_RENDERER_TEXT:
		g_value_set_string (value, alm_files_cell_renderer_get_text (self));
		break;
		case ALM_FILES_CELL_RENDERER_PATH:
		g_value_set_string (value, alm_files_cell_renderer_get_path (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_alm_files_cell_renderer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AlmFilesCellRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ALM_TYPE_FILES_CELL_RENDERER, AlmFilesCellRenderer);
	switch (property_id) {
		case ALM_FILES_CELL_RENDERER_PIXBUF:
		alm_files_cell_renderer_set_pixbuf (self, g_value_get_object (value));
		break;
		case ALM_FILES_CELL_RENDERER_TEXT:
		alm_files_cell_renderer_set_text (self, g_value_get_string (value));
		break;
		case ALM_FILES_CELL_RENDERER_PATH:
		alm_files_cell_renderer_set_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



