/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.nlctdoc;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.nlctdoc.UserGuideSty;
import java.io.File;
import java.io.IOException;

public class CreateExample
extends ControlSequence {
    private UserGuideSty sty;

    public CreateExample(UserGuideSty userGuideSty) {
        this("createexample", userGuideSty);
    }

    public CreateExample(String string, UserGuideSty userGuideSty) {
        super(string);
        this.sty = userGuideSty;
    }

    @Override
    public Object clone() {
        return new CreateExample(this.getName(), this.sty);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        Object object;
        Object object2;
        TeXObject teXObject;
        LaTeXParserListener laTeXParserListener = (LaTeXParserListener)teXParser.getListener();
        this.popModifier(teXParser, teXObjectList, 42);
        KeyValList keyValList = TeXParserUtils.popOptKeyValList(teXParser, teXObjectList);
        this.popArg(teXParser, teXObjectList);
        this.popArg(teXParser, teXObjectList);
        TeXObject teXObject2 = null;
        TeXObject teXObject3 = null;
        String string = null;
        int[] nArray = null;
        if (keyValList != null) {
            teXObject2 = (TeXObject)keyValList.get("title");
            teXObject3 = (TeXObject)keyValList.get("description");
            if (teXObject3 != null && teXParser.isStack(teXObject3)) {
                ((TeXObjectList)teXObject3).add(laTeXParserListener.getOther(46));
            }
            if ((teXObject = (TeXObject)keyValList.get("label")) != null) {
                string = teXParser.expandToString(teXObject, teXObjectList);
            }
            if ((teXObject = (TeXObject)keyValList.get("pages")) != null && !((String)(object2 = teXParser.expandToString(teXObject, teXObjectList).trim())).isEmpty()) {
                object = ((String)object2).split(" *, *");
                nArray = new int[((String[])object).length];
                for (int i = 0; i < ((String[])object).length; ++i) {
                    try {
                        nArray[i] = Integer.parseInt(object[i]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new TeXSyntaxException((Throwable)numberFormatException, teXParser, "tex.error.number_expected", object[i]);
                    }
                }
            }
        }
        teXObject = laTeXParserListener.createStack();
        ((TeXObjectList)teXObject).add(laTeXParserListener.getControlSequence("refstepcounter"));
        ((TeXObjectList)teXObject).add(laTeXParserListener.createGroup("example"));
        if (string != null) {
            ((TeXObjectList)teXObject).add(laTeXParserListener.getControlSequence("label"));
            ((TeXObjectList)teXObject).add(laTeXParserListener.createGroup(string));
        } else {
            object2 = teXParser.getSettings().getNumericRegister("c@example");
            if (object2 == null) {
                throw new LaTeXSyntaxException(teXParser, "latex.error.undefined_counter", "example");
            }
            int n = object2.number(teXParser) + 1;
            ((TeXObjectList)teXObject).add(laTeXParserListener.getControlSequence("hypertarget"));
            ((TeXObjectList)teXObject).add(laTeXParserListener.createGroup("example." + n));
            ((TeXObjectList)teXObject).add(laTeXParserListener.createGroup());
        }
        TeXParserUtils.process(teXObject, teXParser, teXObjectList);
        ((TeXObjectList)teXObject).add(laTeXParserListener.getControlSequence("nlctexampletag"));
        if (teXObject2 != null) {
            ((TeXObjectList)teXObject).add(laTeXParserListener.getOther(58));
            ((TeXObjectList)teXObject).add(laTeXParserListener.getSpace());
            ((TeXObjectList)teXObject).add(teXObject2);
            ((TeXObjectList)teXObject).add(laTeXParserListener.getSpace());
        }
        if (this.sty.isDraft()) {
            ((TeXObjectList)teXObject).add(laTeXParserListener.getPar());
            ((TeXObjectList)teXObject).add(laTeXParserListener.createString("[DRAFT MODE ON]"));
            TeXParserUtils.process(teXObject, teXParser, teXObjectList);
        } else {
            String string2;
            object2 = teXParser.expandToString(laTeXParserListener.getControlSequence("examplesdir"), teXObjectList);
            object = laTeXParserListener.getControlSequence("nlctexamplefilebasename");
            object = TeXParserUtils.expandOnce((TeXObject)object, teXParser, teXObjectList);
            String string3 = teXParser.expandToString((TeXObject)object, teXObjectList);
            ControlSequence controlSequence = laTeXParserListener.getControlSequence("href");
            ((TeXObjectList)teXObject).add(controlSequence);
            ((TeXObjectList)teXObject).add(laTeXParserListener.createGroup((String)object2 + "/" + string3 + ".tex"));
            ((TeXObjectList)teXObject).add(laTeXParserListener.getControlSequence("exampledownloadtexicon"));
            ((TeXObjectList)teXObject).add(laTeXParserListener.getSpace());
            String string4 = string2 = (String)object2 + "/" + string3 + ".pdf";
            File file = new File((String)object2, string3 + ".pdf");
            ((TeXObjectList)teXObject).add(controlSequence);
            ((TeXObjectList)teXObject).add(laTeXParserListener.createGroup(string2));
            ((TeXObjectList)teXObject).add(laTeXParserListener.getControlSequence("exampledownloadpdficon"));
            File file2 = new File((String)object2, string3 + "-crop.pdf");
            if (file2.exists()) {
                file = file2;
                string4 = (String)object2 + "/" + file.getName();
            }
            ((TeXObjectList)teXObject).add(laTeXParserListener.getPar());
            TeXParserUtils.process(teXObject, teXParser, teXObjectList);
            KeyValList keyValList2 = new KeyValList();
            if (teXObject3 != null) {
                keyValList2.put("alt", teXObject3);
            }
            if (nArray == null) {
                try {
                    File file3 = new File((String)object2, string3 + ".png");
                    if (!file3.exists()) {
                        laTeXParserListener.getTeXApp().convertimage(-1, null, file, null, file3);
                    }
                    if (file3.exists()) {
                        string4 = (String)object2 + "/" + string3 + ".png";
                    }
                }
                catch (IOException | InterruptedException exception) {
                    teXParser.logMessage(exception);
                }
                laTeXParserListener.includegraphics(teXObjectList, keyValList2, string4);
            } else {
                for (int i = 0; i < nArray.length; ++i) {
                    Object object3;
                    string4 = null;
                    try {
                        object3 = String.format("%s-page%d.png", string3, nArray[i]);
                        File file4 = new File((String)object2, (String)object3);
                        if (!file4.exists()) {
                            laTeXParserListener.getTeXApp().convertimage(nArray[i], null, file, null, file4);
                        }
                        if (file4.exists()) {
                            string4 = (String)object2 + "/" + (String)object3;
                        }
                    }
                    catch (IOException | InterruptedException exception) {
                        throw new LaTeXSyntaxException((Throwable)exception, teXParser, "latex.package.error", "nlctuserguide", exception.getMessage());
                    }
                    if (string4 == null) continue;
                    object3 = laTeXParserListener.createString("Page " + nArray[i] + ". ");
                    if (teXObject3 != null) {
                        ((TeXObjectList)object3).add((TeXObject)teXObject3.clone(), true);
                    }
                    keyValList2.put("alt", (TeXObject)object3);
                    keyValList2.put("class", laTeXParserListener.createString("pageimage"));
                    laTeXParserListener.includegraphics(teXObjectList, keyValList2, string4);
                    laTeXParserListener.getWriteable().writeln("");
                }
            }
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }
}

