untrusted comment: signature from openbsd 5.6 base private key
RWR0EANmo9nqhqcSLmw8driixRxEcXj6U5XfgdNrUrNJyUTMIakzVScCAbXE4ZELok6twlHHMCeMiXrizHJwGeLZ//OLuMZplAg=

OpenBSD 5.6 errata 28, Jul 26, 2015:

A kernel memory leak could be triggered by an unprivileged user in
a failure case when using execve under systrace.

Apply by doing:
    signify -Vep /etc/signify/openbsd-56-base.pub -x 028_execve.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/kern/kern_exec.c
===================================================================
RCS file: /data/src/openbsd/src/sys/kern/kern_exec.c,v
retrieving revision 1.144.4.1
diff -u -p -r1.144.4.1 kern_exec.c
--- sys/kern/kern_exec.c	19 Oct 2014 22:18:02 -0000	1.144.4.1
+++ sys/kern/kern_exec.c	26 Jul 2015 23:15:42 -0000
@@ -763,12 +763,12 @@ exec_abort:
 
 free_pack_abort:
 	free(pack.ep_hdr, M_EXEC, 0);
+	if (pathbuf != NULL)
+		pool_put(&namei_pool, pathbuf);
 	exit1(p, W_EXITCODE(0, SIGABRT), EXIT_NORMAL);
 
 	/* NOTREACHED */
 	atomic_clearbits_int(&pr->ps_flags, PS_INEXEC);
-	if (pathbuf != NULL)
-		pool_put(&namei_pool, pathbuf);
 
 	return (0);
 }
