untrusted comment: signature from openbsd 5.6 base private key
RWR0EANmo9nqhlveFcs8F9nZMBGMjTEtoUSm8vL2xxyv44i4Vuli01myjf4HHVzdDv5lAl93JembgC+xicnA0X5GHGqvWBOhWAc=

OpenBSD 5.6 errata 22, Apr 30, 2015:

Logging to a log file is only possible after the logging system was
initialized. Trying to log too early allows a remote user to crash
httpd.

Apply by doing:
    cd /usr/src
    signify -Vep /etc/signify/openbsd-56-base.pub -x 022_httpd.patch.sig -m - | \
        patch -p0

And then rebuild and install httpd:
    cd usr.sbin/httpd
    make obj
    make
    make install

Index: usr.sbin/httpd/server.c
===================================================================
RCS file: /cvs/src/usr.sbin/httpd/server.c,v
retrieving revision 1.39.2.1
diff -u -p -r1.39.2.1 server.c
--- usr.sbin/httpd/server.c	20 Nov 2014 07:48:45 -0000	1.39.2.1
+++ usr.sbin/httpd/server.c	23 Apr 2015 17:32:37 -0000
@@ -836,6 +836,11 @@ server_accept(int fd, short event, void 
 	if ((clt = calloc(1, sizeof(*clt))) == NULL)
 		goto err;
 
+	/* Pre-allocate log buffer */
+	clt->clt_log = evbuffer_new();
+	if (clt->clt_log == NULL)
+		goto err;
+
 	clt->clt_s = s;
 	clt->clt_fd = -1;
 	clt->clt_toread = TOREAD_UNLIMITED;
@@ -880,13 +885,6 @@ server_accept(int fd, short event, void 
 	clt->clt_output = evbuffer_new();
 	if (clt->clt_output == NULL) {
 		server_close(clt, "failed to allocate output buffer");
-		return;
-	}
-
-	/* Pre-allocate log buffer */
-	clt->clt_log = evbuffer_new();
-	if (clt->clt_log == NULL) {
-		server_close(clt, "failed to allocate log buffer");
 		return;
 	}
 
