untrusted comment: signature from openbsd 5.6 base private key
RWR0EANmo9nqhnSKDBy7WgkNZrLujusI8Qvntb9/tVW0P3tfc0eRZ37NLCk0qcu5lurRs5aKGI6y5kGCXgAGE6tos5xwEjWbiw8=

OpenBSD 5.6 errata 19, March 18, 2015

More BDF file parsing issues in libXfont

Afer IOActive's Ilja van Sprundel who found a number of issues in
2014, additional testing by Alan Coopersmith and William Robinet with
the American Fuzzy Lop (afl) tool uncovered two more issues in the
parsing of BDF font files.

Apply patch using:

    signify -Vep /etc/signify/openbsd-56-base.pub -x 019_libxfont.patch.sig \
        -m - | (cd /usr/xenocara && patch -p0)

Then build and install a new libXfont:

    cd /usr/xenocara/lib/libXont
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper build

Index: lib/libXfont/src/bitmap/bdfread.c
===================================================================
RCS file: /cvs/OpenBSD/xenocara/lib/libXfont/src/bitmap/bdfread.c,v
retrieving revision 1.8
diff -u -p -u -r1.8 bdfread.c
--- lib/libXfont/src/bitmap/bdfread.c	7 Jan 2014 20:42:20 -0000	1.8
+++ lib/libXfont/src/bitmap/bdfread.c	17 Mar 2015 21:46:25 -0000
@@ -62,8 +62,16 @@ from The Open Group.
 
 #if HAVE_STDINT_H
 #include <stdint.h>
-#elif !defined(INT32_MAX)
-#define INT32_MAX 0x7fffffff
+#else
+# ifndef INT32_MAX
+#  define INT32_MAX 0x7fffffff
+# endif
+# ifndef INT16_MAX
+#  define INT16_MAX 0x7fff
+# endif
+# ifndef INT16_MIN
+#  define INT16_MIN (0 - 0x8000)
+# endif
 #endif
 
 #define INDICES 256
@@ -417,6 +425,12 @@ bdfReadCharacters(FontFilePtr file, Font
 	    bdfError("DWIDTH y value must be zero\n");
 	    goto BAILOUT;
 	}
+	/* xCharInfo metrics are stored as INT16 */
+	if ((wx < 0) || (wx > INT16_MAX)) {
+	    bdfError("character '%s' has out of range width, %d\n",
+		     charName, wx);
+	    goto BAILOUT;
+	}
 	line = bdfGetLine(file, lineBuf, BDFLINELEN);
 	if ((!line) || (sscanf((char *) line, "BBX %d %d %d %d", &bw, &bh, &bl, &bb) != 4)) {
 	    bdfError("bad 'BBX'\n");
@@ -427,6 +441,14 @@ bdfReadCharacters(FontFilePtr file, Font
 		     charName, bw, bh);
 	    goto BAILOUT;
 	}
+	/* xCharInfo metrics are read as int, but stored as INT16 */
+	if ((bl > INT16_MAX) || (bl < INT16_MIN) ||
+	    (bb > INT16_MAX) || (bb < INT16_MIN) ||
+	    (bw > (INT16_MAX - bl)) || (bh > (INT16_MAX - bb))) {
+	    bdfError("character '%s' has out of range metrics, %d %d %d %d\n",
+		     charName, bl, (bl+bw), (bh+bb), -bb);
+	    goto BAILOUT;
+	}
 	line = bdfGetLine(file, lineBuf, BDFLINELEN);
 	if ((line) && (bdfIsPrefix(line, "ATTRIBUTES"))) {
 	    for (p = line + strlen("ATTRIBUTES ");
@@ -458,7 +480,10 @@ bdfReadCharacters(FontFilePtr file, Font
 	    ci->metrics.descent = -bb;
 	    ci->metrics.characterWidth = wx;
 	    ci->bits = NULL;
-	    bdfReadBitmap(ci, file, bit, byte, glyph, scan, bitmapsSizes);
+	    if (!bdfReadBitmap(ci, file, bit, byte, glyph, scan, bitmapsSizes)) {
+		bdfError("could not read bitmap for character '%s'\n", charName);
+		goto BAILOUT;
+	    }
 	    ci++;
 	    ndx++;
 	} else
@@ -604,7 +629,9 @@ bdfReadProperties(FontFilePtr file, Font
 	bdfError("missing 'STARTPROPERTIES'\n");
 	return (FALSE);
     }
-    if (sscanf((char *) line, "STARTPROPERTIES %d", &nProps) != 1) {
+    if ((sscanf((char *) line, "STARTPROPERTIES %d", &nProps) != 1) ||
+	(nProps <= 0) ||
+	(nProps > ((INT32_MAX / sizeof(FontPropRec)) - BDF_GENPROPS))) {
 	bdfError("bad 'STARTPROPERTIES'\n");
 	return (FALSE);
     }
