/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.beats;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.beats.AckEncoder;
import org.logstash.beats.BeatsHandler;
import org.logstash.beats.BeatsParser;
import org.logstash.beats.ConnectionHandler;
import org.logstash.beats.IMessageListener;
import org.logstash.beats.MessageListener;
import org.logstash.netty.SslHandlerProvider;

public class Server {
    private static final Logger logger = LogManager.getLogger(Server.class);
    private final int port;
    private final String host;
    private final int beatsHeandlerThreadCount;
    private NioEventLoopGroup workGroup;
    private IMessageListener messageListener = new MessageListener();
    private SslHandlerProvider sslHandlerProvider;
    private BeatsInitializer beatsInitializer;
    private final int clientInactivityTimeoutSeconds;

    public Server(String host, int p, int clientInactivityTimeoutSeconds, int threadCount) {
        this.host = host;
        this.port = p;
        this.clientInactivityTimeoutSeconds = clientInactivityTimeoutSeconds;
        this.beatsHeandlerThreadCount = threadCount;
    }

    public void setSslHandlerProvider(SslHandlerProvider sslHandlerProvider) {
        this.sslHandlerProvider = sslHandlerProvider;
    }

    public Server listen() throws InterruptedException {
        if (this.workGroup != null) {
            try {
                logger.debug("Shutting down existing worker group before starting");
                this.workGroup.shutdownGracefully().sync();
            }
            catch (Exception e) {
                logger.error("Could not shut down worker group before starting", (Throwable)e);
            }
        }
        this.workGroup = new NioEventLoopGroup();
        try {
            logger.info("Starting server on port: {}", (Object)this.port);
            this.beatsInitializer = new BeatsInitializer(this.messageListener, this.clientInactivityTimeoutSeconds, this.beatsHeandlerThreadCount);
            ServerBootstrap server = new ServerBootstrap();
            ((ServerBootstrap)server.group((EventLoopGroup)this.workGroup).channel(NioServerSocketChannel.class)).childOption(ChannelOption.SO_LINGER, (Object)0).childHandler((ChannelHandler)this.beatsInitializer);
            Channel channel = server.bind(this.host, this.port).sync().channel();
            channel.closeFuture().sync();
        }
        finally {
            this.shutdown();
        }
        return this;
    }

    public void stop() {
        logger.debug("Server shutting down");
        this.shutdown();
        logger.debug("Server stopped");
    }

    private void shutdown() {
        try {
            if (this.workGroup != null) {
                this.workGroup.shutdownGracefully().sync();
            }
            if (this.beatsInitializer != null) {
                this.beatsInitializer.shutdownEventExecutor();
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setMessageListener(IMessageListener listener) {
        this.messageListener = listener;
    }

    public boolean isSslEnabled() {
        return this.sslHandlerProvider != null;
    }

    private class BeatsInitializer
    extends ChannelInitializer<SocketChannel> {
        private final String SSL_HANDLER = "ssl-handler";
        private final String IDLESTATE_HANDLER = "idlestate-handler";
        private final String CONNECTION_HANDLER = "connection-handler";
        private final String BEATS_ACKER = "beats-acker";
        private final int DEFAULT_IDLESTATEHANDLER_THREAD = 4;
        private final int IDLESTATE_WRITER_IDLE_TIME_SECONDS = 5;
        private final EventExecutorGroup idleExecutorGroup;
        private final EventExecutorGroup beatsHandlerExecutorGroup;
        private final IMessageListener localMessageListener;
        private final int localClientInactivityTimeoutSeconds;

        BeatsInitializer(IMessageListener messageListener, int clientInactivityTimeoutSeconds, int beatsHandlerThread) {
            this.localMessageListener = messageListener;
            this.localClientInactivityTimeoutSeconds = clientInactivityTimeoutSeconds;
            this.idleExecutorGroup = new DefaultEventExecutorGroup(4);
            this.beatsHandlerExecutorGroup = new DefaultEventExecutorGroup(beatsHandlerThread);
        }

        public void initChannel(SocketChannel socket) {
            ChannelPipeline pipeline = socket.pipeline();
            if (Server.this.isSslEnabled()) {
                pipeline.addLast("ssl-handler", (ChannelHandler)Server.this.sslHandlerProvider.sslHandlerForChannel(socket));
            }
            pipeline.addLast(this.idleExecutorGroup, "idlestate-handler", (ChannelHandler)new IdleStateHandler(this.localClientInactivityTimeoutSeconds, 5, this.localClientInactivityTimeoutSeconds));
            pipeline.addLast("beats-acker", (ChannelHandler)new AckEncoder());
            pipeline.addLast("connection-handler", (ChannelHandler)new ConnectionHandler());
            pipeline.addLast(this.beatsHandlerExecutorGroup, new ChannelHandler[]{new BeatsParser(), new BeatsHandler(this.localMessageListener)});
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            logger.warn("Exception caught in channel initializer", cause);
            try {
                this.localMessageListener.onChannelInitializeException(ctx, cause);
            }
            finally {
                super.exceptionCaught(ctx, cause);
            }
        }

        public void shutdownEventExecutor() {
            try {
                this.idleExecutorGroup.shutdownGracefully().sync();
                this.beatsHandlerExecutorGroup.shutdownGracefully().sync();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

