/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.importer.tasks;

import generic.stl.Pair;
import ghidra.app.services.ProgramManager;
import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.ProjectDataUtils;
import ghidra.framework.store.local.LocalFileSystem;
import ghidra.plugin.importer.ImporterUtilities;
import ghidra.plugin.importer.ProgramMappingService;
import ghidra.plugins.importer.batch.BatchGroup;
import ghidra.plugins.importer.batch.BatchGroupLoadSpec;
import ghidra.plugins.importer.batch.BatchInfo;
import ghidra.program.model.listing.Program;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class ImportBatchTask
extends Task {
    public static final int MAX_PROGRAMS_TO_OPEN = 50;
    private BatchInfo batchInfo;
    private DomainFolder destFolder;
    private boolean stripLeadingPath = true;
    private boolean stripAllContainerPath = false;
    private ProgramManager programManager;
    private int totalObjsImported;
    private int totalAppsImported;
    private int totalEnabledApps;

    public ImportBatchTask(BatchInfo batchInfo, DomainFolder destFolder, ProgramManager programManager, boolean stripLeading, boolean stripAllContainerPath) {
        super("Batch Import Task", true, true, false, false);
        this.batchInfo = batchInfo;
        this.destFolder = destFolder;
        this.totalEnabledApps = batchInfo.getEnabledCount();
        this.programManager = programManager;
        this.stripLeadingPath = stripLeading;
        this.stripAllContainerPath = stripAllContainerPath;
    }

    public void run(TaskMonitor monitor) {
        try {
            this.doBatchImport(monitor);
        }
        catch (CancelledException e) {
            Msg.debug((Object)((Object)this), (Object)"Batch import cancelled");
        }
        catch (IOException ce) {
            Msg.error((Object)((Object)this), (Object)"Error during batch import: ", (Throwable)ce);
        }
        finally {
            Msg.showInfo((Object)((Object)this), null, (String)"Batch Import Summary", (Object)("Batch Import finished.\nImported " + this.totalObjsImported + " files."));
        }
    }

    private void doBatchImport(TaskMonitor monitor) throws CancelledException, IOException {
        Msg.info((Object)((Object)this), (Object)("Starting batch import of " + this.totalEnabledApps + " programs into " + this.destFolder));
        for (BatchGroup batchGroup : this.batchInfo.getGroups()) {
            if (!batchGroup.isEnabled()) continue;
            if (monitor.isCancelled()) {
                Msg.info((Object)((Object)this), (Object)"Stopping batch import due to cancel");
                break;
            }
            this.doImportBatchGroup(batchGroup, monitor);
        }
    }

    private void doImportBatchGroup(BatchGroup batchGroup, TaskMonitor monitor) throws CancelledException, IOException {
        BatchGroupLoadSpec selectedBatchGroupLoadSpec = batchGroup.getSelectedBatchGroupLoadSpec();
        for (BatchGroup.BatchLoadConfig loadConfig : batchGroup.getBatchLoadConfig()) {
            if (monitor.isCancelled()) {
                return;
            }
            this.doImportApp(loadConfig, selectedBatchGroupLoadSpec, monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doImportApp(BatchGroup.BatchLoadConfig batchLoadConfig, BatchGroupLoadSpec selectedBatchGroupLoadSpec, TaskMonitor monitor) throws CancelledException, IOException {
        try (ByteProvider byteProvider = FileSystemService.getInstance().getByteProvider(batchLoadConfig.getFSRL(), monitor);){
            LoadSpec loadSpec = batchLoadConfig.getLoadSpec(selectedBatchGroupLoadSpec);
            if (loadSpec == null) {
                Msg.error((Object)((Object)this), (Object)("Failed to get load spec from application that matches choosen batch load spec " + selectedBatchGroupLoadSpec));
                return;
            }
            Pair<DomainFolder, String> destInfo = this.getDestinationInfo(batchLoadConfig, this.destFolder);
            Object consumer = new Object();
            try {
                MessageLog messageLog = new MessageLog();
                List<DomainObject> importedObjects = loadSpec.getLoader().load(byteProvider, this.fixupProjectFilename((String)destInfo.second), (DomainFolder)destInfo.first, loadSpec, this.getOptionsFor(batchLoadConfig, loadSpec, byteProvider), messageLog, consumer, monitor);
                if (importedObjects != null) {
                    try {
                        this.processImportResults(importedObjects, batchLoadConfig, monitor);
                    }
                    finally {
                        this.releaseAll(importedObjects, consumer);
                    }
                }
                ++this.totalAppsImported;
                Msg.info((Object)((Object)this), (Object)("Imported " + destInfo.first + "/ " + (String)destInfo.second + ", " + this.totalAppsImported + " of " + this.totalEnabledApps));
                if (messageLog.getMsgCount() > 0) {
                    Msg.info((Object)((Object)this), (Object)("Additional info:\n" + messageLog.toString()));
                }
            }
            catch (CancelledException e) {
                Msg.debug((Object)((Object)this), (Object)"Batch Import cancelled");
            }
            catch (InvalidNameException | DuplicateNameException | VersionException | IOException e) {
                Msg.error((Object)((Object)this), (Object)("Import failed for " + batchLoadConfig.getPreferredFileName()), (Throwable)e);
            }
        }
    }

    private String fixupProjectFilename(String filename) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < filename.length(); ++i) {
            char ch = filename.charAt(i);
            sb.append(LocalFileSystem.isValidNameCharacter((char)ch) ? ch : (char)'_');
        }
        return sb.toString();
    }

    private void releaseAll(List<DomainObject> importedObjects, Object consumer) {
        for (DomainObject obj : importedObjects) {
            if (!obj.isUsedBy(consumer)) continue;
            obj.release(consumer);
        }
    }

    private void processImportResults(List<DomainObject> importedObjects, BatchGroup.BatchLoadConfig appInfo, TaskMonitor monitor) throws CancelledException, IOException {
        for (DomainObject obj : importedObjects) {
            if (obj instanceof Program) {
                Program program = (Program)obj;
                ImporterUtilities.setProgramProperties(program, appInfo.getFSRL(), monitor);
                if (this.programManager != null && this.totalObjsImported < 50) {
                    this.programManager.openProgram(program, this.totalObjsImported == 0 ? 1 : 2);
                }
                ProgramMappingService.createAssociation(appInfo.getFSRL(), program);
            }
            ++this.totalObjsImported;
        }
    }

    static String fsrlToPath(FSRL fsrl, FSRL userSrc, boolean stripLeadingPath, boolean stripInteriorContainerPath) {
        String fullPath = fsrl.toPrettyFullpathString().replace('|', '/');
        String userSrcPath = userSrc.toPrettyFullpathString().replace('|', '/');
        int filename = fullPath.lastIndexOf(47) + 1;
        int uas = userSrcPath.length();
        int container = uas + 1;
        int leadStart = !stripLeadingPath ? 0 : userSrcPath.lastIndexOf(47) + 1;
        int leadEnd = Math.min(filename, userSrcPath.length());
        String leading = leadStart < filename ? fullPath.substring(leadStart, leadEnd) : "";
        String containerPath = container < filename && !stripInteriorContainerPath ? fullPath.substring(container, filename) : "";
        String filenameStr = fullPath.substring(filename);
        String result = FSUtilities.appendPath(leading, containerPath, filenameStr);
        return result;
    }

    private Pair<DomainFolder, String> getDestinationInfo(BatchGroup.BatchLoadConfig batchLoadConfig, DomainFolder rootDestinationFolder) {
        String parentDir;
        FSRL fsrl = batchLoadConfig.getFSRL();
        String pathStr = ImportBatchTask.fsrlToPath(fsrl, batchLoadConfig.getUasi().getFSRL(), this.stripLeadingPath, this.stripAllContainerPath);
        String preferredName = batchLoadConfig.getPreferredFileName();
        String fsrlFilename = fsrl.getName();
        if (!fsrlFilename.equals(preferredName)) {
            pathStr = FSUtilities.appendPath(pathStr, preferredName);
        }
        if ((parentDir = FilenameUtils.getFullPathNoEndSeparator((String)(pathStr = pathStr.replaceAll("[\\\\:|]+", "/")))) == null) {
            parentDir = "";
        }
        String destFilename = FilenameUtils.getName((String)pathStr);
        try {
            DomainFolder batchDestFolder = ProjectDataUtils.createDomainFolderPath((DomainFolder)rootDestinationFolder, (String)parentDir);
            return new Pair((Object)batchDestFolder, (Object)destFilename);
        }
        catch (InvalidNameException | IOException e) {
            Msg.error((Object)((Object)this), (Object)("Problem creating project folder root: " + rootDestinationFolder.getPathname() + ", subpath: " + parentDir), (Throwable)e);
            return new Pair((Object)rootDestinationFolder, (Object)fsrlFilename);
        }
    }

    private List<Option> getOptionsFor(BatchGroup.BatchLoadConfig batchLoadConfig, LoadSpec loadSpec, ByteProvider byteProvider) {
        List<Option> options = batchLoadConfig.getLoader().getDefaultOptions(byteProvider, loadSpec, null, false);
        return options;
    }
}

