/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.streams;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.CliStreamHeader;
import ghidra.app.util.bin.format.pe.cli.blobs.CliBlob;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamBlob;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class CliStreamUserStrings
extends CliStreamBlob {
    public static String getName() {
        return "#US";
    }

    public CliStreamUserStrings(CliStreamHeader header, long fileOffset, int rva, BinaryReader reader) throws IOException {
        super(header, fileOffset, rva, reader);
    }

    public String getUserString(int index) {
        byte[] bytes = ((CliBlob)this.blobMap.get(index)).getContents();
        return new String(bytes, 0, bytes.length - 1, StandardCharsets.UTF_16);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(new CategoryPath("/PE/CLI/Streams"), this.header.getName(), 0);
        struct.add(BYTE, "Reserved", "Always 0");
        for (Map.Entry entry : this.blobMap.entrySet()) {
            int index = (Integer)entry.getKey();
            CliBlob blob = (CliBlob)entry.getValue();
            struct.add(blob.getSizeDataType(), "Next string size", null);
            if (blob.getContentsSize() <= 0) continue;
            if (blob.getContentsSize() - 1 > 0) {
                struct.add(UTF16, blob.getContentsSize() - 1, "[" + Integer.toHexString(index) + "]", null);
            }
            struct.add(BYTE, "Extra byte", "0x01 if string contains non-ASCII");
        }
        return struct;
    }
}

