/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.exceptionhandlers.gcc.structures.ehFrame;

import ghidra.app.cmd.comments.SetCommentCmd;
import ghidra.app.cmd.data.CreateArrayCmd;
import ghidra.app.plugin.exceptionhandlers.gcc.DwarfDecodeContext;
import ghidra.app.plugin.exceptionhandlers.gcc.DwarfDecoderFactory;
import ghidra.app.plugin.exceptionhandlers.gcc.DwarfEHDecoder;
import ghidra.app.plugin.exceptionhandlers.gcc.GccAnalysisClass;
import ghidra.app.plugin.exceptionhandlers.gcc.GccAnalysisUtils;
import ghidra.app.plugin.exceptionhandlers.gcc.datatype.DwarfEncodingModeDataType;
import ghidra.app.plugin.exceptionhandlers.gcc.datatype.SignedLeb128DataType;
import ghidra.app.plugin.exceptionhandlers.gcc.datatype.UnsignedLeb128DataType;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.ehFrame.ExceptionHandlerFrameException;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.QWordDataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Cie
extends GccAnalysisClass {
    private static final int DWORD_LEN = new DWordDataType().getLength();
    private static final int QWORD_LEN = new QWordDataType().getLength();
    private static final int BYTE_LEN = new ByteDataType().getLength();
    private final boolean isInDebugFrame;
    private boolean endOfFrame = false;
    private byte[] enc_length;
    private int intLength;
    private byte[] enc_extLength;
    private boolean hasExtLength;
    private byte[] enc_cieId;
    private int cieId;
    private byte version;
    private String augmentationString;
    private int segmentSize;
    private int codeAlignFactor;
    private int dataAlignFactor;
    private int returnAddrRegister;
    private int augmentationDataLength;
    private byte[] augmentationData;
    private byte[] initialInstructions;
    private int curSize;
    private Address baseAddress;
    private Address nextAddress;
    private int fdeEncoding = 0;
    private int lsdaEncoding = 0;
    private int personalityFuncAddrEncoding = 0;
    private Address personalityFuncAddr = null;
    private int initialInstructionCount;

    public Cie(TaskMonitor monitor, Program program) {
        this(monitor, program, false);
    }

    public Cie(TaskMonitor monitor, Program program, boolean isInDebugFrame) {
        super(monitor, program);
        this.isInDebugFrame = isInDebugFrame;
        this.enc_length = new byte[4];
        this.enc_extLength = new byte[8];
        this.hasExtLength = false;
        this.enc_cieId = new byte[4];
        this.curSize = 0;
        super.init(program);
    }

    public boolean isInDebugFrame() {
        return this.isInDebugFrame;
    }

    private Address processCieLength(Address addr) throws MemoryAccessException {
        String comment = "(CIE) Length";
        Cie.createAndCommentData(this.program, addr, (DataType)this.dwordDT, comment, 0);
        this.program.getMemory().getBytes(addr, this.enc_length);
        this.curSize += DWORD_LEN;
        this.intLength = this.getIntegerLength();
        return addr.add((long)DWORD_LEN);
    }

    private Address processCieId(Address addr) throws MemoryAccessException {
        String comment = "(CIE) ID";
        Cie.createAndCommentData(this.program, addr, (DataType)this.dwordDT, comment, 0);
        this.program.getMemory().getBytes(addr, this.enc_cieId);
        this.cieId = (int)GccAnalysisUtils.readDWord(this.program, addr);
        this.curSize = DWORD_LEN;
        return addr.add((long)DWORD_LEN);
    }

    private Address processVersion(Address addr) throws MemoryAccessException {
        String comment = "(CIE) Version";
        Cie.createAndCommentData(this.program, addr, (DataType)new ByteDataType(), comment, 0);
        this.version = GccAnalysisUtils.readByte(this.program, addr);
        this.curSize += BYTE_LEN;
        return addr.add((long)BYTE_LEN);
    }

    private Address processAugmentationString(Address addr) throws ExceptionHandlerFrameException {
        String comment = "(CIE) Augmentation String";
        Cie.createAndCommentData(this.program, addr, (DataType)new StringDataType(), comment, 0);
        Data dataAt = this.program.getListing().getDataAt(addr);
        if (dataAt == null) {
            throw new ExceptionHandlerFrameException("Couldn't process augmentation string @ " + addr + ".");
        }
        this.augmentationString = (String)dataAt.getValue();
        this.curSize += this.augmentationString.length() + 1;
        return addr.add((long)(this.augmentationString.length() + 1));
    }

    private Address processPointerSize(Address addr) throws MemoryAccessException {
        String comment = "(CIE) Pointer Size";
        Cie.createAndCommentData(this.program, addr, (DataType)new ByteDataType(), comment, 0);
        this.ptrSize = GccAnalysisUtils.readByte(this.program, addr);
        this.curSize += BYTE_LEN;
        return addr.add((long)BYTE_LEN);
    }

    private Address processSegmentSize(Address addr) throws MemoryAccessException {
        String comment = "(CIE) Segment Size";
        Cie.createAndCommentData(this.program, addr, (DataType)new ByteDataType(), comment, 0);
        this.segmentSize = GccAnalysisUtils.readByte(this.program, addr);
        this.curSize += BYTE_LEN;
        return addr.add((long)BYTE_LEN);
    }

    private Address processCodeAlign(Address addr) throws MemoryAccessException {
        String comment = "(CIE) Code Alignment";
        UnsignedLeb128DataType uleb = UnsignedLeb128DataType.dataType;
        DumbMemBufferImpl buf = new DumbMemBufferImpl(this.program.getMemory(), addr);
        int encodedLen = uleb.getLength((MemBuffer)buf, 8);
        Object augLenObj = uleb.getValue((MemBuffer)buf, uleb.getDefaultSettings(), encodedLen);
        this.codeAlignFactor = (int)((Scalar)augLenObj).getUnsignedValue();
        Cie.createAndCommentData(this.program, addr, (DataType)uleb, comment, 0);
        this.curSize += encodedLen;
        return addr.add((long)encodedLen);
    }

    private Address processDataAlign(Address addr) throws MemoryAccessException {
        String comment = "(CIE) Data Alignment";
        SignedLeb128DataType sleb = SignedLeb128DataType.dataType;
        DumbMemBufferImpl buf = new DumbMemBufferImpl(this.program.getMemory(), addr);
        int encodedLen = sleb.getLength((MemBuffer)buf, -1);
        Object alignObj = sleb.getValue((MemBuffer)buf, sleb.getDefaultSettings(), encodedLen);
        this.dataAlignFactor = (int)((Scalar)alignObj).getSignedValue();
        Cie.createAndCommentData(this.program, addr, (DataType)sleb, comment, 0);
        this.curSize += encodedLen;
        return addr.add((long)encodedLen);
    }

    private Address processReturnAddrRegister(Address addr) throws MemoryAccessException {
        String comment = "(CIE) Return Address Register Column";
        int encodedLen = 0;
        UnsignedLeb128DataType encodedDt = null;
        if (this.version == 1) {
            this.returnAddrRegister = GccAnalysisUtils.readByte(this.program, addr);
            encodedDt = new ByteDataType();
            encodedLen = BYTE_LEN;
        } else {
            UnsignedLeb128DataType uleb;
            encodedDt = uleb = UnsignedLeb128DataType.dataType;
            DumbMemBufferImpl buf = new DumbMemBufferImpl(this.program.getMemory(), addr);
            encodedLen = uleb.getLength((MemBuffer)buf, 8);
            Object augLenObj = uleb.getValue((MemBuffer)buf, uleb.getDefaultSettings(), encodedLen);
            this.returnAddrRegister = (int)((Scalar)augLenObj).getUnsignedValue();
        }
        Cie.createAndCommentData(this.program, addr, (DataType)encodedDt, comment, 0);
        this.curSize += encodedLen;
        return addr.add((long)encodedLen);
    }

    private Address processAugmentationDataLength(Address addr) throws MemoryAccessException {
        String comment = "(CIE) Augmentation Data Length";
        UnsignedLeb128DataType uleb = UnsignedLeb128DataType.dataType;
        DumbMemBufferImpl buf = new DumbMemBufferImpl(this.program.getMemory(), addr);
        int encodedLen = uleb.getLength((MemBuffer)buf, 8);
        Object augLenObj = uleb.getValue((MemBuffer)buf, uleb.getDefaultSettings(), encodedLen);
        this.augmentationDataLength = (int)((Scalar)augLenObj).getUnsignedValue();
        Cie.createAndCommentData(this.program, addr, (DataType)uleb, comment, 0);
        this.curSize += encodedLen;
        return addr.add((long)encodedLen);
    }

    private Address grabAugmentationData(Address addr) throws MemoryAccessException {
        this.augmentationData = new byte[this.augmentationDataLength];
        int numBytesRead = this.program.getMemory().getBytes(addr, this.augmentationData);
        this.curSize += numBytesRead;
        return addr.add((long)numBytesRead);
    }

    private Address processInitialInstructions(Address addr) throws MemoryAccessException {
        CreateArrayCmd arrayCmd = null;
        this.initialInstructionCount = this.intLength - this.curSize;
        arrayCmd = new CreateArrayCmd(addr, this.initialInstructionCount, (DataType)new ByteDataType(), BYTE_LEN);
        arrayCmd.applyTo((DomainObject)this.program);
        SetCommentCmd.createComment(this.program, addr, "(CIE) Initial Instructions", 0);
        this.initialInstructions = new byte[this.initialInstructionCount];
        int numBytesRead = this.program.getMemory().getBytes(addr, this.initialInstructions);
        this.curSize += numBytesRead;
        try {
            return addr.add((long)numBytesRead);
        }
        catch (AddressOutOfBoundsException e) {
            return null;
        }
    }

    public void create(Address cieAddress) throws MemoryAccessException, ExceptionHandlerFrameException {
        if (cieAddress == null || this.monitor.isCancelled()) {
            return;
        }
        this.baseAddress = cieAddress;
        this.monitor.setMessage("Creating Common Information Entries");
        Address currentAddress = cieAddress;
        if (this.program.getMemory().getInt(currentAddress) == 0) {
            this.markEndOfFrame(currentAddress);
            this.endOfFrame = true;
            return;
        }
        currentAddress = this.processCieLength(currentAddress);
        currentAddress = this.processExtendedLength(currentAddress);
        currentAddress = this.processCieId(currentAddress);
        currentAddress = this.processVersion(currentAddress);
        currentAddress = this.processAugmentationString(currentAddress);
        if (this.version >= 4) {
            currentAddress = this.processPointerSize(currentAddress);
            currentAddress = this.processSegmentSize(currentAddress);
        }
        currentAddress = this.processCodeAlign(currentAddress);
        currentAddress = this.processDataAlign(currentAddress);
        currentAddress = this.processReturnAddrRegister(currentAddress);
        if (this.isInDebugFrame) {
            this.fdeEncoding = 0;
        } else {
            currentAddress = this.processAugmentationInfo(currentAddress);
        }
        if (!this.hasExtLength) {
            if (this.curSize < this.intLength) {
                currentAddress = this.processInitialInstructions(currentAddress);
            }
        } else {
            throw new ExceptionHandlerFrameException("ExtLength is not completely implemented.");
        }
        this.nextAddress = currentAddress;
    }

    private void markEndOfFrame(Address addr) {
        Cie.createAndCommentData(this.program, addr, (DataType)this.dwordDT, "End of Frame", 0);
        SetCommentCmd commentCmd = new SetCommentCmd(addr, 3, "END OF FRAME");
        commentCmd.applyTo((DomainObject)this.program);
    }

    private int getIntegerLength() {
        ByteBuffer bb = ByteBuffer.wrap(this.enc_length);
        if (this.program.getMemory().isBigEndian()) {
            bb.order(ByteOrder.BIG_ENDIAN);
        } else {
            bb.order(ByteOrder.LITTLE_ENDIAN);
        }
        return bb.getInt();
    }

    private Address processExtendedLength(Address addr) throws MemoryAccessException {
        if (this.intLength == -1) {
            this.hasExtLength = true;
            String comment = "(CIE) Extended Length";
            Cie.createAndCommentData(this.program, addr, (DataType)new QWordDataType(), comment, 0);
            this.program.getMemory().getBytes(addr, this.enc_extLength);
            addr = addr.add((long)QWORD_LEN);
            this.curSize += QWORD_LEN;
        }
        return addr;
    }

    private Address processAugmentationInfo(Address addr) throws MemoryAccessException {
        if (this.augmentationString != null && this.augmentationString.length() > 0 && this.augmentationString.charAt(0) == 'z') {
            Address augmentationDataAddr = addr = this.processAugmentationDataLength(addr);
            addr = this.grabAugmentationData(addr);
            int augmentationDataIndex = 0;
            block6: for (int idx = 1; idx < this.augmentationString.length() && augmentationDataIndex < this.augmentationData.length; ++idx) {
                int augData = this.augmentationData[augmentationDataIndex] & 0xFF;
                char ch = this.augmentationString.charAt(idx);
                switch (ch) {
                    case 'L': {
                        this.processLsdaEncoding(augmentationDataAddr, augmentationDataIndex, augData);
                        ++augmentationDataIndex;
                        continue block6;
                    }
                    case 'R': {
                        this.processFdeEncoding(augmentationDataAddr, augmentationDataIndex, augData);
                        ++augmentationDataIndex;
                        continue block6;
                    }
                    case 'S': {
                        Msg.debug((Object)this, (Object)"stack frame..");
                        continue block6;
                    }
                    case 'P': {
                        DwarfEHDecoder personalityDecoder = this.processPersonalityEncoding(augmentationDataAddr, augmentationDataIndex, augData);
                        DwarfDecodeContext personalityDecodeContext = this.processPersonalityFunctionPointer(augmentationDataAddr, ++augmentationDataIndex, personalityDecoder);
                        augmentationDataIndex += personalityDecodeContext.getEncodedLength();
                    }
                }
            }
        }
        return addr;
    }

    private void processLsdaEncoding(Address augmentationDataAddr, int augmentationDataIndex, int augData) {
        this.lsdaEncoding = augData;
        String lsdaComment = "(CIE Augmentation Data) LSDA Personality Function Pointer Encoding";
        Cie.createAndCommentData(this.program, augmentationDataAddr.add((long)augmentationDataIndex), (DataType)new DwarfEncodingModeDataType(), lsdaComment, 0);
    }

    private void processFdeEncoding(Address augmentationDataAddr, int augmentationDataIndex, int augData) {
        this.fdeEncoding = augData;
        Cie.createAndCommentData(this.program, augmentationDataAddr.add((long)augmentationDataIndex), (DataType)new DwarfEncodingModeDataType(), "(CIE Augmentation Data) FDE Encoding", 0);
    }

    private DwarfEHDecoder processPersonalityEncoding(Address augmentationDataAddr, int augmentationDataIndex, int augData) {
        this.personalityFuncAddrEncoding = augData;
        DwarfEHDecoder personalityDecoder = DwarfDecoderFactory.getDecoder(this.personalityFuncAddrEncoding);
        String prsnltyComment = "(CIE Augmentation Data) Personality Function Pointer Encoding";
        Cie.createAndCommentData(this.program, augmentationDataAddr.add((long)augmentationDataIndex), (DataType)new DwarfEncodingModeDataType(), prsnltyComment, 0);
        return personalityDecoder;
    }

    private DwarfDecodeContext processPersonalityFunctionPointer(Address augmentationDataAddr, int augmentationDataIndex, DwarfEHDecoder personalityDecoder) throws MemoryAccessException {
        DwarfDecodeContext personalityDecodeContext = new DwarfDecodeContext(this.program, augmentationDataAddr.add((long)augmentationDataIndex));
        this.personalityFuncAddr = personalityDecoder.decodeAddress(personalityDecodeContext);
        DataType prnsFuncPtrDt = personalityDecoder.getDataType(this.program);
        Cie.createAndCommentData(this.program, augmentationDataAddr.add((long)augmentationDataIndex), prnsFuncPtrDt, "(CIE Augmentation Data) Personality Function Pointer (" + this.personalityFuncAddr + ")", 0);
        this.program.getReferenceManager().addMemoryReference(augmentationDataAddr.add((long)augmentationDataIndex), this.personalityFuncAddr, RefType.DATA, SourceType.ANALYSIS, 0);
        return personalityDecodeContext;
    }

    public Address getNextAddress() {
        return this.nextAddress;
    }

    public String getAugmentationString() {
        return this.augmentationString;
    }

    public int getFDEEncoding() {
        return this.fdeEncoding;
    }

    public DwarfEHDecoder getFDEDecoder() {
        return DwarfDecoderFactory.getDecoder(this.getFDEEncoding());
    }

    public int getLSDAEncoding() {
        return this.lsdaEncoding;
    }

    public DwarfEHDecoder getLSDADecoder() {
        return DwarfDecoderFactory.getDecoder(this.getLSDAEncoding());
    }

    public Address getAddress() {
        return this.baseAddress;
    }

    public int getDataAlignment() {
        return this.dataAlignFactor;
    }

    public int getCodeAlignment() {
        return this.codeAlignFactor;
    }

    public boolean isEndOfFrame() {
        return this.endOfFrame;
    }

    public int getSegmentSize() {
        return this.segmentSize;
    }

    public int getReturnAddressRegisterColumn() {
        return this.returnAddrRegister;
    }

    public int getCieId() {
        return this.cieId;
    }
}

