/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation;

import ghidra.app.util.viewer.field.FieldStringInfo;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import java.util.ArrayList;

public class FunctionUtils {
    public static FieldStringInfo getFunctionReturnTypeStringInfo(Function function, String functionSignatureString) {
        DataType returnType = function.getReturnType();
        return new FieldStringInfo(functionSignatureString, returnType.getName(), 0);
    }

    public static FieldStringInfo getFunctionNameStringInfo(Function function, String functionSignatureString) {
        String functionName = function.getName(true);
        int offset = functionSignatureString.indexOf(functionName);
        if (offset == -1) {
            functionName = function.getName();
            offset = functionSignatureString.indexOf(functionName);
        }
        return new FieldStringInfo(functionSignatureString, functionName, offset);
    }

    public static int getCallingConventionSignatureOffset(Function function) {
        PrototypeModel callingConvention = function.getCallingConvention();
        if (callingConvention == null) {
            return 0;
        }
        String callingConventionName = callingConvention.getName();
        if (callingConventionName == null) {
            return 0;
        }
        if (callingConventionName.equals("unknown")) {
            return 0;
        }
        return callingConventionName.length() + 1;
    }

    public static FieldStringInfo[] getFunctionParameterStringInfos(Function function, String functionSignatureString) {
        Parameter[] arguments = function.getParameters();
        int startIndex = functionSignatureString.indexOf(40) + 1;
        ArrayList<FieldStringInfo> list = new ArrayList<FieldStringInfo>();
        for (Parameter parameter : arguments) {
            String dataTypeName = parameter.getDataType().getDisplayName();
            String parameterName = parameter.getName();
            startIndex = functionSignatureString.indexOf(dataTypeName, startIndex);
            list.add(new FieldStringInfo(functionSignatureString, dataTypeName + " " + parameterName, startIndex));
            startIndex = functionSignatureString.indexOf(parameterName, startIndex) + parameterName.length();
        }
        return list.toArray(new FieldStringInfo[list.size()]);
    }
}

