/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.timer;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.rzo.yacron4j.Scheduler;
import org.rzo.yacron4j.SchedulerOptions;
import org.rzo.yajsw.config.YajswConfigurationImpl;
import org.rzo.yajsw.timer.Job;
import org.rzo.yajsw.timer.RestartJob;
import org.rzo.yajsw.timer.StartJob;
import org.rzo.yajsw.timer.StopJob;
import org.rzo.yajsw.timer.Timer;
import org.rzo.yajsw.wrapper.WrappedProcess;

public class TimerImpl
implements Timer {
    private static final int REPEAT_INDEFINITELY = -1;
    YajswConfigurationImpl _config;
    WrappedProcess _wp;
    Scheduler _cronScheduler;
    ScheduledExecutorService _simpleScheduler;
    MyCronTrigger _cronStart;
    MyCronTrigger _cronStop;
    MyCronTrigger _cronRestart;
    MySimpleTrigger _simpleStart;
    MySimpleTrigger _simpleStop;
    MySimpleTrigger _simpleRestart;
    boolean _hasTrigger = false;
    boolean _startImmediate = true;
    boolean _triggered = false;
    static int tcount = 0;

    public TimerImpl(YajswConfigurationImpl config, WrappedProcess wp) {
        this._config = config;
        this._wp = wp;
    }

    @Override
    public synchronized void init() {
        Iterator keys = this._config.getKeys("wrapper.timer");
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (key.contains(".simple.")) {
                if (key.contains(".START.")) {
                    if (this._simpleStart != null) continue;
                    this._simpleStart = this.getSimpleTrigger(key);
                    continue;
                }
                if (key.contains(".STOP.")) {
                    if (this._simpleStop != null) continue;
                    this._simpleStop = this.getSimpleTrigger(key);
                    continue;
                }
                if (key.contains(".RESTART.")) {
                    if (this._simpleRestart != null) continue;
                    this._simpleRestart = this.getSimpleTrigger(key);
                    continue;
                }
                System.out.println("Cannot interpret timer property: " + key);
                continue;
            }
            if (key.contains(".cron.")) {
                if (key.contains(".START")) {
                    this._cronStart = this.getCronTrigger(key);
                    continue;
                }
                if (key.contains(".STOP")) {
                    this._cronStop = this.getCronTrigger(key);
                    continue;
                }
                if (key.contains(".RESTART")) {
                    this._cronRestart = this.getCronTrigger(key);
                    continue;
                }
                System.out.println("Cannot interpret timer property: " + key);
                continue;
            }
            System.out.println("Cannot interpret timer property: " + key);
        }
    }

    private MySimpleTrigger getSimpleTrigger(String key) {
        MySimpleTrigger trigger;
        Job jobDetail = this.getJobDetail(key);
        if (jobDetail == null) {
            return null;
        }
        Date startTime = this.getStartTime(key);
        int repeatCount = this.getRepeatCount(key);
        int interval = this.getInterval(key);
        try {
            trigger = new MySimpleTrigger(jobDetail, startTime, repeatCount, interval);
        }
        catch (Exception ex) {
            return null;
        }
        this._hasTrigger = true;
        this._startImmediate = false;
        jobDetail.setTrigger(trigger);
        return trigger;
    }

    private int getInterval(String key) {
        int x = this._config.getInt(key.substring(0, key.lastIndexOf(".")) + ".INTERVAL", -1);
        if (x > 0) {
            x *= 1000;
        }
        return x;
    }

    private int getRepeatCount(String key) {
        return this._config.getInt(key.substring(0, key.lastIndexOf(".")) + ".COUNT", -1);
    }

    private Date getStartTime(String key) {
        String str = this._config.getString(key.substring(0, key.lastIndexOf(".")) + ".FIRST");
        if (str == null) {
            return new Date();
        }
        SimpleDateFormat df = null;
        df = str.contains(" ") ? new SimpleDateFormat("dd.MM.yyyy HH:mm:ss") : new SimpleDateFormat("HH:mm:ss");
        try {
            return df.parse(str);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Job getJobDetail(String key) {
        if (key.contains(".RESTART")) {
            return new RestartJob(this._wp);
        }
        if (key.contains(".STOP")) {
            return new StopJob(this._wp);
        }
        if (key.contains(".START")) {
            return new StartJob(this._wp);
        }
        return null;
    }

    private MyCronTrigger getCronTrigger(String key) {
        Job job = this.getJobDetail(key);
        if (job == null) {
            return null;
        }
        String cronExpression = this.getCronExpression(key);
        if (cronExpression != null) {
            MyCronTrigger trigger = new MyCronTrigger(cronExpression, job);
            if (job instanceof StartJob) {
                this._startImmediate = false;
            }
            this._hasTrigger = true;
            return trigger;
        }
        return null;
    }

    private String getCronExpression(String key) {
        String str = this._config.getString(key);
        if (str == null) {
            return null;
        }
        return str;
    }

    @Override
    public synchronized void start() {
        if (!this._hasTrigger) {
            return;
        }
        if (this._cronStart != null) {
            this.startTrigger(this._cronStart, this._cronStart.getJobDetail());
        }
        if (this._cronStop != null) {
            this.startTrigger(this._cronStop, this._cronStop.getJobDetail());
        }
        if (this._cronRestart != null) {
            this.startTrigger(this._cronRestart, this._cronRestart.getJobDetail());
        }
        if (this._simpleStart != null) {
            this.startTrigger(this._simpleStart, this._simpleStart.getJobDetail());
        }
        if (this._simpleStop != null) {
            this.startTrigger(this._simpleStop, this._simpleStop.getJobDetail());
        }
        if (this._simpleRestart != null) {
            this.startTrigger(this._simpleRestart, this._simpleRestart.getJobDetail());
        }
        this._triggered = true;
    }

    private ScheduledExecutorService getSimpleScheduler() {
        if (this._simpleScheduler == null) {
            this._simpleScheduler = Executors.newSingleThreadScheduledExecutor();
        }
        return this._simpleScheduler;
    }

    private void startTrigger(Trigger trigger, Job jobDetail) {
        if (trigger == null || jobDetail == null) {
            return;
        }
        if (trigger instanceof MyCronTrigger) {
            try {
                this.getCronScheduler().schedule((Runnable)jobDetail, ((MyCronTrigger)trigger)._cronExpression);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            MySimpleTrigger simpleTrigger = (MySimpleTrigger)trigger;
            ScheduledExecutorService scheduler = this.getSimpleScheduler();
            long initialDelay = 0L;
            if (simpleTrigger._startTime != null && (initialDelay = simpleTrigger._startTime.getTime() - System.currentTimeMillis()) < 0L) {
                initialDelay = 0L;
            }
            if (simpleTrigger._interval > 0) {
                ScheduledFuture<?> future = scheduler.scheduleWithFixedDelay(jobDetail, initialDelay, simpleTrigger._interval, TimeUnit.MILLISECONDS);
                jobDetail.setFuture(future);
            } else {
                ScheduledFuture<?> future = scheduler.schedule(jobDetail, initialDelay, TimeUnit.MILLISECONDS);
                jobDetail.setFuture(future);
            }
        }
    }

    private Scheduler getCronScheduler() {
        if (this._cronScheduler == null) {
            try {
                SchedulerOptions options = new SchedulerOptions();
                options.setDebug(this._config.getBoolean("wrapper.debug", false));
                options.setMaxThreads(1);
                options.setThreadFactory(new ThreadFactory(){

                    @Override
                    public Thread newThread(Runnable r) {
                        Thread result = new Thread(r);
                        result.setDaemon(true);
                        result.setName("yajsw-timer-" + tcount++);
                        return result;
                    }
                });
                this._cronScheduler = new Scheduler(options);
            }
            catch (Exception e) {
                e.printStackTrace();
                this._cronScheduler = null;
            }
        }
        return this._cronScheduler;
    }

    @Override
    public void stop() {
        if (!this._hasTrigger) {
            return;
        }
        this.stopTrigger(this._cronStart);
        this.stopTrigger(this._cronStop);
        this.stopTrigger(this._cronRestart);
        this.stopTrigger(this._simpleStart);
        this.stopTrigger(this._simpleStop);
        this.stopTrigger(this._simpleRestart);
    }

    private synchronized void stopTrigger(Trigger trigger) {
        try {
            this._cronScheduler.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this._triggered = false;
    }

    @Override
    public boolean isTriggered() {
        return this._triggered;
    }

    @Override
    public boolean isStartImmediate() {
        return this._startImmediate;
    }

    @Override
    public boolean isHasTrigger() {
        return this._hasTrigger;
    }

    class MySimpleTrigger
    extends AbstractTrigger {
        Date _startTime;
        int _repeatCount;
        int _interval;

        MySimpleTrigger(Job job, Date startTime, int repeatCount, int interval) {
            super(job);
            if (startTime == null && repeatCount == -1 && interval == -1) {
                throw new RuntimeException("simple trigger configuration error");
            }
            this._startTime = startTime;
            this._repeatCount = repeatCount;
            this._interval = interval;
        }
    }

    class MyCronTrigger
    extends AbstractTrigger {
        String _cronExpression;

        MyCronTrigger(String cronExpression, Job job) {
            super(job);
            this._cronExpression = cronExpression;
        }
    }

    class AbstractTrigger
    implements Trigger {
        final Job _job;

        AbstractTrigger(Job job) {
            this._job = job;
        }

        @Override
        public Job getJobDetail() {
            return this._job;
        }
    }

    static interface Trigger {
        public Runnable getJobDetail();
    }
}

