/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.correlator.address;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.util.AddressCorrelation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.HashMap;
import java.util.Map;

public class StraightLineCorrelation
implements AddressCorrelation {
    public static final String NAME = "StraightLineCorrelation";
    private Map<Address, AddressRange> cachedForwardAddressMap;
    private final Function sourceFunction;
    private final Function destinationFunction;

    public StraightLineCorrelation(Function sourceFunction, Function destinationFunction) {
        this.sourceFunction = sourceFunction;
        this.destinationFunction = destinationFunction;
    }

    public String getName() {
        return NAME;
    }

    public AddressRange getCorrelatedDestinationRange(Address sourceAddress, TaskMonitor monitor) throws CancelledException {
        this.initialize(monitor);
        return this.cachedForwardAddressMap.get(sourceAddress);
    }

    private void initialize(TaskMonitor monitor) throws CancelledException {
        AddressSetView destinationAddressSet;
        if (this.cachedForwardAddressMap != null) {
            return;
        }
        this.cachedForwardAddressMap = new HashMap<Address, AddressRange>();
        AddressSetView sourceAddressSet = this.sourceFunction != null ? this.sourceFunction.getBody() : null;
        AddressSetView addressSetView = destinationAddressSet = this.destinationFunction != null ? this.destinationFunction.getBody() : null;
        if (sourceAddressSet == null || destinationAddressSet == null) {
            return;
        }
        CodeUnitIterator srcIter = this.sourceFunction.getProgram().getListing().getCodeUnits(sourceAddressSet, true);
        CodeUnitIterator destIter = this.destinationFunction.getProgram().getListing().getCodeUnits(destinationAddressSet, true);
        monitor.setMessage("Defining address ranges...");
        monitor.initialize(sourceAddressSet.getNumAddresses());
        while (srcIter.hasNext() && destIter.hasNext()) {
            String destMnemonic;
            CodeUnit srcCodeUnit = srcIter.next();
            CodeUnit destCodeUnit = destIter.next();
            String srcMnemonic = srcCodeUnit.getMnemonicString();
            if (!srcMnemonic.equals(destMnemonic = destCodeUnit.getMnemonicString())) break;
            monitor.checkCanceled();
            monitor.incrementProgress((long)srcCodeUnit.getLength());
            StraightLineCorrelation.defineRange(this.cachedForwardAddressMap, srcCodeUnit, destCodeUnit);
        }
        this.computeParamCorrelation();
    }

    protected void computeParamCorrelation() {
        int sourceCount = this.sourceFunction.getParameterCount();
        int destinationCount = this.destinationFunction.getParameterCount();
        Parameter[] sourceParameters = this.sourceFunction.getParameters();
        Parameter[] destinationParameters = this.destinationFunction.getParameters();
        boolean allMatch = false;
        HashMap<Address, AddressRangeImpl> map = new HashMap<Address, AddressRangeImpl>();
        if (sourceCount == destinationCount) {
            allMatch = true;
            for (int i = 0; i < sourceParameters.length; ++i) {
                Parameter sourceParameter = sourceParameters[i];
                Parameter destinationParameter = destinationParameters[i];
                DataType sourceDataType = sourceParameter.getDataType();
                DataType destinationDataType = destinationParameter.getDataType();
                int sourceLength = sourceDataType.getLength();
                int destinationLength = destinationDataType.getLength();
                Address dest = destinationParameter.getMinAddress();
                map.put(sourceParameter.getMinAddress(), new AddressRangeImpl(dest, dest));
                if (sourceLength == destinationLength) continue;
                allMatch = false;
                break;
            }
        }
        if (allMatch) {
            this.cachedForwardAddressMap.putAll(map);
        }
    }

    private static void defineRange(Map<Address, AddressRange> map, CodeUnit sourceCodeUnit, CodeUnit destinationCodeUnit) {
        Address minAddress = sourceCodeUnit.getMinAddress();
        Address maxAddress = sourceCodeUnit.getMaxAddress();
        AddressRangeImpl toRange = new AddressRangeImpl(destinationCodeUnit.getMinAddress(), destinationCodeUnit.getMaxAddress());
        while (!minAddress.equals((Object)maxAddress)) {
            map.put(minAddress, (AddressRange)toRange);
            minAddress = minAddress.next();
        }
        map.put(maxAddress, (AddressRange)toRange);
    }
}

